/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class ValueOf
extends SimpleNodeConstructor {
    private int options;
    private boolean isNumberingInstruction = false;
    private boolean noNodeIfEmpty;

    public ValueOf(Expression select, boolean disable, boolean noNodeIfEmpty) {
        this.select = select;
        this.options = disable ? 1 : 0;
        this.noNodeIfEmpty = noNodeIfEmpty;
        this.adoptChildExpression(select);
        if (select instanceof StringLiteral) {
            boolean special = false;
            String val = ((StringLiteral)select).getStringValue();
            for (int k = 0; k < val.length(); ++k) {
                char c = val.charAt(k);
                if (c >= '!' && c <= '~' && c != '<' && c != '>' && c != '&') continue;
                special = true;
                break;
            }
            if (!special) {
                this.options |= 4;
            }
        }
    }

    public void setIsNumberingInstruction() {
        this.isNumberingInstruction = true;
    }

    public boolean isNumberingInstruction() {
        return this.isNumberingInstruction;
    }

    public boolean isNoNodeIfEmpty() {
        return this.noNodeIfEmpty;
    }

    public int getInstructionNameCode() {
        if (this.isNumberingInstruction) {
            return 180;
        }
        if (this.select instanceof StringLiteral) {
            return 201;
        }
        return 205;
    }

    public int getOptions() {
        return this.options;
    }

    public boolean isDisableOutputEscaping() {
        return (this.options & 1) != 0;
    }

    public ItemType getItemType() {
        return NodeKindTest.TEXT;
    }

    public int computeCardinality() {
        if (this.noNodeIfEmpty) {
            return 24576;
        }
        return 16384;
    }

    public int getIntrinsicDependencies() {
        int d = super.getIntrinsicDependencies();
        if (this.isDisableOutputEscaping()) {
            d |= 0x200;
        }
        return d;
    }

    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) {
    }

    public Expression copy() {
        ValueOf exp = new ValueOf(this.select.copy(), (this.options & 1) != 0, this.noNodeIfEmpty);
        if (this.isNumberingInstruction) {
            exp.setIsNumberingInstruction();
        }
        return exp;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (this.select instanceof Literal) {
            GroundedValue selectValue = ((Literal)this.select).getValue();
            SimpleType stype = null;
            if (parentType instanceof SimpleType && whole) {
                stype = (SimpleType)parentType;
            } else if (parentType instanceof ComplexType && ((ComplexType)parentType).isSimpleContent()) {
                stype = ((ComplexType)parentType).getSimpleContentType();
            }
            if (whole && stype != null && !stype.isNamespaceSensitive()) {
                ValidationFailure err = stype.validateContent(selectValue.getStringValue(), null, env.getConfiguration().getConversionRules());
                if (err != null) {
                    err.setLocator(this);
                    err.setErrorCode(this.isXSLT() ? "XTTE1540" : "XQDY0027");
                    throw err.makeException();
                }
                return;
            }
            if (parentType instanceof ComplexType && !((ComplexType)parentType).isSimpleContent() && !((ComplexType)parentType).isMixedContent() && !Whitespace.isWhite(selectValue.getStringValue())) {
                XPathException err = new XPathException("The containing element must be of type " + parentType.getDescription() + ", which does not allow text content " + Err.wrap(selectValue.getStringValue()));
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
        } else if (parentType instanceof ComplexType && !((ComplexType)parentType).isSimpleContent() && !((ComplexType)parentType).isMixedContent()) {
            env.issueWarning("The containing element must be of type " + parentType.getDescription() + ", which does not allow text content other than whitespace", this);
        }
    }

    public Expression convertToCastAsString() {
        if (this.noNodeIfEmpty || !Cardinality.allowsZero(this.select.getCardinality())) {
            return new CastExpression(this.select, BuiltInAtomicType.UNTYPED_ATOMIC, true);
        }
        StringFn sf = (StringFn)SystemFunctionCall.makeSystemFunction("string", new Expression[]{this.select});
        return new CastExpression(sf, BuiltInAtomicType.UNTYPED_ATOMIC, false);
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (this.noNodeIfEmpty) {
            StringValue value = (StringValue)this.select.evaluateItem(context);
            if (value != null) {
                this.processValue(value.getStringValueCS(), context);
            }
            return null;
        }
        return super.processLeavingTail(context);
    }

    public void processValue(CharSequence value, XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        out.characters(value, this.locationId, this.options);
    }

    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        try {
            CharSequence val;
            Item item = this.select.evaluateItem(context);
            if (item == null) {
                if (this.noNodeIfEmpty) {
                    return null;
                }
                val = "";
            } else {
                val = item.getStringValueCS();
            }
            Controller controller = context.getController();
            assert (controller != null);
            Orphan o = new Orphan(controller.getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(val);
            return o;
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("valueOf");
        this.getContentExpression().explain(out);
        out.endElement();
    }
}

