import pkg_resources
import pandas as pd


def load_companies():
    """Return a dataframe about the different insurance companies.

    Contains the following fields:
        ID              Id of the insurance company
        Company name    Name of the insurance company
        Price           Price of the company insurance service
    """

    stream = pkg_resources.resource_stream(__name__, 'data/insurance_companies.csv')
    return pd.read_csv(stream)


def get_company_info():
    return load_companies()
