from insurance_pkg import load_companies
from random import shuffle


def get_companies_array():
    companies_df = load_companies.get_company_info()
    return companies_df.values.tolist()


def get_insurance_order(type_ins, volume, count, hp, age):
    companies = get_companies_array()
    shuffle(companies)

    to_return = {'company_info': companies,
                 'other_info': {
                    'type_ins': type_ins,
                    'volume': volume,
                    'count': count,
                    'hp': hp,
                    'age': age
                    }
                 }

    print(to_return)
    return companies


res = get_insurance_order(2, 1, 1, 1, 2)
#res2 = get_insurance_order(1, 1, 1, 1, 1)

print(res)
#print(res2)
