# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import SignalRManagementClientConfiguration
from .operations import Operations
from .operations import SignalROperations
from .operations import SignalRPrivateEndpointConnectionsOperations
from .operations import SignalRPrivateLinkResourcesOperations
from .operations import UsagesOperations
from . import models


class SignalRManagementClient(SDKClient):
    """REST API for Azure SignalR Service

    :ivar config: Configuration for client.
    :vartype config: SignalRManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.signalr.operations.Operations
    :ivar signal_r: SignalR operations
    :vartype signal_r: azure.mgmt.signalr.operations.SignalROperations
    :ivar signal_rprivate_endpoint_connections: SignalRPrivateEndpointConnections operations
    :vartype signal_rprivate_endpoint_connections: azure.mgmt.signalr.operations.SignalRPrivateEndpointConnectionsOperations
    :ivar signal_rprivate_link_resources: SignalRPrivateLinkResources operations
    :vartype signal_rprivate_link_resources: azure.mgmt.signalr.operations.SignalRPrivateLinkResourcesOperations
    :ivar usages: Usages operations
    :vartype usages: azure.mgmt.signalr.operations.UsagesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Gets subscription Id which uniquely identify the
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = SignalRManagementClientConfiguration(credentials, subscription_id, base_url)
        super(SignalRManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2020-05-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.signal_r = SignalROperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.signal_rprivate_endpoint_connections = SignalRPrivateEndpointConnectionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.signal_rprivate_link_resources = SignalRPrivateLinkResourcesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.usages = UsagesOperations(
            self._client, self.config, self._serialize, self._deserialize)
