/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.Messages;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SecureUnmarshaller
implements Unmarshaller {
    private Unmarshaller delegate;
    boolean disableExternalEntities;
    boolean enableSecureProcessingFeature;
    boolean disableDTDs;

    public SecureUnmarshaller(Unmarshaller delegate, boolean disableExternalEntities, boolean enableSecureProcessingFeature, boolean disableDTDs) {
        this.delegate = delegate;
        this.disableExternalEntities = disableExternalEntities;
        this.enableSecureProcessingFeature = enableSecureProcessingFeature;
        this.disableDTDs = disableDTDs;
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.delegate.getAdapter(type);
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.delegate.getAttachmentUnmarshaller();
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.delegate.getEventHandler();
    }

    public Unmarshaller.Listener getListener() {
        return this.delegate.getListener();
    }

    public Object getProperty(String name) throws PropertyException {
        return this.delegate.getProperty(name);
    }

    public Schema getSchema() {
        return this.delegate.getSchema();
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.delegate.getUnmarshallerHandler();
    }

    @Deprecated
    public boolean isValidating() throws JAXBException {
        return this.delegate.isValidating();
    }

    public void setAdapter(XmlAdapter adapter) {
        this.delegate.setAdapter(adapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.delegate.setAdapter(adapter);
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller au) {
        this.delegate.setAttachmentUnmarshaller(au);
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.delegate.setEventHandler(handler);
    }

    public void setListener(Unmarshaller.Listener listener) {
        this.delegate.setListener(listener);
    }

    public void setProperty(String name, Object value) throws PropertyException {
        this.delegate.setProperty(name, value);
    }

    public void setSchema(Schema schema) {
        this.delegate.setSchema(schema);
    }

    @Deprecated
    public void setValidating(boolean validating) throws JAXBException {
        this.delegate.setValidating(validating);
    }

    public Object unmarshal(File f) throws JAXBException {
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("File"));
    }

    public Object unmarshal(InputStream is) throws JAXBException {
        return this.unmarshal(new InputSource(is));
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("Reader"));
    }

    public Object unmarshal(URL url) throws JAXBException {
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("URL"));
    }

    public Object unmarshal(InputSource source) throws JAXBException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            this.configureParserFactory(spf);
            SAXParser sp = spf.newSAXParser();
            this.configParser(sp);
            XMLReader xmlReader = sp.getXMLReader();
            final SAXSource saxSource = new SAXSource(xmlReader, source);
            if (System.getSecurityManager() == null) {
                return this.delegate.unmarshal((Source)saxSource);
            }
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JAXBException {
                    return SecureUnmarshaller.this.delegate.unmarshal((Source)saxSource);
                }
            });
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (PrivilegedActionException pae) {
            throw new JAXBException((Throwable)pae);
        }
    }

    public Object unmarshal(Node node) throws JAXBException {
        return this.delegate.unmarshal(node);
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (source instanceof SAXSource) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                this.configureParserFactory(spf);
                SAXParser sp = spf.newSAXParser();
                this.configParser(sp);
                XMLReader xmlReader = sp.getXMLReader();
                ((SAXSource)source).setXMLReader(xmlReader);
                return this.delegate.unmarshal(source);
            }
            catch (SAXException e) {
                throw new JAXBException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("Source, Class<T>"));
    }

    private void configParser(SAXParser sp) {
        try {
            if (!this.disableExternalEntities) {
                sp.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "all");
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Object unmarshal(XMLStreamReader reader) throws JAXBException {
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("XMLStreamReader"));
    }

    public Object unmarshal(XMLEventReader reader) throws JAXBException {
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("XMLEventReader"));
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> declaredType) throws JAXBException {
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("Node, Class<T>"));
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> declaredType) throws JAXBException {
        if (source instanceof SAXSource) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                this.configureParserFactory(spf);
                SAXParser sp = spf.newSAXParser();
                this.configParser(sp);
                XMLReader xmlReader = sp.getXMLReader();
                ((SAXSource)source).setXMLReader(xmlReader);
                return this.delegate.unmarshal(source, declaredType);
            }
            catch (SAXException e) {
                throw new JAXBException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("Source, Class<T>"));
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader reader, Class<T> declaredType) throws JAXBException {
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("XMLStreamReader, Class<T>"));
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader reader, Class<T> declaredType) throws JAXBException {
        throw new UnsupportedOperationException(Messages.MESSAGES.unexpectedUse("XMLEventReader, Class<T>"));
    }

    public Unmarshaller getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Unmarshaller delegate) {
        this.delegate = delegate;
    }

    protected void configureParserFactory(SAXParserFactory factory) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        factory.setFeature("http://xml.org/sax/features/validation", false);
        factory.setFeature("http://xml.org/sax/features/namespaces", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", !this.disableExternalEntities);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", !this.disableExternalEntities);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", this.enableSecureProcessingFeature);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", this.disableDTDs);
    }
}

