/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.SchedulerSpaceInterface;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedMethodResolver;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedPropertyAccessor;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedTypeLocator;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ModelValidatorContext {
    private final StandardEvaluationContext spelContext;
    private final Scheduler scheduler;
    private final SchedulerSpaceInterface space;
    private String variableName;
    private SpELVariables spELVariables;

    public ModelValidatorContext(StandardEvaluationContext context, Scheduler scheduler, SchedulerSpaceInterface space) {
        this.spelContext = context;
        this.scheduler = scheduler;
        this.space = space;
    }

    public ModelValidatorContext(Map<String, Serializable> variablesValues, Map<String, String> models, Scheduler scheduler, SchedulerSpaceInterface space) {
        this.spELVariables = new SpELVariables(variablesValues, models);
        this.spelContext = new StandardEvaluationContext((Object)this.spELVariables);
        this.spelContext.setTypeLocator((TypeLocator)new RestrictedTypeLocator());
        this.spelContext.setMethodResolvers(Collections.singletonList(new RestrictedMethodResolver()));
        this.spelContext.addPropertyAccessor((PropertyAccessor)new RestrictedPropertyAccessor());
        this.scheduler = scheduler;
        this.space = space;
    }

    public ModelValidatorContext(Task task, Scheduler scheduler, SchedulerSpaceInterface space) {
        this(task.getVariables().values().stream().collect(HashMap::new, (m, v) -> {
            Serializable cfr_ignored_0 = (Serializable)((Object)m.put(v.getName(), v.getValue()));
        }, HashMap::putAll), task.getVariables().values().stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), v.getModel()), HashMap::putAll), scheduler, space);
    }

    public ModelValidatorContext(TaskFlowJob job, Scheduler scheduler, SchedulerSpaceInterface space) {
        this(job.getVariables().values().stream().collect(HashMap::new, (m, v) -> {
            Serializable cfr_ignored_0 = (Serializable)((Object)m.put(v.getName(), v.getValue()));
        }, HashMap::putAll), job.getVariables().values().stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), v.getModel()), HashMap::putAll), scheduler, space);
    }

    public ModelValidatorContext(StandardEvaluationContext context) {
        this(context, null, null);
    }

    public ModelValidatorContext(Map<String, Serializable> variablesValues, Map<String, String> models) {
        this(variablesValues, models, null, null);
    }

    public ModelValidatorContext(Task task) {
        this(task, null, null);
    }

    public ModelValidatorContext(TaskFlowJob job) {
        this(job, null, null);
    }

    public StandardEvaluationContext getSpELContext() {
        return this.spelContext;
    }

    public SpELVariables getSpELVariables() {
        return this.spELVariables;
    }

    public void setSpELVariables(SpELVariables spELVariables) {
        this.spELVariables = spELVariables;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SchedulerSpaceInterface getSpace() {
        return this.space;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void updateJobWithContext(TaskFlowJob job) {
        for (JobVariable jobVariable : job.getVariables().values()) {
            jobVariable.setValue(this.spELVariables.getVariables().get(jobVariable.getName()).toString());
            jobVariable.setModel(this.spELVariables.getModels().get(jobVariable.getName()));
        }
    }

    public void updateTaskWithContext(Task task) {
        for (TaskVariable taskVariable : task.getVariables().values()) {
            taskVariable.setValue(this.spELVariables.getVariables().get(taskVariable.getName()).toString());
            taskVariable.setModel(this.spELVariables.getModels().get(taskVariable.getName()));
        }
    }

    public static class SpELVariables {
        private Map<String, Serializable> variables;
        private Map<String, String> models;
        private Object temp;
        private Map<String, Object> tempMap;
        private Boolean valid;

        public SpELVariables(Map<String, Serializable> variables, Map<String, String> models) {
            this.variables = variables;
            this.models = models;
            this.tempMap = new HashMap<String, Object>();
        }

        public static boolean t(Object expression) {
            return true;
        }

        public static boolean f(Object expression) {
            return false;
        }

        public static String s(Object expression) {
            return "";
        }

        public Map<String, Serializable> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Serializable> variables) {
            this.variables = variables;
        }

        public Map<String, String> getModels() {
            return this.models;
        }

        public void setModels(Map<String, String> models) {
            this.models = models;
        }

        public Object getTemp() {
            return this.temp;
        }

        public void setTemp(Object temp) {
            this.temp = temp;
        }

        public Map<String, Object> getTempMap() {
            return this.tempMap;
        }

        public void setTempMap(Map<String, Object> tempMap) {
            this.tempMap = tempMap;
        }

        public Boolean getValid() {
            return this.valid;
        }

        public void setValid(Boolean valid) {
            this.valid = valid;
        }
    }
}

