# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActiveDirectory(Model):
    """Active Directory.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param active_directory_id: Id of the Active Directory
    :type active_directory_id: str
    :param username: Username of Active Directory domain administrator
    :type username: str
    :param password: Plain text password of Active Directory domain
     administrator, value is masked in the response
    :type password: str
    :param domain: Name of the Active Directory domain
    :type domain: str
    :param dns: Comma separated list of DNS server IP addresses (IPv4 only)
     for the Active Directory domain
    :type dns: str
    :ivar status: Status of the Active Directory. Possible values include:
     'Created', 'InUse', 'Deleted', 'Error', 'Updating'
    :vartype status: str or ~azure.mgmt.netapp.models.ActiveDirectoryStatus
    :ivar status_details: Any details in regards to the Status of the Active
     Directory
    :vartype status_details: str
    :param smb_server_name: NetBIOS name of the SMB server. This name will be
     registered as a computer account in the AD and used to mount volumes
    :type smb_server_name: str
    :param organizational_unit: The Organizational Unit (OU) within the
     Windows Active Directory
    :type organizational_unit: str
    :param site: The Active Directory site the service will limit Domain
     Controller discovery to
    :type site: str
    :param backup_operators: Users to be added to the Built-in Backup Operator
     active directory group. A list of unique usernames without domain
     specifier
    :type backup_operators: list[str]
    :param kdc_ip: kdc server IP addresses for the active directory machine.
     This optional parameter is used only while creating kerberos volume.
    :type kdc_ip: str
    :param ad_name: Name of the active directory machine. This optional
     parameter is used only while creating kerberos volume
    :type ad_name: str
    :param server_root_ca_certificate: When LDAP over SSL/TLS is enabled, the
     LDAP client is required to have base64 encoded Active Directory
     Certificate Service's self-signed root CA certificate, this optional
     parameter is used only for dual protocol with LDAP user-mapping volumes.
    :type server_root_ca_certificate: str
    :param aes_encryption: If enabled, AES encryption will be enabled for SMB
     communication.
    :type aes_encryption: bool
    :param ldap_signing: Specifies whether or not the LDAP traffic needs to be
     signed.
    :type ldap_signing: bool
    :param security_operators: Domain Users in the Active directory to be
     given SeSecurityPrivilege privilege (Needed for SMB Continuously available
     shares for SQL). A list of unique usernames without domain specifier
    :type security_operators: list[str]
    """

    _validation = {
        'dns': {'pattern': r'^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)((, ?)(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))*$'},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'kdc_ip': {'pattern': r'^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)((, ?)(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))*$'},
        'ad_name': {'max_length': 64, 'min_length': 1},
        'server_root_ca_certificate': {'max_length': 10240, 'min_length': 1},
    }

    _attribute_map = {
        'active_directory_id': {'key': 'activeDirectoryId', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'dns': {'key': 'dns', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'smb_server_name': {'key': 'smbServerName', 'type': 'str'},
        'organizational_unit': {'key': 'organizationalUnit', 'type': 'str'},
        'site': {'key': 'site', 'type': 'str'},
        'backup_operators': {'key': 'backupOperators', 'type': '[str]'},
        'kdc_ip': {'key': 'kdcIP', 'type': 'str'},
        'ad_name': {'key': 'adName', 'type': 'str'},
        'server_root_ca_certificate': {'key': 'serverRootCACertificate', 'type': 'str'},
        'aes_encryption': {'key': 'aesEncryption', 'type': 'bool'},
        'ldap_signing': {'key': 'ldapSigning', 'type': 'bool'},
        'security_operators': {'key': 'securityOperators', 'type': '[str]'},
    }

    def __init__(self, *, active_directory_id: str=None, username: str=None, password: str=None, domain: str=None, dns: str=None, smb_server_name: str=None, organizational_unit: str=None, site: str=None, backup_operators=None, kdc_ip: str=None, ad_name: str=None, server_root_ca_certificate: str=None, aes_encryption: bool=None, ldap_signing: bool=None, security_operators=None, **kwargs) -> None:
        super(ActiveDirectory, self).__init__(**kwargs)
        self.active_directory_id = active_directory_id
        self.username = username
        self.password = password
        self.domain = domain
        self.dns = dns
        self.status = None
        self.status_details = None
        self.smb_server_name = smb_server_name
        self.organizational_unit = organizational_unit
        self.site = site
        self.backup_operators = backup_operators
        self.kdc_ip = kdc_ip
        self.ad_name = ad_name
        self.server_root_ca_certificate = server_root_ca_certificate
        self.aes_encryption = aes_encryption
        self.ldap_signing = ldap_signing
        self.security_operators = security_operators


class AuthorizeRequest(Model):
    """Authorize request.

    :param remote_volume_resource_id: Resource id of the remote volume
    :type remote_volume_resource_id: str
    """

    _attribute_map = {
        'remote_volume_resource_id': {'key': 'remoteVolumeResourceId', 'type': 'str'},
    }

    def __init__(self, *, remote_volume_resource_id: str=None, **kwargs) -> None:
        super(AuthorizeRequest, self).__init__(**kwargs)
        self.remote_volume_resource_id = remote_volume_resource_id


class Backup(Model):
    """Backup of a Volume.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar backup_id: backupId. UUID v4 used to identify the Backup
    :vartype backup_id: str
    :ivar creation_date: name. The creation date of the backup
    :vartype creation_date: datetime
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    :ivar size: Size of backup
    :vartype size: long
    :param label: Label for backup
    :type label: str
    :ivar backup_type: Type of backup adhoc or scheduled
    :vartype backup_type: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'size': {'readonly': True},
        'backup_type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'label': {'key': 'properties.label', 'type': 'str'},
        'backup_type': {'key': 'properties.backupType', 'type': 'str'},
    }

    def __init__(self, *, location: str, label: str=None, **kwargs) -> None:
        super(Backup, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.backup_id = None
        self.creation_date = None
        self.provisioning_state = None
        self.size = None
        self.label = label
        self.backup_type = None


class BackupPatch(Model):
    """Backup patch.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar backup_id: backupId. UUID v4 used to identify the Backup
    :vartype backup_id: str
    :ivar creation_date: name. The creation date of the backup
    :vartype creation_date: datetime
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    :ivar size: Size of backup
    :vartype size: long
    :param label: Label for backup
    :type label: str
    :ivar backup_type: Type of backup adhoc or scheduled
    :vartype backup_type: str
    """

    _validation = {
        'backup_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'size': {'readonly': True},
        'backup_type': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'label': {'key': 'properties.label', 'type': 'str'},
        'backup_type': {'key': 'properties.backupType', 'type': 'str'},
    }

    def __init__(self, *, tags=None, label: str=None, **kwargs) -> None:
        super(BackupPatch, self).__init__(**kwargs)
        self.tags = tags
        self.backup_id = None
        self.creation_date = None
        self.provisioning_state = None
        self.size = None
        self.label = label
        self.backup_type = None


class BackupPolicy(Model):
    """Backup policy information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar name1: Name of backup policy
    :vartype name1: str
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    :param daily_backups_to_keep: Daily backups count to keep
    :type daily_backups_to_keep: int
    :param weekly_backups_to_keep: Weekly backups count to keep
    :type weekly_backups_to_keep: int
    :param monthly_backups_to_keep: Monthly backups count to keep
    :type monthly_backups_to_keep: int
    :param yearly_backups_to_keep: Yearly backups count to keep
    :type yearly_backups_to_keep: int
    :param volumes_assigned: Volumes using current backup policy
    :type volumes_assigned: int
    :param enabled: The property to decide policy is enabled or not
    :type enabled: bool
    :param volume_backups: A list of volumes assigned to this policy
    :type volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name1': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name1': {'key': 'properties.name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'daily_backups_to_keep': {'key': 'properties.dailyBackupsToKeep', 'type': 'int'},
        'weekly_backups_to_keep': {'key': 'properties.weeklyBackupsToKeep', 'type': 'int'},
        'monthly_backups_to_keep': {'key': 'properties.monthlyBackupsToKeep', 'type': 'int'},
        'yearly_backups_to_keep': {'key': 'properties.yearlyBackupsToKeep', 'type': 'int'},
        'volumes_assigned': {'key': 'properties.volumesAssigned', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'volume_backups': {'key': 'properties.volumeBackups', 'type': '[VolumeBackups]'},
    }

    def __init__(self, *, location: str, tags=None, daily_backups_to_keep: int=None, weekly_backups_to_keep: int=None, monthly_backups_to_keep: int=None, yearly_backups_to_keep: int=None, volumes_assigned: int=None, enabled: bool=None, volume_backups=None, **kwargs) -> None:
        super(BackupPolicy, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.name1 = None
        self.provisioning_state = None
        self.daily_backups_to_keep = daily_backups_to_keep
        self.weekly_backups_to_keep = weekly_backups_to_keep
        self.monthly_backups_to_keep = monthly_backups_to_keep
        self.yearly_backups_to_keep = yearly_backups_to_keep
        self.volumes_assigned = volumes_assigned
        self.enabled = enabled
        self.volume_backups = volume_backups


class BackupPolicyDetails(Model):
    """Backup policy properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar name1: Name of backup policy
    :vartype name1: str
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    :param daily_backups_to_keep: Daily backups count to keep
    :type daily_backups_to_keep: int
    :param weekly_backups_to_keep: Weekly backups count to keep
    :type weekly_backups_to_keep: int
    :param monthly_backups_to_keep: Monthly backups count to keep
    :type monthly_backups_to_keep: int
    :param yearly_backups_to_keep: Yearly backups count to keep
    :type yearly_backups_to_keep: int
    :param volumes_assigned: Volumes using current backup policy
    :type volumes_assigned: int
    :param enabled: The property to decide policy is enabled or not
    :type enabled: bool
    :param volume_backups: A list of volumes assigned to this policy
    :type volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name1': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name1': {'key': 'properties.name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'daily_backups_to_keep': {'key': 'properties.dailyBackupsToKeep', 'type': 'int'},
        'weekly_backups_to_keep': {'key': 'properties.weeklyBackupsToKeep', 'type': 'int'},
        'monthly_backups_to_keep': {'key': 'properties.monthlyBackupsToKeep', 'type': 'int'},
        'yearly_backups_to_keep': {'key': 'properties.yearlyBackupsToKeep', 'type': 'int'},
        'volumes_assigned': {'key': 'properties.volumesAssigned', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'volume_backups': {'key': 'properties.volumeBackups', 'type': '[VolumeBackups]'},
    }

    def __init__(self, *, location: str=None, tags=None, daily_backups_to_keep: int=None, weekly_backups_to_keep: int=None, monthly_backups_to_keep: int=None, yearly_backups_to_keep: int=None, volumes_assigned: int=None, enabled: bool=None, volume_backups=None, **kwargs) -> None:
        super(BackupPolicyDetails, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.name1 = None
        self.provisioning_state = None
        self.daily_backups_to_keep = daily_backups_to_keep
        self.weekly_backups_to_keep = weekly_backups_to_keep
        self.monthly_backups_to_keep = monthly_backups_to_keep
        self.yearly_backups_to_keep = yearly_backups_to_keep
        self.volumes_assigned = volumes_assigned
        self.enabled = enabled
        self.volume_backups = volume_backups


class BackupPolicyPatch(Model):
    """Backup policy Details for create and update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar name1: Name of backup policy
    :vartype name1: str
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    :param daily_backups_to_keep: Daily backups count to keep
    :type daily_backups_to_keep: int
    :param weekly_backups_to_keep: Weekly backups count to keep
    :type weekly_backups_to_keep: int
    :param monthly_backups_to_keep: Monthly backups count to keep
    :type monthly_backups_to_keep: int
    :param yearly_backups_to_keep: Yearly backups count to keep
    :type yearly_backups_to_keep: int
    :param volumes_assigned: Volumes using current backup policy
    :type volumes_assigned: int
    :param enabled: The property to decide policy is enabled or not
    :type enabled: bool
    :param volume_backups: A list of volumes assigned to this policy
    :type volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name1': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name1': {'key': 'properties.name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'daily_backups_to_keep': {'key': 'properties.dailyBackupsToKeep', 'type': 'int'},
        'weekly_backups_to_keep': {'key': 'properties.weeklyBackupsToKeep', 'type': 'int'},
        'monthly_backups_to_keep': {'key': 'properties.monthlyBackupsToKeep', 'type': 'int'},
        'yearly_backups_to_keep': {'key': 'properties.yearlyBackupsToKeep', 'type': 'int'},
        'volumes_assigned': {'key': 'properties.volumesAssigned', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'volume_backups': {'key': 'properties.volumeBackups', 'type': '[VolumeBackups]'},
    }

    def __init__(self, *, location: str=None, tags=None, daily_backups_to_keep: int=None, weekly_backups_to_keep: int=None, monthly_backups_to_keep: int=None, yearly_backups_to_keep: int=None, volumes_assigned: int=None, enabled: bool=None, volume_backups=None, **kwargs) -> None:
        super(BackupPolicyPatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.name1 = None
        self.provisioning_state = None
        self.daily_backups_to_keep = daily_backups_to_keep
        self.weekly_backups_to_keep = weekly_backups_to_keep
        self.monthly_backups_to_keep = monthly_backups_to_keep
        self.yearly_backups_to_keep = yearly_backups_to_keep
        self.volumes_assigned = volumes_assigned
        self.enabled = enabled
        self.volume_backups = volume_backups


class BackupsList(Model):
    """List of Backups.

    :param value: A list of Backups
    :type value: list[~azure.mgmt.netapp.models.Backup]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Backup]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(BackupsList, self).__init__(**kwargs)
        self.value = value


class BreakReplicationRequest(Model):
    """Break replication request.

    :param force_break_replication: If replication is in status transferring
     and you want to force break the replication, set to true
    :type force_break_replication: bool
    """

    _attribute_map = {
        'force_break_replication': {'key': 'forceBreakReplication', 'type': 'bool'},
    }

    def __init__(self, *, force_break_replication: bool=None, **kwargs) -> None:
        super(BreakReplicationRequest, self).__init__(**kwargs)
        self.force_break_replication = force_break_replication


class CapacityPool(Model):
    """Capacity pool resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar pool_id: poolId. UUID v4 used to identify the Pool
    :vartype pool_id: str
    :param size: Required. size. Provisioned size of the pool (in bytes).
     Allowed values are in 4TiB chunks (value must be multiply of
     4398046511104).
    :type size: long
    :param service_level: Required. serviceLevel. The service level of the
     file system. Possible values include: 'Standard', 'Premium', 'Ultra'.
     Default value: "Premium" .
    :type service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    :ivar total_throughput_mibps: Total throughput of pool in Mibps
    :vartype total_throughput_mibps: float
    :ivar utilized_throughput_mibps: Utilized throughput of pool in Mibps
    :vartype utilized_throughput_mibps: float
    :param qos_type: qosType. The qos type of the pool. Possible values
     include: 'Auto', 'Manual'. Default value: "Auto" .
    :type qos_type: str or ~azure.mgmt.netapp.models.QosType
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'pool_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'size': {'required': True, 'maximum': 549755813888000, 'minimum': 4398046511104},
        'service_level': {'required': True},
        'provisioning_state': {'readonly': True},
        'total_throughput_mibps': {'readonly': True},
        'utilized_throughput_mibps': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'pool_id': {'key': 'properties.poolId', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'total_throughput_mibps': {'key': 'properties.totalThroughputMibps', 'type': 'float'},
        'utilized_throughput_mibps': {'key': 'properties.utilizedThroughputMibps', 'type': 'float'},
        'qos_type': {'key': 'properties.qosType', 'type': 'str'},
    }

    def __init__(self, *, location: str, size: int, tags=None, service_level="Premium", qos_type="Auto", **kwargs) -> None:
        super(CapacityPool, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.pool_id = None
        self.size = size
        self.service_level = service_level
        self.provisioning_state = None
        self.total_throughput_mibps = None
        self.utilized_throughput_mibps = None
        self.qos_type = qos_type


class CapacityPoolPatch(Model):
    """Capacity pool patch resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param size: size. Provisioned size of the pool (in bytes). Allowed values
     are in 4TiB chunks (value must be multiply of 4398046511104). Default
     value: 4398046511104 .
    :type size: long
    :param qos_type: qosType. The qos type of the pool. Possible values
     include: 'Auto', 'Manual'. Default value: "Auto" .
    :type qos_type: str or ~azure.mgmt.netapp.models.QosType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'size': {'maximum': 549755813888000, 'minimum': 4398046511104},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'qos_type': {'key': 'properties.qosType', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, size: int=4398046511104, qos_type="Auto", **kwargs) -> None:
        super(CapacityPoolPatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.size = size
        self.qos_type = qos_type


class CheckAvailabilityResponse(Model):
    """Information regarding availability of a resource.

    :param is_available: <code>true</code> indicates name is valid and
     available. <code>false</code> indicates the name is invalid, unavailable,
     or both.
    :type is_available: bool
    :param reason: <code>Invalid</code> indicates the name provided does not
     match Azure App Service naming requirements. <code>AlreadyExists</code>
     indicates that the name is already in use and is therefore unavailable.
     Possible values include: 'Invalid', 'AlreadyExists'
    :type reason: str or ~azure.mgmt.netapp.models.InAvailabilityReasonType
    :param message: If reason == invalid, provide the user with the reason why
     the given name is invalid, and provide the resource naming requirements so
     that the user can select a valid name. If reason == AlreadyExists, explain
     that resource name is already in use, and direct them to select a
     different name.
    :type message: str
    """

    _attribute_map = {
        'is_available': {'key': 'isAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, is_available: bool=None, reason=None, message: str=None, **kwargs) -> None:
        super(CheckAvailabilityResponse, self).__init__(**kwargs)
        self.is_available = is_available
        self.reason = reason
        self.message = message


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class DailySchedule(Model):
    """Daily Schedule properties.

    :param snapshots_to_keep: Daily snapshot count to keep
    :type snapshots_to_keep: int
    :param hour: Indicates which hour in UTC timezone a snapshot should be
     taken
    :type hour: int
    :param minute: Indicates which minute snapshot should be taken
    :type minute: int
    :param used_bytes: Resource size in bytes, current storage usage for the
     volume in bytes
    :type used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(self, *, snapshots_to_keep: int=None, hour: int=None, minute: int=None, used_bytes: int=None, **kwargs) -> None:
        super(DailySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = snapshots_to_keep
        self.hour = hour
        self.minute = minute
        self.used_bytes = used_bytes


class Dimension(Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :param name: Display name of dimension.
    :type name: str
    :param display_name: Display name of dimension.
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, **kwargs) -> None:
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class ExportPolicyRule(Model):
    """Volume Export Policy Rule.

    :param rule_index: Order index
    :type rule_index: int
    :param unix_read_only: Read only access
    :type unix_read_only: bool
    :param unix_read_write: Read and write access
    :type unix_read_write: bool
    :param kerberos5_read_only: Kerberos5 Read only access. To be use with
     swagger version 2020-05-01 or later. Default value: False .
    :type kerberos5_read_only: bool
    :param kerberos5_read_write: Kerberos5 Read and write access. To be use
     with swagger version 2020-05-01 or later. Default value: False .
    :type kerberos5_read_write: bool
    :param kerberos5i_read_only: Kerberos5i Read only access. To be use with
     swagger version 2020-05-01 or later. Default value: False .
    :type kerberos5i_read_only: bool
    :param kerberos5i_read_write: Kerberos5i Read and write access. To be use
     with swagger version 2020-05-01 or later. Default value: False .
    :type kerberos5i_read_write: bool
    :param kerberos5p_read_only: Kerberos5p Read only access. To be use with
     swagger version 2020-05-01 or later. Default value: False .
    :type kerberos5p_read_only: bool
    :param kerberos5p_read_write: Kerberos5p Read and write access. To be use
     with swagger version 2020-05-01 or later. Default value: False .
    :type kerberos5p_read_write: bool
    :param cifs: Allows CIFS protocol
    :type cifs: bool
    :param nfsv3: Allows NFSv3 protocol. Enable only for NFSv3 type volumes
    :type nfsv3: bool
    :param nfsv41: Allows NFSv4.1 protocol. Enable only for NFSv4.1 type
     volumes
    :type nfsv41: bool
    :param allowed_clients: Client ingress specification as comma separated
     string with IPv4 CIDRs, IPv4 host addresses and host names
    :type allowed_clients: str
    :param has_root_access: Has root access to volume. Default value: True .
    :type has_root_access: bool
    """

    _attribute_map = {
        'rule_index': {'key': 'ruleIndex', 'type': 'int'},
        'unix_read_only': {'key': 'unixReadOnly', 'type': 'bool'},
        'unix_read_write': {'key': 'unixReadWrite', 'type': 'bool'},
        'kerberos5_read_only': {'key': 'kerberos5ReadOnly', 'type': 'bool'},
        'kerberos5_read_write': {'key': 'kerberos5ReadWrite', 'type': 'bool'},
        'kerberos5i_read_only': {'key': 'kerberos5iReadOnly', 'type': 'bool'},
        'kerberos5i_read_write': {'key': 'kerberos5iReadWrite', 'type': 'bool'},
        'kerberos5p_read_only': {'key': 'kerberos5pReadOnly', 'type': 'bool'},
        'kerberos5p_read_write': {'key': 'kerberos5pReadWrite', 'type': 'bool'},
        'cifs': {'key': 'cifs', 'type': 'bool'},
        'nfsv3': {'key': 'nfsv3', 'type': 'bool'},
        'nfsv41': {'key': 'nfsv41', 'type': 'bool'},
        'allowed_clients': {'key': 'allowedClients', 'type': 'str'},
        'has_root_access': {'key': 'hasRootAccess', 'type': 'bool'},
    }

    def __init__(self, *, rule_index: int=None, unix_read_only: bool=None, unix_read_write: bool=None, kerberos5_read_only: bool=False, kerberos5_read_write: bool=False, kerberos5i_read_only: bool=False, kerberos5i_read_write: bool=False, kerberos5p_read_only: bool=False, kerberos5p_read_write: bool=False, cifs: bool=None, nfsv3: bool=None, nfsv41: bool=None, allowed_clients: str=None, has_root_access: bool=True, **kwargs) -> None:
        super(ExportPolicyRule, self).__init__(**kwargs)
        self.rule_index = rule_index
        self.unix_read_only = unix_read_only
        self.unix_read_write = unix_read_write
        self.kerberos5_read_only = kerberos5_read_only
        self.kerberos5_read_write = kerberos5_read_write
        self.kerberos5i_read_only = kerberos5i_read_only
        self.kerberos5i_read_write = kerberos5i_read_write
        self.kerberos5p_read_only = kerberos5p_read_only
        self.kerberos5p_read_write = kerberos5p_read_write
        self.cifs = cifs
        self.nfsv3 = nfsv3
        self.nfsv41 = nfsv41
        self.allowed_clients = allowed_clients
        self.has_root_access = has_root_access


class HourlySchedule(Model):
    """Hourly Schedule properties.

    :param snapshots_to_keep: Hourly snapshot count to keep
    :type snapshots_to_keep: int
    :param minute: Indicates which minute snapshot should be taken
    :type minute: int
    :param used_bytes: Resource size in bytes, current storage usage for the
     volume in bytes
    :type used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(self, *, snapshots_to_keep: int=None, minute: int=None, used_bytes: int=None, **kwargs) -> None:
        super(HourlySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = snapshots_to_keep
        self.minute = minute
        self.used_bytes = used_bytes


class MetricSpecification(Model):
    """Metric specification of operation.

    :param name: Name of metric specification.
    :type name: str
    :param display_name: Display name of metric specification.
    :type display_name: str
    :param display_description: Display description of metric specification.
    :type display_description: str
    :param unit: Unit could be Bytes or Count.
    :type unit: str
    :param dimensions: Dimensions of blobs, including blob type and access
     tier.
    :type dimensions: list[~azure.mgmt.netapp.models.Dimension]
    :param aggregation_type: Aggregation type could be Average.
    :type aggregation_type: str
    :param fill_gap_with_zero: The property to decide fill gap with zero or
     not.
    :type fill_gap_with_zero: bool
    :param category: The category this metric specification belong to, could
     be Capacity.
    :type category: str
    :param resource_id_dimension_name_override: Account Resource Id.
    :type resource_id_dimension_name_override: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, display_description: str=None, unit: str=None, dimensions=None, aggregation_type: str=None, fill_gap_with_zero: bool=None, category: str=None, resource_id_dimension_name_override: str=None, **kwargs) -> None:
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.dimensions = dimensions
        self.aggregation_type = aggregation_type
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override


class MonthlySchedule(Model):
    """Monthly Schedule properties.

    :param snapshots_to_keep: Monthly snapshot count to keep
    :type snapshots_to_keep: int
    :param days_of_month: Indicates which days of the month snapshot should be
     taken. A comma delimited string.
    :type days_of_month: str
    :param hour: Indicates which hour in UTC timezone a snapshot should be
     taken
    :type hour: int
    :param minute: Indicates which minute snapshot should be taken
    :type minute: int
    :param used_bytes: Resource size in bytes, current storage usage for the
     volume in bytes
    :type used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'days_of_month': {'key': 'daysOfMonth', 'type': 'str'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(self, *, snapshots_to_keep: int=None, days_of_month: str=None, hour: int=None, minute: int=None, used_bytes: int=None, **kwargs) -> None:
        super(MonthlySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = snapshots_to_keep
        self.days_of_month = days_of_month
        self.hour = hour
        self.minute = minute
        self.used_bytes = used_bytes


class MountTarget(Model):
    """Mount Target.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar mount_target_id: mountTargetId. UUID v4 used to identify the
     MountTarget
    :vartype mount_target_id: str
    :param file_system_id: Required. fileSystemId. UUID v4 used to identify
     the MountTarget
    :type file_system_id: str
    :ivar ip_address: ipAddress. The mount target's IPv4 address
    :vartype ip_address: str
    :param smb_server_fqdn: smbServerFQDN. The SMB server's Fully Qualified
     Domain Name, FQDN
    :type smb_server_fqdn: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'mount_target_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'file_system_id': {'required': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'ip_address': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'mount_target_id': {'key': 'properties.mountTargetId', 'type': 'str'},
        'file_system_id': {'key': 'properties.fileSystemId', 'type': 'str'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'smb_server_fqdn': {'key': 'properties.smbServerFqdn', 'type': 'str'},
    }

    def __init__(self, *, location: str, file_system_id: str, tags=None, smb_server_fqdn: str=None, **kwargs) -> None:
        super(MountTarget, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.mount_target_id = None
        self.file_system_id = file_system_id
        self.ip_address = None
        self.smb_server_fqdn = smb_server_fqdn


class MountTargetProperties(Model):
    """Mount target properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar mount_target_id: mountTargetId. UUID v4 used to identify the
     MountTarget
    :vartype mount_target_id: str
    :param file_system_id: Required. fileSystemId. UUID v4 used to identify
     the MountTarget
    :type file_system_id: str
    :ivar ip_address: ipAddress. The mount target's IPv4 address
    :vartype ip_address: str
    :param smb_server_fqdn: smbServerFQDN. The SMB server's Fully Qualified
     Domain Name, FQDN
    :type smb_server_fqdn: str
    """

    _validation = {
        'mount_target_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'file_system_id': {'required': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'ip_address': {'readonly': True},
    }

    _attribute_map = {
        'mount_target_id': {'key': 'mountTargetId', 'type': 'str'},
        'file_system_id': {'key': 'fileSystemId', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'smb_server_fqdn': {'key': 'smbServerFqdn', 'type': 'str'},
    }

    def __init__(self, *, file_system_id: str, smb_server_fqdn: str=None, **kwargs) -> None:
        super(MountTargetProperties, self).__init__(**kwargs)
        self.mount_target_id = None
        self.file_system_id = file_system_id
        self.ip_address = None
        self.smb_server_fqdn = smb_server_fqdn


class NetAppAccount(Model):
    """NetApp account resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    :param active_directories: Active Directories
    :type active_directories: list[~azure.mgmt.netapp.models.ActiveDirectory]
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'active_directories': {'key': 'properties.activeDirectories', 'type': '[ActiveDirectory]'},
    }

    def __init__(self, *, location: str, tags=None, active_directories=None, **kwargs) -> None:
        super(NetAppAccount, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.provisioning_state = None
        self.active_directories = active_directories


class NetAppAccountPatch(Model):
    """NetApp account patch resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    :param active_directories: Active Directories
    :type active_directories: list[~azure.mgmt.netapp.models.ActiveDirectory]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'active_directories': {'key': 'properties.activeDirectories', 'type': '[ActiveDirectory]'},
    }

    def __init__(self, *, location: str=None, tags=None, active_directories=None, **kwargs) -> None:
        super(NetAppAccountPatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.provisioning_state = None
        self.active_directories = active_directories


class Operation(Model):
    """Microsoft.NetApp REST API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.netapp.models.OperationDisplay
    :param origin: The origin of operations.
    :type origin: str
    :param service_specification: One property of operation, include metric
     specifications.
    :type service_specification:
     ~azure.mgmt.netapp.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, service_specification=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft NetApp.
    :type provider: str
    :param resource: Resource on which the operation is performed etc.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class PoolChangeRequest(Model):
    """Pool change request.

    All required parameters must be populated in order to send to Azure.

    :param new_pool_resource_id: Required. Resource id of the pool to move
     volume to
    :type new_pool_resource_id: str
    """

    _validation = {
        'new_pool_resource_id': {'required': True},
    }

    _attribute_map = {
        'new_pool_resource_id': {'key': 'newPoolResourceId', 'type': 'str'},
    }

    def __init__(self, *, new_pool_resource_id: str, **kwargs) -> None:
        super(PoolChangeRequest, self).__init__(**kwargs)
        self.new_pool_resource_id = new_pool_resource_id


class QuotaAvailabilityRequest(Model):
    """Quota availability request content.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the resource to verify.
    :type name: str
    :param type: Required. Resource type used for verification. Possible
     values include: 'Microsoft.NetApp/netAppAccounts',
     'Microsoft.NetApp/netAppAccounts/capacityPools',
     'Microsoft.NetApp/netAppAccounts/capacityPools/volumes',
     'Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots'
    :type type: str or ~azure.mgmt.netapp.models.CheckQuotaNameResourceTypes
    :param resource_group: Required. Resource group name.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'resource_group': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(self, *, name: str, type, resource_group: str, **kwargs) -> None:
        super(QuotaAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.resource_group = resource_group


class ReplicationObject(Model):
    """Replication properties.

    All required parameters must be populated in order to send to Azure.

    :param replication_id: Id
    :type replication_id: str
    :param endpoint_type: Indicates whether the local volume is the source or
     destination for the Volume Replication. Possible values include: 'src',
     'dst'
    :type endpoint_type: str or ~azure.mgmt.netapp.models.EndpointType
    :param replication_schedule: Required. Schedule. Possible values include:
     '_10minutely', 'hourly', 'daily'
    :type replication_schedule: str or
     ~azure.mgmt.netapp.models.ReplicationSchedule
    :param remote_volume_resource_id: Required. The resource ID of the remote
     volume.
    :type remote_volume_resource_id: str
    :param remote_volume_region: The remote region for the other end of the
     Volume Replication.
    :type remote_volume_region: str
    """

    _validation = {
        'replication_schedule': {'required': True},
        'remote_volume_resource_id': {'required': True},
    }

    _attribute_map = {
        'replication_id': {'key': 'replicationId', 'type': 'str'},
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'replication_schedule': {'key': 'replicationSchedule', 'type': 'str'},
        'remote_volume_resource_id': {'key': 'remoteVolumeResourceId', 'type': 'str'},
        'remote_volume_region': {'key': 'remoteVolumeRegion', 'type': 'str'},
    }

    def __init__(self, *, replication_schedule, remote_volume_resource_id: str, replication_id: str=None, endpoint_type=None, remote_volume_region: str=None, **kwargs) -> None:
        super(ReplicationObject, self).__init__(**kwargs)
        self.replication_id = replication_id
        self.endpoint_type = endpoint_type
        self.replication_schedule = replication_schedule
        self.remote_volume_resource_id = remote_volume_resource_id
        self.remote_volume_region = remote_volume_region


class ReplicationStatus(Model):
    """Replication status.

    :param healthy: Replication health check
    :type healthy: bool
    :param relationship_status: Status of the mirror relationship. Possible
     values include: 'Idle', 'Transferring'
    :type relationship_status: str or
     ~azure.mgmt.netapp.models.RelationshipStatus
    :param mirror_state: The status of the replication. Possible values
     include: 'Uninitialized', 'Mirrored', 'Broken'
    :type mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
    :param total_progress: The progress of the replication
    :type total_progress: str
    :param error_message: Displays error message if the replication is in an
     error state
    :type error_message: str
    """

    _attribute_map = {
        'healthy': {'key': 'healthy', 'type': 'bool'},
        'relationship_status': {'key': 'relationshipStatus', 'type': 'str'},
        'mirror_state': {'key': 'mirrorState', 'type': 'str'},
        'total_progress': {'key': 'totalProgress', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(self, *, healthy: bool=None, relationship_status=None, mirror_state=None, total_progress: str=None, error_message: str=None, **kwargs) -> None:
        super(ReplicationStatus, self).__init__(**kwargs)
        self.healthy = healthy
        self.relationship_status = relationship_status
        self.mirror_state = mirror_state
        self.total_progress = total_progress
        self.error_message = error_message


class ResourceNameAvailabilityRequest(Model):
    """Resource name availability request content.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Required. Resource type used for verification. Possible
     values include: 'Microsoft.NetApp/netAppAccounts',
     'Microsoft.NetApp/netAppAccounts/capacityPools',
     'Microsoft.NetApp/netAppAccounts/capacityPools/volumes',
     'Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots'
    :type type: str or ~azure.mgmt.netapp.models.CheckNameResourceTypes
    :param resource_group: Required. Resource group name.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'resource_group': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(self, *, name: str, type, resource_group: str, **kwargs) -> None:
        super(ResourceNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.resource_group = resource_group


class ServiceSpecification(Model):
    """One property of operation, include metric specifications.

    :param metric_specifications: Metric specifications of operation.
    :type metric_specifications:
     list[~azure.mgmt.netapp.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(self, *, metric_specifications=None, **kwargs) -> None:
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Snapshot(Model):
    """Snapshot of a Volume.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar snapshot_id: snapshotId. UUID v4 used to identify the Snapshot
    :vartype snapshot_id: str
    :ivar created: name. The creation date of the snapshot
    :vartype created: datetime
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'snapshot_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'created': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, location: str, **kwargs) -> None:
        super(Snapshot, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.snapshot_id = None
        self.created = None
        self.provisioning_state = None


class SnapshotPolicy(Model):
    """Snapshot policy information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar name1: Snapshot policy name
    :vartype name1: str
    :param hourly_schedule: hourlySchedule. Schedule for hourly snapshots
    :type hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :param daily_schedule: dailySchedule. Schedule for daily snapshots
    :type daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :param weekly_schedule: weeklySchedule. Schedule for weekly snapshots
    :type weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :param monthly_schedule: monthlySchedule. Schedule for monthly snapshots
    :type monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :param enabled: The property to decide policy is enabled or not
    :type enabled: bool
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name1': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name1': {'key': 'properties.name', 'type': 'str'},
        'hourly_schedule': {'key': 'properties.hourlySchedule', 'type': 'HourlySchedule'},
        'daily_schedule': {'key': 'properties.dailySchedule', 'type': 'DailySchedule'},
        'weekly_schedule': {'key': 'properties.weeklySchedule', 'type': 'WeeklySchedule'},
        'monthly_schedule': {'key': 'properties.monthlySchedule', 'type': 'MonthlySchedule'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, hourly_schedule=None, daily_schedule=None, weekly_schedule=None, monthly_schedule=None, enabled: bool=None, **kwargs) -> None:
        super(SnapshotPolicy, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.name1 = None
        self.hourly_schedule = hourly_schedule
        self.daily_schedule = daily_schedule
        self.weekly_schedule = weekly_schedule
        self.monthly_schedule = monthly_schedule
        self.enabled = enabled
        self.provisioning_state = None


class SnapshotPolicyDetails(Model):
    """Snapshot policy properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar name1: Snapshot policy name
    :vartype name1: str
    :param hourly_schedule: hourlySchedule. Schedule for hourly snapshots
    :type hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :param daily_schedule: dailySchedule. Schedule for daily snapshots
    :type daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :param weekly_schedule: weeklySchedule. Schedule for weekly snapshots
    :type weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :param monthly_schedule: monthlySchedule. Schedule for monthly snapshots
    :type monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :param enabled: The property to decide policy is enabled or not
    :type enabled: bool
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name1': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name1': {'key': 'properties.name', 'type': 'str'},
        'hourly_schedule': {'key': 'properties.hourlySchedule', 'type': 'HourlySchedule'},
        'daily_schedule': {'key': 'properties.dailySchedule', 'type': 'DailySchedule'},
        'weekly_schedule': {'key': 'properties.weeklySchedule', 'type': 'WeeklySchedule'},
        'monthly_schedule': {'key': 'properties.monthlySchedule', 'type': 'MonthlySchedule'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, hourly_schedule=None, daily_schedule=None, weekly_schedule=None, monthly_schedule=None, enabled: bool=None, **kwargs) -> None:
        super(SnapshotPolicyDetails, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.name1 = None
        self.hourly_schedule = hourly_schedule
        self.daily_schedule = daily_schedule
        self.weekly_schedule = weekly_schedule
        self.monthly_schedule = monthly_schedule
        self.enabled = enabled
        self.provisioning_state = None


class SnapshotPolicyPatch(Model):
    """Snapshot policy Details for create and update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar name1: Snapshot policy name
    :vartype name1: str
    :param hourly_schedule: hourlySchedule. Schedule for hourly snapshots
    :type hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :param daily_schedule: dailySchedule. Schedule for daily snapshots
    :type daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :param weekly_schedule: weeklySchedule. Schedule for weekly snapshots
    :type weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :param monthly_schedule: monthlySchedule. Schedule for monthly snapshots
    :type monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :param enabled: The property to decide policy is enabled or not
    :type enabled: bool
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name1': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name1': {'key': 'properties.name', 'type': 'str'},
        'hourly_schedule': {'key': 'properties.hourlySchedule', 'type': 'HourlySchedule'},
        'daily_schedule': {'key': 'properties.dailySchedule', 'type': 'DailySchedule'},
        'weekly_schedule': {'key': 'properties.weeklySchedule', 'type': 'WeeklySchedule'},
        'monthly_schedule': {'key': 'properties.monthlySchedule', 'type': 'MonthlySchedule'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, hourly_schedule=None, daily_schedule=None, weekly_schedule=None, monthly_schedule=None, enabled: bool=None, **kwargs) -> None:
        super(SnapshotPolicyPatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.name1 = None
        self.hourly_schedule = hourly_schedule
        self.daily_schedule = daily_schedule
        self.weekly_schedule = weekly_schedule
        self.monthly_schedule = monthly_schedule
        self.enabled = enabled
        self.provisioning_state = None


class SnapshotPolicyVolumeList(Model):
    """Volumes associated with snapshot policy.

    :param value: List of volumes
    :type value: list[object]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[object]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(SnapshotPolicyVolumeList, self).__init__(**kwargs)
        self.value = value


class Vault(Model):
    """Vault information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param vault_name: Vault Name
    :type vault_name: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vault_name': {'key': 'properties.vaultName', 'type': 'str'},
    }

    def __init__(self, *, location: str, vault_name: str=None, **kwargs) -> None:
        super(Vault, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.vault_name = vault_name


class Volume(Model):
    """Volume resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar file_system_id: FileSystem ID. Unique FileSystem Identifier.
    :vartype file_system_id: str
    :param creation_token: Required. Creation Token or File Path. A unique
     file path for the volume. Used when creating mount targets
    :type creation_token: str
    :param service_level: serviceLevel. The service level of the file system.
     Possible values include: 'Standard', 'Premium', 'Ultra'. Default value:
     "Premium" .
    :type service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :param usage_threshold: Required. usageThreshold. Maximum storage quota
     allowed for a file system in bytes. This is a soft quota used for alerting
     only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in bytes.
     Default value: 107374182400 .
    :type usage_threshold: long
    :param export_policy: exportPolicy. Set of export policy rules
    :type export_policy:
     ~azure.mgmt.netapp.models.VolumePropertiesExportPolicy
    :param protocol_types: protocolTypes. Set of protocol types
    :type protocol_types: list[str]
    :ivar provisioning_state: Azure lifecycle management
    :vartype provisioning_state: str
    :param snapshot_id: Snapshot ID. UUID v4 or resource identifier used to
     identify the Snapshot.
    :type snapshot_id: str
    :param backup_id: Backup ID. UUID v4 or resource identifier used to
     identify the Backup.
    :type backup_id: str
    :ivar baremetal_tenant_id: Baremetal Tenant ID. Unique Baremetal Tenant
     Identifier.
    :vartype baremetal_tenant_id: str
    :param subnet_id: Required. The Azure Resource URI for a delegated subnet.
     Must have the delegation Microsoft.NetApp/volumes
    :type subnet_id: str
    :param mount_targets: mountTargets. List of mount targets
    :type mount_targets: list[~azure.mgmt.netapp.models.MountTargetProperties]
    :param volume_type: What type of volume is this
    :type volume_type: str
    :param data_protection: DataProtection. DataProtection type volumes
     include an object containing details of the replication
    :type data_protection:
     ~azure.mgmt.netapp.models.VolumePropertiesDataProtection
    :param is_restoring: Restoring
    :type is_restoring: bool
    :param snapshot_directory_visible: If enabled (true) the volume will
     contain a read-only .snapshot directory which provides access to each of
     the volume's snapshots (default to true).
    :type snapshot_directory_visible: bool
    :param kerberos_enabled: Describe if a volume is KerberosEnabled. To be
     use with swagger version 2020-05-01 or later. Default value: False .
    :type kerberos_enabled: bool
    :param security_style: The security style of volume. Possible values
     include: 'ntfs', 'unix'
    :type security_style: str or ~azure.mgmt.netapp.models.SecurityStyle
    :param smb_encryption: Enables encryption for in-flight smb3 data. Only
     applicable for SMB/DualProtocol volume. To be used with swagger version
     2020-08-01 or later. Default value: False .
    :type smb_encryption: bool
    :param smb_continuously_available: Enables continuously available share
     property for smb volume. Only applicable for SMB volume. Default value:
     False .
    :type smb_continuously_available: bool
    :param throughput_mibps: Maximum throughput in Mibps that can be achieved
     by this volume.
    :type throughput_mibps: float
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'file_system_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_token': {'required': True, 'max_length': 80, 'min_length': 1, 'pattern': r'^[a-zA-Z][a-zA-Z0-9\-]{0,79}$'},
        'usage_threshold': {'required': True, 'maximum': 109951162777600, 'minimum': 107374182400},
        'provisioning_state': {'readonly': True},
        'snapshot_id': {'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}|(\\?([^\/]*[\/])*)([^\/]+)$'},
        'backup_id': {'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}|(\\?([^\/]*[\/])*)([^\/]+)$'},
        'baremetal_tenant_id': {'readonly': True},
        'subnet_id': {'required': True},
        'throughput_mibps': {'maximum': 4500, 'minimum': 1, 'multiple': 0.001},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'file_system_id': {'key': 'properties.fileSystemId', 'type': 'str'},
        'creation_token': {'key': 'properties.creationToken', 'type': 'str'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'usage_threshold': {'key': 'properties.usageThreshold', 'type': 'long'},
        'export_policy': {'key': 'properties.exportPolicy', 'type': 'VolumePropertiesExportPolicy'},
        'protocol_types': {'key': 'properties.protocolTypes', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'str'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'baremetal_tenant_id': {'key': 'properties.baremetalTenantId', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'mount_targets': {'key': 'properties.mountTargets', 'type': '[MountTargetProperties]'},
        'volume_type': {'key': 'properties.volumeType', 'type': 'str'},
        'data_protection': {'key': 'properties.dataProtection', 'type': 'VolumePropertiesDataProtection'},
        'is_restoring': {'key': 'properties.isRestoring', 'type': 'bool'},
        'snapshot_directory_visible': {'key': 'properties.snapshotDirectoryVisible', 'type': 'bool'},
        'kerberos_enabled': {'key': 'properties.kerberosEnabled', 'type': 'bool'},
        'security_style': {'key': 'properties.securityStyle', 'type': 'str'},
        'smb_encryption': {'key': 'properties.smbEncryption', 'type': 'bool'},
        'smb_continuously_available': {'key': 'properties.smbContinuouslyAvailable', 'type': 'bool'},
        'throughput_mibps': {'key': 'properties.throughputMibps', 'type': 'float'},
    }

    def __init__(self, *, location: str, creation_token: str, subnet_id: str, tags=None, service_level="Premium", usage_threshold: int=107374182400, export_policy=None, protocol_types=None, snapshot_id: str=None, backup_id: str=None, mount_targets=None, volume_type: str=None, data_protection=None, is_restoring: bool=None, snapshot_directory_visible: bool=None, kerberos_enabled: bool=False, security_style=None, smb_encryption: bool=False, smb_continuously_available: bool=False, throughput_mibps: float=None, **kwargs) -> None:
        super(Volume, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.file_system_id = None
        self.creation_token = creation_token
        self.service_level = service_level
        self.usage_threshold = usage_threshold
        self.export_policy = export_policy
        self.protocol_types = protocol_types
        self.provisioning_state = None
        self.snapshot_id = snapshot_id
        self.backup_id = backup_id
        self.baremetal_tenant_id = None
        self.subnet_id = subnet_id
        self.mount_targets = mount_targets
        self.volume_type = volume_type
        self.data_protection = data_protection
        self.is_restoring = is_restoring
        self.snapshot_directory_visible = snapshot_directory_visible
        self.kerberos_enabled = kerberos_enabled
        self.security_style = security_style
        self.smb_encryption = smb_encryption
        self.smb_continuously_available = smb_continuously_available
        self.throughput_mibps = throughput_mibps


class VolumeBackupProperties(Model):
    """Volume Backup Properties.

    :param backup_policy_id: Backup Policy Resource ID
    :type backup_policy_id: str
    :param policy_enforced: Policy Enforced
    :type policy_enforced: bool
    :param vault_id: Vault Resource ID
    :type vault_id: str
    :param backup_enabled: Backup Enabled
    :type backup_enabled: bool
    """

    _attribute_map = {
        'backup_policy_id': {'key': 'backupPolicyId', 'type': 'str'},
        'policy_enforced': {'key': 'policyEnforced', 'type': 'bool'},
        'vault_id': {'key': 'vaultId', 'type': 'str'},
        'backup_enabled': {'key': 'backupEnabled', 'type': 'bool'},
    }

    def __init__(self, *, backup_policy_id: str=None, policy_enforced: bool=None, vault_id: str=None, backup_enabled: bool=None, **kwargs) -> None:
        super(VolumeBackupProperties, self).__init__(**kwargs)
        self.backup_policy_id = backup_policy_id
        self.policy_enforced = policy_enforced
        self.vault_id = vault_id
        self.backup_enabled = backup_enabled


class VolumeBackups(Model):
    """Volume details using the backup policy.

    :param volume_name: Volume name
    :type volume_name: str
    :param backups_count: Total count of backups for volume
    :type backups_count: int
    :param policy_enabled: Policy enabled
    :type policy_enabled: bool
    """

    _attribute_map = {
        'volume_name': {'key': 'volumeName', 'type': 'str'},
        'backups_count': {'key': 'backupsCount', 'type': 'int'},
        'policy_enabled': {'key': 'policyEnabled', 'type': 'bool'},
    }

    def __init__(self, *, volume_name: str=None, backups_count: int=None, policy_enabled: bool=None, **kwargs) -> None:
        super(VolumeBackups, self).__init__(**kwargs)
        self.volume_name = volume_name
        self.backups_count = backups_count
        self.policy_enabled = policy_enabled


class VolumePatch(Model):
    """Volume patch resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: Resource location
    :type location: str
    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param service_level: serviceLevel. The service level of the file system.
     Possible values include: 'Standard', 'Premium', 'Ultra'. Default value:
     "Premium" .
    :type service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :param usage_threshold: usageThreshold. Maximum storage quota allowed for
     a file system in bytes. This is a soft quota used for alerting only.
     Minimum size is 100 GiB. Upper limit is 100TiB. Specified in bytes.
     Default value: 107374182400 .
    :type usage_threshold: long
    :param export_policy: exportPolicy. Set of export policy rules
    :type export_policy:
     ~azure.mgmt.netapp.models.VolumePatchPropertiesExportPolicy
    :param throughput_mibps: Maximum throughput in Mibps that can be achieved
     by this volume.
    :type throughput_mibps: float
    :param data_protection: DataProtection. DataProtection type volumes
     include an object containing details of the replication
    :type data_protection:
     ~azure.mgmt.netapp.models.VolumePatchPropertiesDataProtection
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'usage_threshold': {'maximum': 109951162777600, 'minimum': 107374182400},
        'throughput_mibps': {'maximum': 4500, 'minimum': 1, 'multiple': 0.001},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'usage_threshold': {'key': 'properties.usageThreshold', 'type': 'long'},
        'export_policy': {'key': 'properties.exportPolicy', 'type': 'VolumePatchPropertiesExportPolicy'},
        'throughput_mibps': {'key': 'properties.throughputMibps', 'type': 'float'},
        'data_protection': {'key': 'properties.dataProtection', 'type': 'VolumePatchPropertiesDataProtection'},
    }

    def __init__(self, *, location: str=None, tags=None, service_level="Premium", usage_threshold: int=107374182400, export_policy=None, throughput_mibps: float=None, data_protection=None, **kwargs) -> None:
        super(VolumePatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.service_level = service_level
        self.usage_threshold = usage_threshold
        self.export_policy = export_policy
        self.throughput_mibps = throughput_mibps
        self.data_protection = data_protection


class VolumePatchPropertiesDataProtection(Model):
    """DataProtection.

    DataProtection type volumes include an object containing details of the
    replication.

    :param backup: Backup. Backup Properties
    :type backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
    """

    _attribute_map = {
        'backup': {'key': 'backup', 'type': 'VolumeBackupProperties'},
    }

    def __init__(self, *, backup=None, **kwargs) -> None:
        super(VolumePatchPropertiesDataProtection, self).__init__(**kwargs)
        self.backup = backup


class VolumePatchPropertiesExportPolicy(Model):
    """exportPolicy.

    Set of export policy rules.

    :param rules: Export policy rule. Export policy rule
    :type rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[ExportPolicyRule]'},
    }

    def __init__(self, *, rules=None, **kwargs) -> None:
        super(VolumePatchPropertiesExportPolicy, self).__init__(**kwargs)
        self.rules = rules


class VolumePropertiesDataProtection(Model):
    """DataProtection.

    DataProtection type volumes include an object containing details of the
    replication.

    :param backup: Backup. Backup Properties
    :type backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
    :param replication: Replication. Replication properties
    :type replication: ~azure.mgmt.netapp.models.ReplicationObject
    :param snapshot: Snapshot. Snapshot properties.
    :type snapshot: ~azure.mgmt.netapp.models.VolumeSnapshotProperties
    """

    _attribute_map = {
        'backup': {'key': 'backup', 'type': 'VolumeBackupProperties'},
        'replication': {'key': 'replication', 'type': 'ReplicationObject'},
        'snapshot': {'key': 'snapshot', 'type': 'VolumeSnapshotProperties'},
    }

    def __init__(self, *, backup=None, replication=None, snapshot=None, **kwargs) -> None:
        super(VolumePropertiesDataProtection, self).__init__(**kwargs)
        self.backup = backup
        self.replication = replication
        self.snapshot = snapshot


class VolumePropertiesExportPolicy(Model):
    """exportPolicy.

    Set of export policy rules.

    :param rules: Export policy rule. Export policy rule
    :type rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[ExportPolicyRule]'},
    }

    def __init__(self, *, rules=None, **kwargs) -> None:
        super(VolumePropertiesExportPolicy, self).__init__(**kwargs)
        self.rules = rules


class VolumeRevert(Model):
    """revert a volume to the snapshot.

    :param snapshot_id: Resource id of the snapshot
    :type snapshot_id: str
    """

    _attribute_map = {
        'snapshot_id': {'key': 'snapshotId', 'type': 'str'},
    }

    def __init__(self, *, snapshot_id: str=None, **kwargs) -> None:
        super(VolumeRevert, self).__init__(**kwargs)
        self.snapshot_id = snapshot_id


class VolumeSnapshotProperties(Model):
    """Volume Snapshot Properties.

    :param snapshot_policy_id: Snapshot Policy ResourceId
    :type snapshot_policy_id: str
    """

    _attribute_map = {
        'snapshot_policy_id': {'key': 'snapshotPolicyId', 'type': 'str'},
    }

    def __init__(self, *, snapshot_policy_id: str=None, **kwargs) -> None:
        super(VolumeSnapshotProperties, self).__init__(**kwargs)
        self.snapshot_policy_id = snapshot_policy_id


class WeeklySchedule(Model):
    """Weekly Schedule properties, make a snapshot every week at a specific day or
    days.

    :param snapshots_to_keep: Weekly snapshot count to keep
    :type snapshots_to_keep: int
    :param day: Indicates which weekdays snapshot should be taken, accepts a
     comma separated list of week day names in english
    :type day: str
    :param hour: Indicates which hour in UTC timezone a snapshot should be
     taken
    :type hour: int
    :param minute: Indicates which minute snapshot should be taken
    :type minute: int
    :param used_bytes: Resource size in bytes, current storage usage for the
     volume in bytes
    :type used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'day': {'key': 'day', 'type': 'str'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(self, *, snapshots_to_keep: int=None, day: str=None, hour: int=None, minute: int=None, used_bytes: int=None, **kwargs) -> None:
        super(WeeklySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = snapshots_to_keep
        self.day = day
        self.hour = hour
        self.minute = minute
        self.used_bytes = used_bytes
