# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SearchResultsResponse(Model):
    """The get search result operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The id of the search, which includes the full url.
    :vartype id: str
    :param metadata: The metadata from search results.
    :type metadata: :class:`SearchMetadata
     <azure.mgmt.loganalytics.models.SearchMetadata>`
    :param value: The array of result values.
    :type value: list of object
    :param error: The error.
    :type error: :class:`SearchError
     <azure.mgmt.loganalytics.models.SearchError>`
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'metadata': {'key': '__metadata', 'type': 'SearchMetadata'},
        'value': {'key': 'value', 'type': '[object]'},
        'error': {'key': 'error', 'type': 'SearchError'},
    }

    def __init__(self, metadata=None, value=None, error=None):
        self.id = None
        self.metadata = metadata
        self.value = value
        self.error = error
