# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SavedSearch(Model):
    """Value object for saved search results.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The id of the saved search.
    :vartype id: str
    :param etag: The etag of the saved search.
    :type etag: str
    :param category: The category of the saved search. This helps the user to
     find a saved search faster.
    :type category: str
    :param display_name: Saved search display name.
    :type display_name: str
    :param query: The query expression for the saved search. Please see
     https://docs.microsoft.com/en-us/azure/log-analytics/log-analytics-search-reference
     for reference.
    :type query: str
    :param version: The version number of the query lanuage. Only verion 1 is
     allowed here.
    :type version: long
    :param tags: The tags attached to the saved search.
    :type tags: list of :class:`Tag <azure.mgmt.loganalytics.models.Tag>`
    """

    _validation = {
        'id': {'readonly': True},
        'category': {'required': True},
        'display_name': {'required': True},
        'query': {'required': True},
        'version': {'required': True, 'maximum': 1, 'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'category': {'key': 'properties.Category', 'type': 'str'},
        'display_name': {'key': 'properties.DisplayName', 'type': 'str'},
        'query': {'key': 'properties.Query', 'type': 'str'},
        'version': {'key': 'properties.Version', 'type': 'long'},
        'tags': {'key': 'properties.Tags', 'type': '[Tag]'},
    }

    def __init__(self, category, display_name, query, version, etag=None, tags=None):
        self.id = None
        self.etag = etag
        self.category = category
        self.display_name = display_name
        self.query = query
        self.version = version
        self.tags = tags
