# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._service_operations import (
    build_list_available_skus_by_resource_group_request,
    build_region_configuration_by_resource_group_request,
    build_region_configuration_request,
    build_validate_address_request,
    build_validate_inputs_by_resource_group_request,
    build_validate_inputs_request,
)
from .._vendor import DataBoxManagementClientMixinABC

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ServiceOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.databox.v2022_02_01.aio.DataBoxManagementClient`'s
        :attr:`service` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def list_available_skus_by_resource_group(
        self,
        resource_group_name: str,
        location: str,
        available_sku_request: _models.AvailableSkuRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable["_models.SkuInformation"]:
        """This method provides the list of available skus for the given subscription, resource group and
        location.

        :param resource_group_name: The Resource Group Name. Required.
        :type resource_group_name: str
        :param location: The location of the resource. Required.
        :type location: str
        :param available_sku_request: Filters for showing the available skus. Required.
        :type available_sku_request: ~azure.mgmt.databox.v2022_02_01.models.AvailableSkuRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SkuInformation or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.databox.v2022_02_01.models.SkuInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def list_available_skus_by_resource_group(
        self,
        resource_group_name: str,
        location: str,
        available_sku_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable["_models.SkuInformation"]:
        """This method provides the list of available skus for the given subscription, resource group and
        location.

        :param resource_group_name: The Resource Group Name. Required.
        :type resource_group_name: str
        :param location: The location of the resource. Required.
        :type location: str
        :param available_sku_request: Filters for showing the available skus. Required.
        :type available_sku_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SkuInformation or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.databox.v2022_02_01.models.SkuInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def list_available_skus_by_resource_group(
        self,
        resource_group_name: str,
        location: str,
        available_sku_request: Union[_models.AvailableSkuRequest, IO],
        **kwargs: Any
    ) -> AsyncIterable["_models.SkuInformation"]:
        """This method provides the list of available skus for the given subscription, resource group and
        location.

        :param resource_group_name: The Resource Group Name. Required.
        :type resource_group_name: str
        :param location: The location of the resource. Required.
        :type location: str
        :param available_sku_request: Filters for showing the available skus. Is either a
         AvailableSkuRequest type or a IO type. Required.
        :type available_sku_request: ~azure.mgmt.databox.v2022_02_01.models.AvailableSkuRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SkuInformation or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.databox.v2022_02_01.models.SkuInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-02-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-02-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AvailableSkusResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(available_sku_request, (IO, bytes)):
            _content = available_sku_request
        else:
            _json = self._serialize.body(available_sku_request, "AvailableSkuRequest")

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_available_skus_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    location=location,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    content_type=content_type,
                    json=_json,
                    content=_content,
                    template_url=self.list_available_skus_by_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AvailableSkusResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_available_skus_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/availableSkus"
    }

    @overload
    async def validate_address(
        self,
        location: str,
        validate_address: _models.ValidateAddress,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddressValidationOutput:
        """[DEPRECATED NOTICE: This operation will soon be removed]. This method validates the customer
        shipping address and provide alternate addresses if any.

        :param location: The location of the resource. Required.
        :type location: str
        :param validate_address: Shipping address of the customer. Required.
        :type validate_address: ~azure.mgmt.databox.v2022_02_01.models.ValidateAddress
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AddressValidationOutput or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.AddressValidationOutput
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def validate_address(
        self, location: str, validate_address: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AddressValidationOutput:
        """[DEPRECATED NOTICE: This operation will soon be removed]. This method validates the customer
        shipping address and provide alternate addresses if any.

        :param location: The location of the resource. Required.
        :type location: str
        :param validate_address: Shipping address of the customer. Required.
        :type validate_address: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AddressValidationOutput or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.AddressValidationOutput
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def validate_address(
        self, location: str, validate_address: Union[_models.ValidateAddress, IO], **kwargs: Any
    ) -> _models.AddressValidationOutput:
        """[DEPRECATED NOTICE: This operation will soon be removed]. This method validates the customer
        shipping address and provide alternate addresses if any.

        :param location: The location of the resource. Required.
        :type location: str
        :param validate_address: Shipping address of the customer. Is either a ValidateAddress type or
         a IO type. Required.
        :type validate_address: ~azure.mgmt.databox.v2022_02_01.models.ValidateAddress or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AddressValidationOutput or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.AddressValidationOutput
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-02-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-02-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddressValidationOutput] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(validate_address, (IO, bytes)):
            _content = validate_address
        else:
            _json = self._serialize.body(validate_address, "ValidateAddress")

        request = build_validate_address_request(
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.validate_address.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AddressValidationOutput", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate_address.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/validateAddress"
    }

    @overload
    async def validate_inputs_by_resource_group(
        self,
        resource_group_name: str,
        location: str,
        validation_request: _models.ValidationRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ValidationResponse:
        """This method does all necessary pre-job creation validation under resource group.

        :param resource_group_name: The Resource Group Name. Required.
        :type resource_group_name: str
        :param location: The location of the resource. Required.
        :type location: str
        :param validation_request: Inputs of the customer. Required.
        :type validation_request: ~azure.mgmt.databox.v2022_02_01.models.ValidationRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.ValidationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def validate_inputs_by_resource_group(
        self,
        resource_group_name: str,
        location: str,
        validation_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ValidationResponse:
        """This method does all necessary pre-job creation validation under resource group.

        :param resource_group_name: The Resource Group Name. Required.
        :type resource_group_name: str
        :param location: The location of the resource. Required.
        :type location: str
        :param validation_request: Inputs of the customer. Required.
        :type validation_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.ValidationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def validate_inputs_by_resource_group(
        self,
        resource_group_name: str,
        location: str,
        validation_request: Union[_models.ValidationRequest, IO],
        **kwargs: Any
    ) -> _models.ValidationResponse:
        """This method does all necessary pre-job creation validation under resource group.

        :param resource_group_name: The Resource Group Name. Required.
        :type resource_group_name: str
        :param location: The location of the resource. Required.
        :type location: str
        :param validation_request: Inputs of the customer. Is either a ValidationRequest type or a IO
         type. Required.
        :type validation_request: ~azure.mgmt.databox.v2022_02_01.models.ValidationRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.ValidationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-02-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-02-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ValidationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(validation_request, (IO, bytes)):
            _content = validation_request
        else:
            _json = self._serialize.body(validation_request, "ValidationRequest")

        request = build_validate_inputs_by_resource_group_request(
            resource_group_name=resource_group_name,
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.validate_inputs_by_resource_group.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ValidationResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate_inputs_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/validateInputs"
    }

    @overload
    async def validate_inputs(
        self,
        location: str,
        validation_request: _models.ValidationRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ValidationResponse:
        """This method does all necessary pre-job creation validation under subscription.

        :param location: The location of the resource. Required.
        :type location: str
        :param validation_request: Inputs of the customer. Required.
        :type validation_request: ~azure.mgmt.databox.v2022_02_01.models.ValidationRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.ValidationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def validate_inputs(
        self, location: str, validation_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.ValidationResponse:
        """This method does all necessary pre-job creation validation under subscription.

        :param location: The location of the resource. Required.
        :type location: str
        :param validation_request: Inputs of the customer. Required.
        :type validation_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.ValidationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def validate_inputs(
        self, location: str, validation_request: Union[_models.ValidationRequest, IO], **kwargs: Any
    ) -> _models.ValidationResponse:
        """This method does all necessary pre-job creation validation under subscription.

        :param location: The location of the resource. Required.
        :type location: str
        :param validation_request: Inputs of the customer. Is either a ValidationRequest type or a IO
         type. Required.
        :type validation_request: ~azure.mgmt.databox.v2022_02_01.models.ValidationRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.ValidationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-02-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-02-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ValidationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(validation_request, (IO, bytes)):
            _content = validation_request
        else:
            _json = self._serialize.body(validation_request, "ValidationRequest")

        request = build_validate_inputs_request(
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.validate_inputs.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ValidationResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate_inputs.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/validateInputs"
    }

    @overload
    async def region_configuration(
        self,
        location: str,
        region_configuration_request: _models.RegionConfigurationRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RegionConfigurationResponse:
        """This API provides configuration details specific to given region/location at Subscription
        level.

        :param location: The location of the resource. Required.
        :type location: str
        :param region_configuration_request: Request body to get the configuration for the region.
         Required.
        :type region_configuration_request:
         ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RegionConfigurationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def region_configuration(
        self, location: str, region_configuration_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.RegionConfigurationResponse:
        """This API provides configuration details specific to given region/location at Subscription
        level.

        :param location: The location of the resource. Required.
        :type location: str
        :param region_configuration_request: Request body to get the configuration for the region.
         Required.
        :type region_configuration_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RegionConfigurationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def region_configuration(
        self, location: str, region_configuration_request: Union[_models.RegionConfigurationRequest, IO], **kwargs: Any
    ) -> _models.RegionConfigurationResponse:
        """This API provides configuration details specific to given region/location at Subscription
        level.

        :param location: The location of the resource. Required.
        :type location: str
        :param region_configuration_request: Request body to get the configuration for the region. Is
         either a RegionConfigurationRequest type or a IO type. Required.
        :type region_configuration_request:
         ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RegionConfigurationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-02-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-02-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RegionConfigurationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(region_configuration_request, (IO, bytes)):
            _content = region_configuration_request
        else:
            _json = self._serialize.body(region_configuration_request, "RegionConfigurationRequest")

        request = build_region_configuration_request(
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.region_configuration.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RegionConfigurationResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    region_configuration.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/regionConfiguration"
    }

    @overload
    async def region_configuration_by_resource_group(
        self,
        resource_group_name: str,
        location: str,
        region_configuration_request: _models.RegionConfigurationRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RegionConfigurationResponse:
        """This API provides configuration details specific to given region/location at Resource group
        level.

        :param resource_group_name: The Resource Group Name. Required.
        :type resource_group_name: str
        :param location: The location of the resource. Required.
        :type location: str
        :param region_configuration_request: Request body to get the configuration for the region at
         resource group level. Required.
        :type region_configuration_request:
         ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RegionConfigurationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def region_configuration_by_resource_group(
        self,
        resource_group_name: str,
        location: str,
        region_configuration_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RegionConfigurationResponse:
        """This API provides configuration details specific to given region/location at Resource group
        level.

        :param resource_group_name: The Resource Group Name. Required.
        :type resource_group_name: str
        :param location: The location of the resource. Required.
        :type location: str
        :param region_configuration_request: Request body to get the configuration for the region at
         resource group level. Required.
        :type region_configuration_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RegionConfigurationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def region_configuration_by_resource_group(
        self,
        resource_group_name: str,
        location: str,
        region_configuration_request: Union[_models.RegionConfigurationRequest, IO],
        **kwargs: Any
    ) -> _models.RegionConfigurationResponse:
        """This API provides configuration details specific to given region/location at Resource group
        level.

        :param resource_group_name: The Resource Group Name. Required.
        :type resource_group_name: str
        :param location: The location of the resource. Required.
        :type location: str
        :param region_configuration_request: Request body to get the configuration for the region at
         resource group level. Is either a RegionConfigurationRequest type or a IO type. Required.
        :type region_configuration_request:
         ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RegionConfigurationResponse or the result of cls(response)
        :rtype: ~azure.mgmt.databox.v2022_02_01.models.RegionConfigurationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-02-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-02-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RegionConfigurationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(region_configuration_request, (IO, bytes)):
            _content = region_configuration_request
        else:
            _json = self._serialize.body(region_configuration_request, "RegionConfigurationRequest")

        request = build_region_configuration_by_resource_group_request(
            resource_group_name=resource_group_name,
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.region_configuration_by_resource_group.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ApiError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RegionConfigurationResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    region_configuration_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/regionConfiguration"
    }
