// Generated by CoffeeScript 1.12.1
var Ganymede;

Ganymede = (function() {
  function Ganymede(logo_src) {
    var base, base1, base2;
    this.metadata = (base = window.IPython.notebook.metadata).ganymede != null ? base.ganymede : base.ganymede = {};
    $('#header').hide();
    this.menubar = new Ganymede.MenuBar();
    this.toolbar = new Ganymede.ToolBar();
    $('#ganymede').remove();
    this.$ = $("<div id=\"ganymede\"></div>");
    $('body').append(this.$);
    this.$.append(this.menubar.$);
    this.$.append(this.toolbar.$);
    this.logo = new Ganymede.Logo(logo_src);
    this.logo.$.addClass('ui-resizable-handle ui-resizable-se');
    this.$.append(this.logo.$);
    if ((base1 = this.metadata).height == null) {
      base1.height = this.logo.$.outerHeight(true);
    }
    if ((base2 = this.metadata).width == null) {
      base2.width = this.logo.$.outerWidth(true);
    }
    this.$.height(this.metadata.height);
    this.$.width(this.metadata.width);
    this.$.resizable({
      handles: {
        se: this.logo.$
      },
      start: (function(_this) {
        return function() {
          _this.preventClick = false;
          _this.metadata.slim = false;
          _this.metadata.height = _this.$.height();
          return _this.metadata.width = _this.$.width();
        };
      })(this),
      resize: (function(_this) {
        return function() {
          _this.resizing = true;
          _this.preventClick = true;
          _this.metadata.height = _this.$.height();
          _this.metadata.width = _this.$.width();
          return _this.update();
        };
      })(this),
      stop: (function(_this) {
        return function() {
          _this.resizing = false;
          return _this.update();
        };
      })(this)
    });
    this.preventClick = false;
    this.logo.$.click((function(_this) {
      return function() {
        var slim;
        if (_this.preventClick) {
          _this.preventClick = false;
          return;
        }
        if (_this.vertical) {
          _this.metadata.slim = slim = _this.$.width() === _this.metadata.width;
          return _this.$.width(!slim ? _this.metadata.width : _this.logo.$.outerWidth(true));
        } else {
          _this.metadata.slim = slim = _this.$.height() === _this.metadata.height;
          return _this.$.height(!slim ? _this.metadata.height : _this.logo.$.outerHeight(true));
        }
      };
    })(this));
    this.console = new Ganymede.Console();
    $(window).on('resize.ganymede', (function(_this) {
      return function() {
        return _this.update();
      };
    })(this));
    this.update();
  }

  Ganymede.prototype.update = function() {
    var $bar, $toolGroups, $tools, group, groupWidths, i, len, overHeight, overWidth, ref, width;
    overHeight = this.metadata.height - this.$.height() + (this.$.outerHeight(true)) - $(window).height();
    if (overHeight > 0) {
      this.$.height(this.metadata.height - overHeight);
    } else if (!this.resizing) {
      this.$.height(this.metadata.height);
    }
    overWidth = this.metadata.width - this.$.width() + (this.$.outerWidth(true)) - $(window).width();
    if (overWidth > 0) {
      this.$.width(this.metadata.width - overWidth);
    } else if (!this.resizing) {
      this.$.width(this.metadata.width);
    }
    this.horizontal = !(this.vertical = this.$.height() > this.$.width());
    if (this.metadata.slim === true) {
      if (this.vertical) {
        this.$.width(this.logo.$.outerWidth(true));
      } else {
        this.$.height(this.logo.$.outerHeight(true));
      }
    }
    ref = [this.menubar.$, this.toolbar.$];
    for (i = 0, len = ref.length; i < len; i++) {
      $bar = ref[i];
      $bar.toggleClass('vertical', this.vertical);
      $bar.toggleClass('horizontal', this.horizontal);
    }
    $toolGroups = $('.btn-group', this.toolbar.$);
    if (this.horizontal) {
      groupWidths = (function() {
        var j, len1, results;
        results = [];
        for (j = 0, len1 = $toolGroups.length; j < len1; j++) {
          group = $toolGroups[j];
          $tools = $('.btn', group);
          width = 6 + $tools.length * ($tools.outerWidth(true));
          $(group).css({
            width: width
          });
          results.push($(group).outerWidth(true));
        }
        return results;
      })();
      this.toolbar.$.css({
        width: groupWidths.reduce(function(l, r) {
          return l + r;
        })
      });
    } else {
      $toolGroups.css({
        width: ''
      });
      this.toolbar.$.css({
        width: ''
      });
    }
    return this;
  };

  Ganymede.prototype.unload = function() {
    var $checkpoint, $origin;
    $origin = $('#menubar-container');
    $origin.append(this.menubar.unload().$);
    $origin.append(this.toolbar.unload().$);
    $checkpoint = this.console.$checkpoint.prepend($('#notebook_name'));
    $origin = $('#header-container');
    $origin.append($checkpoint);
    $origin.append($('#kernel_logo_widget'));
    $('#header').show();
    $(window).off('resize.ganymede');
    this.console.unload();
    this.$.remove();
    return this;
  };

  return Ganymede;

})();

Ganymede.Logo = (function() {
  function Logo(src) {
    $('#ganymede-logo').remove();
    this.$ = $("<img id=\"ganymede-logo\" src=\"" + src + "\" />");
  }

  return Logo;

})();

Ganymede.MenuBar = (function() {
  function MenuBar() {
    this.$ = $('#menubar').detach();
  }

  MenuBar.prototype.unload = function() {
    $('.container-fluid > *:first', this.$).after($('#kernel_indicator'));
    $('.container-fluid > *:last', this.$).before($('#notification_area'));
    $('.kernel_indicator_name').show();
    return this;
  };

  return MenuBar;

})();

Ganymede.ToolBar = (function() {
  function ToolBar() {
    this.$ = $('#maintoolbar').detach();
    this.$.find('.btn:contains("CellToolbar")').hide();
  }

  ToolBar.prototype.unload = function() {
    $('.btn-group').css({
      width: ''
    });
    this.$.css({
      width: ''
    });
    return this;
  };

  return ToolBar;

})();

Ganymede.Console = (function() {
  function Console() {
    var $handle, $indicator, $tab, base, base1, base2, base3, i, id, len, loc, ref;
    this.metadata = (base = ((base1 = window.IPython.notebook.metadata).ganymede != null ? base1.ganymede : base1.ganymede = {})).console != null ? base.console : base.console = {};
    this.$ = $('#ipython-main-app');
    this.$.append(this.$checkpoint = $('#save_widget'));
    this.$.append(this.$notifier = $('#notification_area'));
    this.$handles = {};
    ref = ['sw', 's', 'se'];
    for (i = 0, len = ref.length; i < len; i++) {
      loc = ref[i];
      id = "ganymede-console-handle-" + loc;
      $('#' + id).remove();
      $handle = $("<div id=\"" + id + "\">. . .</div>").addClass("ganymede-console-handle btn btn-default\nui-resizable-handle ui-resizable-" + loc);
      this.$.append(this.$handles[loc] = $handle);
    }
    if ((base2 = this.metadata).width == null) {
      base2.width = this.$.width();
    }
    if ((base3 = this.metadata).height == null) {
      base3.height = this.$.height();
    }
    if (this.metadata.left != null) {
      this.$.css({
        left: this.metadata.left
      });
    } else {
      this.metadata.left = this.$.offset().left;
    }
    if (this.metadata.collapsed === true) {
      this.$.addClass('collapsed');
    }
    this.$.resizable({
      handles: this.$handles,
      start: (function(_this) {
        return function(event) {
          _this.preventClick = false;
          _this.metadata.height = _this.$.height();
          _this.metadata.width = _this.$.width();
          _this.mouseX = event.pageX;
          return _this.offsetX = _this.$.offset().left;
        };
      })(this),
      resize: (function(_this) {
        return function(event) {
          _this.resizing = true;
          _this.metadata.height = _this.$.height();
          _this.metadata.width = _this.$.width();
          if (_this.$.data('ui-resizable').axis === 's') {
            _this.preventClick = true;
            _this.$.css({
              left: _this.metadata.left = _this.offsetX + event.pageX - _this.mouseX
            });
          }
          return _this.update();
        };
      })(this),
      stop: (function(_this) {
        return function() {
          _this.resizing = false;
          return _this.update();
        };
      })(this)
    });
    this.preventClick = false;
    this.$handles.s.click((function(_this) {
      return function() {
        if (_this.preventClick) {
          _this.preventClick = false;
          return;
        }
        _this.$.toggleClass('collapsed');
        _this.metadata.collapsed = _this.$.hasClass('collapsed');
        return _this.update();
      };
    })(this));
    $tab = $('.ganymede-console-tab').detach();
    $('#ganymede-console-tabs').remove();
    this.$tabs = $("<ul id=\"ganymede-console-tabs\"></ul>");
    if (!$tab.length) {
      $tab = $("<li class=\"ganymede-console-tab\">\n    <a href=\"#notebook\"></a>\n</li>");
      $indicator = $('#kernel_indicator');
      $('a', $tab).append($indicator);
      $('.kernel_indicator_name', $indicator).hide();
      $indicator.prepend($('#notebook_name'));
      $indicator.prepend($('#kernel_logo_widget'));
    }
    this.$tabs.append($tab);
    this.$.prepend(this.$tabs);
    this.$.tabs();
    $('#notebook-container').on('resize.ganymede-console', (function(_this) {
      return function() {
        return _this.updateOutputs();
      };
    })(this));
    $(window).on('resize.ganymede-console', (function(_this) {
      return function() {
        return _this.update();
      };
    })(this));
    this.update();
  }

  Console.prototype.update = function() {
    var overHeight, overWidth, top;
    overWidth = this.metadata.width - this.$.width() + (this.$.outerWidth(true)) + this.$.offset().left - $(window).width();
    if (overWidth > 0) {
      this.$.width(this.metadata.width - overWidth);
    } else if (!this.resizing) {
      this.$.width(this.metadata.width);
    }
    if (this.$.hasClass('collapsed')) {
      this.$.resizable('disable');
      this.$.removeClass('ui-resizable-disabled ui-state-disabled');
      this.$.css({
        top: 0,
        height: 0
      });
      return this;
    }
    this.$.resizable('enable');
    this.$.css({
      top: top = this.$tabs.outerHeight(true)
    });
    overHeight = this.metadata.height - this.$.height() + (this.$.outerHeight(true)) + top + (this.$handles.s.outerHeight(true)) - $(window).height();
    if (overHeight > 0) {
      this.$.height(this.metadata.height - overHeight);
    } else if (!this.resizing) {
      this.$.height(this.metadata.height);
    }
    return this;
  };

  Console.prototype.updateOutputs = function() {
    var $output, cell, metadata, z, zValues;
    zValues = (function() {
      var base, base1, i, len, ref, results;
      ref = $('.cell', this.$);
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        cell = ref[i];
        metadata = (base = ((base1 = $(cell).data('cell').metadata).ganymede != null ? base1.ganymede : base1.ganymede = {})).output != null ? base.output : base.output = {};
        if (metadata.undocked === true) {
          $output = $('.output_wrapper', cell);
          $output.addClass('ganymede');
          $output.css({
            position: 'fixed',
            'z-index': z = metadata['z-index'] || -1,
            top: metadata.top || 0,
            left: metadata.left || 0
          });
          results.push(z);
        } else {
          results.push(0);
        }
      }
      return results;
    }).call(this);
    $('body').css({
      'z-index': (Math.min.apply(Math, zValues)) - 1
    });
    $('.output_wrapper', this.$).draggable({
      handle: '.out_prompt_overlay',
      start: (function(_this) {
        return function(event) {
          var $outputs, base, base1, base2, base3, data, i, index, len, offset, output;
          $output = $(event.target);
          _this.$.addClass('collapsed');
          _this.update();
          if (!$output.hasClass('ganymede')) {
            offset = $output.offset();
            data = $output.data('ui-draggable');
            data.offset.click.top -= offset.top;
            data.offset.click.left -= offset.left;
          }
          $output.addClass('ganymede');
          $output.css('z-index', -1);
          $outputs = $('.output_wrapper.ganymede').sort(function(l, r) {
            return ($(l).css('z-index')) - ($(r).css('z-index'));
          });
          z = -2 - $outputs.length;
          $('body').css('z-index', z - 1);
          for (index = i = 0, len = $outputs.length; i < len; index = ++i) {
            output = $outputs[index];
            metadata = (base = ((base1 = $(output).parents('.cell').data('cell').metadata).ganymede != null ? base1.ganymede : base1.ganymede = {})).output != null ? base.output : base.output = {};
            $(output).css({
              'z-index': metadata['z-index'] = z + index
            });
          }
          metadata = (base2 = ((base3 = $output.parents('.cell').data('cell').metadata).ganymede != null ? base3.ganymede : base3.ganymede = {})).output != null ? base2.output : base2.output = {};
          metadata.undocked = true;
          return $output.css({
            'z-index': metadata['z-index'] = z + index
          });
        };
      })(this),
      stop: (function(_this) {
        return function(event) {
          var base, base1;
          $output = $(event.target);
          metadata = (base = ((base1 = $output.parents('.cell').data('cell').metadata).ganymede != null ? base1.ganymede : base1.ganymede = {})).output != null ? base.output : base.output = {};
          $.extend(metadata, $output.offset());
          _this.$.removeClass('collapsed');
          return _this.update();
        };
      })(this)
    });
    return this;
  };

  Console.prototype.unload = function() {
    var $handle, $outputs, loc, ref;
    $outputs = $('.output_wrapper', this.$).removeClass('ganymede');
    $outputs.css({
      'z-index': '',
      position: '',
      top: '',
      left: ''
    });
    this.$tabs.remove();
    ref = this.$handles;
    for (loc in ref) {
      $handle = ref[loc];
      $handle.remove();
    }
    this.$.tabs('destroy');
    this.$.resizable('destroy');
    this.$.css({
      position: '',
      left: '',
      top: '',
      width: '',
      height: ''
    });
    $([window, '#notebook-container']).off('resize.ganymede-console');
    return this;
  };

  return Console;

})();
