/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.testdriver.TestDriver;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOutcome {
    private TestDriver driver;
    private SingleResultDoc principalResult = new SingleResultDoc();
    private Set<String> errorsReported;
    private boolean warningsReported;
    private SaxonApiException exception;
    private String comment;
    private Set<XdmNode> xslMessages = new HashSet<XdmNode>(4);
    private Map<URI, SingleResultDoc> xslResultDocuments = new HashMap<URI, SingleResultDoc>(4);
    private String wrongError;

    public TestOutcome(TestDriver driver) {
        this.driver = driver;
    }

    public void setException(SaxonApiException exception) {
        this.exception = exception;
    }

    public boolean isException() {
        return this.exception != null;
    }

    public SaxonApiException getException() {
        return this.exception;
    }

    public String getWrongErrorMessage() {
        return this.wrongError;
    }

    public void setPrincipalResult(XdmValue value) {
        this.principalResult.value = value;
    }

    public void setWarningsReported(boolean warnings) {
        this.warningsReported = warnings;
    }

    public boolean isWarningsReported() {
        return this.warningsReported;
    }

    public XdmValue getPrincipalResult() {
        return this.principalResult.value;
    }

    public SingleResultDoc getPrincipalResultDoc() {
        return this.principalResult;
    }

    public void setSecondaryResult(URI uri, XdmNode value, String serialization) {
        SingleResultDoc result = this.xslResultDocuments.get(uri);
        if (result == null) {
            result = new SingleResultDoc((XdmValue)value, serialization);
            this.xslResultDocuments.put(uri, result);
        } else {
            if (value != null) {
                result.value = value;
            }
            if (serialization != null) {
                result.serialization = serialization;
            }
        }
    }

    public SingleResultDoc getSecondaryResult(URI uri) {
        return this.xslResultDocuments.get(uri);
    }

    public Map<URI, SingleResultDoc> getSecondaryResultDocuments() {
        return this.xslResultDocuments;
    }

    public void setErrorsReported(Set<String> errors) {
        this.errorsReported = errors;
    }

    public void addReportedError(String error) {
        if (this.errorsReported == null) {
            this.errorsReported = new HashSet<String>();
        }
        this.errorsReported.add(error);
    }

    public boolean hasReportedError(String errorCode) {
        return this.errorsReported != null && this.errorsReported.contains(errorCode);
    }

    public String toString() {
        return this.isException() ? "EXCEPTION " + this.exception.getMessage() : this.getPrincipalResult().toString();
    }

    public void setPrincipalSerializedResult(String result) {
        this.principalResult.serialization = result;
    }

    public String getPrincipalSerializedResult() {
        return this.principalResult.serialization;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void addXslMessage(XdmNode message) {
        this.xslMessages.add(message);
    }

    public String serialize(Processor p, URI uri) {
        XdmValue value;
        if (uri == null) {
            if (this.principalResult.serialization != null) {
                return this.principalResult.serialization;
            }
            value = this.principalResult.value;
        } else {
            SingleResultDoc doc = this.xslResultDocuments.get(uri);
            if (doc == null) {
                return "[[[NULL VALUE]]]";
            }
            if (doc.serialization != null) {
                return doc.serialization;
            }
            value = doc.value;
        }
        if (value == null) {
            return "[[[NULL VALUE]]]";
        }
        if (this.isException()) {
            return "EXCEPTION " + this.exception.getMessage();
        }
        StringWriter sw = new StringWriter();
        Serializer s = p.newSerializer((Writer)sw);
        s.setOutputProperty(Serializer.Property.METHOD, "xml");
        s.setOutputProperty(Serializer.Property.INDENT, "no");
        s.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        try {
            s.serializeXdmValue(value);
        }
        catch (SaxonApiException err) {
            return "SERIALIZATION FAILED: " + err.getMessage();
        }
        String str = sw.toString().trim();
        if (uri == null) {
            this.principalResult.serialization = str;
        } else {
            this.xslResultDocuments.get((Object)uri).serialization = str;
        }
        return str;
    }

    public String serialize(Processor p, SingleResultDoc doc) {
        String str;
        if (doc.serialization != null) {
            return doc.serialization;
        }
        XdmValue value = doc.value;
        if (value == null) {
            return "[[[NULL VALUE]]]";
        }
        if (this.isException()) {
            return "EXCEPTION " + this.exception.getMessage();
        }
        StringWriter sw = new StringWriter();
        Serializer s = p.newSerializer((Writer)sw);
        s.setOutputProperty(Serializer.Property.METHOD, "xml");
        s.setOutputProperty(Serializer.Property.INDENT, "no");
        s.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        try {
            s.serializeXdmValue(value);
        }
        catch (SaxonApiException err) {
            return "SERIALIZATION FAILED: " + err.getMessage();
        }
        doc.serialization = str = sw.toString().trim();
        return str;
    }

    public String serialize(Processor p, XdmValue value) {
        StringWriter sw = new StringWriter();
        Serializer s = p.newSerializer((Writer)sw);
        s.setOutputProperty(Serializer.Property.METHOD, "xml");
        s.setOutputProperty(Serializer.Property.INDENT, "no");
        s.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        try {
            s.serializeXdmValue(value);
        }
        catch (SaxonApiException err) {
            return "SERIALIZATION FAILED: " + err.getMessage();
        }
        return sw.toString().trim();
    }

    public boolean testAssertion(XdmNode assertion, SingleResultDoc result, XPathCompiler assertXpc, XPathCompiler catalogXpc, boolean debug) throws SaxonApiException {
        try {
            String tag = assertion.getNodeName().getLocalName();
            boolean success = this.testAssertion2(assertion, result, assertXpc, catalogXpc, debug);
            if (debug && !"all-of".equals(tag) && !"any-of".equals(tag) && !"not".equals(tag)) {
                String parentTag = assertion.getParent().getNodeName().getLocalName();
                String label = "Assertion " + tag;
                if (parentTag.equals("not") || parentTag.equals("any-of") || parentTag.equals("all-of")) {
                    label = "(Within " + parentTag + ") " + label;
                }
                this.driver.println(label + " (" + assertion.getStringValue() + ") " + (success ? " succeeded" : " failed"));
                if (tag.equals("error")) {
                    if (this.isException()) {
                        boolean b = this.compareExpectedError(assertion);
                        if (b) {
                            this.driver.println("Returned error as expected");
                        } else {
                            this.driver.println(this.wrongError);
                        }
                    } else {
                        this.driver.println("Expected exception " + assertion.getAttributeValue(new QName("code")) + "; got success");
                    }
                } else if (!success && this.isException()) {
                    FastStringBuffer fsb = new FastStringBuffer(32);
                    fsb.append("Expected success, got error ");
                    if (this.errorsReported != null) {
                        for (String e : this.errorsReported) {
                            fsb.append(e);
                            fsb.append("|");
                        }
                    }
                    fsb.setLength(fsb.length() - 1);
                    this.driver.println(fsb.toString());
                }
            }
            if (!success && this.wrongError != null) {
                success = true;
            }
            return success;
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean testAssertion2(XdmNode assertion, SingleResultDoc result, XPathCompiler assertXpc, XPathCompiler catalogXpc, boolean debug) throws SaxonApiException {
        String tag = assertion.getNodeName().getLocalName();
        if (tag.equals("assert-eq")) {
            return this.assertEq(assertion, result, assertXpc);
        }
        if (tag.equals("assert-deep-eq")) {
            return this.assertDeepEq(assertion, result, assertXpc);
        }
        if (tag.equals("assert-permutation")) {
            return this.assertPermutation(assertion, result, assertXpc);
        }
        if (tag.equals("assert-xml")) {
            return this.assertXml(assertion, result, assertXpc, catalogXpc, debug);
        }
        if (tag.equals("serialization-matches")) {
            return this.assertSerializationMatches(assertion, result, catalogXpc);
        }
        if (tag.equals("assert-serialization-error")) {
            return this.assertSerializationError(assertion, result, assertXpc);
        }
        if (tag.equals("assert-empty")) {
            return this.assertEmpty(result.value);
        }
        if (tag.equals("assert-count")) {
            return this.assertCount(assertion, result);
        }
        if (tag.equals("assert")) {
            return this.assertXPath(assertion, result, assertXpc, debug);
        }
        if (tag.equals("assert-string-value")) {
            return this.assertStringValue(assertion, result, debug);
        }
        if (tag.equals("assert-serialization")) {
            return this.assertSerialization(assertion, result, catalogXpc, debug);
        }
        if (tag.equals("assert-type")) {
            return this.assertType(assertion, result, assertXpc);
        }
        if (tag.equals("assert-true")) {
            return this.assertTrue(result);
        }
        if (tag.equals("assert-false")) {
            return this.assertFalse(result);
        }
        if (tag.equals("assert-warning")) {
            return this.assertWarning();
        }
        if (tag.equals("assert-message")) {
            XdmNode subAssertion = (XdmNode)catalogXpc.evaluateSingle("*", (XdmItem)assertion);
            for (XdmNode message : this.xslMessages) {
                if (!this.testAssertion2(subAssertion, new SingleResultDoc((XdmValue)message, ""), assertXpc, catalogXpc, debug)) continue;
                return true;
            }
            return false;
        }
        if (tag.equals("assert-result-document")) {
            XdmNode subAssertion = (XdmNode)catalogXpc.evaluateSingle("*", (XdmItem)assertion);
            URI uri = new File(this.driver.resultsDir + "/results/output.xml").toURI().resolve(assertion.getAttributeValue(new QName("uri")));
            SingleResultDoc doc = this.getSecondaryResult(uri);
            if (doc == null) {
                System.err.println("**** No output document found for " + uri);
                return false;
            }
            boolean ok = this.testAssertion2(subAssertion, doc, assertXpc, catalogXpc, debug);
            if (!ok) {
                System.err.println("**** Assertion failed for result-document " + uri);
            }
            return ok;
        }
        if (tag.equals("error")) {
            return this.isException() && this.compareExpectedError(assertion);
        }
        if (tag.equals("all-of")) {
            for (XdmItem child : catalogXpc.evaluate("*", (XdmItem)assertion)) {
                if (this.testAssertion((XdmNode)child, result, assertXpc, catalogXpc, debug)) continue;
                return false;
            }
            return true;
        }
        if (tag.equals("any-of")) {
            boolean partialSuccess = false;
            for (XdmItem child : catalogXpc.evaluate("*", (XdmItem)assertion)) {
                if (!this.testAssertion((XdmNode)child, result, assertXpc, catalogXpc, debug)) continue;
                if (this.wrongError != null) {
                    partialSuccess = true;
                    continue;
                }
                return true;
            }
            return partialSuccess;
        }
        if (tag.equals("not")) {
            XdmNode subAssertion = (XdmNode)catalogXpc.evaluateSingle("*", (XdmItem)assertion);
            return !this.testAssertion(subAssertion, result, assertXpc, catalogXpc, debug);
        }
        throw new IllegalStateException("Unknown assertion element " + tag);
    }

    private boolean assertFalse(SingleResultDoc result) throws SaxonApiException {
        if (this.isException()) {
            return false;
        }
        return result.value.size() == 1 && result.value.itemAt(0).isAtomicValue() && ((XdmAtomicValue)result.value.itemAt(0)).getPrimitiveTypeName().equals((Object)QName.XS_BOOLEAN) && !((XdmAtomicValue)result.value.itemAt(0)).getBooleanValue();
    }

    private boolean assertTrue(SingleResultDoc result) throws SaxonApiException {
        if (this.isException()) {
            return false;
        }
        return result.value.size() == 1 && result.value.itemAt(0).isAtomicValue() && ((XdmAtomicValue)result.value.itemAt(0)).getPrimitiveTypeName().equals((Object)QName.XS_BOOLEAN) && ((XdmAtomicValue)result.value.itemAt(0)).getBooleanValue();
    }

    private boolean assertWarning() {
        byte[] data = new byte[]{31, 32, 33};
        String.valueOf(data);
        return this.isWarningsReported();
    }

    private boolean assertType(XdmNode assertion, SingleResultDoc result, XPathCompiler assertXpc) throws SaxonApiException {
        if (this.isException()) {
            return false;
        }
        XPathSelector s = assertXpc.compile("$result instance of " + assertion.getStringValue()).load();
        s.setVariable(new QName("result"), result.value);
        return ((XdmAtomicValue)s.evaluateSingle()).getBooleanValue();
    }

    private boolean assertStringValue(XdmNode assertion, SingleResultDoc result, boolean debug) {
        String resultString;
        if (this.isException()) {
            return false;
        }
        String assertionString = assertion.getStringValue();
        if (result.value instanceof XdmItem) {
            resultString = ((XdmItem)result.value).getStringValue();
        } else {
            boolean first = true;
            FastStringBuffer fsb = new FastStringBuffer(256);
            for (XdmItem item : result.value) {
                if (first) {
                    first = false;
                } else {
                    fsb.append(' ');
                }
                fsb.append(item.getStringValue());
            }
            resultString = fsb.toString();
        }
        String normalizeAtt = assertion.getAttributeValue(new QName("normalize-space"));
        if (normalizeAtt != null && (normalizeAtt.trim().equals("true") || normalizeAtt.trim().equals("1"))) {
            assertionString = Whitespace.collapseWhitespace((CharSequence)assertionString).toString();
            resultString = Whitespace.collapseWhitespace((CharSequence)resultString).toString();
        }
        if (resultString.equals(assertionString)) {
            return true;
        }
        if (debug) {
            if (resultString.length() != assertionString.length()) {
                this.driver.println("Result length " + resultString.length() + "; expected length " + assertionString.length());
            }
            int len = Math.min(resultString.length(), assertionString.length());
            for (int i = 0; i < len; ++i) {
                if (resultString.charAt(i) == assertionString.charAt(i)) continue;
                this.driver.println("Results differ at index " + i + "(\"" + resultString.substring(i, i + 10 > len ? len : i + 10) + "\") vs (\"" + assertionString.substring(i, i + 10 > len ? len : i + 10) + "\")");
                break;
            }
        }
        return false;
    }

    private boolean assertSerialization(XdmNode assertion, SingleResultDoc result, XPathCompiler xpath, boolean debug) throws SaxonApiException {
        boolean isHtml;
        boolean normalize;
        if (this.isException()) {
            return false;
        }
        String method = assertion.getAttributeValue(new QName("method"));
        if (method == null) {
            method = "xml";
        }
        String resultString = result.serialization;
        String comparand = xpath.evaluate("if (@file) then if (@encoding) then unparsed-text(resolve-uri(@file, base-uri(.)), @encoding) else unparsed-text(resolve-uri(@file, base-uri(.))) else string(.)", (XdmItem)assertion).toString();
        if ((comparand = comparand.replace("\r\n", "\n")).endsWith("\n")) {
            comparand = comparand.substring(0, comparand.length() - 1);
        }
        if (resultString == null) {
            if (result.value instanceof XdmItem) {
                resultString = ((XdmItem)result.value).getStringValue();
            } else {
                if (debug) {
                    this.driver.println("Assert serialization fails: result is a sequence");
                }
                return false;
            }
        }
        if (!(normalize = (isHtml = method.equals("html") || method.equals("xhtml")))) {
            String normalizeAtt = assertion.getAttributeValue(new QName("normalize-space"));
            boolean bl = normalize = normalizeAtt != null && (normalizeAtt.trim().equals("true") || normalizeAtt.trim().equals("1"));
        }
        if (normalize) {
            comparand = Whitespace.collapseWhitespace((CharSequence)comparand).toString();
            resultString = Whitespace.collapseWhitespace((CharSequence)resultString).toString();
        } else if (resultString.endsWith("\n")) {
            resultString = resultString.substring(0, resultString.length() - 1);
        }
        if (isHtml) {
            comparand = comparand.replace(" <", "<");
            comparand = comparand.replace("> ", ">");
            resultString = resultString.replace(" <", "<");
            resultString = resultString.replace("> ", ">");
        }
        if (resultString.equals(comparand)) {
            return true;
        }
        if (debug) {
            if (resultString.length() != comparand.length()) {
                this.driver.println("Result length " + resultString.length() + "; expected length " + comparand.length());
            }
            int len = Math.min(resultString.length(), comparand.length());
            for (int i = 0; i < len; ++i) {
                if (resultString.charAt(i) == comparand.charAt(i)) continue;
                this.driver.println("Results differ at index " + i + "(\"" + resultString.substring(i, i + 10 > len ? len : i + 10) + "\") vs (\"" + comparand.substring(i, i + 10 > len ? len : i + 10) + "\")");
                break;
            }
        }
        this.driver.println("Serialized results differ");
        return false;
    }

    private boolean assertXPath(XdmNode assertion, SingleResultDoc result, XPathCompiler assertXpc, boolean debug) throws SaxonApiException {
        boolean b;
        if (this.isException()) {
            return false;
        }
        XdmSequenceIterator iter = assertion.axisIterator(Axis.NAMESPACE);
        while (iter.hasNext()) {
            XdmNode namespace = (XdmNode)iter.next();
            if (namespace.getNodeName() == null) continue;
            assertXpc.declareNamespace(namespace.getNodeName().getLocalName(), namespace.getStringValue());
        }
        XPathExecutable exp = assertXpc.compile(assertion.getStringValue());
        XPathSelector s = exp.load();
        QName resultVar = new QName("result");
        if (exp.getRequiredCardinalityForVariable(resultVar) == null) {
            if (result.value instanceof XdmItem) {
                s.setContextItem((XdmItem)result.value);
            }
        } else {
            s.setVariable(resultVar, result.value);
        }
        if (!(b = s.effectiveBooleanValue()) && debug) {
            this.driver.println("XPath assertion " + assertion.getStringValue() + " failed");
            try {
                String ass = assertion.getStringValue();
                int eq = ass.indexOf("=");
                if (eq > 0) {
                    ass = ass.substring(0, eq);
                    exp = assertXpc.compile(ass);
                    s = exp.load();
                    if (exp.getRequiredCardinalityForVariable(resultVar) == null) {
                        if (result.value instanceof XdmItem) {
                            s.setContextItem((XdmItem)result.value);
                        }
                    } else {
                        s.setVariable(resultVar, result.value);
                    }
                    XdmValue val = s.evaluate();
                    this.driver.println("Actual result of " + ass + ": " + val.toString());
                }
            }
            catch (Exception err) {
                // empty catch block
            }
            this.driver.println("Actual results: " + result.value);
        }
        return b;
    }

    private boolean assertCount(XdmNode assertion, SingleResultDoc result) {
        return !this.isException() && result.value.size() == Integer.parseInt(assertion.getStringValue());
    }

    private boolean assertEmpty(XdmValue result) {
        return !this.isException() && result.size() == 0;
    }

    private boolean assertSerializationError(XdmNode assertion, SingleResultDoc result, XPathCompiler assertXpc) {
        if (this.isException()) {
            return this.compareExpectedError(assertion);
        }
        String expectedError = assertion.getAttributeValue(new QName("code"));
        StringWriter sw = new StringWriter();
        Serializer serializer = assertXpc.getProcessor().newSerializer((Writer)sw);
        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        serializer.setOutputProperty(Serializer.Property.INDENT, "no");
        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        try {
            serializer.serializeXdmValue(result.value);
            return false;
        }
        catch (SaxonApiException err) {
            boolean b = expectedError.equals(err.getErrorCode().getLocalName());
            if (!b) {
                this.driver.println("Expected " + expectedError + ", got " + err.getErrorCode().getLocalName());
            }
            return true;
        }
    }

    private boolean assertSerializationMatches(XdmNode assertion, SingleResultDoc result, XPathCompiler xpath) throws SaxonApiException {
        if (this.isException()) {
            return false;
        }
        String flagsAtt = assertion.getAttributeValue(new QName("flags"));
        if (flagsAtt == null) {
            flagsAtt = "";
        }
        String regex = assertion.getStringValue();
        ArrayList warnings = new ArrayList(1);
        try {
            RegularExpression re = Configuration.getPlatform().compileRegularExpression((CharSequence)regex, flagsAtt, "XP30", warnings);
            if (re.containsMatch((CharSequence)this.getPrincipalSerializedResult())) {
                return true;
            }
            this.driver.println("Serialized result:");
            this.driver.println(this.getPrincipalSerializedResult());
            return false;
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
    }

    private boolean assertXml(XdmNode assertion, SingleResultDoc result, XPathCompiler assertXpc, XPathCompiler catalogXpc, boolean debug) throws SaxonApiException {
        if (this.isException()) {
            return false;
        }
        String normalizeAtt = assertion.getAttributeValue(new QName("normalize-space"));
        boolean normalize = normalizeAtt != null && ("true".equals(normalizeAtt.trim()) || "1".equals(normalizeAtt.trim()));
        String ignoreAtt = assertion.getAttributeValue(new QName("ignore-prefixes"));
        boolean ignorePrefixes = ignoreAtt != null && ("true".equals(ignoreAtt.trim()) || "1".equals(ignoreAtt.trim()));
        String xmlVersion = assertion.getAttributeValue(new QName("xml-version"));
        boolean xml11 = "1.1".equals(xmlVersion);
        String comparand = catalogXpc.evaluate("if (@file) then unparsed-text(resolve-uri(@file, base-uri(.))) else string(.)", (XdmItem)assertion).toString();
        if (comparand.startsWith("<?xml")) {
            int index = comparand.indexOf("?>");
            comparand = comparand.substring(index + 2);
        }
        comparand = comparand.trim();
        comparand = comparand.replace("\r\n", "\n");
        if (normalize) {
            comparand = Whitespace.collapseWhitespace((CharSequence)comparand).toString();
        }
        if (comparand.equals(this.serialize(assertXpc.getProcessor(), result))) {
            return true;
        }
        DocumentBuilder builder = assertXpc.getProcessor().newDocumentBuilder();
        if (xml11) {
            assertXpc.getProcessor().setConfigurationProperty("http://saxon.sf.net/feature/xml-version", (Object)"1.1");
        }
        StringReader reader = new StringReader((xml11 ? "<?xml version='1.1'?>" : "") + "<z>" + comparand + "</z>");
        XdmNode expected = builder.build((Source)new StreamSource(reader));
        int flag = 0;
        flag |= 4;
        flag |= 8;
        flag |= 0x400;
        if (!ignorePrefixes) {
            flag |= 1;
            flag |= 2;
        }
        flag |= 0x20;
        if (debug) {
            flag |= 0x80;
        }
        try {
            AxisIterator iter1;
            if (result == null) {
                System.err.println("Result value is null");
                return false;
            }
            XdmValue value = result.value;
            if (value == null) {
                System.err.println("Result value is null (perhaps serialized?)");
                return false;
            }
            Object iter0 = value.size() == 1 && value.itemAt(0) instanceof XdmNode && ((XdmNode)value.itemAt(0)).getNodeKind() == XdmNodeKind.DOCUMENT ? ((XdmNode)value.itemAt(0)).getUnderlyingNode().iterateAxis((byte)3) : value.getUnderlyingValue().iterate();
            boolean success = DeepEqual.deepEquals((SequenceIterator)iter0, (SequenceIterator)(iter1 = ((NodeInfo)expected.axisIterator(Axis.CHILD).next().getUnderlyingValue()).iterateAxis((byte)3)), (AtomicComparer)new GenericAtomicComparer((StringCollator)CodepointCollator.getInstance(), null), (XPathContext)assertXpc.getProcessor().getUnderlyingConfiguration().getConversionContext(), (int)flag);
            if (!success) {
                iter0 = iter0.getAnother();
                iter1 = iter1.getAnother();
                success = DeepEqual.deepEquals((SequenceIterator)(iter0 = new ItemMappingIterator(iter0, (ItemMappingFunction)new RemoveWhitespace())), (SequenceIterator)(iter1 = new ItemMappingIterator((SequenceIterator)iter1, (ItemMappingFunction)new RemoveWhitespace())), (AtomicComparer)new GenericAtomicComparer((StringCollator)CodepointCollator.getInstance(), null), (XPathContext)assertXpc.getProcessor().getUnderlyingConfiguration().getConversionContext(), (int)(flag | 0x10));
                if (success) {
                    this.comment = "OK after ignoring whitespace text";
                }
            }
            if (!success) {
                System.err.println("assert-xml comparison failed");
                if (debug) {
                    System.err.println("assert-xml comparison failed");
                    System.err.println("Reference results:");
                    System.err.println(expected.toString());
                    System.err.println("Actual results:");
                    System.err.println(value.toString());
                }
            }
            return success;
        }
        catch (XPathException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean assertPermutation(XdmNode assertion, SingleResultDoc result, XPathCompiler assertXpc) throws SaxonApiException {
        if (this.isException()) {
            return false;
        }
        try {
            int expectedItems = 0;
            HashSet<AtomicMatchKey> expected = new HashSet<AtomicMatchKey>();
            XPathSelector s = assertXpc.compile("(" + assertion.getStringValue() + ")").load();
            s.setVariable(new QName("result"), result.value);
            CodepointCollator collator = CodepointCollator.getInstance();
            XPathContextMajor context = new XPathContextMajor((Item)StringValue.EMPTY_STRING, assertXpc.getUnderlyingStaticContext().getConfiguration());
            for (XdmItem item : s) {
                ++expectedItems;
                AtomicValue value = (AtomicValue)item.getUnderlyingValue();
                AtomicMatchKey comparable = value.isNaN() ? AtomicSortComparer.COLLATION_KEY_NaN : value.getXPathComparable(false, (StringCollator)collator, context.getImplicitTimezone());
                expected.add(comparable);
            }
            int actualItems = 0;
            for (XdmItem item : this.getPrincipalResult()) {
                ++actualItems;
                AtomicValue value = (AtomicValue)item.getUnderlyingValue();
                AtomicMatchKey comparable = value.isNaN() ? AtomicSortComparer.COLLATION_KEY_NaN : value.getXPathComparable(false, (StringCollator)collator, context.getImplicitTimezone());
                if (expected.contains(comparable)) continue;
                return false;
            }
            return actualItems == expectedItems;
        }
        catch (NoDynamicContextException e) {
            System.err.println("Comparison of results failed - no timezone available");
            return false;
        }
    }

    private boolean assertDeepEq(XdmNode assertion, SingleResultDoc result, XPathCompiler assertXpc) throws SaxonApiException {
        if (this.isException()) {
            return false;
        }
        assertXpc.declareVariable(new QName("result"));
        XPathSelector s = assertXpc.compile("deep-equal($result , (" + assertion.getStringValue() + "))").load();
        s.setVariable(new QName("result"), result.value);
        return ((XdmAtomicValue)s.evaluate()).getBooleanValue();
    }

    private boolean assertEq(XdmNode assertion, SingleResultDoc result, XPathCompiler assertXpc) throws SaxonApiException {
        if (this.isException()) {
            return false;
        }
        assertXpc.declareVariable(new QName("result"));
        XPathSelector s = assertXpc.compile("$result eq " + assertion.getStringValue()).load();
        s.setVariable(new QName("result"), result.value);
        XdmAtomicValue item = (XdmAtomicValue)s.evaluateSingle();
        return item != null && item.getBooleanValue();
    }

    public boolean compareExpectedError(XdmNode assertion) {
        boolean ok;
        String expectedError = assertion.getAttributeValue(new QName("code"));
        QName expectedErrorQ = expectedError.equals("*") ? null : (expectedError.startsWith("Q{") ? QName.fromEQName((String)expectedError) : new QName("err", "http://www.w3.org/2005/xqt-errors", expectedError));
        boolean bl = ok = expectedError.equals("*") || this.getException().getErrorCode() != null && this.getException().getErrorCode().equals((Object)expectedErrorQ) || this.hasReportedError(expectedError);
        if (ok) {
            this.wrongError = null;
        } else if (expectedErrorQ != null && this.errorsReported != null && !this.errorsReported.isEmpty()) {
            FastStringBuffer fsb = new FastStringBuffer(100);
            fsb.append("Expected ");
            fsb.append(expectedErrorQ.getLocalName());
            fsb.append("; got ");
            for (String e : this.errorsReported) {
                fsb.append(e);
                fsb.append("|");
            }
            fsb.setLength(fsb.length() - 1);
            this.wrongError = fsb.toString();
        }
        return ok;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveWhitespace
    implements ItemMappingFunction<NodeInfo, NodeInfo> {
        private RemoveWhitespace() {
        }

        public NodeInfo mapItem(NodeInfo item) throws XPathException {
            boolean isWhite = item.getNodeKind() == 3 && Whitespace.isWhite((CharSequence)item.getStringValueCS());
            return isWhite ? null : item;
        }
    }

    public static class SingleResultDoc {
        public XdmValue value;
        public String serialization;

        public SingleResultDoc() {
        }

        public SingleResultDoc(XdmValue value, String serialization) {
            this.value = value;
            this.serialization = serialization;
        }
    }
}

