# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.operations import Operations
from .operations.accounts_operations import AccountsOperations
from .operations.pools_operations import PoolsOperations
from .operations.volumes_operations import VolumesOperations
from .operations.mount_targets_operations import MountTargetsOperations
from .operations.snapshots_operations import SnapshotsOperations
from . import models


class AzureNetAppFilesManagementClientConfiguration(AzureConfiguration):
    """Configuration for AzureNetAppFilesManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials which uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(AzureNetAppFilesManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-netapp/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class AzureNetAppFilesManagementClient(SDKClient):
    """Microsoft NetApp Azure Resource Provider specification

    :ivar config: Configuration for client.
    :vartype config: AzureNetAppFilesManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.netapp.operations.Operations
    :ivar accounts: Accounts operations
    :vartype accounts: azure.mgmt.netapp.operations.AccountsOperations
    :ivar pools: Pools operations
    :vartype pools: azure.mgmt.netapp.operations.PoolsOperations
    :ivar volumes: Volumes operations
    :vartype volumes: azure.mgmt.netapp.operations.VolumesOperations
    :ivar mount_targets: MountTargets operations
    :vartype mount_targets: azure.mgmt.netapp.operations.MountTargetsOperations
    :ivar snapshots: Snapshots operations
    :vartype snapshots: azure.mgmt.netapp.operations.SnapshotsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials which uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = AzureNetAppFilesManagementClientConfiguration(credentials, subscription_id, base_url)
        super(AzureNetAppFilesManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2017-08-15'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.accounts = AccountsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.pools = PoolsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.volumes = VolumesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.mount_targets = MountTargetsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.snapshots = SnapshotsOperations(
            self._client, self.config, self._serialize, self._deserialize)
