/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.core.lattice.model;

public class LatticeNode {
    private String morph;
    private int posId;
    private double score;
    private int prevIdx;
    private int prevHashcode;

    public String getMorph() {
        return this.morph;
    }

    public void setMorph(String string) {
        this.morph = string;
    }

    public int getPosId() {
        return this.posId;
    }

    public void setPosId(int n) {
        this.posId = n;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double d) {
        this.score = d;
    }

    public int getPrevIdx() {
        return this.prevIdx;
    }

    public void setPrevIdx(int n) {
        this.prevIdx = n;
    }

    public int getPrevHashcode() {
        return this.prevHashcode;
    }

    public void setPrevHashcode(int n) {
        this.prevHashcode = n;
    }

    public String toString() {
        return "LatticeNode [morph=" + this.morph + ", posId=" + this.posId + ", score=" + this.score + ", prevIdx=" + this.prevIdx + ", prevHashcode=" + this.prevHashcode + "]";
    }

    public int hashCode() {
        int n = 31 + (this.morph == null ? 0 : this.morph.hashCode());
        n = n * 31 + this.posId;
        n = n * 31 + this.prevHashcode;
        n = n * 31 + this.prevIdx;
        long l = Double.doubleToLongBits(this.score);
        n = n * 31 + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (LatticeNode)object;
        if (this.morph == null ? ((LatticeNode)object).morph != null : !this.morph.equals(((LatticeNode)object).morph)) {
            return false;
        }
        if (this.posId != ((LatticeNode)object).posId) {
            return false;
        }
        if (this.prevHashcode != ((LatticeNode)object).prevHashcode) {
            return false;
        }
        if (this.prevIdx != ((LatticeNode)object).prevIdx) {
            return false;
        }
        return Double.doubleToLongBits(this.score) == Double.doubleToLongBits(((LatticeNode)object).score);
    }
}

