/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.util;

public class Util {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean valid(String str) {
        return str != null && !str.trim().equals("");
    }

    public static int getTabCnt(String str) {
        int cnt = 0;
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == ' ' || ch == '\t') {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    private static String getTab(int cnt) {
        String tab = "";
        int i = 0;
        while (i < cnt) {
            tab = String.valueOf(tab) + "\t";
            ++i;
        }
        return tab;
    }

    public static String getTabbedString(String string, int tabSize, int width) {
        int cnt = 0;
        if (string == null) {
            return Util.getTab((width - cnt) / tabSize);
        }
        int i = 0;
        int len = string.length();
        while (i < len) {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(string.charAt(i));
            cnt = ub == Character.UnicodeBlock.HANGUL_SYLLABLES || ub == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO ? (cnt += 2) : ++cnt;
            ++i;
        }
        String ret = String.valueOf(string) + Util.getTab((width - cnt) / tabSize);
        if (cnt % tabSize != 0) {
            ret = String.valueOf(ret) + "\t";
        }
        return ret;
    }

    public static final String rplcXMLSpclChar(String src) {
        return src.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\\"", "&quot;").replaceAll("'", "&apos;");
    }
}

