/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.util.common.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileUtil {
    public static List<String> load2List(String filename, String encoding) {
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
            while ((line = br.readLine()) != null) {
                resultList.add(line);
            }
            br.close();
            br = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<String> load2List(String filename, Charset encoding) {
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
            while ((line = br.readLine()) != null) {
                resultList.add(line);
            }
            br.close();
            br = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<String> load2List(String filename) {
        return FileUtil.load2List(filename, "UTF-8");
    }

    public static <T> void writeList(List<T> list, String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            int count = 0;
            for (T line : list) {
                bw.write(line.toString());
                if (count != list.size() - 1) {
                    bw.newLine();
                }
                ++count;
            }
            bw.close();
            bw = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Set<String> load2Set(String filename, String encoding) {
        HashSet<String> resultSet = new HashSet<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                resultSet.add(line);
            }
            br.close();
            br = null;
            line = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    public static Set<String> load2Set(String filename) {
        return FileUtil.load2Set(filename, "UTF-8");
    }

    public static <T> void writeSet(Set<T> set, String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            int count = 0;
            for (T line : set) {
                bw.write(line.toString());
                if (count != set.size() - 1) {
                    bw.newLine();
                }
                ++count;
            }
            bw.close();
            bw = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> load2Map(String filename) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                String[] tmp = line.split("\t");
                if (tmp.length != 2) {
                    System.err.println("FileUtil.load2Map error!");
                    System.err.println("This line can not split by '\t' : " + line);
                }
                resultMap.put(tmp[0], tmp[1]);
                tmp = null;
            }
            br.close();
            br = null;
            Object var3_4 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public static <K, V> void writeMap(Map<K, V> map, String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            Set<Map.Entry<K, V>> mapEntrySet = map.entrySet();
            int count = 0;
            for (Map.Entry<K, V> entry : mapEntrySet) {
                bw.write(entry.getKey().toString());
                bw.write("\t");
                bw.write(entry.getValue().toString());
                if (count != mapEntrySet.size() - 1) {
                    bw.newLine();
                }
                ++count;
            }
            bw.close();
            mapEntrySet = null;
            bw = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getFileNames(String rootPath) {
        File[] files;
        ArrayList<String> filenames = new ArrayList<String>();
        File f = new File(rootPath);
        File[] fileArray = files = f.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                filenames.addAll(FileUtil.getFileNames(file.getAbsolutePath()));
            } else {
                filenames.add(file.getAbsolutePath());
            }
            ++n2;
        }
        files = null;
        f = null;
        return filenames;
    }

    public static List<String> getFileNames(String rootPath, String suffix) {
        File[] files;
        ArrayList<String> filenames = new ArrayList<String>();
        File f = new File(rootPath);
        File[] fileArray = files = f.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                filenames.addAll(FileUtil.getFileNames(file.getAbsolutePath()));
            } else if (file.getName().endsWith(suffix)) {
                filenames.add(file.getAbsolutePath());
            }
            ++n2;
        }
        files = null;
        f = null;
        return filenames;
    }

    public static boolean removeFile(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            return f.delete();
        }
        return false;
    }

    public static boolean makeFile(String filename) {
        File f = new File(filename);
        try {
            return f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean makeFile(String filename, boolean makePath) {
        boolean successMakePath;
        String path = FileUtil.getPath(filename);
        if (makePath && !(successMakePath = FileUtil.makePath(path))) {
            return false;
        }
        path = null;
        return FileUtil.makeFile(filename);
    }

    public static boolean makePath(String path) {
        File f = new File(path);
        boolean successMakePath = f.mkdirs();
        if (successMakePath) {
            return true;
        }
        f = null;
        return false;
    }

    public static String getPath(String filename) {
        String appendSeparator;
        String pathSeparator;
        StringBuffer path = new StringBuffer();
        if (filename.contains("/")) {
            pathSeparator = "/";
            appendSeparator = "/";
        } else {
            pathSeparator = "\\\\";
            appendSeparator = "\\";
        }
        String[] tmp = filename.split(pathSeparator);
        int i = 0;
        while (i < tmp.length - 1) {
            path.append(tmp[i]);
            path.append(appendSeparator);
            ++i;
        }
        tmp = null;
        pathSeparator = null;
        appendSeparator = null;
        if (path.toString().trim().length() == 0) {
            return null;
        }
        return path.toString();
    }

    public static void splitFile(String filename, int splitCount, String suffix) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            int count = 0;
            int suffixNumber = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                if (count == splitCount) {
                    FileUtil.writeList(lines, String.valueOf(filename) + suffix + suffixNumber);
                    count = 0;
                    lines = null;
                    lines = new ArrayList();
                    ++suffixNumber;
                    continue;
                }
                lines.add(line);
                ++count;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

