# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._application_insights_management_client_enums import *


class ComponentsResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ComponentsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicationInsightsComponent(ComponentsResource):
    """An Application Insights component definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: Required. The kind of application that this component refers to, used to customize
     UI. This value is a freeform string, values should typically be one of the following: web, ios,
     other, store, java, phone.
    :type kind: str
    :ivar application_id: The unique ID of your application. This field mirrors the 'Name' field
     and cannot be changed.
    :vartype application_id: str
    :ivar app_id: Application Insights Unique ID for your Application.
    :vartype app_id: str
    :param application_type: Type of application being monitored. Possible values include: "web",
     "other". Default value: "web".
    :type application_type: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ApplicationType
    :param flow_type: Used by the Application Insights system to determine what kind of flow this
     component was created by. This is to be set to 'Bluefield' when creating/updating a component
     via the REST API. Possible values include: "Bluefield". Default value: "Bluefield".
    :type flow_type: str or ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.FlowType
    :param request_source: Describes what tool created this Application Insights component.
     Customers using this API should set this to the default 'rest'. Possible values include:
     "rest". Default value: "rest".
    :type request_source: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.RequestSource
    :ivar instrumentation_key: Application Insights Instrumentation key. A read-only value that
     applications can use to identify the destination for all telemetry sent to Azure Application
     Insights. This value will be supplied upon construction of each new Application Insights
     component.
    :vartype instrumentation_key: str
    :ivar creation_date: Creation Date for the Application Insights component, in ISO 8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar tenant_id: Azure Tenant Id.
    :vartype tenant_id: str
    :param hockey_app_id: The unique application ID created when a new application is added to
     HockeyApp, used for communications with HockeyApp.
    :type hockey_app_id: str
    :ivar hockey_app_token: Token used to authenticate communications with between Application
     Insights and HockeyApp.
    :vartype hockey_app_token: str
    :ivar provisioning_state: Current state of this component: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    :param sampling_percentage: Percentage of the data produced by the application being monitored
     that is being sampled for Application Insights telemetry.
    :type sampling_percentage: float
    :ivar connection_string: Application Insights component connection string.
    :vartype connection_string: str
    :param retention_in_days: Retention period in days.
    :type retention_in_days: int
    :param disable_ip_masking: Disable IP masking.
    :type disable_ip_masking: bool
    :param immediate_purge_data_on30_days: Purge data immediately after 30 days.
    :type immediate_purge_data_on30_days: bool
    :ivar private_link_scoped_resources: List of linked private link scope resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PrivateLinkScopedResource]
    :param public_network_access_for_ingestion: The network access type for accessing Application
     Insights ingestion. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access_for_ingestion: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PublicNetworkAccessType
    :param public_network_access_for_query: The network access type for accessing Application
     Insights query. Possible values include: "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access_for_query: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PublicNetworkAccessType
    :param ingestion_mode: Indicates the flow of the ingestion. Possible values include:
     "ApplicationInsights", "ApplicationInsightsWithDiagnosticSettings", "LogAnalytics". Default
     value: "ApplicationInsights".
    :type ingestion_mode: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.IngestionMode
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'required': True},
        'application_id': {'readonly': True},
        'app_id': {'readonly': True},
        'instrumentation_key': {'readonly': True},
        'creation_date': {'readonly': True},
        'tenant_id': {'readonly': True},
        'hockey_app_token': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'connection_string': {'readonly': True},
        'private_link_scoped_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'application_id': {'key': 'properties.ApplicationId', 'type': 'str'},
        'app_id': {'key': 'properties.AppId', 'type': 'str'},
        'application_type': {'key': 'properties.Application_Type', 'type': 'str'},
        'flow_type': {'key': 'properties.Flow_Type', 'type': 'str'},
        'request_source': {'key': 'properties.Request_Source', 'type': 'str'},
        'instrumentation_key': {'key': 'properties.InstrumentationKey', 'type': 'str'},
        'creation_date': {'key': 'properties.CreationDate', 'type': 'iso-8601'},
        'tenant_id': {'key': 'properties.TenantId', 'type': 'str'},
        'hockey_app_id': {'key': 'properties.HockeyAppId', 'type': 'str'},
        'hockey_app_token': {'key': 'properties.HockeyAppToken', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sampling_percentage': {'key': 'properties.SamplingPercentage', 'type': 'float'},
        'connection_string': {'key': 'properties.ConnectionString', 'type': 'str'},
        'retention_in_days': {'key': 'properties.RetentionInDays', 'type': 'int'},
        'disable_ip_masking': {'key': 'properties.DisableIpMasking', 'type': 'bool'},
        'immediate_purge_data_on30_days': {'key': 'properties.ImmediatePurgeDataOn30Days', 'type': 'bool'},
        'private_link_scoped_resources': {'key': 'properties.PrivateLinkScopedResources', 'type': '[PrivateLinkScopedResource]'},
        'public_network_access_for_ingestion': {'key': 'properties.publicNetworkAccessForIngestion', 'type': 'str'},
        'public_network_access_for_query': {'key': 'properties.publicNetworkAccessForQuery', 'type': 'str'},
        'ingestion_mode': {'key': 'properties.IngestionMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: str,
        tags: Optional[Dict[str, str]] = None,
        application_type: Optional[Union[str, "ApplicationType"]] = "web",
        flow_type: Optional[Union[str, "FlowType"]] = "Bluefield",
        request_source: Optional[Union[str, "RequestSource"]] = "rest",
        hockey_app_id: Optional[str] = None,
        sampling_percentage: Optional[float] = None,
        retention_in_days: Optional[int] = 90,
        disable_ip_masking: Optional[bool] = None,
        immediate_purge_data_on30_days: Optional[bool] = None,
        public_network_access_for_ingestion: Optional[Union[str, "PublicNetworkAccessType"]] = "Enabled",
        public_network_access_for_query: Optional[Union[str, "PublicNetworkAccessType"]] = "Enabled",
        ingestion_mode: Optional[Union[str, "IngestionMode"]] = "ApplicationInsights",
        **kwargs
    ):
        super(ApplicationInsightsComponent, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = kind
        self.application_id = None
        self.app_id = None
        self.application_type = application_type
        self.flow_type = flow_type
        self.request_source = request_source
        self.instrumentation_key = None
        self.creation_date = None
        self.tenant_id = None
        self.hockey_app_id = hockey_app_id
        self.hockey_app_token = None
        self.provisioning_state = None
        self.sampling_percentage = sampling_percentage
        self.connection_string = None
        self.retention_in_days = retention_in_days
        self.disable_ip_masking = disable_ip_masking
        self.immediate_purge_data_on30_days = immediate_purge_data_on30_days
        self.private_link_scoped_resources = None
        self.public_network_access_for_ingestion = public_network_access_for_ingestion
        self.public_network_access_for_query = public_network_access_for_query
        self.ingestion_mode = ingestion_mode


class ApplicationInsightsComponentListResult(msrest.serialization.Model):
    """Describes the list of Application Insights Resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of Application Insights component definitions.
    :type value:
     list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ApplicationInsightsComponent]
    :param next_link: The URI to get the next set of Application Insights component definitions if
     too many components where returned in the result set.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationInsightsComponent]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ApplicationInsightsComponent"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationInsightsComponentListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationInsightsComponentProactiveDetectionConfiguration(msrest.serialization.Model):
    """A ProactiveDetection configuration definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :param name: Azure resource name.
    :type name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :ivar name_properties_name: The rule name.
    :vartype name_properties_name: str
    :param enabled: A flag that indicates whether this rule is enabled by the user.
    :type enabled: bool
    :param send_emails_to_subscription_owners: A flag that indicated whether notifications on this
     rule should be sent to subscription owners.
    :type send_emails_to_subscription_owners: bool
    :param custom_emails: Custom email addresses for this rule notifications.
    :type custom_emails: list[str]
    :ivar last_updated_time: The last time this rule was updated.
    :vartype last_updated_time: str
    :param rule_definitions: Static definitions of the ProactiveDetection configuration rule (same
     values for all components).
    :type rule_definitions:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name_properties_name': {'key': 'properties.Name', 'type': 'str'},
        'enabled': {'key': 'properties.Enabled', 'type': 'bool'},
        'send_emails_to_subscription_owners': {'key': 'properties.SendEmailsToSubscriptionOwners', 'type': 'bool'},
        'custom_emails': {'key': 'properties.CustomEmails', 'type': '[str]'},
        'last_updated_time': {'key': 'properties.LastUpdatedTime', 'type': 'str'},
        'rule_definitions': {'key': 'properties.RuleDefinitions', 'type': 'ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        enabled: Optional[bool] = None,
        send_emails_to_subscription_owners: Optional[bool] = None,
        custom_emails: Optional[List[str]] = None,
        rule_definitions: Optional["ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions"] = None,
        **kwargs
    ):
        super(ApplicationInsightsComponentProactiveDetectionConfiguration, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = None
        self.location = location
        self.name_properties_name = None
        self.enabled = enabled
        self.send_emails_to_subscription_owners = send_emails_to_subscription_owners
        self.custom_emails = custom_emails
        self.last_updated_time = None
        self.rule_definitions = rule_definitions


class ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions(msrest.serialization.Model):
    """Static definitions of the ProactiveDetection configuration rule (same values for all components).

    :param name: The rule name.
    :type name: str
    :param display_name: The rule name as it is displayed in UI.
    :type display_name: str
    :param description: The rule description.
    :type description: str
    :param help_url: URL which displays additional info about the proactive detection rule.
    :type help_url: str
    :param is_hidden: A flag indicating whether the rule is hidden (from the UI).
    :type is_hidden: bool
    :param is_enabled_by_default: A flag indicating whether the rule is enabled by default.
    :type is_enabled_by_default: bool
    :param is_in_preview: A flag indicating whether the rule is in preview.
    :type is_in_preview: bool
    :param supports_email_notifications: A flag indicating whether email notifications are
     supported for detections for this rule.
    :type supports_email_notifications: bool
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'help_url': {'key': 'HelpUrl', 'type': 'str'},
        'is_hidden': {'key': 'IsHidden', 'type': 'bool'},
        'is_enabled_by_default': {'key': 'IsEnabledByDefault', 'type': 'bool'},
        'is_in_preview': {'key': 'IsInPreview', 'type': 'bool'},
        'supports_email_notifications': {'key': 'SupportsEmailNotifications', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        help_url: Optional[str] = None,
        is_hidden: Optional[bool] = None,
        is_enabled_by_default: Optional[bool] = None,
        is_in_preview: Optional[bool] = None,
        supports_email_notifications: Optional[bool] = None,
        **kwargs
    ):
        super(ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitions, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.description = description
        self.help_url = help_url
        self.is_hidden = is_hidden
        self.is_enabled_by_default = is_enabled_by_default
        self.is_in_preview = is_in_preview
        self.supports_email_notifications = supports_email_notifications


class ComponentPurgeBody(msrest.serialization.Model):
    """Describes the body of a purge request for an App Insights component.

    All required parameters must be populated in order to send to Azure.

    :param table: Required. Table from which to purge data.
    :type table: str
    :param filters: Required. The set of columns and filters (queries) to run over them to purge
     the resulting data.
    :type filters:
     list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.ComponentPurgeBodyFilters]
    """

    _validation = {
        'table': {'required': True},
        'filters': {'required': True},
    }

    _attribute_map = {
        'table': {'key': 'table', 'type': 'str'},
        'filters': {'key': 'filters', 'type': '[ComponentPurgeBodyFilters]'},
    }

    def __init__(
        self,
        *,
        table: str,
        filters: List["ComponentPurgeBodyFilters"],
        **kwargs
    ):
        super(ComponentPurgeBody, self).__init__(**kwargs)
        self.table = table
        self.filters = filters


class ComponentPurgeBodyFilters(msrest.serialization.Model):
    """User-defined filters to return data which will be purged from the table.

    :param column: The column of the table over which the given query should run.
    :type column: str
    :param operator: A query operator to evaluate over the provided column and value(s). Supported
     operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as they would
     in a KQL query.
    :type operator: str
    :param value: the value for the operator to function over. This can be a number (e.g., > 100),
     a string (timestamp >= '2017-09-01') or array of values.
    :type value: any
    :param key: When filtering over custom dimensions, this key will be used as the name of the
     custom dimension.
    :type key: str
    """

    _attribute_map = {
        'column': {'key': 'column', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        column: Optional[str] = None,
        operator: Optional[str] = None,
        value: Optional[Any] = None,
        key: Optional[str] = None,
        **kwargs
    ):
        super(ComponentPurgeBodyFilters, self).__init__(**kwargs)
        self.column = column
        self.operator = operator
        self.value = value
        self.key = key


class ComponentPurgeResponse(msrest.serialization.Model):
    """Response containing operationId for a specific purge action.

    All required parameters must be populated in order to send to Azure.

    :param operation_id: Required. Id to use when querying for status for a particular purge
     operation.
    :type operation_id: str
    """

    _validation = {
        'operation_id': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        **kwargs
    ):
        super(ComponentPurgeResponse, self).__init__(**kwargs)
        self.operation_id = operation_id


class ComponentPurgeStatusResponse(msrest.serialization.Model):
    """Response containing status for a specific purge operation.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Status of the operation represented by the requested Id. Possible
     values include: "pending", "completed".
    :type status: str or ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.PurgeState
    """

    _validation = {
        'status': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "PurgeState"],
        **kwargs
    ):
        super(ComponentPurgeStatusResponse, self).__init__(**kwargs)
        self.status = status


class HeaderField(msrest.serialization.Model):
    """A header to add to the WebTest.

    :param header_field_name: The name of the header.
    :type header_field_name: str
    :param header_field_value: The value of the header.
    :type header_field_value: str
    """

    _attribute_map = {
        'header_field_name': {'key': 'key', 'type': 'str'},
        'header_field_value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        header_field_name: Optional[str] = None,
        header_field_value: Optional[str] = None,
        **kwargs
    ):
        super(HeaderField, self).__init__(**kwargs)
        self.header_field_name = header_field_name
        self.header_field_value = header_field_value


class Operation(msrest.serialization.Model):
    """Represents an operation returned by the GetOperations request.

    :param name: Name of the operation.
    :type name: str
    :param display: Display name of the operation.
    :type display: ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.OperationInfo
    :param origin: Origin of the operation.
    :type origin: str
    :param properties: Properties of the operation.
    :type properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationInfo'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationInfo"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationInfo(msrest.serialization.Model):
    """Information about an operation.

    :param provider: Name of the provider.
    :type provider: str
    :param resource: Name of the resource type.
    :type resource: str
    :param operation: Name of the operation.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationInfo, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsListResult(msrest.serialization.Model):
    """Result of the List Operations operation.

    :param value: A collection of operations.
    :type value: list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkScopedResource(msrest.serialization.Model):
    """The private link scope resource reference.

    :param resource_id: The full resource Id of the private link scope resource.
    :type resource_id: str
    :param scope_id: The private link scope unique Identifier.
    :type scope_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'ResourceId', 'type': 'str'},
        'scope_id': {'key': 'ScopeId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        scope_id: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkScopedResource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.scope_id = scope_id


class TagsResource(msrest.serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a WebTest instance.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TagsResource, self).__init__(**kwargs)
        self.tags = tags


class WebtestsResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(WebtestsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class WebTest(WebtestsResource):
    """An Application Insights WebTest definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: The kind of WebTest that this web test watches. Choices are ping and multistep.
     Possible values include: "ping", "multistep". Default value: "ping".
    :type kind: str or ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestKind
    :param synthetic_monitor_id: Unique ID of this WebTest. This is typically the same value as the
     Name field.
    :type synthetic_monitor_id: str
    :param web_test_name: User defined name if this WebTest.
    :type web_test_name: str
    :param description: User defined description for this WebTest.
    :type description: str
    :param enabled: Is the test actively being monitored.
    :type enabled: bool
    :param frequency: Interval in seconds between test runs for this WebTest. Default value is 300.
    :type frequency: int
    :param timeout: Seconds until this WebTest will timeout and fail. Default value is 30.
    :type timeout: int
    :param web_test_kind: The kind of web test this is, valid choices are ping, multistep, basic,
     and standard. Possible values include: "ping", "multistep", "basic", "standard". Default value:
     "ping".
    :type web_test_kind: str or
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestKindEnum
    :param retry_enabled: Allow for retries should this WebTest fail.
    :type retry_enabled: bool
    :param locations: A list of where to physically run the tests from to give global coverage for
     accessibility of your application.
    :type locations:
     list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestGeolocation]
    :param configuration: An XML configuration specification for a WebTest.
    :type configuration:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesConfiguration
    :ivar provisioning_state: Current state of this component, whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    :param request: The collection of request properties.
    :type request:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesRequest
    :param validation_rules: The collection of validation rule properties.
    :type validation_rules:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesValidationRules
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'synthetic_monitor_id': {'key': 'properties.SyntheticMonitorId', 'type': 'str'},
        'web_test_name': {'key': 'properties.Name', 'type': 'str'},
        'description': {'key': 'properties.Description', 'type': 'str'},
        'enabled': {'key': 'properties.Enabled', 'type': 'bool'},
        'frequency': {'key': 'properties.Frequency', 'type': 'int'},
        'timeout': {'key': 'properties.Timeout', 'type': 'int'},
        'web_test_kind': {'key': 'properties.Kind', 'type': 'str'},
        'retry_enabled': {'key': 'properties.RetryEnabled', 'type': 'bool'},
        'locations': {'key': 'properties.Locations', 'type': '[WebTestGeolocation]'},
        'configuration': {'key': 'properties.Configuration', 'type': 'WebTestPropertiesConfiguration'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'request': {'key': 'properties.Request', 'type': 'WebTestPropertiesRequest'},
        'validation_rules': {'key': 'properties.ValidationRules', 'type': 'WebTestPropertiesValidationRules'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "WebTestKind"]] = "ping",
        synthetic_monitor_id: Optional[str] = None,
        web_test_name: Optional[str] = None,
        description: Optional[str] = None,
        enabled: Optional[bool] = None,
        frequency: Optional[int] = 300,
        timeout: Optional[int] = 30,
        web_test_kind: Optional[Union[str, "WebTestKindEnum"]] = "ping",
        retry_enabled: Optional[bool] = None,
        locations: Optional[List["WebTestGeolocation"]] = None,
        configuration: Optional["WebTestPropertiesConfiguration"] = None,
        request: Optional["WebTestPropertiesRequest"] = None,
        validation_rules: Optional["WebTestPropertiesValidationRules"] = None,
        **kwargs
    ):
        super(WebTest, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = kind
        self.synthetic_monitor_id = synthetic_monitor_id
        self.web_test_name = web_test_name
        self.description = description
        self.enabled = enabled
        self.frequency = frequency
        self.timeout = timeout
        self.web_test_kind = web_test_kind
        self.retry_enabled = retry_enabled
        self.locations = locations
        self.configuration = configuration
        self.provisioning_state = None
        self.request = request
        self.validation_rules = validation_rules


class WebTestGeolocation(msrest.serialization.Model):
    """Geo-physical location to run a WebTest from. You must specify one or more locations for the test to run from.

    :param location: Location ID for the WebTest to run from.
    :type location: str
    """

    _attribute_map = {
        'location': {'key': 'Id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        super(WebTestGeolocation, self).__init__(**kwargs)
        self.location = location


class WebTestListResult(msrest.serialization.Model):
    """A list of 0 or more Application Insights WebTest definitions.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Set of Application Insights WebTest definitions.
    :type value: list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTest]
    :param next_link: The link to get the next part of the returned list of WebTest, should the
     return set be too large for a single request. May be null.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebTest]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["WebTest"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(WebTestListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WebTestPropertiesConfiguration(msrest.serialization.Model):
    """An XML configuration specification for a WebTest.

    :param web_test: The XML specification of a WebTest to run against an application.
    :type web_test: str
    """

    _attribute_map = {
        'web_test': {'key': 'WebTest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        web_test: Optional[str] = None,
        **kwargs
    ):
        super(WebTestPropertiesConfiguration, self).__init__(**kwargs)
        self.web_test = web_test


class WebTestPropertiesRequest(msrest.serialization.Model):
    """The collection of request properties.

    :param request_url: Url location to test.
    :type request_url: str
    :param headers: List of headers and their values to add to the WebTest call.
    :type headers: list[~azure.mgmt.applicationinsights.v2018_05_01_preview.models.HeaderField]
    :param http_verb: Http verb to use for this web test.
    :type http_verb: str
    :param request_body: Base64 encoded string body to send with this web test.
    :type request_body: str
    :param parse_dependent_requests: Parse Dependent request for this WebTest.
    :type parse_dependent_requests: bool
    :param follow_redirects: Follow redirects for this web test.
    :type follow_redirects: bool
    """

    _attribute_map = {
        'request_url': {'key': 'RequestUrl', 'type': 'str'},
        'headers': {'key': 'Headers', 'type': '[HeaderField]'},
        'http_verb': {'key': 'HttpVerb', 'type': 'str'},
        'request_body': {'key': 'RequestBody', 'type': 'str'},
        'parse_dependent_requests': {'key': 'ParseDependentRequests', 'type': 'bool'},
        'follow_redirects': {'key': 'FollowRedirects', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        request_url: Optional[str] = None,
        headers: Optional[List["HeaderField"]] = None,
        http_verb: Optional[str] = None,
        request_body: Optional[str] = None,
        parse_dependent_requests: Optional[bool] = None,
        follow_redirects: Optional[bool] = None,
        **kwargs
    ):
        super(WebTestPropertiesRequest, self).__init__(**kwargs)
        self.request_url = request_url
        self.headers = headers
        self.http_verb = http_verb
        self.request_body = request_body
        self.parse_dependent_requests = parse_dependent_requests
        self.follow_redirects = follow_redirects


class WebTestPropertiesValidationRules(msrest.serialization.Model):
    """The collection of validation rule properties.

    :param content_validation: The collection of content validation properties.
    :type content_validation:
     ~azure.mgmt.applicationinsights.v2018_05_01_preview.models.WebTestPropertiesValidationRulesContentValidation
    :param ssl_check: Checks to see if the SSL cert is still valid.
    :type ssl_check: bool
    :param ssl_cert_remaining_lifetime_check: A number of days to check still remain before the the
     existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
    :type ssl_cert_remaining_lifetime_check: int
    :param expected_http_status_code: Validate that the WebTest returns the http status code
     provided.
    :type expected_http_status_code: int
    :param ignore_https_status_code: When set, validation will ignore the status code.
    :type ignore_https_status_code: bool
    """

    _attribute_map = {
        'content_validation': {'key': 'ContentValidation', 'type': 'WebTestPropertiesValidationRulesContentValidation'},
        'ssl_check': {'key': 'SSLCheck', 'type': 'bool'},
        'ssl_cert_remaining_lifetime_check': {'key': 'SSLCertRemainingLifetimeCheck', 'type': 'int'},
        'expected_http_status_code': {'key': 'ExpectedHttpStatusCode', 'type': 'int'},
        'ignore_https_status_code': {'key': 'IgnoreHttpsStatusCode', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        content_validation: Optional["WebTestPropertiesValidationRulesContentValidation"] = None,
        ssl_check: Optional[bool] = None,
        ssl_cert_remaining_lifetime_check: Optional[int] = None,
        expected_http_status_code: Optional[int] = None,
        ignore_https_status_code: Optional[bool] = None,
        **kwargs
    ):
        super(WebTestPropertiesValidationRules, self).__init__(**kwargs)
        self.content_validation = content_validation
        self.ssl_check = ssl_check
        self.ssl_cert_remaining_lifetime_check = ssl_cert_remaining_lifetime_check
        self.expected_http_status_code = expected_http_status_code
        self.ignore_https_status_code = ignore_https_status_code


class WebTestPropertiesValidationRulesContentValidation(msrest.serialization.Model):
    """The collection of content validation properties.

    :param content_match: Content to look for in the return of the WebTest.  Must not be null or
     empty.
    :type content_match: str
    :param ignore_case: When set, this value makes the ContentMatch validation case insensitive.
    :type ignore_case: bool
    :param pass_if_text_found: When true, validation will pass if there is a match for the
     ContentMatch string.  If false, validation will fail if there is a match.
    :type pass_if_text_found: bool
    """

    _attribute_map = {
        'content_match': {'key': 'ContentMatch', 'type': 'str'},
        'ignore_case': {'key': 'IgnoreCase', 'type': 'bool'},
        'pass_if_text_found': {'key': 'PassIfTextFound', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        content_match: Optional[str] = None,
        ignore_case: Optional[bool] = None,
        pass_if_text_found: Optional[bool] = None,
        **kwargs
    ):
        super(WebTestPropertiesValidationRulesContentValidation, self).__init__(**kwargs)
        self.content_match = content_match
        self.ignore_case = ignore_case
        self.pass_if_text_found = pass_if_text_found
