/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.dic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.snu.ids.ha.constants.Condition;
import org.snu.ids.ha.constants.POSTag;
import org.snu.ids.ha.dic.DicReader;
import org.snu.ids.ha.dic.RawDicFileReader;
import org.snu.ids.ha.dic.RawDicReader;
import org.snu.ids.ha.dic.SimpleDicFileReader;
import org.snu.ids.ha.dic.SimpleDicReader;
import org.snu.ids.ha.dic.SpacingPDDictionary;
import org.snu.ids.ha.ma.MCandidate;
import org.snu.ids.ha.ma.MExpression;
import org.snu.ids.ha.ma.Morpheme;
import org.snu.ids.ha.util.Hangul;
import org.snu.ids.ha.util.StringSet;
import org.snu.ids.ha.util.Timer;
import org.snu.ids.ha.util.Util;

public class Dictionary {
    private static Dictionary dictionary = null;
    static boolean isLoading = false;
    private final Hashtable<String, MExpression> table = new Hashtable(530000);
    private List<MExpression> meList = null;
    private final Hashtable<String, String[]> compNounTable = new Hashtable();
    private final HashSet<String> verbStemSet = new HashSet();
    private int maxLen = 0;
    static final StringSet MO_SET1 = new StringSet(new String[]{"\u314f", "\u3153", "\u3150", "\u3154"});
    static final StringSet MO_SET2 = new StringSet(new String[]{"\u3157", "\u315c", "\u3161"});

    public static final synchronized Dictionary getInstance() {
        if (!isLoading && dictionary == null) {
            isLoading = true;
            dictionary = new Dictionary();
            isLoading = false;
        }
        return dictionary;
    }

    protected Dictionary() {
        Timer timer = new Timer();
        try {
            try {
                timer.start();
                this.loadDic();
            }
            catch (Exception e) {
                e.printStackTrace();
                timer.stop();
                timer.printMsg("Dictionary Loading Time");
                System.out.println("Loaded Item " + this.table.size());
            }
        }
        finally {
            timer.stop();
            timer.printMsg("Dictionary Loading Time");
            System.out.println("Loaded Item " + this.table.size());
        }
    }

    public static void reload() {
        if (!isLoading && dictionary != null) {
            Timer timer = new Timer();
            try {
                try {
                    System.out.println("reloading");
                    timer.start();
                    dictionary.clear();
                    dictionary.loadDic();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    timer.stop();
                    timer.printMsg("Dictionary Loading Time");
                    System.out.println("Loaded Item " + Dictionary.dictionary.table.size());
                }
            }
            finally {
                timer.stop();
                timer.printMsg("Dictionary Loading Time");
                System.out.println("Loaded Item " + Dictionary.dictionary.table.size());
            }
        }
    }

    public static void reload(List<DicReader> dicReadList) {
        if (!isLoading && dictionary != null) {
            Timer timer = new Timer();
            try {
                try {
                    System.out.println("reloading");
                    timer.start();
                    dictionary.clear();
                    int i = 0;
                    while (i < dicReadList.size()) {
                        dictionary.load(dicReadList.get(i));
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    timer.stop();
                    timer.printMsg("Dictionary Loading Time");
                    System.out.println("Loaded Item " + Dictionary.dictionary.table.size());
                }
            }
            finally {
                timer.stop();
                timer.printMsg("Dictionary Loading Time");
                System.out.println("Loaded Item " + Dictionary.dictionary.table.size());
            }
        }
    }

    public void clear() {
        this.table.clear();
        this.compNounTable.clear();
        this.verbStemSet.clear();
        this.maxLen = 0;
    }

    public static MCandidate getVerbBasicMC(String string, String posTag) throws Exception {
        String stem = null;
        stem = string.charAt(string.length() - 1) == '\ub2e4' ? string.substring(0, string.length() - 1) : string;
        String exp = stem;
        MCandidate mCandidate = new MCandidate(exp, posTag);
        mCandidate.setCandDicLen((byte)exp.length());
        mCandidate.setExp(exp);
        return mCandidate;
    }

    public static List<MCandidate> getVerbExtendedMC(MCandidate mCandidate) {
        ArrayList<MCandidate> ret = new ArrayList<MCandidate>();
        String stem = mCandidate.getExp();
        int stemLen = stem.length();
        String preStem = stem.substring(0, stemLen - 1);
        char lastCh = stem.charAt(stemLen - 1);
        char preLastCh = '\u0000';
        char mo = '\u0000';
        Hangul lastHg = Hangul.split(lastCh);
        Hangul preLastHg = null;
        if (stemLen > 1) {
            preLastCh = stem.charAt(stemLen - 2);
            preLastHg = Hangul.split(preLastCh);
        } else {
            preLastCh = '\u0000';
        }
        String exp = null;
        MCandidate mCandidateClone = null;
        if (stem.length() == 1 && !lastHg.hasJong() && lastHg.cho != '\u314e') {
            exp = stem;
            if (lastHg.jung == '\u314f') {
                mCandidateClone = mCandidate.copy();
                mCandidateClone.add(new Morpheme("\uc544", POSTag.ECS));
                mCandidateClone.setExp(exp);
                mCandidateClone.clearHavingCondition();
                mCandidateClone.initHavingCond(exp);
                mCandidateClone.addHavingCond(Condition.AH);
                mCandidateClone.setRealDicLen((byte)exp.length());
                ret.add(mCandidateClone);
            } else if (lastHg.jung == '\u3153') {
                mCandidateClone = mCandidate.copy();
                mCandidateClone.add(new Morpheme("\uc5b4", POSTag.ECS));
                mCandidateClone.setExp(exp);
                mCandidateClone.clearHavingCondition();
                mCandidateClone.initHavingCond(exp);
                mCandidateClone.addHavingCond(Condition.AH);
                mCandidateClone.setRealDicLen((byte)exp.length());
                ret.add(mCandidateClone);
            }
        }
        if (lastCh == '\ucc2e' || lastCh == '\uc796') {
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, '\u3134');
            mCandidateClone.setExp(exp);
            mCandidateClone.setRealDicLen((byte)exp.length());
            mCandidateClone.setExp(exp);
            ret.add(mCandidateClone);
        }
        if (lastCh == '\ud558') {
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + "\ud588";
            mCandidateClone.add(new Morpheme("\uc5c8", POSTag.EPT));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.EUT);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + "\ud574";
            mCandidateClone.add(new Morpheme("\uc5b4", POSTag.ECS));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.AH);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + "\ud574";
            mCandidateClone.add(new Morpheme("\uc5b4", POSTag.EFN));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.AH);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            if (mCandidate.isTagOf(POSTag.VA | POSTag.VXA)) {
                mCandidateClone = mCandidate.copy();
                exp = String.valueOf(preStem) + "\uce58";
                mCandidateClone.add(new Morpheme("\uc9c0", POSTag.ECS));
                mCandidateClone.setExp(exp);
                mCandidateClone.clearHavingCondition();
                mCandidateClone.initHavingCond(exp);
                mCandidateClone.setRealDicLen((byte)exp.length());
                ret.add(mCandidateClone);
            }
        } else if (!lastHg.hasJong() && lastHg.jung == '\u3163') {
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, '\u3155', '\u3146');
            mCandidateClone.add(new Morpheme("\uc5c8", POSTag.EPT));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.EUT);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, '\u3155', ' ');
            mCandidateClone.add(new Morpheme("\uc5b4", POSTag.ECS));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.MOEUM | Condition.EUMSEONG | Condition.AH);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        } else if (!lastHg.hasJong() && MO_SET1.contains(lastHg.jung)) {
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, '\u3146');
            mCandidateClone.add(new Morpheme("\uc5c8", POSTag.EPT));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.EUT);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        } else if (lastCh == '\ub974') {
            mCandidateClone = mCandidate.copy();
            mCandidateClone.clearHavingCondition();
            if (preLastCh == '\ub530') {
                exp = String.valueOf(preStem) + "\ub790";
                mCandidateClone.add(new Morpheme("\uc558", POSTag.EPT));
                mCandidateClone.addHavingCond(Condition.EUT);
            } else if (preLastCh == '\ud478') {
                exp = String.valueOf(stem) + "\ub800";
                mCandidateClone.add(new Morpheme("\uc5c8", POSTag.EPT));
                mCandidateClone.addHavingCond(Condition.EUT);
            } else {
                mo = Dictionary.getMoeum(lastHg, preLastHg);
                exp = String.valueOf(stem.substring(0, stemLen - 2)) + Hangul.combine(preLastHg.cho, preLastHg.jung, '\u3139') + Hangul.combine(lastHg.cho, mo, '\u3146');
                if (mo == '\u314f') {
                    mCandidateClone.add(new Morpheme("\uc558", POSTag.EPT));
                } else {
                    mCandidateClone.add(new Morpheme("\uc5c8", POSTag.EPT));
                }
                mCandidateClone.addHavingCond(Condition.EUT);
            }
            mCandidateClone.setExp(exp);
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            mCandidateClone.clearHavingCondition();
            if (preLastCh == '\ub530') {
                exp = String.valueOf(preStem) + "\ub77c";
                mCandidateClone.add(new Morpheme("\uc544", POSTag.ECS));
                mCandidateClone.addHavingCond(Condition.AH);
            } else if (preLastCh == '\ud478') {
                exp = String.valueOf(stem) + "\ub7ec";
                mCandidateClone.add(new Morpheme("\uc5b4", POSTag.ECS));
                mCandidateClone.addHavingCond(Condition.AH);
            } else {
                mo = Dictionary.getMoeum(lastHg, preLastHg);
                exp = String.valueOf(stem.substring(0, stemLen - 2)) + Hangul.combine(preLastHg.cho, preLastHg.jung, '\u3139') + Hangul.combine(lastHg.cho, mo, ' ');
                if (mo == '\u314f') {
                    mCandidateClone.add(new Morpheme("\uc544", POSTag.ECS));
                    mCandidateClone.addHavingCond(Condition.AH);
                } else {
                    mCandidateClone.add(new Morpheme("\uc5b4", POSTag.ECS));
                    mCandidateClone.addHavingCond(Condition.AH);
                }
            }
            mCandidateClone.setExp(exp);
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        } else if (!lastHg.hasJong() && lastHg.jung == '\u3161') {
            mo = Dictionary.getMoeum(lastHg, preLastHg);
            mCandidateClone = mCandidate.copy();
            mCandidateClone.clearHavingCondition();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, mo, '\u3146');
            if (mo == '\u314f') {
                mCandidateClone.add(new Morpheme("\uc558", POSTag.EPT));
                mCandidateClone.addHavingCond(Condition.EUT);
            } else {
                mCandidateClone.add(new Morpheme("\uc5c8", POSTag.EPT));
                mCandidateClone.addHavingCond(Condition.EUT);
            }
            mCandidateClone.setExp(exp);
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            mCandidateClone.clearHavingCondition();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, mo, ' ');
            if (mo == '\u314f') {
                mCandidateClone.add(new Morpheme("\uc544", POSTag.ECS));
                mCandidateClone.addHavingCond(Condition.AH);
            } else {
                mCandidateClone.add(new Morpheme("\uc5b4", POSTag.ECS));
                mCandidateClone.addHavingCond(Condition.AH);
            }
            mCandidateClone.setExp(exp);
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        } else if (!lastHg.hasJong() && MO_SET2.contains(lastHg.jung)) {
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, Dictionary.getMoeum(lastHg, preLastHg), '\u3146');
            if (lastHg.jung == '\u315c') {
                mCandidateClone.add(new Morpheme("\uc5c8", POSTag.EPT));
            } else {
                mCandidateClone.add(new Morpheme("\uc558", POSTag.EPT));
            }
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.EUT);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, Dictionary.getMoeum(lastHg, preLastHg), ' ');
            if (lastHg.jung == '\u315c') {
                mCandidateClone.add(new Morpheme("\uc5b4", POSTag.ECS));
            } else {
                mCandidateClone.add(new Morpheme("\uc544", POSTag.ECS));
            }
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.AH);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        } else if (!lastHg.hasJong() && lastHg.jung == '\u315a') {
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, '\u3159', ' ');
            mCandidateClone.add(new Morpheme("\uc5b4", POSTag.ECS));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.AH);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, '\u3159', '\u3146');
            mCandidateClone.add(new Morpheme("\uc5c8", POSTag.EPT));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.EUT);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        }
        if ("\uac11\uac81\uacb9\uacf1\uad7d\uae41\uae5d\uaecd\uaf3d\ub0a9\ub215\ub2f5\ub365\ub3d5\ub461\ub541\ub5b1\ub78d\ub7fd\ub835\ub86d\ub9bd\ub9d9\ub9f5\ubc09\ubccd\uc12d\uc27d\uc2b5\uc5fd\uc90d\ucb59\ucda5\ud0d1".indexOf(lastCh) > -1) {
            char bChar = Hangul.combine(lastHg.cho, lastHg.jung, ' ');
            if (lastCh == '\ub7fd') {
                mCandidateClone = mCandidate.copy();
                exp = String.valueOf(preStem) + '\ub7f0';
                mCandidateClone.add(new Morpheme("\u3134", POSTag.ETD));
                mCandidateClone.setExp(exp);
                mCandidateClone.clearHavingCondition();
                mCandidateClone.initHavingCond(exp);
                mCandidateClone.setRealDicLen((byte)exp.length());
                ret.add(mCandidateClone);
            }
            mCandidateClone = mCandidate.copy();
            if (lastHg.jung == '\u3157') {
                mo = '\u3158';
                mCandidateClone.add(new Morpheme("\uc544", POSTag.ECS));
            } else {
                mo = '\u315d';
                mCandidateClone.add(new Morpheme("\uc5b4", POSTag.ECS));
            }
            exp = String.valueOf(preStem) + bChar + Hangul.combine('\u3147', mo, ' ');
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.AH);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            mCandidateClone.clearHavingCondition();
            if (lastHg.jung == '\u3157') {
                mo = '\u3158';
                mCandidateClone.add(new Morpheme("\uc558", POSTag.EPT));
            } else {
                mo = '\u315d';
                mCandidateClone.add(new Morpheme("\uc5c8", POSTag.EPT));
            }
            exp = String.valueOf(preStem) + bChar + Hangul.combine('\u3147', mo, '\u3146');
            mCandidateClone.setExp(exp);
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.EUT);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + bChar + '\uc6b0';
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.MINUS_BIEUB);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + bChar + '\uc6b4';
            mCandidateClone.add(new Morpheme("\u3134", POSTag.ETD));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            mCandidateClone.add(new Morpheme("\u3139", POSTag.ETD));
            exp = String.valueOf(preStem) + bChar + '\uc6b8';
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            mCandidateClone.add(new Morpheme("\u3141", POSTag.ETN));
            exp = String.valueOf(preStem) + bChar + '\uc6c0';
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        } else if ("\uc813\uc9d3\uae0b\ub0ab\ubd93\uc787".indexOf(lastCh) > -1) {
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, ' ');
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.MINUS_SIOT);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        } else if (lastHg.jong == '\u3137') {
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, '\u3139');
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.addHavingCond(Condition.MINUS_SIOT);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        } else if (!lastHg.hasJong() || lastHg.jong == '\u3139' || lastHg.jong == '\u314e') {
            mCandidateClone = mCandidate.copy();
            mCandidateClone.add(new Morpheme("\u3134", POSTag.ETD));
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, '\u3134');
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, '\u3139');
            mCandidateClone.add(new Morpheme("\u3139", POSTag.ETD));
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setRealDicLen((byte)exp.length());
            ret.add(mCandidateClone);
            if (lastHg.jong == '\u3139') {
                mCandidateClone = mCandidate.copy();
                exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, '\u313b');
                mCandidateClone.add(new Morpheme("\u3141", POSTag.ETN));
                mCandidateClone.setExp(exp);
                mCandidateClone.clearHavingCondition();
                mCandidateClone.initHavingCond(exp);
                mCandidateClone.setRealDicLen((byte)exp.length());
                ret.add(mCandidateClone);
                mCandidateClone = mCandidate.copy();
                exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, ' ');
                mCandidateClone.setExp(exp);
                mCandidateClone.clearHavingCondition();
                mCandidateClone.initHavingCond(exp);
                mCandidateClone.addHavingCond(Condition.MINUS_LIEUL);
                mCandidateClone.setCandDicLen((byte)exp.length());
                ret.add(mCandidateClone);
            } else if (lastHg.jong == '\u314e') {
                mCandidateClone = mCandidate.copy();
                exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, ' ');
                mCandidateClone.setExp(exp);
                mCandidateClone.clearHavingCondition();
                mCandidateClone.initHavingCond(exp);
                mCandidateClone.addHavingCond(Condition.MINUS_HIEUT);
                mCandidateClone.setCandDicLen((byte)exp.length());
                ret.add(mCandidateClone);
            } else {
                mCandidateClone = mCandidate.copy();
                mCandidateClone.add(new Morpheme("\u3141", POSTag.ETN));
                exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, '\u3141');
                mCandidateClone.setExp(exp);
                mCandidateClone.clearHavingCondition();
                mCandidateClone.initHavingCond(exp);
                mCandidateClone.setRealDicLen((byte)exp.length());
                ret.add(mCandidateClone);
            }
            mCandidateClone = mCandidate.copy();
            exp = String.valueOf(preStem) + Hangul.combine(lastHg.cho, lastHg.jung, '\u3142');
            mCandidateClone.setExp(exp);
            mCandidateClone.clearHavingCondition();
            mCandidateClone.addHavingCond(Condition.BIEUB);
            mCandidateClone.initHavingCond(exp);
            mCandidateClone.setCandDicLen((byte)exp.length());
            ret.add(mCandidateClone);
        }
        return ret;
    }

    static char getMoeum(Hangul lastHg, Hangul preLastHg) {
        int mo = 0;
        char mo1 = lastHg.jung;
        if (mo1 == '\u3157') {
            mo = 12632;
        } else if (mo1 == '\u315c') {
            mo = lastHg.cho == '\u314d' ? 12627 : 12637;
        } else if (mo1 == '\u3161') {
            mo = preLastHg != null && Hangul.MO_POSITIVE_SET.contains(preLastHg.jung) ? 12623 : 12627;
        }
        return (char)mo;
    }

    private void add(String exp, MCandidate mc) throws Exception {
        mc.calcHashCode();
        mc.calcLnprOfTagging();
        MExpression me = this.get(exp);
        if (me == null) {
            me = new MExpression(exp, mc);
            float lnprOfSpacing = SpacingPDDictionary.getProb(exp);
            mc.setLnprOfSpacing(lnprOfSpacing);
            me.setLnprOfSpacing(lnprOfSpacing);
            this.table.put(exp, me);
            if (this.maxLen < exp.length()) {
                this.maxLen = exp.length();
            }
        } else {
            mc.setLnprOfSpacing(me.getLnprOfSpacing());
            me.add(mc);
        }
    }

    public boolean containVerbStem(String exp) {
        return this.verbStemSet.contains(exp);
    }

    public boolean containNoun(String exp) {
        MExpression me = this.table.get(exp);
        if (me == null) {
            return false;
        }
        for (MCandidate mc : me) {
            if (mc.size() != 1 || !mc.isFirstTagOf(POSTag.NNA)) continue;
            return true;
        }
        return false;
    }

    private synchronized MExpression get(String exp) {
        return this.table.get(exp);
    }

    public synchronized MExpression getMExpression(String exp) {
        MExpression ret = this.get(exp);
        return ret == null ? null : ret.copy();
    }

    public synchronized String[] getCompNoun(String noun) {
        return this.compNounTable.get(noun);
    }

    private void load(SimpleDicReader simpleDicReader) throws Exception {
        String line = null;
        try {
            try {
                String[] strArrTemp = null;
                while ((line = simpleDicReader.readLine()) != null) {
                    if (!Util.valid(line) || line.startsWith("//")) continue;
                    line = line.trim();
                    String exp = null;
                    String mpInfo = null;
                    String condInfo = null;
                    if (line.indexOf(59) > 0) {
                        strArrTemp = line.split(";");
                        mpInfo = strArrTemp[0];
                        if (strArrTemp.length > 1) {
                            condInfo = strArrTemp[1];
                        }
                    } else {
                        mpInfo = line;
                    }
                    exp = mpInfo.split("/")[0];
                    String atl = null;
                    String hcl = null;
                    String ccl = null;
                    String ecl = null;
                    String compResult = null;
                    if (condInfo != null) {
                        StringTokenizer st = new StringTokenizer(condInfo, "#&@\uffe2%$", true);
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (token.equals("#")) {
                                token = st.nextToken().trim();
                                atl = token.substring(1, token.length() - 1);
                                continue;
                            }
                            if (token.equals("&")) {
                                token = st.nextToken().trim();
                                hcl = token.substring(1, token.length() - 1);
                                continue;
                            }
                            if (token.equals("@")) {
                                token = st.nextToken().trim();
                                ccl = token.substring(1, token.length() - 1);
                                continue;
                            }
                            if (token.equals("\uffe2")) {
                                token = st.nextToken().trim();
                                ecl = token.substring(1, token.length() - 1);
                                continue;
                            }
                            if (!token.equals("$")) continue;
                            token = st.nextToken().trim();
                            compResult = token.substring(1, token.length() - 1);
                        }
                    }
                    MCandidate mCandidate = MCandidate.create(exp, mpInfo, atl, hcl, ccl, ecl);
                    this.add(mCandidate.getExp(), mCandidate);
                    if (mCandidate.isTagOf(POSTag.V | POSTag.XSV | POSTag.XSA)) {
                        this.verbStemSet.add(exp);
                        List<MCandidate> mcList = Dictionary.getVerbExtendedMC(mCandidate);
                        int i = 0;
                        int size = mcList.size();
                        while (i < size) {
                            MCandidate mc = mcList.get(i);
                            this.add(mc.getExp(), mc);
                            ++i;
                        }
                        continue;
                    }
                    if (!Util.valid(compResult)) continue;
                    this.compNounTable.put(exp, compResult.split("[+]"));
                }
            }
            catch (Exception e) {
                System.err.println(line);
                throw e;
            }
        }
        finally {
            simpleDicReader.cleanup();
        }
    }

    private void load(RawDicReader rawDicReader) throws Exception {
        String line = null;
        try {
            try {
                String[] arr = null;
                String string = null;
                String temp = null;
                while ((line = rawDicReader.readLine()) != null) {
                    if (!Util.valid(line) || line.startsWith("//")) continue;
                    line = line.trim();
                    arr = line.split(":");
                    string = arr[0];
                    if (arr.length < 2) continue;
                    arr = arr[1].split(";");
                    int i = 0;
                    int stop = arr.length;
                    while (i < stop) {
                        temp = arr[i].trim();
                        this.add(string, MCandidate.create(string, temp.substring(1, temp.length() - 1)));
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                System.err.println(line);
                throw e;
            }
        }
        finally {
            rawDicReader.cleanup();
        }
    }

    private void load(DicReader dicReader) throws Exception {
        if (dicReader instanceof SimpleDicReader) {
            this.load((SimpleDicReader)dicReader);
        } else if (dicReader instanceof RawDicReader) {
            this.load((RawDicReader)dicReader);
        } else {
            throw new Exception("Unknown dictionary reader type.");
        }
    }

    void loadSimple(String fileName) throws Exception {
        System.out.println("Loading " + fileName);
        Timer timer = new Timer();
        timer.start();
        try {
            this.load(new SimpleDicFileReader(fileName));
        }
        finally {
            timer.stop();
            System.out.println("Loaded " + timer.getInterval() + "secs");
        }
    }

    private void loadRaw(String fileName) throws Exception {
        System.out.println("Loading " + fileName);
        Timer timer = new Timer();
        timer.start();
        try {
            this.load(new RawDicFileReader(fileName));
        }
        finally {
            timer.stop();
            System.out.println("Loaded " + timer.getInterval() + "secs");
        }
    }

    protected void loadDic() throws Exception {
        this.loadSimple("/dic/noun.dic");
        this.loadSimple("/dic/verb.dic");
        this.loadSimple("/dic/simple.dic");
        this.loadSimple("/dic/person.dic");
        this.loadSimple("/dic/kcc.dic");
        this.loadRaw("/dic/raw.dic");
    }

    public void printToFile(String fileName) {
        PrintWriter pw = null;
        try {
            try {
                pw = new PrintWriter(new FileOutputStream(new File(fileName)));
                ArrayList<MExpression> list = new ArrayList<MExpression>(this.table.values());
                Collections.sort(list);
                int i = 0;
                int stop = list.size();
                while (i < stop) {
                    MExpression me = list.get(i);
                    pw.println(me);
                    pw.flush();
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (pw != null) {
                    pw.close();
                }
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public List<MExpression> getAsList() {
        if (this.table == null) {
            return null;
        }
        if (this.meList == null) {
            this.meList = new ArrayList<MExpression>(this.table.values());
        }
        return this.meList;
    }

    public List<MCandidate> search(String str) {
        Timer timer = new Timer();
        timer.start();
        ArrayList<MCandidate> ret = new ArrayList<MCandidate>();
        this.getAsList();
        int i = 0;
        while (i < this.meList.size()) {
            MExpression me = this.meList.get(i);
            if (me.getExp().indexOf(str) > -1) {
                ret.addAll(me);
            }
            ++i;
        }
        timer.printMsg(String.valueOf(ret.size()) + " candidates found.");
        timer.stop();
        return ret;
    }

    public List<Morpheme> getWordList() {
        ArrayList<Morpheme> morpList = new ArrayList<Morpheme>();
        for (MExpression me : this.table.values()) {
            for (MCandidate mc : me) {
                if (mc.size() != 1) continue;
                morpList.add((Morpheme)mc.get(0));
            }
        }
        return morpList;
    }
}

