(function () {
    var receiverTest = document.body.querySelector("#receiver_test");
    var receiverProduction = document.body.querySelector("#receiver_production");
    var receiverPreview = document.body.querySelector("#receiver_preview");

    var emitterTest  = document.body.querySelector("#emitter_test");
    var emitterProduction = document.body.querySelector("#emitter_production");
    var emitterPreview = document.body.querySelector("#emitter_preview");

    function onReceiverRadioClick() {
        var receiverValue = "";
        var emitterValue = "";

        if (receiverTest.checked) {
            receiverValue = window.RECIEVER_TEST_URL;
            emitterValue= window.EMITTER_TEST_URL;
            emitterTest.checked=true;

        } else if (receiverProduction.checked) {
            receiverValue = window.RECIEVER_PRODUCTION_URL;
            emitterValue = window.EMITTER_PRODUCTION_URL;
            emitterProduction.checked = true;
        }

        saveSettings(receiverValue,emitterValue)
    }

    function onEmitterRadioClick(){
        var receiverValue = "";
        var emitterValue = "";

        if (emitterTest.checked) {
            receiverValue = window.RECIEVER_TEST_URL;
            emitterValue= window.EMITTER_TEST_URL;
            receiverTest.checked=true;

        } else if (emitterProduction.checked) {
            receiverValue = window.RECIEVER_PRODUCTION_URL;
            emitterValue= window.EMITTER_PRODUCTION_URL;
            receiverProduction.checked=true;
        }

        saveSettings(receiverValue,emitterValue);
    }

    function saveSettings(receiverValue,emitterValue) {
        if (receiverValue && emitterValue) {
            receiverPreview.value = receiverValue;
            emitterPreview.value= emitterValue;

            chrome.storage.sync.set({ urls: {receiver_url: receiverValue, emitter_url: emitterValue }});
            document.body.querySelector("#warning").innerText = "Reload a browser page for the changes to take effect";
        }
    }

    Array.prototype.forEach.call(document.querySelectorAll("input[name='receiver']"),function (radio){
       radio.addEventListener('click', onReceiverRadioClick);
    });

    Array.prototype.forEach.call(document.querySelectorAll("input[name='emitter']"),function (radio){
        radio.addEventListener('click', onEmitterRadioClick);
    });

    onReceiverRadioClick();
    onEmitterRadioClick();

})();
