(function () {
    'use strict';

    var colors = [
        "#66b62c",
        "#ec8d00",
        "#ef3b4a",
        "AntiqueWhite",
        "Aqua",
        "Aquamarine",
        "Azure",
        "Beige",
        "Bisque",
        "BlanchedAlmond",
        "BlueViolet",
        "Brown",
        "BurlyWood",
        "CadetBlue",
        "Chartreuse",
        "Chocolate",
        "Coral",
        "CornflowerBlue",
        "Cornsilk",
        "Crimson",
        "Cyan",
        "DarkCyan",
        "DarkGoldenRod",
        "DarkGray",
        "DarkGreen",
        "DarkKhaki",
        "DarkMagenta",
        "DarkOliveGreen",
        "DarkOrange",
        "DarkOrchid",
        "DarkRed",
        "DarkSalmon",
        "DarkSeaGreen",
        "DarkSlateBlue",
        "DarkSlateGray",
        "DarkTurquoise",
        "DarkViolet",
        "DeepPink",
        "DeepSkyBlue",
        "DimGray",
        "DodgerBlue",
        "FireBrick",
        "FloralWhite",
        "ForestGreen",
        "Fuchsia",
        "Gainsboro",
        "GhostWhite",
        "Gold",
        "GoldenRod",
        "Gray",
        "Green",
        "GreenYellow",
        "HoneyDew",
        "HotPink",
        "IndianRed",
        "Indigo",
        "Ivory",
        "Khaki",
        "Lavender",
        "LavenderBlush",
        "LawnGreen",
        "LemonChiffon",
        "LightBlue",
        "LightCoral",
        "LightCyan",
        "LightGoldenRodYellow",
        "LightGray",
        "LightGreen",
        "LightPink",
        "LightSalmon",
        "LightSeaGreen",
        "LightSkyBlue",
        "LightSlateGray",
        "LightSteelBlue",
        "LightYellow",
        "Lime",
        "LimeGreen",
        "Linen",
        "Magenta",
        "Maroon",
        "MediumAquaMarine",
        "MediumBlue",
        "MediumOrchid",
        "MediumPurple",
        "MediumSeaGreen",
        "MediumSlateBlue",
        "MediumSpringGreen",
        "MediumTurquoise",
        "MediumVioletRed",
        "MidnightBlue",
        "MintCream",
        "MistyRose",
        "Moccasin",
        "NavajoWhite",
        "Navy",
        "OldLace",
        "Olive",
        "OliveDrab",
        "Orange",
        "OrangeRed",
        "Orchid",
        "PaleGoldenRod",
        "PaleGreen",
        "PaleTurquoise",
        "PaleVioletRed",
        "PapayaWhip",
        "PeachPuff",
        "Peru",
        "Pink",
        "Plum",
        "PowderBlue",
        "Purple",
        "RebeccaPurple",
        "Red",
        "RosyBrown",
        "RoyalBlue",
        "SaddleBrown",
        "Salmon",
        "SandyBrown",
        "SeaGreen",
        "SeaShell",
        "Sienna",
        "Silver",
        "SkyBlue",
        "SlateBlue",
        "SlateGray",
        "Snow",
        "SpringGreen",
        "SteelBlue",
        "Tan",
        "Teal",
        "Thistle",
        "Tomato",
        "Turquoise",
        "Violet",
        "Wheat",
        "WhiteSmoke",
        "Yellow",
        "YellowGreen"
    ];

    var ITEMS_PER_COL = 1;
    var columnHeight=0;
    var currentInput=0;

    var glass = document.querySelector(".AVAST_CLASSIFIER_glass");
    var mask = document.querySelector(".AVAST_CLASSIFIER_mask");
    var originalMaskColor = mask.style.backgroundColor;
    glass.addEventListener("mouseover", function () {
        mask.style.backgroundColor = originalMaskColor;
    });

    function addInput(parent, type, label) {
        if (!type || !label) {
            if (columnHeight > ITEMS_PER_COL) {
                parent.lastElementChild.style["-webkit-column-break-after"] = "always";
                columnHeight = 0;
            }
            return;
        }
        ++columnHeight;

        var input = document.createElement("input");
        input.name = type;
        input.type = "text";
        input.value = label;
        input.readOnly = true;
        input.size = (label.toString().length<20) ? 15: 30;
        if (type) {
            input.style.backgroundColor = colors[currentInput++];
        }

         parent.appendChild(input);
    }

    function inputfieldsAll(form){
        addInput(form, "USER", "Username");
        addInput(form, "PASSWD", "Password");
        addInput(form, "EMAIL", "E-mail");
        addInput(form, "PHONE", "Phone");

        addInput(form, "", "");

        addInput(form, "FIRSTNAME", "First name");
        addInput(form, "SURNAME", "Surname");
        addInput(form, "MIDDLENAME", "Middle name");
        addInput(form, "FULLNAME", "All names");
        addInput(form, "TITLES_BEFORE", "Titles before name");
        addInput(form, "TITLES_AFTER", "Titles after name");
        addInput(form, "BIRTH", "Birth date");
        addInput(form, "BIRTH_DAY", "Birth date - day");
        addInput(form, "BIRTH_MONTH", "Birth date - month");
        addInput(form, "BIRTH_YEAR", "Birth date - year");
        addInput(form, "BIRTH_PLACE", "Place of birth");

        addInput(form, "", "");

        addInput(form, "STREET_NAME", "Street name (without door number)");
        addInput(form, "STREET_NO", "Door number");
        addInput(form, "STREET_ADDR", "Street name with door number");
        addInput(form, "CITY", "City");
        addInput(form, "STATE", "State");
        addInput(form, "ZIP_CODE", "ZIP code");
        addInput(form, "COUNTRY", "Country");

        addInput(form, "", "");

        addInput(form, "PERSONAL_ID", "Personal ID number");
        addInput(form, "COMPANY_ID", "Company ID number");
        addInput(form, "COMPANY_NAME", "Company name");
        addInput(form, "JOB_TITLE", "Job title");

        addInput(form, "", "");

        addInput(form, "MALE", "Gender: Male");
        addInput(form, "FEMALE", "Gender: Female");
        addInput(form, "UNSPECIFIED_GENDER", "Gender: unspecified");

        addInput(form, "", "");

        addInput(form, "PIN", "PIN");
        addInput(form, "CNUM", "Credit card number");
        addInput(form, "CNUM14", "First four credit card numbers XXXX **** **** ****");
        addInput(form, "CNUM24", "Second four credit card numbers **** XXXX **** ****");
        addInput(form, "CNUM34", "Third four credit card numbers **** **** XXXX *****");
        addInput(form, "CNUM44", "Last four credit card numbers **** **** **** XXXX");
        addInput(form, "CARD_VALID_MONTH", "Credit card valid until - month");
        addInput(form, "CARD_VALID_YEAR", "Credit card valid until - year");
        addInput(form, "SNUM", "Credit card security number");
        addInput(form, "ACCOUNT", "Bank account");
        addInput(form, "BANKID", "Domestic bank ID");
        addInput(form, "SWIFT", "Bank SWIFT code");
        addInput(form, "IBAN", "Bank IBAN number");
    }

    function inputfieldsLogin(form){
        addInput(form, "USER", "Username");
        addInput(form, "PASSWD", "Password");
        addInput(form, "IGNOR", "Ignore this input");
    }

    function populateSelection() {
        var form = document.querySelector(".AVAST_CLASSIFIER_popup form");
        currentInput = 0;
        columnHeight = 0;
        if (form.children.length == 0) {

            inputfieldsLogin(form);

            Array.prototype.forEach.call(form.querySelectorAll("input"), function(i) {
                i.addEventListener("click", function (e) {
                    if (window.avastClassifierURL) {
                        i.formAction = window.avastClassifierURL;
                    }
                });
                i.addEventListener("mouseover", function () {
                    mask.style.backgroundColor = i.style.backgroundColor;
                });
            });

            // fix position
            var popup = document.querySelector(".AVAST_CLASSIFIER_popup");
            var rect = popup.getBoundingClientRect();
            if (rect.right > window.innerWidth) {
                var left = rect.left - (rect.right - window.innerWidth);
                if (left < 0) {
                    left = 0;
                }
                popup.style.left = left + "px";
            }
            if (rect.bottom > window.innerHeight) {
                var top = rect.top - (rect.bottom - window.innerHeight);
                if (top < 0) {
                    top = 0;
                }
                popup.style.top = top + "px";
            }
        }
    }

    populateSelection();
})();
