import nefis
import numpy as np

def test_nefis_define():
    #-------------------------------------------------------------------------------
    error, version = nefis.getnfv()
    print('')
    print('Library version: %s' % version[4:])
    print('')
    #-------------------------------------------------------------------------------
    dat_file = 'define.dat'
    def_file = 'define.def'
    coding = ' '
    ac_type = 'c'
    fp = -1
    print("---------")
    print(dat_file)
    print(def_file)
    print(coding)
    print(ac_type)
    print("---------")

    #-------------------------------------------------------------------------------
    error, fp = nefis.crenef(dat_file, def_file, coding, ac_type)
    print('File set (should be zero): %d' % fp)
    print('NEFIS error code (crenef): %d' % error)
    print("---------")
    #-------------------------------------------------------------------------------
    elm_name = 'Element 1'
    elm_type = 'character'
    elm_single_byte = 20
    elm_quantity = 'names'
    elm_unit = '[-]'
    elm_description = 'Discharge station names'
    elm_count = 1
    #elm_data = np.arange(15).reshape(5,3)
    elm_dimensions = np.arange(elm_count).reshape(elm_count)
    elm_dimensions[0] = 20
    error = nefis.defelm(fp, elm_name, elm_type, elm_single_byte, elm_quantity, elm_unit, elm_description, elm_count, elm_dimensions)
    print('NEFIS error code (getels): %d' % error)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    elm_name = 'Elm 2'
    elm_type = 'REAL'
    elm_single_byte = 4
    elm_quantity = 'discharge'
    elm_unit = '[m^3/s]'
    elm_description = 'First element generated by Python'
    elm_count = 2
    #elm_data = np.arange(15).reshape(5,3)
    elm_dimensions = np.arange(elm_count).reshape(elm_count)
    elm_dimensions[0] = 20
    elm_dimensions[1] = 5
    error = nefis.defelm(fp, elm_name, elm_type, elm_single_byte, elm_quantity, elm_unit, elm_description, elm_count, elm_dimensions)
    print('NEFIS error code (getels): %d' % error)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    cel_name = 'Cell 1'
    cel_names_count = 2
    elm_names = ['Element 1', 'Elm 2']
    error = nefis.defcel(fp, cel_name, cel_names_count, elm_names)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    grp_defined = 'Grp 1'
    cel_name = 'Cell 1'
    grp_count = 1
    grp_dimensions = np.arange(5).reshape(5)
    grp_dimensions[0] = 11
    grp_dimensions[1] = 0
    grp_dimensions[2] = 0
    grp_dimensions[3] = 0
    grp_dimensions[4] = 0
    grp_order = np.arange(5).reshape(5)
    grp_order[0] = 1
    grp_order[1] = 2
    grp_order[2] = 3
    grp_order[3] = 4
    grp_order[4] = 5

    error = nefis.defgrp(fp, grp_defined, cel_name, grp_count, grp_dimensions, grp_order)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    grp_name = 'Group 1'
    grp_defined = 'Grp 1'

    error = nefis.credat(fp, grp_name, grp_defined)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------

    print("---------")
    error = nefis.clsnef(fp)
    print('NEFIS error code (clsnef): %d' % error)
    print("---------")


if __name__ == "__main__":
    test_nefis_define()
