# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, Generic, Optional, TypeVar
import warnings

from azure.core.exceptions import HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class BlobContainersOperations:
    """BlobContainersOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.storage.v2018_07_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def list(
        self,
        resource_group_name: str,
        account_name: str,
        **kwargs
    ) -> "models.ListContainerItems":
        """Lists all containers and does not support a prefix like data plane. Also SRP today does not
        return continuation token.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ListContainerItems, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.ListContainerItems
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ListContainerItems"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"

        # Construct URL
        url = self.list.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ListContainerItems', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    list.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers'}  # type: ignore

    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: "models.BlobContainer",
        **kwargs
    ) -> "models.BlobContainer":
        """Creates a new container under the specified account as described by request body. The container
        resource includes metadata and properties for that container. It does not include a list of the
        blobs contained by the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param blob_container: Properties of the blob container to create.
        :type blob_container: ~azure.mgmt.storage.v2018_07_01.models.BlobContainer
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.BlobContainer
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.BlobContainer"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.create.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(blob_container, 'BlobContainer')
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('BlobContainer', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'}  # type: ignore

    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: "models.BlobContainer",
        **kwargs
    ) -> "models.BlobContainer":
        """Updates container properties as specified in request body. Properties not mentioned in the
        request will be unchanged. Update fails if the specified container doesn't already exist.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param blob_container: Properties to update for the blob container.
        :type blob_container: ~azure.mgmt.storage.v2018_07_01.models.BlobContainer
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.BlobContainer
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.BlobContainer"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.update.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(blob_container, 'BlobContainer')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('BlobContainer', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'}  # type: ignore

    async def get(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        **kwargs
    ) -> "models.BlobContainer":
        """Gets properties of a specified container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.BlobContainer
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.BlobContainer"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"

        # Construct URL
        url = self.get.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('BlobContainer', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'}  # type: ignore

    async def delete(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        **kwargs
    ) -> None:
        """Deletes specified container under its account.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"

        # Construct URL
        url = self.delete.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}'}  # type: ignore

    async def set_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: "models.LegalHold",
        **kwargs
    ) -> "models.LegalHold":
        """Sets legal hold tags. Setting the same tag results in an idempotent operation. SetLegalHold
        follows an append pattern and does not clear out the existing tags that are not specified in
        the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be set to a blob container.
        :type legal_hold: ~azure.mgmt.storage.v2018_07_01.models.LegalHold
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.LegalHold
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.LegalHold"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.set_legal_hold.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(legal_hold, 'LegalHold')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('LegalHold', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    set_legal_hold.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/setLegalHold'}  # type: ignore

    async def clear_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: "models.LegalHold",
        **kwargs
    ) -> "models.LegalHold":
        """Clears legal hold tags. Clearing the same or non-existent tag results in an idempotent
        operation. ClearLegalHold clears out only the specified tags in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be clear from a blob container.
        :type legal_hold: ~azure.mgmt.storage.v2018_07_01.models.LegalHold
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.LegalHold
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.LegalHold"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.clear_legal_hold.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(legal_hold, 'LegalHold')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('LegalHold', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    clear_legal_hold.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/clearLegalHold'}  # type: ignore

    async def create_or_update_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        parameters: Optional["models.ImmutabilityPolicy"] = None,
        **kwargs
    ) -> "models.ImmutabilityPolicy":
        """Creates or updates an unlocked immutability policy. ETag in If-Match is honored if given but
        not required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be created or updated to a blob
         container.
        :type parameters: ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicy
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ImmutabilityPolicy"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        immutability_policy_name = "default"
        api_version = "2018-07-01"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.create_or_update_immutability_policy.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'immutabilityPolicyName': self._serialize.url("immutability_policy_name", immutability_policy_name, 'str'),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        body_content_kwargs = {}  # type: Dict[str, Any]
        if parameters is not None:
            body_content = self._serialize.body(parameters, 'ImmutabilityPolicy')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    create_or_update_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}'}  # type: ignore

    async def get_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        **kwargs
    ) -> "models.ImmutabilityPolicy":
        """Gets the existing immutability policy along with the corresponding ETag in response headers and
        body.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ImmutabilityPolicy"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        immutability_policy_name = "default"
        api_version = "2018-07-01"

        # Construct URL
        url = self.get_immutability_policy.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'immutabilityPolicyName': self._serialize.url("immutability_policy_name", immutability_policy_name, 'str'),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}'}  # type: ignore

    async def delete_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        **kwargs
    ) -> "models.ImmutabilityPolicy":
        """Aborts an unlocked immutability policy. The response of delete has
        immutabilityPeriodSinceCreationInDays set to 0. ETag in If-Match is required for this
        operation. Deleting a locked immutability policy is not allowed, only way is to delete the
        container after deleting all blobs inside the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ImmutabilityPolicy"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        immutability_policy_name = "default"
        api_version = "2018-07-01"

        # Construct URL
        url = self.delete_immutability_policy.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'immutabilityPolicyName': self._serialize.url("immutability_policy_name", immutability_policy_name, 'str'),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    delete_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}'}  # type: ignore

    async def lock_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        **kwargs
    ) -> "models.ImmutabilityPolicy":
        """Sets the ImmutabilityPolicy to Locked state. The only action allowed on a Locked policy is
        ExtendImmutabilityPolicy action. ETag in If-Match is required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ImmutabilityPolicy"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"

        # Construct URL
        url = self.lock_immutability_policy.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    lock_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/lock'}  # type: ignore

    async def extend_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        parameters: Optional["models.ImmutabilityPolicy"] = None,
        **kwargs
    ) -> "models.ImmutabilityPolicy":
        """Extends the immutabilityPeriodSinceCreationInDays of a locked immutabilityPolicy. The only
        action allowed on a Locked policy will be this action. ETag in If-Match is required for this
        operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be extended for a blob
         container.
        :type parameters: ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicy
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ImmutabilityPolicy"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.extend_immutability_policy.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        body_content_kwargs = {}  # type: Dict[str, Any]
        if parameters is not None:
            body_content = self._serialize.body(parameters, 'ImmutabilityPolicy')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('ImmutabilityPolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    extend_immutability_policy.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/extend'}  # type: ignore

    async def lease(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        parameters: Optional["models.LeaseContainerRequest"] = None,
        **kwargs
    ) -> "models.LeaseContainerResponse":
        """The Lease Container operation establishes and manages a lock on a container for delete
        operations. The lock duration can be 15 to 60 seconds, or can be infinite.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and lower-
         case letters only.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number.
        :type container_name: str
        :param parameters: Lease Container request body.
        :type parameters: ~azure.mgmt.storage.v2018_07_01.models.LeaseContainerRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LeaseContainerResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2018_07_01.models.LeaseContainerResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.LeaseContainerResponse"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2018-07-01"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.lease.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1, pattern=r'^[-\w\._\(\)]+$'),
            'accountName': self._serialize.url("account_name", account_name, 'str', max_length=24, min_length=3),
            'containerName': self._serialize.url("container_name", container_name, 'str', max_length=63, min_length=3),
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str', min_length=1),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        # Construct and send request
        body_content_kwargs = {}  # type: Dict[str, Any]
        if parameters is not None:
            body_content = self._serialize.body(parameters, 'LeaseContainerRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('LeaseContainerResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    lease.metadata = {'url': '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/lease'}  # type: ignore
