# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DatabaseBackupSetting(Model):
    """
    Note: properties are serialized in JSON format and stored in DB.
    if new properties are added they might not be in the previous
    data rows
    so please handle nulls

    :param database_type: SqlAzure / MySql
    :type database_type: str
    :param name:
    :type name: str
    :param connection_string_name: Contains a connection string name that is
     linked to the SiteConfig.ConnectionStrings.
     This is used during restore with overwrite connection strings
     options.
    :type connection_string_name: str
    :param connection_string: Contains a connection string to a database
     which is being backed up/restored. If the restore should happen to a new
     database, the database name inside is the new one.
    :type connection_string: str
    """ 

    _attribute_map = {
        'database_type': {'key': 'databaseType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'connection_string_name': {'key': 'connectionStringName', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(self, database_type=None, name=None, connection_string_name=None, connection_string=None, **kwargs):
        self.database_type = database_type
        self.name = name
        self.connection_string_name = connection_string_name
        self.connection_string = connection_string
