# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ComputeNodeError(Model):
    """An error encountered by a compute node.

    :param code: An identifier for the compute node error. Codes are invariant
     and are intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the compute node error, intended to
     be suitable for display in a user interface.
    :type message: str
    :param error_details: The list of additional error details related to the
     compute node error.
    :type error_details: list[~azure.batch.models.NameValuePair]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'error_details': {'key': 'errorDetails', 'type': '[NameValuePair]'},
    }

    def __init__(self, *, code: str=None, message: str=None, error_details=None, **kwargs) -> None:
        super(ComputeNodeError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.error_details = error_details
