"""
Auto generated code

"""

import json
from snapp_email.datacontract.classes import Post_18
from snapp_email.datacontract.utils import export_dict, fill


class Post_18Endpoint:
    def __init__(self, api_client):
        self.api_client = api_client
    
    def options(self, impersonate_user_id=None, accept_type=None):
        """
        Retrieve options available for resource 'Post_18'.
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_18
        """
        url_parameters = {
        }
        endpoint_parameters = {
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.8+json',
            'Accept': 'application/vnd.4thoffice.post-5.8+json' if accept_type is None else accept_type,
        }
        response = self.api_client.api_call('options', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id)
        
        return fill(Post_18, response.json())
    
    def get(self, postId, impersonate_user_id=None, accept_type=None):
        """
        Retrieve post resource.
        
        :param postId: 
        :type postId: 
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_18
        """
        url_parameters = {
        }
        endpoint_parameters = {
            'postId': postId,
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.8+json',
            'Accept': 'application/vnd.4thoffice.post-5.8+json' if accept_type is None else accept_type,
        }
        response = self.api_client.api_call('get', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id)
        
        return fill(Post_18, response.json())
    
    def create(self, obj, clientResourceId=None, impersonate_user_id=None, accept_type=None):
        """
        Create new post.
        
        :param obj: Object to be persisted
        :type obj: Post_18
        
        :param clientResourceId: Resource id generated by client-side. Required for double-post prevention on server-side.
        :type clientResourceId: String
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_18
        """
        url_parameters = {
            'clientResourceId': clientResourceId,
        }
        endpoint_parameters = {
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.8+json',
            'Accept': 'application/vnd.4thoffice.post-5.8+json' if accept_type is None else accept_type,
        }
        data = export_dict(obj)
        response = self.api_client.api_call('post', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id, data=json.dumps(data))
        
        return fill(Post_18, response.json())
    
    def create_2(self, obj, sourceResourceId, impersonate_user_id=None, accept_type=None):
        """
        Copy existing post.
        
        :param obj: Object to be persisted
        :type obj: Post_18
        
        :param sourceResourceId: Specify id of source resource.
        :type sourceResourceId: String
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_18
        """
        url_parameters = {
            'sourceResourceId': sourceResourceId,
        }
        endpoint_parameters = {
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.8+json',
            'Accept': 'application/vnd.4thoffice.post-5.8+json' if accept_type is None else accept_type,
        }
        data = export_dict(obj)
        response = self.api_client.api_call('post', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id, data=json.dumps(data))
        
        return fill(Post_18, response.json())
