/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ModelType;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.ListValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class ListParserValidator
extends BaseParserValidator<String> {
    public static final String LEFT_DELIMITER = "(";
    public static final String RIGHT_DELIMITER = ")";
    protected static final String LIST_REGEXP = "^" + ListParserValidator.ignoreCaseRegexp(ModelType.LIST.name()) + "\\" + "(" + "([^)]*)\\" + ")" + "$";

    public ListParserValidator(String model) throws ModelSyntaxException {
        super(model, ModelType.LIST, LIST_REGEXP);
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        String commaSeparatedValuesString = this.parseAndGetOneGroup(model, LIST_REGEXP);
        Object[] stringValues = commaSeparatedValuesString.split(",");
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        if (ImmutableSet.copyOf((Object[])stringValues).size() < stringValues.length) {
            throw new ModelSyntaxException("Duplicate value in LIST");
        }
        for (Object value : stringValues) {
            String trimmedValue = ((String)value).trim();
            listBuilder.add((Object)trimmedValue);
        }
        return new ListValidator((ImmutableList<String>)listBuilder.build());
    }
}

