/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.processors.invocation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.Cookie;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.InvocationProcessor;

public class CookieParamProcessor
implements InvocationProcessor {
    private String cookieName;
    protected Annotation[] annotations;
    protected Type type;

    public CookieParamProcessor(String cookieName) {
        this.cookieName = cookieName;
    }

    public CookieParamProcessor(String cookieName, Type type, Annotation[] annotations) {
        this.cookieName = cookieName;
        this.annotations = annotations;
        this.type = type;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    @Override
    public void process(ClientInvocationBuilder request, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Cookie) {
            Cookie cookie = (Cookie)object;
            request.cookie(cookie);
        } else {
            request.cookie(new Cookie(this.cookieName, request.getInvocation().getClientConfiguration().toString(object)));
        }
    }

    @Override
    public void process(ClientInvocation invocation, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Cookie) {
            Cookie cookie = (Cookie)object;
            invocation.getHeaders().cookie(cookie);
        } else {
            ClientConfiguration cc = invocation.getClientConfiguration();
            String s = this.annotations != null && this.type != null ? cc.toString(object, this.type, this.annotations) : cc.toString(object);
            invocation.getHeaders().cookie(new Cookie(this.cookieName, s));
        }
    }
}

