# coding: utf-8
import os

class Projection(object):
    def __init__(self):
        self._name_mapping = {}
        for key, val in self._projections.items():
            self._name_mapping[int(val)] = key
            setattr(self, key.replace('-', '_'), val)
    def __getitem__(self, index):
        return self._name_mapping[int(index)]
    def __contains__(self, index):
        return index in self._name_mapping

class projected(Projection):
    _projections = {
       'Anguilla_1957_British_West_Indies_Grid': 2000,
       'Antigua_1943_British_West_Indies_Grid': 2001,
       'Dominica_1945_British_West_Indies_Grid': 2002,
       'Grenada_1953_British_West_Indies_Grid': 2003,
       'Montserrat_1958_British_West_Indies_Grid': 2004,
       'St_Kitts_1955_British_West_Indies_Grid': 2005,
       'St_Lucia_1955_British_West_Indies_Grid': 2006,
       'St_Vincent_1945_British_West_Indies_Grid': 2007,
       'NAD_1927_CGQ77_MTM_2_SCoPQ': 2008,
       'NAD_1927_CGQ77_MTM_3_SCoPQ': 2009,
       'NAD_1927_CGQ77_MTM_4_SCoPQ': 2010,
       'NAD_1927_CGQ77_MTM_5_SCoPQ': 2011,
       'NAD_1927_CGQ77_MTM_6_SCoPQ': 2012,
       'NAD_1927_CGQ77_MTM_7_SCoPQ': 2013,
       'NAD_1927_CGQ77_MTM_8_SCoPQ': 2014,
       'NAD_1927_CGQ77_MTM_9_SCoPQ': 2015,
       'NAD_1927_CGQ77_MTM_10_SCoPQ': 2016,
       'NAD_1927_DEF_1976_MTM_8': 2017,
       'NAD_1927_DEF_1976_MTM_9': 2018,
       'NAD_1927_DEF_1976_MTM_10': 2019,
       'NAD_1927_DEF_1976_MTM_11': 2020,
       'NAD_1927_DEF_1976_MTM_12': 2021,
       'NAD_1927_DEF_1976_MTM_13': 2022,
       'NAD_1927_DEF_1976_MTM_14': 2023,
       'NAD_1927_DEF_1976_MTM_15': 2024,
       'NAD_1927_DEF_1976_MTM_16': 2025,
       'NAD_1927_DEF_1976_MTM_17': 2026,
       'NAD_1927_DEF_1976_UTM_Zone_15N': 2027,
       'NAD_1927_DEF_1976_UTM_Zone_16N': 2028,
       'NAD_1927_DEF_1976_UTM_Zone_17N': 2029,
       'NAD_1927_DEF_1976_UTM_Zone_18N': 2030,
       'NAD_1927_CGQ77_UTM_Zone_17N': 2031,
       'NAD_1927_CGQ77_UTM_Zone_18N': 2032,
       'NAD_1927_CGQ77_UTM_Zone_19N': 2033,
       'NAD_1927_CGQ77_UTM_Zone_20N': 2034,
       'NAD_1927_CGQ77_UTM_Zone_21N': 2035,
       'NAD_1983_CSRS_New_Brunswick_Stereographic': 2036,
       'NAD_1983_CSRS_UTM_Zone_19N': 2037,
       'NAD_1983_CSRS_UTM_Zone_20N': 2038,
       'Israel_TM_Grid': 2039,
       'Locodjo_1965_UTM_Zone_30N': 2040,
       'Abidjan_1987_UTM_Zone_30N': 2041,
       'Locodjo_1965_UTM_Zone_29N': 2042,
       'Abidjan_1987_UTM_Zone_29N': 2043,
       'Hanoi_1972_GK_Zone_18': 2044,
       'Hanoi_1972_GK_Zone_19': 2045,
       'CH1903+_LV95': 2056,
       'Rassadiran_Nakhl_e_Taqi': 2057,
       'ED_1950_ED77_UTM_Zone_38N': 2058,
       'ED_1950_ED77_UTM_Zone_39N': 2059,
       'ED_1950_ED77_UTM_Zone_40N': 2060,
       'ED_1950_ED77_UTM_Zone_41N': 2061,
       'Madrid_1870_Madrid_Spain': 2062,
       'Dabola_1981_UTM_Zone_28N': 2063,
       'Dabola_1981_UTM_Zone_29N': 2064,
       'S-JTSK_Ferro_Krovak': 2065,
       'Mount_Dillon_Tobago_Grid': 2066,
       'Naparima_1955_UTM_Zone_20N': 2067,
       'ELD_1979_Libya_5': 2068,
       'ELD_1979_Libya_6': 2069,
       'ELD_1979_Libya_7': 2070,
       'ELD_1979_Libya_8': 2071,
       'ELD_1979_Libya_9': 2072,
       'ELD_1979_Libya_10': 2073,
       'ELD_1979_Libya_11': 2074,
       'ELD_1979_Libya_12': 2075,
       'ELD_1979_Libya_13': 2076,
       'ELD_1979_UTM_Zone_32N': 2077,
       'ELD_1979_UTM_Zone_33N': 2078,
       'ELD_1979_UTM_Zone_34N': 2079,
       'ELD_1979_UTM_Zone_35N': 2080,
       'Chos_Malal_1914_Argentina_2': 2081,
       'Pampa_del_Castillo_Argentina_2': 2082,
       'Hito_XVIII_1963_Argentina_2': 2083,
       'Hito_XVIII_1963_UTM_19S': 2084,
       'NAD_1927_Cuba_Norte': 2085,
       'NAD_1927_Cuba_Sur': 2086,
       'ELD_1979_TM_12_NE': 2087,
       'Carthage_TM_11_NE': 2088,
       'Yemen_NGN_1996_UTM_Zone_38N': 2089,
       'Yemen_NGN_1996_UTM_Zone_39N': 2090,
       'South_Yemen_GK_Zone_8': 2091,
       'South_Yemen_GK_Zone_9': 2092,
       'Hanoi_1972_GK_106_NE': 2093,
       'WGS_1972_BE_TM_106_NE': 2094,
       'Bissau_UTM_Zone_28N': 2095,
       'Korean_1985_Korea_East_Belt': 2096,
       'Korean_1985_Korea_Central_Belt': 2097,
       'Korean_1985_Korea_West_Belt': 2098,
       'Qatar_1948_Qatar_Grid': 2099,
       'Greek_Grid': 2100,
       'Lake_Maracaibo_Grid_M1': 2101,
       'Lake_Maracaibo_Grid': 2102,
       'Lake_Maracaibo_Grid_M3': 2103,
       'Lake_Maracaibo_La_Rosa_Grid': 2104,
       'NZGD_2000_Mount_Eden_Circuit': 2105,
       'NZGD_2000_Bay_of_Plenty_Circuit': 2106,
       'NZGD_2000_Poverty_Bay_Circuit': 2107,
       'NZGD_2000_Hawkes_Bay_Circuit': 2108,
       'NZGD_2000_Taranaki_Circuit': 2109,
       'NZGD_2000_Tuhirangi_Circuit': 2110,
       'NZGD_2000_Wanganui_Circuit': 2111,
       'NZGD_2000_Wairarapa_Circuit': 2112,
       'NZGD_2000_Wellington_Circuit': 2113,
       'NZGD_2000_Collingwood_Circuit': 2114,
       'NZGD_2000_Nelson_Circuit': 2115,
       'NZGD_2000_Karamea_Circuit': 2116,
       'NZGD_2000_Buller_Circuit': 2117,
       'NZGD_2000_Grey_Circuit': 2118,
       'NZGD_2000_Amuri_Circuit': 2119,
       'NZGD_2000_Marlborough_Circuit': 2120,
       'NZGD_2000_Hokitika_Circuit': 2121,
       'NZGD_2000_Okarito_Circuit': 2122,
       'NZGD_2000_Jacksons_Bay_Circuit': 2123,
       'NZGD_2000_Mount_Pleasant_Circuit': 2124,
       'NZGD_2000_Gawler_Circuit': 2125,
       'NZGD_2000_Timaru_Circuit': 2126,
       'NZGD_2000_Lindis_Peak_Circuit': 2127,
       'NZGD_2000_Mount_Nicholas_Circuit': 2128,
       'NZGD_2000_Mount_York_Circuit': 2129,
       'NZGD_2000_Observation_Point_Circuit': 2130,
       'NZGD_2000_North_Taieri_Circuit': 2131,
       'NZGD_2000_Bluff_Circuit': 2132,
       'NZGD_2000_UTM_Zone_58S': 2133,
       'NZGD_2000_UTM_Zone_59S': 2134,
       'NZGD_2000_UTM_Zone_60S': 2135,
       'Accra_Ghana_Grid': 2136,
       'Accra_TM_1_NW': 2137,
       'NAD_1927_CGQ77_Quebec_Lambert': 2138,
       'NAD_1983_CSRS_MTM_2_SCoPQ': 2139,
       'NAD_1983_CSRS_MTM_3': 2140,
       'NAD_1983_CSRS_MTM_4': 2141,
       'NAD_1983_CSRS_MTM_5': 2142,
       'NAD_1983_CSRS_MTM_6': 2143,
       'NAD_1983_CSRS_MTM_7': 2144,
       'NAD_1983_CSRS_MTM_8': 2145,
       'NAD_1983_CSRS_MTM_9': 2146,
       'NAD_1983_CSRS_MTM_10': 2147,
       'NAD_1983_CSRS_UTM_Zone_21N': 2148,
       'NAD_1983_CSRS_UTM_Zone_18N': 2149,
       'NAD_1983_CSRS_UTM_Zone_17N': 2150,
       'NAD_1983_CSRS_UTM_Zone_13N': 2151,
       'NAD_1983_CSRS_UTM_Zone_12N': 2152,
       'NAD_1983_CSRS_UTM_Zone_11N': 2153,
       'RGF_1993_Lambert_93': 2154,
       'Samoa_1962_Samoa_Lambert': 2155,
       'IRENET95_Irish_Transverse_Mercator': 2157,
       'IRENET95_UTM_Zone_29N': 2158,
       'Sierra_Leone_1924_New_Colony_Grid': 2159,
       'Sierra_Leone_1924_New_War_Office_Grid': 2160,
       'Sierra_Leone_1968_UTM_Zone_28N': 2161,
       'Sierra_Leone_1968_UTM_Zone_29N': 2162,
       'US_National_Atlas_Equal_Area': 2163,
       'Locodjo_1965_TM_5_NW': 2164,
       'Abidjan_1987_TM_5_NW': 2165,
       'Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_3': 2166,
       'Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_4': 2167,
       'Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_5': 2168,
       'Luxembourg_1930_Gauss': 2169,
       'MGI_Slovenia_Grid': 2170,
       'Pulkovo_1942_Adj_1958_Poland_Zone_II': 2172,
       'Pulkovo_1942_Adj_1958_Poland_Zone_III': 2173,
       'Pulkovo_1942_Adj_1958_Poland_Zone_IV': 2174,
       'Pulkovo_1942_Adj_1958_Poland_Zone_V': 2175,
       'ETRS_1989_Poland_CS2000_Zone_5': 2176,
       'ETRS_1989_Poland_CS2000_Zone_6': 2177,
       'ETRS_1989_Poland_CS2000_Zone_7': 2178,
       'ETRS_1989_Poland_CS2000_Zone_8': 2179,
       'ETRS_1989_Poland_CS92': 2180,
       'ED_1950_Turkey_9': 2181,
       'ED_1950_Turkey_10': 2182,
       'ED_1950_Turkey_11': 2183,
       'ED_1950_Turkey_12': 2184,
       'ED_1950_Turkey_13': 2185,
       'ED_1950_Turkey_14': 2186,
       'ED_1950_Turkey_15': 2187,
       'Azores_Occidental_1939_UTM_Zone_25N': 2188,
       'Azores_Central_1948_UTM_Zone_26N': 2189,
       'Azores_Oriental_1940_UTM_Zone_26N': 2190,
       'ED_1950_France_EuroLambert': 2192,
       'NZGD_2000_New_Zealand_Transverse_Mercator': 2193,
       'NAD_1983_HARN_UTM_Zone_2S': 2195,
       'ETRS_1989_Kp2000_Jutland': 2196,
       'ETRS_1989_Kp2000_Zealand': 2197,
       'ETRS_1989_Kp2000_Bornholm': 2198,
       'ATS_1977_New_Brunswick_Stereographic': 2200,
       'REGVEN_UTM_Zone_18N': 2201,
       'REGVEN_UTM_Zone_19N': 2202,
       'REGVEN_UTM_Zone_20N': 2203,
       'NAD_1927_StatePlane_Tennessee_FIPS_4100': 2204,
       'NAD_1983_StatePlane_Kentucky_North_FIPS_1601': 2205,
       'ED_1950_3_Degree_GK_Zone_9': 2206,
       'ED_1950_3_Degree_GK_Zone_10': 2207,
       'ED_1950_3_Degree_GK_Zone_11': 2208,
       'ED_1950_3_Degree_GK_Zone_12': 2209,
       'ED_1950_3_Degree_GK_Zone_13': 2210,
       'ED_1950_3_Degree_GK_Zone_14': 2211,
       'ED_1950_3_Degree_GK_Zone_15': 2212,
       'ETRS_1989_TM_30_NE': 2213,
       'Douala_1948_AEF_West': 2214,
       'Manoca_1962_UTM_Zone_32N': 2215,
       'Qornoq_1927_UTM_Zone_22N': 2216,
       'Qornoq_1927_UTM_Zone_23N': 2217,
       'ATS_1977_UTM_Zone_19N': 2219,
       'ATS_1977_UTM_Zone_20N': 2220,
       'NAD_1983_StatePlane_Arizona_East_FIPS_0201_Feet_Intl': 2222,
       'NAD_1983_StatePlane_Arizona_Central_FIPS_0202_Feet_Intl': 2223,
       'NAD_1983_StatePlane_Arizona_West_FIPS_0203_Feet_Intl': 2224,
       'NAD_1983_StatePlane_California_I_FIPS_0401_Feet': 2225,
       'NAD_1983_StatePlane_California_II_FIPS_0402_Feet': 2226,
       'NAD_1983_StatePlane_California_III_FIPS_0403_Feet': 2227,
       'NAD_1983_StatePlane_California_IV_FIPS_0404_Feet': 2228,
       'NAD_1983_StatePlane_California_V_FIPS_0405_Feet': 2229,
       'NAD_1983_StatePlane_California_VI_FIPS_0406_Feet': 2230,
       'NAD_1983_StatePlane_Colorado_North_FIPS_0501_Feet': 2231,
       'NAD_1983_StatePlane_Colorado_Central_FIPS_0502_Feet': 2232,
       'NAD_1983_StatePlane_Colorado_South_FIPS_0503_Feet': 2233,
       'NAD_1983_StatePlane_Connecticut_FIPS_0600_Feet': 2234,
       'NAD_1983_StatePlane_Delaware_FIPS_0700_Feet': 2235,
       'NAD_1983_StatePlane_Florida_East_FIPS_0901_Feet': 2236,
       'NAD_1983_StatePlane_Florida_West_FIPS_0902_Feet': 2237,
       'NAD_1983_StatePlane_Florida_North_FIPS_0903_Feet': 2238,
       'NAD_1983_StatePlane_Georgia_East_FIPS_1001_Feet': 2239,
       'NAD_1983_StatePlane_Georgia_West_FIPS_1002_Feet': 2240,
       'NAD_1983_StatePlane_Idaho_East_FIPS_1101_Feet': 2241,
       'NAD_1983_StatePlane_Idaho_Central_FIPS_1102_Feet': 2242,
       'NAD_1983_StatePlane_Idaho_West_FIPS_1103_Feet': 2243,
       'NAD_1983_StatePlane_Indiana_East_FIPS_1301_Feet': 2244,
       'NAD_1983_StatePlane_Indiana_West_FIPS_1302_Feet': 2245,
       'NAD_1983_StatePlane_Kentucky_North_FIPS_1601_Feet': 2246,
       'NAD_1983_StatePlane_Kentucky_South_FIPS_1602_Feet': 2247,
       'NAD_1983_StatePlane_Maryland_FIPS_1900_Feet': 2248,
       'NAD_1983_StatePlane_Massachusetts_Mainland_FIPS_2001_Feet': 2249,
       'NAD_1983_StatePlane_Massachusetts_Island_FIPS_2002_Feet': 2250,
       'NAD_1983_StatePlane_Michigan_North_FIPS_2111_Feet_Intl': 2251,
       'NAD_1983_StatePlane_Michigan_Central_FIPS_2112_Feet_Intl': 2252,
       'NAD_1983_StatePlane_Michigan_South_FIPS_2113_Feet_Intl': 2253,
       'NAD_1983_StatePlane_Mississippi_East_FIPS_2301_Feet': 2254,
       'NAD_1983_StatePlane_Mississippi_West_FIPS_2302_Feet': 2255,
       'NAD_1983_StatePlane_Montana_FIPS_2500_Feet_Intl': 2256,
       'NAD_1983_StatePlane_New_Mexico_East_FIPS_3001_Feet': 2257,
       'NAD_1983_StatePlane_New_Mexico_Central_FIPS_3002_Feet': 2258,
       'NAD_1983_StatePlane_New_Mexico_West_FIPS_3003_Feet': 2259,
       'NAD_1983_StatePlane_New_York_East_FIPS_3101_Feet': 2260,
       'NAD_1983_StatePlane_New_York_Central_FIPS_3102_Feet': 2261,
       'NAD_1983_StatePlane_New_York_West_FIPS_3103_Feet': 2262,
       'NAD_1983_StatePlane_New_York_Long_Island_FIPS_3104_Feet': 2263,
       'NAD_1983_StatePlane_North_Carolina_FIPS_3200_Feet': 2264,
       'NAD_1983_StatePlane_North_Dakota_North_FIPS_3301_Feet_Intl': 2265,
       'NAD_1983_StatePlane_North_Dakota_South_FIPS_3302_Feet_Intl': 2266,
       'NAD_1983_StatePlane_Oklahoma_North_FIPS_3501_Feet': 2267,
       'NAD_1983_StatePlane_Oklahoma_South_FIPS_3502_Feet': 2268,
       'NAD_1983_StatePlane_Oregon_North_FIPS_3601_Feet_Intl': 2269,
       'NAD_1983_StatePlane_Oregon_South_FIPS_3602_Feet_Intl': 2270,
       'NAD_1983_StatePlane_Pennsylvania_North_FIPS_3701_Feet': 2271,
       'NAD_1983_StatePlane_Pennsylvania_South_FIPS_3702_Feet': 2272,
       'NAD_1983_StatePlane_South_Carolina_FIPS_3900_Feet_Intl': 2273,
       'NAD_1983_StatePlane_Tennessee_FIPS_4100_Feet': 2274,
       'NAD_1983_StatePlane_Texas_North_FIPS_4201_Feet': 2275,
       'NAD_1983_StatePlane_Texas_North_Central_FIPS_4202_Feet': 2276,
       'NAD_1983_StatePlane_Texas_Central_FIPS_4203_Feet': 2277,
       'NAD_1983_StatePlane_Texas_South_Central_FIPS_4204_Feet': 2278,
       'NAD_1983_StatePlane_Texas_South_FIPS_4205_Feet': 2279,
       'NAD_1983_StatePlane_Utah_North_FIPS_4301_Feet_Intl': 2280,
       'NAD_1983_StatePlane_Utah_Central_FIPS_4302_Feet_Intl': 2281,
       'NAD_1983_StatePlane_Utah_South_FIPS_4303_Feet_Intl': 2282,
       'NAD_1983_StatePlane_Virginia_North_FIPS_4501_Feet': 2283,
       'NAD_1983_StatePlane_Virginia_South_FIPS_4502_Feet': 2284,
       'NAD_1983_StatePlane_Washington_North_FIPS_4601_Feet': 2285,
       'NAD_1983_StatePlane_Washington_South_FIPS_4602_Feet': 2286,
       'NAD_1983_StatePlane_Wisconsin_North_FIPS_4801_Feet': 2287,
       'NAD_1983_StatePlane_Wisconsin_Central_FIPS_4802_Feet': 2288,
       'NAD_1983_StatePlane_Wisconsin_South_FIPS_4803_Feet': 2289,
       'Prince_Edward_Island_Stereographic': 2290,
       'NAD_1983_CSRS_Prince_Edward_Island': 2291,
       'NAD_1983_CSRS_Prince_Edward_Island': 2292,
       'ATS_1977_MTM_4_Nova_Scotia': 2294,
       'ATS_1977_MTM_5_Nova_Scotia': 2295,
       'Batavia_TM_109_SE': 2308,
       'WGS_1984_TM_116_SE': 2309,
       'WGS_1984_TM_132_SE': 2310,
       'WGS_1984_TM_6_NE': 2311,
       'Garoua_UTM_Zone_33N': 2312,
       'Kousseri_UTM_Zone_33N': 2313,
       'Trinidad_1903_Trinidad_Grid_Feet_Clarke': 2314,
       'Campo_Inchauspe_UTM_19S': 2315,
       'Campo_Inchauspe_UTM_20S': 2316,
       'PSAD_1956_ICN_Regional': 2317,
       'Ain_el_Abd_Aramco_Lambert': 2318,
       'ED_1950_TM27': 2319,
       'ED_1950_TM30': 2320,
       'ED_1950_TM33': 2321,
       'ED_1950_TM36': 2322,
       'ED_1950_TM39': 2323,
       'ED_1950_TM42': 2324,
       'ED_1950_TM45': 2325,
       'Hong_Kong_1980_Grid': 2326,
       'Xian_1980_GK_Zone_13': 2327,
       'Xian_1980_GK_Zone_14': 2328,
       'Xian_1980_GK_Zone_15': 2329,
       'Xian_1980_GK_Zone_16': 2330,
       'Xian_1980_GK_Zone_17': 2331,
       'Xian_1980_GK_Zone_18': 2332,
       'Xian_1980_GK_Zone_19': 2333,
       'Xian_1980_GK_Zone_20': 2334,
       'Xian_1980_GK_Zone_21': 2335,
       'Xian_1980_GK_Zone_22': 2336,
       'Xian_1980_GK_Zone_23': 2337,
       'Xian_1980_GK_CM_75E': 2338,
       'Xian_1980_GK_CM_81E': 2339,
       'Xian_1980_GK_CM_87E': 2340,
       'Xian_1980_GK_CM_93E': 2341,
       'Xian_1980_GK_CM_99E': 2342,
       'Xian_1980_GK_CM_105E': 2343,
       'Xian_1980_GK_CM_111E': 2344,
       'Xian_1980_GK_CM_117E': 2345,
       'Xian_1980_GK_CM_123E': 2346,
       'Xian_1980_GK_CM_129E': 2347,
       'Xian_1980_GK_CM_135E': 2348,
       'Xian_1980_3_Degree_GK_Zone_25': 2349,
       'Xian_1980_3_Degree_GK_Zone_26': 2350,
       'Xian_1980_3_Degree_GK_Zone_27': 2351,
       'Xian_1980_3_Degree_GK_Zone_28': 2352,
       'Xian_1980_3_Degree_GK_Zone_29': 2353,
       'Xian_1980_3_Degree_GK_Zone_30': 2354,
       'Xian_1980_3_Degree_GK_Zone_31': 2355,
       'Xian_1980_3_Degree_GK_Zone_32': 2356,
       'Xian_1980_3_Degree_GK_Zone_33': 2357,
       'Xian_1980_3_Degree_GK_Zone_34': 2358,
       'Xian_1980_3_Degree_GK_Zone_35': 2359,
       'Xian_1980_3_Degree_GK_Zone_36': 2360,
       'Xian_1980_3_Degree_GK_Zone_37': 2361,
       'Xian_1980_3_Degree_GK_Zone_38': 2362,
       'Xian_1980_3_Degree_GK_Zone_39': 2363,
       'Xian_1980_3_Degree_GK_Zone_40': 2364,
       'Xian_1980_3_Degree_GK_Zone_41': 2365,
       'Xian_1980_3_Degree_GK_Zone_42': 2366,
       'Xian_1980_3_Degree_GK_Zone_43': 2367,
       'Xian_1980_3_Degree_GK_Zone_44': 2368,
       'Xian_1980_3_Degree_GK_Zone_45': 2369,
       'Xian_1980_3_Degree_GK_CM_75E': 2370,
       'Xian_1980_3_Degree_GK_CM_78E': 2371,
       'Xian_1980_3_Degree_GK_CM_81E': 2372,
       'Xian_1980_3_Degree_GK_CM_84E': 2373,
       'Xian_1980_3_Degree_GK_CM_87E': 2374,
       'Xian_1980_3_Degree_GK_CM_90E': 2375,
       'Xian_1980_3_Degree_GK_CM_93E': 2376,
       'Xian_1980_3_Degree_GK_CM_96E': 2377,
       'Xian_1980_3_Degree_GK_CM_99E': 2378,
       'Xian_1980_3_Degree_GK_CM_102E': 2379,
       'Xian_1980_3_Degree_GK_CM_105E': 2380,
       'Xian_1980_3_Degree_GK_CM_108E': 2381,
       'Xian_1980_3_Degree_GK_CM_111E': 2382,
       'Xian_1980_3_Degree_GK_CM_114E': 2383,
       'Xian_1980_3_Degree_GK_CM_117E': 2384,
       'Xian_1980_3_Degree_GK_CM_120E': 2385,
       'Xian_1980_3_Degree_GK_CM_123E': 2386,
       'Xian_1980_3_Degree_GK_CM_126E': 2387,
       'Xian_1980_3_Degree_GK_CM_129E': 2388,
       'Xian_1980_3_Degree_GK_CM_132E': 2389,
       'Xian_1980_3_Degree_GK_CM_135E': 2390,
       'Finland_Zone_1': 2391,
       'Finland_Zone_2': 2392,
       'Finland_Zone_3': 2393,
       'Finland_Zone_4': 2394,
       'South_Yemen_GK_Zone_8': 2395,
       'South_Yemen_GK_Zone_9': 2396,
       'Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_3': 2397,
       'Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_4': 2398,
       'Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_5': 2399,
       'RT90_25_gon_W': 2400,
       'Beijing_1954_3_Degree_GK_Zone_25': 2401,
       'Beijing_1954_3_Degree_GK_Zone_26': 2402,
       'Beijing_1954_3_Degree_GK_Zone_27': 2403,
       'Beijing_1954_3_Degree_GK_Zone_28': 2404,
       'Beijing_1954_3_Degree_GK_Zone_29': 2405,
       'Beijing_1954_3_Degree_GK_Zone_30': 2406,
       'Beijing_1954_3_Degree_GK_Zone_31': 2407,
       'Beijing_1954_3_Degree_GK_Zone_32': 2408,
       'Beijing_1954_3_Degree_GK_Zone_33': 2409,
       'Beijing_1954_3_Degree_GK_Zone_34': 2410,
       'Beijing_1954_3_Degree_GK_Zone_35': 2411,
       'Beijing_1954_3_Degree_GK_Zone_36': 2412,
       'Beijing_1954_3_Degree_GK_Zone_37': 2413,
       'Beijing_1954_3_Degree_GK_Zone_38': 2414,
       'Beijing_1954_3_Degree_GK_Zone_39': 2415,
       'Beijing_1954_3_Degree_GK_Zone_40': 2416,
       'Beijing_1954_3_Degree_GK_Zone_41': 2417,
       'Beijing_1954_3_Degree_GK_Zone_42': 2418,
       'Beijing_1954_3_Degree_GK_Zone_43': 2419,
       'Beijing_1954_3_Degree_GK_Zone_44': 2420,
       'Beijing_1954_3_Degree_GK_Zone_45': 2421,
       'Beijing_1954_3_Degree_GK_CM_75E': 2422,
       'Beijing_1954_3_Degree_GK_CM_78E': 2423,
       'Beijing_1954_3_Degree_GK_CM_81E': 2424,
       'Beijing_1954_3_Degree_GK_CM_84E': 2425,
       'Beijing_1954_3_Degree_GK_CM_87E': 2426,
       'Beijing_1954_3_Degree_GK_CM_90E': 2427,
       'Beijing_1954_3_Degree_GK_CM_93E': 2428,
       'Beijing_1954_3_Degree_GK_CM_96E': 2429,
       'Beijing_1954_3_Degree_GK_CM_99E': 2430,
       'Beijing_1954_3_Degree_GK_CM_102E': 2431,
       'Beijing_1954_3_Degree_GK_CM_105E': 2432,
       'Beijing_1954_3_Degree_GK_CM_108E': 2433,
       'Beijing_1954_3_Degree_GK_CM_111E': 2434,
       'Beijing_1954_3_Degree_GK_CM_114E': 2435,
       'Beijing_1954_3_Degree_GK_CM_117E': 2436,
       'Beijing_1954_3_Degree_GK_CM_120E': 2437,
       'Beijing_1954_3_Degree_GK_CM_123E': 2438,
       'Beijing_1954_3_Degree_GK_CM_126E': 2439,
       'Beijing_1954_3_Degree_GK_CM_129E': 2440,
       'Beijing_1954_3_Degree_GK_CM_132E': 2441,
       'Beijing_1954_3_Degree_GK_CM_135E': 2442,
       'JGD_2000_Japan_Zone_1': 2443,
       'JGD_2000_Japan_Zone_2': 2444,
       'JGD_2000_Japan_Zone_3': 2445,
       'JGD_2000_Japan_Zone_4': 2446,
       'JGD_2000_Japan_Zone_5': 2447,
       'JGD_2000_Japan_Zone_6': 2448,
       'JGD_2000_Japan_Zone_7': 2449,
       'JGD_2000_Japan_Zone_8': 2450,
       'JGD_2000_Japan_Zone_9': 2451,
       'JGD_2000_Japan_Zone_10': 2452,
       'JGD_2000_Japan_Zone_11': 2453,
       'JGD_2000_Japan_Zone_12': 2454,
       'JGD_2000_Japan_Zone_13': 2455,
       'JGD_2000_Japan_Zone_14': 2456,
       'JGD_2000_Japan_Zone_15': 2457,
       'JGD_2000_Japan_Zone_16': 2458,
       'JGD_2000_Japan_Zone_17': 2459,
       'JGD_2000_Japan_Zone_18': 2460,
       'JGD_2000_Japan_Zone_19': 2461,
       'Albanian_1987_GK_Zone_4': 2462,
       'Pulkovo_1942_3_Degree_GK_Zone_7': 2523,
       'Pulkovo_1942_3_Degree_GK_Zone_8': 2524,
       'Pulkovo_1942_3_Degree_GK_Zone_9': 2525,
       'Pulkovo_1942_3_Degree_GK_Zone_10': 2526,
       'Pulkovo_1942_3_Degree_GK_Zone_11': 2527,
       'Pulkovo_1942_3_Degree_GK_Zone_12': 2528,
       'Pulkovo_1942_3_Degree_GK_Zone_13': 2529,
       'Pulkovo_1942_3_Degree_GK_Zone_14': 2530,
       'Pulkovo_1942_3_Degree_GK_Zone_15': 2531,
       'Pulkovo_1942_3_Degree_GK_Zone_16': 2532,
       'Pulkovo_1942_3_Degree_GK_Zone_17': 2533,
       'Pulkovo_1942_3_Degree_GK_Zone_18': 2534,
       'Pulkovo_1942_3_Degree_GK_Zone_19': 2535,
       'Pulkovo_1942_3_Degree_GK_Zone_20': 2536,
       'Pulkovo_1942_3_Degree_GK_Zone_21': 2537,
       'Pulkovo_1942_3_Degree_GK_Zone_22': 2538,
       'Pulkovo_1942_3_Degree_GK_Zone_23': 2539,
       'Pulkovo_1942_3_Degree_GK_Zone_24': 2540,
       'Pulkovo_1942_3_Degree_GK_Zone_25': 2541,
       'Pulkovo_1942_3_Degree_GK_Zone_26': 2542,
       'Pulkovo_1942_3_Degree_GK_Zone_27': 2543,
       'Pulkovo_1942_3_Degree_GK_Zone_28': 2544,
       'Pulkovo_1942_3_Degree_GK_Zone_29': 2545,
       'Pulkovo_1942_3_Degree_GK_Zone_30': 2546,
       'Pulkovo_1942_3_Degree_GK_Zone_31': 2547,
       'Pulkovo_1942_3_Degree_GK_Zone_32': 2548,
       'Pulkovo_1942_3_Degree_GK_Zone_33': 2549,
       'Samboja_UTM_Zone_50S': 2550,
       'Pulkovo_1942_3_Degree_GK_Zone_34': 2551,
       'Pulkovo_1942_3_Degree_GK_Zone_35': 2552,
       'Pulkovo_1942_3_Degree_GK_Zone_36': 2553,
       'Pulkovo_1942_3_Degree_GK_Zone_37': 2554,
       'Pulkovo_1942_3_Degree_GK_Zone_38': 2555,
       'Pulkovo_1942_3_Degree_GK_Zone_39': 2556,
       'Pulkovo_1942_3_Degree_GK_Zone_40': 2557,
       'Pulkovo_1942_3_Degree_GK_Zone_41': 2558,
       'Pulkovo_1942_3_Degree_GK_Zone_42': 2559,
       'Pulkovo_1942_3_Degree_GK_Zone_43': 2560,
       'Pulkovo_1942_3_Degree_GK_Zone_44': 2561,
       'Pulkovo_1942_3_Degree_GK_Zone_45': 2562,
       'Pulkovo_1942_3_Degree_GK_Zone_46': 2563,
       'Pulkovo_1942_3_Degree_GK_Zone_47': 2564,
       'Pulkovo_1942_3_Degree_GK_Zone_48': 2565,
       'Pulkovo_1942_3_Degree_GK_Zone_49': 2566,
       'Pulkovo_1942_3_Degree_GK_Zone_50': 2567,
       'Pulkovo_1942_3_Degree_GK_Zone_51': 2568,
       'Pulkovo_1942_3_Degree_GK_Zone_52': 2569,
       'Pulkovo_1942_3_Degree_GK_Zone_53': 2570,
       'Pulkovo_1942_3_Degree_GK_Zone_54': 2571,
       'Pulkovo_1942_3_Degree_GK_Zone_55': 2572,
       'Pulkovo_1942_3_Degree_GK_Zone_56': 2573,
       'Pulkovo_1942_3_Degree_GK_Zone_57': 2574,
       'Pulkovo_1942_3_Degree_GK_Zone_58': 2575,
       'Pulkovo_1942_3_Degree_GK_Zone_59': 2576,
       'Pulkovo_1942_3_Degree_GK_Zone_60': 2577,
       'Pulkovo_1942_3_Degree_GK_Zone_61': 2578,
       'Pulkovo_1942_3_Degree_GK_Zone_62': 2579,
       'Pulkovo_1942_3_Degree_GK_Zone_63': 2580,
       'Pulkovo_1942_3_Degree_GK_Zone_64': 2581,
       'Pulkovo_1942_3_Degree_GK_CM_21E': 2582,
       'Pulkovo_1942_3_Degree_GK_CM_24E': 2583,
       'Pulkovo_1942_3_Degree_GK_CM_27E': 2584,
       'Pulkovo_1942_3_Degree_GK_CM_30E': 2585,
       'Pulkovo_1942_3_Degree_GK_CM_33E': 2586,
       'Pulkovo_1942_3_Degree_GK_CM_36E': 2587,
       'Pulkovo_1942_3_Degree_GK_CM_39E': 2588,
       'Pulkovo_1942_3_Degree_GK_CM_42E': 2589,
       'Pulkovo_1942_3_Degree_GK_CM_45E': 2590,
       'Pulkovo_1942_3_Degree_GK_CM_48E': 2591,
       'Pulkovo_1942_3_Degree_GK_CM_51E': 2592,
       'Pulkovo_1942_3_Degree_GK_CM_54E': 2593,
       'Pulkovo_1942_3_Degree_GK_CM_57E': 2594,
       'Pulkovo_1942_3_Degree_GK_CM_60E': 2595,
       'Pulkovo_1942_3_Degree_GK_CM_63E': 2596,
       'Pulkovo_1942_3_Degree_GK_CM_66E': 2597,
       'Pulkovo_1942_3_Degree_GK_CM_69E': 2598,
       'Pulkovo_1942_3_Degree_GK_CM_72E': 2599,
       'Lietuvos_Koordinaciu_Sistema': 2600,
       'Pulkovo_1942_3_Degree_GK_CM_75E': 2601,
       'Pulkovo_1942_3_Degree_GK_CM_78E': 2602,
       'Pulkovo_1942_3_Degree_GK_CM_81E': 2603,
       'Pulkovo_1942_3_Degree_GK_CM_84E': 2604,
       'Pulkovo_1942_3_Degree_GK_CM_87E': 2605,
       'Pulkovo_1942_3_Degree_GK_CM_90E': 2606,
       'Pulkovo_1942_3_Degree_GK_CM_93E': 2607,
       'Pulkovo_1942_3_Degree_GK_CM_96E': 2608,
       'Pulkovo_1942_3_Degree_GK_CM_99E': 2609,
       'Pulkovo_1942_3_Degree_GK_CM_102E': 2610,
       'Pulkovo_1942_3_Degree_GK_CM_105E': 2611,
       'Pulkovo_1942_3_Degree_GK_CM_108E': 2612,
       'Pulkovo_1942_3_Degree_GK_CM_111E': 2613,
       'Pulkovo_1942_3_Degree_GK_CM_114E': 2614,
       'Pulkovo_1942_3_Degree_GK_CM_117E': 2615,
       'Pulkovo_1942_3_Degree_GK_CM_120E': 2616,
       'Pulkovo_1942_3_Degree_GK_CM_123E': 2617,
       'Pulkovo_1942_3_Degree_GK_CM_126E': 2618,
       'Pulkovo_1942_3_Degree_GK_CM_129E': 2619,
       'Pulkovo_1942_3_Degree_GK_CM_132E': 2620,
       'Pulkovo_1942_3_Degree_GK_CM_135E': 2621,
       'Pulkovo_1942_3_Degree_GK_CM_138E': 2622,
       'Pulkovo_1942_3_Degree_GK_CM_141E': 2623,
       'Pulkovo_1942_3_Degree_GK_CM_144E': 2624,
       'Pulkovo_1942_3_Degree_GK_CM_147E': 2625,
       'Pulkovo_1942_3_Degree_GK_CM_150E': 2626,
       'Pulkovo_1942_3_Degree_GK_CM_153E': 2627,
       'Pulkovo_1942_3_Degree_GK_CM_156E': 2628,
       'Pulkovo_1942_3_Degree_GK_CM_159E': 2629,
       'Pulkovo_1942_3_Degree_GK_CM_162E': 2630,
       'Pulkovo_1942_3_Degree_GK_CM_165E': 2631,
       'Pulkovo_1942_3_Degree_GK_CM_168E': 2632,
       'Pulkovo_1942_3_Degree_GK_CM_171E': 2633,
       'Pulkovo_1942_3_Degree_GK_CM_174E': 2634,
       'Pulkovo_1942_3_Degree_GK_CM_177E': 2635,
       'Pulkovo_1942_3_Degree_GK_CM_180E': 2636,
       'Pulkovo_1942_3_Degree_GK_CM_177W': 2637,
       'Pulkovo_1942_3_Degree_GK_CM_174W': 2638,
       'Pulkovo_1942_3_Degree_GK_CM_171W': 2639,
       'Pulkovo_1942_3_Degree_GK_CM_168W': 2640,
       'Pulkovo_1995_3_Degree_GK_Zone_7': 2641,
       'Pulkovo_1995_3_Degree_GK_Zone_8': 2642,
       'Pulkovo_1995_3_Degree_GK_Zone_9': 2643,
       'Pulkovo_1995_3_Degree_GK_Zone_10': 2644,
       'Pulkovo_1995_3_Degree_GK_Zone_11': 2645,
       'Pulkovo_1995_3_Degree_GK_Zone_12': 2646,
       'Pulkovo_1995_3_Degree_GK_Zone_13': 2647,
       'Pulkovo_1995_3_Degree_GK_Zone_14': 2648,
       'Pulkovo_1995_3_Degree_GK_Zone_15': 2649,
       'Pulkovo_1995_3_Degree_GK_Zone_16': 2650,
       'Pulkovo_1995_3_Degree_GK_Zone_17': 2651,
       'Pulkovo_1995_3_Degree_GK_Zone_18': 2652,
       'Pulkovo_1995_3_Degree_GK_Zone_19': 2653,
       'Pulkovo_1995_3_Degree_GK_Zone_20': 2654,
       'Pulkovo_1995_3_Degree_GK_Zone_21': 2655,
       'Pulkovo_1995_3_Degree_GK_Zone_22': 2656,
       'Pulkovo_1995_3_Degree_GK_Zone_23': 2657,
       'Pulkovo_1995_3_Degree_GK_Zone_24': 2658,
       'Pulkovo_1995_3_Degree_GK_Zone_25': 2659,
       'Pulkovo_1995_3_Degree_GK_Zone_26': 2660,
       'Pulkovo_1995_3_Degree_GK_Zone_27': 2661,
       'Pulkovo_1995_3_Degree_GK_Zone_28': 2662,
       'Pulkovo_1995_3_Degree_GK_Zone_29': 2663,
       'Pulkovo_1995_3_Degree_GK_Zone_30': 2664,
       'Pulkovo_1995_3_Degree_GK_Zone_31': 2665,
       'Pulkovo_1995_3_Degree_GK_Zone_32': 2666,
       'Pulkovo_1995_3_Degree_GK_Zone_33': 2667,
       'Pulkovo_1995_3_Degree_GK_Zone_34': 2668,
       'Pulkovo_1995_3_Degree_GK_Zone_35': 2669,
       'Pulkovo_1995_3_Degree_GK_Zone_36': 2670,
       'Pulkovo_1995_3_Degree_GK_Zone_37': 2671,
       'Pulkovo_1995_3_Degree_GK_Zone_38': 2672,
       'Pulkovo_1995_3_Degree_GK_Zone_39': 2673,
       'Pulkovo_1995_3_Degree_GK_Zone_40': 2674,
       'Pulkovo_1995_3_Degree_GK_Zone_41': 2675,
       'Pulkovo_1995_3_Degree_GK_Zone_42': 2676,
       'Pulkovo_1995_3_Degree_GK_Zone_43': 2677,
       'Pulkovo_1995_3_Degree_GK_Zone_44': 2678,
       'Pulkovo_1995_3_Degree_GK_Zone_45': 2679,
       'Pulkovo_1995_3_Degree_GK_Zone_46': 2680,
       'Pulkovo_1995_3_Degree_GK_Zone_47': 2681,
       'Pulkovo_1995_3_Degree_GK_Zone_48': 2682,
       'Pulkovo_1995_3_Degree_GK_Zone_49': 2683,
       'Pulkovo_1995_3_Degree_GK_Zone_50': 2684,
       'Pulkovo_1995_3_Degree_GK_Zone_51': 2685,
       'Pulkovo_1995_3_Degree_GK_Zone_52': 2686,
       'Pulkovo_1995_3_Degree_GK_Zone_53': 2687,
       'Pulkovo_1995_3_Degree_GK_Zone_54': 2688,
       'Pulkovo_1995_3_Degree_GK_Zone_55': 2689,
       'Pulkovo_1995_3_Degree_GK_Zone_56': 2690,
       'Pulkovo_1995_3_Degree_GK_Zone_57': 2691,
       'Pulkovo_1995_3_Degree_GK_Zone_58': 2692,
       'Pulkovo_1995_3_Degree_GK_Zone_59': 2693,
       'Pulkovo_1995_3_Degree_GK_Zone_60': 2694,
       'Pulkovo_1995_3_Degree_GK_Zone_61': 2695,
       'Pulkovo_1995_3_Degree_GK_Zone_62': 2696,
       'Pulkovo_1995_3_Degree_GK_Zone_63': 2697,
       'Pulkovo_1995_3_Degree_GK_Zone_64': 2698,
       'Pulkovo_1995_3_Degree_GK_CM_21E': 2699,
       'Pulkovo_1995_3_Degree_GK_CM_24E': 2700,
       'Pulkovo_1995_3_Degree_GK_CM_27E': 2701,
       'Pulkovo_1995_3_Degree_GK_CM_30E': 2702,
       'Pulkovo_1995_3_Degree_GK_CM_33E': 2703,
       'Pulkovo_1995_3_Degree_GK_CM_36E': 2704,
       'Pulkovo_1995_3_Degree_GK_CM_39E': 2705,
       'Pulkovo_1995_3_Degree_GK_CM_42E': 2706,
       'Pulkovo_1995_3_Degree_GK_CM_45E': 2707,
       'Pulkovo_1995_3_Degree_GK_CM_48E': 2708,
       'Pulkovo_1995_3_Degree_GK_CM_51E': 2709,
       'Pulkovo_1995_3_Degree_GK_CM_54E': 2710,
       'Pulkovo_1995_3_Degree_GK_CM_57E': 2711,
       'Pulkovo_1995_3_Degree_GK_CM_60E': 2712,
       'Pulkovo_1995_3_Degree_GK_CM_63E': 2713,
       'Pulkovo_1995_3_Degree_GK_CM_66E': 2714,
       'Pulkovo_1995_3_Degree_GK_CM_69E': 2715,
       'Pulkovo_1995_3_Degree_GK_CM_72E': 2716,
       'Pulkovo_1995_3_Degree_GK_CM_75E': 2717,
       'Pulkovo_1995_3_Degree_GK_CM_78E': 2718,
       'Pulkovo_1995_3_Degree_GK_CM_81E': 2719,
       'Pulkovo_1995_3_Degree_GK_CM_84E': 2720,
       'Pulkovo_1995_3_Degree_GK_CM_87E': 2721,
       'Pulkovo_1995_3_Degree_GK_CM_90E': 2722,
       'Pulkovo_1995_3_Degree_GK_CM_93E': 2723,
       'Pulkovo_1995_3_Degree_GK_CM_96E': 2724,
       'Pulkovo_1995_3_Degree_GK_CM_99E': 2725,
       'Pulkovo_1995_3_Degree_GK_CM_102E': 2726,
       'Pulkovo_1995_3_Degree_GK_CM_105E': 2727,
       'Pulkovo_1995_3_Degree_GK_CM_108E': 2728,
       'Pulkovo_1995_3_Degree_GK_CM_111E': 2729,
       'Pulkovo_1995_3_Degree_GK_CM_114E': 2730,
       'Pulkovo_1995_3_Degree_GK_CM_117E': 2731,
       'Pulkovo_1995_3_Degree_GK_CM_120E': 2732,
       'Pulkovo_1995_3_Degree_GK_CM_123E': 2733,
       'Pulkovo_1995_3_Degree_GK_CM_126E': 2734,
       'Pulkovo_1995_3_Degree_GK_CM_129E': 2735,
       'Tete_UTM_Zone_36S': 2736,
       'Tete_UTM_Zone_37S': 2737,
       'Pulkovo_1995_3_Degree_GK_CM_132E': 2738,
       'Pulkovo_1995_3_Degree_GK_CM_135E': 2739,
       'Pulkovo_1995_3_Degree_GK_CM_138E': 2740,
       'Pulkovo_1995_3_Degree_GK_CM_141E': 2741,
       'Pulkovo_1995_3_Degree_GK_CM_144E': 2742,
       'Pulkovo_1995_3_Degree_GK_CM_147E': 2743,
       'Pulkovo_1995_3_Degree_GK_CM_150E': 2744,
       'Pulkovo_1995_3_Degree_GK_CM_153E': 2745,
       'Pulkovo_1995_3_Degree_GK_CM_156E': 2746,
       'Pulkovo_1995_3_Degree_GK_CM_159E': 2747,
       'Pulkovo_1995_3_Degree_GK_CM_162E': 2748,
       'Pulkovo_1995_3_Degree_GK_CM_165E': 2749,
       'Pulkovo_1995_3_Degree_GK_CM_168E': 2750,
       'Pulkovo_1995_3_Degree_GK_CM_171E': 2751,
       'Pulkovo_1995_3_Degree_GK_CM_174E': 2752,
       'Pulkovo_1995_3_Degree_GK_CM_177E': 2753,
       'Pulkovo_1995_3_Degree_GK_CM_180E': 2754,
       'Pulkovo_1995_3_Degree_GK_CM_177W': 2755,
       'Pulkovo_1995_3_Degree_GK_CM_174W': 2756,
       'Pulkovo_1995_3_Degree_GK_CM_171W': 2757,
       'Pulkovo_1995_3_Degree_GK_CM_168W': 2758,
       'NAD_1983_HARN_StatePlane_Alabama_East_FIPS_0101': 2759,
       'NAD_1983_HARN_StatePlane_Alabama_West_FIPS_0102': 2760,
       'NAD_1983_HARN_StatePlane_Arizona_East_FIPS_0201': 2761,
       'NAD_1983_HARN_StatePlane_Arizona_Central_FIPS_0202': 2762,
       'NAD_1983_HARN_StatePlane_Arizona_West_FIPS_0203': 2763,
       'NAD_1983_HARN_StatePlane_Arkansas_North_FIPS_0301': 2764,
       'NAD_1983_HARN_StatePlane_Arkansas_South_FIPS_0302': 2765,
       'NAD_1983_HARN_StatePlane_California_I_FIPS_0401': 2766,
       'NAD_1983_HARN_StatePlane_California_II_FIPS_0402': 2767,
       'NAD_1983_HARN_StatePlane_California_III_FIPS_0403': 2768,
       'NAD_1983_HARN_StatePlane_California_IV_FIPS_0404': 2769,
       'NAD_1983_HARN_StatePlane_California_V_FIPS_0405': 2770,
       'NAD_1983_HARN_StatePlane_California_VI_FIPS_0406': 2771,
       'NAD_1983_HARN_StatePlane_Colorado_North_FIPS_0501': 2772,
       'NAD_1983_HARN_StatePlane_Colorado_Central_FIPS_0502': 2773,
       'NAD_1983_HARN_StatePlane_Colorado_South_FIPS_0503': 2774,
       'NAD_1983_HARN_StatePlane_Connecticut_FIPS_0600': 2775,
       'NAD_1983_HARN_StatePlane_Delaware_FIPS_0700': 2776,
       'NAD_1983_HARN_StatePlane_Florida_East_FIPS_0901': 2777,
       'NAD_1983_HARN_StatePlane_Florida_West_FIPS_0902': 2778,
       'NAD_1983_HARN_StatePlane_Florida_North_FIPS_0903': 2779,
       'NAD_1983_HARN_StatePlane_Georgia_East_FIPS_1001': 2780,
       'NAD_1983_HARN_StatePlane_Georgia_West_FIPS_1002': 2781,
       'NAD_1983_HARN_StatePlane_Hawaii_1_FIPS_5101': 2782,
       'NAD_1983_HARN_StatePlane_Hawaii_2_FIPS_5102': 2783,
       'NAD_1983_HARN_StatePlane_Hawaii_3_FIPS_5103': 2784,
       'NAD_1983_HARN_StatePlane_Hawaii_4_FIPS_5104': 2785,
       'NAD_1983_HARN_StatePlane_Hawaii_5_FIPS_5105': 2786,
       'NAD_1983_HARN_StatePlane_Idaho_East_FIPS_1101': 2787,
       'NAD_1983_HARN_StatePlane_Idaho_Central_FIPS_1102': 2788,
       'NAD_1983_HARN_StatePlane_Idaho_West_FIPS_1103': 2789,
       'NAD_1983_HARN_StatePlane_Illinois_East_FIPS_1201': 2790,
       'NAD_1983_HARN_StatePlane_Illinois_West_FIPS_1202': 2791,
       'NAD_1983_HARN_StatePlane_Indiana_East_FIPS_1301': 2792,
       'NAD_1983_HARN_StatePlane_Indiana_West_FIPS_1302': 2793,
       'NAD_1983_HARN_StatePlane_Iowa_North_FIPS_1401': 2794,
       'NAD_1983_HARN_StatePlane_Iowa_South_FIPS_1402': 2795,
       'NAD_1983_HARN_StatePlane_Kansas_North_FIPS_1501': 2796,
       'NAD_1983_HARN_StatePlane_Kansas_South_FIPS_1502': 2797,
       'NAD_1983_HARN_StatePlane_Kentucky_North_FIPS_1601': 2798,
       'NAD_1983_HARN_StatePlane_Kentucky_South_FIPS_1602': 2799,
       'NAD_1983_HARN_StatePlane_Louisiana_North_FIPS_1701': 2800,
       'NAD_1983_HARN_StatePlane_Louisiana_South_FIPS_1702': 2801,
       'NAD_1983_HARN_StatePlane_Maine_East_FIPS_1801': 2802,
       'NAD_1983_HARN_StatePlane_Maine_West_FIPS_1802': 2803,
       'NAD_1983_HARN_StatePlane_Maryland_FIPS_1900': 2804,
       'NAD_1983_HARN_StatePlane_Massachusetts_Mainland_FIPS_2001': 2805,
       'NAD_1983_HARN_StatePlane_Massachusetts_Island_FIPS_2002': 2806,
       'NAD_1983_HARN_StatePlane_Michigan_North_FIPS_2111': 2807,
       'NAD_1983_HARN_StatePlane_Michigan_Central_FIPS_2112': 2808,
       'NAD_1983_HARN_StatePlane_Michigan_South_FIPS_2113': 2809,
       'NAD_1983_HARN_StatePlane_Minnesota_North_FIPS_2201': 2810,
       'NAD_1983_HARN_StatePlane_Minnesota_Central_FIPS_2202': 2811,
       'NAD_1983_HARN_StatePlane_Minnesota_South_FIPS_2203': 2812,
       'NAD_1983_HARN_StatePlane_Mississippi_East_FIPS_2301': 2813,
       'NAD_1983_HARN_StatePlane_Mississippi_West_FIPS_2302': 2814,
       'NAD_1983_HARN_StatePlane_Missouri_East_FIPS_2401': 2815,
       'NAD_1983_HARN_StatePlane_Missouri_Central_FIPS_2402': 2816,
       'NAD_1983_HARN_StatePlane_Missouri_West_FIPS_2403': 2817,
       'NAD_1983_HARN_StatePlane_Montana_FIPS_2500': 2818,
       'NAD_1983_HARN_StatePlane_Nebraska_FIPS_2600': 2819,
       'NAD_1983_HARN_StatePlane_Nevada_East_FIPS_2701': 2820,
       'NAD_1983_HARN_StatePlane_Nevada_Central_FIPS_2702': 2821,
       'NAD_1983_HARN_StatePlane_Nevada_West_FIPS_2703': 2822,
       'NAD_1983_HARN_StatePlane_New_Hampshire_FIPS_2800': 2823,
       'NAD_1983_HARN_StatePlane_New_Jersey_FIPS_2900': 2824,
       'NAD_1983_HARN_StatePlane_New_Mexico_East_FIPS_3001': 2825,
       'NAD_1983_HARN_StatePlane_New_Mexico_Central_FIPS_3002': 2826,
       'NAD_1983_HARN_StatePlane_New_Mexico_West_FIPS_3003': 2827,
       'NAD_1983_HARN_StatePlane_New_York_East_FIPS_3101': 2828,
       'NAD_1983_HARN_StatePlane_New_York_Central_FIPS_3102': 2829,
       'NAD_1983_HARN_StatePlane_New_York_West_FIPS_3103': 2830,
       'NAD_1983_HARN_StatePlane_New_York_Long_Island_FIPS_3104': 2831,
       'NAD_1983_HARN_StatePlane_North_Dakota_North_FIPS_3301': 2832,
       'NAD_1983_HARN_StatePlane_North_Dakota_South_FIPS_3302': 2833,
       'NAD_1983_HARN_StatePlane_Ohio_North_FIPS_3401': 2834,
       'NAD_1983_HARN_StatePlane_Ohio_South_FIPS_3402': 2835,
       'NAD_1983_HARN_StatePlane_Oklahoma_North_FIPS_3501': 2836,
       'NAD_1983_HARN_StatePlane_Oklahoma_South_FIPS_3502': 2837,
       'NAD_1983_HARN_StatePlane_Oregon_North_FIPS_3601': 2838,
       'NAD_1983_HARN_StatePlane_Oregon_South_FIPS_3602': 2839,
       'NAD_1983_HARN_StatePlane_Rhode_Island_FIPS_3800': 2840,
       'NAD_1983_HARN_StatePlane_South_Dakota_North_FIPS_4001': 2841,
       'NAD_1983_HARN_StatePlane_South_Dakota_South_FIPS_4002': 2842,
       'NAD_1983_HARN_StatePlane_Tennessee_FIPS_4100': 2843,
       'NAD_1983_HARN_StatePlane_Texas_North_FIPS_4201': 2844,
       'NAD_1983_HARN_StatePlane_Texas_North_Central_FIPS_4202': 2845,
       'NAD_1983_HARN_StatePlane_Texas_Central_FIPS_4203': 2846,
       'NAD_1983_HARN_StatePlane_Texas_South_Central_FIPS_4204': 2847,
       'NAD_1983_HARN_StatePlane_Texas_South_FIPS_4205': 2848,
       'NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301': 2849,
       'NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302': 2850,
       'NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303': 2851,
       'NAD_1983_HARN_StatePlane_Vermont_FIPS_4400': 2852,
       'NAD_1983_HARN_StatePlane_Virginia_North_FIPS_4501': 2853,
       'NAD_1983_HARN_StatePlane_Virginia_South_FIPS_4502': 2854,
       'NAD_1983_HARN_StatePlane_Washington_North_FIPS_4601': 2855,
       'NAD_1983_HARN_StatePlane_Washington_South_FIPS_4602': 2856,
       'NAD_1983_HARN_StatePlane_West_Virginia_North_FIPS_4701': 2857,
       'NAD_1983_HARN_StatePlane_West_Virginia_South_FIPS_4702': 2858,
       'NAD_1983_HARN_StatePlane_Wisconsin_North_FIPS_4801': 2859,
       'NAD_1983_HARN_StatePlane_Wisconsin_Central_FIPS_4802': 2860,
       'NAD_1983_HARN_StatePlane_Wisconsin_South_FIPS_4803': 2861,
       'NAD_1983_HARN_StatePlane_Wyoming_East_FIPS_4901': 2862,
       'NAD_1983_HARN_StatePlane_Wyoming_East_Central_FIPS_4902': 2863,
       'NAD_1983_HARN_StatePlane_Wyoming_West_Central_FIPS_4903': 2864,
       'NAD_1983_HARN_StatePlane_Wyoming_West_FIPS_4904': 2865,
       'NAD_1983_HARN_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200': 2866,
       'NAD_1983_HARN_StatePlane_Arizona_East_FIPS_0201_Feet_Intl': 2867,
       'NAD_1983_HARN_StatePlane_Arizona_Central_FIPS_0202_Feet_Intl': 2868,
       'NAD_1983_HARN_StatePlane_Arizona_West_FIPS_0203_Feet_Intl': 2869,
       'NAD_1983_HARN_StatePlane_California_I_FIPS_0401_Feet': 2870,
       'NAD_1983_HARN_StatePlane_California_II_FIPS_0402_Feet': 2871,
       'NAD_1983_HARN_StatePlane_California_III_FIPS_0403_Feet': 2872,
       'NAD_1983_HARN_StatePlane_California_IV_FIPS_0404_Feet': 2873,
       'NAD_1983_HARN_StatePlane_California_V_FIPS_0405_Feet': 2874,
       'NAD_1983_HARN_StatePlane_California_VI_FIPS_0406_Feet': 2875,
       'NAD_1983_HARN_StatePlane_Colorado_North_FIPS_0501_Feet': 2876,
       'NAD_1983_HARN_StatePlane_Colorado_Central_FIPS_0502_Feet': 2877,
       'NAD_1983_HARN_StatePlane_Colorado_South_FIPS_0503_Feet': 2878,
       'NAD_1983_HARN_StatePlane_Connecticut_FIPS_0600_Feet': 2879,
       'NAD_1983_HARN_StatePlane_Delaware_FIPS_0700_Feet': 2880,
       'NAD_1983_HARN_StatePlane_Florida_East_FIPS_0901_Feet': 2881,
       'NAD_1983_HARN_StatePlane_Florida_West_FIPS_0902_Feet': 2882,
       'NAD_1983_HARN_StatePlane_Florida_North_FIPS_0903_Feet': 2883,
       'NAD_1983_HARN_StatePlane_Georgia_East_FIPS_1001_Feet': 2884,
       'NAD_1983_HARN_StatePlane_Georgia_West_FIPS_1002_Feet': 2885,
       'NAD_1983_HARN_StatePlane_Idaho_East_FIPS_1101_Feet': 2886,
       'NAD_1983_HARN_StatePlane_Idaho_Central_FIPS_1102_Feet': 2887,
       'NAD_1983_HARN_StatePlane_Idaho_West_FIPS_1103_Feet': 2888,
       'NAD_1983_HARN_StatePlane_Kentucky_North_FIPS_1601_Feet': 2891,
       'NAD_1983_HARN_StatePlane_Kentucky_South_FIPS_1602_Feet': 2892,
       'NAD_1983_HARN_StatePlane_Maryland_FIPS_1900_Feet': 2893,
       'NAD_1983_HARN_StatePlane_Massachusetts_Mainland_FIPS_2001_Feet': 2894,
       'NAD_1983_HARN_StatePlane_Massachusetts_Island_FIPS_2002_Feet': 2895,
       'NAD_1983_HARN_StatePlane_Michigan_North_FIPS_2111_Feet_Intl': 2896,
       'NAD_1983_HARN_StatePlane_Michigan_Central_FIPS_2112_Feet_Intl': 2897,
       'NAD_1983_HARN_StatePlane_Michigan_South_FIPS_2113_Feet_Intl': 2898,
       'NAD_1983_HARN_StatePlane_Mississippi_East_FIPS_2301_Feet': 2899,
       'NAD_1983_HARN_StatePlane_Mississippi_West_FIPS_2302_Feet': 2900,
       'NAD_1983_HARN_StatePlane_Montana_FIPS_2500_Feet_Intl': 2901,
       'NAD_1983_HARN_StatePlane_New_Mexico_East_FIPS_3001_Feet': 2902,
       'NAD_1983_HARN_StatePlane_New_Mexico_Central_FIPS_3002_Feet': 2903,
       'NAD_1983_HARN_StatePlane_New_Mexico_West_FIPS_3003_Feet': 2904,
       'NAD_1983_HARN_StatePlane_New_York_East_FIPS_3101_Feet': 2905,
       'NAD_1983_HARN_StatePlane_New_York_Central_FIPS_3102_Feet': 2906,
       'NAD_1983_HARN_StatePlane_New_York_West_FIPS_3103_Feet': 2907,
       'NAD_1983_HARN_StatePlane_New_York_Long_Island_FIPS_3104_Feet': 2908,
       'NAD_1983_HARN_StatePlane_North_Dakota_North_FIPS_3301_Feet_Intl': 2909,
       'NAD_1983_HARN_StatePlane_North_Dakota_South_FIPS_3302_Feet_Intl': 2910,
       'NAD_1983_HARN_StatePlane_Oklahoma_North_FIPS_3501_Feet': 2911,
       'NAD_1983_HARN_StatePlane_Oklahoma_South_FIPS_3502_Feet': 2912,
       'NAD_1983_HARN_StatePlane_Oregon_North_FIPS_3601_Feet_Intl': 2913,
       'NAD_1983_HARN_StatePlane_Oregon_South_FIPS_3602_Feet_Intl': 2914,
       'NAD_1983_HARN_StatePlane_Tennessee_FIPS_4100_Feet': 2915,
       'NAD_1983_HARN_StatePlane_Texas_North_FIPS_4201_Feet': 2916,
       'NAD_1983_HARN_StatePlane_Texas_North_Central_FIPS_4202_Feet': 2917,
       'NAD_1983_HARN_StatePlane_Texas_Central_FIPS_4203_Feet': 2918,
       'NAD_1983_HARN_StatePlane_Texas_South_Central_FIPS_4204_Feet': 2919,
       'NAD_1983_HARN_StatePlane_Texas_South_FIPS_4205_Feet': 2920,
       'NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301_Feet_Intl': 2921,
       'NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302_Feet_Intl': 2922,
       'NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303_Feet_Intl': 2923,
       'NAD_1983_HARN_StatePlane_Virginia_North_FIPS_4501_Feet': 2924,
       'NAD_1983_HARN_StatePlane_Virginia_South_FIPS_4502_Feet': 2925,
       'NAD_1983_HARN_StatePlane_Washington_North_FIPS_4601_Feet': 2926,
       'NAD_1983_HARN_StatePlane_Washington_South_FIPS_4602_Feet': 2927,
       'NAD_1983_HARN_StatePlane_Wisconsin_North_FIPS_4801_Feet': 2928,
       'NAD_1983_HARN_StatePlane_Wisconsin_Central_FIPS_4802_Feet': 2929,
       'NAD_1983_HARN_StatePlane_Wisconsin_South_FIPS_4803_Feet': 2930,
       'Beduaram_TM_13_NE': 2931,
       'QND_1995_Qatar_National_Grid': 2932,
       'Gunung_Segara_UTM_Zone_50S': 2933,
       'Pulkovo_1942_CS63_Zone_A1': 2935,
       'Pulkovo_1942_CS63_Zone_A2': 2936,
       'Pulkovo_1942_CS63_Zone_A3': 2937,
       'Pulkovo_1942_CS63_Zone_A4': 2938,
       'Pulkovo_1942_CS63_Zone_K2': 2939,
       'Pulkovo_1942_CS63_Zone_K3': 2940,
       'Pulkovo_1942_CS63_Zone_K4': 2941,
       'Porto_Santo_1936_UTM_Zone_28N': 2942,
       'Selvagem_Grande_1938_UTM_Zone_28N': 2943,
       'NAD_1983_CSRS_MTM_2_SCoPQ': 2944,
       'NAD_1983_CSRS_MTM_3': 2945,
       'NAD_1983_CSRS_MTM_4': 2946,
       'NAD_1983_CSRS_MTM_5': 2947,
       'NAD_1983_CSRS_MTM_6': 2948,
       'NAD_1983_CSRS_MTM_7': 2949,
       'NAD_1983_CSRS_MTM_8': 2950,
       'NAD_1983_CSRS_MTM_9': 2951,
       'NAD_1983_CSRS_MTM_10': 2952,
       'NAD_1983_CSRS_New_Brunswick_Stereographic': 2953,
       'NAD_1983_CSRS_Prince_Edward_Island': 2954,
       'NAD_1983_CSRS_UTM_Zone_11N': 2955,
       'NAD_1983_CSRS_UTM_Zone_12N': 2956,
       'NAD_1983_CSRS_UTM_Zone_13N': 2957,
       'NAD_1983_CSRS_UTM_Zone_17N': 2958,
       'NAD_1983_CSRS_UTM_Zone_18N': 2959,
       'NAD_1983_CSRS_UTM_Zone_19N': 2960,
       'NAD_1983_CSRS_UTM_Zone_20N': 2961,
       'NAD_1983_CSRS_UTM_Zone_21N': 2962,
       'NAD_1927_Alaska_Albers_Feet': 2964,
       'NAD_1983_StatePlane_Indiana_East_FIPS_1301_Feet': 2965,
       'NAD_1983_StatePlane_Indiana_West_FIPS_1302_Feet': 2966,
       'NAD_1983_HARN_StatePlane_Indiana_East_FIPS_1301_Feet': 2967,
       'NAD_1983_HARN_StatePlane_Indiana_West_FIPS_1302_Feet': 2968,
       'Fort_Marigot_UTM_20N': 2969,
       'Sainte_Anne_UTM_20N': 2970,
       'CSG_1967_UTM_22N': 2971,
       'RGFG_1995_UTM_22N': 2972,
       'Fort_Desaix_UTM_20N': 2973,
       'RGR_1992_UTM_40S': 2975,
       'Tahiti_1952_UTM_6S': 2976,
       'Tahaa_1954_UTM_5S': 2977,
       'IGN72_Nuku_Hiva_UTM_7S': 2978,
       'K0_1949_UTM_42S': 2979,
       'Combani_1950_UTM_38S': 2980,
       'IGN56_Lifou_UTM_58S': 2981,
       'IGN72_Grande_Terre_UTM_58S': 2982,
       'RGNC_1991_Lambert_New_Caledonia': 2984,
       'Petrels_1972_Terre_Adelie_Polar_Stereographic': 2985,
       'Perroud_1950_Terre_Adelie_Polar_Stereographic': 2986,
       'Saint_Pierre_et_Miquelon_1950_UTM_21N': 2987,
       'MOP78_UTM_1S': 2988,
       'RRAF_1991_UTM_20N': 2989,
       'NAD_1983_Oregon_Statewide_Lambert': 2991,
       'NAD_1983_Oregon_Statewide_Lambert_Feet_Intl': 2992,
       'NAD_1983_HARN_Oregon_Statewide_Lambert': 2993,
       'NAD_1983_HARN_Oregon_Statewide_Lambert_Feet_Intl': 2994,
       'IGN53_Mare_UTM_58S': 2995,
       'ST84_Ile_des_Pins_UTM_58S': 2996,
       'ST71_Belep_UTM_58S': 2997,
       'NEA74_Noumea_UTM_58S': 2998,
       'Grand_Comoros_UTM_38S': 2999,
       'Gunung_Segara_NEIEZ': 3000,
       'Batavia_NEIEZ': 3001,
       'Makassar_NEIEZ': 3002,
       'Monte_Mario_Italy_1': 3003,
       'Monte_Mario_Italy_2': 3004,
       'NAD_1983_BC_Environment_Albers': 3005,
       'SWEREF99_TM': 3006,
       'SWEREF99_12_00': 3007,
       'SWEREF99_13_30': 3008,
       'SWEREF99_15_00': 3009,
       'SWEREF99_16_30': 3010,
       'SWEREF99_18_00': 3011,
       'SWEREF99_14_15': 3012,
       'SWEREF99_15_45': 3013,
       'SWEREF99_17_15': 3014,
       'SWEREF99_18_45': 3015,
       'SWEREF99_20_15': 3016,
       'SWEREF99_21_45': 3017,
       'SWEREF99_23_15': 3018,
       'RT90_75_gon_V': 3019,
       'RT90_5_gon_V': 3020,
       'RT90_25_gon_V': 3021,
       'RT90_0_gon': 3022,
       'RT90_25_gon_O': 3023,
       'RT90_5_gon_O': 3024,
       'RT38_75_gon_V': 3025,
       'RT38_5_gon_V': 3026,
       'RT38_25_gon_V': 3027,
       'RT38_0_gon': 3028,
       'RT38_25_gon_O': 3029,
       'RT38_5_gon_O': 3030,
       'WGS_1984_Antarctic_Polar_Stereographic': 3031,
       'WGS_1984_Australian_Antarctic_Polar_Stereographic': 3032,
       'WGS_1984_Australian_Antarctic_Lambert': 3033,
       'ETRS_1989_LCC': 3034,
       'ETRS_1989_LAEA': 3035,
       'Moznet_UTM_Zone_36S': 3036,
       'Moznet_UTM_Zone_37S': 3037,
       'Hjorsey_1955_UTM_Zone_26N': 3054,
       'Hjorsey_1955_UTM_Zone_27N': 3055,
       'Hjorsey_1955_UTM_Zone_28N': 3056,
       'ISN_1993_Lambert_1993': 3057,
       'Helle_1954_Jan_Mayen_Grid': 3058,
       'LKS_1992_Latvia_TM': 3059,
       'IGN72_Grande_Terre_UTM_58S': 3060,
       'Porto_Santo_1995_UTM_Zone_28N': 3061,
       'Azores_Oriental_1995_UTM_Zone_26N': 3062,
       'Azores_Central_1995_UTM_Zone_26N': 3063,
       'IGM_1995_UTM_Zone_32N': 3064,
       'IGM_1995_UTM_Zone_33N': 3065,
       'ED_1950_Jordan_TM': 3066,
       'EUREF_FIN_TM35FIN': 3067,
       'DHDN_Soldner_Berlin': 3068,
       'NAD_1927_Wisconsin_TM': 3069,
       'NAD_1983_Wisconsin_TM': 3070,
       'NAD_1983_HARN_Wisconsin_TM': 3071,
       'NAD_1983_Maine_2000_East_Zone': 3072,
       'NAD_1983_Maine_2000_Central_Zone': 3073,
       'NAD_1983_Maine_2000_West_Zone': 3074,
       'NAD_1983_HARN_Maine_2000_East_Zone': 3075,
       'NAD_1983_HARN_Maine_2000_Central_Zone': 3076,
       'NAD_1983_HARN_Maine_2000_West_Zone': 3077,
       'NAD_1983_Michigan_GeoRef_Meters': 3078,
       'NAD_1983_HARN_Michigan_GeoRef_Meters': 3079,
       'NAD_1927_Texas_Statewide_Mapping_System': 3080,
       'NAD_1983_Texas_Statewide_Mapping_System': 3081,
       'NAD_1983_Texas_Centric_Mapping_System_Lambert': 3082,
       'NAD_1983_Texas_Centric_Mapping_System_Albers': 3083,
       'NAD_1983_HARN_Texas_Centric_Mapping_System_Lambert': 3084,
       'NAD_1983_HARN_Texas_Centric_Mapping_System_Albers': 3085,
       'NAD_1983_Florida_GDL_Albers': 3086,
       'NAD_1983_HARN_Florida_GDL_Albers': 3087,
       'NAD_1983_StatePlane_Kentucky_FIPS_1600': 3088,
       'NAD_1983_StatePlane_Kentucky_FIPS_1600_Feet': 3089,
       'NAD_1983_HARN_StatePlane_Kentucky_FIPS_1600': 3090,
       'NAD_1983_HARN_StatePlane_Kentucky_FIPS_1600_Feet': 3091,
       'Tokyo_UTM_Zone_51N': 3092,
       'Tokyo_UTM_Zone_52N': 3093,
       'Tokyo_UTM_Zone_53N': 3094,
       'Tokyo_UTM_Zone_54N': 3095,
       'Tokyo_UTM_Zone_55N': 3096,
       'JGD_2000_UTM_Zone_51N': 3097,
       'JGD_2000_UTM_Zone_52N': 3098,
       'JGD_2000_UTM_Zone_53N': 3099,
       'JGD_2000_UTM_Zone_54N': 3100,
       'JGD_2000_UTM_Zone_55N': 3101,
       'Samoa_1962_Samoa_Lambert': 3102,
       'Gulshan_303_Bangladesh_TM': 3106,
       'GDA_1994_South_Australia_Lambert': 3107,
       'ETRS_1989_Guernsey_Grid': 3108,
       'ETRS_1989_Jersey_Transverse_Mercator': 3109,
       'AGD_1966_VICGRID': 3110,
       'GDA_1994_VICGRID94': 3111,
       'GDA_1994_Geoscience_Australia_Lambert': 3112,
       'GDA_1994_BCSG02': 3113,
       'MAGNA_Colombia_Oeste_Oeste': 3114,
       'MAGNA_Colombia_Oeste': 3115,
       'MAGNA_Colombia_Bogota': 3116,
       'MAGNA_Colombia_Este': 3117,
       'MAGNA_Colombia_Este_Este': 3118,
       'Douala_1948_AEF_West': 3119,
       'Pulkovo_1942_Adj_1958_Poland_Zone_I': 3120,
       'Philippines_Zone_I': 3121,
       'Philippines_Zone_II': 3122,
       'Philippines_Zone_III': 3123,
       'Philippines_Zone_IV': 3124,
       'Philippines_Zone_V': 3125,
       'ETRS_1989_ETRS-GK19FIN': 3126,
       'ETRS_1989_ETRS-GK20FIN': 3127,
       'ETRS_1989_ETRS-GK21FIN': 3128,
       'ETRS_1989_ETRS-GK22FIN': 3129,
       'ETRS_1989_ETRS-GK23FIN': 3130,
       'ETRS_1989_ETRS-GK24FIN': 3131,
       'ETRS_1989_ETRS-GK25FIN': 3132,
       'ETRS_1989_ETRS-GK26FIN': 3133,
       'ETRS_1989_ETRS-GK27FIN': 3134,
       'ETRS_1989_ETRS-GK28FIN': 3135,
       'ETRS_1989_ETRS-GK29FIN': 3136,
       'ETRS_1989_ETRS-GK30FIN': 3137,
       'ETRS_1989_ETRS-GK31FIN': 3138,
       'Fiji_1956_UTM_Zone_60S': 3141,
       'Fiji_1956_UTM_Zone_1S': 3142,
       'Indian_1960_UTM_Zone_48N': 3148,
       'Indian_1960_UTM_Zone_49N': 3149,
       'NAD_1983_CSRS_BC_Environment_Albers': 3153,
       'NAD_1983_CSRS_UTM_Zone_7N': 3154,
       'NAD_1983_CSRS_UTM_Zone_8N': 3155,
       'NAD_1983_CSRS_UTM_Zone_9N': 3156,
       'NAD_1983_CSRS_UTM_Zone_10N': 3157,
       'NAD_1983_CSRS_UTM_Zone_14N': 3158,
       'NAD_1983_CSRS_UTM_Zone_15N': 3159,
       'NAD_1983_CSRS_UTM_Zone_16N': 3160,
       'NAD_1983_Ontario_MNR_Lambert': 3161,
       'NAD_1983_CSRS_Ontario_MNR_Lambert': 3162,
       'RGNC_1991_93_Lambert_New_Caledonia': 3163,
       'ST87_Ouvea_UTM_58S': 3164,
       'NEA74_Noumea_Lambert': 3165,
       'NEA74_Noumea_Lambert_2': 3166,
       'RGNC_1991-93_UTM_Zone_57S': 3169,
       'RGNC_1991-93_UTM_Zone_58S': 3170,
       'RGNC_1991-93_UTM_Zone_59S': 3171,
       'IGN53_Mare_UTM_Zone_59S': 3172,
       'NAD_1983_Great_Lakes_Basin_Albers': 3174,
       'NAD_1983_Great_Lakes_and_St_Lawrence_Albers': 3175,
       'Indian_1960_TM_106NE': 3176,
       'LGD2006_Libya_TM': 3177,
       'Greenland_1996_UTM_Zone_18N': 3178,
       'Greenland_1996_UTM_Zone_19N': 3179,
       'Greenland_1996_UTM_Zone_20N': 3180,
       'Greenland_1996_UTM_Zone_21N': 3181,
       'Greenland_1996_UTM_Zone_22N': 3182,
       'Greenland_1996_UTM_Zone_23N': 3183,
       'Greenland_1996_UTM_Zone_24N': 3184,
       'Greenland_1996_UTM_Zone_25N': 3185,
       'Greenland_1996_UTM_Zone_26N': 3186,
       'Greenland_1996_UTM_Zone_27N': 3187,
       'Greenland_1996_UTM_Zone_28N': 3188,
       'Greenland_1996_UTM_Zone_29N': 3189,
       'LGD2006_Libya_TM_Zone_5': 3190,
       'LGD2006_Libya_TM_Zone_6': 3191,
       'LGD2006_Libya_TM_Zone_7': 3192,
       'LGD2006_Libya_TM_Zone_8': 3193,
       'LGD2006_Libya_TM_Zone_9': 3194,
       'LGD2006_Libya_TM_Zone_10': 3195,
       'LGD2006_Libya_TM_Zone_11': 3196,
       'LGD2006_Libya_TM_Zone_12': 3197,
       'LGD2006_Libya_TM_Zone_13': 3198,
       'LGD2006_UTM_Zone_32N': 3199,
       'FD_1958_Iraq': 3200,
       'LGD2006_UTM_Zone_33N': 3201,
       'LGD2006_UTM_Zone_34N': 3202,
       'LGD2006_UTM_Zone_35N': 3203,
       'WGS_1984_USGS_Transantarctic_Mountains': 3294,
       'RGPF_UTM_Zone_5S': 3296,
       'RGPF_UTM_Zone_6S': 3297,
       'RGPF_UTM_Zone_7S': 3298,
       'RGPF_UTM_Zone_8S': 3299,
       'Estonian_Coordinate_System_of_1992': 3300,
       'Estonia_1997_Estonia_National_Grid': 3301,
       'IGN63_Hiva_Oa_UTM_Zone_7S': 3302,
       'Fatu_Iva_1972_UTM_Zone_7S': 3303,
       'Tahiti_1979_UTM_Zone_6S': 3304,
       'Moorea_1987_UTM_Zone_6S': 3305,
       'Maupiti_1983_UTM_Zone_5S': 3306,
       'Nakhl-e_Ghanem_UTM_Zone_39N': 3307,
       'GDA_1994_NSW_lambert': 3308,
       'NAD_1927_California_Teale_Albers': 3309,
       'NAD_1983_California_Teale_Albers': 3310,
       'NAD_1983_HARN_California_Teale_Albers': 3311,
       'CSG_1967_UTM_Zone_21N': 3312,
       'RGFG_1995_UTM_Zone_21N': 3313,
       'Katanga_1955_Katanga_Lambert': 3314,
       'Katanga_1955_Katanga_TM': 3315,
       'Kasai_1953_Congo_TM_Zone_22': 3316,
       'Kasai_1953_Congo_TM_Zone_24': 3317,
       'IGC_1962_Congo_TM_Zone_12': 3318,
       'IGC_1962_Congo_TM_Zone_14': 3319,
       'IGC_1962_Congo_TM_Zone_16': 3320,
       'IGC_1962_Congo_TM_Zone_18': 3321,
       'IGC_1962_Congo_TM_Zone_20': 3322,
       'IGC_1962_Congo_TM_Zone_22': 3323,
       'IGC_1962_Congo_TM_Zone_24': 3324,
       'IGC_1962_Congo_TM_Zone_26': 3325,
       'IGC_1962_Congo_TM_Zone_28': 3326,
       'IGC_1962_Congo_TM_Zone_30': 3327,
       'Pulkovo_1942_Adj_1958_GUGiK-80': 3328,
       'Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_5': 3329,
       'Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_6': 3330,
       'Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_7': 3331,
       'Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_8': 3332,
       'Pulkovo_1942_Adj_1958_GK_Zone_3': 3333,
       'Pulkovo_1942_Adj_1958_GK_Zone_4': 3334,
       'Pulkovo_1942_Adj_1958_GK_Zone_5': 3335,
       'Kerguelen_Island_1949_UTM_42S': 3336,
       'Le_Pouce_1934_Mauritius_Grid': 3337,
       'NAD_1983_Alaska_Albers': 3338,
       'IGCB_1955_Congo_TM_Zone_12': 3339,
       'IGCB_1955_Congo_TM_Zone_14': 3340,
       'IGCB_1955_Congo_TM_Zone_16': 3341,
       'IGCB_1955_UTM_Zone_33S': 3342,
       'Mauritania_1999_UTM_Zone_28N': 3343,
       'Mauritania_1999_UTM_Zone_29N': 3344,
       'Mauritania_1999_UTM_Zone_30N': 3345,
       'LKS_1994_Lithuania_TM': 3346,
       'NAD_1983_Statistics_Canada_Lambert': 3347,
       'NAD_1983_CSRS_Statistics_Canada_Lambert': 3348,
       'WGS_1984_PDC_Mercator': 3349,
       'Pulkovo_1942_CS63_Zone_K0': 3350,
       'Pulkovo_1942_CS63_Zone_K1': 3351,
       'Pulkovo_1942_CS63_Zone_K2': 3352,
       'Mhast_Onshore_UTM_Zone_32S': 3353,
       'Mhast_Offshore_UTM_Zone_32S': 3354,
       'Egypt_Gulf_of_Suez_S-650_TL_Red_Belt': 3355,
       'Grand_Cayman_1959_UTM_Zone_17N': 3356,
       'Little_Cayman_1961_UTM_Zone_17N': 3357,
       'NAD_1983_HARN_StatePlane_North_Carolina_FIPS_3200': 3358,
       'NAD_1983_HARN_StatePlane_North_Carolina_FIPS_3200_Feet': 3359,
       'NAD_1983_HARN_StatePlane_South_Carolina_FIPS_3900': 3360,
       'NAD_1983_HARN_StatePlane_South_Carolina_FIPS_3900_Feet_Intl': 3361,
       'NAD_1983_HARN_StatePlane_Pennsylvania_North_FIPS_3701': 3362,
       'NAD_1983_HARN_StatePlane_Pennsylvania_North_FIPS_3701_Feet': 3363,
       'NAD_1983_HARN_StatePlane_Pennsylvania_South_FIPS_3702': 3364,
       'NAD_1983_HARN_StatePlane_Pennsylvania_South_FIPS_3702_Feet': 3365,
       'Hong_Kong_1963_Grid_System': 3366,
       'IGN_Astro_1960_UTM_Zone_28N': 3367,
       'IGN_Astro_1960_UTM_Zone_29N': 3368,
       'IGN_Astro_1960_UTM_Zone_30N': 3369,
       'NAD_1927_UTM_Zone_59N': 3370,
       'NAD_1927_UTM_Zone_60N': 3371,
       'NAD_1983_UTM_Zone_59N': 3372,
       'NAD_1983_UTM_Zone_60N': 3373,
       'FD_1954_UTM_Zone_29N': 3374,
       'GDM_2000_MRSO_Peninsular_Malaysia': 3375,
       'GDM_2000_BRSO_East_Malaysia': 3376,
       'GDM_2000_State_Cassini_Johor': 3377,
       'GDM_2000_State_Cassini_Negeri_Sembilan_&_Melaka': 3378,
       'GDM_2000_State_Cassini_Pahang': 3379,
       'GDM_2000_State_Cassini_Selangor': 3380,
       'GDM_2000_State_Cassini_Terengganu': 3381,
       'GDM_2000_State_Cassini_Pulau_Pinang_&_Seberang_Perai': 3382,
       'GDM_2000_State_Cassini_Perlis': 3383,
       'GDM_2000_State_Cassini_Perak': 3384,
       'GDM_2000_State_Cassini_Kelantan': 3385,
       'KKJ_Finland_Zone_0': 3386,
       'KKJ_Finland_Zone_5': 3387,
       'Pulkovo_1942_Caspian_Sea_Mercator': 3388,
       'Karbala_1979_Polservice_UTM_Zone_37N': 3391,
       'Karbala_1979_Polservice_UTM_Zone_38N': 3392,
       'Karbala_1979_Polservice_UTM_Zone_39N': 3393,
       'Nahrwan_1934_Iraq_Zone': 3394,
       'WGS_1984_World_Mercator': 3395,
       'PD/83_GK_Zone_3': 3396,
       'PD/83_GK_Zone_4': 3397,
       'RD/83_GK_Zone_4': 3398,
       'RD/83_GK_Zone_5': 3399,
       'NAD_1983_10TM_AEP_Forest': 3400,
       'NAD_1983_10TM_AEP_Resource': 3401,
       'NAD_1983_CSRS_10TM_AEP_Forest': 3402,
       'NAD_1983_CSRS_10TM_AEP_Resource': 3403,
       'NAD_1983_HARN_StatePlane_North_Carolina_FIPS_3200_Feet': 3404,
       'VN_2000_UTM_Zone_48N': 3405,
       'VN_2000_UTM_Zone_49N': 3406,
       'Hong_Kong_1963_Grid_System': 3407,
       'NSIDC_EASE_Grid_North': 3408,
       'NSIDC_EASE_Grid_South': 3409,
       'NSIDC_EASE_Grid_Global': 3410,
       'NSIDC_Sea_Ice_Polar_Stereographic_North': 3411,
       'NSIDC_Sea_Ice_Polar_Stereographic_South': 3412,
       'WGS_1984_NSIDC_Sea_Ice_Polar_Stereographic_North': 3413,
       'SVY21_Singapore_TM': 3414,
       'WGS_1972_BE_South_China_Sea_Lambert': 3415,
       'ETRS_1989_Austria_Lambert': 3416,
       'NAD_1983_StatePlane_Iowa_North_FIPS_1401_Feet': 3417,
       'NAD_1983_StatePlane_Iowa_South_FIPS_1402_Feet': 3418,
       'NAD_1983_StatePlane_Kansas_North_FIPS_1501_Feet': 3419,
       'NAD_1983_StatePlane_Kansas_South_FIPS_1502_Feet': 3420,
       'NAD_1983_StatePlane_Nevada_East_FIPS_2701_Feet': 3421,
       'NAD_1983_StatePlane_Nevada_Central_FIPS_2702_Feet': 3422,
       'NAD_1983_StatePlane_Nevada_West_FIPS_2703_Feet': 3423,
       'NAD_1983_StatePlane_New_Jersey_FIPS_2900_Feet': 3424,
       'NAD_1983_HARN_StatePlane_Iowa_North_FIPS_1401_Feet': 3425,
       'NAD_1983_HARN_StatePlane_Iowa_South_FIPS_1402_Feet': 3426,
       'NAD_1983_HARN_StatePlane_Kansas_North_FIPS_1501_Feet': 3427,
       'NAD_1983_HARN_StatePlane_Kansas_South_FIPS_1502_Feet': 3428,
       'NAD_1983_HARN_StatePlane_Nevada_East_FIPS_2701_Feet': 3429,
       'NAD_1983_HARN_StatePlane_Nevada_Central_FIPS_2702_Feet': 3430,
       'NAD_1983_HARN_StatePlane_Nevada_West_FIPS_2703_Feet': 3431,
       'NAD_1983_HARN_StatePlane_New_Jersey_FIPS_2900_Feet': 3432,
       'NAD_1983_StatePlane_Arkansas_North_FIPS_0301_Feet': 3433,
       'NAD_1983_StatePlane_Arkansas_South_FIPS_0302_Feet': 3434,
       'NAD_1983_StatePlane_Illinois_East_FIPS_1201_Feet': 3435,
       'NAD_1983_StatePlane_Illinois_West_FIPS_1202_Feet': 3436,
       'NAD_1983_StatePlane_New_Hampshire_FIPS_2800_Feet': 3437,
       'NAD_1983_StatePlane_Rhode_Island_FIPS_3800_Feet': 3438,
       'PDO_1993_UTM_Zone_39N': 3439,
       'PDO_1993_UTM_Zone_40N': 3440,
       'NAD_1983_HARN_StatePlane_Arkansas_North_FIPS_0301_Feet': 3441,
       'NAD_1983_HARN_StatePlane_Arkansas_South_FIPS_0302_Feet': 3442,
       'NAD_1983_HARN_StatePlane_Illinois_East_FIPS_1201_Feet': 3443,
       'NAD_1983_HARN_StatePlane_Illinois_West_FIPS_1202_Feet': 3444,
       'NAD_1983_HARN_StatePlane_New_Hampshire_FIPS_2800_Feet': 3445,
       'NAD_1983_HARN_StatePlane_Rhode_Island_FIPS_3800_Feet': 3446,
       'Belge_Lambert_2005': 3447,
       'JAD_2001_Jamaica_Grid': 3448,
       'JAD_2001_UTM_Zone_17N': 3449,
       'JAD_2001_UTM_Zone_18N': 3450,
       'NAD_1983_StatePlane_Louisiana_Offshore_FIPS_1703_Feet': 3453,
       'NAD_1983_HARN_StatePlane_Louisiana_North_FIPS_1701_Feet': 3456,
       'NAD_1983_HARN_StatePlane_Louisiana_South_FIPS_1702_Feet': 3457,
       'NAD_1983_HARN_StatePlane_South_Dakota_North_FIPS_4001_Feet': 3458,
       'NAD_1983_HARN_StatePlane_South_Dakota_South_FIPS_4002_Feet': 3459,
       'Fiji_1986_Fiji_Map_Grid': 3460,
       'Dabola_1981_UTM_Zone_28N': 3461,
       'Dabola_1981_UTM_Zone_29N': 3462,
       'NAD_1983_Maine_2000_Central_Zone': 3463,
       'NAD_1983_HARN_Maine_2000_Central_Zone': 3464,
       'NAD_1983_StatePlane_Utah_North_FIPS_4301_Feet': 3560,
       'Old_Hawaiian_StatePlane_Hawaii_1_FIPS_5101': 3561,
       'Old_Hawaiian_StatePlane_Hawaii_2_FIPS_5102': 3562,
       'Old_Hawaiian_StatePlane_Hawaii_3_FIPS_5103': 3563,
       'Old_Hawaiian_StatePlane_Hawaii_4_FIPS_5104': 3564,
       'Old_Hawaiian_StatePlane_Hawaii_5_FIPS_5105': 3565,
       'NAD_1983_StatePlane_Utah_Central_FIPS_4302_Feet': 3566,
       'NAD_1983_StatePlane_Utah_South_FIPS_4303_Feet': 3567,
       'NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301_Feet': 3568,
       'NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302_Feet': 3569,
       'NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303_Feet': 3570,
       'WGS_1984_North_Pole_LAEA_Bering_Sea': 3571,
       'WGS_1984_North_Pole_LAEA_Alaska': 3572,
       'WGS_1984_North_Pole_LAEA_Canada': 3573,
       'WGS_1984_North_Pole_LAEA_Atlantic': 3574,
       'WGS_1984_North_Pole_LAEA_Europe': 3575,
       'WGS_1984_North_Pole_LAEA_Russia': 3576,
       'GDA_1994_Australia_Albers': 3577,
       'NAD_1983_Yukon_Albers': 3578,
       'NAD_1983_CSRS_Yukon_Albers': 3579,
       'NAD_1983_Northwest_Territories_Lambert': 3580,
       'NAD_1983_CSRS_Northwest_Territories_Lambert': 3581,
       'Reunion_1947_TM_Reunion': 3727,
       'NAD_1983_StatePlane_Ohio_North_FIPS_3401_Feet': 3734,
       'NAD_1983_StatePlane_Ohio_South_FIPS_3402_Feet': 3735,
       'NAD_1983_StatePlane_Wyoming_East_FIPS_4901_Feet': 3736,
       'NAD_1983_StatePlane_Wyoming_East_Central_FIPS_4902_Feet': 3737,
       'NAD_1983_StatePlane_Wyoming_West_Central_FIPS_4903_Feet': 3738,
       'NAD_1983_StatePlane_Wyoming_West_FIPS_4904_Feet': 3739,
       'NAD_1983_HARN_StatePlane_Ohio_North_FIPS_3401_Feet': 3753,
       'NAD_1983_HARN_StatePlane_Ohio_South_FIPS_3402_Feet': 3754,
       'NAD_1983_HARN_StatePlane_Wyoming_East_FIPS_4901_Feet': 3755,
       'NAD_1983_HARN_StatePlane_Wyoming_East_Central_FIPS_4902_Feet': 3756,
       'NAD_1983_HARN_StatePlane_Wyoming_West_Central_FIPS_4903_Feet': 3757,
       'NAD_1983_HARN_StatePlane_Wyoming_West_FIPS_4904_Feet': 3758,
       'NAD_1983_StatePlane_Hawaii_3_FIPS_5103_Feet': 3759,
       'NAD_1983_HARN_StatePlane_Hawaii_3_FIPS_5103_Feet': 3760,
       'NAD_1983_CSRS_UTM_Zone_22N': 3761,
       'WGS_1984_South_Georgia_Lambert': 3762,
       'ETRS_1989_Portugal_TM06': 3763,
       'Puerto_Rico_UTM_Zone_20N': 3920,
       'Puerto_Rico_StatePlane_Puerto_Rico_FIPS_5201': 3991,
       'Puerto_Rico_StatePlane_Virgin_Islands_St_Croix_FIPS_5202': 3992,
       'Pulkovo_1995_GK_Zone_2': 20002,
       'Pulkovo_1995_GK_Zone_3': 20003,
       'Pulkovo_1995_GK_Zone_4': 20004,
       'Pulkovo_1995_GK_Zone_5': 20005,
       'Pulkovo_1995_GK_Zone_6': 20006,
       'Pulkovo_1995_GK_Zone_7': 20007,
       'Pulkovo_1995_GK_Zone_8': 20008,
       'Pulkovo_1995_GK_Zone_9': 20009,
       'Pulkovo_1995_GK_Zone_10': 20010,
       'Pulkovo_1995_GK_Zone_11': 20011,
       'Pulkovo_1995_GK_Zone_12': 20012,
       'Pulkovo_1995_GK_Zone_13': 20013,
       'Pulkovo_1995_GK_Zone_14': 20014,
       'Pulkovo_1995_GK_Zone_15': 20015,
       'Pulkovo_1995_GK_Zone_16': 20016,
       'Pulkovo_1995_GK_Zone_17': 20017,
       'Pulkovo_1995_GK_Zone_18': 20018,
       'Pulkovo_1995_GK_Zone_19': 20019,
       'Pulkovo_1995_GK_Zone_20': 20020,
       'Pulkovo_1995_GK_Zone_21': 20021,
       'Pulkovo_1995_GK_Zone_22': 20022,
       'Pulkovo_1995_GK_Zone_23': 20023,
       'Pulkovo_1995_GK_Zone_24': 20024,
       'Pulkovo_1995_GK_Zone_25': 20025,
       'Pulkovo_1995_GK_Zone_26': 20026,
       'Pulkovo_1995_GK_Zone_27': 20027,
       'Pulkovo_1995_GK_Zone_28': 20028,
       'Pulkovo_1995_GK_Zone_29': 20029,
       'Pulkovo_1995_GK_Zone_30': 20030,
       'Pulkovo_1995_GK_Zone_31': 20031,
       'Pulkovo_1995_GK_Zone_32': 20032,
       'Pulkovo_1995_GK_Zone_2N': 20062,
       'Pulkovo_1995_GK_Zone_3N': 20063,
       'Pulkovo_1995_GK_Zone_4N': 20064,
       'Pulkovo_1995_GK_Zone_5N': 20065,
       'Pulkovo_1995_GK_Zone_6N': 20066,
       'Pulkovo_1995_GK_Zone_7N': 20067,
       'Pulkovo_1995_GK_Zone_8N': 20068,
       'Pulkovo_1995_GK_Zone_9N': 20069,
       'Pulkovo_1995_GK_Zone_10N': 20070,
       'Pulkovo_1995_GK_Zone_11N': 20071,
       'Pulkovo_1995_GK_Zone_12N': 20072,
       'Pulkovo_1995_GK_Zone_13N': 20073,
       'Pulkovo_1995_GK_Zone_14N': 20074,
       'Pulkovo_1995_GK_Zone_15N': 20075,
       'Pulkovo_1995_GK_Zone_16N': 20076,
       'Pulkovo_1995_GK_Zone_17N': 20077,
       'Pulkovo_1995_GK_Zone_18N': 20078,
       'Pulkovo_1995_GK_Zone_19N': 20079,
       'Pulkovo_1995_GK_Zone_20N': 20080,
       'Pulkovo_1995_GK_Zone_21N': 20081,
       'Pulkovo_1995_GK_Zone_22N': 20082,
       'Pulkovo_1995_GK_Zone_23N': 20083,
       'Pulkovo_1995_GK_Zone_24N': 20084,
       'Pulkovo_1995_GK_Zone_25N': 20085,
       'Pulkovo_1995_GK_Zone_26N': 20086,
       'Pulkovo_1995_GK_Zone_27N': 20087,
       'Pulkovo_1995_GK_Zone_28N': 20088,
       'Pulkovo_1995_GK_Zone_29N': 20089,
       'Pulkovo_1995_GK_Zone_30N': 20090,
       'Pulkovo_1995_GK_Zone_31N': 20091,
       'Pulkovo_1995_GK_Zone_32N': 20092,
       'Adindan_UTM_Zone_35N': 20135,
       'Adindan_UTM_Zone_36N': 20136,
       'Adindan_UTM_Zone_37N': 20137,
       'Adindan_UTM_Zone_38N': 20138,
       'AGD_1966_AMG_Zone_48': 20248,
       'AGD_1966_AMG_Zone_49': 20249,
       'AGD_1966_AMG_Zone_50': 20250,
       'AGD_1966_AMG_Zone_51': 20251,
       'AGD_1966_AMG_Zone_52': 20252,
       'AGD_1966_AMG_Zone_53': 20253,
       'AGD_1966_AMG_Zone_54': 20254,
       'AGD_1966_AMG_Zone_55': 20255,
       'AGD_1966_AMG_Zone_56': 20256,
       'AGD_1966_AMG_Zone_57': 20257,
       'AGD_1966_AMG_Zone_58': 20258,
       'AGD_1984_AMG_Zone_48': 20348,
       'AGD_1984_AMG_Zone_49': 20349,
       'AGD_1984_AMG_Zone_50': 20350,
       'AGD_1984_AMG_Zone_51': 20351,
       'AGD_1984_AMG_Zone_52': 20352,
       'AGD_1984_AMG_Zone_53': 20353,
       'AGD_1984_AMG_Zone_54': 20354,
       'AGD_1984_AMG_Zone_55': 20355,
       'AGD_1984_AMG_Zone_56': 20356,
       'AGD_1984_AMG_Zone_57': 20357,
       'AGD_1984_AMG_Zone_58': 20358,
       'Ain_el_Abd_UTM_Zone_36N': 20436,
       'Ain_el_Abd_UTM_Zone_37N': 20437,
       'Ain_el_Abd_UTM_Zone_38N': 20438,
       'Ain_el_Abd_UTM_Zone_39N': 20439,
       'Ain_el_Abd_UTM_Zone_40N': 20440,
       'Bahrain_State_Grid': 20499,
       'Afgooye_UTM_Zone_38N': 20538,
       'Afgooye_UTM_Zone_39N': 20539,
       'Portuguese_National_Grid': 20790,
       'Aratu_UTM_Zone_22S': 20822,
       'Aratu_UTM_Zone_23S': 20823,
       'Aratu_UTM_Zone_24S': 20824,
       'Arc_1950_UTM_Zone_34S': 20934,
       'Arc_1950_UTM_Zone_35S': 20935,
       'Arc_1950_UTM_Zone_36S': 20936,
       'Arc_1960_UTM_Zone_35S': 21035,
       'Arc_1960_UTM_Zone_36S': 21036,
       'Arc_1960_UTM_Zone_37S': 21037,
       'Arc_1960_UTM_Zone_35N': 21095,
       'Arc_1960_UTM_Zone_36N': 21096,
       'Arc_1960_UTM_Zone_37N': 21097,
       'Batavia_UTM_Zone_48S': 21148,
       'Batavia_UTM_Zone_49S': 21149,
       'Batavia_UTM_Zone_50S': 21150,
       'Barbados_1938_British_West_Indies_Grid': 21291,
       'Barbados_1938_Barbados_Grid': 21292,
       'Beijing_1954_GK_Zone_13': 21413,
       'Beijing_1954_GK_Zone_14': 21414,
       'Beijing_1954_GK_Zone_15': 21415,
       'Beijing_1954_GK_Zone_16': 21416,
       'Beijing_1954_GK_Zone_17': 21417,
       'Beijing_1954_GK_Zone_18': 21418,
       'Beijing_1954_GK_Zone_19': 21419,
       'Beijing_1954_GK_Zone_20': 21420,
       'Beijing_1954_GK_Zone_21': 21421,
       'Beijing_1954_GK_Zone_22': 21422,
       'Beijing_1954_GK_Zone_23': 21423,
       'Beijing_1954_GK_Zone_13N': 21473,
       'Beijing_1954_GK_Zone_14N': 21474,
       'Beijing_1954_GK_Zone_15N': 21475,
       'Beijing_1954_GK_Zone_16N': 21476,
       'Beijing_1954_GK_Zone_17N': 21477,
       'Beijing_1954_GK_Zone_18N': 21478,
       'Beijing_1954_GK_Zone_19N': 21479,
       'Beijing_1954_GK_Zone_20N': 21480,
       'Beijing_1954_GK_Zone_21N': 21481,
       'Beijing_1954_GK_Zone_22N': 21482,
       'Beijing_1954_GK_Zone_23N': 21483,
       'Belge_Lambert_1950': 21500,
       'Bern_1898_Bern_LV03C': 21780,
       'CH1903_LV03': 21781,
       'Bogota_UTM_Zone_17N': 21817,
       'Bogota_UTM_Zone_18N': 21818,
       'Colombia_West_Zone': 21891,
       'Colombia_Bogota_Zone': 21892,
       'Colombia_East_Central_Zone': 21893,
       'Colombia_East_Zone': 21894,
       'Colombia_West_Zone': 21896,
       'Colombia_Bogota_Zone': 21897,
       'Colombia_East_Central_Zone': 21898,
       'Colombia_East_Zone': 21899,
       'Camacupa_UTM_Zone_32S': 22032,
       'Camacupa_UTM_Zone_33S': 22033,
       'Camacupa_TM_11_30_SE': 22091,
       'Camacupa_TM_12_SE': 22092,
       'POSGAR_1998_Argentina_Zone_1': 22171,
       'POSGAR_1998_Argentina_Zone_2': 22172,
       'POSGAR_1998_Argentina_Zone_3': 22173,
       'POSGAR_1998_Argentina_Zone_4': 22174,
       'POSGAR_1998_Argentina_Zone_5': 22175,
       'POSGAR_1998_Argentina_Zone_6': 22176,
       'POSGAR_1998_Argentina_Zone_7': 22177,
       'POSGAR_1994_Argentina_Zone_1': 22181,
       'POSGAR_1994_Argentina_Zone_2': 22182,
       'POSGAR_1994_Argentina_Zone_3': 22183,
       'POSGAR_1994_Argentina_Zone_4': 22184,
       'POSGAR_1994_Argentina_Zone_5': 22185,
       'POSGAR_1994_Argentina_Zone_6': 22186,
       'POSGAR_1994_Argentina_Zone_7': 22187,
       'Argentina_Zone_1': 22191,
       'Argentina_Zone_2': 22192,
       'Argentina_Zone_3': 22193,
       'Argentina_Zone_4': 22194,
       'Argentina_Zone_5': 22195,
       'Argentina_Zone_6': 22196,
       'Argentina_Zone_7': 22197,
       'Cape_UTM_Zone_34S': 22234,
       'Cape_UTM_Zone_35S': 22235,
       'Cape_UTM_Zone_36S': 22236,
       'Carthage_UTM_Zone_32N': 22332,
       'Nord_Tunisie': 22391,
       'Sud_Tunisie': 22392,
       'Corrego_Alegre_UTM_Zone_21S': 22521,
       'Corrego_Alegre_UTM_Zone_22S': 22522,
       'Corrego_Alegre_UTM_Zone_23S': 22523,
       'Corrego_Alegre_UTM_Zone_24S': 22524,
       'Corrego_Alegre_UTM_Zone_25S': 22525,
       'Deir_ez_Zor_Levant_Zone': 22700,
       'Deir_ez_Zor_Syria_Lambert': 22770,
       'Deir_ez_Zor_Levant_Stereographic': 22780,
       'Douala_UTM_Zone_32N': 22832,
       'Egypt_Blue_Belt': 22991,
       'Egypt_Red_Belt': 22992,
       'Egypt_Purple_Belt': 22993,
       'Egypt_Extended_Purple_Belt': 22994,
       'ED_1950_UTM_Zone_28N': 23028,
       'ED_1950_UTM_Zone_29N': 23029,
       'ED_1950_UTM_Zone_30N': 23030,
       'ED_1950_UTM_Zone_31N': 23031,
       'ED_1950_UTM_Zone_32N': 23032,
       'ED_1950_UTM_Zone_33N': 23033,
       'ED_1950_UTM_Zone_34N': 23034,
       'ED_1950_UTM_Zone_35N': 23035,
       'ED_1950_UTM_Zone_36N': 23036,
       'ED_1950_UTM_Zone_37N': 23037,
       'ED_1950_UTM_Zone_38N': 23038,
       'ED_1950_TM_0_N': 23090,
       'ED_1950_TM_5_NE': 23095,
       'Fahud_UTM_Zone_39N': 23239,
       'Fahud_UTM_Zone_40N': 23240,
       'Garoua_UTM_Zone_33N': 23433,
       'Hungarian_1972_Egyseges_Orszagos_Vetuleti': 23700,
       'DGN_1995_Indonesia_TM-3_Zone_46.2': 23830,
       'DGN_1995_Indonesia_TM-3_Zone_47.1': 23831,
       'DGN_1995_Indonesia_TM-3_Zone_47.2': 23832,
       'DGN_1995_Indonesia_TM-3_Zone_48.1': 23833,
       'DGN_1995_Indonesia_TM-3_Zone_48.2': 23834,
       'DGN_1995_Indonesia_TM-3_Zone_49.1': 23835,
       'DGN_1995_Indonesia_TM-3_Zone_49.2': 23836,
       'DGN_1995_Indonesia_TM-3_Zone_50.1': 23837,
       'DGN_1995_Indonesia_TM-3_Zone_50.2': 23838,
       'DGN_1995_Indonesia_TM-3_Zone_51.1': 23839,
       'DGN_1995_Indonesia_TM-3_Zone_51.2': 23840,
       'DGN_1995_Indonesia_TM-3_Zone_52.1': 23841,
       'DGN_1995_Indonesia_TM-3_Zone_52.2': 23842,
       'DGN_1995_Indonesia_TM-3_Zone_53.1': 23843,
       'DGN_1995_Indonesia_TM-3_Zone_53.2': 23844,
       'DGN_1995_Indonesia_TM-3_Zone_54.1': 23845,
       'Indonesian_1974_UTM_Zone_46N': 23846,
       'Indonesian_1974_UTM_Zone_47N': 23847,
       'Indonesian_1974_UTM_Zone_48N': 23848,
       'Indonesian_1974_UTM_Zone_49N': 23849,
       'Indonesian_1974_UTM_Zone_50N': 23850,
       'Indonesian_1974_UTM_Zone_51N': 23851,
       'Indonesian_1974_UTM_Zone_52N': 23852,
       'Indonesian_1974_UTM_Zone_53N': 23853,
       'DGN_1995_UTM_Zone_46N': 23866,
       'DGN_1995_UTM_Zone_47N': 23867,
       'DGN_1995_UTM_Zone_48N': 23868,
       'DGN_1995_UTM_Zone_49N': 23869,
       'DGN_1995_UTM_Zone_50N': 23870,
       'DGN_1995_UTM_Zone_51N': 23871,
       'DGN_1995_UTM_Zone_52N': 23872,
       'DGN_1995_UTM_Zone_47S': 23877,
       'DGN_1995_UTM_Zone_48S': 23878,
       'DGN_1995_UTM_Zone_49S': 23879,
       'DGN_1995_UTM_Zone_50S': 23880,
       'DGN_1995_UTM_Zone_51S': 23881,
       'DGN_1995_UTM_Zone_52S': 23882,
       'DGN_1995_UTM_Zone_53S': 23883,
       'DGN_1995_UTM_Zone_54S': 23884,
       'Indonesian_1974_UTM_Zone_46S': 23886,
       'Indonesian_1974_UTM_Zone_47S': 23887,
       'Indonesian_1974_UTM_Zone_48S': 23888,
       'Indonesian_1974_UTM_Zone_49S': 23889,
       'Indonesian_1974_UTM_Zone_50S': 23890,
       'Indonesian_1974_UTM_Zone_51S': 23891,
       'Indonesian_1974_UTM_Zone_52S': 23892,
       'Indonesian_1974_UTM_Zone_53S': 23893,
       'Indonesian_1974_UTM_Zone_54S': 23894,
       'Indian_1954_UTM_Zone_46N': 23946,
       'Indian_1954_UTM_Zone_47N': 23947,
       'Indian_1954_UTM_Zone_48N': 23948,
       'Indian_1975_UTM_Zone_47N': 24047,
       'Indian_1975_UTM_Zone_48N': 24048,
       'Jamaica_1875_Old_Grid': 24100,
       'Jamaica_Grid': 24200,
       'Kalianpur_1937_UTM_Zone_45N': 24305,
       'Kalianpur_1937_UTM_Zone_46N': 24306,
       'Kalianpur_1962_UTM_Zone_41N': 24311,
       'Kalianpur_1962_UTM_Zone_42N': 24312,
       'Kalianpur_1962_UTM_Zone_43N': 24313,
       'Kalianpur_1975_UTM_Zone_42N': 24342,
       'Kalianpur_1975_UTM_Zone_43N': 24343,
       'Kalianpur_1975_UTM_Zone_44N': 24344,
       'Kalianpur_1975_UTM_Zone_45N': 24345,
       'Kalianpur_1975_UTM_Zone_46N': 24346,
       'Kalianpur_1975_UTM_Zone_47N': 24347,
       'Kalianpur_1880_India_Zone_0': 24370,
       'Kalianpur_1880_India_Zone_I': 24371,
       'Kalianpur_1880_India_Zone_IIa': 24372,
       'Kalianpur_1880_India_Zone_III': 24373,
       'Kalianpur_1880_India_Zone_IV': 24374,
       'Kalianpur_1937_India_Zone_IIb': 24375,
       'Kalianpur_1962_India_Zone_I': 24376,
       'Kalianpur_1962_India_Zone_IIa': 24377,
       'Kalianpur_1975_India_Zone_I': 24378,
       'Kalianpur_1975_India_Zone_IIa': 24379,
       'Kalianpur_1975_India_Zone_IIb': 24380,
       'Kalianpur_1975_India_Zone_III': 24381,
       'Kalianpur_1880_India_Zone_IIb': 24382,
       'Kalianpur_1975_India_Zone_IV': 24383,
       'Kertau_Singapore_Grid': 24500,
       'Kertau_UTM_Zone_47N': 24547,
       'Kertau_UTM_Zone_48N': 24548,
       'Kertau_RSO_Malaya_Chains': 24571,
       'KOC_Lambert': 24600,
       'La_Canoa_UTM_Zone_18N': 24718,
       'La_Canoa_UTM_Zone_19N': 24719,
       'La_Canoa_UTM_Zone_20N': 24720,
       'La_Canoa_UTM_Zone_21N': 24721,
       'PSAD_1956_UTM_Zone_17N': 24817,
       'PSAD_1956_UTM_Zone_18N': 24818,
       'PSAD_1956_UTM_Zone_19N': 24819,
       'PSAD_1956_UTM_Zone_20N': 24820,
       'PSAD_1956_UTM_Zone_21N': 24821,
       'PSAD_1956_UTM_Zone_17S': 24877,
       'PSAD_1956_UTM_Zone_18S': 24878,
       'PSAD_1956_UTM_Zone_19S': 24879,
       'PSAD_1956_UTM_Zone_20S': 24880,
       'PSAD_1956_UTM_Zone_21S': 24881,
       'PSAD_1956_UTM_Zone_22S': 24882,
       'Peru_West_Zone': 24891,
       'Peru_Central_Zone': 24892,
       'Peru_East_Zone': 24893,
       'Ghana_Metre_Grid': 25000,
       'Lome_UTM_Zone_31N': 25231,
       'Philippines_Zone_I': 25391,
       'Philippines_Zone_II': 25392,
       'Philippines_Zone_III': 25393,
       'Philippines_Zone_IV': 25394,
       'Philippines_Zone_V': 25395,
       'ETRS_1989_UTM_Zone_28N': 25828,
       'ETRS_1989_UTM_Zone_29N': 25829,
       'ETRS_1989_UTM_Zone_30N': 25830,
       'ETRS_1989_UTM_Zone_31N': 25831,
       'ETRS_1989_UTM_Zone_32N': 25832,
       'ETRS_1989_UTM_Zone_33N': 25833,
       'ETRS_1989_UTM_Zone_34N': 25834,
       'ETRS_1989_UTM_Zone_35N': 25835,
       'ETRS_1989_UTM_Zone_36N': 25836,
       'ETRS_1989_UTM_Zone_37N': 25837,
       'ETRS_1989_UTM_Zone_38N': 25838,
       'ETRS_1989_TM_Baltic_1993': 25884,
       'Malongo_1987_UTM_Zone_32S': 25932,
       'Nord_Maroc': 26191,
       'Sud_Maroc': 26192,
       'Sahara': 26193,
       'Merchich_Sahara_Nord': 26194,
       'Merchich_Sahara_Sud': 26195,
       'Massawa_UTM_Zone_37N': 26237,
       'Minna_UTM_Zone_31N': 26331,
       'Minna_UTM_Zone_32N': 26332,
       'Nigeria_West_Belt': 26391,
       'Nigeria_Mid_Belt': 26392,
       'Nigeria_East_Belt': 26393,
       'Mhast_UTM_Zone_32S': 26432,
       'Monte_Mario_Rome_Italy_1': 26591,
       'Monte_Mario_Rome_Italy_2': 26592,
       'Mporaloko_UTM_Zone_32N': 26632,
       'Mporaloko_UTM_Zone_32S': 26692,
       'NAD_1927_UTM_Zone_1N': 26701,
       'NAD_1927_UTM_Zone_2N': 26702,
       'NAD_1927_UTM_Zone_3N': 26703,
       'NAD_1927_UTM_Zone_4N': 26704,
       'NAD_1927_UTM_Zone_5N': 26705,
       'NAD_1927_UTM_Zone_6N': 26706,
       'NAD_1927_UTM_Zone_7N': 26707,
       'NAD_1927_UTM_Zone_8N': 26708,
       'NAD_1927_UTM_Zone_9N': 26709,
       'NAD_1927_UTM_Zone_10N': 26710,
       'NAD_1927_UTM_Zone_11N': 26711,
       'NAD_1927_UTM_Zone_12N': 26712,
       'NAD_1927_UTM_Zone_13N': 26713,
       'NAD_1927_UTM_Zone_14N': 26714,
       'NAD_1927_UTM_Zone_15N': 26715,
       'NAD_1927_UTM_Zone_16N': 26716,
       'NAD_1927_UTM_Zone_17N': 26717,
       'NAD_1927_UTM_Zone_18N': 26718,
       'NAD_1927_UTM_Zone_19N': 26719,
       'NAD_1927_UTM_Zone_20N': 26720,
       'NAD_1927_UTM_Zone_21N': 26721,
       'NAD_1927_UTM_Zone_22N': 26722,
       'NAD_1927_StatePlane_Alabama_East_FIPS_0101': 26729,
       'NAD_1927_StatePlane_Alabama_West_FIPS_0102': 26730,
       'NAD_1927_StatePlane_Alaska_1_FIPS_5001': 26731,
       'NAD_1927_StatePlane_Alaska_2_FIPS_5002': 26732,
       'NAD_1927_StatePlane_Alaska_3_FIPS_5003': 26733,
       'NAD_1927_StatePlane_Alaska_4_FIPS_5004': 26734,
       'NAD_1927_StatePlane_Alaska_5_FIPS_5005': 26735,
       'NAD_1927_StatePlane_Alaska_6_FIPS_5006': 26736,
       'NAD_1927_StatePlane_Alaska_7_FIPS_5007': 26737,
       'NAD_1927_StatePlane_Alaska_8_FIPS_5008': 26738,
       'NAD_1927_StatePlane_Alaska_9_FIPS_5009': 26739,
       'NAD_1927_StatePlane_Alaska_10_FIPS_5010': 26740,
       'NAD_1927_StatePlane_California_I_FIPS_0401': 26741,
       'NAD_1927_StatePlane_California_II_FIPS_0402': 26742,
       'NAD_1927_StatePlane_California_III_FIPS_0403': 26743,
       'NAD_1927_StatePlane_California_IV_FIPS_0404': 26744,
       'NAD_1927_StatePlane_California_V_FIPS_0405': 26745,
       'NAD_1927_StatePlane_California_VI_FIPS_0406': 26746,
       'NAD_1927_StatePlane_California_VII_FIPS_0407': 26747,
       'NAD_1927_StatePlane_Arizona_East_FIPS_0201': 26748,
       'NAD_1927_StatePlane_Arizona_Central_FIPS_0202': 26749,
       'NAD_1927_StatePlane_Arizona_West_FIPS_0203': 26750,
       'NAD_1927_StatePlane_Arkansas_North_FIPS_0301': 26751,
       'NAD_1927_StatePlane_Arkansas_South_FIPS_0302': 26752,
       'NAD_1927_StatePlane_Colorado_North_FIPS_0501': 26753,
       'NAD_1927_StatePlane_Colorado_Central_FIPS_0502': 26754,
       'NAD_1927_StatePlane_Colorado_South_FIPS_0503': 26755,
       'NAD_1927_StatePlane_Connecticut_FIPS_0600': 26756,
       'NAD_1927_StatePlane_Delaware_FIPS_0700': 26757,
       'NAD_1927_StatePlane_Florida_East_FIPS_0901': 26758,
       'NAD_1927_StatePlane_Florida_West_FIPS_0902': 26759,
       'NAD_1927_StatePlane_Florida_North_FIPS_0903': 26760,
       'NAD_1927_StatePlane_Hawaii_1_FIPS_5101': 26761,
       'NAD_1927_StatePlane_Hawaii_2_FIPS_5102': 26762,
       'NAD_1927_StatePlane_Hawaii_3_FIPS_5103': 26763,
       'NAD_1927_StatePlane_Hawaii_4_FIPS_5104': 26764,
       'NAD_1927_StatePlane_Hawaii_5_FIPS_5105': 26765,
       'NAD_1927_StatePlane_Georgia_East_FIPS_1001': 26766,
       'NAD_1927_StatePlane_Georgia_West_FIPS_1002': 26767,
       'NAD_1927_StatePlane_Idaho_East_FIPS_1101': 26768,
       'NAD_1927_StatePlane_Idaho_Central_FIPS_1102': 26769,
       'NAD_1927_StatePlane_Idaho_West_FIPS_1103': 26770,
       'NAD_1927_StatePlane_Illinois_East_FIPS_1201': 26771,
       'NAD_1927_StatePlane_Illinois_West_FIPS_1202': 26772,
       'NAD_1927_StatePlane_Indiana_East_FIPS_1301': 26773,
       'NAD_1927_StatePlane_Indiana_West_FIPS_1302': 26774,
       'NAD_1927_StatePlane_Iowa_North_FIPS_1401': 26775,
       'NAD_1927_StatePlane_Iowa_South_FIPS_1402': 26776,
       'NAD_1927_StatePlane_Kansas_North_FIPS_1501': 26777,
       'NAD_1927_StatePlane_Kansas_South_FIPS_1502': 26778,
       'NAD_1927_StatePlane_Kentucky_North_FIPS_1601': 26779,
       'NAD_1927_StatePlane_Kentucky_South_FIPS_1602': 26780,
       'NAD_1927_StatePlane_Louisiana_North_FIPS_1701': 26781,
       'NAD_1927_StatePlane_Louisiana_South_FIPS_1702': 26782,
       'NAD_1927_StatePlane_Maine_East_FIPS_1801': 26783,
       'NAD_1927_StatePlane_Maine_West_FIPS_1802': 26784,
       'NAD_1927_StatePlane_Maryland_FIPS_1900': 26785,
       'NAD_1927_StatePlane_Massachusetts_Mainland_FIPS_2001': 26786,
       'NAD_1927_StatePlane_Massachusetts_Island_FIPS_2002': 26787,
       'NAD_1927_StatePlane_Michigan_North_FIPS_2111': 26788,
       'NAD_1927_StatePlane_Michigan_Central_FIPS_2112': 26789,
       'NAD_1927_StatePlane_Michigan_South_FIPS_2113': 26790,
       'NAD_1927_StatePlane_Minnesota_North_FIPS_2201': 26791,
       'NAD_1927_StatePlane_Minnesota_Central_FIPS_2202': 26792,
       'NAD_1927_StatePlane_Minnesota_South_FIPS_2203': 26793,
       'NAD_1927_StatePlane_Mississippi_East_FIPS_2301': 26794,
       'NAD_1927_StatePlane_Mississippi_West_FIPS_2302': 26795,
       'NAD_1927_StatePlane_Missouri_East_FIPS_2401': 26796,
       'NAD_1927_StatePlane_Missouri_Central_FIPS_2402': 26797,
       'NAD_1927_StatePlane_Missouri_West_FIPS_2403': 26798,
       'NAD_1927_StatePlane_California_VII_FIPS_0407': 26799,
       'NAD_Michigan_StatePlane_Michigan_East_Old_FIPS_2101': 26801,
       'NAD_Michigan_StatePlane_Michigan_Central_Old_FIPS_2102': 26802,
       'NAD_Michigan_StatePlane_Michigan_West_Old_FIPS_2103': 26803,
       'NAD_Michigan_StatePlane_Michigan_North_FIPS_2111': 26811,
       'NAD_Michigan_StatePlane_Michigan_Central_FIPS_2112': 26812,
       'NAD_Michigan_StatePlane_Michigan_South_FIPS_2113': 26813,
       'NAD_1983_UTM_Zone_1N': 26901,
       'NAD_1983_UTM_Zone_2N': 26902,
       'NAD_1983_UTM_Zone_3N': 26903,
       'NAD_1983_UTM_Zone_4N': 26904,
       'NAD_1983_UTM_Zone_5N': 26905,
       'NAD_1983_UTM_Zone_6N': 26906,
       'NAD_1983_UTM_Zone_7N': 26907,
       'NAD_1983_UTM_Zone_8N': 26908,
       'NAD_1983_UTM_Zone_9N': 26909,
       'NAD_1983_UTM_Zone_10N': 26910,
       'NAD_1983_UTM_Zone_11N': 26911,
       'NAD_1983_UTM_Zone_12N': 26912,
       'NAD_1983_UTM_Zone_13N': 26913,
       'NAD_1983_UTM_Zone_14N': 26914,
       'NAD_1983_UTM_Zone_15N': 26915,
       'NAD_1983_UTM_Zone_16N': 26916,
       'NAD_1983_UTM_Zone_17N': 26917,
       'NAD_1983_UTM_Zone_18N': 26918,
       'NAD_1983_UTM_Zone_19N': 26919,
       'NAD_1983_UTM_Zone_20N': 26920,
       'NAD_1983_UTM_Zone_21N': 26921,
       'NAD_1983_UTM_Zone_22N': 26922,
       'NAD_1983_UTM_Zone_23N': 26923,
       'NAD_1983_StatePlane_Alabama_East_FIPS_0101': 26929,
       'NAD_1983_StatePlane_Alabama_West_FIPS_0102': 26930,
       'NAD_1983_StatePlane_Alaska_1_FIPS_5001': 26931,
       'NAD_1983_StatePlane_Alaska_2_FIPS_5002': 26932,
       'NAD_1983_StatePlane_Alaska_3_FIPS_5003': 26933,
       'NAD_1983_StatePlane_Alaska_4_FIPS_5004': 26934,
       'NAD_1983_StatePlane_Alaska_5_FIPS_5005': 26935,
       'NAD_1983_StatePlane_Alaska_6_FIPS_5006': 26936,
       'NAD_1983_StatePlane_Alaska_7_FIPS_5007': 26937,
       'NAD_1983_StatePlane_Alaska_8_FIPS_5008': 26938,
       'NAD_1983_StatePlane_Alaska_9_FIPS_5009': 26939,
       'NAD_1983_StatePlane_Alaska_10_FIPS_5010': 26940,
       'NAD_1983_StatePlane_California_I_FIPS_0401': 26941,
       'NAD_1983_StatePlane_California_II_FIPS_0402': 26942,
       'NAD_1983_StatePlane_California_III_FIPS_0403': 26943,
       'NAD_1983_StatePlane_California_IV_FIPS_0404': 26944,
       'NAD_1983_StatePlane_California_V_FIPS_0405': 26945,
       'NAD_1983_StatePlane_California_VI_FIPS_0406': 26946,
       'NAD_1983_StatePlane_Arizona_East_FIPS_0201': 26948,
       'NAD_1983_StatePlane_Arizona_Central_FIPS_0202': 26949,
       'NAD_1983_StatePlane_Arizona_West_FIPS_0203': 26950,
       'NAD_1983_StatePlane_Arkansas_North_FIPS_0301': 26951,
       'NAD_1983_StatePlane_Arkansas_South_FIPS_0302': 26952,
       'NAD_1983_StatePlane_Colorado_North_FIPS_0501': 26953,
       'NAD_1983_StatePlane_Colorado_Central_FIPS_0502': 26954,
       'NAD_1983_StatePlane_Colorado_South_FIPS_0503': 26955,
       'NAD_1983_StatePlane_Connecticut_FIPS_0600': 26956,
       'NAD_1983_StatePlane_Delaware_FIPS_0700': 26957,
       'NAD_1983_StatePlane_Florida_East_FIPS_0901': 26958,
       'NAD_1983_StatePlane_Florida_West_FIPS_0902': 26959,
       'NAD_1983_StatePlane_Florida_North_FIPS_0903': 26960,
       'NAD_1983_StatePlane_Hawaii_1_FIPS_5101': 26961,
       'NAD_1983_StatePlane_Hawaii_2_FIPS_5102': 26962,
       'NAD_1983_StatePlane_Hawaii_3_FIPS_5103': 26963,
       'NAD_1983_StatePlane_Hawaii_4_FIPS_5104': 26964,
       'NAD_1983_StatePlane_Hawaii_5_FIPS_5105': 26965,
       'NAD_1983_StatePlane_Georgia_East_FIPS_1001': 26966,
       'NAD_1983_StatePlane_Georgia_West_FIPS_1002': 26967,
       'NAD_1983_StatePlane_Idaho_East_FIPS_1101': 26968,
       'NAD_1983_StatePlane_Idaho_Central_FIPS_1102': 26969,
       'NAD_1983_StatePlane_Idaho_West_FIPS_1103': 26970,
       'NAD_1983_StatePlane_Illinois_East_FIPS_1201': 26971,
       'NAD_1983_StatePlane_Illinois_West_FIPS_1202': 26972,
       'NAD_1983_StatePlane_Indiana_East_FIPS_1301': 26973,
       'NAD_1983_StatePlane_Indiana_West_FIPS_1302': 26974,
       'NAD_1983_StatePlane_Iowa_North_FIPS_1401': 26975,
       'NAD_1983_StatePlane_Iowa_South_FIPS_1402': 26976,
       'NAD_1983_StatePlane_Kansas_North_FIPS_1501': 26977,
       'NAD_1983_StatePlane_Kansas_South_FIPS_1502': 26978,
       'NAD_1983_StatePlane_Kentucky_North_FIPS_1601': 26979,
       'NAD_1983_StatePlane_Kentucky_South_FIPS_1602': 26980,
       'NAD_1983_StatePlane_Louisiana_North_FIPS_1701': 26981,
       'NAD_1983_StatePlane_Louisiana_South_FIPS_1702': 26982,
       'NAD_1983_StatePlane_Maine_East_FIPS_1801': 26983,
       'NAD_1983_StatePlane_Maine_West_FIPS_1802': 26984,
       'NAD_1983_StatePlane_Maryland_FIPS_1900': 26985,
       'NAD_1983_StatePlane_Massachusetts_Mainland_FIPS_2001': 26986,
       'NAD_1983_StatePlane_Massachusetts_Island_FIPS_2002': 26987,
       'NAD_1983_StatePlane_Michigan_North_FIPS_2111': 26988,
       'NAD_1983_StatePlane_Michigan_Central_FIPS_2112': 26989,
       'NAD_1983_StatePlane_Michigan_South_FIPS_2113': 26990,
       'NAD_1983_StatePlane_Minnesota_North_FIPS_2201': 26991,
       'NAD_1983_StatePlane_Minnesota_Central_FIPS_2202': 26992,
       'NAD_1983_StatePlane_Minnesota_South_FIPS_2203': 26993,
       'NAD_1983_StatePlane_Mississippi_East_FIPS_2301': 26994,
       'NAD_1983_StatePlane_Mississippi_West_FIPS_2302': 26995,
       'NAD_1983_StatePlane_Missouri_East_FIPS_2401': 26996,
       'NAD_1983_StatePlane_Missouri_Central_FIPS_2402': 26997,
       'NAD_1983_StatePlane_Missouri_West_FIPS_2403': 26998,
       'Nahrwan_1967_UTM_Zone_37N': 27037,
       'Nahrwan_1967_UTM_Zone_38N': 27038,
       'Nahrwan_1967_UTM_Zone_39N': 27039,
       'Nahrwan_1967_UTM_Zone_40N': 27040,
       'Naparima_1972_UTM_Zone_20N': 27120,
       'GD_1949_New_Zealand_Map_Grid': 27200,
       'NZGD_1949_Mount_Eden_Circuit': 27205,
       'NZGD_1949_Bay_of_Plenty_Circuit': 27206,
       'NZGD_1949_Poverty_Bay_Circuit': 27207,
       'NZGD_1949_Hawkes_Bay_Circuit': 27208,
       'NZGD_1949_Taranaki_Circuit': 27209,
       'NZGD_1949_Tuhirangi_Circuit': 27210,
       'NZGD_1949_Wanganui_Circuit': 27211,
       'NZGD_1949_Wairarapa_Circuit': 27212,
       'NZGD_1949_Wellington_Circuit': 27213,
       'NZGD_1949_Collingwood_Circuit': 27214,
       'NZGD_1949_Nelson_Circuit': 27215,
       'NZGD_1949_Karamea_Circuit': 27216,
       'NZGD_1949_Buller_Circuit': 27217,
       'NZGD_1949_Grey_Circuit': 27218,
       'NZGD_1949_Amuri_Circuit': 27219,
       'NZGD_1949_Marlborough_Circuit': 27220,
       'NZGD_1949_Hokitika_Circuit': 27221,
       'NZGD_1949_Okarito_Circuit': 27222,
       'NZGD_1949_Jacksons_Bay_Circuit': 27223,
       'NZGD_1949_Mount_Pleasant_Circuit': 27224,
       'NZGD_1949_Gawler_Circuit': 27225,
       'NZGD_1949_Timaru_Circuit': 27226,
       'NZGD_1949_Lindis_Peak_Circuit': 27227,
       'NZGD_1949_Mount_Nicholas_Circuit': 27228,
       'NZGD_1949_Mount_York_Circuit': 27229,
       'NZGD_1949_Observation_Point_Circuit': 27230,
       'NZGD_1949_North_Taieri_Circuit': 27231,
       'NZGD_1949_Bluff_Circuit': 27232,
       'NZGD_1949_UTM_Zone_58S': 27258,
       'NZGD_1949_UTM_Zone_59S': 27259,
       'NZGD_1949_UTM_Zone_60S': 27260,
       'New_Zealand_North_Island': 27291,
       'New_Zealand_South_Island': 27292,
       'NGO_1948_Oslo_Norway_Zone_1': 27391,
       'NGO_1948_Oslo_Norway_Zone_2': 27392,
       'NGO_1948_Oslo_Norway_Zone_3': 27393,
       'NGO_1948_Oslo_Norway_Zone_4': 27394,
       'NGO_1948_Oslo_Norway_Zone_5': 27395,
       'NGO_1948_Oslo_Norway_Zone_6': 27396,
       'NGO_1948_Oslo_Norway_Zone_7': 27397,
       'NGO_1948_Oslo_Norway_Zone_8': 27398,
       'Datum_73_UTM_Zone_29N': 27429,
       'Datum_73_Modified_Portuguese_Grid': 27492,
       'Nord_de_Guerre': 27500,
       'NTF_Paris_Lambert_Nord_France': 27561,
       'NTF_Paris_Lambert_Centre_France': 27562,
       'NTF_Paris_Lambert_Sud_France': 27563,
       'NTF_Paris_Lambert_Corse': 27564,
       'NTF_Paris_Lambert_Zone_I': 27571,
       'NTF_Paris_Lambert_Zone_II': 27572,
       'NTF_Paris_Lambert_Zone_III': 27573,
       'NTF_Paris_Lambert_Zone_IV': 27574,
       'NTF_Paris_France_I': 27581,
       'NTF_Paris_France_II': 27582,
       'NTF_Paris_France_III': 27583,
       'NTF_Paris_France_IV': 27584,
       'NTF_Paris_Nord_France': 27591,
       'NTF_Paris_Centre_France': 27592,
       'NTF_Paris_Sud_France': 27593,
       'NTF_Paris_Corse': 27594,
       'British_National_Grid': 27700,
       'Palestine_1923_Palestine_Grid': 28191,
       'Palestine_1923_Palestine_Belt': 28192,
       'Palestine_1923_Israel_CS_Grid': 28193,
       'Pointe_Noire_UTM_Zone_32S': 28232,
       'GDA_1994_MGA_Zone_48': 28348,
       'GDA_1994_MGA_Zone_49': 28349,
       'GDA_1994_MGA_Zone_50': 28350,
       'GDA_1994_MGA_Zone_51': 28351,
       'GDA_1994_MGA_Zone_52': 28352,
       'GDA_1994_MGA_Zone_53': 28353,
       'GDA_1994_MGA_Zone_54': 28354,
       'GDA_1994_MGA_Zone_55': 28355,
       'GDA_1994_MGA_Zone_56': 28356,
       'GDA_1994_MGA_Zone_57': 28357,
       'GDA_1994_MGA_Zone_58': 28358,
       'Pulkovo_1942_GK_Zone_2': 28402,
       'Pulkovo_1942_GK_Zone_3': 28403,
       'Pulkovo_1942_GK_Zone_4': 28404,
       'Pulkovo_1942_GK_Zone_5': 28405,
       'Pulkovo_1942_GK_Zone_6': 28406,
       'Pulkovo_1942_GK_Zone_7': 28407,
       'Pulkovo_1942_GK_Zone_8': 28408,
       'Pulkovo_1942_GK_Zone_9': 28409,
       'Pulkovo_1942_GK_Zone_10': 28410,
       'Pulkovo_1942_GK_Zone_11': 28411,
       'Pulkovo_1942_GK_Zone_12': 28412,
       'Pulkovo_1942_GK_Zone_13': 28413,
       'Pulkovo_1942_GK_Zone_14': 28414,
       'Pulkovo_1942_GK_Zone_15': 28415,
       'Pulkovo_1942_GK_Zone_16': 28416,
       'Pulkovo_1942_GK_Zone_17': 28417,
       'Pulkovo_1942_GK_Zone_18': 28418,
       'Pulkovo_1942_GK_Zone_19': 28419,
       'Pulkovo_1942_GK_Zone_20': 28420,
       'Pulkovo_1942_GK_Zone_21': 28421,
       'Pulkovo_1942_GK_Zone_22': 28422,
       'Pulkovo_1942_GK_Zone_23': 28423,
       'Pulkovo_1942_GK_Zone_24': 28424,
       'Pulkovo_1942_GK_Zone_25': 28425,
       'Pulkovo_1942_GK_Zone_26': 28426,
       'Pulkovo_1942_GK_Zone_27': 28427,
       'Pulkovo_1942_GK_Zone_28': 28428,
       'Pulkovo_1942_GK_Zone_29': 28429,
       'Pulkovo_1942_GK_Zone_30': 28430,
       'Pulkovo_1942_GK_Zone_31': 28431,
       'Pulkovo_1942_GK_Zone_32': 28432,
       'Pulkovo_1942_GK_Zone_2N': 28462,
       'Pulkovo_1942_GK_Zone_3N': 28463,
       'Pulkovo_1942_GK_Zone_4N': 28464,
       'Pulkovo_1942_GK_Zone_5N': 28465,
       'Pulkovo_1942_GK_Zone_6N': 28466,
       'Pulkovo_1942_GK_Zone_7N': 28467,
       'Pulkovo_1942_GK_Zone_8N': 28468,
       'Pulkovo_1942_GK_Zone_9N': 28469,
       'Pulkovo_1942_GK_Zone_10N': 28470,
       'Pulkovo_1942_GK_Zone_11N': 28471,
       'Pulkovo_1942_GK_Zone_12N': 28472,
       'Pulkovo_1942_GK_Zone_13N': 28473,
       'Pulkovo_1942_GK_Zone_14N': 28474,
       'Pulkovo_1942_GK_Zone_15N': 28475,
       'Pulkovo_1942_GK_Zone_16N': 28476,
       'Pulkovo_1942_GK_Zone_17N': 28477,
       'Pulkovo_1942_GK_Zone_18N': 28478,
       'Pulkovo_1942_GK_Zone_19N': 28479,
       'Pulkovo_1942_GK_Zone_20N': 28480,
       'Pulkovo_1942_GK_Zone_21N': 28481,
       'Pulkovo_1942_GK_Zone_22N': 28482,
       'Pulkovo_1942_GK_Zone_23N': 28483,
       'Pulkovo_1942_GK_Zone_24N': 28484,
       'Pulkovo_1942_GK_Zone_25N': 28485,
       'Pulkovo_1942_GK_Zone_26N': 28486,
       'Pulkovo_1942_GK_Zone_27N': 28487,
       'Pulkovo_1942_GK_Zone_28N': 28488,
       'Pulkovo_1942_GK_Zone_29N': 28489,
       'Pulkovo_1942_GK_Zone_30N': 28490,
       'Pulkovo_1942_GK_Zone_31N': 28491,
       'Pulkovo_1942_GK_Zone_32N': 28492,
       'Qatar_National_Grid': 28600,
       'RD_Old': 28991,
       'RD_New': 28992,
       'SAD_1969_Brazil_Polyconic': 29100,
       'SAD_1969_Brazil_Polyconic': 29101,
       'SAD_1969_UTM_Zone_18N': 29118,
       'SAD_1969_UTM_Zone_19N': 29119,
       'SAD_1969_UTM_Zone_20N': 29120,
       'SAD_1969_UTM_Zone_21N': 29121,
       'SAD_1969_UTM_Zone_22N': 29122,
       'SAD_1969_UTM_Zone_18N': 29168,
       'SAD_1969_UTM_Zone_19N': 29169,
       'SAD_1969_UTM_Zone_20N': 29170,
       'SAD_1969_UTM_Zone_21N': 29171,
       'SAD_1969_UTM_Zone_22N': 29172,
       'SAD_1969_UTM_Zone_17S': 29177,
       'SAD_1969_UTM_Zone_18S': 29178,
       'SAD_1969_UTM_Zone_19S': 29179,
       'SAD_1969_UTM_Zone_20S': 29180,
       'SAD_1969_UTM_Zone_21S': 29181,
       'SAD_1969_UTM_Zone_22S': 29182,
       'SAD_1969_UTM_Zone_23S': 29183,
       'SAD_1969_UTM_Zone_24S': 29184,
       'SAD_1969_UTM_Zone_25S': 29185,
       'SAD_1969_UTM_Zone_17S': 29187,
       'SAD_1969_UTM_Zone_18S': 29188,
       'SAD_1969_UTM_Zone_19S': 29189,
       'SAD_1969_UTM_Zone_20S': 29190,
       'SAD_1969_UTM_Zone_21S': 29191,
       'SAD_1969_UTM_Zone_22S': 29192,
       'SAD_1969_UTM_Zone_23S': 29193,
       'SAD_1969_UTM_Zone_24S': 29194,
       'SAD_1969_UTM_Zone_25S': 29195,
       'Sapper_Hill_1943_UTM_Zone_20S': 29220,
       'Sapper_Hill_1943_UTM_Zone_21S': 29221,
       'Schwarzeck_UTM_Zone_33S': 29333,
       'Sudan_UTM_Zone_35N': 29635,
       'Sudan_UTM_Zone_36N': 29636,
       'Tananarive_1925_UTM_Zone_38S': 29738,
       'Tananarive_1925_UTM_Zone_39S': 29739,
       'Timbalai_1948_UTM_Zone_49N': 29849,
       'Timbalai_1948_UTM_Zone_50N': 29850,
       'Timbalai_1948_RSO_Borneo_Chains': 29871,
       'Timbalai_1948_RSO_Borneo_Feet': 29872,
       'Timbalai_1948_RSO_Borneo_Meters': 29873,
       'TM65_Irish_Grid': 29900,
       'OSNI_1952_Irish_National_Grid': 29901,
       'TM65_Irish_Grid': 29902,
       'TM75_Irish_Grid': 29903,
       'Japan_Zone_1': 30161,
       'Japan_Zone_2': 30162,
       'Japan_Zone_3': 30163,
       'Japan_Zone_4': 30164,
       'Japan_Zone_5': 30165,
       'Japan_Zone_6': 30166,
       'Japan_Zone_7': 30167,
       'Japan_Zone_8': 30168,
       'Japan_Zone_9': 30169,
       'Japan_Zone_10': 30170,
       'Japan_Zone_11': 30171,
       'Japan_Zone_12': 30172,
       'Japan_Zone_13': 30173,
       'Japan_Zone_14': 30174,
       'Japan_Zone_15': 30175,
       'Japan_Zone_16': 30176,
       'Japan_Zone_17': 30177,
       'Japan_Zone_18': 30178,
       'Japan_Zone_19': 30179,
       'Trinidad_1903_Trinidad_Grid': 30200,
       'TC_1948_UTM_Zone_39N': 30339,
       'TC_1948_UTM_Zone_40N': 30340,
       'Nord_Algerie_Ancienne': 30491,
       'Sud_Algerie_Ancienne': 30492,
       'Voirol_1879_Nord_Algerie_Ancienne': 30493,
       'Voirol_1879_Sud_Algerie_Ancienne': 30494,
       'Nord_Algerie': 30591,
       'Sud_Algerie': 30592,
       'Nord_Sahara_1959_UTM_Zone_29N': 30729,
       'Nord_Sahara_1959_UTM_Zone_30N': 30730,
       'Nord_Sahara_1959_UTM_Zone_31N': 30731,
       'Nord_Sahara_1959_UTM_Zone_32N': 30732,
       'Nord_Sahara_1959_Voirol_Unifie_Nord': 30791,
       'Nord_Sahara_1959_Voirol_Unifie_Sud': 30792,
       'Swedish_National_Grid': 30800,
       'Yoff_1972_UTM_Zone_28N': 31028,
       'Zanderij_1972_UTM_Zone_21N': 31121,
       'Zanderij_TM_54_NW': 31154,
       'Zanderij_Suriname_Old_TM': 31170,
       'Zanderij_Suriname_TM': 31171,
       'MGI_Ferro_Austria_GK_West': 31251,
       'MGI_Ferro_Austria_GK_Central': 31252,
       'MGI_Ferro_Austria_GK_East': 31253,
       'MGI_Austria_GK_West': 31254,
       'MGI_Austria_GK_Central': 31255,
       'MGI_Austria_GK_East': 31256,
       'MGI_Austria_GK_M28': 31257,
       'MGI_Austria_GK_M31': 31258,
       'MGI_Austria_GK_M34': 31259,
       'MGI_3_Degree_Gauss_Zone_5': 31265,
       'MGI_3_Degree_Gauss_Zone_6': 31266,
       'MGI_3_Degree_Gauss_Zone_7': 31267,
       'MGI_3_Degree_Gauss_Zone_8': 31268,
       'MGI_Balkans_5': 31275,
       'MGI_Balkans_6': 31276,
       'MGI_Balkans_7': 31277,
       'MGI_Balkans_8': 31278,
       'MGI_Balkans_8': 31279,
       'Austria_West_Zone': 31281,
       'Austria_Central_Zone': 31282,
       'Austria_East_Zone': 31283,
       'MGI_M28': 31284,
       'MGI_M31': 31285,
       'MGI_M34': 31286,
       'MGI_Austria_Lambert': 31287,
       'MGI_Ferro_M28': 31288,
       'MGI_Ferro_M31': 31289,
       'MGI_Ferro_M34': 31290,
       'Austria_West_Zone': 31291,
       'Austria_Central_Zone': 31292,
       'Austria_East_Zone': 31293,
       'MGI_M28': 31294,
       'MGI_M31': 31295,
       'MGI_M34': 31296,
       'MGI_Austria_Lambert': 31297,
       'Belge_Lambert_1972': 31370,
       'DHDN_3_Degree_Gauss_Zone_1': 31461,
       'DHDN_3_Degree_Gauss_Zone_2': 31462,
       'DHDN_3_Degree_Gauss_Zone_3': 31463,
       'DHDN_3_Degree_Gauss_Zone_4': 31464,
       'DHDN_3_Degree_Gauss_Zone_5': 31465,
       'DHDN_3_Degree_Gauss_Zone_2': 31466,
       'DHDN_3_Degree_Gauss_Zone_3': 31467,
       'DHDN_3_Degree_Gauss_Zone_4': 31468,
       'DHDN_3_Degree_Gauss_Zone_5': 31469,
       'Germany_Zone_1': 31491,
       'Germany_Zone_2': 31492,
       'Germany_Zone_3': 31493,
       'Germany_Zone_4': 31494,
       'Germany_Zone_5': 31495,
       'Conakry_1905_UTM_Zone_28N': 31528,
       'Conakry_1905_UTM_Zone_29N': 31529,
       'Stereo_33': 31600,
       'Stereo_70': 31700,
       'NGN_UTM_Zone_38N': 31838,
       'NGN_UTM_Zone_39N': 31839,
       'KUDAMS_KTM': 31901,
       'SIRGAS_UTM_Zone_17N': 31917,
       'SIRGAS_UTM_Zone_18N': 31918,
       'SIRGAS_UTM_Zone_19N': 31919,
       'SIRGAS_UTM_Zone_20N': 31920,
       'SIRGAS_UTM_Zone_21N': 31921,
       'SIRGAS_UTM_Zone_22N': 31922,
       'SIRGAS_2000_UTM_Zone_17N': 31971,
       'SIRGAS_2000_UTM_Zone_18N': 31972,
       'SIRGAS_2000_UTM_Zone_19N': 31973,
       'SIRGAS_2000_UTM_Zone_20N': 31974,
       'SIRGAS_2000_UTM_Zone_21N': 31975,
       'SIRGAS_2000_UTM_Zone_22N': 31976,
       'SIRGAS_2000_UTM_Zone_17S': 31977,
       'SIRGAS_2000_UTM_Zone_18S': 31978,
       'SIRGAS_2000_UTM_Zone_19S': 31979,
       'SIRGAS_2000_UTM_Zone_20S': 31980,
       'SIRGAS_2000_UTM_Zone_21S': 31981,
       'SIRGAS_2000_UTM_Zone_22S': 31982,
       'SIRGAS_2000_UTM_Zone_23S': 31983,
       'SIRGAS_2000_UTM_Zone_24S': 31984,
       'SIRGAS_2000_UTM_Zone_25S': 31985,
       'SIRGAS_UTM_Zone_17N': 31986,
       'SIRGAS_UTM_Zone_18N': 31987,
       'SIRGAS_UTM_Zone_19N': 31988,
       'SIRGAS_UTM_Zone_20N': 31989,
       'SIRGAS_UTM_Zone_21N': 31990,
       'SIRGAS_UTM_Zone_22N': 31991,
       'SIRGAS_UTM_Zone_17S': 31992,
       'SIRGAS_UTM_Zone_18S': 31993,
       'SIRGAS_UTM_Zone_19S': 31994,
       'SIRGAS_UTM_Zone_20S': 31995,
       'SIRGAS_UTM_Zone_21S': 31996,
       'SIRGAS_UTM_Zone_22S': 31997,
       'SIRGAS_UTM_Zone_23S': 31998,
       'SIRGAS_UTM_Zone_24S': 31999,
       'SIRGAS_UTM_Zone_25S': 32000,
       'NAD_1927_StatePlane_Montana_North_FIPS_2501': 32001,
       'NAD_1927_StatePlane_Montana_Central_FIPS_2502': 32002,
       'NAD_1927_StatePlane_Montana_South_FIPS_2503': 32003,
       'NAD_1927_StatePlane_Nebraska_North_FIPS_2601': 32005,
       'NAD_1927_StatePlane_Nebraska_South_FIPS_2602': 32006,
       'NAD_1927_StatePlane_Nevada_East_FIPS_2701': 32007,
       'NAD_1927_StatePlane_Nevada_Central_FIPS_2702': 32008,
       'NAD_1927_StatePlane_Nevada_West_FIPS_2703': 32009,
       'NAD_1927_StatePlane_New_Hampshire_FIPS_2800': 32010,
       'NAD_1927_StatePlane_New_Jersey_FIPS_2900': 32011,
       'NAD_1927_StatePlane_New_Mexico_East_FIPS_3001': 32012,
       'NAD_1927_StatePlane_New_Mexico_Central_FIPS_3002': 32013,
       'NAD_1927_StatePlane_New_Mexico_West_FIPS_3003': 32014,
       'NAD_1927_StatePlane_New_York_East_FIPS_3101': 32015,
       'NAD_1927_StatePlane_New_York_Central_FIPS_3102': 32016,
       'NAD_1927_StatePlane_New_York_West_FIPS_3103': 32017,
       'NAD_1927_StatePlane_New_York_Long_Island_FIPS_3104': 32018,
       'NAD_1927_StatePlane_North_Carolina_FIPS_3200': 32019,
       'NAD_1927_StatePlane_North_Dakota_North_FIPS_3301': 32020,
       'NAD_1927_StatePlane_North_Dakota_South_FIPS_3302': 32021,
       'NAD_1927_StatePlane_Ohio_North_FIPS_3401': 32022,
       'NAD_1927_StatePlane_Ohio_South_FIPS_3402': 32023,
       'NAD_1927_StatePlane_Oklahoma_North_FIPS_3501': 32024,
       'NAD_1927_StatePlane_Oklahoma_South_FIPS_3502': 32025,
       'NAD_1927_StatePlane_Oregon_North_FIPS_3601': 32026,
       'NAD_1927_StatePlane_Oregon_South_FIPS_3602': 32027,
       'NAD_1927_StatePlane_Pennsylvania_North_FIPS_3701': 32028,
       'NAD_1927_StatePlane_Pennsylvania_South_FIPS_3702': 32029,
       'NAD_1927_StatePlane_Rhode_Island_FIPS_3800': 32030,
       'NAD_1927_StatePlane_South_Carolina_North_FIPS_3901': 32031,
       'NAD_1927_StatePlane_South_Carolina_South_FIPS_3902': 32033,
       'NAD_1927_StatePlane_South_Dakota_North_FIPS_4001': 32034,
       'NAD_1927_StatePlane_South_Dakota_South_FIPS_4002': 32035,
       'NAD_1927_StatePlane_Tennessee_FIPS_4100': 32036,
       'NAD_1927_StatePlane_Texas_North_FIPS_4201': 32037,
       'NAD_1927_StatePlane_Texas_North_Central_FIPS_4202': 32038,
       'NAD_1927_StatePlane_Texas_Central_FIPS_4203': 32039,
       'NAD_1927_StatePlane_Texas_South_Central_FIPS_4204': 32040,
       'NAD_1927_StatePlane_Texas_South_FIPS_4205': 32041,
       'NAD_1927_StatePlane_Utah_North_FIPS_4301': 32042,
       'NAD_1927_StatePlane_Utah_Central_FIPS_4302': 32043,
       'NAD_1927_StatePlane_Utah_South_FIPS_4303': 32044,
       'NAD_1927_StatePlane_Vermont_FIPS_4400': 32045,
       'NAD_1927_StatePlane_Virginia_North_FIPS_4501': 32046,
       'NAD_1927_StatePlane_Virginia_South_FIPS_4502': 32047,
       'NAD_1927_StatePlane_Washington_North_FIPS_4601': 32048,
       'NAD_1927_StatePlane_Washington_South_FIPS_4602': 32049,
       'NAD_1927_StatePlane_West_Virginia_North_FIPS_4701': 32050,
       'NAD_1927_StatePlane_West_Virginia_South_FIPS_4702': 32051,
       'NAD_1927_StatePlane_Wisconsin_North_FIPS_4801': 32052,
       'NAD_1927_StatePlane_Wisconsin_Central_FIPS_4802': 32053,
       'NAD_1927_StatePlane_Wisconsin_South_FIPS_4803': 32054,
       'NAD_1927_StatePlane_Wyoming_East_FIPS_4901': 32055,
       'NAD_1927_StatePlane_Wyoming_East_Central_FIPS_4902': 32056,
       'NAD_1927_StatePlane_Wyoming_West_Central_FIPS_4903': 32057,
       'NAD_1927_StatePlane_Wyoming_West_FIPS_4904': 32058,
       'NAD_1927_StatePlane_Puerto_Rico_FIPS_5201': 32059,
       'NAD_1927_StatePlane_Virgin_Islands_St_Croix_FIPS_5202': 32060,
       'NAD_1927_Guatemala_Norte': 32061,
       'NAD_1927_Guatemala_Sur': 32062,
       'NAD_1927_BLM_Zone_14N': 32064,
       'NAD_1927_BLM_Zone_15N': 32065,
       'NAD_1927_BLM_Zone_16N': 32066,
       'NAD_1927_BLM_Zone_17N': 32067,
       'NAD_1927_BLM_Zone_14N': 32074,
       'NAD_1927_BLM_Zone_15N': 32075,
       'NAD_1927_BLM_Zone_16N': 32076,
       'NAD_1927_BLM_Zone_17N': 32077,
       'NAD_1927_MTM_1': 32081,
       'NAD_1927_MTM_2': 32082,
       'NAD_1927_MTM_3': 32083,
       'NAD_1927_MTM_4': 32084,
       'NAD_1927_MTM_5': 32085,
       'NAD_1927_MTM_6': 32086,
       'NAD_1927_Quebec_Lambert': 32098,
       'NAD_1927_StatePlane_Louisiana_Offshore_FIPS_1703': 32099,
       'NAD_1983_StatePlane_Montana_FIPS_2500': 32100,
       'NAD_1983_StatePlane_Nebraska_FIPS_2600': 32104,
       'NAD_1983_StatePlane_Nevada_East_FIPS_2701': 32107,
       'NAD_1983_StatePlane_Nevada_Central_FIPS_2702': 32108,
       'NAD_1983_StatePlane_Nevada_West_FIPS_2703': 32109,
       'NAD_1983_StatePlane_New_Hampshire_FIPS_2800': 32110,
       'NAD_1983_StatePlane_New_Jersey_FIPS_2900': 32111,
       'NAD_1983_StatePlane_New_Mexico_East_FIPS_3001': 32112,
       'NAD_1983_StatePlane_New_Mexico_Central_FIPS_3002': 32113,
       'NAD_1983_StatePlane_New_Mexico_West_FIPS_3003': 32114,
       'NAD_1983_StatePlane_New_York_East_FIPS_3101': 32115,
       'NAD_1983_StatePlane_New_York_Central_FIPS_3102': 32116,
       'NAD_1983_StatePlane_New_York_West_FIPS_3103': 32117,
       'NAD_1983_StatePlane_New_York_Long_Island_FIPS_3104': 32118,
       'NAD_1983_StatePlane_North_Carolina_FIPS_3200': 32119,
       'NAD_1983_StatePlane_North_Dakota_North_FIPS_3301': 32120,
       'NAD_1983_StatePlane_North_Dakota_South_FIPS_3302': 32121,
       'NAD_1983_StatePlane_Ohio_North_FIPS_3401': 32122,
       'NAD_1983_StatePlane_Ohio_South_FIPS_3402': 32123,
       'NAD_1983_StatePlane_Oklahoma_North_FIPS_3501': 32124,
       'NAD_1983_StatePlane_Oklahoma_South_FIPS_3502': 32125,
       'NAD_1983_StatePlane_Oregon_North_FIPS_3601': 32126,
       'NAD_1983_StatePlane_Oregon_South_FIPS_3602': 32127,
       'NAD_1983_StatePlane_Pennsylvania_North_FIPS_3701': 32128,
       'NAD_1983_StatePlane_Pennsylvania_South_FIPS_3702': 32129,
       'NAD_1983_StatePlane_Rhode_Island_FIPS_3800': 32130,
       'NAD_1983_StatePlane_South_Carolina_FIPS_3900': 32133,
       'NAD_1983_StatePlane_South_Dakota_North_FIPS_4001': 32134,
       'NAD_1983_StatePlane_South_Dakota_South_FIPS_4002': 32135,
       'NAD_1983_StatePlane_Tennessee_FIPS_4100': 32136,
       'NAD_1983_StatePlane_Texas_North_FIPS_4201': 32137,
       'NAD_1983_StatePlane_Texas_North_Central_FIPS_4202': 32138,
       'NAD_1983_StatePlane_Texas_Central_FIPS_4203': 32139,
       'NAD_1983_StatePlane_Texas_South_Central_FIPS_4204': 32140,
       'NAD_1983_StatePlane_Texas_South_FIPS_4205': 32141,
       'NAD_1983_StatePlane_Utah_North_FIPS_4301': 32142,
       'NAD_1983_StatePlane_Utah_Central_FIPS_4302': 32143,
       'NAD_1983_StatePlane_Utah_South_FIPS_4303': 32144,
       'NAD_1983_StatePlane_Vermont_FIPS_4400': 32145,
       'NAD_1983_StatePlane_Virginia_North_FIPS_4501': 32146,
       'NAD_1983_StatePlane_Virginia_South_FIPS_4502': 32147,
       'NAD_1983_StatePlane_Washington_North_FIPS_4601': 32148,
       'NAD_1983_StatePlane_Washington_South_FIPS_4602': 32149,
       'NAD_1983_StatePlane_West_Virginia_North_FIPS_4701': 32150,
       'NAD_1983_StatePlane_West_Virginia_South_FIPS_4702': 32151,
       'NAD_1983_StatePlane_Wisconsin_North_FIPS_4801': 32152,
       'NAD_1983_StatePlane_Wisconsin_Central_FIPS_4802': 32153,
       'NAD_1983_StatePlane_Wisconsin_South_FIPS_4803': 32154,
       'NAD_1983_StatePlane_Wyoming_East_FIPS_4901': 32155,
       'NAD_1983_StatePlane_Wyoming_East_Central_FIPS_4902': 32156,
       'NAD_1983_StatePlane_Wyoming_West_Central_FIPS_4903': 32157,
       'NAD_1983_StatePlane_Wyoming_West_FIPS_4904': 32158,
       'NAD_1983_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200': 32161,
       'NAD_1983_BLM_Zone_14N_ftUS': 32164,
       'NAD_1983_BLM_Zone_15N_ftUS': 32165,
       'NAD_1983_BLM_Zone_16N_ftUS': 32166,
       'NAD_1983_BLM_Zone_17N_ftUS': 32167,
       'NAD_1983_MTM_2_SCoPQ': 32180,
       'NAD_1983_MTM_1': 32181,
       'NAD_1983_MTM_2': 32182,
       'NAD_1983_MTM_3': 32183,
       'NAD_1983_MTM_4': 32184,
       'NAD_1983_MTM_5': 32185,
       'NAD_1983_MTM_6': 32186,
       'NAD_1983_MTM_7': 32187,
       'NAD_1983_MTM_8': 32188,
       'NAD_1983_MTM_9': 32189,
       'NAD_1983_MTM_10': 32190,
       'NAD_1983_MTM_11': 32191,
       'NAD_1983_MTM_12': 32192,
       'NAD_1983_MTM_13': 32193,
       'NAD_1983_MTM_14': 32194,
       'NAD_1983_MTM_15': 32195,
       'NAD_1983_MTM_16': 32196,
       'NAD_1983_MTM_17': 32197,
       'NAD_1983_Quebec_Lambert': 32198,
       'NAD_1983_StatePlane_Louisiana_Offshore_FIPS_1703': 32199,
       'WGS_1972_UTM_Zone_1N': 32201,
       'WGS_1972_UTM_Zone_2N': 32202,
       'WGS_1972_UTM_Zone_3N': 32203,
       'WGS_1972_UTM_Zone_4N': 32204,
       'WGS_1972_UTM_Zone_5N': 32205,
       'WGS_1972_UTM_Zone_6N': 32206,
       'WGS_1972_UTM_Zone_7N': 32207,
       'WGS_1972_UTM_Zone_8N': 32208,
       'WGS_1972_UTM_Zone_9N': 32209,
       'WGS_1972_UTM_Zone_10N': 32210,
       'WGS_1972_UTM_Zone_11N': 32211,
       'WGS_1972_UTM_Zone_12N': 32212,
       'WGS_1972_UTM_Zone_13N': 32213,
       'WGS_1972_UTM_Zone_14N': 32214,
       'WGS_1972_UTM_Zone_15N': 32215,
       'WGS_1972_UTM_Zone_16N': 32216,
       'WGS_1972_UTM_Zone_17N': 32217,
       'WGS_1972_UTM_Zone_18N': 32218,
       'WGS_1972_UTM_Zone_19N': 32219,
       'WGS_1972_UTM_Zone_20N': 32220,
       'WGS_1972_UTM_Zone_21N': 32221,
       'WGS_1972_UTM_Zone_22N': 32222,
       'WGS_1972_UTM_Zone_23N': 32223,
       'WGS_1972_UTM_Zone_24N': 32224,
       'WGS_1972_UTM_Zone_25N': 32225,
       'WGS_1972_UTM_Zone_26N': 32226,
       'WGS_1972_UTM_Zone_27N': 32227,
       'WGS_1972_UTM_Zone_28N': 32228,
       'WGS_1972_UTM_Zone_29N': 32229,
       'WGS_1972_UTM_Zone_30N': 32230,
       'WGS_1972_UTM_Zone_31N': 32231,
       'WGS_1972_UTM_Zone_32N': 32232,
       'WGS_1972_UTM_Zone_33N': 32233,
       'WGS_1972_UTM_Zone_34N': 32234,
       'WGS_1972_UTM_Zone_35N': 32235,
       'WGS_1972_UTM_Zone_36N': 32236,
       'WGS_1972_UTM_Zone_37N': 32237,
       'WGS_1972_UTM_Zone_38N': 32238,
       'WGS_1972_UTM_Zone_39N': 32239,
       'WGS_1972_UTM_Zone_40N': 32240,
       'WGS_1972_UTM_Zone_41N': 32241,
       'WGS_1972_UTM_Zone_42N': 32242,
       'WGS_1972_UTM_Zone_43N': 32243,
       'WGS_1972_UTM_Zone_44N': 32244,
       'WGS_1972_UTM_Zone_45N': 32245,
       'WGS_1972_UTM_Zone_46N': 32246,
       'WGS_1972_UTM_Zone_47N': 32247,
       'WGS_1972_UTM_Zone_48N': 32248,
       'WGS_1972_UTM_Zone_49N': 32249,
       'WGS_1972_UTM_Zone_50N': 32250,
       'WGS_1972_UTM_Zone_51N': 32251,
       'WGS_1972_UTM_Zone_52N': 32252,
       'WGS_1972_UTM_Zone_53N': 32253,
       'WGS_1972_UTM_Zone_54N': 32254,
       'WGS_1972_UTM_Zone_55N': 32255,
       'WGS_1972_UTM_Zone_56N': 32256,
       'WGS_1972_UTM_Zone_57N': 32257,
       'WGS_1972_UTM_Zone_58N': 32258,
       'WGS_1972_UTM_Zone_59N': 32259,
       'WGS_1972_UTM_Zone_60N': 32260,
       'WGS_1972_UTM_Zone_1S': 32301,
       'WGS_1972_UTM_Zone_2S': 32302,
       'WGS_1972_UTM_Zone_3S': 32303,
       'WGS_1972_UTM_Zone_4S': 32304,
       'WGS_1972_UTM_Zone_5S': 32305,
       'WGS_1972_UTM_Zone_6S': 32306,
       'WGS_1972_UTM_Zone_7S': 32307,
       'WGS_1972_UTM_Zone_8S': 32308,
       'WGS_1972_UTM_Zone_9S': 32309,
       'WGS_1972_UTM_Zone_10S': 32310,
       'WGS_1972_UTM_Zone_11S': 32311,
       'WGS_1972_UTM_Zone_12S': 32312,
       'WGS_1972_UTM_Zone_13S': 32313,
       'WGS_1972_UTM_Zone_14S': 32314,
       'WGS_1972_UTM_Zone_15S': 32315,
       'WGS_1972_UTM_Zone_16S': 32316,
       'WGS_1972_UTM_Zone_17S': 32317,
       'WGS_1972_UTM_Zone_18S': 32318,
       'WGS_1972_UTM_Zone_19S': 32319,
       'WGS_1972_UTM_Zone_20S': 32320,
       'WGS_1972_UTM_Zone_21S': 32321,
       'WGS_1972_UTM_Zone_22S': 32322,
       'WGS_1972_UTM_Zone_23S': 32323,
       'WGS_1972_UTM_Zone_24S': 32324,
       'WGS_1972_UTM_Zone_25S': 32325,
       'WGS_1972_UTM_Zone_26S': 32326,
       'WGS_1972_UTM_Zone_27S': 32327,
       'WGS_1972_UTM_Zone_28S': 32328,
       'WGS_1972_UTM_Zone_29S': 32329,
       'WGS_1972_UTM_Zone_30S': 32330,
       'WGS_1972_UTM_Zone_31S': 32331,
       'WGS_1972_UTM_Zone_32S': 32332,
       'WGS_1972_UTM_Zone_33S': 32333,
       'WGS_1972_UTM_Zone_34S': 32334,
       'WGS_1972_UTM_Zone_35S': 32335,
       'WGS_1972_UTM_Zone_36S': 32336,
       'WGS_1972_UTM_Zone_37S': 32337,
       'WGS_1972_UTM_Zone_38S': 32338,
       'WGS_1972_UTM_Zone_39S': 32339,
       'WGS_1972_UTM_Zone_40S': 32340,
       'WGS_1972_UTM_Zone_41S': 32341,
       'WGS_1972_UTM_Zone_42S': 32342,
       'WGS_1972_UTM_Zone_43S': 32343,
       'WGS_1972_UTM_Zone_44S': 32344,
       'WGS_1972_UTM_Zone_45S': 32345,
       'WGS_1972_UTM_Zone_46S': 32346,
       'WGS_1972_UTM_Zone_47S': 32347,
       'WGS_1972_UTM_Zone_48S': 32348,
       'WGS_1972_UTM_Zone_49S': 32349,
       'WGS_1972_UTM_Zone_50S': 32350,
       'WGS_1972_UTM_Zone_51S': 32351,
       'WGS_1972_UTM_Zone_52S': 32352,
       'WGS_1972_UTM_Zone_53S': 32353,
       'WGS_1972_UTM_Zone_54S': 32354,
       'WGS_1972_UTM_Zone_55S': 32355,
       'WGS_1972_UTM_Zone_56S': 32356,
       'WGS_1972_UTM_Zone_57S': 32357,
       'WGS_1972_UTM_Zone_58S': 32358,
       'WGS_1972_UTM_Zone_59S': 32359,
       'WGS_1972_UTM_Zone_60S': 32360,
       'WGS_1984_UTM_Zone_1N': 32601,
       'WGS_1984_UTM_Zone_2N': 32602,
       'WGS_1984_UTM_Zone_3N': 32603,
       'WGS_1984_UTM_Zone_4N': 32604,
       'WGS_1984_UTM_Zone_5N': 32605,
       'WGS_1984_UTM_Zone_6N': 32606,
       'WGS_1984_UTM_Zone_7N': 32607,
       'WGS_1984_UTM_Zone_8N': 32608,
       'WGS_1984_UTM_Zone_9N': 32609,
       'WGS_1984_UTM_Zone_10N': 32610,
       'WGS_1984_UTM_Zone_11N': 32611,
       'WGS_1984_UTM_Zone_12N': 32612,
       'WGS_1984_UTM_Zone_13N': 32613,
       'WGS_1984_UTM_Zone_14N': 32614,
       'WGS_1984_UTM_Zone_15N': 32615,
       'WGS_1984_UTM_Zone_16N': 32616,
       'WGS_1984_UTM_Zone_17N': 32617,
       'WGS_1984_UTM_Zone_18N': 32618,
       'WGS_1984_UTM_Zone_19N': 32619,
       'WGS_1984_UTM_Zone_20N': 32620,
       'WGS_1984_UTM_Zone_21N': 32621,
       'WGS_1984_UTM_Zone_22N': 32622,
       'WGS_1984_UTM_Zone_23N': 32623,
       'WGS_1984_UTM_Zone_24N': 32624,
       'WGS_1984_UTM_Zone_25N': 32625,
       'WGS_1984_UTM_Zone_26N': 32626,
       'WGS_1984_UTM_Zone_27N': 32627,
       'WGS_1984_UTM_Zone_28N': 32628,
       'WGS_1984_UTM_Zone_29N': 32629,
       'WGS_1984_UTM_Zone_30N': 32630,
       'WGS_1984_UTM_Zone_31N': 32631,
       'WGS_1984_UTM_Zone_32N': 32632,
       'WGS_1984_UTM_Zone_33N': 32633,
       'WGS_1984_UTM_Zone_34N': 32634,
       'WGS_1984_UTM_Zone_35N': 32635,
       'WGS_1984_UTM_Zone_36N': 32636,
       'WGS_1984_UTM_Zone_37N': 32637,
       'WGS_1984_UTM_Zone_38N': 32638,
       'WGS_1984_UTM_Zone_39N': 32639,
       'WGS_1984_UTM_Zone_40N': 32640,
       'WGS_1984_UTM_Zone_41N': 32641,
       'WGS_1984_UTM_Zone_42N': 32642,
       'WGS_1984_UTM_Zone_43N': 32643,
       'WGS_1984_UTM_Zone_44N': 32644,
       'WGS_1984_UTM_Zone_45N': 32645,
       'WGS_1984_UTM_Zone_46N': 32646,
       'WGS_1984_UTM_Zone_47N': 32647,
       'WGS_1984_UTM_Zone_48N': 32648,
       'WGS_1984_UTM_Zone_49N': 32649,
       'WGS_1984_UTM_Zone_50N': 32650,
       'WGS_1984_UTM_Zone_51N': 32651,
       'WGS_1984_UTM_Zone_52N': 32652,
       'WGS_1984_UTM_Zone_53N': 32653,
       'WGS_1984_UTM_Zone_54N': 32654,
       'WGS_1984_UTM_Zone_55N': 32655,
       'WGS_1984_UTM_Zone_56N': 32656,
       'WGS_1984_UTM_Zone_57N': 32657,
       'WGS_1984_UTM_Zone_58N': 32658,
       'WGS_1984_UTM_Zone_59N': 32659,
       'WGS_1984_UTM_Zone_60N': 32660,
       'UPS_North': 32661,
       'WGS_1984_Plate_Carree': 32662,
       'WGS_1984_BLM_Zone_14N_ftUS': 32664,
       'WGS_1984_BLM_Zone_15N_ftUS': 32665,
       'WGS_1984_BLM_Zone_16N_ftUS': 32666,
       'WGS_1984_BLM_Zone_17N_ftUS': 32667,
       'WGS_1984_UTM_Zone_1S': 32701,
       'WGS_1984_UTM_Zone_2S': 32702,
       'WGS_1984_UTM_Zone_3S': 32703,
       'WGS_1984_UTM_Zone_4S': 32704,
       'WGS_1984_UTM_Zone_5S': 32705,
       'WGS_1984_UTM_Zone_6S': 32706,
       'WGS_1984_UTM_Zone_7S': 32707,
       'WGS_1984_UTM_Zone_8S': 32708,
       'WGS_1984_UTM_Zone_9S': 32709,
       'WGS_1984_UTM_Zone_10S': 32710,
       'WGS_1984_UTM_Zone_11S': 32711,
       'WGS_1984_UTM_Zone_12S': 32712,
       'WGS_1984_UTM_Zone_13S': 32713,
       'WGS_1984_UTM_Zone_14S': 32714,
       'WGS_1984_UTM_Zone_15S': 32715,
       'WGS_1984_UTM_Zone_16S': 32716,
       'WGS_1984_UTM_Zone_17S': 32717,
       'WGS_1984_UTM_Zone_18S': 32718,
       'WGS_1984_UTM_Zone_19S': 32719,
       'WGS_1984_UTM_Zone_20S': 32720,
       'WGS_1984_UTM_Zone_21S': 32721,
       'WGS_1984_UTM_Zone_22S': 32722,
       'WGS_1984_UTM_Zone_23S': 32723,
       'WGS_1984_UTM_Zone_24S': 32724,
       'WGS_1984_UTM_Zone_25S': 32725,
       'WGS_1984_UTM_Zone_26S': 32726,
       'WGS_1984_UTM_Zone_27S': 32727,
       'WGS_1984_UTM_Zone_28S': 32728,
       'WGS_1984_UTM_Zone_29S': 32729,
       'WGS_1984_UTM_Zone_30S': 32730,
       'WGS_1984_UTM_Zone_31S': 32731,
       'WGS_1984_UTM_Zone_32S': 32732,
       'WGS_1984_UTM_Zone_33S': 32733,
       'WGS_1984_UTM_Zone_34S': 32734,
       'WGS_1984_UTM_Zone_35S': 32735,
       'WGS_1984_UTM_Zone_36S': 32736,
       'WGS_1984_UTM_Zone_37S': 32737,
       'WGS_1984_UTM_Zone_38S': 32738,
       'WGS_1984_UTM_Zone_39S': 32739,
       'WGS_1984_UTM_Zone_40S': 32740,
       'WGS_1984_UTM_Zone_41S': 32741,
       'WGS_1984_UTM_Zone_42S': 32742,
       'WGS_1984_UTM_Zone_43S': 32743,
       'WGS_1984_UTM_Zone_44S': 32744,
       'WGS_1984_UTM_Zone_45S': 32745,
       'WGS_1984_UTM_Zone_46S': 32746,
       'WGS_1984_UTM_Zone_47S': 32747,
       'WGS_1984_UTM_Zone_48S': 32748,
       'WGS_1984_UTM_Zone_49S': 32749,
       'WGS_1984_UTM_Zone_50S': 32750,
       'WGS_1984_UTM_Zone_51S': 32751,
       'WGS_1984_UTM_Zone_52S': 32752,
       'WGS_1984_UTM_Zone_53S': 32753,
       'WGS_1984_UTM_Zone_54S': 32754,
       'WGS_1984_UTM_Zone_55S': 32755,
       'WGS_1984_UTM_Zone_56S': 32756,
       'WGS_1984_UTM_Zone_57S': 32757,
       'WGS_1984_UTM_Zone_58S': 32758,
       'WGS_1984_UTM_Zone_59S': 32759,
       'WGS_1984_UTM_Zone_60S': 32760,
       'UPS_South': 32761,
       'WGS_1984_TM_36_SE': 32766,
       'Sphere_Plate_Carree': 53001,
       'Sphere_Equidistant_Cylindrical': 53002,
       'Sphere_Miller_Cylindrical': 53003,
       'Sphere_Mercator': 53004,
       'Sphere_Sinusoidal': 53008,
       'Sphere_Mollweide': 53009,
       'Sphere_Eckert_VI': 53010,
       'Sphere_Eckert_V': 53011,
       'Sphere_Eckert_IV': 53012,
       'Sphere_Eckert_III': 53013,
       'Sphere_Eckert_II': 53014,
       'Sphere_Eckert_I': 53015,
       'Sphere_Gall_Stereographic': 53016,
       'Sphere_Behrmann': 53017,
       'Sphere_Winkel_I': 53018,
       'Sphere_Winkel_II': 53019,
       'Sphere_Polyconic': 53021,
       'Sphere_Quartic_Authalic': 53022,
       'Sphere_Loximuthal': 53023,
       'Sphere_Bonne': 53024,
       'Sphere_Hotine': 53025,
       'Sphere_Stereographic': 53026,
       'Sphere_Equidistant_Conic': 53027,
       'Sphere_Cassini': 53028,
       'Sphere_Van_der_Grinten_I': 53029,
       'Sphere_Robinson': 53030,
       'Sphere_Two_Point_Equidistant': 53031,
       'Sphere_Azimuthal_Equidistant': 53032,
       'Sphere_Cylindrical_Equal_Area': 53034,
       'Sphere_Winkel_Tripel_NGS': 53042,
       'Sphere_Aitoff': 53043,
       'Sphere_Hammer_Aitoff': 53044,
       'Sphere_Flat_Polar_Quartic': 53045,
       'Sphere_Craster_Parabolic': 53046,
       'Sphere_Times': 53048,
       'Sphere_Vertical_Perspective': 53049,
       'World_Plate_Carree': 54001,
       'World_Equidistant_Cylindrical': 54002,
       'World_Miller_Cylindrical': 54003,
       'World_Mercator': 54004,
       'World_Sinusoidal': 54008,
       'World_Mollweide': 54009,
       'World_Eckert_VI': 54010,
       'World_Eckert_V': 54011,
       'World_Eckert_IV': 54012,
       'World_Eckert_III': 54013,
       'World_Eckert_II': 54014,
       'World_Eckert_I': 54015,
       'World_Gall_Stereographic': 54016,
       'World_Behrmann': 54017,
       'World_Winkel_I': 54018,
       'World_Winkel_II': 54019,
       'World_Polyconic': 54021,
       'World_Quartic_Authalic': 54022,
       'World_Loximuthal': 54023,
       'World_Bonne': 54024,
       'World_Hotine': 54025,
       'World_Stereographic': 54026,
       'World_Equidistant_Conic': 54027,
       'World_Cassini': 54028,
       'World_Van_der_Grinten_I': 54029,
       'World_Robinson': 54030,
       'World_Two_Point_Equidistant': 54031,
       'World_Azimuthal_Equidistant': 54032,
       'World_Cylindrical_Equal_Area': 54034,
       'World_Winkel_Tripel_NGS': 54042,
       'World_Aitoff': 54043,
       'World_Hammer_Aitoff': 54044,
       'World_Flat_Polar_Quartic': 54045,
       'World_Craster_Parabolic': 54046,
       'World_Times': 54048,
       'World_Vertical_Perspective': 54049,
       'World_Fuller': 54050,
       'World_Cube': 54051,
       'World_Goode_Homolosine_Land': 54052,
       'World_Goode_Homolosine_Ocean': 54053,
       'NAD_1927_StatePlane_Guam_FIPS_5400': 65061,
       'American_Samoa_1962_StatePlane_American_Samoa_FIPS_5300': 65062,
       'NAD_1983_StatePlane_Guam_FIPS_5400': 65161,
       'NAD_1983_StatePlane_Kentucky_FIPS_1600': 65163,
       'Canada_Albers_Equal_Area_Conic': 102001,
       'Canada_Lambert_Conformal_Conic': 102002,
       'USA_Contiguous_Albers_Equal_Area_Conic': 102003,
       'USA_Contiguous_Lambert_Conformal_Conic': 102004,
       'USA_Contiguous_Equidistant_Conic': 102005,
       'NAD_1983_Alaska_Albers': 102006,
       'Hawaii_Albers_Equal_Area_Conic': 102007,
       'North_America_Albers_Equal_Area_Conic': 102008,
       'North_America_Lambert_Conformal_Conic': 102009,
       'North_America_Equidistant_Conic': 102010,
       'Africa_Sinusoidal': 102011,
       'Asia_Lambert_Conformal_Conic': 102012,
       'Europe_Albers_Equal_Area_Conic': 102013,
       'Europe_Lambert_Conformal_Conic': 102014,
       'South_America_Lambert_Conformal_Conic': 102015,
       'North_Pole_Azimuthal_Equidistant': 102016,
       'North_Pole_Lambert_Azimuthal_Equal_Area': 102017,
       'North_Pole_Stereographic': 102018,
       'South_Pole_Azimuthal_Equidistant': 102019,
       'South_Pole_Lambert_Azimuthal_Equal_Area': 102020,
       'South_Pole_Stereographic': 102021,
       'Africa_Albers_Equal_Area_Conic': 102022,
       'Africa_Equidistant_Conic': 102023,
       'Africa_Lambert_Conformal_Conic': 102024,
       'Asia_North_Albers_Equal_Area_Conic': 102025,
       'Asia_North_Equidistant_Conic': 102026,
       'Asia_North_Lambert_Conformal_Conic': 102027,
       'Asia_South_Albers_Equal_Area_Conic': 102028,
       'Asia_South_Equidistant_Conic': 102029,
       'Asia_South_Lambert_Conformal_Conic': 102030,
       'Europe_Equidistant_Conic': 102031,
       'South_America_Equidistant_Conic': 102032,
       'South_America_Albers_Equal_Area_Conic': 102033,
       'North_Pole_Gnomonic': 102034,
       'North_Pole_Orthographic': 102035,
       'South_Pole_Gnomonic': 102036,
       'South_Pole_Orthographic': 102037,
       'The_World_From_Space': 102038,
       'USA_Contiguous_Albers_Equal_Area_Conic_USGS_version': 102039,
       'D48_Slovenia_TM': 102060,
       'Everest_Modified_1969_RSO_Malaya_Meters': 102061,
       'Kertau_RSO_Malaya_Meters': 102062,
       'Kandawala_Ceylon_Belt_Meters': 102063,
       'Kandawala_Ceylon_Belt_Indian_Yards_1937': 102064,
       'S-JTSK_Krovak': 102065,
       'S-JTSK_Ferro_Krovak_East_North': 102066,
       'S-JTSK_Krovak_East_North': 102067,
       'EMEP_50_Kilometer_Grid': 102068,
       'EMEP_150_Kilometer_Grid': 102069,
       'Guernsey_Grid': 102070,
       'AGD_1966_ACT_Grid_AGC_Zone': 102071,
       'AGD_1966_ISG_54_2': 102072,
       'AGD_1966_ISG_54_3': 102073,
       'AGD_1966_ISG_55_1': 102074,
       'AGD_1966_ISG_55_2': 102075,
       'AGD_1966_ISG_55_3': 102076,
       'AGD_1966_ISG_56_1': 102077,
       'AGD_1966_ISG_56_2': 102078,
       'AGD_1966_ISG_56_3': 102079,
       'Bermuda_2000_National_Grid': 102090,
       'Monte_Mario_Italy_1': 102091,
       'Monte_Mario_Italy_2': 102092,
       'Roma_1940_Gauss_Boaga_Est': 102093,
       'Roma_1940_Gauss_Boaga_Ovest': 102094,
       'JAD_2001_Jamaica_Grid': 102095,
       'Bab_South_Palau_Azimuthal_Equidistant': 102096,
       'ETRS_1989_UTM_Zone_26N': 102097,
       'ETRS_1989_UTM_Zone_27N': 102098,
       'ETRS_1989_UTM_Zone_39N': 102099,
       'WGS_1984_Web_Mercator_Auxiliary_Sphere': 102100,
       'NGO_1948_Norway_Zone_1': 102101,
       'NGO_1948_Norway_Zone_2': 102102,
       'NGO_1948_Norway_Zone_3': 102103,
       'NGO_1948_Norway_Zone_4': 102104,
       'NGO_1948_Norway_Zone_5': 102105,
       'NGO_1948_Norway_Zone_6': 102106,
       'NGO_1948_Norway_Zone_7': 102107,
       'NGO_1948_Norway_Zone_8': 102108,
       'ETRS_1989_Slovenia_TM': 102109,
       'RGF_1993_Lambert_93': 102110,
       'Chatham_Islands_1979_Map_Grid': 102111,
       'NZGD_2000_Chatham_Island_Circuit': 102112,
       'WGS_1984_Web_Mercator': 102113,
       'Old_Hawaiian_UTM_Zone_4N': 102114,
       'Old_Hawaiian_UTM_Zone_5N': 102115,
       'American_Samoa_1962_UTM_Zone_2S': 102116,
       'NAD_1927_Alaska_Albers_Meters': 102117,
       'NAD_1927_Georgia_Statewide_Albers': 102118,
       'NAD_1927_Texas_Statewide_Mapping_System': 102119,
       'NAD_1927_Michigan_GeoRef_Feet_US': 102120,
       'NAD_1983_Michigan_GeoRef_Feet_US': 102121,
       'NAD_1927_Michigan_GeoRef_Meters': 102122,
       'NAD_1983_Michigan_GeoRef_Meters': 102123,
       'NAD_1927_UTM_Zone_1N': 102124,
       'NAD_1927_UTM_Zone_2N': 102125,
       'NAD_1927_UTM_Zone_59N': 102126,
       'NAD_1927_UTM_Zone_60N': 102127,
       'NAD_1983_UTM_Zone_1N': 102128,
       'NAD_1983_UTM_Zone_2N': 102129,
       'NAD_1983_UTM_Zone_59N': 102130,
       'NAD_1983_UTM_Zone_60N': 102131,
       'NGO_1948_UTM_Zone_32N': 102132,
       'NGO_1948_UTM_Zone_33N': 102133,
       'NGO_1948_UTM_Zone_34N': 102134,
       'NGO_1948_UTM_Zone_35N': 102135,
       'NGO_1948_Baerum_Kommune': 102136,
       'NGO_1948_Bergenhalvoen': 102137,
       'NGO_1948_Oslo_Kommune': 102138,
       'EUREF_FIN_TM35FIN': 102139,
       'Hong_Kong_1980_Grid': 102140,
       'Hong_Kong_1980_UTM_Zone_49N': 102141,
       'Hong_Kong_1980_UTM_Zone_50N': 102142,
       'QND_1995_UTM_39N': 102143,
       'Merchich_Degree_UTM_Zone_28N': 102144,
       'JGD_2000_UTM_Zone_51N': 102145,
       'JGD_2000_UTM_Zone_52N': 102146,
       'JGD_2000_UTM_Zone_53N': 102147,
       'JGD_2000_UTM_Zone_54N': 102148,
       'JGD_2000_UTM_Zone_55N': 102149,
       'JGD_2000_UTM_Zone_56N': 102150,
       'Tokyo_UTM_Zone_51N': 102151,
       'Tokyo_UTM_Zone_52N': 102152,
       'Tokyo_UTM_Zone_53N': 102153,
       'Tokyo_UTM_Zone_54N': 102154,
       'Tokyo_UTM_Zone_55N': 102155,
       'Tokyo_UTM_Zone_56N': 102156,
       'ETRS_1989_Kosovo_Grid': 102157,
       'Jordan_JTM': 102158,
       'Observatorio_Meteorologico_1965_Macau_Grid': 102159,
       'Datum_73_Hayford_Gauss_IGeoE': 102160,
       'Datum_73_Hayford_Gauss_IPCC': 102161,
       'Graciosa_Base_SW_1948_UTM_Zone_26N': 102162,
       'Lisboa_Bessel_Bonne': 102163,
       'Lisboa_Hayford_Gauss_IGeoE': 102164,
       'Lisboa_Hayford_Gauss_IPCC': 102165,
       'Observ_Meteorologico_1939_UTM_Zone_25N': 102166,
       'Porto_Santo_1936_UTM_Zone_28N': 102167,
       'Sao_Braz_UTM_Zone_26N': 102168,
       'Selvagem_Grande_1938_UTM_Zone_28N': 102169,
       'AGD_1966_VICGRID': 102170,
       'GDA_1994_VICGRID94': 102171,
       'GDA_1994_South_Australia_Lambert': 102172,
       'ETRS_1989_UWPP_1992': 102173,
       'ETRS_1989_UWPP_2000_PAS_5': 102174,
       'ETRS_1989_UWPP_2000_PAS_6': 102175,
       'ETRS_1989_UWPP_2000_PAS_7': 102176,
       'ETRS_1989_UWPP_2000_PAS_8': 102177,
       'NAD_1927_10TM_AEP_Forest': 102178,
       'NAD_1927_10TM_AEP_Resource': 102179,
       'NAD_1927_3TM_111': 102180,
       'NAD_1927_3TM_114': 102181,
       'NAD_1927_3TM_117': 102182,
       'NAD_1927_3TM_120': 102183,
       'NAD_1983_10TM_AEP_Forest': 102184,
       'NAD_1983_10TM_AEP_Resource': 102185,
       'NAD_1983_3TM_111': 102186,
       'NAD_1983_3TM_114': 102187,
       'NAD_1983_3TM_117': 102188,
       'NAD_1983_3TM_120': 102189,
       'NAD_1983_BC_Environment_Albers': 102190,
       'Nord_Maroc_Degree': 102191,
       'Sud_Maroc_Degree': 102192,
       'Sahara_Degree': 102193,
       'UWPP_1992': 102194,
       'UWPP_2000_PAS_5': 102195,
       'UWPP_2000_PAS_6': 102196,
       'UWPP_2000_PAS_7': 102197,
       'UWPP_2000_PAS_8': 102198,
       'Belge_Lambert_2008': 102199,
       'NAD_1983_HARN_UTM_Zone_2S': 102200,
       'NAD_1983_HARN_Guam_Map_Grid': 102201,
       'NAD_1983_HARN_UTM_Zone_4N': 102202,
       'NAD_1983_HARN_UTM_Zone_5N': 102203,
       'NAD_1983_HARN_UTM_Zone_11N': 102205,
       'NAD_1983_HARN_UTM_Zone_12N': 102206,
       'NAD_1983_HARN_UTM_Zone_13N': 102207,
       'NAD_1983_HARN_Maine_2000_East_Zone': 102208,
       'NAD_1983_HARN_Maine_2000_Central_Zone': 102209,
       'NAD_1983_HARN_Maine_2000_West_Zone': 102210,
       'NAD_1983_HARN_UTM_Zone_18N': 102211,
       'NAD_1983_USFS_R6_Albers': 102218,
       'NAD_1983_Wisconsin_TM_US_Ft': 102219,
       'NAD_1983_HARN_Wisconsin_TM_US_Ft': 102220,
       'Ocotepeque_1935_Costa_Rica_Lambert_Norte': 102221,
       'Ocotepeque_1935_Costa_Rica_Lambert_Sur': 102222,
       'WGS_1984_Costa_Rica_TM_90': 102223,
       'MONREF_1997_UTM_Zone_46N': 102224,
       'MONREF_1997_UTM_Zone_47N': 102225,
       'MONREF_1997_UTM_Zone_48N': 102226,
       'MONREF_1997_UTM_Zone_49N': 102227,
       'MONREF_1997_UTM_Zone_50N': 102228,
       'NAD_1983_HARN_StatePlane_Alabama_East_FIPS_0101': 102229,
       'NAD_1983_HARN_StatePlane_Alabama_West_FIPS_0102': 102230,
       'Colombia_West_West_Zone': 102231,
       'Bogota_Ciudad_Bogota': 102232,
       'MAGNA_Ciudad_Bogota': 102233,
       'NAD_1983_CSRS_UTM_Zone_14N': 102234,
       'NAD_1983_CSRS_UTM_Zone_15N': 102235,
       'NAD_1983_CSRS_UTM_Zone_16N': 102236,
       'Pohnpei_Az_Eq_1971': 102237,
       'Saipan_Az_Eq_1969': 102238,
       'Guam_Geodetic_Triangulation_Network_1963': 102239,
       'Guam_Geodetic_Network_1993': 102240,
       'NAD_1983_HARN_StatePlane_California_I_FIPS_0401': 102241,
       'NAD_1983_HARN_StatePlane_California_II_FIPS_0402': 102242,
       'NAD_1983_HARN_StatePlane_California_III_FIPS_0403': 102243,
       'NAD_1983_HARN_StatePlane_California_IV_FIPS_0404': 102244,
       'NAD_1983_HARN_StatePlane_California_V_FIPS_0405': 102245,
       'NAD_1983_HARN_StatePlane_California_VI_FIPS_0406': 102246,
       'NAD_1983_HARN_StatePlane_Arizona_East_FIPS_0201': 102248,
       'NAD_1983_HARN_StatePlane_Arizona_Central_FIPS_0202': 102249,
       'NAD_1983_HARN_StatePlane_Arizona_West_FIPS_0203': 102250,
       'NAD_1983_HARN_StatePlane_Arkansas_North_FIPS_0301': 102251,
       'NAD_1983_HARN_StatePlane_Arkansas_South_FIPS_0302': 102252,
       'NAD_1983_HARN_StatePlane_Colorado_North_FIPS_0501': 102253,
       'NAD_1983_HARN_StatePlane_Colorado_Central_FIPS_0502': 102254,
       'NAD_1983_HARN_StatePlane_Colorado_South_FIPS_0503': 102255,
       'NAD_1983_HARN_StatePlane_Connecticut_FIPS_0600': 102256,
       'NAD_1983_HARN_StatePlane_Delaware_FIPS_0700': 102257,
       'NAD_1983_HARN_StatePlane_Florida_East_FIPS_0901': 102258,
       'NAD_1983_HARN_StatePlane_Florida_West_FIPS_0902': 102259,
       'NAD_1983_HARN_StatePlane_Florida_North_FIPS_0903': 102260,
       'NAD_1983_HARN_StatePlane_Hawaii_1_FIPS_5101': 102261,
       'NAD_1983_HARN_StatePlane_Hawaii_2_FIPS_5102': 102262,
       'NAD_1983_HARN_StatePlane_Hawaii_3_FIPS_5103': 102263,
       'NAD_1983_HARN_StatePlane_Hawaii_4_FIPS_5104': 102264,
       'NAD_1983_HARN_StatePlane_Hawaii_5_FIPS_5105': 102265,
       'NAD_1983_HARN_StatePlane_Georgia_East_FIPS_1001': 102266,
       'NAD_1983_HARN_StatePlane_Georgia_West_FIPS_1002': 102267,
       'NAD_1983_HARN_StatePlane_Idaho_East_FIPS_1101': 102268,
       'NAD_1983_HARN_StatePlane_Idaho_Central_FIPS_1102': 102269,
       'NAD_1983_HARN_StatePlane_Idaho_West_FIPS_1103': 102270,
       'NAD_1983_HARN_StatePlane_Illinois_East_FIPS_1201': 102271,
       'NAD_1983_HARN_StatePlane_Illinois_West_FIPS_1202': 102272,
       'NAD_1983_HARN_StatePlane_Indiana_East_FIPS_1301': 102273,
       'NAD_1983_HARN_StatePlane_Indiana_West_FIPS_1302': 102274,
       'NAD_1983_HARN_StatePlane_Iowa_North_FIPS_1401': 102275,
       'NAD_1983_HARN_StatePlane_Iowa_South_FIPS_1402': 102276,
       'NAD_1983_HARN_StatePlane_Kansas_North_FIPS_1501': 102277,
       'NAD_1983_HARN_StatePlane_Kansas_South_FIPS_1502': 102278,
       'NAD_1983_HARN_StatePlane_Kentucky_North_FIPS_1601': 102279,
       'NAD_1983_HARN_StatePlane_Kentucky_South_FIPS_1602': 102280,
       'NAD_1983_HARN_StatePlane_Louisiana_North_FIPS_1701': 102281,
       'NAD_1983_HARN_StatePlane_Louisiana_South_FIPS_1702': 102282,
       'NAD_1983_HARN_StatePlane_Maine_East_FIPS_1801': 102283,
       'NAD_1983_HARN_StatePlane_Maine_West_FIPS_1802': 102284,
       'NAD_1983_HARN_StatePlane_Maryland_FIPS_1900': 102285,
       'NAD_1983_HARN_StatePlane_Massachusetts_Mainland_FIPS_2001': 102286,
       'NAD_1983_HARN_StatePlane_Massachusetts_Island_FIPS_2002': 102287,
       'NAD_1983_HARN_StatePlane_Michigan_North_FIPS_2111': 102288,
       'NAD_1983_HARN_StatePlane_Michigan_Central_FIPS_2112': 102289,
       'NAD_1983_HARN_StatePlane_Michigan_South_FIPS_2113': 102290,
       'NAD_1983_HARN_StatePlane_Minnesota_North_FIPS_2201': 102291,
       'NAD_1983_HARN_StatePlane_Minnesota_Central_FIPS_2202': 102292,
       'NAD_1983_HARN_StatePlane_Minnesota_South_FIPS_2203': 102293,
       'NAD_1983_HARN_StatePlane_Mississippi_East_FIPS_2301': 102294,
       'NAD_1983_HARN_StatePlane_Mississippi_West_FIPS_2302': 102295,
       'NAD_1983_HARN_StatePlane_Missouri_East_FIPS_2401': 102296,
       'NAD_1983_HARN_StatePlane_Missouri_Central_FIPS_2402': 102297,
       'NAD_1983_HARN_StatePlane_Missouri_West_FIPS_2403': 102298,
       'NAD_1983_HARN_StatePlane_Montana_FIPS_2500': 102300,
       'NAD_1983_HARN_StatePlane_Nebraska_FIPS_2600': 102304,
       'NAD_1983_HARN_StatePlane_Nevada_East_FIPS_2701': 102307,
       'NAD_1983_HARN_StatePlane_Nevada_Central_FIPS_2702': 102308,
       'NAD_1983_HARN_StatePlane_Nevada_West_FIPS_2703': 102309,
       'NAD_1983_HARN_StatePlane_New_Hampshire_FIPS_2800': 102310,
       'NAD_1983_HARN_StatePlane_New_Jersey_FIPS_2900': 102311,
       'NAD_1983_HARN_StatePlane_New_Mexico_East_FIPS_3001': 102312,
       'NAD_1983_HARN_StatePlane_New_Mexico_Central_FIPS_3002': 102313,
       'NAD_1983_HARN_StatePlane_New_Mexico_West_FIPS_3003': 102314,
       'NAD_1983_HARN_StatePlane_New_York_East_FIPS_3101': 102315,
       'NAD_1983_HARN_StatePlane_New_York_Central_FIPS_3102': 102316,
       'NAD_1983_HARN_StatePlane_New_York_West_FIPS_3103': 102317,
       'NAD_1983_HARN_StatePlane_New_York_Long_Island_FIPS_3104': 102318,
       'NAD_1983_HARN_StatePlane_North_Dakota_North_FIPS_3301': 102320,
       'NAD_1983_HARN_StatePlane_North_Dakota_South_FIPS_3302': 102321,
       'NAD_1983_HARN_StatePlane_Ohio_North_FIPS_3401': 102322,
       'NAD_1983_HARN_StatePlane_Ohio_South_FIPS_3402': 102323,
       'NAD_1983_HARN_StatePlane_Oklahoma_North_FIPS_3501': 102324,
       'NAD_1983_HARN_StatePlane_Oklahoma_South_FIPS_3502': 102325,
       'NAD_1983_HARN_StatePlane_Oregon_North_FIPS_3601': 102326,
       'NAD_1983_HARN_StatePlane_Oregon_South_FIPS_3602': 102327,
       'NAD_1983_HARN_StatePlane_Rhode_Island_FIPS_3800': 102330,
       'NAD_1983_HARN_StatePlane_South_Dakota_North_FIPS_4001': 102334,
       'NAD_1983_HARN_StatePlane_South_Dakota_South_FIPS_4002': 102335,
       'NAD_1983_HARN_StatePlane_Tennessee_FIPS_4100': 102336,
       'NAD_1983_HARN_StatePlane_Texas_North_FIPS_4201': 102337,
       'NAD_1983_HARN_StatePlane_Texas_North_Central_FIPS_4202': 102338,
       'NAD_1983_HARN_StatePlane_Texas_Central_FIPS_4203': 102339,
       'NAD_1983_HARN_StatePlane_Texas_South_Central_FIPS_4204': 102340,
       'NAD_1983_HARN_StatePlane_Texas_South_FIPS_4205': 102341,
       'NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301': 102342,
       'NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302': 102343,
       'NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303': 102344,
       'NAD_1983_HARN_StatePlane_Vermont_FIPS_4400': 102345,
       'NAD_1983_HARN_StatePlane_Virginia_North_FIPS_4501': 102346,
       'NAD_1983_HARN_StatePlane_Virginia_South_FIPS_4502': 102347,
       'NAD_1983_HARN_StatePlane_Washington_North_FIPS_4601': 102348,
       'NAD_1983_HARN_StatePlane_Washington_South_FIPS_4602': 102349,
       'NAD_1983_HARN_StatePlane_West_Virginia_North_FIPS_4701': 102350,
       'NAD_1983_HARN_StatePlane_West_Virginia_South_FIPS_4702': 102351,
       'NAD_1983_HARN_StatePlane_Wisconsin_North_FIPS_4801': 102352,
       'NAD_1983_HARN_StatePlane_Wisconsin_Central_FIPS_4802': 102353,
       'NAD_1983_HARN_StatePlane_Wisconsin_South_FIPS_4803': 102354,
       'NAD_1983_HARN_StatePlane_Wyoming_East_FIPS_4901': 102355,
       'NAD_1983_HARN_StatePlane_Wyoming_East_Central_FIPS_4902': 102356,
       'NAD_1983_HARN_StatePlane_Wyoming_West_Central_FIPS_4903': 102357,
       'NAD_1983_HARN_StatePlane_Wyoming_West_FIPS_4904': 102358,
       'NAD_1983_HARN_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200': 102361,
       'NAD_1983_HARN_StatePlane_Kentucky_FIPS_1600': 102363,
       'WGS_1984_ARC_System_Zone_01': 102421,
       'WGS_1984_ARC_System_Zone_02': 102422,
       'WGS_1984_ARC_System_Zone_03': 102423,
       'WGS_1984_ARC_System_Zone_04': 102424,
       'WGS_1984_ARC_System_Zone_05': 102425,
       'WGS_1984_ARC_System_Zone_06': 102426,
       'WGS_1984_ARC_System_Zone_07': 102427,
       'WGS_1984_ARC_System_Zone_08': 102428,
       'WGS_1984_ARC_System_Zone_09': 102429,
       'WGS_1984_ARC_System_Zone_10': 102430,
       'WGS_1984_ARC_System_Zone_11': 102431,
       'WGS_1984_ARC_System_Zone_12': 102432,
       'WGS_1984_ARC_System_Zone_13': 102433,
       'WGS_1984_ARC_System_Zone_14': 102434,
       'WGS_1984_ARC_System_Zone_15': 102435,
       'WGS_1984_ARC_System_Zone_16': 102436,
       'WGS_1984_ARC_System_Zone_17': 102437,
       'WGS_1984_ARC_System_Zone_18': 102438,
       'LKS_1992_Latvia_TM_0': 102440,
       'TWD_1967_TM_Taiwan': 102441,
       'TWD_1967_TM_Penghu': 102442,
       'TWD_1997_TM_Taiwan': 102443,
       'TWD_1997_TM_Penghu': 102444,
       'NAD_1983_HARN_StatePlane_Hawaii_1_FIPS_5101_Feet': 102461,
       'NAD_1983_HARN_StatePlane_Hawaii_2_FIPS_5102_Feet': 102462,
       'NAD_1983_HARN_StatePlane_Hawaii_3_FIPS_5103_Feet': 102463,
       'NAD_1983_HARN_StatePlane_Hawaii_4_FIPS_5104_Feet': 102464,
       'NAD_1983_HARN_StatePlane_Hawaii_5_FIPS_5105_Feet': 102465,
       'NAD_1983_HARN_StatePlane_Minnesota_North_FIPS_2201_Feet': 102466,
       'NAD_1983_HARN_StatePlane_Minnesota_Central_FIPS_2202_Feet': 102467,
       'NAD_1983_HARN_StatePlane_Minnesota_South_FIPS_2203_Feet': 102468,
       'NAD_1983_HARN_Mississippi_TM': 102469,
       'Nord_Algerie_Ancienne_Degree': 102491,
       'Sud_Algerie_Ancienne_Degree': 102492,
       'WGS_1984_Complex_UTM_Zone_20N': 102570,
       'WGS_1984_Complex_UTM_Zone_21N': 102571,
       'WGS_1984_Complex_UTM_Zone_22N': 102572,
       'WGS_1984_Complex_UTM_Zone_23N': 102573,
       'WGS_1984_Complex_UTM_Zone_24N': 102574,
       'WGS_1984_Complex_UTM_Zone_25N': 102575,
       'WGS_1984_Complex_UTM_Zone_26N': 102576,
       'WGS_1984_Complex_UTM_Zone_27N': 102577,
       'WGS_1984_Complex_UTM_Zone_28N': 102578,
       'WGS_1984_Complex_UTM_Zone_29N': 102579,
       'WGS_1984_Complex_UTM_Zone_30N': 102580,
       'NTF_France_I_degrees': 102581,
       'NTF_France_II_degrees': 102582,
       'NTF_France_III_degrees': 102583,
       'NTF_France_IV_degrees': 102584,
       'Nord_Algerie_Degree': 102591,
       'Sud_Algerie_Degree': 102592,
       'NAD_1983_Texas_Centric_Mapping_System_Albers': 102601,
       'NAD_1983_Texas_Centric_Mapping_System_Lambert': 102602,
       'NAD_1983_Texas_Statewide_Mapping_System': 102603,
       'NAD_1983_Georgia_Statewide_Lambert': 102604,
       'NAD_1983_Idaho_TM': 102605,
       'NAD_1983_Maine_2000_East_Zone': 102606,
       'NAD_1983_Maine_2000_Central_Zone': 102607,
       'NAD_1983_Maine_2000_West_Zone': 102608,
       'NAD_1983_Mississippi_TM': 102609,
       'NAD_1983_StatePlane_Alabama_East_FIPS_0101_Feet': 102629,
       'NAD_1983_StatePlane_Alabama_West_FIPS_0102_Feet': 102630,
       'NAD_1983_StatePlane_Alaska_1_FIPS_5001_Feet': 102631,
       'NAD_1983_StatePlane_Alaska_2_FIPS_5002_Feet': 102632,
       'NAD_1983_StatePlane_Alaska_3_FIPS_5003_Feet': 102633,
       'NAD_1983_StatePlane_Alaska_4_FIPS_5004_Feet': 102634,
       'NAD_1983_StatePlane_Alaska_5_FIPS_5005_Feet': 102635,
       'NAD_1983_StatePlane_Alaska_6_FIPS_5006_Feet': 102636,
       'NAD_1983_StatePlane_Alaska_7_FIPS_5007_Feet': 102637,
       'NAD_1983_StatePlane_Alaska_8_FIPS_5008_Feet': 102638,
       'NAD_1983_StatePlane_Alaska_9_FIPS_5009_Feet': 102639,
       'NAD_1983_StatePlane_Alaska_10_FIPS_5010_Feet': 102640,
       'NAD_1983_StatePlane_California_I_FIPS_0401_Feet': 102641,
       'NAD_1983_StatePlane_California_II_FIPS_0402_Feet': 102642,
       'NAD_1983_StatePlane_California_III_FIPS_0403_Feet': 102643,
       'NAD_1983_StatePlane_California_IV_FIPS_0404_Feet': 102644,
       'NAD_1983_StatePlane_California_V_FIPS_0405_Feet': 102645,
       'NAD_1983_StatePlane_California_VI_FIPS_0406_Feet': 102646,
       'NAD_1983_StatePlane_Arizona_East_FIPS_0201_Feet': 102648,
       'NAD_1983_StatePlane_Arizona_Central_FIPS_0202_Feet': 102649,
       'NAD_1983_StatePlane_Arizona_West_FIPS_0203_Feet': 102650,
       'NAD_1983_StatePlane_Arkansas_North_FIPS_0301_Feet': 102651,
       'NAD_1983_StatePlane_Arkansas_South_FIPS_0302_Feet': 102652,
       'NAD_1983_StatePlane_Colorado_North_FIPS_0501_Feet': 102653,
       'NAD_1983_StatePlane_Colorado_Central_FIPS_0502_Feet': 102654,
       'NAD_1983_StatePlane_Colorado_South_FIPS_0503_Feet': 102655,
       'NAD_1983_StatePlane_Connecticut_FIPS_0600_Feet': 102656,
       'NAD_1983_StatePlane_Delaware_FIPS_0700_Feet': 102657,
       'NAD_1983_StatePlane_Florida_East_FIPS_0901_Feet': 102658,
       'NAD_1983_StatePlane_Florida_West_FIPS_0902_Feet': 102659,
       'NAD_1983_StatePlane_Florida_North_FIPS_0903_Feet': 102660,
       'NAD_1983_StatePlane_Hawaii_1_FIPS_5101_Feet': 102661,
       'NAD_1983_StatePlane_Hawaii_2_FIPS_5102_Feet': 102662,
       'NAD_1983_StatePlane_Hawaii_3_FIPS_5103_Feet': 102663,
       'NAD_1983_StatePlane_Hawaii_4_FIPS_5104_Feet': 102664,
       'NAD_1983_StatePlane_Hawaii_5_FIPS_5105_Feet': 102665,
       'NAD_1983_StatePlane_Georgia_East_FIPS_1001_Feet': 102666,
       'NAD_1983_StatePlane_Georgia_West_FIPS_1002_Feet': 102667,
       'NAD_1983_StatePlane_Idaho_East_FIPS_1101_Feet': 102668,
       'NAD_1983_StatePlane_Idaho_Central_FIPS_1102_Feet': 102669,
       'NAD_1983_StatePlane_Idaho_West_FIPS_1103_Feet': 102670,
       'NAD_1983_StatePlane_Illinois_East_FIPS_1201_Feet': 102671,
       'NAD_1983_StatePlane_Illinois_West_FIPS_1202_Feet': 102672,
       'NAD_1983_StatePlane_Indiana_East_FIPS_1301_Feet': 102673,
       'NAD_1983_StatePlane_Indiana_West_FIPS_1302_Feet': 102674,
       'NAD_1983_StatePlane_Iowa_North_FIPS_1401_Feet': 102675,
       'NAD_1983_StatePlane_Iowa_South_FIPS_1402_Feet': 102676,
       'NAD_1983_StatePlane_Kansas_North_FIPS_1501_Feet': 102677,
       'NAD_1983_StatePlane_Kansas_South_FIPS_1502_Feet': 102678,
       'NAD_1983_StatePlane_Kentucky_North_FIPS_1601_Feet': 102679,
       'NAD_1983_StatePlane_Kentucky_South_FIPS_1602_Feet': 102680,
       'NAD_1983_StatePlane_Louisiana_North_FIPS_1701_Feet': 102681,
       'NAD_1983_StatePlane_Louisiana_South_FIPS_1702_Feet': 102682,
       'NAD_1983_StatePlane_Maine_East_FIPS_1801_Feet': 102683,
       'NAD_1983_StatePlane_Maine_West_FIPS_1802_Feet': 102684,
       'NAD_1983_StatePlane_Maryland_FIPS_1900_Feet': 102685,
       'NAD_1983_StatePlane_Massachusetts_Mainland_FIPS_2001_Feet': 102686,
       'NAD_1983_StatePlane_Massachusetts_Island_FIPS_2002_Feet': 102687,
       'NAD_1983_StatePlane_Michigan_North_FIPS_2111_Feet': 102688,
       'NAD_1983_StatePlane_Michigan_Central_FIPS_2112_Feet': 102689,
       'NAD_1983_StatePlane_Michigan_South_FIPS_2113_Feet': 102690,
       'NAD_1983_StatePlane_Minnesota_North_FIPS_2201_Feet': 102691,
       'NAD_1983_StatePlane_Minnesota_Central_FIPS_2202_Feet': 102692,
       'NAD_1983_StatePlane_Minnesota_South_FIPS_2203_Feet': 102693,
       'NAD_1983_StatePlane_Mississippi_East_FIPS_2301_Feet': 102694,
       'NAD_1983_StatePlane_Mississippi_West_FIPS_2302_Feet': 102695,
       'NAD_1983_StatePlane_Missouri_East_FIPS_2401_Feet': 102696,
       'NAD_1983_StatePlane_Missouri_Central_FIPS_2402_Feet': 102697,
       'NAD_1983_StatePlane_Missouri_West_FIPS_2403_Feet': 102698,
       'NAD_1983_StatePlane_Montana_FIPS_2500_Feet': 102700,
       'NAD_1983_StatePlane_Nebraska_FIPS_2600_Feet': 102704,
       'NAD_1983_StatePlane_Nevada_East_FIPS_2701_Feet': 102707,
       'NAD_1983_StatePlane_Nevada_Central_FIPS_2702_Feet': 102708,
       'NAD_1983_StatePlane_Nevada_West_FIPS_2703_Feet': 102709,
       'NAD_1983_StatePlane_New_Hampshire_FIPS_2800_Feet': 102710,
       'NAD_1983_StatePlane_New_Jersey_FIPS_2900_Feet': 102711,
       'NAD_1983_StatePlane_New_Mexico_East_FIPS_3001_Feet': 102712,
       'NAD_1983_StatePlane_New_Mexico_Central_FIPS_3002_Feet': 102713,
       'NAD_1983_StatePlane_New_Mexico_West_FIPS_3003_Feet': 102714,
       'NAD_1983_StatePlane_New_York_East_FIPS_3101_Feet': 102715,
       'NAD_1983_StatePlane_New_York_Central_FIPS_3102_Feet': 102716,
       'NAD_1983_StatePlane_New_York_West_FIPS_3103_Feet': 102717,
       'NAD_1983_StatePlane_New_York_Long_Island_FIPS_3104_Feet': 102718,
       'NAD_1983_StatePlane_North_Carolina_FIPS_3200_Feet': 102719,
       'NAD_1983_StatePlane_North_Dakota_North_FIPS_3301_Feet': 102720,
       'NAD_1983_StatePlane_North_Dakota_South_FIPS_3302_Feet': 102721,
       'NAD_1983_StatePlane_Ohio_North_FIPS_3401_Feet': 102722,
       'NAD_1983_StatePlane_Ohio_South_FIPS_3402_Feet': 102723,
       'NAD_1983_StatePlane_Oklahoma_North_FIPS_3501_Feet': 102724,
       'NAD_1983_StatePlane_Oklahoma_South_FIPS_3502_Feet': 102725,
       'NAD_1983_StatePlane_Oregon_North_FIPS_3601_Feet': 102726,
       'NAD_1983_StatePlane_Oregon_South_FIPS_3602_Feet': 102727,
       'NAD_1983_StatePlane_Pennsylvania_North_FIPS_3701_Feet': 102728,
       'NAD_1983_StatePlane_Pennsylvania_South_FIPS_3702_Feet': 102729,
       'NAD_1983_StatePlane_Rhode_Island_FIPS_3800_Feet': 102730,
       'NAD_1983_StatePlane_South_Carolina_FIPS_3900_Feet': 102733,
       'NAD_1983_StatePlane_South_Dakota_North_FIPS_4001_Feet': 102734,
       'NAD_1983_StatePlane_South_Dakota_South_FIPS_4002_Feet': 102735,
       'NAD_1983_StatePlane_Tennessee_FIPS_4100_Feet': 102736,
       'NAD_1983_StatePlane_Texas_North_FIPS_4201_Feet': 102737,
       'NAD_1983_StatePlane_Texas_North_Central_FIPS_4202_Feet': 102738,
       'NAD_1983_StatePlane_Texas_Central_FIPS_4203_Feet': 102739,
       'NAD_1983_StatePlane_Texas_South_Central_FIPS_4204_Feet': 102740,
       'NAD_1983_StatePlane_Texas_South_FIPS_4205_Feet': 102741,
       'NAD_1983_StatePlane_Utah_North_FIPS_4301_Feet': 102742,
       'NAD_1983_StatePlane_Utah_Central_FIPS_4302_Feet': 102743,
       'NAD_1983_StatePlane_Utah_South_FIPS_4303_Feet': 102744,
       'NAD_1983_StatePlane_Vermont_FIPS_4400_Feet': 102745,
       'NAD_1983_StatePlane_Virginia_North_FIPS_4501_Feet': 102746,
       'NAD_1983_StatePlane_Virginia_South_FIPS_4502_Feet': 102747,
       'NAD_1983_StatePlane_Washington_North_FIPS_4601_Feet': 102748,
       'NAD_1983_StatePlane_Washington_South_FIPS_4602_Feet': 102749,
       'NAD_1983_StatePlane_West_Virginia_North_FIPS_4701_Feet': 102750,
       'NAD_1983_StatePlane_West_Virginia_South_FIPS_4702_Feet': 102751,
       'NAD_1983_StatePlane_Wisconsin_North_FIPS_4801_Feet': 102752,
       'NAD_1983_StatePlane_Wisconsin_Central_FIPS_4802_Feet': 102753,
       'NAD_1983_StatePlane_Wisconsin_South_FIPS_4803_Feet': 102754,
       'NAD_1983_StatePlane_Wyoming_East_FIPS_4901_Feet': 102755,
       'NAD_1983_StatePlane_Wyoming_East_Central_FIPS_4902_Feet': 102756,
       'NAD_1983_StatePlane_Wyoming_West_Central_FIPS_4903_Feet': 102757,
       'NAD_1983_StatePlane_Wyoming_West_FIPS_4904_Feet': 102758,
       'NAD_1983_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200_Feet': 102761,
       'NAD_1983_StatePlane_Kentucky_FIPS_1600_Feet': 102763,
       'NAD_1983_StatePlane_Guam_FIPS_5400_Feet': 102766,
       'NAD_1983_HARN_WISCRS_Adams_County_Meters': 103300,
       'NAD_1983_HARN_WISCRS_Ashland_County_Meters': 103301,
       'NAD_1983_HARN_WISCRS_Barron_County_Meters': 103302,
       'NAD_1983_HARN_WISCRS_Bayfield_County_Meters': 103303,
       'NAD_1983_HARN_WISCRS_Brown_County_Meters': 103304,
       'NAD_1983_HARN_WISCRS_Buffalo_County_Meters': 103305,
       'NAD_1983_HARN_WISCRS_Burnett_County_Meters': 103306,
       'NAD_1983_HARN_WISCRS_Calumet_County_Meters': 103307,
       'NAD_1983_HARN_WISCRS_Chippewa_County_Meters': 103308,
       'NAD_1983_HARN_WISCRS_Clark_County_Meters': 103309,
       'NAD_1983_HARN_WISCRS_Columbia_County_Meters': 103310,
       'NAD_1983_HARN_WISCRS_Crawford_County_Meters': 103311,
       'NAD_1983_HARN_WISCRS_Dane_County_Meters': 103312,
       'NAD_1983_HARN_WISCRS_Dodge_County_Meters': 103313,
       'NAD_1983_HARN_WISCRS_Door_County_Meters': 103314,
       'NAD_1983_HARN_WISCRS_Douglas_County_Meters': 103315,
       'NAD_1983_HARN_WISCRS_Dunn_County_Meters': 103316,
       'NAD_1983_HARN_WISCRS_EauClaire_County_Meters': 103317,
       'NAD_1983_HARN_WISCRS_Florence_County_Meters': 103318,
       'NAD_1983_HARN_WISCRS_Fond_du_Lac_County_Meters': 103319,
       'NAD_1983_HARN_WISCRS_Forest_County_Meters': 103320,
       'NAD_1983_HARN_WISCRS_Grant_County_Meters': 103321,
       'NAD_1983_HARN_WISCRS_Green_County_Meters': 103322,
       'NAD_1983_HARN_WISCRS_GreenLake_County_Meters': 103323,
       'NAD_1983_HARN_WISCRS_Iowa_County_Meters': 103324,
       'NAD_1983_HARN_WISCRS_Iron_County_Meters': 103325,
       'NAD_1983_HARN_WISCRS_Jackson_County_Meters': 103326,
       'NAD_1983_HARN_WISCRS_Jefferson_County_Meters': 103327,
       'NAD_1983_HARN_WISCRS_Juneau_County_Meters': 103328,
       'NAD_1983_HARN_WISCRS_Kenosha_County_Meters': 103329,
       'NAD_1983_HARN_WISCRS_Kewaunee_County_Meters': 103330,
       'NAD_1983_HARN_WISCRS_LaCrosse_County_Meters': 103331,
       'NAD_1983_HARN_WISCRS_Lafayette_County_Meters': 103332,
       'NAD_1983_HARN_WISCRS_Langlade_County_Meters': 103333,
       'NAD_1983_HARN_WISCRS_Lincoln_County_Meters': 103334,
       'NAD_1983_HARN_WISCRS_Manitowoc_County_Meters': 103335,
       'NAD_1983_HARN_WISCRS_Marathon_County_Meters': 103336,
       'NAD_1983_HARN_WISCRS_Marinette_County_Meters': 103337,
       'NAD_1983_HARN_WISCRS_Marquette_County_Meters': 103338,
       'NAD_1983_HARN_WISCRS_Menominee_County_Meters': 103339,
       'NAD_1983_HARN_WISCRS_Milwaukee_County_Meters': 103340,
       'NAD_1983_HARN_WISCRS_Monroe_County_Meters': 103341,
       'NAD_1983_HARN_WISCRS_Oconto_County_Meters': 103342,
       'NAD_1983_HARN_WISCRS_Oneida_County_Meters': 103343,
       'NAD_1983_HARN_WISCRS_Outagamie_County_Meters': 103344,
       'NAD_1983_HARN_WISCRS_Ozaukee_County_Meters': 103345,
       'NAD_1983_HARN_WISCRS_Pepin_County_Meters': 103346,
       'NAD_1983_HARN_WISCRS_Pierce_County_Meters': 103347,
       'NAD_1983_HARN_WISCRS_Polk_County_Meters': 103348,
       'NAD_1983_HARN_WISCRS_Portage_County_Meters': 103349,
       'NAD_1983_HARN_WISCRS_Price_County_Meters': 103350,
       'NAD_1983_HARN_WISCRS_Racine_County_Meters': 103351,
       'NAD_1983_HARN_WISCRS_Richland_County_Meters': 103352,
       'NAD_1983_HARN_WISCRS_Rock_County_Meters': 103353,
       'NAD_1983_HARN_WISCRS_Rusk_County_Meters': 103354,
       'NAD_1983_HARN_WISCRS_Sauk_County_Meters': 103355,
       'NAD_1983_HARN_WISCRS_Sawyer_County_Meters': 103356,
       'NAD_1983_HARN_WISCRS_Shawano_County_Meters': 103357,
       'NAD_1983_HARN_WISCRS_Sheboygan_County_Meters': 103358,
       'NAD_1983_HARN_WISCRS_St_Croix_County_Meters': 103359,
       'NAD_1983_HARN_WISCRS_Taylor_County_Meters': 103360,
       'NAD_1983_HARN_WISCRS_Trempealeau_County_Meters': 103361,
       'NAD_1983_HARN_WISCRS_Vernon_County_Meters': 103362,
       'NAD_1983_HARN_WISCRS_Vilas_County_Meters': 103363,
       'NAD_1983_HARN_WISCRS_Walworth_County_Meters': 103364,
       'NAD_1983_HARN_WISCRS_Washburn_County_Meters': 103365,
       'NAD_1983_HARN_WISCRS_Washington_County_Meters': 103366,
       'NAD_1983_HARN_WISCRS_Waukesha_County_Meters': 103367,
       'NAD_1983_HARN_WISCRS_Waupaca_County_Meters': 103368,
       'NAD_1983_HARN_WISCRS_Waushara_County_Meters': 103369,
       'NAD_1983_HARN_WISCRS_Winnebago_County_Meters': 103370,
       'NAD_1983_HARN_WISCRS_Wood_County_Meters': 103371,
       'NAD_1983_HARN_WISCRS_Adams_County_Feet': 103400,
       'NAD_1983_HARN_WISCRS_Ashland_County_Feet': 103401,
       'NAD_1983_HARN_WISCRS_Barron_County_Feet': 103402,
       'NAD_1983_HARN_WISCRS_Bayfield_County_Feet': 103403,
       'NAD_1983_HARN_WISCRS_Brown_County_Feet': 103404,
       'NAD_1983_HARN_WISCRS_Buffalo_County_Feet': 103405,
       'NAD_1983_HARN_WISCRS_Burnett_County_Feet': 103406,
       'NAD_1983_HARN_WISCRS_Calumet_County_Feet': 103407,
       'NAD_1983_HARN_WISCRS_Chippewa_County_Feet': 103408,
       'NAD_1983_HARN_WISCRS_Clark_County_Feet': 103409,
       'NAD_1983_HARN_WISCRS_Columbia_County_Feet': 103410,
       'NAD_1983_HARN_WISCRS_Crawford_County_Feet': 103411,
       'NAD_1983_HARN_WISCRS_Dane_County_Feet': 103412,
       'NAD_1983_HARN_WISCRS_Dodge_County_Feet': 103413,
       'NAD_1983_HARN_WISCRS_Door_County_Feet': 103414,
       'NAD_1983_HARN_WISCRS_Douglas_County_Feet': 103415,
       'NAD_1983_HARN_WISCRS_Dunn_County_Feet': 103416,
       'NAD_1983_HARN_WISCRS_EauClaire_County_Feet': 103417,
       'NAD_1983_HARN_WISCRS_Florence_County_Feet': 103418,
       'NAD_1983_HARN_WISCRS_Fond_du_Lac_County_Feet': 103419,
       'NAD_1983_HARN_WISCRS_Forest_County_Feet': 103420,
       'NAD_1983_HARN_WISCRS_Grant_County_Feet': 103421,
       'NAD_1983_HARN_WISCRS_Green_County_Feet': 103422,
       'NAD_1983_HARN_WISCRS_GreenLake_County_Feet': 103423,
       'NAD_1983_HARN_WISCRS_Iowa_County_Feet': 103424,
       'NAD_1983_HARN_WISCRS_Iron_County_Feet': 103425,
       'NAD_1983_HARN_WISCRS_Jackson_County_Feet': 103426,
       'NAD_1983_HARN_WISCRS_Jefferson_County_Feet': 103427,
       'NAD_1983_HARN_WISCRS_Juneau_County_Feet': 103428,
       'NAD_1983_HARN_WISCRS_Kenosha_County_Feet': 103429,
       'NAD_1983_HARN_WISCRS_Kewaunee_County_Feet': 103430,
       'NAD_1983_HARN_WISCRS_LaCrosse_County_Feet': 103431,
       'NAD_1983_HARN_WISCRS_Lafayette_County_Feet': 103432,
       'NAD_1983_HARN_WISCRS_Langlade_County_Feet': 103433,
       'NAD_1983_HARN_WISCRS_Lincoln_County_Feet': 103434,
       'NAD_1983_HARN_WISCRS_Manitowoc_County_Feet': 103435,
       'NAD_1983_HARN_WISCRS_Marathon_County_Feet': 103436,
       'NAD_1983_HARN_WISCRS_Marinette_County_Feet': 103437,
       'NAD_1983_HARN_WISCRS_Marquette_County_Feet': 103438,
       'NAD_1983_HARN_WISCRS_Menominee_County_Feet': 103439,
       'NAD_1983_HARN_WISCRS_Milwaukee_County_Feet': 103440,
       'NAD_1983_HARN_WISCRS_Monroe_County_Feet': 103441,
       'NAD_1983_HARN_WISCRS_Oconto_County_Feet': 103442,
       'NAD_1983_HARN_WISCRS_Oneida_County_Feet': 103443,
       'NAD_1983_HARN_WISCRS_Outagamie_County_Feet': 103444,
       'NAD_1983_HARN_WISCRS_Ozaukee_County_Feet': 103445,
       'NAD_1983_HARN_WISCRS_Pepin_County_Feet': 103446,
       'NAD_1983_HARN_WISCRS_Pierce_County_Feet': 103447,
       'NAD_1983_HARN_WISCRS_Polk_County_Feet': 103448,
       'NAD_1983_HARN_WISCRS_Portage_County_Feet': 103449,
       'NAD_1983_HARN_WISCRS_Price_County_Feet': 103450,
       'NAD_1983_HARN_WISCRS_Racine_County_Feet': 103451,
       'NAD_1983_HARN_WISCRS_Richland_County_Feet': 103452,
       'NAD_1983_HARN_WISCRS_Rock_County_Feet': 103453,
       'NAD_1983_HARN_WISCRS_Rusk_County_Feet': 103454,
       'NAD_1983_HARN_WISCRS_Sauk_County_Feet': 103455,
       'NAD_1983_HARN_WISCRS_Sawyer_County_Feet': 103456,
       'NAD_1983_HARN_WISCRS_Shawano_County_Feet': 103457,
       'NAD_1983_HARN_WISCRS_Sheboygan_County_Feet': 103458,
       'NAD_1983_HARN_WISCRS_St_Croix_County_Feet': 103459,
       'NAD_1983_HARN_WISCRS_Taylor_County_Feet': 103460,
       'NAD_1983_HARN_WISCRS_Trempealeau_County_Feet': 103461,
       'NAD_1983_HARN_WISCRS_Vernon_County_Feet': 103462,
       'NAD_1983_HARN_WISCRS_Vilas_County_Feet': 103463,
       'NAD_1983_HARN_WISCRS_Walworth_County_Feet': 103464,
       'NAD_1983_HARN_WISCRS_Washburn_County_Feet': 103465,
       'NAD_1983_HARN_WISCRS_Washington_County_Feet': 103466,
       'NAD_1983_HARN_WISCRS_Waukesha_County_Feet': 103467,
       'NAD_1983_HARN_WISCRS_Waupaca_County_Feet': 103468,
       'NAD_1983_HARN_WISCRS_Waushara_County_Feet': 103469,
       'NAD_1983_HARN_WISCRS_Winnebago_County_Feet': 103470,
       'NAD_1983_HARN_WISCRS_Wood_County_Feet': 103471,
       'ETRF_1989_UTM_Zone_28N': 103528,
       'ETRF_1989_UTM_Zone_29N': 103529,
       'ETRF_1989_UTM_Zone_30N': 103530,
       'ETRF_1989_UTM_Zone_31N': 103531,
       'ETRF_1989_UTM_Zone_32N': 103532,
       'ETRF_1989_UTM_Zone_33N': 103533,
       'ETRF_1989_UTM_Zone_34N': 103534,
       'ETRF_1989_UTM_Zone_35N': 103535,
       'ETRF_1989_UTM_Zone_36N': 103536,
       'ETRF_1989_UTM_Zone_37N': 103537,
       'ETRF_1989_UTM_Zone_38N': 103538,
       'ETRF_1989_TM_Baltic_1993': 103584,
       'NAD_1983_HARN_Adj_MN_Aitkin_Meters': 103600,
       'NAD_1983_HARN_Adj_MN_Clay_Meters': 103601,
       'NAD_1983_HARN_Adj_MN_Clearwater_Meters': 103602,
       'NAD_1983_HARN_Adj_MN_Hubbard_Meters': 103603,
       'NAD_1983_HARN_Adj_MN_Lake_Meters': 103604,
       'NAD_1983_HARN_Adj_MN_Mille_Lacs_Meters': 103605,
       'NAD_1983_HARN_Adj_MN_Washington_Meters': 103606,
       'NAD_1983_HARN_Adj_MN_Wilkin_Meters': 103607,
       'NAD_1983_HARN_Adj_MN_Anoka_Meters': 103608,
       'NAD_1983_HARN_Adj_MN_Becker_Meters': 103609,
       'NAD_1983_HARN_Adj_MN_Beltrami_North_Meters': 103610,
       'NAD_1983_HARN_Adj_MN_Beltrami_South_Meters': 103611,
       'NAD_1983_HARN_Adj_MN_Benton_Meters': 103612,
       'NAD_1983_HARN_Adj_MN_Big_Stone_Meters': 103613,
       'NAD_1983_HARN_Adj_MN_Blue_Earth_Meters': 103614,
       'NAD_1983_HARN_Adj_MN_Brown_Meters': 103615,
       'NAD_1983_HARN_Adj_MN_Carlton_Meters': 103616,
       'NAD_1983_HARN_Adj_MN_Carver_Meters': 103617,
       'NAD_1983_HARN_Adj_MN_Cass_North_Meters': 103618,
       'NAD_1983_HARN_Adj_MN_Cass_South_Meters': 103619,
       'NAD_1983_HARN_Adj_MN_Chippewa_Meters': 103620,
       'NAD_1983_HARN_Adj_MN_Chisago_Meters': 103621,
       'NAD_1983_HARN_Adj_MN_Cook_North_Meters': 103622,
       'NAD_1983_HARN_Adj_MN_Cook_South_Meters': 103623,
       'NAD_1983_HARN_Adj_MN_Cottonwood_Meters': 103624,
       'NAD_1983_HARN_Adj_MN_Crow_Wing_Meters': 103625,
       'NAD_1983_HARN_Adj_MN_Dakota_Meters': 103626,
       'NAD_1983_HARN_Adj_MN_Dodge_Meters': 103627,
       'NAD_1983_HARN_Adj_MN_Douglas_Meters': 103628,
       'NAD_1983_HARN_Adj_MN_Faribault_Meters': 103629,
       'NAD_1983_HARN_Adj_MN_Fillmore_Meters': 103630,
       'NAD_1983_HARN_Adj_MN_Freeborn_Meters': 103631,
       'NAD_1983_HARN_Adj_MN_Goodhue_Meters': 103632,
       'NAD_1983_HARN_Adj_MN_Grant_Meters': 103633,
       'NAD_1983_HARN_Adj_MN_Hennepin_Meters': 103634,
       'NAD_1983_HARN_Adj_MN_Houston_Meters': 103635,
       'NAD_1983_HARN_Adj_MN_Isanti_Meters': 103636,
       'NAD_1983_HARN_Adj_MN_Itasca_North_Meters': 103637,
       'NAD_1983_HARN_Adj_MN_Itasca_South_Meters': 103638,
       'NAD_1983_HARN_Adj_MN_Jackson_Meters': 103639,
       'NAD_1983_HARN_Adj_MN_Kanabec_Meters': 103640,
       'NAD_1983_HARN_Adj_MN_Kandiyohi_Meters': 103641,
       'NAD_1983_HARN_Adj_MN_Kittson_Meters': 103642,
       'NAD_1983_HARN_Adj_MN_Koochiching_Meters': 103643,
       'NAD_1983_HARN_Adj_MN_Lac_Qui_Parle_Meters': 103644,
       'NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_North_Meters': 103645,
       'NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_South_Meters': 103646,
       'NAD_1983_HARN_Adj_MN_Le_Sueur_Meters': 103647,
       'NAD_1983_HARN_Adj_MN_Lincoln_Meters': 103648,
       'NAD_1983_HARN_Adj_MN_Lyon_Meters': 103649,
       'NAD_1983_HARN_Adj_MN_McLeod_Meters': 103650,
       'NAD_1983_HARN_Adj_MN_Mahnomen_Meters': 103651,
       'NAD_1983_HARN_Adj_MN_Marshall_Meters': 103652,
       'NAD_1983_HARN_Adj_MN_Martin_Meters': 103653,
       'NAD_1983_HARN_Adj_MN_Meeker_Meters': 103654,
       'NAD_1983_HARN_Adj_MN_Morrison_Meters': 103655,
       'NAD_1983_HARN_Adj_MN_Mower_Meters': 103656,
       'NAD_1983_HARN_Adj_MN_Murray_Meters': 103657,
       'NAD_1983_HARN_Adj_MN_Nicollet_Meters': 103658,
       'NAD_1983_HARN_Adj_MN_Nobles_Meters': 103659,
       'NAD_1983_HARN_Adj_MN_Norman_Meters': 103660,
       'NAD_1983_HARN_Adj_MN_Olmsted_Meters': 103661,
       'NAD_1983_HARN_Adj_MN_Ottertail_Meters': 103662,
       'NAD_1983_HARN_Adj_MN_Pennington_Meters': 103663,
       'NAD_1983_HARN_Adj_MN_Pine_Meters': 103664,
       'NAD_1983_HARN_Adj_MN_Pipestone_Meters': 103665,
       'NAD_1983_HARN_Adj_MN_Polk_Meters': 103666,
       'NAD_1983_HARN_Adj_MN_Pope_Meters': 103667,
       'NAD_1983_HARN_Adj_MN_Ramsey_Meters': 103668,
       'NAD_1983_HARN_Adj_MN_Red_Lake_Meters': 103669,
       'NAD_1983_HARN_Adj_MN_Redwood_Meters': 103670,
       'NAD_1983_HARN_Adj_MN_Renville_Meters': 103671,
       'NAD_1983_HARN_Adj_MN_Rice_Meters': 103672,
       'NAD_1983_HARN_Adj_MN_Rock_Meters': 103673,
       'NAD_1983_HARN_Adj_MN_Roseau_Meters': 103674,
       'NAD_1983_HARN_Adj_MN_St_Louis_North_Meters': 103675,
       'NAD_1983_HARN_Adj_MN_St_Louis_Central_Meters': 103676,
       'NAD_1983_HARN_Adj_MN_St_Louis_South_Meters': 103677,
       'NAD_1983_HARN_Adj_MN_Scott_Meters': 103678,
       'NAD_1983_HARN_Adj_MN_Sherburne_Meters': 103679,
       'NAD_1983_HARN_Adj_MN_Sibley_Meters': 103680,
       'NAD_1983_HARN_Adj_MN_Stearns_Meters': 103681,
       'NAD_1983_HARN_Adj_MN_Steele_Meters': 103682,
       'NAD_1983_HARN_Adj_MN_Stevens_Meters': 103683,
       'NAD_1983_HARN_Adj_MN_Swift_Meters': 103684,
       'NAD_1983_HARN_Adj_MN_Todd_Meters': 103685,
       'NAD_1983_HARN_Adj_MN_Traverse_Meters': 103686,
       'NAD_1983_HARN_Adj_MN_Wabasha_Meters': 103687,
       'NAD_1983_HARN_Adj_MN_Wadena_Meters': 103688,
       'NAD_1983_HARN_Adj_MN_Waseca_Meters': 103689,
       'NAD_1983_HARN_Adj_MN_Watonwan_Meters': 103690,
       'NAD_1983_HARN_Adj_MN_Winona_Meters': 103691,
       'NAD_1983_HARN_Adj_MN_Wright_Meters': 103692,
       'NAD_1983_HARN_Adj_MN_Yellow_Medicine_Meters': 103693,
       'NAD_1983_HARN_Adj_MN_Aitkin_Feet': 103700,
       'NAD_1983_HARN_Adj_MN_Clay_Feet': 103701,
       'NAD_1983_HARN_Adj_MN_Clearwater_Feet': 103702,
       'NAD_1983_HARN_Adj_MN_Hubbard_Feet': 103703,
       'NAD_1983_HARN_Adj_MN_Lake_Feet': 103704,
       'NAD_1983_HARN_Adj_MN_Mille_Lacs_Feet': 103705,
       'NAD_1983_HARN_Adj_MN_Washington_Feet': 103706,
       'NAD_1983_HARN_Adj_MN_Wilkin_Feet': 103707,
       'NAD_1983_HARN_Adj_MN_Anoka_Feet': 103708,
       'NAD_1983_HARN_Adj_MN_Becker_Feet': 103709,
       'NAD_1983_HARN_Adj_MN_Beltrami_North_Feet': 103710,
       'NAD_1983_HARN_Adj_MN_Beltrami_South_Feet': 103711,
       'NAD_1983_HARN_Adj_MN_Benton_Feet': 103712,
       'NAD_1983_HARN_Adj_MN_Big_Stone_Feet': 103713,
       'NAD_1983_HARN_Adj_MN_Blue_Earth_Feet': 103714,
       'NAD_1983_HARN_Adj_MN_Brown_Feet': 103715,
       'NAD_1983_HARN_Adj_MN_Carlton_Feet': 103716,
       'NAD_1983_HARN_Adj_MN_Carver_Feet': 103717,
       'NAD_1983_HARN_Adj_MN_Cass_North_Feet': 103718,
       'NAD_1983_HARN_Adj_MN_Cass_South_Feet': 103719,
       'NAD_1983_HARN_Adj_MN_Chippewa_Feet': 103720,
       'NAD_1983_HARN_Adj_MN_Chisago_Feet': 103721,
       'NAD_1983_HARN_Adj_MN_Cook_North_Feet': 103722,
       'NAD_1983_HARN_Adj_MN_Cook_South_Feet': 103723,
       'NAD_1983_HARN_Adj_MN_Cottonwood_Feet': 103724,
       'NAD_1983_HARN_Adj_MN_Crow_Wing_Feet': 103725,
       'NAD_1983_HARN_Adj_MN_Dakota_Feet': 103726,
       'NAD_1983_HARN_Adj_MN_Dodge_Feet': 103727,
       'NAD_1983_HARN_Adj_MN_Douglas_Feet': 103728,
       'NAD_1983_HARN_Adj_MN_Faribault_Feet': 103729,
       'NAD_1983_HARN_Adj_MN_Fillmore_Feet': 103730,
       'NAD_1983_HARN_Adj_MN_Freeborn_Feet': 103731,
       'NAD_1983_HARN_Adj_MN_Goodhue_Feet': 103732,
       'NAD_1983_HARN_Adj_MN_Grant_Feet': 103733,
       'NAD_1983_HARN_Adj_MN_Hennepin_Feet': 103734,
       'NAD_1983_HARN_Adj_MN_Houston_Feet': 103735,
       'NAD_1983_HARN_Adj_MN_Isanti_Feet': 103736,
       'NAD_1983_HARN_Adj_MN_Itasca_North_Feet': 103737,
       'NAD_1983_HARN_Adj_MN_Itasca_South_Feet': 103738,
       'NAD_1983_HARN_Adj_MN_Jackson_Feet': 103739,
       'NAD_1983_HARN_Adj_MN_Kanabec_Feet': 103740,
       'NAD_1983_HARN_Adj_MN_Kandiyohi_Feet': 103741,
       'NAD_1983_HARN_Adj_MN_Kittson_Feet': 103742,
       'NAD_1983_HARN_Adj_MN_Koochiching_Feet': 103743,
       'NAD_1983_HARN_Adj_MN_Lac_Qui_Parle_Feet': 103744,
       'NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_North_Feet': 103745,
       'NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_South_Feet': 103746,
       'NAD_1983_HARN_Adj_MN_Le_Sueur_Feet': 103747,
       'NAD_1983_HARN_Adj_MN_Lincoln_Feet': 103748,
       'NAD_1983_HARN_Adj_MN_Lyon_Feet': 103749,
       'NAD_1983_HARN_Adj_MN_McLeod_Feet': 103750,
       'NAD_1983_HARN_Adj_MN_Mahnomen_Feet': 103751,
       'NAD_1983_HARN_Adj_MN_Marshall_Feet': 103752,
       'NAD_1983_HARN_Adj_MN_Martin_Feet': 103753,
       'NAD_1983_HARN_Adj_MN_Meeker_Feet': 103754,
       'NAD_1983_HARN_Adj_MN_Morrison_Feet': 103755,
       'NAD_1983_HARN_Adj_MN_Mower_Feet': 103756,
       'NAD_1983_HARN_Adj_MN_Murray_Feet': 103757,
       'NAD_1983_HARN_Adj_MN_Nicollet_Feet': 103758,
       'NAD_1983_HARN_Adj_MN_Nobles_Feet': 103759,
       'NAD_1983_HARN_Adj_MN_Norman_Feet': 103760,
       'NAD_1983_HARN_Adj_MN_Olmsted_Feet': 103761,
       'NAD_1983_HARN_Adj_MN_Ottertail_Feet': 103762,
       'NAD_1983_HARN_Adj_MN_Pennington_Feet': 103763,
       'NAD_1983_HARN_Adj_MN_Pine_Feet': 103764,
       'NAD_1983_HARN_Adj_MN_Pipestone_Feet': 103765,
       'NAD_1983_HARN_Adj_MN_Polk_Feet': 103766,
       'NAD_1983_HARN_Adj_MN_Pope_Feet': 103767,
       'NAD_1983_HARN_Adj_MN_Ramsey_Feet': 103768,
       'NAD_1983_HARN_Adj_MN_Red_Lake_Feet': 103769,
       'NAD_1983_HARN_Adj_MN_Redwood_Feet': 103770,
       'NAD_1983_HARN_Adj_MN_Renville_Feet': 103771,
       'NAD_1983_HARN_Adj_MN_Rice_Feet': 103772,
       'NAD_1983_HARN_Adj_MN_Rock_Feet': 103773,
       'NAD_1983_HARN_Adj_MN_Roseau_Feet': 103774,
       'NAD_1983_HARN_Adj_MN_St_Louis_North_Feet': 103775,
       'NAD_1983_HARN_Adj_MN_St_Louis_Central_Feet': 103776,
       'NAD_1983_HARN_Adj_MN_St_Louis_South_Feet': 103777,
       'NAD_1983_HARN_Adj_MN_Scott_Feet': 103778,
       'NAD_1983_HARN_Adj_MN_Sherburne_Feet': 103779,
       'NAD_1983_HARN_Adj_MN_Sibley_Feet': 103780,
       'NAD_1983_HARN_Adj_MN_Stearns_Feet': 103781,
       'NAD_1983_HARN_Adj_MN_Steele_Feet': 103782,
       'NAD_1983_HARN_Adj_MN_Stevens_Feet': 103783,
       'NAD_1983_HARN_Adj_MN_Swift_Feet': 103784,
       'NAD_1983_HARN_Adj_MN_Todd_Feet': 103785,
       'NAD_1983_HARN_Adj_MN_Traverse_Feet': 103786,
       'NAD_1983_HARN_Adj_MN_Wabasha_Feet': 103787,
       'NAD_1983_HARN_Adj_MN_Wadena_Feet': 103788,
       'NAD_1983_HARN_Adj_MN_Waseca_Feet': 103789,
       'NAD_1983_HARN_Adj_MN_Watonwan_Feet': 103790,
       'NAD_1983_HARN_Adj_MN_Winona_Feet': 103791,
       'NAD_1983_HARN_Adj_MN_Wright_Feet': 103792,
       'NAD_1983_HARN_Adj_MN_Yellow_Medicine_Feet': 103793,
       'NAD_1983_HARN_Adj_WI_Adams_Meters': 103800,
       'NAD_1983_HARN_Adj_WI_Ashland_Meters': 103801,
       'NAD_1983_HARN_Adj_WI_Barron_Meters': 103802,
       'NAD_1983_HARN_Adj_WI_Brown_Meters': 103803,
       'NAD_1983_HARN_Adj_WI_Buffalo_Meters': 103804,
       'NAD_1983_HARN_Adj_WI_Calumet_Meters': 103805,
       'NAD_1983_HARN_Adj_WI_Clark_Meters': 103806,
       'NAD_1983_HARN_Adj_WI_Dodge_Meters': 103807,
       'NAD_1983_HARN_Adj_WI_Door_Meters': 103808,
       'NAD_1983_HARN_Adj_WI_Douglas_Meters': 103809,
       'NAD_1983_HARN_Adj_WI_Dunn_Meters': 103810,
       'NAD_1983_HARN_Adj_WI_Florence_Meters': 103811,
       'NAD_1983_HARN_Adj_WI_Fond_du_Lac_Meters': 103812,
       'NAD_1983_HARN_Adj_WI_Forest_Meters': 103813,
       'NAD_1983_HARN_Adj_WI_Grant_Meters': 103814,
       'NAD_1983_HARN_Adj_WI_Iowa_Meters': 103815,
       'NAD_1983_HARN_Adj_WI_Iron_Meters': 103816,
       'NAD_1983_HARN_Adj_WI_Jefferson_Meters': 103817,
       'NAD_1983_HARN_Adj_WI_Juneau_Meters': 103818,
       'NAD_1983_HARN_Adj_WI_Kenosha_Meters': 103819,
       'NAD_1983_HARN_Adj_WI_Kewaunee_Meters': 103820,
       'NAD_1983_HARN_Adj_WI_LaCrosse_Meters': 103821,
       'NAD_1983_HARN_Adj_WI_Lincoln_Meters': 103822,
       'NAD_1983_HARN_Adj_WI_Manitowoc_Meters': 103823,
       'NAD_1983_HARN_Adj_WI_Marinette_Meters': 103824,
       'NAD_1983_HARN_Adj_WI_Menominee_Meters': 103825,
       'NAD_1983_HARN_Adj_WI_Milwaukee_Meters': 103826,
       'NAD_1983_HARN_Adj_WI_Oconto_Meters': 103827,
       'NAD_1983_HARN_Adj_WI_Outagamie_Meters': 103828,
       'NAD_1983_HARN_Adj_WI_Ozaukee_Meters': 103829,
       'NAD_1983_HARN_Adj_WI_Polk_Meters': 103830,
       'NAD_1983_HARN_Adj_WI_Price_Meters': 103831,
       'NAD_1983_HARN_Adj_WI_Racine_Meters': 103832,
       'NAD_1983_HARN_Adj_WI_Rock_Meters': 103833,
       'NAD_1983_HARN_Adj_WI_Rusk_Meters': 103834,
       'NAD_1983_HARN_Adj_WI_St_Croix_Meters': 103835,
       'NAD_1983_HARN_Adj_WI_Sauk_Meters': 103836,
       'NAD_1983_HARN_Adj_WI_Shawano_Meters': 103837,
       'NAD_1983_HARN_Adj_WI_Sheboygan_Meters': 103838,
       'NAD_1983_HARN_Adj_WI_Trempealeau_Meters': 103839,
       'NAD_1983_HARN_Adj_WI_Washington_Meters': 103840,
       'NAD_1983_HARN_Adj_WI_Waukesha_Meters': 103841,
       'NAD_1983_HARN_Adj_WI_Waupaca_Meters': 103842,
       'NAD_1983_HARN_Adj_WI_Winnebago_Meters': 103843,
       'NAD_1983_HARN_Adj_WI_Bayfield_Meters': 103844,
       'NAD_1983_HARN_Adj_WI_Burnett_Meters': 103845,
       'NAD_1983_HARN_Adj_WI_Chippewa_Meters': 103846,
       'NAD_1983_HARN_Adj_WI_Columbia_Meters': 103847,
       'NAD_1983_HARN_Adj_WI_Crawford_Meters': 103848,
       'NAD_1983_HARN_Adj_WI_Dane_Meters': 103849,
       'NAD_1983_HARN_Adj_WI_EauClaire_Meters': 103850,
       'NAD_1983_HARN_Adj_WI_Green_Meters': 103851,
       'NAD_1983_HARN_Adj_WI_GreenLake_Meters': 103852,
       'NAD_1983_HARN_Adj_WI_Jackson_Meters': 103853,
       'NAD_1983_HARN_Adj_WI_Lafayette_Meters': 103854,
       'NAD_1983_HARN_Adj_WI_Langlade_Meters': 103855,
       'NAD_1983_HARN_Adj_WI_Marathon_Meters': 103856,
       'NAD_1983_HARN_Adj_WI_Marquette_Meters': 103857,
       'NAD_1983_HARN_Adj_WI_Monroe_Meters': 103858,
       'NAD_1983_HARN_Adj_WI_Oneida_Meters': 103859,
       'NAD_1983_HARN_Adj_WI_Pepin_Meters': 103860,
       'NAD_1983_HARN_Adj_WI_Pierce_Meters': 103861,
       'NAD_1983_HARN_Adj_WI_Portage_Meters': 103862,
       'NAD_1983_HARN_Adj_WI_Richland_Meters': 103863,
       'NAD_1983_HARN_Adj_WI_Sawyer_Meters': 103864,
       'NAD_1983_HARN_Adj_WI_Taylor_Meters': 103865,
       'NAD_1983_HARN_Adj_WI_Vernon_Meters': 103866,
       'NAD_1983_HARN_Adj_WI_Vilas_Meters': 103867,
       'NAD_1983_HARN_Adj_WI_Walworth_Meters': 103868,
       'NAD_1983_HARN_Adj_WI_Washburn_Meters': 103869,
       'NAD_1983_HARN_Adj_WI_Waushara_Meters': 103870,
       'NAD_1983_HARN_Adj_WI_Wood_Meters': 103871,
       'NAD_1983_HARN_Adj_WI_Adams_Feet': 103900,
       'NAD_1983_HARN_Adj_WI_Ashland_Feet': 103901,
       'NAD_1983_HARN_Adj_WI_Barron_Feet': 103902,
       'NAD_1983_HARN_Adj_WI_Brown_Feet': 103903,
       'NAD_1983_HARN_Adj_WI_Buffalo_Feet': 103904,
       'NAD_1983_HARN_Adj_WI_Calumet_Feet': 103905,
       'NAD_1983_HARN_Adj_WI_Clark_Feet': 103906,
       'NAD_1983_HARN_Adj_WI_Dodge_Feet': 103907,
       'NAD_1983_HARN_Adj_WI_Door_Feet': 103908,
       'NAD_1983_HARN_Adj_WI_Douglas_Feet': 103909,
       'NAD_1983_HARN_Adj_WI_Dunn_Feet': 103910,
       'NAD_1983_HARN_Adj_WI_Florence_Feet': 103911,
       'NAD_1983_HARN_Adj_WI_Fond_du_Lac_Feet': 103912,
       'NAD_1983_HARN_Adj_WI_Forest_Feet': 103913,
       'NAD_1983_HARN_Adj_WI_Grant_Feet': 103914,
       'NAD_1983_HARN_Adj_WI_Iowa_Feet': 103915,
       'NAD_1983_HARN_Adj_WI_Iron_Feet': 103916,
       'NAD_1983_HARN_Adj_WI_Jefferson_Feet': 103917,
       'NAD_1983_HARN_Adj_WI_Juneau_Feet': 103918,
       'NAD_1983_HARN_Adj_WI_Kenosha_Feet': 103919,
       'NAD_1983_HARN_Adj_WI_Kewaunee_Feet': 103920,
       'NAD_1983_HARN_Adj_WI_LaCrosse_Feet': 103921,
       'NAD_1983_HARN_Adj_WI_Lincoln_Feet': 103922,
       'NAD_1983_HARN_Adj_WI_Manitowoc_Feet': 103923,
       'NAD_1983_HARN_Adj_WI_Marinette_Feet': 103924,
       'NAD_1983_HARN_Adj_WI_Menominee_Feet': 103925,
       'NAD_1983_HARN_Adj_WI_Milwaukee_Feet': 103926,
       'NAD_1983_HARN_Adj_WI_Oconto_Feet': 103927,
       'NAD_1983_HARN_Adj_WI_Outagamie_Feet': 103928,
       'NAD_1983_HARN_Adj_WI_Ozaukee_Feet': 103929,
       'NAD_1983_HARN_Adj_WI_Polk_Feet': 103930,
       'NAD_1983_HARN_Adj_WI_Price_Feet': 103931,
       'NAD_1983_HARN_Adj_WI_Racine_Feet': 103932,
       'NAD_1983_HARN_Adj_WI_Rock_Feet': 103933,
       'NAD_1983_HARN_Adj_WI_Rusk_Feet': 103934,
       'NAD_1983_HARN_Adj_WI_St_Croix_Feet': 103935,
       'NAD_1983_HARN_Adj_WI_Sauk_Feet': 103936,
       'NAD_1983_HARN_Adj_WI_Shawano_Feet': 103937,
       'NAD_1983_HARN_Adj_WI_Sheboygan_Feet': 103938,
       'NAD_1983_HARN_Adj_WI_Trempealeau_Feet': 103939,
       'NAD_1983_HARN_Adj_WI_Washington_Feet': 103940,
       'NAD_1983_HARN_Adj_WI_Waukesha_Feet': 103941,
       'NAD_1983_HARN_Adj_WI_Waupaca_Feet': 103942,
       'NAD_1983_HARN_Adj_WI_Winnebago_Feet': 103943,
       'NAD_1983_HARN_Adj_WI_Bayfield_Feet': 103944,
       'NAD_1983_HARN_Adj_WI_Burnett_Feet': 103945,
       'NAD_1983_HARN_Adj_WI_Chippewa_Feet': 103946,
       'NAD_1983_HARN_Adj_WI_Columbia_Feet': 103947,
       'NAD_1983_HARN_Adj_WI_Crawford_Feet': 103948,
       'NAD_1983_HARN_Adj_WI_Dane_Feet': 103949,
       'NAD_1983_HARN_Adj_WI_EauClaire_Feet': 103950,
       'NAD_1983_HARN_Adj_WI_Green_Feet': 103951,
       'NAD_1983_HARN_Adj_WI_GreenLake_Feet': 103952,
       'NAD_1983_HARN_Adj_WI_Jackson_Feet': 103953,
       'NAD_1983_HARN_Adj_WI_Lafayette_Feet': 103954,
       'NAD_1983_HARN_Adj_WI_Langlade_Feet': 103955,
       'NAD_1983_HARN_Adj_WI_Marathon_Feet': 103956,
       'NAD_1983_HARN_Adj_WI_Marquette_Feet': 103957,
       'NAD_1983_HARN_Adj_WI_Monroe_Feet': 103958,
       'NAD_1983_HARN_Adj_WI_Oneida_Feet': 103959,
       'NAD_1983_HARN_Adj_WI_Pepin_Feet': 103960,
       'NAD_1983_HARN_Adj_WI_Pierce_Feet': 103961,
       'NAD_1983_HARN_Adj_WI_Portage_Feet': 103962,
       'NAD_1983_HARN_Adj_WI_Richland_Feet': 103963,
       'NAD_1983_HARN_Adj_WI_Sawyer_Feet': 103964,
       'NAD_1983_HARN_Adj_WI_Taylor_Feet': 103965,
       'NAD_1983_HARN_Adj_WI_Vernon_Feet': 103966,
       'NAD_1983_HARN_Adj_WI_Vilas_Feet': 103967,
       'NAD_1983_HARN_Adj_WI_Walworth_Feet': 103968,
       'NAD_1983_HARN_Adj_WI_Washburn_Feet': 103969,
       'NAD_1983_HARN_Adj_WI_Waushara_Feet': 103970,
       'NAD_1983_HARN_Adj_WI_Wood_Feet': 103971
    }

class geographic(Projection):
   _projections = {
       'GCS_Airy_1830': 4001,
       'GCS_Airy_Modified': 4002,
       'GCS_Australian': 4003,
       'GCS_Bessel_1841': 4004,
       'GCS_Bessel_Modified': 4005,
       'GCS_Bessel_Namibia': 4006,
       'GCS_Clarke_1858': 4007,
       'GCS_Clarke_1866': 4008,
       'GCS_Clarke_1866_Michigan': 4009,
       'GCS_Clarke_1880_Benoit': 4010,
       'GCS_Clarke_1880_IGN': 4011,
       'GCS_Clarke_1880_RGS': 4012,
       'GCS_Clarke_1880_Arc': 4013,
       'GCS_Clarke_1880_SGA': 4014,
       'GCS_Everest_Adj_1937': 4015,
       'GCS_Everest_def_1967': 4016,
       'GCS_Everest_Modified': 4018,
       'GCS_GRS_1980': 4019,
       'GCS_Helmert_1906': 4020,
       'GCS_Indonesian': 4021,
       'GCS_International_1924': 4022,
       'GCS_International_1967': 4023,
       'GCS_Krasovsky_1940': 4024,
       'GCS_NWL_9D': 4025,
       'GCS_Plessis_1817': 4027,
       'GCS_Struve_1860': 4028,
       'GCS_War_Office': 4029,
       'GCS_GEM_10C': 4031,
       'GCS_OSU_86F': 4032,
       'GCS_OSU_91A': 4033,
       'GCS_Clarke_1880': 4034,
       'GCS_Sphere': 4035,
       'GCS_GRS_1967': 4036,
       'GCS_Everest_1830': 4042,
       'GCS_Everest_def_1962': 4044,
       'GCS_Everest_def_1975': 4045,
       'GCS_Sphere_GRS_1980_Authalic': 4047,
       'GCS_Sphere_Clarke_1866_Authalic': 4052,
       'GCS_Sphere_International_1924_Authalic': 4053,
       'GCS_Hughes_1980': 4054,
       'GCS_Greek': 4120,
       'GCS_GGRS_1987': 4121,
       'GCS_ATS_1977': 4122,
       'GCS_KKJ': 4123,
       'GCS_RT_1990': 4124,
       'GCS_Samboja': 4125,
       'GCS_LKS_1994': 4126,
       'GCS_Tete': 4127,
       'GCS_Madzansua': 4128,
       'GCS_Observatario': 4129,
       'GCS_Moznet': 4130,
       'GCS_Indian_1960': 4131,
       'GCS_FD_1958': 4132,
       'GCS_Estonia_1992': 4133,
       'GCS_PDO_1993': 4134,
       'GCS_Old_Hawaiian': 4135,
       'GCS_St_Lawrence_Island': 4136,
       'GCS_St_Paul_Island': 4137,
       'GCS_St_George_Island': 4138,
       'GCS_Puerto_Rico': 4139,
       'GCS_North_American_1983_CSRS': 4140,
       'GCS_Israel': 4141,
       'GCS_Locodjo_1965': 4142,
       'GCS_Abidjan_1987': 4143,
       'GCS_Kalianpur_1937': 4144,
       'GCS_Kalianpur_1962': 4145,
       'GCS_Kalianpur_1975': 4146,
       'GCS_Hanoi_1972': 4147,
       'GCS_Hartebeesthoek_1994': 4148,
       'GCS_CH1903': 4149,
       'GCS_CH1903+': 4150,
       'GCS_Swiss_TRF_1995': 4151,
       'GCS_North_American_1983_HARN': 4152,
       'GCS_Rassadiran': 4153,
       'GCS_European_1950_ED77': 4154,
       'GCS_Dabola_1981': 4155,
       'GCS_S_JTSK': 4156,
       'GCS_Mount_Dillon': 4157,
       'GCS_Naparima_1955': 4158,
       'GCS_European_Libyan_Datum_1979': 4159,
       'GCS_Chos_Malal_1914': 4160,
       'GCS_Pampa_del_Castillo': 4161,
       'GCS_Korean_Datum_1985': 4162,
       'GCS_Yemen_NGN_1996': 4163,
       'GCS_South_Yemen': 4164,
       'GCS_Bissau': 4165,
       'GCS_Korean_Datum_1995': 4166,
       'GCS_NZGD_2000': 4167,
       'GCS_Accra': 4168,
       'GCS_American_Samoa_1962': 4169,
       'GCS_SIRGAS': 4170,
       'GCS_RGF_1993': 4171,
       'GCS_POSGAR': 4172,
       'GCS_IRENET95': 4173,
       'GCS_Sierra_Leone_1924': 4174,
       'GCS_Sierra_Leone_1968': 4175,
       'GCS_Australian_Antarctic_1998': 4176,
       'GCS_Pulkovo_1942_Adj_1983': 4178,
       'GCS_Pulkovo_1942_Adj_1958': 4179,
       'GCS_Estonia_1997': 4180,
       'GCS_Luxembourg_1930': 4181,
       'GCS_Azores_Occidental_1939': 4182,
       'GCS_Azores_Central_1948': 4183,
       'GCS_Azores_Oriental_1940': 4184,
       'GCS_Madeira_1936': 4185,
       'GCS_OSNI_1952': 4188,
       'GCS_REGVEN': 4189,
       'GCS_POSGAR_1998': 4190,
       'GCS_Albanian_1987': 4191,
       'GCS_Douala_1948': 4192,
       'GCS_Manoca_1962': 4193,
       'GCS_Qornoq_1927': 4194,
       'GCS_Scoresbysund_1952': 4195,
       'GCS_Ammassalik_1958': 4196,
       'GCS_Kousseri': 4198,
       'GCS_Egypt_1930': 4199,
       'GCS_Pulkovo_1995': 4200,
       'GCS_Adindan': 4201,
       'GCS_Australian_1966': 4202,
       'GCS_Australian_1984': 4203,
       'GCS_Ain_el_Abd_1970': 4204,
       'GCS_Afgooye': 4205,
       'GCS_Agadez': 4206,
       'GCS_Lisbon': 4207,
       'GCS_Aratu': 4208,
       'GCS_Arc_1950': 4209,
       'GCS_Arc_1960': 4210,
       'GCS_Batavia': 4211,
       'GCS_Barbados_1938': 4212,
       'GCS_Beduaram': 4213,
       'GCS_Beijing_1954': 4214,
       'GCS_Belge_1950': 4215,
       'GCS_Bermuda_1957': 4216,
       'GCS_Bern_1898': 4217,
       'GCS_Bogota': 4218,
       'GCS_Bukit_Rimpah': 4219,
       'GCS_Camacupa': 4220,
       'GCS_Campo_Inchauspe': 4221,
       'GCS_Cape': 4222,
       'GCS_Carthage': 4223,
       'GCS_Chua': 4224,
       'GCS_Corrego_Alegre': 4225,
       'GCS_Cote_d_Ivoire': 4226,
       'GCS_Deir_ez_Zor': 4227,
       'GCS_Douala': 4228,
       'GCS_Egypt_1907': 4229,
       'GCS_European_1950': 4230,
       'GCS_European_1987': 4231,
       'GCS_Fahud': 4232,
       'GCS_Gandajika_1970': 4233,
       'GCS_Garoua': 4234,
       'GCS_Guyane_Francaise': 4235,
       'GCS_Hu_Tzu_Shan': 4236,
       'GCS_Hungarian_1972': 4237,
       'GCS_Indonesian_1974': 4238,
       'GCS_Indian_1954': 4239,
       'GCS_Indian_1975': 4240,
       'GCS_Jamaica_1875': 4241,
       'GCS_Jamaica_1969': 4242,
       'GCS_Kalianpur_1880': 4243,
       'GCS_Kandawala': 4244,
       'GCS_Kertau': 4245,
       'GCS_Kuwait_Oil_Company': 4246,
       'GCS_La_Canoa': 4247,
       'GCS_Provisional_S_American_1956': 4248,
       'GCS_Lake': 4249,
       'GCS_Leigon': 4250,
       'GCS_Liberia_1964': 4251,
       'GCS_Lome': 4252,
       'GCS_Luzon_1911': 4253,
       'GCS_Hito_XVIII_1963': 4254,
       'GCS_Herat_North': 4255,
       'GCS_Mahe_1971': 4256,
       'GCS_Makassar': 4257,
       'GCS_ETRS_1989': 4258,
       'GCS_Malongo_1987': 4259,
       'GCS_Manoca': 4260,
       'GCS_Merchich': 4261,
       'GCS_Massawa': 4262,
       'GCS_Minna': 4263,
       'GCS_Mhast': 4264,
       'GCS_Monte_Mario': 4265,
       'GCS_Mporaloko': 4266,
       'GCS_North_American_1927': 4267,
       'GCS_North_American_Michigan': 4268,
       'GCS_North_American_1983': 4269,
       'GCS_Nahrwan_1967': 4270,
       'GCS_Naparima_1972': 4271,
       'GCS_New_Zealand_1949': 4272,
       'GCS_NGO_1948': 4273,
       'GCS_Datum_73': 4274,
       'GCS_NTF': 4275,
       'GCS_NSWC_9Z_2': 4276,
       'GCS_OSGB_1936': 4277,
       'GCS_OSGB_1970_SN': 4278,
       'GCS_OS_SN_1980': 4279,
       'GCS_Padang_1884': 4280,
       'GCS_Palestine_1923': 4281,
       'GCS_Pointe_Noire': 4282,
       'GCS_GDA_1994': 4283,
       'GCS_Pulkovo_1942': 4284,
       'GCS_Qatar_1974': 4285,
       'GCS_Qatar_1948': 4286,
       'GCS_Qornoq': 4287,
       'GCS_Loma_Quintana': 4288,
       'GCS_Amersfoort': 4289,
       'GCS_South_American_1969': 4291,
       'GCS_Sapper_Hill_1943': 4292,
       'GCS_Schwarzeck': 4293,
       'GCS_Segora': 4294,
       'GCS_Serindung': 4295,
       'GCS_Sudan': 4296,
       'GCS_Tananarive_1925': 4297,
       'GCS_Timbalai_1948': 4298,
       'GCS_TM65': 4299,
       'GCS_TM75': 4300,
       'GCS_Tokyo': 4301,
       'GCS_Trinidad_1903': 4302,
       'GCS_Trucial_Coast_1948': 4303,
       'GCS_Voirol_1875': 4304,
       'GCS_Voirol_Unifie_1960': 4305,
       'GCS_Bern_1938': 4306,
       'GCS_Nord_Sahara_1959': 4307,
       'GCS_RT38': 4308,
       'GCS_Yacare': 4309,
       'GCS_Yoff': 4310,
       'GCS_Zanderij': 4311,
       'GCS_MGI': 4312,
       'GCS_Belge_1972': 4313,
       'GCS_Deutsches_Hauptdreiecksnetz': 4314,
       'GCS_Conakry_1905': 4315,
       'GCS_Dealul_Piscului_1933': 4316,
       'GCS_Dealul_Piscului_1970': 4317,
       'GCS_NGN': 4318,
       'GCS_KUDAMS': 4319,
       'GCS_WGS_1972': 4322,
       'GCS_WGS_1972_BE': 4324,
       'GCS_WGS_1984': 4326,
       'GCS_Montserrat_1958': 4404,
       'GCS_Anguilla_1957': 4600,
       'GCS_Antigua_1943': 4601,
       'GCS_Dominica_1945': 4602,
       'GCS_Grenada_1953': 4603,
       'GCS_St_Kitts_1955': 4605,
       'GCS_St_Lucia_1955': 4606,
       'GCS_St_Vincent_1945': 4607,
       'GCS_NAD_1927_Definition_1976': 4608,
       'GCS_NAD_1927_CGQ77': 4609,
       'GCS_Xian_1980': 4610,
       'GCS_Hong_Kong_1980': 4611,
       'GCS_JGD_2000': 4612,
       'GCS_Gunung_Segara': 4613,
       'GCS_QND_1995': 4614,
       'GCS_Porto_Santo_1936': 4615,
       'GCS_Selvagem_Grande_1938': 4616,
       'GCS_North_American_1983_CSRS': 4617,
       'GCS_South_American_1969': 4618,
       'GCS_SWEREF99': 4619,
       'GCS_Point_58': 4620,
       'GCS_Fort_Marigot': 4621,
       'GCS_Sainte_Anne': 4622,
       'GCS_CSG_1967': 4623,
       'GCS_RGFG_1995': 4624,
       'GCS_Fort_Desaix': 4625,
       'GCS_Reunion_1947': 4626,
       'GCS_RGR_1992': 4627,
       'GCS_Tahiti_1952': 4628,
       'GCS_Tahaa_1954': 4629,
       'GCS_IGN72_Nuku_Hiva': 4630,
       'GCS_K0_1949': 4631,
       'GCS_Combani_1950': 4632,
       'GCS_IGN56_Lifou': 4633,
       'GCS_Petrels_1972': 4636,
       'GCS_Pointe_Geologie_Perroud_1950': 4637,
       'GCS_Saint_Pierre_et_Miquelon_1950': 4638,
       'GCS_MOP78': 4639,
       'GCS_RRAF_1991': 4640,
       'GCS_IGN53_Mare': 4641,
       'GCS_ST84_Ile_des_Pins': 4642,
       'GCS_ST71_Belep': 4643,
       'GCS_NEA74_Noumea': 4644,
       'GCS_RGNC_1991': 4645,
       'GCS_Grand_Comoros': 4646,
       'GCS_Reykjavik_1900': 4657,
       'GCS_Hjorsey_1955': 4658,
       'GCS_ISN_1993': 4659,
       'GCS_Helle_1954': 4660,
       'GCS_LKS_1992': 4661,
       'GCS_IGN72_Grande_Terre': 4662,
       'GCS_Porto_Santo_1995': 4663,
       'GCS_Azores_Oriental_1995': 4664,
       'GCS_Azores_Central_1995': 4665,
       'GCS_Lisbon_1890': 4666,
       'GCS_IKBD_1992': 4667,
       'GCS_European_1979': 4668,
       'GCS_LKS_1994': 4669,
       'GCS_IGM_1995': 4670,
       'GCS_Voirol_1879': 4671,
       'GCS_Chatham_Island_1971': 4672,
       'GCS_Chatham_Islands_1979': 4673,
       'GCS_SIRGAS_2000': 4674,
       'GCS_Guam_1963': 4675,
       'GCS_Vientiane_1982': 4676,
       'GCS_Lao_1993': 4677,
       'GCS_Lao_1997': 4678,
       'GCS_Jouik_1961': 4679,
       'GCS_Nouakchott_1965': 4680,
       'GCS_Gulshan_303': 4682,
       'GCS_PRS_1992': 4683,
       'GCS_Gan_1970': 4684,
       'GCS_MAGNA': 4686,
       'GCS_RGPF': 4687,
       'GCS_Fatu_Iva_1972': 4688,
       'GCS_IGN63_Hiva_Oa': 4689,
       'GCS_Tahiti_1979': 4690,
       'GCS_Moorea_1987': 4691,
       'GCS_Maupiti_1983': 4692,
       'GCS_Nakhl-e_Ghanem': 4693,
       'GCS_POSGAR_1994': 4694,
       'GCS_Katanga_1955': 4695,
       'GCS_Kasai_1955': 4696,
       'GCS_IGC_1962_6th_Parallel_South': 4697,
       'GCS_Kerguelen_Island_1949': 4698,
       'GCS_Le_Pouce_1934': 4699,
       'GCS_IGN_Astro_1960': 4700,
       'GCS_IGCB_1955': 4701,
       'GCS_Mauritania_1999': 4702,
       'GCS_Mhast_1951': 4703,
       'GCS_Mhast_Onshore': 4704,
       'GCS_Mhast_Offshore': 4705,
       'GCS_Egypt_Gulf_of_Suez_S-650_TL': 4706,
       'GCS_Tern_Island_1961': 4707,
       'GCS_Anna_1_1965': 4708,
       'GCS_Beacon_E_1945': 4709,
       'GCS_DOS_71_4': 4710,
       'GCS_Astro_1952': 4711,
       'GCS_Ascension_Island_1958': 4712,
       'GCS_Ayabelle': 4713,
       'GCS_Bellevue_IGN': 4714,
       'GCS_Camp_Area': 4715,
       'GCS_Canton_1966': 4716,
       'GCS_Cape_Canaveral': 4717,
       'GCS_Solomon_1968': 4718,
       'GCS_Easter_Island_1967': 4719,
       'GCS_Fiji_1986': 4720,
       'GCS_Fiji_1956': 4721,
       'GCS_ISTS_061_1968': 4722,
       'GCS_Grand_Cayman_1959': 4723,
       'GCS_ISTS_073_1969': 4724,
       'GCS_Johnston_Island_1961': 4725,
       'GCS_Little_Cayman_1961': 4726,
       'GCS_Midway_1961': 4727,
       'GCS_Pico_de_Las_Nieves': 4728,
       'GCS_Pitcairn_1967': 4729,
       'GCS_Santo_DOS_1965': 4730,
       'GCS_Viti_Levu_1916': 4731,
       'GCS_Wake_Eniwetok_1960': 4732,
       'GCS_Wake_Island_1952': 4733,
       'GCS_Tristan_1968': 4734,
       'GCS_Kusaie_1951': 4735,
       'GCS_Deception_Island': 4736,
       'GCS_Korea_2000': 4737,
       'GCS_Hong_Kong_1963': 4738,
       'GCS_Hong_Kong_1963_67': 4739,
       'GCS_PZ_1990': 4740,
       'GCS_FD_1954': 4741,
       'GCS_GDM_2000': 4742,
       'GCS_Karbala_1979_Polservice': 4743,
       'GCS_Nahrwan_1934': 4744,
       'GCS_RD/83': 4745,
       'GCS_PD/83': 4746,
       'GCS_Greenland_1996': 4747,
       'GCS_Vanua_Levu_1915': 4748,
       'GCS_RGNC_1991-93': 4749,
       'GCS_ST87_Ouvea': 4750,
       'GCS_fk89': 4753,
       'GCS_LGD2006': 4754,
       'GCS_DGN_1995': 4755,
       'GCS_VN_2000': 4756,
       'GCS_SVY21': 4757,
       'GCS_JAD_2001': 4758,
       'GCS_NAD_1983_NSRS2007': 4759,
       'GCS_WGS_1966': 4760,
       'GCS_Bern_1898_Bern': 4801,
       'GCS_Bogota_Bogota': 4802,
       'GCS_Lisbon_Lisbon': 4803,
       'GCS_Makassar_Jakarta': 4804,
       'GCS_MGI_Ferro': 4805,
       'GCS_Monte_Mario_Rome': 4806,
       'GCS_NTF_Paris': 4807,
       'GCS_Padang_1884_Jakarta': 4808,
       'GCS_Belge_1950_Brussels': 4809,
       'GCS_Tananarive_1925_Paris': 4810,
       'GCS_Voirol_1875_Paris': 4811,
       'GCS_Voirol_Unifie_1960_Paris': 4812,
       'GCS_Batavia_Jakarta': 4813,
       'GCS_RT38_Stockholm': 4814,
       'GCS_Greek_Athens': 4815,
       'GCS_Carthage_Paris': 4816,
       'GCS_NGO_1948_Oslo': 4817,
       'GCS_S_JTSK_Ferro': 4818,
       'GCS_Nord_Sahara_1959_Paris': 4819,
       'GCS_Gunung_Segara_Jakarta': 4820,
       'GCS_Voirol_1879_Paris': 4821,
       'GCS_ITRF_2005': 4896,
       'GCS_ATF_Paris': 4901,
       'GCS_Nord_de_Guerre_Paris': 4902,
       'GCS_Madrid_1870_Madrid': 4903,
       'GCS_Lisbon_1890_Lisbon': 4904,
       'GCS_WGS_1966': 37001,
       'GCS_Fischer_1960': 37002,
       'GCS_Fischer_1968': 37003,
       'GCS_Fischer_Modified': 37004,
       'GCS_Hough_1960': 37005,
       'GCS_Everest_Modified_1969': 37006,
       'GCS_Walbeck': 37007,
       'GCS_Sphere_ARC_INFO': 37008,
       'GCS_European_1979': 37201,
       'GCS_Everest_Bangladesh': 37202,
       'GCS_Everest_India_Nepal': 37203,
       'GCS_Hjorsey_1955': 37204,
       'GCS_Hong_Kong_1963_67': 37205,
       'GCS_Oman': 37206,
       'GCS_South_Asia_Singapore': 37207,
       'GCS_Ayabelle': 37208,
       'GCS_Point_58': 37211,
       'GCS_Beacon_E_1945': 37212,
       'GCS_Tern_Island_1961': 37213,
       'GCS_Astro_1952': 37214,
       'GCS_Bellevue_IGN': 37215,
       'GCS_Canton_1966': 37216,
       'GCS_Chatham_Island_1971': 37217,
       'GCS_DOS_1968': 37218,
       'GCS_Easter_Island_1967': 37219,
       'GCS_Guam_1963': 37220,
       'GCS_GUX_1': 37221,
       'GCS_Johnston_Island_1961': 37222,
       'GCS_Carthage_Degree': 37223,
       'GCS_Midway_1961': 37224,
       'GCS_Pitcairn_1967': 37226,
       'GCS_Santo_DOS_1965': 37227,
       'GCS_Viti_Levu_1916': 37228,
       'GCS_Wake_Eniwetok_1960': 37229,
       'GCS_Wake_Island_1952': 37230,
       'GCS_Anna_1_1965': 37231,
       'GCS_Gan_1970': 37232,
       'GCS_ISTS_073_1969': 37233,
       'GCS_Kerguelen_Island_1949': 37234,
       'GCS_Reunion_1947': 37235,
       'GCS_Ascension_Island_1958': 37237,
       'GCS_DOS_71_4': 37238,
       'GCS_Cape_Canaveral': 37239,
       'GCS_Fort_Thomas_1955': 37240,
       'GCS_Graciosa_Base_SW_1948': 37241,
       'GCS_ISTS_061_1968': 37242,
       'GCS_LC5_1961': 37243,
       'GCS_Observ_Meteorologico_1939': 37245,
       'GCS_Pico_de_Las_Nieves': 37246,
       'GCS_Porto_Santo_1936': 37247,
       'GCS_Sao_Braz': 37249,
       'GCS_Selvagem_Grande_1938': 37250,
       'GCS_Tristan_1968': 37251,
       'GCS_American_Samoa_1962': 37252,
       'GCS_Camp_Area': 37253,
       'GCS_Deception_Island': 37254,
       'GCS_Gunung_Segara': 37255,
       'GCS_S42_Hungary': 37257,
       'GCS_Kusaie_1951': 37259,
       'GCS_Alaskan_Islands': 37260,
       'GCS_Assumed_Geographic_1': 104000,
       'GCS_Estonia_1937': 104101,
       'GCS_Hermannskogel': 104102,
       'GCS_Sierra_Leone_1960': 104103,
       'GCS_Hong_Kong_1980': 104104,
       'GCS_Datum_Lisboa_Bessel': 104105,
       'GCS_Datum_Lisboa_Hayford': 104106,
       'GCS_RGF_1993': 104107,
       'GCS_NZGD_2000': 104108,
       'GCS_Pohnpei': 104109,
       'GCS_REGVEN': 104110,
       'GCS_JGD_2000': 104111,
       'GCS_Bab_South': 104112,
       'GCS_Majuro': 104113,
       'GCS_Bermuda_2000': 104114,
       'GCS_ITRF_1988': 104115,
       'GCS_ITRF_1989': 104116,
       'GCS_ITRF_1990': 104117,
       'GCS_ITRF_1991': 104118,
       'GCS_ITRF_1992': 104119,
       'GCS_ITRF_1993': 104120,
       'GCS_ITRF_1994': 104121,
       'GCS_ITRF_1996': 104122,
       'GCS_ITRF_1997': 104123,
       'GCS_ITRF_2000': 104124,
       'GCS_Chatham_Islands_1979': 104125,
       'GCS_Observatorio_Meteorologico_1965': 104126,
       'GCS_Roma_1940': 104127,
       'GCS_Sphere_EMEP': 104128,
       'GCS_EUREF_FIN': 104129,
       'GCS_Jordan': 104130,
       'GCS_D48': 104131,
       'GCS_Ocotepeque_1935': 104132,
       'GCS_JAD_2001': 104133,
       'GCS_MONREF_1997': 104134,
       'GCS_MSK_1942': 104135,
       'GCS_TWD_1967': 104136,
       'GCS_TWD_1997': 104137,
       'GCS_WGS_1984_Major_Auxiliary_Sphere': 104199,
       'GCS_ETRF_1989': 104258,
       'GCS_Merchich_Degree': 104261,
       'GCS_Voirol_1875_Degree': 104304,
       'GCS_Voirol_Unifie_1960_Degree': 104305,
       'GCS_NAD_1983_HARN_Adj_MN_Anoka': 104700,
       'GCS_NAD_1983_HARN_Adj_MN_Becker': 104701,
       'GCS_NAD_1983_HARN_Adj_MN_Beltrami_North': 104702,
       'GCS_NAD_1983_HARN_Adj_MN_Beltrami_South': 104703,
       'GCS_NAD_1983_HARN_Adj_MN_Benton': 104704,
       'GCS_NAD_1983_HARN_Adj_MN_Big_Stone': 104705,
       'GCS_NAD_1983_HARN_Adj_MN_Blue_Earth': 104706,
       'GCS_NAD_1983_HARN_Adj_MN_Brown': 104707,
       'GCS_NAD_1983_HARN_Adj_MN_Carlton': 104708,
       'GCS_NAD_1983_HARN_Adj_MN_Carver': 104709,
       'GCS_NAD_1983_HARN_Adj_MN_Cass_North': 104710,
       'GCS_NAD_1983_HARN_Adj_MN_Cass_South': 104711,
       'GCS_NAD_1983_HARN_Adj_MN_Chippewa': 104712,
       'GCS_NAD_1983_HARN_Adj_MN_Chisago': 104713,
       'GCS_NAD_1983_HARN_Adj_MN_Cook_North': 104714,
       'GCS_NAD_1983_HARN_Adj_MN_Cook_South': 104715,
       'GCS_NAD_1983_HARN_Adj_MN_Cottonwood': 104716,
       'GCS_NAD_1983_HARN_Adj_MN_Crow_Wing': 104717,
       'GCS_NAD_1983_HARN_Adj_MN_Dakota': 104718,
       'GCS_NAD_1983_HARN_Adj_MN_Dodge': 104719,
       'GCS_NAD_1983_HARN_Adj_MN_Douglas': 104720,
       'GCS_NAD_1983_HARN_Adj_MN_Faribault': 104721,
       'GCS_NAD_1983_HARN_Adj_MN_Fillmore': 104722,
       'GCS_NAD_1983_HARN_Adj_MN_Freeborn': 104723,
       'GCS_NAD_1983_HARN_Adj_MN_Goodhue': 104724,
       'GCS_NAD_1983_HARN_Adj_MN_Grant': 104725,
       'GCS_NAD_1983_HARN_Adj_MN_Hennepin': 104726,
       'GCS_NAD_1983_HARN_Adj_MN_Houston': 104727,
       'GCS_NAD_1983_HARN_Adj_MN_Isanti': 104728,
       'GCS_NAD_1983_HARN_Adj_MN_Itasca_North': 104729,
       'GCS_NAD_1983_HARN_Adj_MN_Itasca_South': 104730,
       'GCS_NAD_1983_HARN_Adj_MN_Jackson': 104731,
       'GCS_NAD_1983_HARN_Adj_MN_Kanabec': 104732,
       'GCS_NAD_1983_HARN_Adj_MN_Kandiyohi': 104733,
       'GCS_NAD_1983_HARN_Adj_MN_Kittson': 104734,
       'GCS_NAD_1983_HARN_Adj_MN_Koochiching': 104735,
       'GCS_NAD_1983_HARN_Adj_MN_Lac_Qui_Parle': 104736,
       'GCS_NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_North': 104737,
       'GCS_NAD_1983_HARN_Adj_MN_Lake_of_the_Woods_South': 104738,
       'GCS_NAD_1983_HARN_Adj_MN_Le_Sueur': 104739,
       'GCS_NAD_1983_HARN_Adj_MN_Lincoln': 104740,
       'GCS_NAD_1983_HARN_Adj_MN_Lyon': 104741,
       'GCS_NAD_1983_HARN_Adj_MN_McLeod': 104742,
       'GCS_NAD_1983_HARN_Adj_MN_Mahnomen': 104743,
       'GCS_NAD_1983_HARN_Adj_MN_Marshall': 104744,
       'GCS_NAD_1983_HARN_Adj_MN_Martin': 104745,
       'GCS_NAD_1983_HARN_Adj_MN_Meeker': 104746,
       'GCS_NAD_1983_HARN_Adj_MN_Morrison': 104747,
       'GCS_NAD_1983_HARN_Adj_MN_Mower': 104748,
       'GCS_NAD_1983_HARN_Adj_MN_Murray': 104749,
       'GCS_NAD_1983_HARN_Adj_MN_Nicollet': 104750,
       'GCS_NAD_1983_HARN_Adj_MN_Nobles': 104751,
       'GCS_NAD_1983_HARN_Adj_MN_Norman': 104752,
       'GCS_NAD_1983_HARN_Adj_MN_Olmsted': 104753,
       'GCS_NAD_1983_HARN_Adj_MN_Ottertail': 104754,
       'GCS_NAD_1983_HARN_Adj_MN_Pennington': 104755,
       'GCS_NAD_1983_HARN_Adj_MN_Pine': 104756,
       'GCS_NAD_1983_HARN_Adj_MN_Pipestone': 104757,
       'GCS_NAD_1983_HARN_Adj_MN_Polk': 104758,
       'GCS_NAD_1983_HARN_Adj_MN_Pope': 104759,
       'GCS_NAD_1983_HARN_Adj_MN_Ramsey': 104760,
       'GCS_NAD_1983_HARN_Adj_MN_Red_Lake': 104761,
       'GCS_NAD_1983_HARN_Adj_MN_Redwood': 104762,
       'GCS_NAD_1983_HARN_Adj_MN_Renville': 104763,
       'GCS_NAD_1983_HARN_Adj_MN_Rice': 104764,
       'GCS_NAD_1983_HARN_Adj_MN_Rock': 104765,
       'GCS_NAD_1983_HARN_Adj_MN_Roseau': 104766,
       'GCS_NAD_1983_HARN_Adj_MN_St_Louis_North': 104767,
       'GCS_NAD_1983_HARN_Adj_MN_St_Louis_Central': 104768,
       'GCS_NAD_1983_HARN_Adj_MN_St_Louis_South': 104769,
       'GCS_NAD_1983_HARN_Adj_MN_Scott': 104770,
       'GCS_NAD_1983_HARN_Adj_MN_Sherburne': 104771,
       'GCS_NAD_1983_HARN_Adj_MN_Sibley': 104772,
       'GCS_NAD_1983_HARN_Adj_MN_Stearns': 104773,
       'GCS_NAD_1983_HARN_Adj_MN_Steele': 104774,
       'GCS_NAD_1983_HARN_Adj_MN_Stevens': 104775,
       'GCS_NAD_1983_HARN_Adj_MN_Swift': 104776,
       'GCS_NAD_1983_HARN_Adj_MN_Todd': 104777,
       'GCS_NAD_1983_HARN_Adj_MN_Traverse': 104778,
       'GCS_NAD_1983_HARN_Adj_MN_Wabasha': 104779,
       'GCS_NAD_1983_HARN_Adj_MN_Wadena': 104780,
       'GCS_NAD_1983_HARN_Adj_MN_Waseca': 104781,
       'GCS_NAD_1983_HARN_Adj_MN_Watonwan': 104782,
       'GCS_NAD_1983_HARN_Adj_MN_Winona': 104783,
       'GCS_NAD_1983_HARN_Adj_MN_Wright': 104784,
       'GCS_NAD_1983_HARN_Adj_MN_Yellow_Medicine': 104785,
       'GCS_NAD_1983_HARN_Adj_WI_Adams': 104800,
       'GCS_NAD_1983_HARN_Adj_WI_Ashland': 104801,
       'GCS_NAD_1983_HARN_Adj_WI_Barron': 104802,
       'GCS_NAD_1983_HARN_Adj_WI_Bayfield': 104803,
       'GCS_NAD_1983_HARN_Adj_WI_Brown': 104804,
       'GCS_NAD_1983_HARN_Adj_WI_Buffalo': 104805,
       'GCS_NAD_1983_HARN_Adj_WI_Burnett': 104806,
       'GCS_NAD_1983_HARN_Adj_WI_Calumet': 104807,
       'GCS_NAD_1983_HARN_Adj_WI_Chippewa': 104808,
       'GCS_NAD_1983_HARN_Adj_WI_Clark': 104809,
       'GCS_NAD_1983_HARN_Adj_WI_Columbia': 104810,
       'GCS_NAD_1983_HARN_Adj_WI_Crawford': 104811,
       'GCS_NAD_1983_HARN_Adj_WI_Dane': 104812,
       'GCS_NAD_1983_HARN_Adj_WI_Dodge': 104813,
       'GCS_NAD_1983_HARN_Adj_WI_Door': 104814,
       'GCS_NAD_1983_HARN_Adj_WI_Douglas': 104815,
       'GCS_NAD_1983_HARN_Adj_WI_Dunn': 104816,
       'GCS_NAD_1983_HARN_Adj_WI_EauClaire': 104817,
       'GCS_NAD_1983_HARN_Adj_WI_Florence': 104818,
       'GCS_NAD_1983_HARN_Adj_WI_FondduLac': 104819,
       'GCS_NAD_1983_HARN_Adj_WI_Forest': 104820,
       'GCS_NAD_1983_HARN_Adj_WI_Grant': 104821,
       'GCS_NAD_1983_HARN_Adj_WI_Green': 104822,
       'GCS_NAD_1983_HARN_Adj_WI_GreenLake': 104823,
       'GCS_NAD_1983_HARN_Adj_WI_Iowa': 104824,
       'GCS_NAD_1983_HARN_Adj_WI_Iron': 104825,
       'GCS_NAD_1983_HARN_Adj_WI_Jackson': 104826,
       'GCS_NAD_1983_HARN_Adj_WI_Jefferson': 104827,
       'GCS_NAD_1983_HARN_Adj_WI_Juneau': 104828,
       'GCS_NAD_1983_HARN_Adj_WI_Kenosha': 104829,
       'GCS_NAD_1983_HARN_Adj_WI_Kewaunee': 104830,
       'GCS_NAD_1983_HARN_Adj_WI_LaCrosse': 104831,
       'GCS_NAD_1983_HARN_Adj_WI_Lafayette': 104832,
       'GCS_NAD_1983_HARN_Adj_WI_Langlade': 104833,
       'GCS_NAD_1983_HARN_Adj_WI_Lincoln': 104834,
       'GCS_NAD_1983_HARN_Adj_WI_Manitowoc': 104835,
       'GCS_NAD_1983_HARN_Adj_WI_Marathon': 104836,
       'GCS_NAD_1983_HARN_Adj_WI_Marinette': 104837,
       'GCS_NAD_1983_HARN_Adj_WI_Marquette': 104838,
       'GCS_NAD_1983_HARN_Adj_WI_Menominee': 104839,
       'GCS_NAD_1983_HARN_Adj_WI_Milwaukee': 104840,
       'GCS_NAD_1983_HARN_Adj_WI_Monroe': 104841,
       'GCS_NAD_1983_HARN_Adj_WI_Oconto': 104842,
       'GCS_NAD_1983_HARN_Adj_WI_Oneida': 104843,
       'GCS_NAD_1983_HARN_Adj_WI_Outagamie': 104844,
       'GCS_NAD_1983_HARN_Adj_WI_Ozaukee': 104845,
       'GCS_NAD_1983_HARN_Adj_WI_Pepin': 104846,
       'GCS_NAD_1983_HARN_Adj_WI_Pierce': 104847,
       'GCS_NAD_1983_HARN_Adj_WI_Polk': 104848,
       'GCS_NAD_1983_HARN_Adj_WI_Portage': 104849,
       'GCS_NAD_1983_HARN_Adj_WI_Price': 104850,
       'GCS_NAD_1983_HARN_Adj_WI_Racine': 104851,
       'GCS_NAD_1983_HARN_Adj_WI_Richland': 104852,
       'GCS_NAD_1983_HARN_Adj_WI_Rock': 104853,
       'GCS_NAD_1983_HARN_Adj_WI_Rusk': 104854,
       'GCS_NAD_1983_HARN_Adj_WI_StCroix': 104855,
       'GCS_NAD_1983_HARN_Adj_WI_Sauk': 104856,
       'GCS_NAD_1983_HARN_Adj_WI_Sawyer': 104857,
       'GCS_NAD_1983_HARN_Adj_WI_Shawano': 104858,
       'GCS_NAD_1983_HARN_Adj_WI_Sheboygan': 104859,
       'GCS_NAD_1983_HARN_Adj_WI_Taylor': 104860,
       'GCS_NAD_1983_HARN_Adj_WI_Trempealeau': 104861,
       'GCS_NAD_1983_HARN_Adj_WI_Vernon': 104862,
       'GCS_NAD_1983_HARN_Adj_WI_Vilas': 104863,
       'GCS_NAD_1983_HARN_Adj_WI_Walworth': 104864,
       'GCS_NAD_1983_HARN_Adj_WI_Washburn': 104865,
       'GCS_NAD_1983_HARN_Adj_WI_Washington': 104866,
       'GCS_NAD_1983_HARN_Adj_WI_Waukesha': 104867,
       'GCS_NAD_1983_HARN_Adj_WI_Waupaca': 104868,
       'GCS_NAD_1983_HARN_Adj_WI_Waushara': 104869,
       'GCS_NAD_1983_HARN_Adj_WI_Winnebago': 104870,
       'GCS_NAD_1983_HARN_Adj_WI_Wood': 104871,
       'GCS_Mercury_2000': 104900,
       'GCS_Venus_1985': 104901,
       'GCS_Venus_2000': 104902,
       'GCS_Moon_2000': 104903,
       'GCS_Mars_1979': 104904,
       'GCS_Mars_2000': 104905,
       'GCS_Deimos_2000': 104906,
       'GCS_Phobos_2000': 104907,
       'GCS_Jupiter_2000': 104908,
       'GCS_Adrastea_2000': 104909,
       'GCS_Amalthea_2000': 104910,
       'GCS_Ananke_2000': 104911,
       'GCS_Callisto_2000': 104912,
       'GCS_Carme_2000': 104913,
       'GCS_Elara_2000': 104914,
       'GCS_Europa_2000': 104915,
       'GCS_Ganymede_2000': 104916,
       'GCS_Himalia_2000': 104917,
       'GCS_Io_2000': 104918,
       'GCS_Leda_2000': 104919,
       'GCS_Lysithea_2000': 104920,
       'GCS_Metis_2000': 104921,
       'GCS_Pasiphae_2000': 104922,
       'GCS_Sinope_2000': 104923,
       'GCS_Thebe_2000': 104924,
       'GCS_Saturn_2000': 104925,
       'GCS_Atlas_2000': 104926,
       'GCS_Calypso_2000': 104927,
       'GCS_Dione_2000': 104928,
       'GCS_Enceladus_2000': 104929,
       'GCS_Epimetheus_2000': 104930,
       'GCS_Helene_2000': 104931,
       'GCS_Hyperion_2000': 104932,
       'GCS_Iapetus_2000': 104933,
       'GCS_Janus_2000': 104934,
       'GCS_Mimas_2000': 104935,
       'GCS_Pan_2000': 104936,
       'GCS_Pandora_2000': 104937,
       'GCS_Phoebe_2000': 104938,
       'GCS_Prometheus_2000': 104939,
       'GCS_Rhea_2000': 104940,
       'GCS_Telesto_2000': 104941,
       'GCS_Tethys_2000': 104942,
       'GCS_Titan_2000': 104943,
       'GCS_Uranus_2000': 104944,
       'GCS_Ariel_2000': 104945,
       'GCS_Belinda_2000': 104946,
       'GCS_Bianca_2000': 104947,
       'GCS_Cordelia_2000': 104948,
       'GCS_Cressida_2000': 104949,
       'GCS_Desdemona_2000': 104950,
       'GCS_Juliet_2000': 104951,
       'GCS_Miranda_2000': 104952,
       'GCS_Oberon_2000': 104953,
       'GCS_Ophelia_2000': 104954,
       'GCS_Portia_2000': 104955,
       'GCS_Puck_2000': 104956,
       'GCS_Rosalind_2000': 104957,
       'GCS_Titania_2000': 104958,
       'GCS_Umbriel_2000': 104959,
       'GCS_Neptune_2000': 104960,
       'GCS_Despina_2000': 104961,
       'GCS_Galatea_2000': 104962,
       'GCS_Larissa_2000': 104963,
       'GCS_Naiad_2000': 104964,
       'GCS_Nereid_2000': 104965,
       'GCS_Proteus_2000': 104966,
       'GCS_Thalassa_2000': 104967,
       'GCS_Triton_2000': 104968,
       'GCS_Pluto_2000': 104969,
       'GCS_Charon_2000': 104970
    }

geographic = geographic()
projected = projected()
