/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.sp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.snu.ids.ha.constants.POSTag;
import org.snu.ids.ha.ma.Eojeol;
import org.snu.ids.ha.ma.Sentence;
import org.snu.ids.ha.sp.ParseGrammar;
import org.snu.ids.ha.sp.ParseTree;
import org.snu.ids.ha.sp.ParseTreeEdge;
import org.snu.ids.ha.sp.ParseTreeNode;

public class Parser {
    private List<ParseGrammar> grammarList = null;
    private static Parser parser = null;

    public static Parser getInstance() {
        if (parser == null) {
            parser = new Parser();
        }
        return parser;
    }

    public Parser() {
        this.initGrammars();
    }

    protected void initGrammars() {
        this.grammarList = new ArrayList<ParseGrammar>();
        this.grammarList.add(new ParseGrammar("\uc774\uc720", "\uae30", POSTag.ETN, "\ub54c\ubb38", POSTag.NNB, 1, 1));
        this.grammarList.add(new ParseGrammar("\ub3d9\uc77c", POSTag.N | POSTag.XSN, POSTag.NP, 1, 2));
        this.grammarList.add(new ParseGrammar("\uba85\uc0ac\uad6c", POSTag.N | POSTag.XSN, POSTag.N | POSTag.XPN, 1, 2));
        this.grammarList.add(new ParseGrammar("\ubd80\uc0ac\uc5b4", POSTag.JKM, POSTag.VP | POSTag.XPV, 1, 2));
        this.grammarList.add(new ParseGrammar("\ubd80\uc0ac\uc5b4", POSTag.JKM, POSTag.VP | POSTag.XPV, 10, 10));
        this.grammarList.add(new ParseGrammar("\uc218\uc2dd", POSTag.MD | POSTag.ETD | POSTag.JKG, POSTag.N | POSTag.XPN, 1, 2));
        this.grammarList.add(new ParseGrammar("\uc218\uc2dd", POSTag.MD | POSTag.ETD | POSTag.JKG, POSTag.N | POSTag.XPN, 3, 10));
        this.grammarList.add(new ParseGrammar("\uc218\uc2dd", POSTag.MAG, POSTag.VP | POSTag.MAG | POSTag.MD, 1, 2));
        this.grammarList.add(new ParseGrammar("\uc218\uc2dd", POSTag.MAG, POSTag.VP | POSTag.MAG | POSTag.MD, 10, 10));
        this.grammarList.add(new ParseGrammar("\ubcf4\uc870 \uc5f0\uacb0", POSTag.ECS, POSTag.VP, 1, 2));
        this.grammarList.add(new ParseGrammar("\uc758\uc874 \uc5f0\uacb0", POSTag.ECD, POSTag.VP, 10, 2));
        this.grammarList.add(new ParseGrammar("\ub300\ub4f1 \uc5f0\uacb0", POSTag.ECE, POSTag.VP, 10, 2));
        this.grammarList.add(new ParseGrammar("\uccb4\uc5b8 \uc5f0\uacb0", POSTag.JC, POSTag.N | POSTag.XPN, 1, 2));
        this.grammarList.add(new ParseGrammar("\uc8fc\uc5b4", POSTag.JKS, POSTag.VP, 10, 2));
        this.grammarList.add(new ParseGrammar("\uc8fc\uc5b4", POSTag.N | POSTag.XSN | POSTag.JKS | POSTag.JX, POSTag.VCP, 10, 10));
        this.grammarList.add(new ParseGrammar("\ubcf4\uc5b4", POSTag.JKC | POSTag.JX, POSTag.VCN, 3, 10));
        this.grammarList.add(new ParseGrammar("\ubaa9\uc801\uc5b4", POSTag.JKO, POSTag.VP, 10, 2));
        this.grammarList.add(new ParseGrammar("(\uc8fc\uc5b4,\ubaa9\uc801)\ub300\uc0c1", POSTag.N | POSTag.XSN | POSTag.JX | POSTag.ETN, POSTag.VP | POSTag.XPV, 10, 100));
        this.grammarList.add(new ParseGrammar("\uc778\uc6a9", POSTag.JKQ, POSTag.VV, 1, 2));
        Collections.sort(this.grammarList, new Comparator<ParseGrammar>(){

            @Override
            public int compare(ParseGrammar arg0, ParseGrammar arg1) {
                return arg0.priority - arg1.priority;
            }
        });
    }

    public ParseTree parse(Sentence sentence) {
        ArrayList<ParseTreeNode> nodeList = new ArrayList<ParseTreeNode>();
        Iterator itr = sentence.iterator();
        while (itr.hasNext()) {
            nodeList.add(new ParseTreeNode((Eojeol)itr.next()));
        }
        int i = 0;
        while (i < nodeList.size() - 1) {
            ParseTreeNode ptnPrev = (ParseTreeNode)nodeList.get(i);
            int j = i + 1;
            while (j < nodeList.size()) {
                ParseTreeNode ptnNext = (ParseTreeNode)nodeList.get(j);
                ParseTreeEdge arc = this.dominate(ptnPrev, ptnNext, j - i);
                if (arc != null) {
                    ptnNext.addChildEdge(arc);
                    ptnPrev.setParentNode(ptnNext);
                    break;
                }
                ++j;
            }
            ++i;
        }
        ParseTree tree = new ParseTree();
        tree.setSentenec(sentence.getSentence());
        for (ParseTreeNode ptn : nodeList) {
            if (ptn.getParentNode() != null) continue;
            tree.setRoot(ptn);
        }
        tree.setId();
        tree.setAllList();
        return tree;
    }

    public ParseTreeEdge dominate(ParseTreeNode ptnPrev, ParseTreeNode ptnNext, int distance) {
        ParseTreeEdge arc = null;
        int i = 0;
        int size = this.grammarList.size();
        while (i < size) {
            arc = this.grammarList.get(i).dominate(ptnPrev, ptnNext, distance);
            if (arc != null) {
                return arc;
            }
            ++i;
        }
        return null;
    }
}

