/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.ma;

import java.util.StringTokenizer;
import org.snu.ids.ha.constants.Condition;
import org.snu.ids.ha.constants.POSTag;
import org.snu.ids.ha.ma.CharSetType;
import org.snu.ids.ha.ma.Morpheme;

public class MorphemeSpace
extends Morpheme {
    long atlEnc = 0L;
    long hclEnc = 0L;
    long cclEnc = 0L;
    long bclEnc = 0L;
    long eclEnc = 0L;

    protected MorphemeSpace() {
        super(" ", 0);
        this.charSet = CharSetType.SPACE;
        this.infoEnc = POSTag.SW;
    }

    MorphemeSpace(String source) {
        this();
        String[] arr = source.split("/");
        if (arr.length > 1) {
            StringTokenizer st = new StringTokenizer(arr[1], "*#&@\uffe2%", true);
            String token = null;
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equals("#")) {
                    token = st.nextToken().trim();
                    token = token.substring(1, token.length() - 1);
                    this.atlEnc = POSTag.getTagNum(token.split(","));
                    continue;
                }
                if (token.equals("&")) {
                    token = st.nextToken().trim();
                    token = token.substring(1, token.length() - 1);
                    this.hclEnc = Condition.getCondNum(token.split(","));
                    continue;
                }
                if (token.equals("@")) {
                    token = st.nextToken().trim();
                    token = token.substring(1, token.length() - 1);
                    this.cclEnc = Condition.getCondNum(token.split(","));
                    continue;
                }
                if (!token.equals("\uffe2")) continue;
                token = st.nextToken().trim();
                token = token.substring(1, token.length() - 1);
                this.eclEnc = Condition.getCondNum(token.split(","));
            }
        }
    }

    MorphemeSpace(long atlEnc, long hclEnc, long bclEnc, long cclEnc, long eclEnc) {
        this();
        this.charSet = CharSetType.SPACE;
        this.infoEnc = POSTag.SW;
        this.atlEnc = atlEnc;
        this.hclEnc = hclEnc;
        this.bclEnc = bclEnc;
        this.cclEnc = cclEnc;
        this.eclEnc = eclEnc;
    }

    @Override
    public String toString() {
        return " ";
    }

    public String getToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.string) + "/");
        String temp = POSTag.getTagStr(this.atlEnc);
        if (temp != null) {
            sb.append("#(" + temp + ")");
        }
        if ((temp = Condition.getCondStr(this.hclEnc)) != null) {
            sb.append("&(" + temp + ")");
        }
        if ((temp = Condition.getCondStr(this.cclEnc)) != null) {
            sb.append("@(" + temp + ")");
        }
        if ((temp = Condition.getCondStr(this.eclEnc)) != null) {
            sb.append("\uffe2(" + temp + ")");
        }
        return sb.toString();
    }

    @Override
    public Morpheme copy() {
        return new MorphemeSpace(this.atlEnc, this.hclEnc, this.bclEnc, this.cclEnc, this.eclEnc);
    }
}

