/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.dic;

import java.util.ArrayList;
import java.util.Hashtable;
import org.snu.ids.ha.constants.POSTag;
import org.snu.ids.ha.dic.ProbDicReader;
import org.snu.ids.ha.ma.Morpheme;
import org.snu.ids.ha.util.Timer;
import org.snu.ids.ha.util.Util;

public final class PDDictionary {
    private static final Hashtable<Long, Float> LNPR_POS = new Hashtable(50);
    private static final Hashtable<String, Float> LNPR_MORP = new Hashtable(80000);
    private static final Hashtable<String, Float> LNPR_POS_G_EXP = new Hashtable(70000);
    private static final Hashtable<String, Float> LNPR_POS_G_MORP_INTRA = new Hashtable(60000);
    private static final Hashtable<String, Float> LNPR_POS_G_MORP_INTER = new Hashtable(520000);
    private static final float MIN_LNPR_POS = -9.0f;
    private static final float MIN_LNPR_MORP = -18.0f;

    static {
        System.out.println("Prob Dic Loading!");
        Timer timer = new Timer();
        timer.start();
        PDDictionary.loadLnprPos("/dic/prob/lnpr_pos.dic");
        System.out.println(String.valueOf(LNPR_POS.size()) + " loaded!");
        PDDictionary.loadLnprMorp("/dic/prob/lnpr_morp.dic");
        System.out.println(String.valueOf(LNPR_MORP.size()) + " loaded!");
        PDDictionary.loadLnprPosGExp("/dic/prob/lnpr_pos_g_exp.dic");
        System.out.println(String.valueOf(LNPR_POS_G_EXP.size()) + " loaded!");
        PDDictionary.loadLnprPosGMorp("/dic/prob/lnpr_pos_g_morp_intra.dic", LNPR_POS_G_MORP_INTRA);
        System.out.println(String.valueOf(LNPR_POS_G_MORP_INTRA.size()) + " loaded!");
        PDDictionary.loadLnprPosGMorp("/dic/prob/lnpr_pos_g_morp_inter.dic", LNPR_POS_G_MORP_INTER);
        System.out.println(String.valueOf(LNPR_POS_G_MORP_INTER.size()) + " loaded!");
        timer.stop();
        System.out.println("(Loading time : " + timer.getInterval() + " secs!");
    }

    private static final void loadLnprPos(String fileName) {
        ProbDicReader dr = null;
        try {
            dr = new ProbDicReader(fileName);
            String[] arr = null;
            while ((arr = dr.read()) != null) {
                long pos = POSTag.getTagNum(arr[0]);
                float lnpr = Float.parseFloat(arr[1]);
                LNPR_POS.put(pos, Float.valueOf(lnpr));
            }
            dr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(dr.line);
            System.err.println("Loading error: " + fileName);
        }
    }

    private static final void loadLnprMorp(String fileName) {
        ProbDicReader dr = null;
        try {
            dr = new ProbDicReader(fileName);
            String[] arr = null;
            while ((arr = dr.read()) != null) {
                String exp = arr[0];
                long pos = POSTag.getTagNum(arr[1]);
                float lnpr = Float.parseFloat(arr[2]);
                LNPR_MORP.put(String.valueOf(exp) + ":" + pos, Float.valueOf(lnpr));
            }
            dr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(dr.line);
            System.err.println("Loading error: " + fileName);
        }
    }

    private static final void loadLnprPosGExp(String fileName) {
        ProbDicReader dr = null;
        try {
            dr = new ProbDicReader(fileName);
            String[] arr = null;
            while ((arr = dr.read()) != null) {
                String exp = arr[0];
                long pos = POSTag.getTagNum(arr[1]);
                float lnpr = Float.parseFloat(arr[2]);
                LNPR_POS_G_EXP.put(String.valueOf(pos) + "|" + exp, Float.valueOf(lnpr));
            }
            dr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(dr.line);
            System.err.println("Loading error: " + fileName);
        }
    }

    private static final void loadLnprPosGMorp(String fileName, Hashtable<String, Float> probMap) {
        ProbDicReader dr = null;
        try {
            dr = new ProbDicReader(fileName);
            String[] arr = null;
            while ((arr = dr.read()) != null) {
                long prevPos;
                if (arr.length == 4) {
                    prevPos = POSTag.getTagNum(arr[0]);
                    String exp = arr[1];
                    long pos = POSTag.getTagNum(arr[2]);
                    float lnpr = Float.parseFloat(arr[3]);
                    probMap.put(PDDictionary.getKey(prevPos, exp, pos), Float.valueOf(lnpr));
                    continue;
                }
                if (arr.length != 3) continue;
                prevPos = POSTag.getTagNum(arr[0]);
                long pos = POSTag.getTagNum(arr[1]);
                float lnpr = Float.parseFloat(arr[2]);
                probMap.put(PDDictionary.getKey(prevPos, null, pos), Float.valueOf(lnpr));
            }
            dr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(dr.line);
            System.err.println("Loading error: " + fileName);
        }
    }

    static final String getKey(long prevPos, String exp, long pos) {
        return String.valueOf(prevPos) + "|" + exp + ":" + pos;
    }

    public static float getLnprPos(long pos) {
        Float lnpr = LNPR_POS.get(PDDictionary.getPrTag(pos));
        if (lnpr == null) {
            return -9.0f;
        }
        return lnpr.floatValue();
    }

    private static float getLnprMorp(String exp, long pos) {
        Float lnpr = LNPR_MORP.get(String.valueOf(exp) + ":" + PDDictionary.getPrTag(pos));
        if (lnpr == null) {
            return -18.0f;
        }
        return lnpr.floatValue();
    }

    public static float getLnprPosGExp(String exp, long pos) {
        Float lnpr = LNPR_POS_G_EXP.get(String.valueOf(PDDictionary.getPrTag(pos)) + "|" + exp);
        if (lnpr == null) {
            return PDDictionary.getLnprPos(pos);
        }
        return lnpr.floatValue();
    }

    public static float getLnprPosGMorpIntra(long prevPos, String exp, long pos) {
        return PDDictionary.getLnprPosGMorp(LNPR_POS_G_MORP_INTRA, prevPos, exp, pos);
    }

    public static float getLnprPosGMorpInter(long prevPos, String exp, long pos) {
        return PDDictionary.getLnprPosGMorp(LNPR_POS_G_MORP_INTER, prevPos, exp, pos);
    }

    private static float getLnprPosGMorp(Hashtable<String, Float> lnprMap, long prevPos, String exp, long pos) {
        Float lnpr = lnprMap.get(PDDictionary.getKey(PDDictionary.getPrTag(prevPos), exp, PDDictionary.getPrTag(pos)));
        if (lnpr == null && PDDictionary.getLnprMorp(exp, pos) < -14.0f) {
            lnpr = lnprMap.get(PDDictionary.getKey(PDDictionary.getPrTag(prevPos), null, PDDictionary.getPrTag(pos)));
        }
        if (lnpr == null) {
            return -18.0f;
        }
        return lnpr.floatValue();
    }

    public static long getPrTag(long tag) {
        if (((POSTag.NNA | POSTag.UN) & tag) > 0L) {
            return POSTag.NNA;
        }
        if (((POSTag.NNM | POSTag.NNB) & tag) > 0L) {
            return POSTag.NNB;
        }
        if ((POSTag.VX & tag) > 0L) {
            return POSTag.VX;
        }
        if ((POSTag.MD & tag) > 0L) {
            return POSTag.MD;
        }
        if ((POSTag.EP & tag) > 0L) {
            return POSTag.EP;
        }
        if ((POSTag.EF & tag) > 0L) {
            return POSTag.EF;
        }
        if ((POSTag.EC & tag) > 0L) {
            return POSTag.EC;
        }
        return tag;
    }

    public static float getLnpr(String morps) {
        float lnpr = 0.0f;
        String[] arr = morps.trim().split("[+]");
        ArrayList<Morpheme> mpList = new ArrayList<Morpheme>();
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String temp = stringArray[n2];
            if (temp.equals(" ")) {
                mpList.add(new Morpheme(" ", POSTag.S));
            } else {
                String[] arr2 = temp.split("[/]");
                mpList.add(new Morpheme(arr2[1], POSTag.getTagNum(arr2[2])));
            }
            ++n2;
        }
        Morpheme preMp = null;
        boolean spacing = false;
        System.out.println(morps);
        for (Morpheme curMp : mpList) {
            if (curMp.getString().equals(" ")) {
                spacing = true;
                continue;
            }
            float lnprPosGExp = PDDictionary.getLnprPosGExp(curMp.getString(), curMp.getTagNum());
            float lnprPosGMorp = 0.0f;
            float lnprPos = 0.0f;
            if (preMp != null) {
                lnprPosGMorp = spacing ? PDDictionary.getLnprPosGMorpInter(preMp.getTagNum(), curMp.getString(), curMp.getTagNum()) : PDDictionary.getLnprPosGMorpIntra(preMp.getTagNum(), curMp.getString(), curMp.getTagNum());
                lnprPos = PDDictionary.getLnprPos(preMp.getTagNum());
            }
            lnpr += lnprPosGExp;
            lnpr += lnprPosGMorp;
            System.out.println("\t" + Util.getTabbedString(curMp.getSmplStr(), 4, 8) + String.format("%10.3f%10s%10.3f%10.3f", Float.valueOf(lnprPosGExp), spacing, Float.valueOf(lnprPosGMorp), Float.valueOf(lnprPos)));
            spacing = false;
            preMp = curMp;
        }
        return lnpr;
    }

    public static void main(String[] args) {
        System.out.println(PDDictionary.getLnpr("42/\ubb34\ub9ac/NNG+ +44/\uc77c\uc218/NNG+ +46/\uc788/VV+47/\ub2e4/EFN"));
        System.out.println(PDDictionary.getLnpr("42/\ubb34\ub9ac/NNG+44/\uc774/VCP+45/\u3139/ETD+ +45/\uc218/NNB+ +46/\uc788/VV+47/\ub2e4/EFN"));
    }
}

