/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.CatalogObjectValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;
import org.springframework.expression.ParseException;

public class CatalogObjectParserValidator
extends BaseParserValidator<String> {
    public static final String CATALOG_OBJECT_TYPE = "CATALOG_OBJECT";
    public static final String CATALOG_OBJECT_TYPE_REGEXP = "[Cc][Aa][Tt][Aa][Ll][Oo][Gg][_][Oo][Bb][Jj][Ee][Cc][Tt]";

    public CatalogObjectParserValidator(String model) throws ModelSyntaxException {
        super(model);
        String regexep = "^[Cc][Aa][Tt][Aa][Ll][Oo][Gg][_][Oo][Bb][Jj][Ee][Cc][Tt]$";
        if (!model.matches(regexep)) {
            throw new ModelSyntaxException("CATALOG_OBJECT expression in model does not match " + regexep);
        }
    }

    @Override
    protected String getType() {
        return CATALOG_OBJECT_TYPE;
    }

    @Override
    protected String getTypeRegexp() {
        return CATALOG_OBJECT_TYPE_REGEXP;
    }

    @Override
    protected Class getClassType() {
        return String.class;
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        try {
            return new CatalogObjectValidator();
        }
        catch (ParseException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }
}

