/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.BooleanConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.AcceptAllValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class BooleanParserValidator
extends BaseParserValidator<Boolean> {
    public static final String BOOLEAN_TYPE = "BOOLEAN";
    protected static final String BOOLEAN_TYPE_REGEXP = "[Bb][Oo][Oo][Ll][Ee][Aa][Nn]";

    public BooleanParserValidator(String model) throws ModelSyntaxException {
        super(model);
        if (!model.matches("^[Bb][Oo][Oo][Ll][Ee][Aa][Nn]$")) {
            throw new ModelSyntaxException("BOOLEAN expression in model does not match [Bb][Oo][Oo][Ll][Ee][Aa][Nn]$");
        }
    }

    @Override
    public String getType() {
        return BOOLEAN_TYPE;
    }

    @Override
    public String getTypeRegexp() {
        return BOOLEAN_TYPE_REGEXP;
    }

    @Override
    public Class getClassType() {
        return Boolean.class;
    }

    @Override
    protected Converter<Boolean> createConverter(String model) throws ModelSyntaxException {
        return new BooleanConverter();
    }

    @Override
    protected Validator<Boolean> createValidator(String model, Converter<Boolean> converter) throws ModelSyntaxException {
        return new AcceptAllValidator<Boolean>();
    }
}

