/* Generated by re2c 0.16 */
#line 1 "mwlib/_uscan.re"
// -*- mode: c++ -*-
// Copyright (c) 2007-2009 PediaPress GmbH
// See README.rst for additional licensing information.

#include <Python.h>

#include <iostream>
#include <assert.h>
#include <vector>
using namespace std;

#define RET(x) {found(x); return x;}

typedef enum {
	t_end,
	t_text,
	t_entity,
	t_special,
	t_magicword,
	t_comment,
	t_2box_open,   // [[
	t_2box_close,  // ]]
	t_http_url,
	t_break,
	t_begin_table,
	t_end_table,
	t_html_tag,
	t_singlequote,
	t_pre,
	t_section,
	t_section_end,
	t_item,
	t_colon,
	t_semicolon,
	t_hrule,
	t_newline,
	t_column,
	t_row,
	t_tablecaption,
	t_urllink,
	t_uniq,

	t_ebad,
} mwtok;

struct Token
{
	int type;
	int start;
	int len;
};

class Scanner
{
public:

	Scanner(Py_UNICODE *_start, Py_UNICODE *_end) {
		source = start = _start;
		end = _end;
		cursor = start;
		line_startswith_section = -1;
		tablemode=0;
		last_ebad = false;
	}

	int found(mwtok val) {
		if (val==t_ebad) {
			last_ebad=true;
			return tokens.size()-1;
		}

		if (val==t_text && tokens.size() && !last_ebad) {
			Token &previous_token (tokens[tokens.size()-1]);
			if (previous_token.type==val) {
				previous_token.len += cursor-start;
				return tokens.size()-1;
			}
		}
		
		last_ebad = false;

		Token t;
		t.type = val;
		t.start = (start-source);
		t.len = cursor-start;			
		tokens.push_back(t);
		return tokens.size()-1;
	}

	bool bol() {
		if ((start==source) || (start[-1]=='\n')) {
			memset(&lineflags, 0, sizeof(lineflags));
			return true;
		} else {
			return false;
		}
	}

	bool eol() const {
		return *cursor=='\n' || *cursor==0;
	}

	void newline() {
		if (line_startswith_section>=0) {
			tokens[line_startswith_section].type = t_text;
		}
		line_startswith_section = -1;
	}

	inline int scan();

	Py_UNICODE *source;

	Py_UNICODE *start;
	Py_UNICODE *cursor;
	Py_UNICODE *end;
	vector<Token> tokens;

	bool last_ebad;
	int line_startswith_section;
	int tablemode;
	struct {
		int rowchar;
	} lineflags;
};


int Scanner::scan()
{
	start=cursor;
	
	Py_UNICODE *marker=cursor;

	Py_UNICODE *save_cursor = cursor;


#define YYCTYPE         Py_UNICODE
#define YYCURSOR        cursor
#define YYMARKER	marker
#define YYLIMIT   (end)
// #define YYFILL(n) return 0;

#line 145 "mwlib/_uscan.re"


/*
  the re2c manpage says:
  "The user must arrange for a sentinel token to appear at the end of input"
  \000 is our sentinel token.
*/

#line 186 "mwlib/_uscan.re"

	if (!bol()) {
		goto not_bol;
	}

#line 161 "mwlib/_uscan.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	yych = *YYCURSOR;
	if (yych <= ',') {
		if (yych <= '!') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy4;
			} else {
				if (yych <= 0x001F) goto yy2;
				if (yych <= ' ') goto yy5;
				goto yy7;
			}
		} else {
			if (yych <= '#') {
				if (yych >= '#') goto yy9;
			} else {
				if (yych == '*') goto yy9;
			}
		}
	} else {
		if (yych <= '<') {
			if (yych <= '9') {
				if (yych <= '-') goto yy12;
			} else {
				if (yych <= ':') goto yy13;
				if (yych <= ';') goto yy9;
			}
		} else {
			if (yych <= 'z') {
				if (yych <= '=') goto yy15;
			} else {
				if (yych <= '{') goto yy18;
				if (yych <= '|') goto yy19;
			}
		}
	}
yy2:
	++YYCURSOR;
yy3:
#line 238 "mwlib/_uscan.re"
	{goto not_bol;}
#line 204 "mwlib/_uscan.cc"
yy4:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '!') {
		if (yych == '\t') goto yy21;
		if (yych <= 0x001F) goto yy3;
		goto yy21;
	} else {
		if (yych <= ':') {
			if (yych <= '9') goto yy3;
			goto yy21;
		} else {
			if (yych <= 'z') goto yy3;
			if (yych <= '|') goto yy21;
			goto yy3;
		}
	}
yy5:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '!') {
		if (yych == '\t') goto yy21;
		if (yych >= ' ') goto yy21;
	} else {
		if (yych <= ':') {
			if (yych >= ':') goto yy21;
		} else {
			if (yych <= 'z') goto yy6;
			if (yych <= '|') goto yy21;
		}
	}
yy6:
#line 230 "mwlib/_uscan.re"
	{RET(t_pre);}
#line 239 "mwlib/_uscan.cc"
yy7:
	++YYCURSOR;
yy8:
#line 206 "mwlib/_uscan.re"
	{
		if (tablemode) {
		        lineflags.rowchar=cursor[-1];
			RET(t_column);
		}

		if (*start==' ') {
			cursor = start+1;
			RET(t_pre);
		}
		RET(t_text);
	}
#line 256 "mwlib/_uscan.cc"
yy9:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= ')') {
		if (yych == '#') goto yy9;
	} else {
		if (yych <= '*') goto yy9;
		if (yych <= '9') goto yy11;
		if (yych <= ';') goto yy9;
	}
yy11:
#line 235 "mwlib/_uscan.re"
	{RET(t_item);}
#line 270 "mwlib/_uscan.cc"
yy12:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy26;
	goto yy3;
yy13:
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '9') {
		if (yych <= '#') {
			if (yych <= '"') goto yy11;
			goto yy9;
		} else {
			if (yych == '*') goto yy9;
			goto yy11;
		}
	} else {
		if (yych <= ';') {
			if (yych <= ':') goto yy13;
			goto yy9;
		} else {
			if (yych == '{') goto yy25;
			goto yy11;
		}
	}
yy15:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= 0x001F) {
		if (yych == '\t') goto yy27;
	} else {
		if (yych <= ' ') goto yy27;
		if (yych == '=') goto yy15;
	}
yy17:
#line 231 "mwlib/_uscan.re"
	{
			line_startswith_section = found(t_section);
			return t_section;
		}
#line 312 "mwlib/_uscan.cc"
yy18:
	yych = *++YYCURSOR;
	if (yych == '|') goto yy29;
	goto yy3;
yy19:
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '+') goto yy31;
		goto yy8;
	} else {
		if (yych <= '-') goto yy34;
		if (yych == '}') goto yy37;
		goto yy8;
	}
yy20:
	++YYCURSOR;
	yych = *YYCURSOR;
yy21:
	if (yych <= '!') {
		if (yych <= '\t') {
			if (yych >= '\t') goto yy20;
		} else {
			if (yych <= 0x001F) goto yy22;
			if (yych <= ' ') goto yy20;
			goto yy7;
		}
	} else {
		if (yych <= 'z') {
			if (yych == ':') goto yy23;
		} else {
			if (yych <= '{') goto yy25;
			if (yych <= '|') goto yy19;
		}
	}
yy22:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 1) {
		if (yyaccept == 0) {
			goto yy3;
		} else {
			goto yy6;
		}
	} else {
		goto yy11;
	}
yy23:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == ':') goto yy23;
	if (yych != '{') goto yy22;
yy25:
	yych = *++YYCURSOR;
	if (yych == '|') goto yy29;
	goto yy22;
yy26:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy39;
	goto yy22;
yy27:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '\t') goto yy27;
	if (yych == ' ') goto yy27;
	goto yy17;
yy29:
	++YYCURSOR;
#line 191 "mwlib/_uscan.re"
	{++tablemode; RET(t_begin_table);}
#line 381 "mwlib/_uscan.cc"
yy31:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '+') goto yy31;
#line 220 "mwlib/_uscan.re"
	{
		if (tablemode) 
			RET(t_tablecaption);
		if (*start==' ') {
			cursor = start+1;
			RET(t_pre);
		}
		RET(t_text);
	}
#line 396 "mwlib/_uscan.cc"
yy34:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '-') goto yy34;
#line 195 "mwlib/_uscan.re"
	{
		if (tablemode) 
			RET(t_row);
		if (*start==' ') {
			cursor = start+1;
			RET(t_pre);
		}
		RET(t_text);
	}
#line 411 "mwlib/_uscan.cc"
yy37:
	++YYCURSOR;
#line 192 "mwlib/_uscan.re"
	{if (--tablemode<0) tablemode=0; RET(t_end_table);}
#line 416 "mwlib/_uscan.cc"
yy39:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy22;
yy40:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '-') goto yy40;
#line 236 "mwlib/_uscan.re"
	{RET(t_hrule);}
#line 426 "mwlib/_uscan.cc"
}
#line 239 "mwlib/_uscan.re"



not_bol:
	cursor = save_cursor;
	marker = cursor;


#line 437 "mwlib/_uscan.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	yych = *YYCURSOR;
	if (yych <= ']') {
		if (yych <= '/') {
			if (yych <= ' ') {
				if (yych <= 0x0000) goto yy45;
				if (yych == '\n') goto yy49;
				goto yy47;
			} else {
				if (yych <= '%') {
					if (yych <= '!') goto yy51;
					goto yy47;
				} else {
					if (yych <= '&') goto yy52;
					if (yych <= '\'') goto yy53;
					goto yy47;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '9') goto yy54;
					goto yy57;
				} else {
					if (yych <= ';') goto yy47;
					if (yych <= '<') goto yy59;
					goto yy60;
				}
			} else {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy47;
					goto yy54;
				} else {
					if (yych <= '[') goto yy63;
					if (yych <= '\\') goto yy47;
					goto yy64;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'e') {
				if (yych == '_') goto yy65;
				if (yych <= '`') goto yy47;
				goto yy54;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy67;
					goto yy54;
				} else {
					if (yych <= 'h') goto yy68;
					if (yych <= 'i') goto yy69;
					goto yy54;
				}
			}
		} else {
			if (yych <= '|') {
				if (yych <= 'n') {
					if (yych <= 'm') goto yy70;
					goto yy71;
				} else {
					if (yych <= 'z') goto yy54;
					if (yych <= '{') goto yy47;
					goto yy72;
				}
			} else {
				if (yych <= 0x007F) {
					if (yych <= '~') goto yy47;
					goto yy73;
				} else {
					if (yych == 0xEBAD) goto yy74;
					goto yy47;
				}
			}
		}
	}
yy45:
	++YYCURSOR;
#line 315 "mwlib/_uscan.re"
	{newline(); return t_end;}
#line 520 "mwlib/_uscan.cc"
yy47:
	++YYCURSOR;
yy48:
#line 316 "mwlib/_uscan.re"
	{RET(t_text);}
#line 526 "mwlib/_uscan.cc"
yy49:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\n') goto yy76;
	if (yych == ' ') goto yy79;
yy50:
#line 288 "mwlib/_uscan.re"
	{newline(); RET(t_newline);}
#line 535 "mwlib/_uscan.cc"
yy51:
	yych = *++YYCURSOR;
	if (yych == '!') goto yy82;
	goto yy48;
yy52:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych == '#') goto yy84;
		if (yych <= '/') goto yy48;
		goto yy85;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy48;
			goto yy85;
		} else {
			if (yych <= '`') goto yy48;
			if (yych <= 'z') goto yy85;
			goto yy48;
		}
	}
yy53:
	yych = *++YYCURSOR;
	if (yych == '\'') goto yy87;
	goto yy48;
yy54:
	++YYCURSOR;
	yych = *YYCURSOR;
yy55:
	if (yych <= '@') {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy54;
	} else {
		if (yych <= 'Z') goto yy54;
		if (yych <= '`') goto yy56;
		if (yych <= 'z') goto yy54;
	}
yy56:
#line 262 "mwlib/_uscan.re"
	{RET(t_text);}
#line 576 "mwlib/_uscan.cc"
yy57:
	++YYCURSOR;
yy58:
#line 306 "mwlib/_uscan.re"
	{RET(t_special);}
#line 582 "mwlib/_uscan.cc"
yy59:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '!') goto yy90;
		if (yych <= '.') goto yy48;
		goto yy91;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy48;
			goto yy92;
		} else {
			if (yych <= '`') goto yy48;
			if (yych <= 'z') goto yy92;
			goto yy48;
		}
	}
yy60:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= 0x001F) {
		if (yych == '\t') goto yy94;
	} else {
		if (yych <= ' ') goto yy94;
		if (yych == '=') goto yy60;
	}
yy62:
#line 266 "mwlib/_uscan.re"
	{
			if (eol()) {
			        if (line_startswith_section>=0) {
				     line_startswith_section=-1;
				     RET(t_section_end);
                                } else {
				     RET(t_text);
                                }
			} else {
				RET(t_text);
			}
		    }
#line 623 "mwlib/_uscan.cc"
yy63:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'f') {
		if (yych <= 'Z') {
			if (yych == '/') goto yy96;
			goto yy58;
		} else {
			if (yych <= '[') goto yy97;
			if (yych <= 'e') goto yy58;
			goto yy99;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'g') goto yy58;
			if (yych <= 'h') goto yy100;
			goto yy101;
		} else {
			if (yych <= 'l') goto yy58;
			if (yych <= 'm') goto yy102;
			if (yych <= 'n') goto yy103;
			goto yy58;
		}
	}
yy64:
	yych = *++YYCURSOR;
	if (yych == ']') goto yy104;
	goto yy58;
yy65:
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '_') goto yy106;
yy66:
#line 263 "mwlib/_uscan.re"
	{RET(t_text);}
#line 658 "mwlib/_uscan.cc"
yy67:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy107;
	goto yy55;
yy68:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy108;
	goto yy55;
yy69:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy109;
	goto yy55;
yy70:
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy110;
	goto yy55;
yy71:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy111;
	goto yy55;
yy72:
	yych = *++YYCURSOR;
	if (yych <= '*') {
		if (yych == '!') goto yy82;
		goto yy58;
	} else {
		if (yych <= '+') goto yy112;
		if (yych == '|') goto yy82;
		goto yy58;
	}
yy73:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy114;
	goto yy48;
yy74:
	++YYCURSOR;
#line 247 "mwlib/_uscan.re"
	{RET(t_ebad);}
#line 698 "mwlib/_uscan.cc"
yy76:
	yyaccept = 3;
	YYMARKER = ++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '\n') goto yy76;
	if (yych == ' ') goto yy79;
yy78:
#line 279 "mwlib/_uscan.re"
	{newline();
		 Py_UNICODE *tmp = cursor;

		 cursor = start+1;
		 found(t_newline);
		 start += 1;
		 cursor = tmp;  
		 RET(t_break);
		}
#line 716 "mwlib/_uscan.cc"
yy79:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '\n') goto yy76;
	if (yych == ' ') goto yy79;
yy81:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy50;
			} else {
				goto yy48;
			}
		} else {
			goto yy58;
		}
	} else {
		if (yyaccept <= 4) {
			if (yyaccept == 3) {
				goto yy78;
			} else {
				goto yy66;
			}
		} else {
			goto yy56;
		}
	}
yy82:
	++YYCURSOR;
#line 290 "mwlib/_uscan.re"
	{
		if (tablemode) {
		        if (cursor[-2]!='!' || cursor[-2]==lineflags.rowchar) {
			       RET(t_column);
			}
		}
		cursor = start+1;
		RET(t_special);
	}
#line 757 "mwlib/_uscan.cc"
yy84:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= '/') goto yy81;
		if (yych <= '9') goto yy115;
		goto yy81;
	} else {
		if (yych <= 'X') goto yy117;
		if (yych == 'x') goto yy117;
		goto yy81;
	}
yy85:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= ';') {
		if (yych <= '/') goto yy81;
		if (yych <= '9') goto yy85;
		if (yych <= ':') goto yy81;
		goto yy118;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy81;
			goto yy85;
		} else {
			if (yych <= '`') goto yy81;
			if (yych <= 'z') goto yy85;
			goto yy81;
		}
	}
yy87:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '\'') goto yy87;
#line 307 "mwlib/_uscan.re"
	{RET(t_singlequote);}
#line 793 "mwlib/_uscan.cc"
yy90:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy120;
	goto yy81;
yy91:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy81;
	if (yych <= 'Z') goto yy92;
	if (yych <= '`') goto yy81;
	if (yych >= '{') goto yy81;
yy92:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '<') {
		if (yych <= 0x0000) goto yy81;
		if (yych <= ';') goto yy92;
		goto yy81;
	} else {
		if (yych == '>') goto yy121;
		goto yy92;
	}
yy94:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '\t') goto yy94;
	if (yych == ' ') goto yy94;
	goto yy62;
yy96:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy123;
	goto yy81;
yy97:
	++YYCURSOR;
#line 264 "mwlib/_uscan.re"
	{RET(t_2box_open);}
#line 829 "mwlib/_uscan.cc"
yy99:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy124;
	goto yy81;
yy100:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy125;
	goto yy81;
yy101:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy126;
	goto yy81;
yy102:
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy127;
	goto yy81;
yy103:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy128;
	goto yy81;
yy104:
	++YYCURSOR;
#line 265 "mwlib/_uscan.re"
	{RET(t_2box_close);}
#line 854 "mwlib/_uscan.cc"
yy106:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case 'E':	goto yy129;
	case 'F':	goto yy130;
	case 'N':	goto yy131;
	case 'S':	goto yy132;
	case 'T':	goto yy133;
	default:	goto yy135;
	}
yy107:
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy136;
	goto yy55;
yy108:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy137;
	goto yy55;
yy109:
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy138;
	goto yy55;
yy110:
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy139;
	goto yy55;
yy111:
	yych = *++YYCURSOR;
	if (yych == 'w') goto yy140;
	goto yy55;
yy112:
	++YYCURSOR;
#line 300 "mwlib/_uscan.re"
	{
		if (tablemode) 
			RET(t_tablecaption);
		cursor = start+1;
		RET(t_special);
	}
#line 895 "mwlib/_uscan.cc"
yy114:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy141;
	goto yy81;
yy115:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '/') goto yy81;
	if (yych <= '9') goto yy115;
	if (yych == ';') goto yy118;
	goto yy81;
yy117:
	yych = *++YYCURSOR;
	if (yych == ';') goto yy81;
	goto yy143;
yy118:
	++YYCURSOR;
#line 313 "mwlib/_uscan.re"
	{RET(t_entity);}
#line 915 "mwlib/_uscan.cc"
yy120:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy144;
	goto yy81;
yy121:
	++YYCURSOR;
#line 309 "mwlib/_uscan.re"
	{RET(t_html_tag);}
#line 924 "mwlib/_uscan.cc"
yy123:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy146;
			goto yy81;
		} else {
			if (yych == '<') goto yy81;
			if (yych <= '=') goto yy146;
			goto yy81;
		}
	} else {
		if (yych <= '\\') {
			if (yych == '[') goto yy81;
			goto yy146;
		} else {
			if (yych <= ']') goto yy81;
			if (yych == 0x007F) goto yy81;
			goto yy146;
		}
	}
yy124:
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy149;
	goto yy81;
yy125:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy150;
	goto yy81;
yy126:
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy151;
	goto yy81;
yy127:
	yych = *++YYCURSOR;
	if (yych == 'i') goto yy152;
	goto yy81;
yy128:
	yych = *++YYCURSOR;
	if (yych == 'w') goto yy153;
	goto yy81;
yy129:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy154;
	goto yy81;
yy130:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy155;
	goto yy81;
yy131:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'E') goto yy156;
		goto yy81;
	} else {
		if (yych <= 'O') goto yy157;
		if (yych == 'U') goto yy158;
		goto yy81;
	}
yy132:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy159;
	goto yy81;
yy133:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy160;
	goto yy81;
yy134:
	++YYCURSOR;
	yych = *YYCURSOR;
yy135:
	if (yych == '_') goto yy134;
	goto yy66;
yy136:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy161;
	goto yy55;
yy137:
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy162;
	goto yy55;
yy138:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy163;
	goto yy55;
yy139:
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy164;
	goto yy55;
yy140:
	yych = *++YYCURSOR;
	if (yych == 's') goto yy165;
	goto yy55;
yy141:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy166;
	goto yy81;
yy142:
	++YYCURSOR;
	yych = *YYCURSOR;
yy143:
	if (yych <= ';') {
		if (yych <= '/') goto yy81;
		if (yych <= '9') goto yy142;
		if (yych <= ':') goto yy81;
		goto yy118;
	} else {
		if (yych <= 'F') {
			if (yych <= '@') goto yy81;
			goto yy142;
		} else {
			if (yych <= '`') goto yy81;
			if (yych <= 'f') goto yy142;
			goto yy81;
		}
	}
yy144:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= ';') {
		if (yych <= 0x0000) goto yy81;
		if (yych == '-') goto yy167;
		goto yy144;
	} else {
		if (yych == '=') goto yy144;
		if (yych <= '>') goto yy81;
		goto yy144;
	}
yy146:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy146;
		} else {
			if (yych == '<') goto yy148;
			if (yych <= '=') goto yy146;
		}
	} else {
		if (yych <= '\\') {
			if (yych != '[') goto yy146;
		} else {
			if (yych <= ']') goto yy148;
			if (yych != 0x007F) goto yy146;
		}
	}
yy148:
#line 257 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1076 "mwlib/_uscan.cc"
yy149:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy168;
	goto yy81;
yy150:
	yych = *++YYCURSOR;
	if (yych == 'p') goto yy169;
	goto yy81;
yy151:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy170;
	goto yy81;
yy152:
	yych = *++YYCURSOR;
	if (yych == 'l') goto yy171;
	goto yy81;
yy153:
	yych = *++YYCURSOR;
	if (yych == 's') goto yy172;
	goto yy81;
yy154:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy173;
	goto yy81;
yy155:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy174;
	goto yy81;
yy156:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy175;
	goto yy81;
yy157:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'C':	goto yy176;
	case 'E':	goto yy177;
	case 'G':	goto yy178;
	case 'I':	goto yy179;
	case 'N':	goto yy180;
	case 'T':	goto yy181;
	default:	goto yy81;
	}
yy158:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy182;
	goto yy81;
yy159:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy183;
	goto yy81;
yy160:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy173;
	goto yy81;
yy161:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy184;
	goto yy81;
yy162:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy185;
	if (yych == 's') goto yy186;
	goto yy55;
yy163:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy187;
	goto yy81;
yy164:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy188;
	goto yy55;
yy165:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy189;
	goto yy55;
yy166:
	yych = *++YYCURSOR;
	if (yych == 'Q') goto yy190;
	goto yy81;
yy167:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= ';') {
		if (yych <= 0x0000) goto yy81;
		if (yych == '-') goto yy191;
		goto yy144;
	} else {
		if (yych == '=') goto yy144;
		if (yych <= '>') goto yy81;
		goto yy144;
	}
yy168:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy193;
	goto yy81;
yy169:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy194;
	if (yych == 's') goto yy195;
	goto yy81;
yy170:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy196;
	goto yy81;
yy171:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy197;
	goto yy81;
yy172:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy198;
	goto yy81;
yy173:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy199;
	goto yy81;
yy174:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy200;
	goto yy81;
yy175:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy201;
	goto yy81;
yy176:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy173;
	if (yych == 'O') goto yy202;
	goto yy81;
yy177:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy203;
	goto yy81;
yy178:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy204;
	if (yych == 'L') goto yy205;
	goto yy81;
yy179:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy206;
	goto yy81;
yy180:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy158;
	goto yy81;
yy181:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych == 'C') goto yy173;
		goto yy81;
	} else {
		if (yych <= 'I') goto yy207;
		if (yych == 'O') goto yy208;
		goto yy81;
	}
yy182:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy209;
	goto yy81;
yy183:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy210;
	goto yy81;
yy184:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy211;
	goto yy81;
yy185:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy212;
	goto yy81;
yy186:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy185;
	goto yy55;
yy187:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy213;
	goto yy81;
yy188:
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy214;
	goto yy55;
yy189:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy215;
		goto yy81;
	} else {
		if (yych <= '9') goto yy215;
		if (yych <= '@') goto yy81;
		if (yych <= 'a') goto yy215;
		goto yy81;
	}
yy190:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy218;
	goto yy81;
yy191:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= ';') {
		if (yych <= 0x0000) goto yy81;
		if (yych == '-') goto yy191;
		goto yy144;
	} else {
		if (yych <= '<') goto yy81;
		if (yych == '>') goto yy219;
		goto yy144;
	}
yy193:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy221;
	goto yy81;
yy194:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy222;
	goto yy81;
yy195:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy194;
	goto yy81;
yy196:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy223;
	goto yy81;
yy197:
	yych = *++YYCURSOR;
	if (yych == 'o') goto yy224;
	goto yy81;
yy198:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy225;
		goto yy81;
	} else {
		if (yych <= '9') goto yy225;
		if (yych <= '@') goto yy81;
		if (yych <= 'a') goto yy225;
		goto yy81;
	}
yy199:
	yych = *++YYCURSOR;
	if (yych == '_') goto yy228;
	goto yy81;
yy200:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy230;
	goto yy81;
yy201:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy231;
	goto yy81;
yy202:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy232;
	goto yy81;
yy203:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy233;
	goto yy81;
yy204:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy234;
	goto yy81;
yy205:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy235;
	goto yy81;
yy206:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy236;
	goto yy81;
yy207:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy237;
	goto yy81;
yy208:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy238;
	goto yy81;
yy209:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy239;
	goto yy81;
yy210:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy173;
	goto yy81;
yy211:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy81;
			if (yych <= '$') goto yy240;
			goto yy81;
		} else {
			if (yych <= ':') goto yy240;
			if (yych == '=') goto yy240;
			goto yy81;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy240;
			if (yych == '_') goto yy240;
			goto yy81;
		} else {
			if (yych == '|') goto yy81;
			if (yych <= '~') goto yy240;
			goto yy81;
		}
	}
yy212:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy243;
	goto yy81;
yy213:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy81;
		if (yych <= '9') goto yy244;
		goto yy81;
	} else {
		if (yych <= 'Z') goto yy244;
		if (yych <= '`') goto yy81;
		if (yych <= 'z') goto yy244;
		goto yy81;
	}
yy214:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy247;
	goto yy55;
yy215:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy215;
	} else {
		if (yych <= '9') goto yy215;
		if (yych <= '@') goto yy217;
		if (yych <= 'a') goto yy215;
	}
yy217:
#line 253 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1428 "mwlib/_uscan.cc"
yy218:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy81;
	goto yy249;
yy219:
	++YYCURSOR;
#line 312 "mwlib/_uscan.re"
	{RET(t_comment);}
#line 1437 "mwlib/_uscan.cc"
yy221:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy81;
			if (yych <= '$') goto yy250;
			goto yy81;
		} else {
			if (yych <= ':') goto yy250;
			if (yych == '=') goto yy250;
			goto yy81;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy250;
			if (yych == '_') goto yy250;
			goto yy81;
		} else {
			if (yych == '|') goto yy81;
			if (yych <= '~') goto yy250;
			goto yy81;
		}
	}
yy222:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy253;
	goto yy81;
yy223:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy81;
		if (yych <= '9') goto yy254;
		goto yy81;
	} else {
		if (yych <= 'Z') goto yy254;
		if (yych <= '`') goto yy81;
		if (yych <= 'z') goto yy254;
		goto yy81;
	}
yy224:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy257;
	goto yy81;
yy225:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy225;
	} else {
		if (yych <= '9') goto yy225;
		if (yych <= '@') goto yy227;
		if (yych <= 'a') goto yy225;
	}
yy227:
#line 252 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1494 "mwlib/_uscan.cc"
yy228:
	++YYCURSOR;
#line 259 "mwlib/_uscan.re"
	{RET(t_magicword);}
#line 1499 "mwlib/_uscan.cc"
yy230:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy133;
	goto yy81;
yy231:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy258;
	goto yy81;
yy232:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy259;
	goto yy81;
yy233:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy260;
	goto yy81;
yy234:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy261;
	goto yy81;
yy235:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy262;
	goto yy81;
yy236:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy263;
	goto yy81;
yy237:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy264;
	goto yy81;
yy238:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy265;
	if (yych == '_') goto yy199;
	goto yy81;
yy239:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy266;
	goto yy81;
yy240:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy242;
			if (yych <= '$') goto yy240;
		} else {
			if (yych <= ':') goto yy240;
			if (yych == '=') goto yy240;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy240;
			if (yych == '_') goto yy240;
		} else {
			if (yych == '|') goto yy242;
			if (yych <= '~') goto yy240;
		}
	}
yy242:
#line 255 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1564 "mwlib/_uscan.cc"
yy243:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy267;
			goto yy81;
		} else {
			if (yych == '<') goto yy81;
			if (yych <= '=') goto yy267;
			goto yy81;
		}
	} else {
		if (yych <= '\\') {
			if (yych == '[') goto yy81;
			goto yy267;
		} else {
			if (yych <= ']') goto yy81;
			if (yych == 0x007F) goto yy81;
			goto yy267;
		}
	}
yy244:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy246;
		if (yych <= '9') goto yy244;
	} else {
		if (yych <= 'Z') goto yy244;
		if (yych <= '`') goto yy246;
		if (yych <= 'z') goto yy244;
	}
yy246:
#line 251 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1600 "mwlib/_uscan.cc"
yy247:
	yych = *++YYCURSOR;
	if (yych == '@') goto yy81;
	goto yy271;
yy248:
	++YYCURSOR;
	yych = *YYCURSOR;
yy249:
	if (yych <= '/') {
		if (yych == '-') goto yy272;
		goto yy81;
	} else {
		if (yych <= '9') goto yy248;
		if (yych <= '`') goto yy81;
		if (yych <= 'z') goto yy248;
		goto yy81;
	}
yy250:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= '%') {
			if (yych <= '"') goto yy252;
			if (yych <= '$') goto yy250;
		} else {
			if (yych <= ':') goto yy250;
			if (yych == '=') goto yy250;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy250;
			if (yych == '_') goto yy250;
		} else {
			if (yych == '|') goto yy252;
			if (yych <= '~') goto yy250;
		}
	}
yy252:
#line 254 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1641 "mwlib/_uscan.cc"
yy253:
	yych = *++YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy273;
			goto yy81;
		} else {
			if (yych == '<') goto yy81;
			if (yych <= '=') goto yy273;
			goto yy81;
		}
	} else {
		if (yych <= '\\') {
			if (yych == '[') goto yy81;
			goto yy273;
		} else {
			if (yych <= ']') goto yy81;
			if (yych == 0x007F) goto yy81;
			goto yy273;
		}
	}
yy254:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') goto yy256;
		if (yych <= '9') goto yy254;
	} else {
		if (yych <= 'Z') goto yy254;
		if (yych <= '`') goto yy256;
		if (yych <= 'z') goto yy254;
	}
yy256:
#line 250 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1677 "mwlib/_uscan.cc"
yy257:
	yych = *++YYCURSOR;
	if (yych == '@') goto yy81;
	goto yy277;
yy258:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy278;
	goto yy81;
yy259:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy279;
	goto yy81;
yy260:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy280;
	goto yy81;
yy261:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy281;
	goto yy81;
yy262:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy282;
	goto yy81;
yy263:
	yych = *++YYCURSOR;
	if (yych == 'X') goto yy173;
	goto yy81;
yy264:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy283;
	goto yy81;
yy265:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy284;
	goto yy81;
yy266:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy285;
	goto yy81;
yy267:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy267;
		} else {
			if (yych == '<') goto yy269;
			if (yych <= '=') goto yy267;
		}
	} else {
		if (yych <= '\\') {
			if (yych != '[') goto yy267;
		} else {
			if (yych <= ']') goto yy269;
			if (yych != 0x007F) goto yy267;
		}
	}
yy269:
#line 258 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1739 "mwlib/_uscan.cc"
yy270:
	++YYCURSOR;
	yych = *YYCURSOR;
yy271:
	if (yych <= '9') {
		if (yych <= '\'') {
			if (yych == '!') goto yy270;
			if (yych <= '"') goto yy81;
			goto yy270;
		} else {
			if (yych <= ')') goto yy81;
			if (yych == ',') goto yy81;
			goto yy270;
		}
	} else {
		if (yych <= '?') {
			if (yych == '=') goto yy270;
			if (yych <= '>') goto yy81;
			goto yy270;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy286;
				goto yy270;
			} else {
				if (yych <= ']') goto yy81;
				if (yych <= '~') goto yy270;
				goto yy81;
			}
		}
	}
yy272:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy81;
	if (yych <= '9') goto yy287;
	goto yy81;
yy273:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '>') {
		if (yych <= '"') {
			if (yych == '!') goto yy273;
		} else {
			if (yych == '<') goto yy275;
			if (yych <= '=') goto yy273;
		}
	} else {
		if (yych <= '\\') {
			if (yych != '[') goto yy273;
		} else {
			if (yych <= ']') goto yy275;
			if (yych != 0x007F) goto yy273;
		}
	}
yy275:
#line 256 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1796 "mwlib/_uscan.cc"
yy276:
	++YYCURSOR;
	yych = *YYCURSOR;
yy277:
	if (yych <= '9') {
		if (yych <= '\'') {
			if (yych == '!') goto yy276;
			if (yych <= '"') goto yy81;
			goto yy276;
		} else {
			if (yych <= ')') goto yy81;
			if (yych == ',') goto yy81;
			goto yy276;
		}
	} else {
		if (yych <= '?') {
			if (yych == '=') goto yy276;
			if (yych <= '>') goto yy81;
			goto yy276;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy289;
				goto yy276;
			} else {
				if (yych <= ']') goto yy81;
				if (yych <= '~') goto yy276;
				goto yy81;
			}
		}
	}
yy278:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy290;
	goto yy81;
yy279:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy291;
	goto yy81;
yy280:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy292;
	goto yy81;
yy281:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy293;
	goto yy81;
yy282:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy281;
	goto yy81;
yy283:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy294;
	goto yy81;
yy284:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy173;
	goto yy81;
yy285:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy295;
	goto yy81;
yy286:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych <= ',') goto yy81;
			goto yy296;
		} else {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy296;
			goto yy81;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy296;
			if (yych <= '^') goto yy81;
			goto yy296;
		} else {
			if (yych <= '`') goto yy81;
			if (yych <= 'z') goto yy296;
			goto yy81;
		}
	}
yy287:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych == '-') goto yy299;
	if (yych <= '/') goto yy81;
	if (yych <= '9') goto yy287;
	goto yy81;
yy289:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych <= ',') goto yy81;
			goto yy300;
		} else {
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy300;
			goto yy81;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy300;
			if (yych <= '^') goto yy81;
			goto yy300;
		} else {
			if (yych <= '`') goto yy81;
			if (yych <= 'z') goto yy300;
			goto yy81;
		}
	}
yy290:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy303;
	goto yy81;
yy291:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy283;
	goto yy81;
yy292:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy304;
	goto yy81;
yy293:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy173;
	goto yy81;
yy294:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy305;
	goto yy81;
yy295:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy306;
	goto yy81;
yy296:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych >= '-') goto yy296;
		} else {
			if (yych <= '/') goto yy298;
			if (yych <= '9') goto yy296;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy296;
			if (yych >= '_') goto yy296;
		} else {
			if (yych <= '`') goto yy298;
			if (yych <= 'z') goto yy296;
		}
	}
yy298:
#line 249 "mwlib/_uscan.re"
	{RET(t_http_url);}
#line 1956 "mwlib/_uscan.cc"
yy299:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy81;
	goto yy308;
yy300:
	++YYCURSOR;
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '.') {
			if (yych >= '-') goto yy300;
		} else {
			if (yych <= '/') goto yy302;
			if (yych <= '9') goto yy300;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy300;
			if (yych >= '_') goto yy300;
		} else {
			if (yych <= '`') goto yy302;
			if (yych <= 'z') goto yy300;
		}
	}
yy302:
#line 248 "mwlib/_uscan.re"
	{RET(t_urllink);}
#line 1983 "mwlib/_uscan.cc"
yy303:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy309;
	goto yy81;
yy304:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy310;
	goto yy81;
yy305:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy311;
	goto yy81;
yy306:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy312;
	goto yy81;
yy307:
	++YYCURSOR;
	yych = *YYCURSOR;
yy308:
	if (yych <= '/') {
		if (yych == '-') goto yy313;
		goto yy81;
	} else {
		if (yych <= '9') goto yy307;
		if (yych <= '`') goto yy81;
		if (yych <= 'f') goto yy307;
		goto yy81;
	}
yy309:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy314;
	goto yy81;
yy310:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy315;
	goto yy81;
yy311:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy316;
	goto yy81;
yy312:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy317;
	goto yy81;
yy313:
	yych = *++YYCURSOR;
	if (yych == 'Q') goto yy318;
	goto yy81;
yy314:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy319;
	goto yy81;
yy315:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy320;
	goto yy81;
yy316:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy183;
	goto yy81;
yy317:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy321;
	goto yy81;
yy318:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy322;
	goto yy81;
yy319:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy323;
	goto yy81;
yy320:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy173;
	goto yy81;
yy321:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy324;
	goto yy81;
yy322:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy325;
	goto yy81;
yy323:
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy173;
	goto yy81;
yy324:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy326;
	goto yy81;
yy325:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy327;
	goto yy81;
yy326:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy328;
	goto yy81;
yy327:
	yych = *++YYCURSOR;
	if (yych == 0x007F) goto yy329;
	goto yy81;
yy328:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy173;
	goto yy81;
yy329:
	++YYCURSOR;
#line 260 "mwlib/_uscan.re"
	{RET(t_uniq);}
#line 2097 "mwlib/_uscan.cc"
}
#line 317 "mwlib/_uscan.re"

}


PyObject *py_scan(PyObject *self, PyObject *args) 
{
	PyObject *arg1;
	if (!PyArg_ParseTuple(args, "O:mwscan.scan", &arg1)) {
		return 0;
	}
	PyUnicodeObject *unistr = (PyUnicodeObject*)PyUnicode_FromObject(arg1);
	if (unistr == NULL) {
		PyErr_SetString(PyExc_TypeError,
				"parameter cannot be converted to unicode in mwscan.scan");
		return 0;
	}

	Py_UNICODE *start = unistr->str;
	Py_UNICODE *end = start+unistr->length;
	

	Scanner scanner (start, end);
	Py_BEGIN_ALLOW_THREADS
	while (scanner.scan()) {
	}
	Py_END_ALLOW_THREADS
	Py_XDECREF(unistr);
	
	// return PyList_New(0); // uncomment to see timings for scanning

	int size = scanner.tokens.size();
	PyObject *result = PyList_New(size);
	if (!result) {
		return 0;
	}
	
	for (int i=0; i<size; i++) {
		Token t = scanner.tokens[i];
		PyList_SET_ITEM(result, i, Py_BuildValue("iii", t.type, t.start, t.len));
	}
	
	return result;
}



static PyMethodDef module_functions[] = {
	{"scan", (PyCFunction)py_scan, METH_VARARGS, "scan(text)"},
	{0, 0},
};



extern "C" {
	DL_EXPORT(void) init_uscan();
}

DL_EXPORT(void) init_uscan()
{
	/*PyObject *m =*/ Py_InitModule("_uscan", module_functions);
}
