# Generated by Django 4.1.4 on 2022-12-27 01:36

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("subscriptions", "0007_alter_planlist_id_alter_planlistdetail_id_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="VenmoAccount",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("venmo_id", models.CharField(max_length=64)),
                ("venmo_username", models.CharField(max_length=64)),
                (
                    "user",
                    models.OneToOneField(
                        help_text="the user associated with this Venmo account",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Bill",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "date_transaction",
                    models.DateTimeField(
                        help_text="the datetime the transaction was billed",
                        verbose_name="transaction date",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="how much was billed for the user",
                        max_digits=19,
                        null=True,
                    ),
                ),
                (
                    "subscription",
                    models.ForeignKey(
                        help_text="the plan costs that were billed",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="subscriptions.plancost",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="the user that this subscription was billed for",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ("date_transaction", "user"),
            },
        ),
    ]
