# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExitConditions(Model):
    """Specifies how the Batch service should respond when the task completes.

    :param exit_codes: A list of individual task exit codes and how the Batch
     service should respond to them.
    :type exit_codes: list of :class:`ExitCodeMapping
     <azure.batch.models.ExitCodeMapping>`
    :param exit_code_ranges: A list of task exit code ranges and how the Batch
     service should respond to them.
    :type exit_code_ranges: list of :class:`ExitCodeRangeMapping
     <azure.batch.models.ExitCodeRangeMapping>`
    :param scheduling_error: How the Batch service should respond if the task
     fails with a scheduling error.
    :type scheduling_error: :class:`ExitOptions
     <azure.batch.models.ExitOptions>`
    :param default: How the Batch service should respond if the task fails
     with an exit condition not covered by any of the other properties - that
     is, any nonzero exit code not listed in the exitCodes or exitCodeRanges
     collection, or a scheduling error if the schedulingError property is not
     present. Note that the default condition does not include exit code 0. If
     you want non-default behaviour on exit code 0, you must list it explicitly
     using the exitCodes or exitCodeRanges collection.
    :type default: :class:`ExitOptions <azure.batch.models.ExitOptions>`
    """

    _attribute_map = {
        'exit_codes': {'key': 'exitCodes', 'type': '[ExitCodeMapping]'},
        'exit_code_ranges': {'key': 'exitCodeRanges', 'type': '[ExitCodeRangeMapping]'},
        'scheduling_error': {'key': 'schedulingError', 'type': 'ExitOptions'},
        'default': {'key': 'default', 'type': 'ExitOptions'},
    }

    def __init__(self, exit_codes=None, exit_code_ranges=None, scheduling_error=None, default=None):
        self.exit_codes = exit_codes
        self.exit_code_ranges = exit_code_ranges
        self.scheduling_error = scheduling_error
        self.default = default
