/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.testdriver.Environment;
import net.sf.saxon.testdriver.ErrorCollector;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriver;
import net.sf.saxon.testdriver.TestOutcome;
import net.sf.saxon.testdriver.Xslt30TestReport;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xslt30TestSuiteDriverHE
extends TestDriver {
    protected boolean showSerialization = false;

    public Xslt30TestSuiteDriverHE() {
        this.spec = Spec.XT30;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            Xslt30TestSuiteDriverHE.usage();
        }
        new Xslt30TestSuiteDriverHE().go(args);
    }

    protected static void usage() {
        System.err.println("java com.saxonica.testdriver.Xslt30TestSuiteDriver[HE] testsuiteDir catalog [-o:resultsdir] [-s:testSetName] [-t:testNamePattern] [-bytecode:on|off|debug] [-tree] [-lang] [-save] [-streaming:off|std|ext] [-xt30:on]");
    }

    @Override
    public String catalogNamespace() {
        return "http://www.w3.org/2012/10/xslt-test-catalog";
    }

    @Override
    protected void writeResultFilePreamble(Processor processor, XdmNode catalog) throws Exception {
        super.writeResultFilePreamble(processor, catalog);
    }

    @Override
    public void processSpec(String specStr) {
        if (specStr.equals("XT10")) {
            this.spec = Spec.XT10;
        } else if (specStr.equals("XT20")) {
            this.spec = Spec.XT20;
        } else if (specStr.equals("XT30")) {
            this.spec = Spec.XT30;
        } else {
            throw new IllegalArgumentException("Unknown spec " + specStr);
        }
        this.resultsDoc = new Xslt30TestReport(this, this.spec);
    }

    @Override
    protected void createGlobalEnvironments(XdmNode catalog, XPathCompiler xpc) throws SaxonApiException {
        for (XdmItem env : xpc.evaluate("//environment", (XdmItem)catalog)) {
            Environment.processEnvironment(this, xpc, env, this.globalEnvironments, (Environment)this.localEnvironments.get("default"));
        }
    }

    protected boolean isSlow(String testName) {
        return testName.startsWith("regex-classes") || testName.equals("normalize-unicode-008") || testName.startsWith("xp-");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void runTestCase(XdmNode testCase, XPathCompiler xpath) throws SaxonApiException {
        outcome = new TestOutcome(this);
        testName = testCase.getAttributeValue(new QName("name"));
        testSetName = testCase.getParent().getAttributeValue(new QName("name"));
        if (this.exceptionsMap.containsKey(testName)) {
            ++this.notrun;
            this.resultsDoc.writeTestcaseElement(testName, "notRun", ((XdmNode)this.exceptionsMap.get(testName)).getAttributeValue(new QName("reason")));
            return;
        }
        if (this.exceptionsMap.containsKey(testName) || this.isSlow(testName)) {
            ++this.notrun;
            this.resultsDoc.writeTestcaseElement(testName, "notRun", "requires excessive resources");
            return;
        }
        specAtt = xpath.evaluateSingle("(/test-set/dependencies/spec/@value, ./dependencies/spec/@value)[last()]", (XdmItem)testCase);
        spec = specAtt == null ? "XSLT10+" : specAtt.toString();
        env = this.getEnvironment(testCase, xpath);
        if (env == null) {
            this.resultsDoc.writeTestcaseElement(testName, "notRun", "test catalog error");
            ++this.notrun;
            return;
        }
        if (!env.usable) {
            this.resultsDoc.writeTestcaseElement(testName, "notRun", "environment dependencies not satisfied");
            ++this.notrun;
            return;
        }
        if (testName.contains("environment-variable")) {
            resolver = new EnvironmentVariableResolver(){

                public Set<String> getAvailableEnvironmentVariables() {
                    HashSet<String> strings = new HashSet<String>();
                    strings.add("QTTEST");
                    strings.add("QTTEST2");
                    strings.add("QTTESTEMPTY");
                    return strings;
                }

                public String getEnvironmentVariable(String name) {
                    if (name.equals("QTTEST")) {
                        return "42";
                    }
                    if (name.equals("QTTEST2")) {
                        return "other";
                    }
                    if (name.equals("QTTESTEMPTY")) {
                        return "";
                    }
                    return null;
                }
            };
            env.processor.setConfigurationProperty("http://saxon.sf.net/feature/environmentVariableResolver", (Object)resolver);
        }
        testInput = (XdmNode)xpath.evaluateSingle("test", (XdmItem)testCase);
        stylesheet = (XdmNode)xpath.evaluateSingle("stylesheet", (XdmItem)testInput);
        pack = (XdmNode)xpath.evaluateSingle("package", (XdmItem)testInput);
        for (XdmItem dep : xpath.evaluate("(/test-set/dependencies/*, ./dependencies/*)", (XdmItem)testCase)) {
            if (this.dependencyIsSatisfied((XdmNode)dep, env)) continue;
            ++this.notrun;
            this.resultsDoc.writeTestcaseElement(testName, "notRun", "dependency not satisfied");
            return;
        }
        sheet = env.xsltExecutable;
        collector = new ErrorCollector();
        v0 = xsltLanguageVersion = spec.contains("XSLT30") != false || spec.contains("XSLT20+") != false ? "3.0" : "2.0";
        if (stylesheet != null) {
            fileName = stylesheet.getAttributeValue(new QName("file"));
            styleSource = new StreamSource(testCase.getBaseURI().resolve(fileName).toString());
            compiler = env.xsltCompiler;
            compiler.setXsltLanguageVersion(spec.contains("XSLT30") != false || spec.contains("XSLT20+") != false ? "3.0" : "2.0");
            compiler.setErrorListener((ErrorListener)collector);
            for (XdmItem param : xpath.evaluate("param[@static='yes']", (XdmItem)testInput)) {
                name = ((XdmNode)param).getAttributeValue(new QName("name"));
                select = ((XdmNode)param).getAttributeValue(new QName("select"));
                try {
                    value = xpath.evaluate(select, null);
                }
                catch (SaxonApiException e) {
                    System.err.println("*** Error evaluating parameter " + name + ": " + e.getMessage());
                    throw e;
                }
                compiler.setParameter(new QName(name), value);
            }
            try {
                sheet = compiler.compile((Source)styleSource);
            }
            catch (SaxonApiException err) {
                outcome.setException(err);
                if (err.getErrorCode() != null) {
                    collector.getErrorCodes().add(err.getErrorCode().getLocalName());
                }
                outcome.setErrorsReported(collector.getErrorCodes());
            }
            catch (Exception err) {
                System.err.println(err.getMessage());
                outcome.setException(new SaxonApiException((Throwable)err));
                outcome.setErrorsReported(collector.getErrorCodes());
            }
            optimizationAssertion = (String)this.optimizationAssertions.get(testName);
            if (optimizationAssertion != null) {
                try {
                    this.assertOptimization(sheet, optimizationAssertion);
                    System.err.println("Optimization OK: " + optimizationAssertion);
                }
                catch (SaxonApiException e) {
                    System.err.println("Optimization assertion failed: " + optimizationAssertion);
                }
            }
        } else if (pack != null) {
            fileName = pack.getAttributeValue(new QName("file"));
            styleSource = new StreamSource(testCase.getBaseURI().resolve(fileName).toString());
            compiler = env.xsltCompiler;
            compiler.setXsltLanguageVersion(xsltLanguageVersion);
            compiler.setErrorListener((ErrorListener)collector);
            try {
                xpack = compiler.compilePackage((Source)styleSource);
                sheet = xpack.link();
            }
            catch (SaxonApiException err) {
                System.err.println(err.getMessage());
                outcome.setException(err);
                outcome.setErrorsReported(collector.getErrorCodes());
            }
            catch (Exception err) {
                System.err.println(err.getMessage());
                outcome.setException(new SaxonApiException((Throwable)err));
                outcome.setErrorsReported(collector.getErrorCodes());
            }
        }
        if (sheet != null) {
            contextItem = env.contextItem;
            initialMode = (XdmNode)xpath.evaluateSingle("initial-mode", (XdmItem)testInput);
            initialFunction = (XdmNode)xpath.evaluateSingle("initial-function", (XdmItem)testInput);
            initialTemplate = (XdmNode)xpath.evaluateSingle("initial-template", (XdmItem)testInput);
            initialModeName = null;
            if (initialMode != null && !"#unnamed".equals(initialMode.getAttributeValue(new QName("name"))) && !"#default".equals(initialMode.getAttributeValue(new QName("name")))) {
                initialModeName = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmItem)testInput, "initial-mode/@name");
            }
            initialTemplateName = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmItem)testInput, "initial-template/@name");
            outputUri = xpath.evaluate("string(output/@file)", (XdmItem)testInput).toString();
            if ("".equals(outputUri)) {
                outputUri = null;
            }
            baseOut = new File(this.resultsDir + "/results/output.xml").toURI();
            baseOutputURI = new File(this.resultsDir + "/results/output.xml").toURI().toString();
            if (outputUri != null) {
                baseOutputURI = baseOut.resolve(outputUri).toString();
            }
            if (this.useXslt30Transformer) {
                try {
                    assertsSerial = xpath.evaluate("result//(assert-serialization|assert-serialization-error|serialization-matches)", (XdmItem)testCase).size() > 0;
                    resultAsTree = env.outputTree;
                    serializationDeclared = env.outputSerialize;
                    needsTree = (XdmNode)xpath.evaluateSingle("output/@tree", (XdmItem)testInput);
                    if (needsTree != null) {
                        resultAsTree = needsTree.getStringValue().equals("yes");
                    }
                    if ((needsSerialization = (XdmNode)xpath.evaluateSingle("output/@serialize", (XdmItem)testInput)) != null) {
                        serializationDeclared = needsSerialization.getStringValue().equals("yes");
                    }
                    v1 = resultSerialized = serializationDeclared != false || assertsSerial != false;
                    if (assertsSerial) {
                        comment = outcome.getComment();
                        comment = (comment == null ? "" : comment) + "*Serialization " + (serializationDeclared != false ? "declared* " : "required* ");
                        outcome.setComment(comment);
                    }
                    transformer = sheet.load30();
                    transformer.setURIResolver((URIResolver)env);
                    if (env.unparsedTextResolver != null) {
                        transformer.getUnderlyingController().setUnparsedTextURIResolver(env.unparsedTextResolver);
                    }
                    caseGlobalParams = this.getNamedParameters(xpath, testInput, false, false);
                    caseStaticParams = this.getNamedParameters(xpath, testInput, true, false);
                    globalParams = new HashMap<QName, XdmValue>(env.params);
                    globalParams.putAll(caseStaticParams);
                    globalParams.putAll(caseGlobalParams);
                    transformer.setStylesheetParameters(globalParams);
                    if (contextItem != null) {
                        transformer.setGlobalContextItem(contextItem);
                    }
                    transformer.setErrorListener((ErrorListener)collector);
                    transformer.setBaseOutputURI(baseOutputURI);
                    transformer.setMessageListener(new MessageListener(){

                        public void message(XdmNode content, boolean terminate, SourceLocator locator) {
                            outcome.addXslMessage(content);
                            System.err.println(content.getStringValue());
                        }
                    });
                    result = null;
                    sw = new StringWriter();
                    serializer = env.processor.newSerializer((Writer)sw);
                    serializingOutput = new OutputResolver(env.processor, outcome, true);
                    controller = transformer.getUnderlyingController();
                    controller.setOutputURIResolver((OutputURIResolver)serializingOutput);
                    dest = null;
                    if (resultAsTree) {
                        controller.setOutputURIResolver((OutputURIResolver)new OutputResolver(env.processor, outcome, false));
                        dest = new XdmDestination();
                    }
                    if (resultSerialized) {
                        dest = serializer;
                    }
                    src = null;
                    if (env.streamedFile != null) {
                        src = new StreamSource(env.streamedFile);
                    } else if (env.streamedContent != null) {
                        src = new StreamSource(new StringReader(env.streamedContent), "inlineDoc");
                    } else if (initialTemplate == null && contextItem != null) {
                        src = ((XdmNode)contextItem).getUnderlyingNode();
                    }
                    if (initialMode != null) {
                        name = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmItem)initialMode, "@name");
                        try {
                            if (name != null) {
                                transformer.setInitialMode(name);
                            } else {
                                controller.getInitialMode();
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (e.getCause() instanceof XPathException) {
                                collector.fatalError((TransformerException)((XPathException)e.getCause()));
                                throw new SaxonApiException(e.getCause());
                            }
                            throw e;
                        }
                    }
                    if (initialMode != null || initialTemplate != null) {
                        init = initialMode == null ? initialTemplate : initialMode;
                        params = this.getNamedParameters(xpath, init, false, false);
                        tunnelledParams = this.getNamedParameters(xpath, init, false, true);
                        if (xsltLanguageVersion.equals("2.0")) {
                            if (!params.isEmpty() || !tunnelledParams.isEmpty()) {
                                System.err.println("*** Initial template parameters ignored for XSLT 2.0");
                            }
                        } else {
                            transformer.setInitialTemplateParameters((Map)params, false);
                            transformer.setInitialTemplateParameters(tunnelledParams, true);
                        }
                    }
                    if (initialTemplate != null) {
                        name = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmItem)initialTemplate, "@name");
                        transformer.setGlobalContextItem(contextItem);
                        if (dest == null) {
                            result = transformer.callTemplate(name);
                        } else {
                            transformer.callTemplate(name, (Destination)dest);
                        }
                    } else if (initialFunction != null) {
                        name = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmItem)initialFunction, "@name");
                        params = this.getParameters(xpath, initialFunction);
                        if (dest == null) {
                            result = transformer.callFunction(name, params);
                        } else {
                            transformer.callFunction(name, params, (Destination)dest);
                        }
                    } else if (dest == null) {
                        result = transformer.applyTemplates((Source)src);
                    } else {
                        transformer.applyTemplates((Source)src, (Destination)dest);
                    }
                    outcome.setWarningsReported(collector.getFoundWarnings());
                    if (resultAsTree && !resultSerialized) {
                        result = ((XdmDestination)dest).getXdmNode();
                    }
                    if (resultSerialized) {
                        outcome.setPrincipalSerializedResult(sw.toString());
                    }
                    outcome.setPrincipalResult(result);
                    if (!this.saveResults) ** GOTO lbl322
                    s = sw.toString();
                    if (!resultSerialized && result != null) {
                        sw2 = new StringWriter();
                        se = env.processor.newSerializer((Writer)sw2);
                        se.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                        env.processor.writeXdmValue(result, (Destination)se);
                        se.close();
                        s = sw2.toString();
                    }
                    this.saveResultsToFile(s, new File(this.resultsDir + "/results/" + testSetName + "/" + testName + ".out"));
                    xslResultDocuments = outcome.getSecondaryResultDocuments();
                    for (Map.Entry<URI, TestOutcome.SingleResultDoc> entry : xslResultDocuments.entrySet()) {
                        key = entry.getKey();
                        path = key.getPath();
                        serialization = outcome.serialize(env.processor, entry.getValue());
                        this.saveResultsToFile(serialization, new File(path));
                    }
                }
                catch (SaxonApiException err) {
                    if (err.getCause() instanceof XPathException && !((XPathException)err.getCause()).hasBeenReported()) {
                        System.err.println("Unreported ERROR: " + err.getCause());
                    }
                    outcome.setException(err);
                    if (collector.getErrorCodes().isEmpty()) {
                        outcome.addReportedError(err.getErrorCode().getLocalName());
                    }
                    outcome.setErrorsReported(collector.getErrorCodes());
                }
                catch (Exception err) {
                    err.printStackTrace();
                    ++this.failures;
                    this.resultsDoc.writeTestcaseElement(testName, "fail", "*** crashed " + err.getClass() + ": " + err.getMessage());
                    return;
                }
            } else {
                try {
                    transformer = sheet.load();
                    transformer.setURIResolver((URIResolver)env);
                    transformer.setBaseOutputURI(baseOutputURI);
                    if (env.unparsedTextResolver != null) {
                        transformer.getUnderlyingController().setUnparsedTextURIResolver(env.unparsedTextResolver);
                    }
                    if (initialTemplateName != null) {
                        transformer.setInitialTemplate(initialTemplateName);
                    }
                    if (initialMode != null) {
                        try {
                            transformer.setInitialMode(initialModeName);
                        }
                        catch (IllegalArgumentException e) {
                            if (e.getCause() instanceof XPathException) {
                                collector.fatalError((TransformerException)((XPathException)e.getCause()));
                                throw new SaxonApiException(e.getCause());
                            }
                            throw e;
                        }
                    }
                    for (XdmItem param : xpath.evaluate("param[not(@static='yes')]", (XdmItem)testInput)) {
                        name = ((XdmNode)param).getAttributeValue(new QName("name"));
                        select = ((XdmNode)param).getAttributeValue(new QName("select"));
                        try {
                            value = xpath.evaluate(select, null);
                        }
                        catch (SaxonApiException e) {
                            System.err.println("*** Error evaluating parameter " + name + ": " + e.getMessage());
                            throw e;
                        }
                        transformer.setParameter(new QName(name), value);
                    }
                    if (contextItem != null) {
                        transformer.setInitialContextNode((XdmNode)contextItem);
                    }
                    if (env.streamedFile != null) {
                        transformer.setSource((Source)new StreamSource(env.streamedFile));
                    } else if (env.streamedContent != null) {
                        transformer.setSource((Source)new StreamSource(new StringReader(env.streamedContent), "inlineDoc"));
                    }
                    for (QName varName : env.params.keySet()) {
                        transformer.setParameter(varName, env.params.get(varName));
                    }
                    transformer.setErrorListener((ErrorListener)collector);
                    transformer.setMessageListener(new MessageListener(){

                        public void message(XdmNode content, boolean terminate, SourceLocator locator) {
                            outcome.addXslMessage(content);
                            System.err.println(content.getStringValue());
                        }
                    });
                    sw = new StringWriter();
                    serializer = env.processor.newSerializer((Writer)sw);
                    transformer.setDestination((Destination)serializer);
                    transformer.getUnderlyingController().setOutputURIResolver((OutputURIResolver)new OutputResolver(env.processor, outcome, true));
                    transformer.transform();
                    outcome.setPrincipalSerializedResult(sw.toString());
                    if (this.saveResults) {
                        this.saveResultsToFile(sw.toString(), new File(this.resultsDir + "/results/" + testSetName + "/" + testName + ".out"));
                        xslResultDocuments = outcome.getSecondaryResultDocuments();
                        for (Map.Entry<URI, TestOutcome.SingleResultDoc> entry : xslResultDocuments.entrySet()) {
                            key = entry.getKey();
                            if (key == null) continue;
                            path = key.getPath();
                            serialization = outcome.serialize(env.processor, entry.getValue());
                            this.saveResultsToFile(serialization, new File(path));
                        }
                    }
                    if (env.streamedContent != null) {
                        transformer.setSource((Source)new StreamSource(new StringReader(env.streamedContent), "inlineDoc"));
                    }
                    destination = new XdmDestination();
                    transformer.setDestination((Destination)destination);
                    transformer.getUnderlyingController().setOutputURIResolver((OutputURIResolver)new OutputResolver(env.processor, outcome, false));
                    transformer.transform();
                    outcome.setPrincipalResult((XdmValue)destination.getXdmNode());
                    outcome.setWarningsReported(collector.getFoundWarnings());
                }
                catch (SaxonApiException err) {
                    outcome.setException(err);
                    if (collector.getErrorCodes().isEmpty()) {
                        outcome.addReportedError(err.getErrorCode().getLocalName());
                    } else {
                        outcome.setErrorsReported(collector.getErrorCodes());
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                    ++this.failures;
                    this.resultsDoc.writeTestcaseElement(testName, "fail", "*** crashed " + err.getClass() + ": " + err.getMessage());
                    return;
                }
            }
        }
lbl322:
        // 10 sources

        for (Environment.ResetAction action : env.resetActions) {
            action.reset(env);
        }
        env.resetActions.clear();
        assertion = (XdmNode)xpath.evaluateSingle("result/*", (XdmItem)testCase);
        if (assertion == null) {
            ++this.failures;
            this.resultsDoc.writeTestcaseElement(testName, "fail", "No test assertions found");
            return;
        }
        assertionXPath = env.processor.newXPathCompiler();
        success = outcome.testAssertion(assertion, outcome.getPrincipalResultDoc(), assertionXPath, xpath, this.debug);
        if (success) {
            if (outcome.getWrongErrorMessage() != null) {
                outcome.setComment(outcome.getWrongErrorMessage());
                ++this.wrongErrorResults;
            } else {
                ++this.successes;
            }
            this.resultsDoc.writeTestcaseElement(testName, "pass", outcome.getComment());
        } else {
            ++this.failures;
            this.resultsDoc.writeTestcaseElement(testName, "fail", outcome.getComment());
        }
    }

    protected Map<QName, XdmValue> getNamedParameters(XPathCompiler xpath, XdmNode node, boolean getStatic, boolean tunnel) throws SaxonApiException {
        HashMap<QName, XdmValue> params = new HashMap<QName, XdmValue>();
        int i = 1;
        String staticTest = getStatic ? "@static='yes'" : "not(@static='yes')";
        for (XdmItem param : xpath.evaluate("param[" + staticTest + "]", (XdmItem)node)) {
            XdmValue value;
            boolean required;
            QName name = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, param, "@name");
            String select = ((XdmNode)param).getAttributeValue(new QName("select"));
            String tunnelled = ((XdmNode)param).getAttributeValue(new QName("tunnel"));
            boolean bl = required = tunnel == (tunnelled != null && tunnelled.equals("yes"));
            if (name == null) {
                System.err.println("*** No name for parameter " + i + " in initial-template");
                throw new SaxonApiException("*** No name for parameter " + i + " in initial-template");
            }
            try {
                value = xpath.evaluate(select, null);
                ++i;
            }
            catch (SaxonApiException e) {
                System.err.println("*** Error evaluating parameter " + name + " in initial-template : " + e.getMessage());
                throw e;
            }
            if (!required) continue;
            params.put(name, value);
        }
        return params;
    }

    protected XdmValue[] getParameters(XPathCompiler xpath, XdmNode node) throws SaxonApiException {
        ArrayList<XdmValue> params = new ArrayList<XdmValue>();
        int i = 1;
        for (XdmItem param : xpath.evaluate("param[not(@static='yes')]", (XdmItem)node)) {
            XdmValue value;
            String select = ((XdmNode)param).getAttributeValue(new QName("select"));
            try {
                value = xpath.evaluate(select, null);
                ++i;
            }
            catch (SaxonApiException e) {
                System.err.println("*** Error evaluating parameter " + i + " in initial-function : " + e.getMessage());
                throw e;
            }
            params.add(value);
        }
        return params.toArray(new XdmValue[0]);
    }

    protected void saveResultsToFile(String content, File file) {
        try {
            if (!file.exists()) {
                File directory = file.getParentFile();
                if (directory != null && !directory.exists()) {
                    directory.mkdirs();
                }
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file);
            writer.append(content);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("*** Failed to save results to " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    protected void assertOptimization(XsltExecutable stylesheet, String assertion) throws SaxonApiException {
        XdmDestination builder = new XdmDestination();
        stylesheet.explain((Destination)builder);
        builder.close();
        XdmNode expressionTree = builder.getXdmNode();
        XPathCompiler xpe = stylesheet.getProcessor().newXPathCompiler();
        XPathSelector exp = xpe.compile(assertion).load();
        exp.setContextItem((XdmItem)expressionTree);
        XdmAtomicValue bv = (XdmAtomicValue)exp.evaluateSingle();
        if (!bv.getBooleanValue()) {
            this.println("** Optimization assertion failed");
            this.println(expressionTree.toString());
            throw new SaxonApiException("Expected optimization not performed");
        }
    }

    @Override
    public boolean dependencyIsSatisfied(XdmNode dependency, Environment env) {
        String type = dependency.getNodeName().getLocalName();
        String value = dependency.getAttributeValue(new QName("value"));
        boolean inverse = "false".equals(dependency.getAttributeValue(new QName("satisfied")));
        if ("spec".equals(type)) {
            boolean atLeast = value.endsWith("+");
            value = value.replace("+", "");
            String specName = this.spec.specAndVersion.replace("XT", "XSLT");
            int order = value.compareTo(specName);
            return atLeast ? order <= 0 : order == 0;
        }
        if ("feature".equals(type)) {
            if ("XML_1.1".equals(value) && !inverse) {
                if (env != null) {
                    env.resetActions.add(new Environment.ResetAction(){

                        public void reset(Environment env) {
                            env.processor.setXmlVersion("1.0");
                        }
                    });
                    env.processor.setXmlVersion("1.1");
                    return true;
                }
                return false;
            }
            if ("disabling_output_escaping".equals(value)) {
                return !inverse;
            }
            if ("schema_aware".equals(value)) {
                return false;
            }
            if ("namespace_axis".equals(value)) {
                return !inverse;
            }
            if ("streaming".equals(value)) {
                return false;
            }
            if ("backwards_compatibility".equals(value)) {
                return !inverse;
            }
            if ("Saxon-PE".equals(value)) {
                return false;
            }
            if ("Saxon-EE".equals(value)) {
                return false;
            }
            return false;
        }
        if ("xsd-version".equals(type)) {
            return false;
        }
        if ("available_documents".equals(type)) {
            return !inverse;
        }
        if ("default_language_for_numbering".equals(type)) {
            return !inverse;
        }
        if ("languages_for_numbering".equals(type)) {
            return env.processor.getSaxonEdition().equals("HE") ? inverse : !inverse;
        }
        if ("supported_calendars_in_date_formatting_functions".equals(type)) {
            return !inverse;
        }
        if ("default_calendar_in_date_formatting_functions".equals(type)) {
            return !inverse;
        }
        if ("maximum_number_of_decimal_digits".equals(type)) {
            return !inverse;
        }
        if ("default_output_encoding".equals(type)) {
            return !inverse;
        }
        if ("unparsed_text_encoding".equals(type)) {
            return !inverse;
        }
        if ("year_component_values".equals(type)) {
            return !inverse;
        }
        if ("additional_normalization_form".equals(type)) {
            return !inverse;
        }
        if ("recognize_id_as_uri_fragment".equals(type)) {
            return !inverse;
        }
        if ("on-multiple-match".equals(type)) {
            env.resetActions.add(new Environment.ResetAction(){

                public void reset(Environment env) {
                    env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(1);
                }
            });
            if (value.equals("error")) {
                env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(2);
            } else {
                env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(0);
            }
            return true;
        }
        if ("ignore-doc-failure".equals(type)) {
            env.resetActions.add(new Environment.ResetAction(){

                public void reset(Environment env) {
                    env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(1);
                }
            });
            if (value.equals("false")) {
                env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(2);
            } else {
                env.xsltCompiler.getUnderlyingCompilerInfo().setRecoveryPolicy(0);
            }
            return true;
        }
        if ("combinations_for_numbering".equals(type)) {
            return !inverse;
        }
        this.println("**** dependency not recognized: " + type);
        return false;
    }

    protected static QName getQNameAttribute(XPathCompiler xpath, XdmItem contextItem, String attributePath) throws SaxonApiException {
        String exp = "for $att in " + attributePath + " return if (contains($att, ':')) then resolve-QName($att, $att/..) else " + " if (contains($att,'{')) then QName(substring-before(substring-after($att,'{'),'}'),substring-after($att,'}')) else" + " QName('', $att)";
        XdmAtomicValue qname = (XdmAtomicValue)xpath.evaluateSingle(exp, contextItem);
        return qname == null ? null : (QName)qname.getValue();
    }

    protected static class OutputResolver
    implements OutputURIResolver {
        private Processor proc;
        private TestOutcome outcome;
        private Destination destination;
        private StringWriter stringWriter;
        boolean serialized;
        URI uri;

        public OutputResolver(Processor proc, TestOutcome outcome, boolean serialized) {
            this.proc = proc;
            this.outcome = outcome;
            this.serialized = serialized;
        }

        public OutputResolver newInstance() {
            return new OutputResolver(this.proc, this.outcome, this.serialized);
        }

        public Result resolve(String href, String base) throws XPathException {
            try {
                this.uri = new URI(base).resolve(href);
                if (this.serialized) {
                    this.stringWriter = new StringWriter();
                    StreamResult result = new StreamResult(this.stringWriter);
                    result.setSystemId(this.uri.toString());
                    return result;
                }
                this.destination = new XdmDestination();
                ((XdmDestination)this.destination).setBaseURI(this.uri);
                return this.destination.getReceiver(this.proc.getUnderlyingConfiguration());
            }
            catch (SaxonApiException e) {
                throw new XPathException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new XPathException((Throwable)e);
            }
        }

        public void close(Result result) throws XPathException {
            if (this.serialized) {
                this.outcome.setSecondaryResult(this.uri, null, this.stringWriter == null ? "" : this.stringWriter.toString());
            } else {
                XdmDestination xdm = (XdmDestination)this.destination;
                if (xdm != null) {
                    this.outcome.setSecondaryResult(xdm.getBaseURI(), xdm.getXdmNode(), null);
                }
            }
        }
    }
}

