/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj;

import com.saxonica.xqj.SaxonXQConnection;
import com.saxonica.xqj.SaxonXQDataFactory;
import com.saxonica.xqj.SaxonXQDynamicContext;
import com.saxonica.xqj.SaxonXQForwardSequence;
import com.saxonica.xqj.SaxonXQSequence;
import com.saxonica.xqj.SaxonXQSequenceType;
import com.saxonica.xqj.SaxonXQStaticContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntHashSet;

public class SaxonXQPreparedExpression
extends SaxonXQDynamicContext
implements XQPreparedExpression {
    private XQueryExpression expression;
    private SaxonXQStaticContext staticContext;
    private DynamicQueryContext context;
    private boolean scrollable;
    private static QName[] EMPTY_QNAME_ARRAY = new QName[0];

    protected SaxonXQPreparedExpression(SaxonXQConnection connection, XQueryExpression expression, SaxonXQStaticContext sqc, DynamicQueryContext context) throws XQException {
        this.connection = connection;
        this.expression = expression;
        this.staticContext = new SaxonXQStaticContext(sqc);
        this.context = context;
        this.scrollable = sqc.getScrollability() == 2;
        this.setClosableContainer(connection);
    }

    protected DynamicQueryContext getDynamicContext() {
        return this.context;
    }

    protected SaxonXQConnection getConnection() {
        return this.connection;
    }

    protected SaxonXQDataFactory getDataFactory() throws XQException {
        if (this.connection.isClosed()) {
            this.close();
        }
        this.checkNotClosed();
        return this.connection;
    }

    protected XQueryExpression getXQueryExpression() {
        return this.expression;
    }

    protected SaxonXQStaticContext getSaxonXQStaticContext() {
        return this.staticContext;
    }

    public void cancel() throws XQException {
        this.checkNotClosed();
    }

    public XQResultSequence executeQuery() throws XQException {
        this.checkNotClosed();
        try {
            SequenceIterator iter = this.expression.iterator(this.context);
            if (this.scrollable) {
                SequenceExtent value = new SequenceExtent(iter);
                return new SaxonXQSequence((GroundedValue)value, this);
            }
            return new SaxonXQForwardSequence(new FocusTrackingIterator(iter), this);
        }
        catch (XPathException de) {
            XQException xqe = new XQException(de.getMessage());
            xqe.initCause(de);
            throw xqe;
        }
    }

    public QName[] getAllExternalVariables() throws XQException {
        this.checkNotClosed();
        List vars = this.expression.getExecutable().getCompiledGlobalVariables();
        if (vars == null || vars.isEmpty()) {
            return EMPTY_QNAME_ARRAY;
        }
        HashSet<StructuredQName> params = new HashSet<StructuredQName>(vars.size());
        for (GlobalVariable var : vars) {
            StructuredQName q;
            if (!(var instanceof GlobalParam) || (q = var.getVariableQName()).equals((Object)StandardNames.SAXON_CONTEXT_ITEM)) continue;
            params.add(q);
        }
        QName[] qnames = new QName[params.size()];
        int q = 0;
        for (StructuredQName name : params) {
            qnames[q++] = new QName(name.getURI(), name.getLocalPart(), name.getPrefix());
        }
        return qnames;
    }

    public QName[] getAllUnboundExternalVariables() throws XQException {
        this.checkNotClosed();
        Collection boundParameters = this.getDynamicContext().getParameters().getKeys();
        IntHashSet unbound = new IntHashSet(boundParameters.size());
        QName[] all = this.getAllExternalVariables();
        for (int i = 0; i < all.length; ++i) {
            StructuredQName sq = new StructuredQName("", all[i].getNamespaceURI(), all[i].getLocalPart());
            if (boundParameters.contains(sq)) continue;
            unbound.add(i);
        }
        QName[] unboundq = new QName[unbound.size()];
        int c = 0;
        for (int x : unbound) {
            unboundq[c++] = all[x];
        }
        return unboundq;
    }

    public XQStaticContext getStaticContext() throws XQException {
        this.checkNotClosed();
        return this.staticContext;
    }

    public XQSequenceType getStaticResultType() throws XQException {
        this.checkNotClosed();
        Expression exp = this.expression.getExpression();
        ItemType itemType = exp.getItemType();
        int cardinality = exp.getCardinality();
        SequenceType staticType = SequenceType.makeSequenceType((ItemType)itemType, (int)cardinality);
        return new SaxonXQSequenceType(staticType, this.connection.getConfiguration());
    }

    public XQSequenceType getStaticVariableType(QName name) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(name);
        StructuredQName qn = new StructuredQName(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart());
        for (GlobalVariable var : this.expression.getExecutable().getCompiledGlobalVariables()) {
            if (!(var instanceof GlobalParam) || !var.getVariableQName().equals((Object)qn)) continue;
            return new SaxonXQSequenceType(var.getRequiredType(), this.connection.getConfiguration());
        }
        throw new XQException("Variable " + name + " is not declared");
    }

    protected boolean externalVariableExists(QName name) {
        StructuredQName qn = new StructuredQName(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart());
        for (GlobalVariable var : this.expression.getExecutable().getCompiledGlobalVariables()) {
            if (!(var instanceof GlobalParam) || !var.getVariableQName().equals((Object)qn)) continue;
            return true;
        }
        return false;
    }

    private void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }
}

