#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals

"""
拼音库，来源于[在线汉语字典](http://zi.artx.cn/zi/)

单字只有 3029 个多音字，但 segment 一个词库的词有 7万余个词包含多音字。
其中可以从[在线汉语词典](http://zi.artx.cn/ci/)查到的有 4万余个词。

XXX: 34 个未知读音字（部分通过 Google Translage 查询到读音，2 个未查到）：
[硳硛猠鞥旕乥怾穒椧莻夞巼喸闏朩哛兺迲囕栍虄縇襨屗曢桛烪聁艈虲蝊闧瓲龥]
"""

pinyin_dict = {
    "吖": "yā,ā",
    "阿": "ā,ē",
    "呵": "hē,a,kē",
    "嗄": "shà,á",
    "啊": "ā,á,ǎ,à,a",
    "腌": "ā,yān",
    "锕": "ā",
    "錒": "ā",
    "矮": "ǎi",
    "爱": "ài",
    "挨": "āi,ái",
    "哎": "āi",
    "碍": "ài",
    "癌": "ái",
    "艾": "ài",
    "唉": "āi,ài",
    "蔼": "ǎi",
    "埃": "āi",
    "哀": "āi",
    "呆": "dāi",
    "嗌": "yì,ài",
    "嫒": "ài",
    "瑷": "ài",
    "隘": "ài",
    "暧": "ài",
    "捱": "ái",
    "砹": "ài",
    "嗳": "ǎi,ài,āi",
    "锿": "āi",
    "皑": "ái",
    "霭": "ǎi",
    "乂": "yì",
    "乃": "nǎi",
    "僾": "ài",
    "伌": "ài",
    "凒": "ái",
    "儗": "nǐ,yì",
    "剴": "kǎi",
    "剀": "kǎi",
    "叆": "ài,yǐ",
    "呃": "è",
    "嘊": "ái",
    "噫": "yī",
    "堨": "è,ài,yè",
    "呝": "è",
    "噯": "ǎi,ài,āi",
    "壒": "ài",
    "塧": "ài",
    "啀": "ái",
    "奇": "qí,jī",
    "娭": "xī,āi",
    "娾": "ǎi,ái,è",
    "嵦": "kǎi,ái",
    "嬡": "ài",
    "懝": "ài,yì,nǐ",
    "懓": "ài",
    "敱": "ái,zhú",
    "愛": "ài",
    "敳": "ái,zhú",
    "欬": "kài,ài",
    "毐": "ǎi",
    "欸": "èi,ǎi",
    "昹": "ǎi",
    "曖": "ài",
    "溾": "āi",
    "濭": "ǎi,kài,kè",
    "烠": "huí,huǐ",
    "溰": "ái",
    "焥": "wò,ài",
    "璦": "ài",
    "硋": "ài",
    "皧": "ài",
    "磑": "wèi,ái,gài",
    "瞹": "ài",
    "皚": "ái",
    "礙": "ài",
    "薆": "ài",
    "絠": "gǎi,ǎi",
    "諰": "xǐ,shāi,āi",
    "譪": "ǎi",
    "藹": "ǎi",
    "譺": "ài",
    "躷": "ǎi",
    "醷": "yì",
    "賹": "ài",
    "鑀": "ài",
    "閡": "hé",
    "鎄": "āi",
    "阂": "hé",
    "阸": "è",
    "阨": "è",
    "隑": "qí,gāi,ái",
    "靉": "ài",
    "靄": "ǎi",
    "騃": "sì",
    "馤": "ài",
    "餲": "ài",
    "鯦": "jiù",
    "鱫": "ài",
    "鴱": "ài",
    "崖": "yá",
    "安": "ān",
    "按": "àn",
    "岸": "àn",
    "暗": "àn",
    "案": "àn",
    "俺": "ǎn",
    "鞍": "ān",
    "胺": "àn",
    "氨": "ān",
    "厂": "chǎng,ān,hàn",
    "庵": "ān",
    "广": "guǎng,ān",
    "揞": "ǎn",
    "犴": "hān,àn",
    "铵": "ǎn",
    "谙": "ān",
    "埯": "ǎn",
    "鹌": "ān",
    "侒": "ān",
    "黯": "àn",
    "儑": "án,àn",
    "桉": "ān",
    "匼": "kē,qià",
    "厈": "hàn,àn",
    "咹": "è,àn",
    "啽": "ān,án",
    "垵": "ǎn",
    "垾": "hàn",
    "堓": "àn",
    "婩": "nüè",
    "媕": "ān",
    "唵": "ǎn",
    "屽": "hàn,àn",
    "峖": "ān",
    "晻": "àn,ǎn,yǎn",
    "洝": "àn,yàn,è",
    "玵": "án,gān",
    "干": "gān,gàn",
    "痷": "ān,yè,è",
    "盒": "hé",
    "盫": "ān",
    "碪": "zhēn",
    "盦": "ān",
    "腤": "ān",
    "罯": "ǎn",
    "荌": "àn",
    "菴": "ān",
    "萻": "ān",
    "蓭": "ān",
    "裺": "yǎn,ān",
    "誝": "ān",
    "豻": "àn",
    "貋": "àn",
    "諳": "ān",
    "葊": "ān",
    "錌": "àn",
    "鉗": "qián",
    "銨": "ǎn",
    "钳": "qián",
    "闇": "àn",
    "隂": "yīn",
    "隌": "àn",
    "陰": "yīn",
    "雸": "án",
    "遃": "yǎn",
    "鞌": "ān",
    "韽": "ān",
    "頞": "è",
    "頇": "hān",
    "顸": "hān",
    "馣": "ān",
    "鮟": "ān",
    "鴳": "yàn",
    "鶕": "ān",
    "鵪": "ān",
    "昂": "áng",
    "肮": "āng",
    "盎": "àng",
    "仰": "yǎng,áng",
    "岇": "áng",
    "卬": "yǎng,áng",
    "昻": "áng",
    "枊": "àng",
    "醃": "yān",
    "醠": "àng",
    "凹": "āo,wā",
    "袄": "ǎo",
    "骯": "āng",
    "傲": "ào",
    "奥": "ào,yù",
    "翱": "áo",
    "敖": "áo",
    "澳": "ào",
    "嚣": "xiāo",
    "熬": "āo,áo",
    "拗": "ǎo,ào,niù",
    "媪": "ǎo",
    "骜": "áo",
    "廒": "áo",
    "懊": "ào",
    "嗷": "áo",
    "坳": "ào",
    "遨": "áo",
    "聱": "áo",
    "螯": "áo",
    "獒": "áo",
    "鏊": "ào",
    "鳌": "áo",
    "厫": "áo",
    "鏖": "áo",
    "嗸": "áo",
    "嚻": "xiāo",
    "噢": "ō",
    "岙": "ào",
    "垇": "ào",
    "囂": "xiāo",
    "墺": "ào",
    "墽": "qiāo,áo",
    "奡": "ào",
    "奧": "ào,yù",
    "媼": "ǎo",
    "岰": "ào",
    "嶅": "áo,ào",
    "嫯": "ào",
    "慠": "ào,áo",
    "扷": "bā,ào",
    "嶴": "ào",
    "抝": "ǎo,ào,niù",
    "摮": "áo,qiáo",
    "擙": "ào",
    "柪": "āo,ào",
    "梎": "āo,yòu",
    "泑": "yōu,yòu,āo",
    "滶": "áo",
    "浇": "jiāo",
    "棍": "gùn,hùn",
    "澆": "jiāo",
    "澚": "ào,yù",
    "熝": "lù,āo",
    "爊": "āo",
    "獓": "áo",
    "璈": "áo",
    "眑": "yǎo,āo,ǎo",
    "磝": "áo,qiāo",
    "翶": "áo",
    "礉": "hé,qiāo,qiào",
    "磽": "qiāo",
    "翺": "áo",
    "芺": "ǎo",
    "蔜": "áo",
    "蝹": "yūn",
    "謷": "áo",
    "謸": "áo",
    "郩": "xiáo,ǎo",
    "軪": "āo,ào",
    "襖": "ǎo",
    "镺": "ǎo",
    "鏕": "lù,áo",
    "隞": "áo",
    "鴁": "yāo",
    "鴢": "yāo",
    "驁": "ào",
    "鼇": "áo",
    "鰲": "áo",
    "鷔": "áo",
    "八": "bā",
    "爸": "bà",
    "把": "bǎ,bà",
    "吧": "bā,ba",
    "拔": "bá",
    "巴": "bā",
    "跋": "bá",
    "罢": "bà,ba,pí",
    "扒": "bā,pá",
    "坝": "bà",
    "芭": "bā",
    "霸": "bà",
    "靶": "bǎ",
    "叭": "bā",
    "笆": "bā",
    "疤": "bā",
    "耙": "bà,pá",
    "捌": "bā",
    "粑": "bā",
    "岜": "bā",
    "茇": "bá",
    "钯": "bǎ,pá",
    "鲅": "bà",
    "菝": "bá",
    "仈": "bā",
    "魃": "bá",
    "灞": "bà",
    "叐": "bá",
    "哱": "pò,bā,bō",
    "坺": "fá",
    "哵": "bā",
    "伯": "bó,bǎi,bà",
    "垻": "bà",
    "墢": "fá",
    "夿": "bā",
    "妭": "bá",
    "峇": "kè,bā",
    "弝": "bà",
    "壩": "bà",
    "抜": "bá",
    "抪": "bù,pū",
    "朳": "bā",
    "捭": "bǎi",
    "柭": "bā,fú,pèi,bó,biē",
    "欛": "bà",
    "杷": "pá",
    "炦": "bá",
    "湃": "pài",
    "玐": "bā",
    "犮": "quǎn,bá",
    "癹": "bá",
    "皅": "pā,bà",
    "矲": "bà",
    "笩": "fá",
    "紦": "hā",
    "羓": "bā",
    "罷": "bà,ba,pí",
    "胈": "bá",
    "茷": "fá",
    "蚆": "bā",
    "覇": "bà,pò",
    "萆": "bì",
    "詙": "bá",
    "豝": "bā",
    "跁": "bà,páo",
    "軷": "bá",
    "釛": "hé",
    "釟": "bā",
    "魞": "bā,bà",
    "颰": "bá,fú",
    "鮊": "bó,bà",
    "鈀": "bǎ",
    "鲃": "bā,bà",
    "鲌": "bó,bà",
    "鮁": "bà",
    "鼥": "bá",
    "百": "bǎi",
    "白": "bái",
    "摆": "bǎi",
    "柏": "bǎi,bó,bò",
    "败": "bài",
    "佰": "bǎi",
    "呗": "bei,bài",
    "稗": "bài",
    "拜": "bài",
    "拝": "bài",
    "庍": "bài,tīng",
    "唄": "bei,bài",
    "挀": "bāi",
    "掰": "bāi",
    "栢": "bǎi",
    "猈": "bài,pí",
    "排": "pái,pǎi",
    "擺": "bǎi",
    "竡": "bǎi",
    "敗": "bài",
    "粨": "bǎi",
    "粺": "bài",
    "派": "pài",
    "絔": "bǎi,mò",
    "薭": "bài",
    "贁": "bài",
    "襬": "bǎi",
    "鞁": "bèi",
    "薜": "bì",
    "韛": "bài",
    "鞴": "bèi",
    "半": "bàn",
    "班": "bān",
    "般": "bān",
    "办": "bàn",
    "拌": "bàn,pàn",
    "搬": "bān",
    "版": "bǎn",
    "斑": "bān",
    "板": "bǎn",
    "伴": "bàn",
    "扳": "bān",
    "扮": "bàn",
    "癍": "bān",
    "瓣": "bàn",
    "颁": "bān",
    "绊": "bàn",
    "坂": "bǎn",
    "钣": "bǎn",
    "舨": "bǎn",
    "瘢": "bān",
    "阪": "bǎn",
    "並": "bìng",
    "坢": "pǎn,bàn",
    "埿": "ní",
    "分": "fēn,fèn",
    "姅": "bàn",
    "岅": "bǎn",
    "怑": "bàn",
    "搫": "pán,bān,pó",
    "彬": "bīn",
    "攽": "bān",
    "斒": "bān",
    "昄": "bǎn",
    "朌": "fén,bān",
    "柈": "pán,bàn",
    "湴": "bàn,pán",
    "秚": "bàn",
    "瓪": "bǎn",
    "粄": "bǎn",
    "籓": "fān,pān,biān",
    "肦": "bān",
    "蝂": "bǎn",
    "絆": "bàn",
    "螁": "bān",
    "螌": "bān",
    "褩": "bān",
    "跘": "pán,bàn",
    "覂": "fěng",
    "辧": "biàn",
    "豳": "bīn",
    "辨": "biàn",
    "辦": "bàn",
    "辩": "biàn",
    "辬": "bān",
    "鉡": "bàn",
    "辯": "biàn",
    "鈑": "bǎn",
    "靽": "bàn",
    "魬": "bǎn",
    "闆": "bǎn,pàn",
    "鳻": "bān,fén",
    "頒": "bān",
    "帮": "bāng",
    "棒": "bàng",
    "绑": "bǎng",
    "磅": "bàng,páng",
    "镑": "bàng",
    "邦": "bāng",
    "榜": "bǎng,bàng",
    "蚌": "bàng,bèng",
    "傍": "bàng",
    "梆": "bāng",
    "膀": "bǎng",
    "谤": "bàng",
    "浜": "bāng",
    "嗙": "bēng,pǎng",
    "垹": "bāng",
    "埲": "běng",
    "塝": "bàng",
    "嫎": "páng",
    "峀": "xiù",
    "幚": "bāng",
    "幇": "bāng",
    "崗": "gǎng,gāng",
    "蒡": "bàng",
    "幫": "bāng",
    "彭": "péng,bāng",
    "徬": "páng",
    "挷": "bàng,péng",
    "捠": "bāng",
    "搒": "bàng,péng",
    "棓": "bàng,pǒu,bèi,bēi",
    "旁": "páng,bàng",
    "玤": "bàng",
    "牓": "bǎng",
    "稖": "bàng",
    "硥": "mǎng,bàng",
    "綁": "bǎng",
    "紡": "fǎng",
    "縍": "bāng,bàng",
    "艕": "bàng",
    "纺": "fǎng",
    "蚄": "fāng,bàng",
    "蛖": "máng,bàng",
    "蜯": "bàng",
    "邫": "bāng",
    "螃": "páng",
    "謗": "bàng",
    "騯": "péng",
    "鞤": "bāng",
    "髈": "bǎng",
    "鎊": "bàng",
    "包": "bāo",
    "报": "bào",
    "抱": "bào",
    "饱": "bǎo",
    "保": "bǎo",
    "暴": "bào,pù",
    "薄": "báo,bó,bò",
    "宝": "bǎo",
    "爆": "bào",
    "豹": "bào",
    "剥": "bāo,bō",
    "刨": "páo,bào",
    "雹": "báo",
    "堡": "bǎo,bǔ,pù",
    "褒": "bāo",
    "苞": "bāo",
    "胞": "bāo",
    "鲍": "bào",
    "炮": "páo,bāo,pào",
    "龅": "bāo",
    "瀑": "pù,bào",
    "孢": "bāo",
    "褓": "bǎo",
    "鸨": "bǎo",
    "趵": "bào,bō",
    "煲": "bāo",
    "儤": "bào",
    "佨": "bāo",
    "勹": "bāo",
    "葆": "bǎo",
    "勽": "bào",
    "剝": "bāo,bō",
    "嘐": "xiāo,jiāo",
    "嚗": "bó,pào,bào",
    "堢": "bǎo",
    "嫑": "biáo",
    "報": "bào",
    "寚": "bǎo",
    "寳": "bǎo",
    "忁": "bào",
    "怉": "bǎo,bào",
    "媬": "bǎo",
    "曓": "bào",
    "寶": "bǎo",
    "珤": "bǎo",
    "枹": "bāo,fú",
    "砲": "pào",
    "窇": "báo",
    "笣": "bāo",
    "緥": "bǎo",
    "菢": "bào",
    "簿": "bù,bó",
    "藵": "bǎo",
    "蕔": "bāo",
    "虣": "bào",
    "蚫": "bào",
    "袌": "bào,páo,pào",
    "裒": "póu",
    "袍": "páo",
    "裦": "bāo",
    "襃": "bāo",
    "賲": "bǎo",
    "鉋": "bào",
    "鑤": "bào",
    "铇": "bào",
    "闁": "bāo",
    "靤": "pào",
    "靌": "bǎo",
    "飹": "bǎo",
    "駂": "bǎo",
    "髱": "bào",
    "鳵": "bǎo",
    "飽": "bǎo",
    "骲": "bào",
    "鮑": "bào",
    "齙": "bāo",
    "鴇": "bǎo",
    "宀": "mián",
    "萡": "bó",
    "被": "bèi,pī",
    "倍": "bèi",
    "杯": "bēi",
    "背": "bèi,bēi",
    "悲": "bēi",
    "备": "bèi",
    "碑": "bēi",
    "北": "běi,bèi",
    "卑": "bēi",
    "辈": "bèi",
    "贝": "bèi",
    "钡": "bèi",
    "焙": "bèi",
    "狈": "bèi",
    "惫": "bèi",
    "褙": "bèi",
    "臂": "bì,bei",
    "悖": "bèi",
    "蓓": "bèi",
    "鹎": "bēi",
    "鐾": "bèi",
    "陂": "bēi,pí,pō",
    "孛": "bèi",
    "碚": "bèi",
    "俻": "bèi",
    "偝": "bèi",
    "偹": "bèi",
    "僃": "bèi",
    "俾": "bǐ",
    "喺": "xí",
    "備": "bèi",
    "邶": "bèi",
    "埤": "pí,pì",
    "愂": "bèi",
    "怫": "fú",
    "揹": "bēi",
    "昁": "bèi",
    "憊": "bèi",
    "杮": "fèi,bèi",
    "柸": "bēi,pēi",
    "桮": "bēi",
    "梖": "bèi",
    "椑": "bēi",
    "棑": "pái,bèi,pèi",
    "波": "bō",
    "牬": "bèi",
    "犕": "bèi",
    "琲": "bèi",
    "痺": "bì",
    "珼": "bèi",
    "狽": "bèi",
    "盃": "bēi",
    "禙": "bèi",
    "糒": "bèi",
    "箃": "zōu",
    "苝": "bèi",
    "茀": "fú",
    "萯": "fù",
    "菩": "pú",
    "藣": "bēi",
    "蛽": "bèi",
    "葡": "pú",
    "誖": "bèi,bó",
    "諀": "pǐ,bēi",
    "蜚": "fēi",
    "軰": "bèi",
    "貝": "bèi",
    "鄁": "bèi",
    "錍": "pī",
    "輩": "bèi",
    "鐴": "bì",
    "鋇": "bèi",
    "鉳": "běi",
    "本": "běn",
    "鵯": "bēi",
    "苯": "běn",
    "锛": "bēn",
    "奔": "bēn,bèn",
    "骳": "bèi,mó",
    "贲": "bì,bēn",
    "畚": "běn",
    "倴": "bèn",
    "笨": "bèn",
    "坌": "bèn",
    "夯": "hāng,bèn",
    "喯": "pèn,bēn",
    "体": "tǐ,tī,bèn",
    "夲": "tāo,běn",
    "奙": "běn",
    "捹": "bèn",
    "撪": "bèn",
    "楍": "běn",
    "桳": "bèn,fàn",
    "泍": "bēn,bèn",
    "渀": "bèn",
    "炃": "fén,bèn",
    "燌": "fén",
    "犇": "bēn",
    "獖": "fén,fèn",
    "蟦": "fèi,bēn",
    "翉": "běn",
    "輽": "fàn",
    "賁": "bì,bēn",
    "逩": "bèn",
    "錛": "bēn",
    "鐼": "fén",
    "蹦": "bèng",
    "甭": "béng",
    "绷": "bēng,běng,bèng",
    "崩": "bēng",
    "迸": "bèng",
    "泵": "bèng",
    "嘣": "bēng",
    "甏": "bèng",
    "俸": "fèng",
    "伻": "bēng",
    "傰": "péng",
    "埄": "běng,fēng",
    "塴": "bèng",
    "堋": "péng,bèng",
    "唪": "fěng",
    "奟": "bēng",
    "嵭": "bēng",
    "抨": "pēng",
    "平": "píng",
    "漨": "féng,péng",
    "熢": "péng,fēng",
    "琫": "běng",
    "琣": "běng,pěi",
    "痭": "bēng,péng",
    "絣": "bēng,bīng,pēng",
    "祊": "bēng,fāng",
    "菶": "běng",
    "綳": "bēng,běng,bèng",
    "跰": "pián,bèng",
    "逬": "bèng",
    "繃": "bēng,běng,bèng",
    "鏰": "bèng",
    "錋": "péng",
    "閍": "bēng",
    "镚": "bèng",
    "鞛": "běng",
    "笔": "bǐ",
    "比": "bǐ",
    "鼻": "bí",
    "闭": "bì",
    "碧": "bì",
    "避": "bì",
    "必": "bì",
    "逼": "bī",
    "毕": "bì",
    "壁": "bì",
    "彼": "bǐ",
    "鄙": "bǐ",
    "币": "bì",
    "蓖": "bì",
    "弊": "bì",
    "蔽": "bì",
    "辟": "bì,pì",
    "敝": "bì",
    "毙": "bì",
    "庇": "bì",
    "毖": "bì",
    "陛": "bì",
    "痹": "bì",
    "秘": "mì,bì",
    "秕": "bǐ",
    "荸": "bí",
    "泌": "mì,bì",
    "匕": "bǐ",
    "裨": "bì,pí",
    "芘": "bì,pí",
    "畀": "bì",
    "嬖": "bì",
    "狴": "bì",
    "筚": "bì",
    "箅": "bì",
    "篦": "bì",
    "舭": "bǐ",
    "荜": "bì",
    "襞": "bì",
    "庳": "bēi",
    "铋": "bì",
    "跸": "bì",
    "吡": "pǐ,bǐ",
    "愎": "bì",
    "滗": "bì",
    "濞": "bì,pì",
    "璧": "bì",
    "哔": "bì",
    "髀": "bì",
    "弼": "bì",
    "仳": "pǐ,pí",
    "婢": "bì",
    "妣": "bǐ",
    "佊": "bǐ",
    "偪": "bī",
    "匂": "xiōng",
    "佛": "fó,fú,bì,bó",
    "咇": "bì",
    "啚": "bǐ,tú",
    "佖": "bì",
    "坒": "bì",
    "堛": "bì",
    "嗶": "bì",
    "夶": "bǐ",
    "奰": "bì",
    "复": "fù",
    "妼": "bì",
    "娝": "pōu,bǐ",
    "嬶": "bí",
    "屄": "bī",
    "媲": "pì",
    "崥": "pí,bǐ",
    "幤": "bì",
    "幅": "fú",
    "幣": "bì",
    "廦": "bì",
    "弻": "bì",
    "彃": "bì",
    "庀": "pǐ",
    "怶": "bì,pī",
    "悂": "pī,pǐ",
    "愊": "bì",
    "怭": "bì",
    "旇": "pī,bì",
    "拂": "fú,bì",
    "服": "fú,fù",
    "朼": "bǐ",
    "斃": "bì",
    "柀": "bǐ",
    "枈": "pī,mì",
    "枇": "pí",
    "柲": "bì,bié",
    "梐": "bì",
    "楅": "bī",
    "檗": "bò",
    "殍": "piǎo",
    "毴": "bī",
    "沘": "bǐ",
    "滭": "bì",
    "煏": "bì",
    "熚": "bì",
    "湢": "bì",
    "獘": "bì",
    "潷": "bì",
    "獙": "bì",
    "珌": "bì",
    "畁": "bì,qí",
    "畐": "fú,bì",
    "疕": "bǐ",
    "疪": "bì",
    "皀": "jí,bī",
    "畢": "bì",
    "皕": "bì",
    "禆": "bì,pí",
    "稫": "pì,bì",
    "笓": "pí,bì",
    "箆": "bì",
    "箄": "pái,bēi",
    "瞥": "piē",
    "粃": "bǐ",
    "筆": "bǐ",
    "篳": "bì",
    "粊": "bì",
    "紴": "bō,bì",
    "紕": "pī,pí,bǐ",
    "綼": "bì",
    "縪": "bì",
    "繴": "bì",
    "罼": "bì",
    "翍": "pī,bì,pō",
    "聛": "bǐ",
    "肶": "pí,bǐ,bì",
    "纰": "pī,pí,bǐ",
    "胇": "fèi,bì",
    "腗": "pí",
    "肸": "xī",
    "腷": "bì",
    "脾": "pí",
    "苾": "bì",
    "萞": "bì",
    "蘗": "bò",
    "蓽": "bì",
    "蜌": "bì",
    "螕": "bī,pí",
    "虑": "lǜ",
    "袐": "bì",
    "襅": "bì",
    "襣": "bì",
    "觱": "bì",
    "詖": "bì",
    "诐": "bì",
    "豍": "bī",
    "貏": "bǐ",
    "貱": "bì",
    "费": "fèi",
    "費": "fèi",
    "贔": "bì",
    "踾": "fú",
    "蹕": "bì",
    "赑": "bì",
    "跛": "bǒ",
    "躃": "bì",
    "躄": "bì",
    "邲": "bì",
    "鄨": "bì",
    "鄪": "bì",
    "鈚": "pī",
    "鎞": "bī,bì,pī",
    "鏎": "bì",
    "鉍": "bì",
    "閇": "bì",
    "閈": "hàn,bì",
    "閉": "bì",
    "閟": "bì",
    "鞞": "bǐng,pí,bì,bēi",
    "闬": "hàn,bì",
    "陴": "pī",
    "鞸": "bì,bǐng",
    "韠": "bì",
    "饆": "bì",
    "飶": "bì",
    "馝": "bì",
    "駜": "bì",
    "馥": "fù",
    "驆": "bì",
    "髲": "bì,pǒ",
    "魓": "bì",
    "魮": "pí",
    "鮅": "bì",
    "鮩": "bìng",
    "鰏": "bī",
    "鲾": "bī",
    "鴓": "miè",
    "鵖": "bī",
    "鶝": "fú,bì",
    "鷝": "bì",
    "鸊": "pì",
    "鷩": "bì",
    "鼊": "bì",
    "髟": "biāo",
    "边": "biān",
    "变": "biàn",
    "便": "biàn,pián",
    "遍": "biàn",
    "扁": "biǎn,piān",
    "编": "biān",
    "贬": "biǎn",
    "鞭": "biān",
    "卞": "biàn",
    "辫": "biàn",
    "忭": "biàn",
    "匾": "biǎn",
    "砭": "biān",
    "汴": "biàn",
    "碥": "biǎn",
    "蝙": "biān",
    "笾": "biān",
    "鳊": "biān",
    "褊": "biǎn",
    "苄": "biàn",
    "缏": "biàn,pián",
    "窆": "biǎn",
    "弁": "biàn",
    "煸": "biān",
    "変": "biàn",
    "峅": "biàn",
    "徧": "biàn",
    "封": "fēng",
    "惼": "biǎn",
    "抃": "biàn",
    "揙": "biǎn",
    "昪": "biàn",
    "拚": "pàn,pīn,fān",
    "炞": "biān",
    "牑": "biān,miàn",
    "猵": "biān,piàn",
    "獱": "biān,piàn",
    "汳": "biàn",
    "甂": "biān",
    "疺": "fá,biǎn",
    "稨": "biǎn",
    "稹": "zhěn",
    "箯": "biān",
    "糄": "biān,biǎn",
    "籩": "biān",
    "編": "biān",
    "臱": "mián,biān",
    "艑": "biàn",
    "緶": "biàn,pián",
    "萹": "biān",
    "藊": "biǎn",
    "覍": "biàn",
    "覵": "jiàn,biǎn",
    "變": "biàn",
    "貶": "biǎn",
    "辡": "biàn",
    "邉": "biān",
    "辮": "biàn",
    "釆": "biàn",
    "鍽": "biān",
    "邊": "biān",
    "閞": "biàn,guān",
    "鞕": "biān,yìng",
    "頨": "yǔ",
    "鯾": "biān",
    "鴘": "biǎn",
    "鶣": "piān,biǎn",
    "鯿": "biān",
    "表": "biǎo",
    "标": "biāo",
    "彪": "biāo",
    "膘": "biāo",
    "杓": "sháo,biāo",
    "婊": "biǎo",
    "飑": "biāo",
    "飙": "biāo",
    "鳔": "biào",
    "瘭": "biāo",
    "飚": "biāo",
    "裱": "biǎo",
    "镳": "biāo",
    "骠": "piào,biāo",
    "僄": "piào,biāo",
    "镖": "biāo",
    "俵": "biào",
    "儦": "biāo",
    "墂": "biāo",
    "幖": "biāo",
    "剽": "piāo",
    "徱": "piào",
    "嫖": "piáo,piāo",
    "檦": "biāo,biǎo",
    "標": "biāo",
    "淲": "biāo,hǔ",
    "摽": "biào,biāo",
    "滮": "biāo",
    "瀌": "biāo",
    "熛": "biāo",
    "漂": "piāo,piǎo,piào",
    "爂": "biāo",
    "灬": "huǒ,biāo",
    "猋": "biāo",
    "穮": "biāo,pāo",
    "篻": "piǎo,biāo",
    "膔": "lù,biāo",
    "脿": "biāo",
    "臕": "biāo",
    "蔈": "biāo",
    "褾": "biǎo",
    "藨": "biāo,pāo",
    "諘": "biǎo",
    "謤": "biāo",
    "贆": "biāo",
    "錶": "biǎo",
    "鏢": "biāo",
    "颷": "biāo",
    "颮": "biāo",
    "鑣": "biāo",
    "飇": "biāo",
    "飆": "biāo",
    "飊": "biāo",
    "飈": "biāo",
    "驫": "biāo",
    "骉": "biāo",
    "驃": "piào",
    "麃": "páo,biāo",
    "鰾": "piào",
    "别": "bié,biè",
    "憋": "biē",
    "瘪": "biē,biě",
    "鳖": "biē",
    "彆": "biè",
    "蹩": "bié",
    "撆": "piē",
    "別": "bié,biè",
    "徶": "bié",
    "猰": "yà,jiá,qiè",
    "撇": "piē,piě",
    "癟": "biē,biě",
    "穪": "chēng,chèn,chèng",
    "莂": "bié",
    "蛂": "bié",
    "虌": "biē",
    "蟞": "biē,bié",
    "襒": "bié",
    "鼈": "biē",
    "龞": "biē",
    "鱉": "biē",
    "宾": "bīn",
    "濒": "bīn",
    "摈": "bìn",
    "斌": "bīn",
    "殡": "bìn",
    "滨": "bīn",
    "膑": "bìn",
    "髌": "bìn",
    "缤": "bīn",
    "槟": "bīn,bīng",
    "傧": "bīn",
    "鬓": "bìn",
    "镔": "bīn",
    "玢": "bīn,fēn",
    "儐": "bīn,bìn",
    "份": "fèn,bīn",
    "氞": "nèi",
    "擯": "bìn",
    "椕": "bīn",
    "殯": "bìn",
    "汃": "bīn,pà,pā",
    "濵": "bīn",
    "瑸": "bīn,pián",
    "濱": "bīn",
    "璸": "bīn,pián",
    "瀕": "bīn",
    "砏": "pīn,bīn,fēn",
    "虨": "bīn",
    "繽": "bīn",
    "蠙": "pín",
    "臏": "bìn",
    "訜": "fēn",
    "賔": "bīn",
    "贇": "yūn",
    "赟": "yūn",
    "賓": "bīn",
    "豩": "bīn",
    "邠": "bīn",
    "霦": "bīn",
    "鑌": "bīn",
    "顮": "bīn",
    "頻": "bīn",
    "频": "pín,bīn",
    "髩": "bìn",
    "鬂": "bìn",
    "髕": "bìn",
    "鬢": "bìn",
    "并": "bìng,bīng",
    "病": "bìng",
    "兵": "bīng",
    "冰": "bīng",
    "丙": "bǐng",
    "饼": "bǐng",
    "屏": "píng,bǐng",
    "秉": "bǐng",
    "柄": "bǐng",
    "摒": "bìng",
    "炳": "bǐng",
    "仌": "bīng",
    "禀": "bǐng",
    "邴": "bǐng",
    "倂": "bìng",
    "偋": "bǐng,bìng",
    "併": "bìng",
    "傡": "bìng",
    "垪": "bìng",
    "冫": "bīng",
    "寎": "bǐng,bìng",
    "庰": "bìng,píng",
    "幷": "bìng,bīng",
    "怲": "bǐng",
    "抦": "bǐng",
    "掤": "bīng",
    "昞": "bǐng",
    "昺": "bǐng",
    "栟": "bēn,bīng",
    "栤": "bìng",
    "梹": "bīn,bīng",
    "枋": "fāng,bìng",
    "棅": "bǐng",
    "氷": "bīng",
    "燷": "lán",
    "檳": "bīn,bīng",
    "琕": "pín,bǐng",
    "癛": "lǐn",
    "癝": "lǐn",
    "燹": "xiǎn",
    "眪": "bǐng,fǎng",
    "窉": "bìng",
    "稟": "bǐng",
    "竝": "bìng",
    "綆": "gěng",
    "苪": "bǐng",
    "绠": "gěng",
    "蛃": "bīng",
    "誁": "bìng",
    "鈵": "bǐng",
    "鉼": "bǐng,píng",
    "鋲": "bīng",
    "陃": "bǐng",
    "靐": "bìng",
    "鞆": "bǐng",
    "餠": "bǐng",
    "疒": "nè",
    "餅": "bǐng",
    "驳": "bó",
    "拨": "bō",
    "播": "bō",
    "博": "bó",
    "泊": "bó,pō",
    "勃": "bó,bèi",
    "玻": "bō",
    "菠": "bō",
    "钵": "bō",
    "搏": "bó",
    "脖": "bó",
    "帛": "bó",
    "渤": "bó",
    "舶": "bó",
    "铂": "bó",
    "箔": "bó",
    "魄": "pò",
    "膊": "bó",
    "卜": "bǔ,bo",
    "礴": "bó",
    "亳": "bó",
    "啵": "bo",
    "鹁": "bó",
    "踣": "bó",
    "蕃": "fán",
    "簸": "bò,bǒ",
    "钹": "bó",
    "仢": "bó",
    "擘": "bò,bāi",
    "饽": "bō",
    "侼": "bó",
    "僠": "bō",
    "噃": "fān,bo",
    "僰": "bó",
    "募": "mù",
    "孹": "bò",
    "壆": "xué,bó,jué",
    "嶓": "bō",
    "彴": "zhuó,bó",
    "帗": "fú",
    "懪": "bó",
    "怕": "pà",
    "愽": "bó",
    "挬": "bó",
    "拍": "pāi",
    "擗": "pǐ,bò",
    "撥": "bō",
    "桲": "bó",
    "檘": "píng,bò",
    "欂": "bó",
    "殕": "fǒu,bó",
    "榑": "fú,fù,bó",
    "浡": "bó",
    "淿": "bó",
    "湐": "pò",
    "泼": "pō",
    "煿": "bó",
    "潑": "pō",
    "牔": "bó",
    "犦": "bào",
    "潘": "pān",
    "犻": "pèi,fèi",
    "狛": "bó",
    "猼": "bó,pò",
    "瓝": "bó",
    "瓟": "bó,páo",
    "癶": "bō",
    "番": "fān,pān",
    "皪": "lì,luò,bō",
    "發": "fā",
    "砵": "bō",
    "盋": "bō",
    "礡": "bō",
    "秡": "bó",
    "磻": "pán,bō",
    "碆": "bō",
    "穛": "zhuō,bó",
    "箥": "pǒ",
    "簙": "bó",
    "糪": "bó",
    "肑": "bó,dí",
    "艊": "bó",
    "胉": "bó",
    "缽": "bō",
    "苩": "pā,bó",
    "葧": "bó",
    "蔢": "pó",
    "艴": "fú",
    "蒲": "pú",
    "袚": "fú",
    "蔔": "bo",
    "蚾": "pí,bǒ",
    "蘖": "niè",
    "袯": "bó",
    "袹": "bó,mò",
    "襎": "fán",
    "襏": "bó",
    "譒": "bò",
    "襮": "bó",
    "豰": "hù",
    "蹳": "bō",
    "郣": "bó",
    "跑": "pǎo,páo",
    "鋍": "bó",
    "鈸": "bó",
    "鉑": "bó",
    "鎛": "bó",
    "鉢": "bō",
    "鑮": "bó",
    "镈": "bó",
    "餺": "bó",
    "馛": "bó",
    "餑": "bō",
    "駮": "bó",
    "駁": "bó",
    "馞": "bó",
    "馎": "bó",
    "驋": "bō",
    "髆": "bó",
    "髉": "bó,jué",
    "鱍": "bō",
    "不": "bù,fǒu",
    "补": "bǔ",
    "布": "bù",
    "鵓": "bó",
    "步": "bù",
    "部": "bù",
    "捕": "bǔ",
    "哺": "bǔ",
    "埠": "bù",
    "怖": "bù",
    "埔": "pǔ,bù",
    "瓿": "bù",
    "晡": "bū",
    "逋": "bū",
    "钚": "bù",
    "钸": "bū",
    "醭": "bú",
    "佈": "bù",
    "卟": "bǔ",
    "勏": "bù",
    "吥": "bù",
    "咘": "bù",
    "僕": "pú",
    "埗": "bù",
    "婄": "pǒu,péi,bù",
    "尃": "fū",
    "峬": "bū",
    "廍": "bù",
    "悑": "bù",
    "捗": "bù,pú,zhì",
    "庯": "bū",
    "拊": "fǔ",
    "捬": "fǔ,fù,bǔ",
    "擈": "pǔ",
    "歨": "bù",
    "撲": "pū",
    "柨": "bù,pū",
    "歩": "bù",
    "獛": "pú",
    "溥": "pǔ",
    "秿": "fù,pū",
    "箁": "póu,bù,fú,pú",
    "篰": "bù",
    "荹": "bù",
    "蔀": "bù",
    "誧": "bū",
    "踄": "bù",
    "輹": "fù",
    "補": "bǔ",
    "轐": "bú",
    "郶": "bù",
    "鈈": "bù",
    "陠": "pū",
    "餔": "bū",
    "餢": "bù",
    "鈽": "bū",
    "附": "fù",
    "鯆": "pū,bū",
    "鳪": "bú",
    "鵏": "bū",
    "鸔": "bǔ",
    "拆": "chāi,cā",
    "擦": "cā",
    "嚓": "cā,chā",
    "囃": "zá,cà",
    "傪": "cān,càn",
    "礤": "cǎ",
    "攃": "cā,sǎ",
    "橴": "zǐ",
    "礸": "cǎ",
    "遪": "cà",
    "磣": "chěn",
    "蔡": "cài",
    "才": "cái",
    "菜": "cài",
    "采": "cǎi,cài",
    "财": "cái",
    "材": "cái",
    "裁": "cái",
    "踩": "cǎi",
    "猜": "cāi",
    "睬": "cǎi",
    "倸": "cǎi",
    "偲": "cāi,sī",
    "啋": "cǎi",
    "彩": "cǎi",
    "寀": "cǎi,cài",
    "婇": "cǎi",
    "戝": "zéi",
    "扐": "lè,lì,cái",
    "埰": "cǎi,cài",
    "揌": "sāi,zǒng,cāi",
    "棌": "cǎi",
    "縩": "cài",
    "採": "cǎi",
    "綵": "cǎi",
    "纔": "cái",
    "跴": "cǎi",
    "財": "cái",
    "蚕": "cán",
    "残": "cán",
    "惨": "cǎn",
    "掺": "chān,xiān,càn,shǎn",
    "惭": "cán",
    "参": "cān,shēn,cēn,sān",
    "餐": "cān",
    "灿": "càn",
    "骖": "cān",
    "孱": "chán,càn",
    "璨": "càn",
    "黪": "cǎn",
    "粲": "càn",
    "儏": "càn",
    "叄": "cān,shēn,cēn,sān",
    "參": "cān,shēn,cēn,sān",
    "嘇": "shān,càn",
    "喰": "cān,sūn,qī",
    "噆": "zǎn",
    "叅": "cān,shēn,cēn,sān",
    "囋": "zá,zàn,cān",
    "嬠": "cān",
    "嵾": "cēn",
    "嬱": "qiàn",
    "慙": "cán",
    "憯": "cǎn",
    "摲": "chàn,cán",
    "慘": "cǎn",
    "戔": "jiān",
    "朁": "cǎn,qián,jiàn",
    "殘": "cán",
    "湌": "cān",
    "淺": "qiǎn",
    "慚": "cán",
    "澯": "càn",
    "爘": "cān",
    "穇": "cǎn,shān,cēn",
    "燦": "càn",
    "薒": "càn",
    "篸": "cēn,zān,cǎn",
    "蝅": "cán",
    "謲": "càn",
    "蠺": "cán",
    "蹔": "zàn",
    "蠶": "cán",
    "飱": "sūn",
    "鏒": "sǎn,qiāo,càn",
    "鯵": "shēn",
    "鰺": "shēn",
    "鲹": "shēn",
    "驂": "cān",
    "飡": "cān",
    "黲": "cǎn",
    "藏": "cáng,zàng",
    "仓": "cāng",
    "沧": "cāng",
    "舱": "cāng",
    "伧": "cāng,chen",
    "仺": "cāng",
    "倉": "cāng",
    "苍": "cāng",
    "凔": "cāng",
    "匨": "zāng,cáng",
    "傖": "cāng,chen",
    "嵢": "cāng",
    "欌": "cáng",
    "濸": "cāng",
    "獊": "cāng",
    "滄": "cāng",
    "瑲": "qiāng,cāng",
    "篬": "qiāng,cāng",
    "罉": "chēng",
    "螥": "cāng",
    "臧": "zāng,zàng,cáng",
    "蒼": "cāng",
    "賶": "càng",
    "鑶": "cáng",
    "艙": "cāng",
    "鸧": "cāng",
    "鶬": "cāng,qiāng",
    "蔵": "zàng",
    "草": "cǎo",
    "操": "cāo",
    "曹": "cáo",
    "槽": "cáo",
    "糙": "cāo",
    "嘈": "cáo",
    "艚": "cáo",
    "傮": "zāo,cáo",
    "螬": "cáo",
    "嶆": "cáo",
    "漕": "cáo",
    "愺": "cǎo",
    "屮": "chè,cǎo",
    "慅": "cǎo,sāo",
    "懆": "cǎo,sāo,sào",
    "撡": "cāo",
    "肏": "cào",
    "曺": "cáo",
    "艸": "cǎo",
    "艹": "ǎo",
    "慒": "cáo,cóng",
    "蓸": "cáo",
    "澡": "zǎo",
    "褿": "cáo",
    "襙": "cào",
    "鏪": "cáo",
    "鄵": "cào",
    "鐰": "qiāo",
    "造": "zào",
    "騲": "cǎo",
    "鼜": "cào",
    "册": "cè",
    "侧": "cè,zè,zhāi",
    "测": "cè",
    "策": "cè",
    "厕": "cè",
    "恻": "cè",
    "冊": "cè",
    "厠": "cè",
    "側": "cè,zè,zhāi",
    "嫧": "zé",
    "墄": "qī",
    "帻": "zé",
    "幘": "zé",
    "廁": "cè",
    "拺": "cè,sè,chuò",
    "敇": "cè",
    "憡": "cè",
    "惻": "cè",
    "畟": "cè,jì",
    "柵": "shān",
    "栅": "zhà,shān,shi,cè",
    "測": "cè",
    "笧": "cè",
    "筞": "cè",
    "筴": "cè",
    "箣": "cè",
    "簎": "cè,jí",
    "粣": "cè,sè",
    "荝": "cè",
    "萴": "cè",
    "萗": "cè",
    "蓛": "cè",
    "齰": "zé",
    "赦": "shè",
    "刂": "dāo",
    "涔": "cén",
    "岑": "cén",
    "梣": "chén",
    "硶": "chěn",
    "汵": "gàn,hán,cén",
    "笒": "cén,jìn,hán",
    "膥": "cūn",
    "层": "céng",
    "曾": "zēng,céng",
    "蹭": "cèng",
    "僧": "sēng",
    "噌": "cēng",
    "橧": "zēng,céng",
    "嶒": "céng",
    "增": "zēng",
    "竲": "céng,zēng",
    "層": "céng",
    "驓": "céng",
    "硳": "chì",  #  Unknow.
    "缯": "zēng,zèng",
    "硛": "yì",   # Unknow.
    "繒": "zēng,zèng",
    "岾": "zhān",
    "猠": "diǎn",  # Unknow.
    "乽": "zhě",
    "查": "chá,zhā",
    "插": "chā",
    "叉": "chā,chá,chǎ",
    "茶": "chá",
    "差": "chà,chā,chāi,cī",
    "岔": "chà",
    "搽": "chá",
    "茬": "chá",
    "碴": "chá,chā",
    "察": "chá",
    "楂": "zhā,chá",
    "诧": "chà",
    "刹": "chà,shā",
    "槎": "chá",
    "镲": "chǎ",
    "衩": "chà",
    "馇": "chā",
    "汊": "chà",
    "檫": "chá",
    "姹": "chà",
    "杈": "chā,chà",
    "仛": "tuō,chà,duó",
    "偛": "chā",
    "侘": "chà",
    "锸": "chā",
    "嗏": "chā",
    "剎": "chà,shā",
    "垞": "chá",
    "土": "tǔ",
    "岎": "fén",
    "奼": "chà",
    "扠": "chā",
    "扱": "xī,chā,qì",
    "挿": "chā",
    "捈": "tú,shū,chá",
    "嵖": "chá",
    "摖": "qì,jì,chá",
    "揷": "chā",
    "捷": "jié",
    "接": "jiē",
    "査": "chá,zhā",
    "梌": "tú,chá",
    "斜": "xié",
    "秅": "chá,ná",
    "紁": "chà,chǎ",
    "肞": "chāi",
    "臿": "chā",
    "猹": "chá",
    "疀": "chā",
    "艖": "chā",
    "芆": "chā",
    "荖": "lǎo",
    "褨": "suǒ",
    "苴": "jū,chá",
    "荼": "tú",
    "訍": "chài",
    "詧": "chá",
    "蹅": "chǎ",
    "銟": "chā",
    "詫": "chà",
    "釵": "chāi",
    "鎈": "cuō,chā",
    "靫": "chá",
    "鍤": "chā",
    "鑔": "chǎ",
    "钗": "chāi",
    "餷": "chā",
    "喳": "zhā,chā",
    "柴": "chái",
    "豺": "chái",
    "瘥": "chài,cuó",
    "虿": "chài",
    "侪": "chái",
    "儕": "chái",
    "勑": "chì",
    "囆": "chài",
    "喍": "chái",
    "犲": "chái",
    "祡": "chái",
    "搓": "cuō",
    "蔕": "dì",
    "茈": "zǐ",
    "茝": "chǎi",
    "袃": "chài",
    "蠆": "chài",
    "龇": "zī",
    "齜": "zī",
    "产": "chǎn",
    "缠": "chán",
    "搀": "chān",
    "阐": "chǎn",
    "颤": "chàn,zhàn",
    "铲": "chǎn",
    "谗": "chán",
    "蝉": "chán",
    "单": "dān,shàn,chán",
    "馋": "chán",
    "觇": "chān",
    "婵": "chán",
    "蒇": "chǎn",
    "谄": "chǎn",
    "冁": "chǎn",
    "廛": "chán",
    "蟾": "chán",
    "羼": "chàn",
    "镡": "xín",
    "忏": "chàn",
    "潺": "chán",
    "禅": "chán,shàn",
    "骣": "chǎn",
    "躔": "chán",
    "澶": "chán",
    "亶": "dǎn,dàn",
    "丳": "chǎn",
    "佔": "zhàn,diān",
    "僝": "zhàn,zhuàn,chán",
    "僤": "dàn",
    "儃": "chán,tǎn,shàn",
    "儳": "chán,chàn",
    "兎": "tù",
    "刬": "chǎn,chàn",
    "兔": "tù",
    "剷": "chǎn",
    "剗": "chǎn,chàn",
    "単": "dān",
    "劖": "chán",
    "啴": "tān,chǎn,tuō",
    "嘽": "tān,chǎn",
    "厘": "lí",
    "單": "dān,shàn,chán",
    "嚵": "chán",
    "墠": "shàn",
    "囅": "chǎn",
    "團": "tuán",
    "壥": "chán",
    "嬗": "shàn",
    "嶃": "zhǎn,chán",
    "嬋": "chán",
    "崭": "zhǎn,chán",
    "嵼": "chǎn",
    "幝": "chǎn,chàn",
    "嶄": "zhǎn,chán",
    "幨": "chān,chàn",
    "巉": "chán",
    "懴": "chàn",
    "憚": "dàn,dá",
    "摌": "chǎn,sùn",
    "懺": "chàn",
    "掸": "dǎn,shàn",
    "摻": "chān,xiān,càn,shǎn",
    "斺": "chǎn,jiè",
    "棎": "chán",
    "旵": "chǎn",
    "梴": "chān,yán",
    "攙": "chān",
    "榐": "zhǎn,niǎn,zhèn",
    "撣": "dǎn,shàn",
    "毚": "chán",
    "欃": "chán,zhàn",
    "浐": "chǎn",
    "湹": "chán",
    "滻": "chǎn",
    "潹": "chán",
    "渐": "jiàn,jiān",
    "瀍": "chán",
    "瀺": "chán",
    "漸": "jiàn,jiān",
    "灛": "chǎn",
    "沾": "zhān",
    "煘": "chán",
    "燀": "chǎn,dǎn,chàn",
    "獑": "chán",
    "硟": "chàn",
    "產": "chǎn",
    "産": "chǎn",
    "磛": "chán",
    "簅": "chǎn",
    "緾": "chán",
    "禪": "shàn,chán",
    "繟": "chǎn,chán",
    "繵": "dàn,tán,chán",
    "緂": "tián,tǎn,chān",
    "纒": "chán",
    "脠": "shān",
    "纏": "chán",
    "艬": "chán",
    "胀": "zhàng",
    "螹": "chán,jiàn",
    "苫": "shān,shàn",
    "蕆": "chǎn",
    "蟺": "shàn",
    "袩": "zhé",
    "蟬": "chán",
    "裧": "chān",
    "襌": "dān",
    "襜": "chān",
    "裣": "liǎn",
    "誗": "chán",
    "襝": "liǎn",
    "覘": "chān",
    "譂": "chǎn",
    "讇": "chǎn",
    "諂": "chǎn",
    "讖": "chèn",
    "讒": "chán",
    "谶": "chèn",
    "蹍": "niǎn",
    "辿": "chān",
    "鄽": "chán",
    "酁": "chán",
    "醦": "chǎn,chěn",
    "鉆": "zuān",
    "鋋": "chán",
    "鋓": "chān",
    "镵": "chán",
    "鑱": "chán",
    "鏟": "chǎn",
    "閳": "chǎn",
    "韂": "chàn",
    "闡": "chǎn",
    "顫": "chàn",
    "饞": "chán",
    "长": "cháng,zhǎng",
    "唱": "chàng",
    "场": "cháng,chǎng",
    "常": "cháng",
    "尝": "cháng",
    "昌": "chāng",
    "肠": "cháng",
    "畅": "chàng",
    "敞": "chǎng",
    "偿": "cháng",
    "倡": "chàng,chāng",
    "猖": "chāng",
    "鲳": "chāng",
    "裳": "cháng,shang",
    "氅": "chǎng",
    "菖": "chāng",
    "嫦": "cháng",
    "惝": "chǎng",
    "徜": "cháng",
    "阊": "chāng",
    "鬯": "chàng",
    "怅": "chàng",
    "伥": "chāng",
    "仧": "cháng,zhǎng",
    "苌": "cháng",
    "昶": "chǎng",
    "娼": "chāng",
    "僘": "chǎng",
    "倀": "chāng",
    "倘": "tǎng,cháng",
    "償": "cháng",
    "儻": "tǎng",
    "兏": "cháng,zhǎng",
    "厰": "chǎng",
    "嚐": "cháng",
    "嘗": "cháng",
    "塲": "cháng,chǎng",
    "場": "cháng,chǎng",
    "尙": "shàng",
    "尚": "shàng",
    "廠": "chǎng",
    "晿": "chēng",
    "悵": "chàng",
    "暢": "chàng",
    "棖": "chéng",
    "淐": "chāng",
    "椙": "chāng",
    "淌": "tǎng,chǎng",
    "焻": "chàng",
    "玚": "chàng,yáng",
    "琩": "chāng",
    "瑒": "chàng,yáng",
    "瑺": "cháng",
    "瓺": "cháng",
    "甞": "cháng",
    "畼": "chàng",
    "脹": "zhàng",
    "膓": "cháng",
    "腸": "cháng",
    "蟐": "chán",
    "誯": "chàng",
    "萇": "cháng",
    "裮": "chāng",
    "鋿": "shǎng",
    "鋹": "chǎng",
    "錩": "chāng",
    "鏛": "shǎng",
    "锠": "chāng",
    "镸": "cháng",
    "闛": "táng,tāng,chāng",
    "長": "cháng,zhǎng",
    "韔": "chàng",
    "閶": "chāng",
    "鱨": "cháng",
    "鯧": "chāng",
    "鼚": "chāng",
    "鲿": "cháng",
    "朝": "zhāo,cháo",
    "抄": "chāo",
    "吵": "chǎo,chāo",
    "超": "chāo",
    "潮": "cháo",
    "炒": "chǎo",
    "剿": "jiǎo,chāo",
    "嘲": "cháo,zhāo",
    "绰": "chuò,chāo",
    "耖": "chào",
    "钞": "chāo",
    "怊": "chāo",
    "巢": "cháo",
    "仦": "chào",
    "焯": "zhuō,chāo",
    "仯": "chào,miǎo",
    "勦": "jiǎo,chāo",
    "劋": "jiǎo,chāo",
    "晁": "cháo",
    "巐": "chǎo",
    "唠": "lào,láo",
    "巣": "cháo",
    "嘮": "lào,láo",
    "弨": "chāo",
    "摷": "jiǎo,chāo",
    "槱": "yǒu,chǎo",
    "樔": "cháo,jiǎo,chāo",
    "欩": "chāo",
    "漅": "cháo",
    "焣": "chǎo,jù",
    "涛": "tāo",
    "煼": "chǎo",
    "牊": "cháo",
    "濤": "tāo",
    "眧": "chǎo",
    "窲": "cháo",
    "粆": "shā,chǎo",
    "綤": "shào",
    "綽": "chuò,chāo",
    "繛": "chuō,chuò",
    "紹": "shào",
    "縐": "zhòu",
    "罺": "cháo",
    "觘": "chào",
    "绉": "zhòu",
    "绍": "shào",
    "訬": "chāo",
    "謿": "cháo",
    "趠": "chuō,zhuó",
    "謅": "zhōu",
    "趫": "qiáo",
    "诌": "zhōu",
    "轈": "cháo",
    "鄛": "cháo",
    "麨": "chǎo",
    "鼂": "cháo",
    "鈔": "chāo",
    "鼌": "cháo",
    "车": "chē,jū",
    "撤": "chè",
    "扯": "chě",
    "掣": "chè",
    "彻": "chè",
    "尺": "chǐ,chě",
    "澈": "chè",
    "伡": "chē,jū",
    "坼": "chè",
    "俥": "chē,jū",
    "砗": "chē",
    "偖": "chě",
    "勶": "chè",
    "唓": "chē",
    "呫": "tiè,chè",
    "喢": "shà",
    "夛": "duō",
    "多": "duō",
    "奲": "duǒ,chě",
    "宅": "zhái",
    "撦": "chě",
    "揊": "pì,chè",
    "徹": "chè",
    "池": "chí",
    "烢": "chè",
    "焎": "xiè,chè",
    "烲": "xiè,chè",
    "斥": "chì",
    "摰": "niè,chè",
    "瞮": "chè",
    "爡": "chè",
    "硩": "chè",
    "聅": "chè",
    "莗": "chē",
    "硨": "chē",
    "蛼": "chē",
    "詀": "zhān",
    "迠": "chè",
    "頙": "chè",
    "趁": "chèn",
    "謵": "xí",
    "称": "chēng,chèn,chèng",
    "辰": "chén",
    "車": "chē,jū",
    "尘": "chén",
    "臣": "chén",
    "晨": "chén",
    "沉": "chén",
    "陈": "chén",
    "衬": "chèn",
    "橙": "chéng",
    "忱": "chén",
    "郴": "chēn",
    "抻": "chēn",
    "谌": "chén",
    "碜": "chěn",
    "宸": "chén",
    "龀": "chèn",
    "嗔": "chēn",
    "榇": "chèn",
    "儭": "chèn",
    "侲": "zhèn,zhēn",
    "塡": "tián",
    "堪": "kān",
    "嚫": "chèn",
    "琛": "chēn",
    "填": "tián,zhèn",
    "墋": "chěn",
    "夦": "chěn",
    "塵": "chén",
    "愖": "chén,xìn,dān",
    "捵": "chēn",
    "帘": "lián",
    "揨": "chéng",
    "敐": "chén",
    "曟": "chén",
    "桭": "chén,zhèn",
    "枕": "zhěn",
    "棽": "chēn,shēn",
    "棧": "zhàn",
    "樄": "chén",
    "湛": "zhàn",
    "沈": "shěn,chén",
    "櫬": "chèn",
    "烥": "jù",
    "瀋": "shěn",
    "煁": "chén",
    "疢": "chèn",
    "瘎": "chén",
    "疹": "zhěn",
    "瘨": "diān,chēn",
    "眈": "dān",
    "稱": "chēng,chèn,chèng",
    "瞋": "chēn",
    "綝": "lín,chēn",
    "縝": "zhěn",
    "茞": "chén",
    "胂": "shèn",
    "莀": "chén",
    "莐": "chén",
    "蔯": "chén",
    "薼": "chén",
    "肜": "róng,chēn",
    "缜": "zhěn",
    "螴": "chén",
    "訦": "chén",
    "諃": "chēn",
    "襯": "chèn",
    "賝": "chēn",
    "諶": "chén",
    "謓": "chēn",
    "贂": "chěn",
    "趂": "chèn",
    "趻": "chěn",
    "跈": "jiàn,chén",
    "踸": "chěn",
    "軙": "chén",
    "迧": "chén",
    "鍖": "chěn",
    "闖": "chuǎng",
    "闯": "chuǎng",
    "鷐": "chén",
    "霃": "chén",
    "陳": "chén",
    "麎": "chén",
    "齓": "chèn",
    "鈂": "chén",
    "齔": "chèn",
    "乘": "chéng,shèng",
    "盛": "shèng,chéng",
    "成": "chéng",
    "撑": "chēng",
    "秤": "chèng",
    "城": "chéng",
    "诚": "chéng",
    "程": "chéng",
    "惩": "chéng",
    "呈": "chéng",
    "澄": "chéng,dèng",
    "逞": "chěng",
    "骋": "chěng",
    "承": "chéng",
    "塍": "chéng",
    "柽": "chēng",
    "铖": "chéng",
    "酲": "chéng",
    "铛": "dāng,chēng",
    "晟": "shèng,chéng",
    "埕": "chéng",
    "枨": "chéng",
    "瞠": "chēng",
    "乗": "chéng,shèng",
    "侱": "chěng,tǐng",
    "丞": "chéng",
    "蛏": "chēng",
    "裎": "chéng,chěng",
    "偁": "chēng,chèn",
    "僜": "chēng,dēng",
    "呛": "qiāng,qiàng",
    "嗆": "qiāng,qiàng",
    "埩": "zhēng,chéng",
    "净": "jìng,chēng",
    "塖": "chéng",
    "堘": "chéng",
    "娍": "chéng,shèng",
    "宬": "chéng",
    "嵊": "shèng",
    "徎": "chěng,zhèng",
    "庱": "chěng",
    "徴": "zhǐ,zhēng",
    "悜": "chěng",
    "憆": "chēng",
    "徵": "zhǐ,zhēng",
    "憕": "chéng,dèng,zhèng",
    "挰": "chéng",
    "懲": "chéng",
    "抢": "qiāng,qiǎng,chēng",
    "掁": "chéng",
    "摚": "chēng",
    "摤": "qiāng",
    "搶": "qiāng,qiǎng,chēng",
    "峸": "chéng",
    "撜": "zhěng,chéng",
    "朾": "chéng,chēng",
    "撐": "chēng",
    "棦": "chēng",
    "椉": "chéng,shèng",
    "槍": "qiāng",
    "樘": "táng",
    "橖": "táng,chēng",
    "橕": "chēng",
    "檙": "chéng",
    "檉": "chēng",
    "氶": "zhěng,chéng,zhèng",
    "泟": "chēng",
    "洆": "chéng",
    "浧": "yǐng,chéng,yíng",
    "浈": "zhēn",
    "浾": "chēng",
    "淨": "jìng,chēng",
    "溗": "chéng",
    "澂": "chéng",
    "瀓": "chéng,dèng",
    "瀞": "jìng",
    "牚": "chēng,chèng",
    "珵": "chéng",
    "爯": "chēng,chèn",
    "琤": "chēng",
    "畻": "chéng",
    "盯": "dīng",
    "珹": "chéng",
    "睈": "chěng",
    "矃": "nǐng,chēng",
    "碀": "chēng",
    "窚": "chéng",
    "竀": "chēng,chèng",
    "筬": "chéng",
    "絾": "chéng",
    "脀": "zhēng",
    "脭": "chéng",
    "荿": "chéng",
    "虰": "dīng",
    "緽": "chēng",
    "赪": "chēng",
    "蟶": "chēng",
    "赬": "chēng",
    "誠": "chéng",
    "觕": "cū",
    "趟": "tàng,tāng",
    "踜": "lèng",
    "郢": "yǐng",
    "醒": "xǐng",
    "鋮": "chéng",
    "郕": "chéng",
    "鏳": "zhēng",
    "阷": "chēng",
    "鏿": "chēng",
    "鎗": "qiāng,chēng",
    "鐺": "dāng,chēng",
    "靗": "chēng",
    "頳": "chēng",
    "饓": "chēng",
    "鯎": "chéng",
    "吃": "chī",
    "黨": "dǎng",
    "騁": "chěng",
    "騬": "chéng",
    "迟": "chí",
    "翅": "chì",
    "痴": "chī",
    "赤": "chì",
    "耻": "chǐ",
    "侈": "chǐ",
    "齿": "chǐ",
    "持": "chí",
    "驰": "chí",
    "弛": "chí",
    "炽": "chì",
    "匙": "chí,shi",
    "踟": "chí",
    "坻": "dǐ,chí",
    "茌": "chí",
    "饬": "chì",
    "墀": "chí",
    "豉": "chǐ",
    "媸": "chī",
    "褫": "chǐ",
    "哧": "chī",
    "瘛": "chì",
    "敕": "chì",
    "蚩": "chī",
    "啻": "chì",
    "鸱": "chī",
    "眵": "chī",
    "螭": "chī",
    "魑": "chī",
    "叱": "chì",
    "篪": "chí",
    "笞": "chī",
    "彳": "chì",
    "佁": "yǐ,chì",
    "傺": "chì",
    "俿": "hǔ,chí",
    "侙": "chì",
    "卙": "jí",
    "卶": "chǐ",
    "叺": "chǐ",
    "呎": "chǐ",
    "剟": "duō",
    "呬": "xì",
    "呮": "qì,zhī",
    "嗤": "chī",
    "勅": "chì",
    "呹": "yì",
    "啸": "xiào",
    "哆": "duō",
    "喫": "chī",
    "喜": "xǐ",
    "嘨": "xiào",
    "噄": "chī",
    "嘯": "xiào",
    "噭": "jiào,qiào,chī",
    "坘": "dǐ",
    "垑": "chǐ",
    "妛": "chī",
    "屟": "xiè,tì",
    "岻": "dī",
    "彨": "chī",
    "彲": "chī",
    "恜": "chì",
    "奓": "shē,chǐ,zhà",
    "恥": "chǐ",
    "徲": "tí,chí",
    "憏": "chì",
    "懘": "chì",
    "慸": "dì,chì",
    "她": "tā,jiě",
    "扡": "tuō,chǐ,yǐ",
    "慗": "chì",
    "抶": "chì",
    "抬": "tái",
    "拕": "tuō",
    "拸": "yí,chǐ,hài",
    "捇": "huò,chì",
    "拖": "tuō",
    "摛": "chī",
    "搋": "chuāi",
    "提": "tí,dī,dǐ",
    "摴": "chū",
    "攡": "chī",
    "杘": "chì",
    "樆": "lí,chī",
    "欼": "chǐ,chuài",
    "柢": "dǐ,chí",
    "歗": "xiào",
    "歭": "zhì,chí",
    "歯": "chǐ",
    "柅": "nǐ,chì",
    "汖": "pìn",
    "沶": "yí,chí",
    "沱": "tuó",
    "泜": "zhī",
    "治": "zhì",
    "淔": "zhí",
    "湁": "chì",
    "滞": "zhì",
    "滯": "zhì",
    "漦": "chí",
    "灻": "chì",
    "熾": "chì",
    "狋": "yí,quán,chí",
    "瓻": "chī",
    "痓": "zhì",
    "痸": "chì",
    "烾": "chì",
    "瘈": "zhì,chì",
    "癡": "chī",
    "瞝": "chī",
    "眙": "yí,chì",
    "祇": "zhǐ,qí",
    "竾": "chí",
    "移": "yí",
    "筂": "chí",
    "箎": "chí",
    "粚": "chī",
    "离": "lí",
    "糦": "xī",
    "絺": "chī,zhǐ",
    "翄": "chì",
    "翤": "chì",
    "翨": "chì",
    "耛": "sì,chí",
    "肔": "chǐ",
    "箈": "tái,chí",
    "胣": "chǐ",
    "胵": "chī",
    "胝": "zhī",
    "脪": "xìn",
    "腟": "chì",
    "荎": "chí",
    "莉": "lì",
    "芪": "qí",
    "菭": "tái,zhī,chí",
    "蚇": "chǐ",
    "蚳": "chí",
    "蝭": "dì",
    "袲": "chǐ,nuǒ",
    "裭": "chǐ",
    "袳": "chǐ,qǐ,duǒ,nuǒ",
    "訵": "chī",
    "誀": "èr",
    "誃": "yí,chǐ,chì",
    "蛇": "shé,yí",
    "誺": "chī,lài",
    "謘": "chí",
    "謻": "yí",
    "貾": "chí",
    "赿": "chí",
    "趐": "xuè",
    "趍": "qū",
    "趩": "chì",
    "跅": "tuò",
    "跢": "dài,duò,duō,chí",
    "跮": "dié",
    "踶": "dì",
    "踅": "xué",
    "軧": "dǐ",
    "迡": "chí",
    "遅": "chí",
    "迣": "zhì,lì",
    "遟": "chí",
    "遫": "chì",
    "邌": "lí,chí",
    "鉓": "chì",
    "鉹": "chǐ",
    "銐": "chì,lì",
    "鍉": "chí",
    "遲": "chí",
    "離": "lí",
    "雴": "chì",
    "飭": "chì",
    "飾": "shì",
    "餝": "shì",
    "饎": "xī",
    "騺": "zhì",
    "饰": "shì",
    "驪": "lí",
    "鵄": "chī",
    "骊": "lí",
    "鳷": "zhī",
    "鵣": "lài",
    "鴟": "chī",
    "鶒": "chì",
    "馳": "chí",
    "鷘": "chì",
    "鶙": "tí,chí",
    "麶": "chi",
    "鶗": "tí,chí",
    "黐": "chī",
    "齝": "chī",
    "齒": "chǐ",
    "郗": "xī",
    "重": "zhòng,chóng",
    "冲": "chōng,chòng",
    "虫": "chóng",
    "宠": "chǒng",
    "充": "chōng",
    "崇": "chóng",
    "涌": "yǒng,chōng",
    "种": "zhǒng,zhòng,chóng",
    "艟": "chōng",
    "舂": "chōng",
    "忡": "chōng",
    "铳": "chòng",
    "偅": "zhòng,tóng",
    "憧": "chōng",
    "茺": "chōng",
    "喠": "zhǒng,chuáng",
    "傭": "yōng",
    "嘃": "chōng",
    "埫": "chǒng,shǎng",
    "崈": "chóng",
    "寵": "chǒng",
    "憃": "chōng",
    "揰": "chòng,dǒng",
    "僮": "tóng,zhuàng",
    "摏": "chōng",
    "徸": "zhǒng,chōng",
    "樁": "zhuāng",
    "沖": "chōng",
    "漴": "chóng,zhuàng",
    "潼": "tóng",
    "烛": "zhú",
    "浺": "chōng",
    "珫": "chōng",
    "爞": "chóng",
    "痋": "téng,chóng",
    "祌": "zhòng",
    "緟": "chóng,zhòng",
    "罿": "chōng",
    "翀": "chōng",
    "盅": "zhōng",
    "種": "zhǒng,zhòng",
    "茧": "jiǎn",
    "褈": "chóng",
    "蹖": "chōng",
    "蟲": "chóng",
    "衝": "chōng",
    "蹱": "zhōng",
    "蝩": "chóng",
    "酮": "tóng",
    "隀": "chóng",
    "銃": "chòng",
    "抽": "chōu",
    "愁": "chóu",
    "臭": "chòu,xiù",
    "仇": "chóu,qiú",
    "稠": "chóu",
    "绸": "chóu",
    "酬": "chóu",
    "筹": "chóu",
    "畴": "chóu",
    "瞅": "chǒu",
    "踌": "chóu",
    "俦": "chóu",
    "帱": "chóu,dào",
    "惆": "chóu",
    "丑": "chǒu",
    "瘳": "chōu",
    "雠": "chóu",
    "侴": "hào",
    "丒": "chǒu",
    "偢": "chǒu,qiào",
    "吜": "chǒu",
    "嚋": "zhōu,chóu",
    "婤": "zhōu,chōu",
    "圳": "zhèn",
    "妯": "zhóu",
    "媿": "kuì",
    "儔": "chóu",
    "嬦": "chóu",
    "怞": "yóu,chóu",
    "幬": "chóu,dào",
    "懤": "chóu",
    "掫": "zōu,zhōu,chōu",
    "扭": "niǔ",
    "搊": "chōu,zǒu",
    "擣": "dǎo",
    "揄": "yú",
    "杻": "niǔ,chǒu",
    "栦": "chóu",
    "椆": "chóu,zhòu,diāo",
    "檮": "chóu,táo,dǎo",
    "殠": "chòu",
    "燽": "chóu",
    "溴": "xiù",
    "牰": "yòu,chōu",
    "杽": "chǒu",
    "犫": "chōu",
    "犨": "chōu",
    "畤": "zhì,chóu,shì",
    "眣": "dié,tì",
    "盩": "zhōu,chóu",
    "矁": "chǒu",
    "皗": "chóu",
    "篘": "chōu",
    "絒": "chóu",
    "紬": "chōu,chóu",
    "疇": "chóu",
    "籌": "chóu",
    "臰": "chòu",
    "綢": "chóu",
    "菗": "chóu",
    "薵": "chóu,zhòu",
    "裯": "chóu,dāo",
    "譸": "zhōu",
    "讐": "chóu",
    "讎": "chóu",
    "诪": "zhōu,chóu",
    "詶": "chóu",
    "跾": "shū,chōu",
    "遚": "chòu",
    "酧": "chóu",
    "躊": "chóu",
    "醔": "qiú,chōu",
    "醻": "chóu",
    "鈕": "niǔ",
    "醜": "chǒu",
    "钮": "niǔ",
    "魗": "chǒu",
    "鮘": "chou,dài",
    "鯈": "tiáo",
    "雔": "chóu",
    "鲋": "fù",
    "出": "chū",
    "处": "chǔ,chù",
    "初": "chū",
    "锄": "chú",
    "除": "chú",
    "触": "chù",
    "橱": "chú",
    "楚": "chǔ",
    "础": "chǔ",
    "储": "chǔ",
    "搐": "chù",
    "滁": "chú",
    "矗": "chù",
    "畜": "xù,chù",
    "厨": "chú",
    "躇": "chú",
    "雏": "chú",
    "杵": "chǔ",
    "刍": "chú",
    "楮": "chǔ",
    "怵": "chù",
    "亍": "chù",
    "绌": "chù",
    "憷": "chù",
    "蹰": "chú",
    "黜": "chù",
    "蜍": "chú",
    "樗": "chū",
    "俶": "chù,tì",
    "傗": "chù",
    "儊": "chù",
    "処": "chù,chǔ",
    "儲": "chǔ",
    "埱": "chù,tòu",
    "媰": "chú,zòu",
    "嘼": "chù,xù,shòu",
    "岀": "chū",
    "幮": "chú",
    "助": "zhù,chú",
    "慉": "xù,chù",
    "廚": "chú",
    "拀": "zhù",
    "懨": "yān",
    "摢": "hù,chū",
    "敊": "chù,shōu",
    "椘": "chǔ",
    "斶": "chù",
    "槒": "xù",
    "柠": "níng",
    "榋": "chū",
    "檚": "chǔ",
    "櫉": "chú",
    "橻": "cū,chu",
    "櫖": "lǜ,chū",
    "欪": "chù,qù,xì",
    "櫥": "chú",
    "歜": "chù",
    "涂": "tú",
    "滀": "chù,xù",
    "淑": "shū",
    "濋": "chǔ",
    "炪": "zhuō,chù",
    "犓": "chú",
    "珿": "chù",
    "琡": "shū",
    "硫": "liú",
    "礎": "chǔ",
    "祝": "zhù",
    "璴": "chǔ",
    "禇": "chǔ",
    "竌": "chù",
    "絀": "chù",
    "竐": "chù,qì",
    "耝": "qù,chú",
    "絮": "xù",
    "篨": "chú",
    "菆": "zōu,chù",
    "耡": "chú",
    "著": "zhù,zhuó,zhe",
    "臅": "chù",
    "蒢": "chú",
    "蓫": "zhú",
    "蒭": "chú",
    "蕏": "zhū",
    "芻": "chú",
    "藸": "zhū,chú",
    "蠩": "zhū",
    "處": "chǔ",
    "褚": "zhǔ",
    "蟵": "chú",
    "諔": "chù,jí",
    "觸": "chù",
    "詘": "qū",
    "諸": "zhū",
    "豖": "chù",
    "诸": "zhū",
    "诎": "qū",
    "豠": "chú",
    "貙": "chū",
    "趎": "chú",
    "跦": "zhū",
    "踀": "chuò",
    "踰": "yú",
    "鄐": "chù",
    "鉏": "chú",
    "躕": "chú",
    "鋤": "chú",
    "閦": "chù",
    "鶵": "chú",
    "鸀": "zhǔ",
    "雛": "chú",
    "齣": "chū",
    "齭": "chǔ",
    "齼": "chǔ",
    "歘": "xū",
    "撮": "cuō,zuǒ",
    "欻": "xū,chuā",
    "揣": "chuǎi,chuài,chuāi,tuán,zhuī",
    "膪": "chuài",
    "啜": "chuò,chuài",
    "嘬": "zuō",
    "腄": "chuí",
    "膗": "chuái",
    "船": "chuán",
    "穿": "chuān",
    "传": "chuán,zhuàn",
    "踹": "chuài",
    "川": "chuān",
    "喘": "chuǎn",
    "氚": "chuān",
    "椽": "chuán",
    "遄": "chuán",
    "串": "chuàn",
    "钏": "chuàn",
    "舛": "chuǎn",
    "舡": "chuán",
    "巛": "chuān",
    "傳": "chuán,zhuàn",
    "僢": "chuǎn",
    "剶": "chuán",
    "圌": "chuán,chuí",
    "惴": "zhuì",
    "掾": "yuàn",
    "暷": "chuán",
    "汌": "chuàn",
    "猭": "chuàn,chuān",
    "堾": "chuǎn",
    "玔": "chuàn",
    "瑏": "chuān",
    "甎": "zhuān",
    "歂": "chuǎn,chuán",
    "篅": "chuán",
    "膞": "zhuān,chuán,chún,zhuǎn",
    "舩": "chuán",
    "荈": "chuǎn",
    "賗": "chuàn",
    "踳": "chuǎn",
    "輲": "chuán",
    "鶨": "chuàn,zhì",
    "釧": "chuàn",
    "镩": "cuān",
    "床": "chuáng",
    "窗": "chuāng",
    "疮": "chuāng",
    "幢": "chuáng,zhuàng",
    "傸": "chuǎng",
    "怆": "chuàng",
    "刅": "chuāng",
    "刱": "chuàng",
    "剙": "chuàng",
    "剏": "chuàng",
    "噇": "chuáng",
    "创": "chuàng,chuāng",
    "創": "chuàng,chuāng",
    "囪": "cōng",
    "囱": "cōng",
    "愴": "chuàng",
    "摐": "chuāng",
    "戧": "qiāng,qiàng",
    "朣": "tóng,chuáng",
    "橦": "tóng,chuáng",
    "牎": "chuāng",
    "牀": "chuáng",
    "牕": "chuāng",
    "磢": "chuǎng",
    "瘡": "chuāng",
    "漺": "shuǎng",
    "葱": "cōng",
    "蔥": "cōng",
    "窻": "chuāng",
    "膧": "tóng",
    "吹": "chuī",
    "窓": "chuāng",
    "垂": "chuí",
    "锤": "chuí",
    "椎": "zhuī,chuí",
    "炊": "chuī",
    "棰": "chuí",
    "槌": "chuí",
    "倕": "chuí",
    "埀": "chuí",
    "惙": "chuò,chuì",
    "捶": "chuí",
    "搥": "chuí",
    "桘": "chuí",
    "陲": "chuí",
    "菙": "chuí",
    "箠": "chuí",
    "郵": "yóu",
    "錘": "chuí",
    "顀": "chuí",
    "鬌": "duǒ",
    "鎚": "chuí",
    "魋": "tuí",
    "龡": "chuī",
    "春": "chūn",
    "唇": "chún",
    "纯": "chún",
    "蠢": "chǔn",
    "淳": "chún,zhūn",
    "醇": "chún",
    "椿": "chūn",
    "媋": "chūn",
    "莼": "chún",
    "鹑": "chún",
    "偆": "chǔn",
    "惷": "chǔn",
    "旾": "chūn",
    "暙": "chūn",
    "杶": "chūn",
    "朐": "qú,xù,chǔn",
    "槆": "chūn",
    "櫄": "chūn",
    "橁": "chūn",
    "蝽": "chūn",
    "楯": "shǔn,dùn",
    "浱": "chún",
    "湻": "chún",
    "沌": "dùn",
    "滣": "chún",
    "犉": "chún",
    "漘": "chún",
    "瑃": "chūn",
    "睶": "chǔn",
    "箺": "chūn",
    "肫": "zhūn,chún",
    "純": "chún",
    "胊": "qú",
    "芚": "tún,chūn",
    "萅": "chūn",
    "萶": "chǔn",
    "脣": "chún",
    "賰": "chǔn",
    "蒓": "chún",
    "輴": "chūn",
    "輇": "quán",
    "錞": "chún",
    "蓴": "chún",
    "陙": "chún",
    "鯙": "chún",
    "辁": "quán",
    "鰆": "chūn",
    "鶞": "chūn",
    "醕": "chún",
    "戳": "chuō",
    "踔": "chuō",
    "龊": "chuò",
    "鶉": "chún",
    "辍": "chuò",
    "促": "cù",
    "娕": "chuò,lài",
    "吷": "xuè,chuò,jué",
    "娖": "chuò",
    "嚽": "chuò",
    "婥": "chuò,nào",
    "婼": "ruò,chuò",
    "孎": "zhú,chuò",
    "擉": "chuò",
    "斫": "zhuó",
    "歠": "chuò",
    "涰": "chuò",
    "磭": "chuò",
    "淖": "nào,chuò,zhuō",
    "簇": "cù",
    "缀": "zhuì",
    "綴": "zhuì",
    "箹": "yuē,yào,chuò",
    "腏": "zhuì",
    "跿": "tú",
    "蔟": "cù",
    "荃": "quán",
    "踱": "duó",
    "辵": "chuò",
    "輟": "chuò",
    "逴": "chuō",
    "酫": "chuò",
    "辶": "chuò",
    "鋜": "zhuó,chuò",
    "錣": "zhuì",
    "鑡": "chuò",
    "醛": "quán",
    "鏃": "zú,chuò",
    "齱": "zōu",
    "齪": "chuò",
    "镞": "zú",
    "此": "cǐ",
    "次": "cì",
    "词": "cí",
    "瓷": "cí",
    "雌": "cí",
    "磁": "cí",
    "辞": "cí",
    "刺": "cì,cī",
    "茨": "cí",
    "伺": "sì,cì",
    "慈": "cí",
    "疵": "cī",
    "呲": "zī,cī",
    "赐": "cì",
    "兹": "zī,cí",
    "鹚": "cí",
    "祠": "cí",
    "佌": "cǐ",
    "糍": "cí",
    "呰": "zǐ,cī",
    "刾": "cì",
    "啙": "zǐ,cǐ",
    "司": "sī",
    "偨": "cī",
    "佽": "cì",
    "垐": "cí",
    "堲": "jí",
    "嬨": "cí",
    "姕": "zī",
    "嵳": "cuó",
    "嵯": "cuó",
    "庛": "cì",
    "朿": "cì",
    "枱": "sì,tái",
    "柌": "cí",
    "栜": "sè",
    "措": "cuò",
    "栨": "cì",
    "泚": "cǐ",
    "澬": "zī",
    "滋": "zī",
    "濨": "cí",
    "玼": "cī,cǐ",
    "珁": "cí",
    "皉": "cǐ",
    "礠": "cí",
    "絘": "cì",
    "縒": "cī,cuò,suǒ",
    "粢": "zī,cí",
    "胔": "zì",
    "甆": "cí",
    "茦": "cì",
    "莿": "cì",
    "萕": "qí",
    "薋": "cí,zī",
    "薺": "jì,qí",
    "茲": "zī",
    "蚝": "háo",
    "蛓": "cì",
    "荠": "jì",
    "螅": "xī",
    "螆": "cì",
    "蠀": "cī",
    "詞": "cí",
    "賜": "cì",
    "趀": "cī",
    "跐": "cī,cǐ",
    "趑": "zī",
    "辤": "cí",
    "赼": "zī",
    "辝": "cí",
    "飺": "cí",
    "鈶": "sì",
    "餈": "cí",
    "辭": "cí",
    "骴": "cī",
    "髊": "cī",
    "鶿": "cí",
    "鴜": "cí",
    "齹": "cī",
    "鮆": "cǐ,jì",
    "嗭": "zi",
    "从": "cóng,zòng",
    "匆": "cōng",
    "丛": "cóng",
    "鷀": "cí",
    "枞": "cōng,zōng",
    "聪": "cōng",
    "琮": "cóng",
    "淙": "cóng",
    "璁": "cōng",
    "偬": "zǒng",
    "婃": "cóng",
    "叢": "cóng",
    "孮": "cóng",
    "従": "cóng",
    "徖": "cóng",
    "苁": "cōng",
    "骢": "cōng",
    "忩": "cōng",
    "從": "cóng,zòng",
    "悤": "cōng",
    "悰": "cóng",
    "怱": "cōng",
    "暰": "cōng",
    "棇": "cōng,sōng",
    "楤": "sǒng,cōng",
    "樬": "cōng",
    "樷": "cóng",
    "欉": "cóng",
    "憁": "còng",
    "樅": "cōng,zōng",
    "漎": "cóng,sǒng",
    "潀": "cóng,zǒng",
    "漗": "cōng",
    "灇": "cóng",
    "潈": "cóng,zōng",
    "焧": "zǒng,cōng",
    "熜": "cōng,zǒng",
    "潨": "cōng,zòng",
    "燪": "zǒng",
    "爜": "cóng",
    "瑽": "cōng",
    "篵": "cōng",
    "総": "zǒng",
    "緫": "zǒng",
    "縦": "zòng",
    "縱": "zòng,zǒng",
    "瞛": "cōng",
    "繱": "cōng",
    "聡": "cōng",
    "碂": "zòng,cóng",
    "纵": "zòng,zǒng",
    "聦": "cōng",
    "茐": "cōng",
    "聰": "cōng",
    "藂": "cóng",
    "蟌": "cōng",
    "誴": "cóng",
    "謥": "còng",
    "賨": "cóng",
    "賩": "cóng",
    "總": "zǒng",
    "蓯": "cōng",
    "騘": "cōng",
    "驄": "cōng",
    "鏦": "cōng",
    "楱": "còu,zòu",
    "辏": "còu",
    "凑": "còu",
    "腠": "còu",
    "奏": "zòu",
    "揍": "zòu",
    "湊": "còu",
    "族": "zú",
    "薮": "sǒu",
    "趋": "qū,cù",
    "藪": "sǒu",
    "趣": "qù,cù",
    "趨": "qū,cù",
    "輳": "còu",
    "粗": "cū",
    "醋": "cù",
    "卒": "zú,cù",
    "徂": "cú",
    "猝": "cù",
    "蹙": "cù",
    "酢": "zuò",
    "殂": "cú",
    "蹴": "cù",
    "且": "qiě,jū",
    "卆": "zú",
    "媨": "cù",
    "怚": "cū,jù,zū",
    "噈": "cù,zā,hé",
    "憱": "cù",
    "瘄": "cù",
    "捽": "zuó",
    "戚": "qī",
    "皻": "zhā,cǔ",
    "瘯": "cù",
    "縬": "cù",
    "脨": "cù",
    "蔖": "cuó",
    "蔍": "lù",
    "誎": "cù",
    "趗": "cù",
    "趥": "qiū",
    "踓": "wěi",
    "踤": "zú",
    "踧": "cù",
    "蹵": "cù",
    "顣": "cù",
    "錯": "cuò",
    "麁": "cū",
    "错": "cuò",
    "麄": "cū",
    "鼀": "cù",
    "窜": "cuàn",
    "麤": "cū",
    "蹿": "cuān",
    "麆": "zhù,cū",
    "篡": "cuàn",
    "汆": "cuān",
    "僔": "zǔn",
    "巑": "cuán",
    "攅": "zǎn",
    "攒": "zǎn,cuán",
    "撺": "cuān",
    "攛": "cuān",
    "攢": "zǎn,cuán",
    "爨": "cuàn",
    "昕": "xīn",
    "櫕": "cuán",
    "欑": "cuán",
    "殩": "cuàn",
    "濽": "zàn,cuán",
    "灒": "zàn,cuán",
    "熶": "cuàn",
    "窾": "kuǎn,cuàn",
    "篹": "zhuàn,zuàn,suǎn",
    "簒": "cuàn",
    "穳": "cuán,zàn",
    "竄": "cuàn",
    "襸": "zàn",
    "鋑": "juān,jiān,cuān",
    "躥": "cuān",
    "鑹": "cuān",
    "催": "cuī",
    "脆": "cuì",
    "崔": "cuī",
    "淬": "cuì",
    "摧": "cuī",
    "翠": "cuì",
    "瘁": "cuì",
    "衰": "shuāi,cuī",
    "啐": "cuì,qi",
    "悴": "cuì",
    "粹": "cuì",
    "萃": "cuì",
    "乼": "zhù",
    "璀": "cuǐ",
    "榱": "cuī",
    "毳": "cuì",
    "伜": "cuì",
    "倅": "cuì,zú",
    "啛": "cuì",
    "凗": "cuī",
    "墔": "cuī",
    "崒": "zú,cuì",
    "崪": "zú",
    "忰": "cuì",
    "慛": "cuī",
    "嶉": "wěi",
    "椊": "zú,cuì",
    "槯": "cuī,zhǐ",
    "焠": "cuì",
    "熣": "suī,cuǐ",
    "獕": "suǒ",
    "漼": "cuǐ,cuī",
    "琗": "cuì,sè",
    "濢": "cuì,zuǐ",
    "疩": "cuì",
    "皠": "cuǐ",
    "磪": "cuī",
    "竁": "cuì",
    "紣": "cuì",
    "綷": "cuì",
    "縗": "cuī,suī,shuāi",
    "繀": "suì",
    "翆": "cuì",
    "粋": "cuì",
    "脃": "cuì",
    "脺": "cuī",
    "膬": "cuì",
    "缞": "cuī,suī,shuāi",
    "臎": "cuì",
    "膵": "cuì",
    "趡": "cuǐ",
    "鏙": "cuī",
    "顇": "cuì",
    "襊": "cuì",
    "村": "cūn",
    "寸": "cùn",
    "存": "cún",
    "蹲": "dūn",
    "侟": "cún,jiàn",
    "忖": "cǔn",
    "皴": "cūn",
    "刌": "cǔn",
    "吋": "dòu,cùn",
    "墫": "zūn,dūn",
    "拵": "cún,zùn",
    "洊": "jiàn",
    "澊": "cūn,cún",
    "浚": "jùn,xùn",
    "竴": "cūn",
    "隹": "zhuī,cuī,wéi",
    "籿": "cùn",
    "踆": "qūn",
    "邨": "cūn",
    "挫": "cuò",
    "鹾": "cuó",
    "厝": "cuò",
    "脞": "cuǒ",
    "痤": "cuó",
    "蹉": "cuō",
    "磋": "cuō",
    "锉": "cuò",
    "矬": "cuó",
    "剒": "cuò",
    "剉": "cuò",
    "庴": "jī,cuò",
    "夎": "cuò",
    "澨": "shì",
    "棤": "què",
    "最": "zuì",
    "營": "yíng",
    "瑳": "cuō",
    "睉": "cuó,zhuài",
    "莝": "cuò",
    "昔": "xī",
    "蒫": "cuó",
    "蓌": "cuò",
    "莡": "cuò",
    "虘": "cuó",
    "諎": "zé,zuò,zhǎ,cuò",
    "逪": "cuò",
    "遳": "cuō",
    "躜": "zuān",
    "躦": "zuān",
    "酂": "zàn",
    "酇": "zàn",
    "醝": "cuō",
    "鹺": "cuó",
    "銼": "cuò",
    "大": "dà,dài,tài",
    "打": "dǎ,dá",
    "搭": "dā",
    "瘩": "dá,da",
    "答": "dá,dā",
    "笪": "dá",
    "塔": "tǎ",
    "达": "dá",
    "哒": "dā",
    "耷": "dā",
    "褡": "dā",
    "疸": "dǎn",
    "怛": "dá",
    "靼": "dá",
    "妲": "dá",
    "沓": "tà,dá",
    "嗒": "tà,dā",
    "剳": "dá,zhá",
    "亣": "dà",
    "匒": "dá",
    "咑": "dā",
    "呾": "dá,dàn",
    "鞑": "dá",
    "噠": "dā",
    "垯": "dá",
    "墶": "dā",
    "搨": "tà",
    "撘": "dā",
    "橽": "tà",
    "毼": "hé",
    "汏": "tài,dà",
    "溚": "dá,tǎ",
    "炟": "dá",
    "燵": "dá",
    "畗": "dá,fú",
    "畣": "dá",
    "矺": "zhé",
    "眔": "dà",
    "笚": "dā,xiá,nà",
    "繨": "da",
    "羍": "dá",
    "荅": "dá",
    "胆": "dǎn",
    "塌": "tā",
    "荙": "dá",
    "薘": "dá",
    "蟽": "dá",
    "觰": "zhā",
    "跶": "dá",
    "詚": "dá",
    "躂": "tà",
    "迏": "dá",
    "迖": "dá",
    "逹": "dá",
    "迭": "dié",
    "鎉": "dā,tà",
    "鎝": "dā",
    "鐽": "dá",
    "達": "dá",
    "龖": "dá",
    "龘": "dá",
    "韃": "dá",
    "带": "dài",
    "代": "dài",
    "戴": "dài",
    "待": "dài,dāi",
    "逮": "dài",
    "袋": "dài",
    "歹": "dǎi",
    "贷": "dài",
    "怠": "dài",
    "傣": "dǎi",
    "殆": "dài",
    "呔": "dāi",
    "迨": "dài",
    "玳": "dài",
    "岱": "dài",
    "甙": "dài",
    "黛": "dài",
    "骀": "tái",
    "绐": "dài",
    "埭": "dài",
    "侢": "dài",
    "嘚": "dē,dēi",
    "垈": "dài",
    "帒": "dài",
    "帯": "dài",
    "廗": "dài",
    "懛": "dāi",
    "叇": "dài",
    "曃": "dài",
    "帶": "dài",
    "柋": "dài",
    "瀻": "dài",
    "瑇": "dài",
    "毒": "dú,dài",
    "獃": "dāi",
    "箉": "guǎi,dài",
    "棣": "dì,dài,tì",
    "簤": "dài",
    "緿": "dài",
    "艜": "dài",
    "紿": "dài",
    "蚮": "dài,dé",
    "蝳": "dài",
    "螮": "dì",
    "詒": "yí",
    "蹛": "dài",
    "軑": "dài",
    "軚": "dài",
    "軩": "dài",
    "轪": "dài",
    "诒": "yí,dài",
    "襶": "dài",
    "逯": "lù",
    "貸": "dài,tè",
    "遰": "dì",
    "遞": "dì",
    "霴": "dài",
    "靆": "dài",
    "隶": "lì,dài",
    "駄": "tuó,duò",
    "馱": "tuó,duò",
    "駘": "tái,dài",
    "驮": "tuó",
    "鴏": "dài",
    "黱": "dài",
    "但": "dàn",
    "蛋": "dàn",
    "弹": "dàn,tán",
    "淡": "dàn",
    "丹": "dān",
    "担": "dān,dàn,dǎn",
    "耽": "dān",
    "氮": "dàn",
    "诞": "dàn",
    "郸": "dān",
    "旦": "dàn",
    "瘅": "dàn,dān",
    "惮": "dàn,dá",
    "澹": "dàn,tán",
    "石": "shí,dàn",
    "萏": "dàn",
    "殚": "dān",
    "聃": "dān",
    "箪": "dān",
    "赕": "dǎn",
    "丼": "jǐng",
    "儋": "dān,dàn",
    "啖": "dàn",
    "冄": "rǎn",
    "冉": "rǎn",
    "刐": "dǎn",
    "伔": "dǎn",
    "勯": "dān",
    "匰": "dān",
    "倓": "tán,tàn",
    "啗": "dàn",
    "啿": "dàn",
    "嘾": "dàn,tán",
    "唌": "dàn,xián,yán",
    "噡": "zhān",
    "嚪": "dàn",
    "噉": "dàn",
    "坛": "tán",
    "壇": "tán",
    "妉": "dān",
    "媅": "dān",
    "帎": "dàn",
    "弾": "dàn,tán",
    "彈": "dàn,tán",
    "憺": "dàn",
    "娊": "xiàn",
    "惔": "tán,dàn",
    "撢": "dǎn",
    "憾": "hàn",
    "抌": "dǎn,shěn",
    "柦": "dàn",
    "擔": "dān,dàn",
    "欿": "kǎn,qiàn",
    "沊": "dàn",
    "檐": "yán",
    "殫": "dān",
    "泹": "dàn",
    "澸": "gǎn",
    "狚": "dàn",
    "玬": "dǎn",
    "瓭": "dǎn",
    "潭": "tán",
    "甔": "dān",
    "癚": "dàn",
    "皽": "zhāo,zhǎn,dǎn",
    "癉": "dàn,dān",
    "禫": "dàn",
    "疍": "dàn",
    "紞": "dǎn",
    "耼": "dān",
    "砃": "dān",
    "簞": "dān",
    "聸": "dān",
    "腅": "dàn",
    "窞": "dàn",
    "蜑": "dàn",
    "膻": "shān,dàn",
    "膽": "dǎn",
    "衴": "dǎn",
    "褝": "dān",
    "觛": "dàn",
    "訑": "dàn",
    "蜒": "yán",
    "贉": "dàn",
    "詹": "zhān",
    "誕": "dàn",
    "躭": "dān",
    "贍": "shàn",
    "赡": "shàn",
    "酖": "dān",
    "醈": "tán,dàn",
    "霮": "dàn",
    "鄲": "dān",
    "頕": "dān",
    "餤": "dàn",
    "馾": "dǎn,dàn",
    "駳": "dàn",
    "髧": "dàn",
    "鴠": "dàn",
    "黕": "dǎn",
    "饏": "dàn",
    "黵": "dǎn,zhǎn",
    "黮": "dàn,shèn",
    "卩": "jié",
    "亻": "rén",
    "当": "dāng,dàng",
    "党": "dǎng",
    "挡": "dǎng,dàng",
    "荡": "dàng",
    "档": "dàng",
    "谠": "dǎng",
    "宕": "dàng",
    "菪": "dàng",
    "凼": "dàng",
    "砀": "dàng",
    "偒": "tǎng,dàng",
    "儅": "dāng,dàng",
    "裆": "dāng",
    "圵": "dàng",
    "垱": "dàng",
    "噹": "dāng",
    "壋": "dàng",
    "婸": "dàng,yáng",
    "崵": "yáng,dàng",
    "嵣": "dàng,táng",
    "愓": "dàng,shāng,táng,yáng",
    "攩": "dǎng",
    "欓": "dǎng",
    "擋": "dǎng,dàng",
    "潒": "dàng,xiàng",
    "檔": "dàng",
    "氹": "dàng",
    "澢": "dāng",
    "灙": "dǎng,tǎng",
    "珰": "dāng",
    "烫": "tàng",
    "璗": "dàng",
    "燙": "tàng",
    "璫": "dāng",
    "瓽": "dàng",
    "瘍": "yáng",
    "當": "dāng,dàng,dǎng",
    "瞊": "dàng",
    "礑": "dàng",
    "碭": "dàng",
    "盪": "dàng",
    "筜": "dāng",
    "簜": "dàng",
    "簹": "dāng",
    "艡": "dāng",
    "蘯": "dàng",
    "蟷": "dāng",
    "譡": "dǎng",
    "蕩": "dàng",
    "襠": "dāng",
    "趤": "dàng",
    "逿": "dàng",
    "闣": "dāng,dàng",
    "讜": "dǎng",
    "雼": "dàng",
    "到": "dào",
    "道": "dào",
    "倒": "dǎo,dào",
    "岛": "dǎo",
    "刀": "dāo",
    "盗": "dào",
    "稻": "dào",
    "导": "dǎo",
    "悼": "dào",
    "祷": "dǎo",
    "蹈": "dǎo",
    "捣": "dǎo",
    "氘": "dāo",
    "忉": "dāo",
    "纛": "dào",
    "焘": "dào",
    "叨": "tāo,dāo",
    "受": "shòu",
    "嘄": "jiào,dǎo",
    "啁": "zhōu,zhāo,tiào",
    "噵": "dào",
    "壔": "dǎo",
    "宲": "bǎo,shí",
    "屶": "huì",
    "導": "dǎo",
    "嶋": "dǎo",
    "嶌": "dǎo",
    "嶹": "dǎo",
    "島": "dǎo",
    "捯": "dáo",
    "忑": "tè",
    "朷": "dāo,tiáo,mù",
    "搗": "dǎo",
    "槝": "dǎo",
    "椡": "dào",
    "檤": "dào",
    "瓙": "dào",
    "洮": "táo",
    "燾": "dào",
    "禂": "dǎo",
    "稲": "dào",
    "盜": "dào",
    "禱": "dǎo",
    "箌": "zhào,dào",
    "絩": "tiào,diào,dào",
    "翢": "dào,zhōu",
    "翿": "dào",
    "舠": "dāo",
    "菿": "dào",
    "虭": "diāo",
    "衟": "dào",
    "軇": "dào",
    "釖": "dāo",
    "陦": "dǎo",
    "衜": "dào",
    "隝": "dǎo",
    "陶": "táo",
    "隯": "dǎo",
    "魛": "dāo",
    "鱽": "dāo",
    "鳥": "niǎo,diǎo",
    "鸟": "niǎo",
    "的": "dí,dì,de",
    "地": "dì,de",
    "得": "dé,děi,de",
    "德": "dé",
    "底": "dǐ,de",
    "徳": "dé",
    "锝": "dé",
    "恴": "dé",
    "悳": "dé",
    "惪": "dé",
    "棏": "dé,zhé",
    "淂": "dé",
    "登": "dēng",
    "陟": "zhì",
    "鍀": "dé",
    "哋": "diè,dì",
    "揼": "bèng",
    "扥": "dèn",
    "扽": "dèn",
    "等": "děng",
    "灯": "dēng",
    "邓": "dèng",
    "瞪": "dèng",
    "凳": "dèng",
    "蹬": "dēng",
    "磴": "dèng",
    "镫": "dèng",
    "嶝": "dèng",
    "戥": "děng",
    "墱": "dèng",
    "嬁": "dēng",
    "櫈": "dèng",
    "噔": "dēng",
    "璒": "dēng",
    "竳": "dēng",
    "燈": "dēng",
    "艠": "dēng",
    "覴": "dèng",
    "豋": "dēng",
    "鄧": "dèng",
    "簦": "dēng",
    "隥": "dèng",
    "鐙": "dèng",
    "第": "dì",
    "敌": "dí",
    "低": "dī",
    "抵": "dǐ",
    "递": "dì",
    "滴": "dī",
    "弟": "dì,tì,tuí",
    "缔": "dì",
    "堤": "dī",
    "涤": "dí",
    "帝": "dì",
    "嫡": "dí",
    "笛": "dí",
    "迪": "dí",
    "狄": "dí",
    "蒂": "dì",
    "觌": "dí",
    "翟": "dí,zhái",
    "邸": "dǐ",
    "谛": "dì",
    "嘀": "dí",
    "诋": "dǐ",
    "骶": "dǐ",
    "羝": "dī",
    "氐": "dī,dǐ",
    "睇": "dì",
    "娣": "dì",
    "荻": "dí",
    "碲": "dì",
    "镝": "dí",
    "籴": "dí",
    "仾": "dī",
    "砥": "dǐ",
    "俤": "dì",
    "偙": "dì",
    "僀": "dì",
    "儥": "yù",
    "厎": "dǐ",
    "呧": "dǐ",
    "勺": "sháo",
    "唙": "dí",
    "啇": "dí",
    "啲": "dī",
    "坔": "dì,làn",
    "埅": "dì,fáng",
    "埊": "dì",
    "埞": "dī",
    "墆": "zhì,dì",
    "墑": "dì",
    "嚁": "dí",
    "媂": "dì,tí",
    "奃": "dī,tì",
    "嵽": "dié,dì",
    "嶳": "dì",
    "廸": "dí",
    "墬": "dì",
    "弔": "diào",
    "弚": "tuí",
    "弤": "dǐ",
    "彽": "dī",
    "怟": "dì",
    "扚": "diǎo,dí,yuē,lì",
    "拞": "dǐ",
    "掋": "dǐ",
    "揥": "tì,dì",
    "摕": "dì,tú,zhí",
    "旳": "dì,dí,de",
    "杕": "dì,duò",
    "枤": "dì,duò",
    "敵": "dí",
    "梊": "dì",
    "梑": "dí",
    "楴": "dì,dǐ,shì",
    "樀": "dī",
    "浟": "yōu,dí",
    "渧": "tí,dī,dì",
    "牴": "dǐ",
    "滌": "dí",
    "玓": "dì",
    "焍": "dì",
    "珶": "dì,tí",
    "甋": "dì",
    "疐": "zhì,dì",
    "眱": "dì",
    "碮": "tí,dī",
    "磾": "dī",
    "祶": "dì",
    "禘": "dì",
    "篴": "zhú,dí",
    "約": "yuē,yāo",
    "糴": "dí",
    "締": "dì",
    "聜": "dǐ,zhì",
    "约": "yuē,yāo",
    "芍": "sháo",
    "苖": "dí",
    "菂": "dì",
    "腣": "dì",
    "莜": "yóu",
    "苐": "dì,tí",
    "菧": "dǐ",
    "蓧": "diào,tiáo,dí",
    "蔋": "dí",
    "藋": "diào,zhuó",
    "蝃": "dì",
    "袛": "dī",
    "觝": "dǐ",
    "藡": "dí",
    "覿": "dí",
    "蔐": "dí",
    "詆": "dǐ",
    "諟": "shì,dì",
    "趆": "dī",
    "諦": "dì",
    "豴": "dí",
    "蹢": "dí",
    "蹏": "tí",
    "逓": "dì",
    "逐": "zhú",
    "蹄": "tí",
    "適": "shì",
    "鉪": "dì",
    "隄": "dī",
    "鏑": "dí,dī",
    "阺": "dǐ",
    "釱": "dì,dài",
    "靮": "dí",
    "頔": "dí",
    "鞮": "dī",
    "馰": "dí",
    "題": "tí",
    "题": "tí",
    "髢": "dí",
    "鬄": "tì",
    "魡": "diào",
    "鯳": "dǐ",
    "鸐": "dí",
    "嗲": "diǎ",
    "点": "diǎn",
    "电": "diàn",
    "店": "diàn",
    "殿": "diàn",
    "淀": "diàn",
    "颠": "diān",
    "掂": "diān",
    "垫": "diàn",
    "惦": "diàn",
    "碘": "diǎn",
    "佃": "diàn,tián",
    "靛": "diàn",
    "奠": "diàn",
    "典": "diǎn",
    "滇": "diān",
    "钿": "diàn,tián",
    "甸": "diàn,tián,shèng",
    "坫": "diàn",
    "阽": "diàn",
    "簟": "diàn",
    "踮": "diǎn",
    "玷": "diàn",
    "癜": "diàn",
    "巅": "diān",
    "傎": "diān",
    "癫": "diān",
    "厧": "diān",
    "唸": "niàn",
    "壂": "diàn",
    "埝": "niàn",
    "墊": "diàn",
    "奌": "diǎn",
    "婝": "diàn",
    "婰": "diǎn",
    "嵮": "diān",
    "巓": "diān",
    "扂": "diàn",
    "敁": "diān",
    "拈": "niān",
    "巔": "diān",
    "敟": "diǎn",
    "槇": "diān",
    "橂": "diàn",
    "橝": "tán,diàn",
    "攧": "diān",
    "槙": "diān,zhěn,zhēn",
    "湺": "xián",
    "琔": "diàn",
    "痶": "tiǎn,diàn",
    "涎": "xián",
    "椣": "diǎn",
    "澱": "diàn",
    "磹": "diàn",
    "腍": "rèn",
    "蒧": "diǎn",
    "蕇": "diǎn",
    "癲": "diān",
    "蜔": "diàn",
    "蹎": "diān",
    "蜓": "tíng",
    "鈿": "diàn",
    "電": "diàn",
    "顚": "diān",
    "驔": "diàn",
    "顛": "diān",
    "齻": "diān",
    "點": "diǎn",
    "丶": "zhǔ",
    "掉": "diào",
    "钓": "diào",
    "雕": "diāo",
    "吊": "diào",
    "调": "tiáo,diào,zhōu",
    "刁": "diāo",
    "碉": "diāo",
    "叼": "diāo",
    "铞": "diào",
    "鲷": "diāo",
    "凋": "diāo",
    "貂": "diāo",
    "铫": "diào,tiáo,yáo",
    "伄": "diào",
    "佻": "tiāo",
    "倜": "tì",
    "奝": "diāo",
    "刟": "diāo",
    "嬥": "tiǎo",
    "屌": "diǎo",
    "弴": "diāo",
    "殦": "chī",
    "彫": "diāo",
    "挑": "tiāo,tiǎo",
    "汈": "diāo",
    "淍": "zhōu",
    "琱": "diāo",
    "瘹": "diào",
    "瞗": "diāo,dōu",
    "矵": "qì",
    "窎": "diào",
    "窵": "diào",
    "竨": "diào",
    "簓": "diāo",
    "粜": "tiào",
    "蛁": "diāo",
    "糶": "tiào",
    "訋": "diào",
    "蜩": "tiáo",
    "誂": "tiǎo,diào",
    "調": "diào,tiáo",
    "赵": "zhào",
    "趙": "zhào",
    "跳": "tiào,táo",
    "軺": "yáo",
    "轺": "yáo",
    "釣": "diào",
    "鋽": "diào",
    "銱": "diào",
    "錭": "diāo",
    "鑃": "diào",
    "鈟": "diào",
    "雿": "diào",
    "鯛": "diāo",
    "鮉": "diāo",
    "颩": "biāo,diū",
    "鵃": "zhōu",
    "鳭": "diāo,zhāo",
    "鸼": "zhōu",
    "鼦": "diāo",
    "鵰": "diāo",
    "跌": "diē",
    "碟": "dié",
    "谍": "dié",
    "叠": "dié",
    "牒": "dié",
    "蝶": "dié",
    "瓞": "dié",
    "揲": "shé,dié,yè",
    "爹": "diē",
    "鲽": "dié",
    "堞": "dié",
    "耋": "dié",
    "垤": "dié",
    "蹀": "dié",
    "咥": "dié,xī",
    "佚": "yì,dié",
    "喋": "dié,zhá",
    "峌": "dié",
    "啑": "shà,jié,dié,tì",
    "怢": "tū,dié",
    "幉": "dié",
    "恎": "dié",
    "惵": "dié",
    "戜": "dié",
    "挃": "zhì",
    "挕": "dié,shè",
    "昳": "dié,yì",
    "曡": "dié",
    "柣": "zhì,dié",
    "楪": "dié,yè",
    "崼": "shì,dié",
    "殜": "dié",
    "槢": "xí,dié",
    "氎": "dié",
    "渉": "shè",
    "泆": "yì,dié",
    "涉": "shè",
    "牃": "dié",
    "畳": "dié",
    "疂": "dié",
    "渫": "xiè",
    "疉": "dié",
    "眰": "dié,zhì",
    "疊": "dié",
    "絰": "dié",
    "绖": "dié",
    "窒": "zhì",
    "胅": "dié",
    "耊": "dié",
    "臷": "dié,zhí",
    "艓": "dié",
    "苵": "dié",
    "至": "zhì",
    "蜨": "dié",
    "螲": "dié,zhì",
    "褋": "dié",
    "褺": "diē",
    "詄": "dié",
    "趃": "dié,tú",
    "褶": "zhě",
    "跕": "diǎn,tiē,dié",
    "諜": "dié",
    "踢": "tī",
    "鐡": "tiě",
    "軼": "yì,dié",
    "镻": "dié",
    "鞢": "xiè,dié",
    "轶": "yì",
    "鐵": "tiě",
    "鮙": "tǎ",
    "鰈": "dié",
    "鰨": "tǎ",
    "嚸": "diǎn",
    "鳎": "tǎ",
    "顶": "dǐng",
    "定": "dìng",
    "订": "dìng",
    "叮": "dīng",
    "丁": "dīng,zhēng",
    "钉": "dīng,dìng",
    "鼎": "dǐng",
    "锭": "dìng",
    "玎": "dīng",
    "铤": "tǐng,dìng",
    "腚": "dìng",
    "碇": "dìng",
    "町": "tǐng,dīng",
    "疔": "dīng",
    "仃": "dīng",
    "耵": "dīng",
    "啶": "dìng",
    "嵿": "dǐng",
    "酊": "dīng,dǐng",
    "帄": "dīng",
    "忊": "dìng,tìng",
    "奵": "dǐng,dīng,tiǎn",
    "椗": "dìng",
    "掟": "zhěng,dìng",
    "濎": "dǐng,tìng",
    "甼": "tǐng,dīng",
    "汀": "tīng",
    "矴": "dìng",
    "碠": "dìng",
    "磸": "dìng",
    "聢": "dìng",
    "艼": "dǐng",
    "萣": "dìng",
    "葶": "tíng",
    "薡": "dǐng",
    "鐤": "dǐng",
    "訂": "dìng",
    "釘": "dīng,dìng",
    "錠": "dìng",
    "鋌": "tǐng,dìng",
    "顁": "dìng",
    "靪": "dīng",
    "飣": "dìng",
    "頂": "dǐng",
    "铥": "diū",
    "丟": "diū",
    "銩": "diū",
    "丢": "diū",
    "饤": "dìng",
    "东": "dōng",
    "动": "dòng",
    "懂": "dǒng",
    "洞": "dòng",
    "冻": "dòng",
    "冬": "dōng",
    "董": "dǒng",
    "栋": "dòng",
    "侗": "dòng,tóng,tǒng",
    "鸫": "dōng",
    "峒": "tóng,dòng",
    "恫": "dòng",
    "胨": "dòng",
    "垌": "dòng,tóng",
    "胴": "dòng",
    "硐": "dòng",
    "氡": "dōng",
    "岽": "dōng",
    "倲": "dōng",
    "働": "dòng",
    "咚": "dōng",
    "凍": "dòng",
    "勭": "tóng,dòng",
    "動": "dòng",
    "埬": "dōng",
    "姛": "dòng",
    "墥": "tuǎn,dǒng",
    "娻": "dōng,dòng",
    "嬞": "dǒng",
    "峝": "tóng",
    "戙": "dòng",
    "挏": "dòng",
    "崬": "dōng",
    "昸": "dōng",
    "崠": "dōng,dòng",
    "東": "dōng",
    "桐": "tóng",
    "氭": "dōng",
    "棟": "dòng",
    "涷": "dōng",
    "湩": "dòng",
    "烔": "tóng,dòng",
    "燑": "tóng,dòng",
    "狫": "lǎo",
    "笗": "dōng",
    "甬": "yǒng",
    "筩": "tǒng",
    "筒": "tǒng",
    "絧": "tōng,tóng,dòng",
    "苳": "dōng",
    "腖": "dòng",
    "菄": "dōng",
    "箽": "dǒng",
    "蕫": "dǒng",
    "蝀": "dōng",
    "衕": "tòng",
    "諌": "dǒng",
    "迵": "dòng",
    "詷": "tóng",
    "霘": "dòng",
    "駧": "dòng",
    "騆": "zhōu",
    "鮗": "dōng",
    "鯟": "dōng",
    "鶫": "dōng",
    "鼕": "dōng",
    "鶇": "dōng",
    "夂": "zhǐ,zhōng",
    "斗": "dǒu,dòu",
    "都": "dū,dōu",
    "豆": "dòu",
    "逗": "dòu",
    "抖": "dǒu",
    "陡": "dǒu",
    "痘": "dòu",
    "读": "dú,dòu",
    "兜": "dōu",
    "窦": "dòu",
    "蚪": "dǒu",
    "篼": "dōu",
    "乧": "dǒu",
    "蔸": "dōu",
    "侸": "shù,dōu",
    "兠": "dōu",
    "凟": "dú",
    "剅": "dōu",
    "斣": "dòu",
    "投": "tóu",
    "枓": "dōu",
    "梪": "dòu",
    "唗": "dōu",
    "橷": "dōu",
    "毭": "dòu,nuò",
    "氀": "lǘ",
    "吺": "dōu,rú",
    "渎": "dú,dòu",
    "瀆": "dú,dòu",
    "浢": "dòu",
    "窬": "yú",
    "脰": "dòu",
    "艔": "dào",
    "竇": "dòu",
    "荳": "dòu",
    "讀": "dú",
    "逾": "yú",
    "酘": "dòu",
    "郖": "dòu",
    "酡": "tuó",
    "鋀": "tōu,tù,dòu",
    "鈄": "dǒu",
    "閗": "dòu",
    "钭": "dǒu",
    "餖": "dòu",
    "饾": "dòu",
    "鬥": "dòu",
    "鬦": "dòu",
    "鬪": "dòu",
    "阧": "dǒu",
    "闘": "dòu",
    "鬬": "dòu",
    "鬭": "dòu",
    "度": "dù,duó",
    "渡": "dù",
    "独": "dú",
    "肚": "dù,dǔ",
    "赌": "dǔ",
    "睹": "dǔ",
    "杜": "dù",
    "镀": "dù",
    "督": "dū",
    "犊": "dú",
    "堵": "dǔ",
    "顿": "dùn",
    "蠹": "dù",
    "笃": "dǔ",
    "嘟": "dū",
    "妒": "dù",
    "椟": "dú",
    "牍": "dú",
    "黩": "dú",
    "髑": "dú",
    "剢": "dū,zhuó",
    "剫": "duó",
    "匵": "dú",
    "芏": "dù",
    "噣": "zhòu,zhuó",
    "厾": "dū",
    "塗": "tú",
    "妬": "dù",
    "帾": "zhǔ",
    "斁": "yì,dù",
    "晵": "qǐ,dù",
    "暏": "shǔ,dǔ",
    "樚": "lù",
    "嬻": "dú",
    "樞": "shū",
    "橐": "tuó",
    "殬": "dù",
    "涜": "dú",
    "殰": "dú",
    "櫝": "dú",
    "琽": "dǔ",
    "犢": "dú",
    "牘": "dú",
    "瓄": "dú",
    "獨": "dú",
    "皾": "dú",
    "睪": "yì,zé,gāo",
    "秺": "dù",
    "竺": "zhú,dǔ",
    "荰": "dù",
    "篤": "dǔ",
    "蠧": "dù",
    "螙": "dù",
    "裻": "dú",
    "襡": "shǔ",
    "襩": "shǔ",
    "読": "dú",
    "笁": "zhú",
    "讟": "dú",
    "豄": "dú",
    "覩": "dǔ",
    "贕": "dú",
    "醏": "dū",
    "賭": "dǔ",
    "錖": "dú",
    "鑟": "dú",
    "鍺": "zhě",
    "鍍": "dù",
    "锗": "zhě",
    "闍": "dū,shé",
    "阇": "dū,shé",
    "陼": "zhǔ",
    "靯": "dù",
    "韇": "dú",
    "韣": "dú",
    "頓": "dùn",
    "黷": "dú",
    "段": "duàn",
    "騳": "dú",
    "短": "duǎn",
    "韥": "dú",
    "断": "duàn",
    "端": "duān",
    "锻": "duàn",
    "椴": "duàn",
    "偳": "duān",
    "煅": "duàn",
    "剬": "zhì,duān",
    "簖": "duàn",
    "塅": "duàn",
    "媏": "duān",
    "缎": "duàn",
    "彖": "tuàn",
    "毈": "duàn",
    "瑖": "duàn",
    "斷": "duàn",
    "耑": "duān,zhuān",
    "籪": "duàn",
    "腶": "duàn",
    "緞": "duàn",
    "葮": "duàn",
    "褍": "duān",
    "躖": "duàn",
    "碫": "duàn",
    "鍴": "duān",
    "鍛": "duàn",
    "对": "duì",
    "队": "duì",
    "堆": "duī",
    "兑": "duì,ruì,yuè",
    "敦": "dūn,duì",
    "镦": "duī",
    "兊": "duì,ruì,yuè",
    "憝": "duì",
    "垖": "duī",
    "兌": "duì,ruì,yuè",
    "怼": "duì",
    "塠": "duī",
    "埻": "zhǔn",
    "夺": "duó",
    "碓": "duì",
    "奪": "duó",
    "對": "duì",
    "嵟": "cuī",
    "憞": "duì,dùn,tūn",
    "対": "duì",
    "杸": "shū,duì",
    "懟": "duì",
    "濧": "duì",
    "瀢": "wěi,duì",
    "瀩": "duì",
    "痽": "duī",
    "磓": "duī",
    "濻": "wěi,duì",
    "祋": "duì",
    "綐": "duì",
    "膭": "kuì",
    "薱": "duì",
    "謉": "kuì",
    "譈": "duì",
    "譵": "duì",
    "銳": "ruì",
    "鋭": "ruì",
    "鐜": "duī",
    "鐓": "duī",
    "陮": "duì",
    "鈗": "yǔn",
    "锐": "ruì",
    "隊": "duì,zhuì",
    "頧": "duǐ",
    "追": "zhuī,duī",
    "鴭": "duī",
    "吨": "dūn",
    "墩": "dūn",
    "钝": "dùn",
    "盾": "dùn",
    "囤": "dùn,tún",
    "趸": "dǔn",
    "遁": "dùn",
    "盹": "dǔn",
    "砘": "dùn",
    "礅": "dūn",
    "炖": "dùn",
    "伅": "dùn",
    "俊": "jùn",
    "噸": "dūn",
    "墪": "dūn",
    "壿": "cún",
    "庉": "dùn,tún",
    "惇": "dūn",
    "忳": "tún,zhūn,dùn",
    "撉": "dūn",
    "撴": "dūn",
    "橔": "tuí,dūn",
    "潡": "dùn",
    "犜": "dūn",
    "碷": "dùn",
    "燉": "dùn",
    "腞": "zhuàn",
    "腯": "tú",
    "獤": "dūn",
    "蜳": "dūn",
    "踲": "dùn",
    "蹾": "dūn",
    "豚": "tún",
    "逇": "dùn",
    "躉": "dǔn",
    "遯": "dùn",
    "驐": "dūn",
    "鈍": "dùn",
    "舵": "duò",
    "剁": "duò",
    "朵": "duǒ",
    "垛": "duǒ,duò",
    "跺": "duò",
    "堕": "duò,huī",
    "惰": "duò",
    "掇": "duō",
    "躲": "duǒ",
    "沲": "tuó,duò",
    "铎": "duó",
    "咄": "duō",
    "裰": "duō",
    "哚": "duǒ",
    "亸": "duǒ",
    "凙": "duó",
    "刴": "duò",
    "缍": "duǒ",
    "喥": "duó,zhà",
    "嚉": "duō",
    "嚲": "duǒ",
    "垜": "duǒ,duò",
    "墯": "duò",
    "埵": "duǒ",
    "墮": "duò,huī",
    "媠": "tuó,duò",
    "嫷": "tuǒ",
    "尮": "duò",
    "崜": "duǒ",
    "嶞": "tuò",
    "憜": "duò",
    "挅": "duò",
    "挆": "duǒ,duò",
    "敓": "duó,duì",
    "敚": "duó,duì",
    "敠": "duō,què",
    "朶": "duǒ",
    "柂": "yí,duò,lí",
    "杂": "zá",
    "柁": "tuó,duò",
    "柮": "duò,zuó,wù",
    "椯": "duǒ,chuán",
    "毲": "duō",
    "橢": "tuǒ",
    "敪": "duō,què",
    "沰": "tuō,duó",
    "痥": "duó",
    "硾": "zhuì,chuí,duǒ",
    "茤": "jì",
    "桗": "duò",
    "詑": "tuó",
    "綞": "duǒ",
    "貀": "nà",
    "澤": "zé,shì",
    "趓": "duǒ",
    "跥": "duò",
    "躱": "duǒ",
    "軃": "duǒ",
    "鈬": "duó",
    "鐸": "duó",
    "陀": "tuó",
    "陊": "duò",
    "陏": "duò",
    "隓": "huī,duò",
    "隋": "suí,duò",
    "飿": "duò",
    "饳": "duò",
    "饿": "è",
    "鵽": "duò",
    "哦": "ó,ò,é",
    "鮵": "tuō",
    "额": "é",
    "鹅": "é",
    "蛾": "é,yǐ",
    "扼": "è",
    "俄": "é",
    "遏": "è",
    "讹": "é",
    "峨": "é",
    "娥": "é",
    "恶": "è,wù,ě,wū",
    "厄": "è",
    "鄂": "è",
    "锇": "é",
    "谔": "è",
    "垩": "è",
    "锷": "è",
    "萼": "è",
    "阏": "è",
    "苊": "è",
    "轭": "è",
    "婀": "ē",
    "鳄": "è",
    "莪": "é",
    "颚": "è",
    "腭": "è",
    "愕": "è",
    "屙": "ē",
    "鹗": "è",
    "亞": "yā,yà",
    "伪": "wěi",
    "佮": "gé",
    "噩": "è",
    "亜": "yà",
    "偔": "è",
    "侉": "kuǎ",
    "亚": "yà",
    "僫": "è,wù,wū",
    "僞": "wěi",
    "匎": "è",
    "偽": "wěi",
    "卾": "è",
    "吪": "é,huā",
    "咢": "è",
    "唖": "yǎ",
    "啈": "hèng",
    "哑": "yǎ,yā",
    "噁": "ě",
    "囐": "yàn,zá,niè",
    "啞": "yǎ,yā",
    "囮": "é",
    "垭": "yà",
    "埡": "yà",
    "堮": "è",
    "堊": "è",
    "妸": "ē",
    "妿": "ē",
    "姶": "è,yà",
    "娿": "ē,ě",
    "屵": "àn",
    "岋": "è",
    "峉": "é",
    "崿": "è",
    "峩": "é",
    "廅": "è",
    "悪": "è",
    "搕": "kē,è",
    "惡": "è,wù,ě,wū",
    "搹": "è",
    "搤": "è",
    "擜": "è",
    "戹": "è",
    "枙": "ě,è",
    "曷": "hé",
    "椏": "yā",
    "歞": "è",
    "櫮": "è",
    "涐": "é",
    "湂": "è",
    "琧": "è",
    "歺": "è",
    "玀": "luó",
    "珴": "é",
    "皒": "é",
    "睋": "é",
    "砈": "è",
    "砐": "è",
    "砨": "ě",
    "硆": "è",
    "硪": "wò",
    "磀": "é",
    "礘": "è,qì",
    "蒍": "wěi",
    "蕚": "è",
    "蘁": "wù",
    "蚅": "è",
    "蝁": "è",
    "覨": "è",
    "詻": "luò",
    "訛": "é",
    "譌": "é",
    "諤": "è",
    "讍": "è",
    "豟": "è",
    "誐": "é",
    "軶": "è",
    "軛": "è",
    "輵": "gé",
    "迗": "é",
    "遌": "è",
    "遻": "è",
    "鈋": "é",
    "邑": "yì",
    "鑩": "è",
    "鋨": "é",
    "鍔": "è",
    "閜": "xiǎ,kě",
    "頟": "é",
    "閼": "è,yān",
    "額": "é",
    "顎": "è",
    "餓": "è",
    "餩": "è",
    "魤": "é",
    "魥": "jì",
    "騀": "ě",
    "鰐": "è",
    "鰪": "è",
    "鵈": "ě",
    "鱷": "è",
    "鬲": "gé,lì",
    "鵞": "é",
    "鵝": "é",
    "齃": "è",
    "鶚": "è",
    "齾": "yà",
    "齶": "è",
    "摁": "èn",
    "蒽": "ēn",
    "恩": "ēn",
    "奀": "ēn",
    "嗯": "ň",
    "峎": "ěn",
    "煾": "ēn,yūn",
    "饐": "yì",
    "仒": "bīng",
    "鞥": "ēng",  # Unknow.
    "唔": "wù,wú,ń",
    "乻": "yú",
    "欕": "yán",
    "旕": "yú",  # Unknow.
    "而": "ér",
    "二": "èr",
    "耳": "ěr",
    "儿": "ér",
    "饵": "ěr",
    "贰": "èr",
    "尔": "ěr",
    "洱": "ěr",
    "鲕": "ér",
    "珥": "ěr",
    "鸸": "ér",
    "侕": "ér",
    "佴": "èr,nài",
    "迩": "ěr",
    "铒": "ěr",
    "刵": "èr",
    "兒": "ér",
    "咡": "èr",
    "唲": "ér,wā",
    "児": "ér",
    "嬭": "nǎi",
    "尒": "ěr",
    "尓": "ěr",
    "峏": "ér",
    "弍": "èr",
    "栭": "ér",
    "樲": "èr",
    "弐": "èr",
    "杒": "rèn,ér",
    "栮": "ěr",
    "毦": "ěr",
    "洏": "ér",
    "濡": "rú",
    "渪": "rú",
    "粫": "ér",
    "耏": "ér,nài",
    "聏": "ér,nǜ",
    "胹": "ér",
    "臑": "nào",
    "爾": "ěr",
    "薾": "ěr",
    "衈": "ěr",
    "袻": "ér",
    "輀": "ér",
    "貮": "èr",
    "荋": "ér",
    "趰": "ěr",
    "轜": "ér",
    "貳": "èr",
    "邇": "ěr",
    "輭": "ruǎn",
    "陑": "ér",
    "隭": "ér",
    "陾": "réng",
    "駬": "ěr",
    "鉺": "ěr",
    "髵": "ér",
    "髶": "èr",
    "餌": "ěr",
    "鮞": "ér",
    "法": "fǎ",
    "鴯": "ér",
    "发": "fā,fà",
    "罚": "fá",
    "乏": "fá",
    "伐": "fá",
    "阀": "fá",
    "筏": "fá",
    "珐": "fà",
    "砝": "fǎ",
    "佱": "fǎ",
    "垡": "fá",
    "姂": "fá",
    "傠": "fá",
    "彂": "fā",
    "栰": "fá",
    "橃": "fá,fèi",
    "廢": "fèi",
    "汎": "fàn",
    "沷": "fā",
    "灋": "fǎ",
    "泛": "fàn",
    "発": "fā",
    "琺": "fà",
    "瞂": "fá",
    "罸": "fá",
    "罰": "fá",
    "蕟": "fà",
    "藅": "fá",
    "醗": "pō,fā",
    "髪": "fà",
    "髮": "fà",
    "反": "fǎn",
    "醱": "pō,fā",
    "鍅": "fǎ",
    "饭": "fàn",
    "翻": "fān",
    "閥": "fá",
    "凡": "fán",
    "帆": "fān",
    "繁": "fán,pó",
    "烦": "fán",
    "贩": "fàn",
    "范": "fàn",
    "犯": "fàn",
    "返": "fǎn",
    "樊": "fán",
    "钒": "fán",
    "藩": "fān",
    "矾": "fán",
    "燔": "fán",
    "蘩": "fán",
    "畈": "fàn",
    "梵": "fàn",
    "仮": "fǎn",
    "幡": "fān",
    "凢": "fán",
    "伋": "jí",
    "凣": "fán",
    "勫": "fān",
    "匥": "fán",
    "墦": "fán",
    "蹯": "fán",
    "婏": "fù,fàn",
    "奿": "fàn",
    "嬎": "fàn",
    "嬏": "fān",
    "嬔": "fù",
    "忛": "fān",
    "払": "fǎn,fú",
    "憣": "fān",
    "旛": "fān",
    "杋": "fán",
    "旙": "fān",
    "柉": "fán",
    "橎": "fǎn",
    "氾": "fàn",
    "楓": "fēng",
    "滼": "fàn",
    "渢": "fēng",
    "瀪": "fàn",
    "棥": "fán",
    "犿": "huān,fān",
    "煩": "fán",
    "璠": "fán",
    "畨": "fān,pān",
    "盕": "fàn",
    "瀿": "fán",
    "笲": "fán",
    "笵": "fàn",
    "礬": "fán",
    "籵": "fán",
    "緐": "fán",
    "範": "fàn",
    "羳": "fán",
    "舤": "fán",
    "膰": "fán,pán",
    "繙": "fān",
    "舧": "fán",
    "薠": "fán",
    "蟠": "pán",
    "蠜": "fán",
    "訉": "fàn",
    "袢": "pàn",
    "軬": "fàn",
    "轓": "fān",
    "軓": "fàn,guǐ",
    "辺": "dào,biān",
    "鐇": "fán",
    "販": "fàn",
    "釩": "fán",
    "颿": "fān",
    "飜": "fān",
    "鱕": "fān",
    "飯": "fàn",
    "飰": "fàn",
    "鷭": "fán",
    "犭": "quǎn",
    "攵": "pū",
    "放": "fàng",
    "防": "fáng",
    "芳": "fāng",
    "方": "fāng",
    "仿": "fǎng",
    "房": "fáng",
    "坊": "fāng,fáng",
    "肪": "fáng",
    "妨": "fáng",
    "访": "fǎng",
    "彷": "páng,fǎng",
    "钫": "fāng",
    "邡": "fāng",
    "舫": "fǎng",
    "鲂": "fáng",
    "倣": "fǎng",
    "匚": "fāng",
    "堏": "fāng",
    "旊": "fǎng",
    "昉": "fǎng",
    "昘": "fǎng",
    "汸": "fāng,pāng",
    "淓": "fāng",
    "瓬": "fǎng",
    "牥": "fāng",
    "眆": "fǎng",
    "趽": "fāng,fàng,páng",
    "訪": "fǎng",
    "錺": "fāng",
    "雱": "pāng",
    "髣": "fǎng",
    "魴": "fáng",
    "鈁": "fāng",
    "鰟": "páng",
    "鳑": "páng",
    "鴋": "fāng",
    "鶭": "fǎng",
    "非": "fēi",
    "肥": "féi",
    "肺": "fèi",
    "废": "fèi",
    "匪": "fěi",
    "沸": "fèi",
    "吠": "fèi",
    "诽": "fěi",
    "飞": "fēi",
    "菲": "fēi,fěi",
    "啡": "fēi",
    "篚": "fěi",
    "腓": "féi",
    "扉": "fēi",
    "妃": "fēi,pèi",
    "斐": "fěi,fēi",
    "狒": "fèi",
    "芾": "fèi,fú",
    "悱": "fěi",
    "镄": "fèi",
    "翡": "fěi",
    "霏": "fēi",
    "淝": "féi",
    "鲱": "fēi",
    "榧": "fěi",
    "痱": "fèi,féi",
    "剕": "fèi",
    "厞": "fèi",
    "绯": "fēi",
    "婔": "fēi",
    "廃": "fèi",
    "屝": "fèi",
    "俷": "fèi",
    "昲": "fèi",
    "婓": "fēi",
    "暃": "fēi",
    "奜": "fěi",
    "曊": "fèi",
    "朏": "fěi,kū",
    "柹": "shì,fèi",
    "棐": "fěi",
    "橨": "fén,fèn,fèi",
    "櫠": "fèi",
    "渄": "fēi",
    "濷": "fèi",
    "猆": "fēi",
    "疿": "fèi,féi",
    "癈": "fèi",
    "笰": "fú,fèi",
    "砩": "fú,fèi",
    "祓": "fú",
    "紼": "fú",
    "緋": "fēi",
    "胏": "zǐ,fèi",
    "绋": "fú",
    "胐": "fěi,kū",
    "蕜": "fěi",
    "蕡": "fén",
    "蜰": "féi",
    "萉": "fèi",
    "裶": "fēi",
    "裵": "péi",
    "陫": "fèi",
    "鐨": "fèi",
    "誹": "fěi",
    "靅": "fèi",
    "靟": "fēi",
    "裴": "péi",
    "飝": "fēi",
    "飛": "fēi",
    "餥": "fēi",
    "馡": "fēi",
    "騑": "fēi",
    "騛": "fēi",
    "髴": "fú",
    "芬": "fēn",
    "鼣": "fèi",
    "奋": "fèn",
    "坟": "fén",
    "愤": "fèn",
    "鯡": "fēi",
    "纷": "fēn",
    "忿": "fèn",
    "粉": "fěn",
    "粪": "fèn",
    "酚": "fēn",
    "焚": "fén",
    "吩": "fēn",
    "氛": "fēn",
    "棼": "fén",
    "瀵": "fèn",
    "鲼": "fèn",
    "偾": "fèn",
    "汾": "fén",
    "鼢": "fén",
    "僨": "fèn",
    "坆": "méi,fén",
    "喷": "pēn,pèn",
    "坋": "bèn,fèn",
    "墳": "fén",
    "奮": "fèn",
    "噴": "pēn,pèn",
    "妢": "fén",
    "帉": "fēn",
    "幩": "fén",
    "弅": "fèn",
    "愍": "mǐn",
    "敃": "mǐn",
    "憤": "fèn",
    "昐": "fēn",
    "朆": "fēn",
    "枌": "fén",
    "梤": "fēn",
    "棻": "fēn",
    "歕": "pēn",
    "燓": "fén",
    "濆": "fén,pēn",
    "盼": "pàn",
    "秎": "fèn",
    "竕": "fēn",
    "瞓": "fèn",
    "羒": "fén",
    "羵": "fén",
    "紛": "fēn",
    "翂": "fēn",
    "膹": "fèn",
    "糞": "fèn",
    "葐": "pén",
    "蒶": "fén",
    "蚠": "fén",
    "蚡": "fén",
    "衯": "fēn",
    "豶": "fén",
    "豮": "fén",
    "躮": "fēn",
    "鈖": "fēn",
    "錀": "lún",
    "隫": "fén",
    "雰": "fēn",
    "餴": "fēn",
    "轒": "fén",
    "饙": "fēn",
    "馚": "fēn",
    "馩": "fén",
    "魵": "fén",
    "黂": "fén",
    "黺": "fěn",
    "鼖": "fén",
    "鱝": "fèn",
    "风": "fēng,fěng",
    "逢": "féng",
    "蜂": "fēng",
    "缝": "féng,fèng",
    "丰": "fēng",
    "枫": "fēng",
    "疯": "fēng",
    "冯": "féng,píng",
    "讽": "fěng",
    "凤": "fèng",
    "峰": "fēng",
    "锋": "fēng",
    "奉": "fèng",
    "葑": "fēng",
    "酆": "fēng",
    "烽": "fēng",
    "仹": "fēng",
    "偑": "fēng",
    "凨": "fēng",
    "沣": "fēng",
    "僼": "fēng",
    "凬": "fēng",
    "砜": "fēng",
    "凮": "fēng",
    "夆": "féng,fēng,páng",
    "堸": "féng",
    "妦": "fēng",
    "寷": "fēng",
    "崶": "fēng",
    "峯": "fēng",
    "捀": "péng",
    "捧": "pěng",
    "桻": "fēng,fèng",
    "沨": "fēng",
    "浲": "féng,hóng",
    "摓": "féng,pěng",
    "湗": "fèng",
    "溄": "féng,hóng",
    "焨": "fèng",
    "檒": "fēng",
    "犎": "fēng",
    "炐": "pàng,fēng",
    "煈": "fèng",
    "猦": "fēng",
    "灃": "fēng",
    "琒": "fēng",
    "甮": "béng",
    "盽": "fēng",
    "瘋": "fēng",
    "篈": "fēng",
    "碸": "fēng",
    "綘": "féng",
    "肨": "pàn",
    "舽": "páng",
    "縫": "féng,fèng",
    "艂": "féng",
    "莑": "péng,fēng",
    "蘕": "péng",
    "諷": "fěng",
    "蘴": "fēng",
    "豊": "lǐ",
    "賵": "fèng",
    "豐": "fēng",
    "赗": "fèng",
    "逄": "páng",
    "鄷": "fēng",
    "鋒": "fēng",
    "鏠": "fēng",
    "靊": "fēng",
    "鎽": "fēng",
    "飌": "fēng",
    "風": "fēng,fěng",
    "鳯": "fèng",
    "馮": "féng,píng",
    "鴌": "fèng",
    "鳳": "fèng",
    "麷": "fēng",
    "鵬": "péng",
    "鹏": "péng",
    "覅": "fiào",
    "仏": "fó",
    "梻": "fó",
    "否": "fǒu,pǐ",
    "仸": "yǎo,fó",
    "缶": "fǒu",
    "垺": "póu,fú",
    "妚": "fǒu,pēi,pī",
    "炰": "páo,fǒu",
    "坲": "fó",
    "紑": "fóu",
    "缹": "fǒu",
    "缻": "fǒu",
    "芣": "fú",
    "衃": "pēi",
    "雬": "fǒu",
    "鴀": "fǒu",
    "副": "fù,pì",
    "扶": "fú",
    "富": "fù",
    "浮": "fú",
    "福": "fú",
    "负": "fù",
    "伏": "fú",
    "付": "fù",
    "俯": "fǔ",
    "斧": "fǔ",
    "赴": "fù",
    "缚": "fù",
    "夫": "fū,fú",
    "父": "fù,fǔ",
    "符": "fú",
    "孵": "fū",
    "敷": "fū",
    "赋": "fù",
    "辅": "fǔ",
    "腐": "fǔ",
    "府": "fǔ",
    "妇": "fù",
    "腹": "fù",
    "抚": "fǔ",
    "覆": "fù",
    "肤": "fū",
    "氟": "fú",
    "傅": "fù",
    "俘": "fú",
    "讣": "fù",
    "弗": "fú",
    "涪": "fú",
    "辐": "fú",
    "袱": "fú",
    "市": "shì",
    "甫": "fǔ",
    "釜": "fǔ",
    "脯": "fǔ",
    "腑": "fǔ",
    "阜": "fù",
    "咐": "fù",
    "黼": "fǔ",
    "苻": "fú",
    "趺": "fū",
    "跗": "fū",
    "蚨": "fú",
    "幞": "fú",
    "茯": "fú",
    "滏": "fǔ",
    "蜉": "fú",
    "菔": "fú",
    "蝠": "fú",
    "鳆": "fù",
    "蝮": "fù",
    "赙": "fù",
    "罘": "fú",
    "匐": "fú",
    "稃": "fū",
    "麸": "fū",
    "绂": "fú",
    "凫": "fú",
    "桴": "fú",
    "莩": "fú,piǎo",
    "孚": "fú",
    "呋": "fū",
    "郛": "fú",
    "乀": "fú",
    "黻": "fú",
    "伕": "fū",
    "仅": "jǐn,jìn",
    "驸": "fù",
    "俌": "fǔ",
    "芙": "fú",
    "俛": "fǔ",
    "冹": "fā",
    "呒": "fǔ",
    "咈": "fú",
    "哹": "fú",
    "冨": "fù",
    "坿": "fù",
    "刜": "fú",
    "嘸": "fǔ,",
    "偩": "fù",
    "垘": "fú",
    "妋": "fū,yōu",
    "姇": "fū,fú",
    "媍": "fù",
    "娐": "fū",
    "婦": "fù",
    "峊": "fù,niè",
    "巿": "fú",
    "宓": "mì,fú",
    "弣": "fǔ",
    "岪": "fú",
    "彿": "fù",
    "復": "fù",
    "怀": "huái",
    "怤": "fū",
    "抙": "póu,pōu,fū",
    "懯": "fū",
    "掊": "pǒu,póu",
    "撫": "fǔ",
    "捊": "póu,pōu,fū",
    "枎": "fú,fū",
    "柎": "fū,fǔ,fù",
    "柫": "fú",
    "栿": "fú",
    "旉": "fū",
    "棴": "fú,sù",
    "椨": "fǔ",
    "汱": "tài",
    "沕": "mì,wù",
    "椱": "fù",
    "澓": "fú",
    "炥": "fú",
    "烰": "fú,páo",
    "焤": "fǔ",
    "玸": "fú",
    "玞": "fū",
    "洑": "fú,fù",
    "泭": "fú",
    "琈": "fú,fū",
    "璷": "lú,fū",
    "畉": "fú",
    "甶": "fú",
    "癁": "fú",
    "盙": "fǔ",
    "砆": "fū",
    "禣": "fù",
    "稪": "fú",
    "竎": "fù",
    "祔": "fù",
    "簠": "fǔ",
    "箙": "fú",
    "粰": "fū,fú",
    "糐": "fū",
    "紨": "fū,fù",
    "綍": "fú",
    "絥": "fú",
    "筟": "fū",
    "綒": "fū",
    "紱": "fú",
    "緮": "fù",
    "纀": "pú,fú",
    "縛": "fù",
    "翇": "fú",
    "罦": "fú",
    "胕": "fū,fú,zhǒu",
    "膚": "fū",
    "艀": "fú",
    "荂": "fū",
    "荴": "fū",
    "蓲": "qiū,xū,fū",
    "葍": "fú",
    "蕧": "fù",
    "虙": "fú",
    "蚥": "fù,fǔ",
    "蚹": "fù",
    "蜅": "fǔ",
    "蛗": "fù",
    "莆": "pú",
    "衭": "fū",
    "蝜": "fù",
    "袝": "fù",
    "複": "fù",
    "褔": "fù,fú",
    "襆": "fú",
    "覄": "fù",
    "襥": "fú",
    "詂": "fù",
    "諨": "fú",
    "豧": "fú",
    "訃": "fù",
    "負": "fù",
    "賦": "fù",
    "軵": "rǒng",
    "賻": "fù",
    "輔": "fǔ",
    "輻": "fú",
    "还": "huán,hái",
    "邚": "rú",
    "邞": "fū",
    "郍": "nà",
    "郙": "fǔ",
    "鄜": "fū",
    "酜": "fū",
    "酻": "zuì",
    "釡": "fǔ",
    "鈇": "fū",
    "鉘": "fú",
    "鉜": "fú",
    "鍑": "fù",
    "錇": "péi",
    "鍢": "fù",
    "锫": "péi",
    "陚": "wǔ",
    "韍": "fú",
    "阝": "fǔ",
    "韨": "fú",
    "颫": "fú",
    "鮄": "fú",
    "駙": "fù",
    "頫": "fǔ",
    "鮲": "fú",
    "鬴": "fǔ",
    "鮒": "fù",
    "鰒": "fù",
    "鳺": "fū,guī",
    "鴔": "fú",
    "鵩": "fú",
    "鳧": "fú",
    "鳬": "fú",
    "麬": "fū",
    "麱": "fū",
    "麩": "fū",
    "噶": "gá",
    "胳": "gē,gé",
    "夹": "jiā,jiá,gā,xiá",
    "嘎": "gā,gá,gǎ",
    "咖": "kā,gā",
    "轧": "yà",
    "钆": "gá",
    "伽": "qié,jiā,gā",
    "旮": "gā",
    "尬": "gà",
    "尕": "gǎ",
    "尜": "gá",
    "玍": "gǎ",
    "呷": "xiā",
    "嘠": "gā,gá,gǎ",
    "軋": "yà,zhá,gá",
    "錷": "gá",
    "釓": "gá",
    "魀": "gà",
    "甴": "yóu,zhá",
    "该": "gāi",
    "改": "gǎi",
    "盖": "gài,gě,hé",
    "概": "gài",
    "芥": "jiè,gài",
    "溉": "gài",
    "垓": "gāi",
    "丐": "gài",
    "陔": "gāi",
    "戤": "gài",
    "乢": "gài",
    "赅": "gāi",
    "侅": "gāi",
    "匃": "gài",
    "钙": "gài",
    "匄": "gài",
    "姟": "gāi",
    "峐": "gāi",
    "咳": "ké,hāi",
    "摡": "gài,xì",
    "晐": "gāi",
    "杚": "gū,gài",
    "忋": "gǎi",
    "核": "hé,hú",
    "漑": "gài",
    "汽": "qì",
    "瓂": "gài",
    "槪": "gài",
    "畡": "gāi",
    "槩": "gài",
    "絯": "gāi,hài",
    "胲": "hǎi",
    "葢": "gài",
    "豥": "gāi",
    "荄": "gāi",
    "祴": "gāi",
    "賌": "gāi",
    "郂": "gāi,hái",
    "賅": "gāi",
    "蓋": "gài,gě,hé",
    "鎅": "jiè",
    "該": "gāi",
    "鈣": "gài",
    "阣": "yì",
    "骸": "hái",
    "赶": "gǎn",
    "感": "gǎn",
    "敢": "gǎn",
    "竿": "gān",
    "肝": "gān",
    "甘": "gān",
    "杆": "gān,gǎn",
    "赣": "gàn",
    "秆": "gǎn",
    "旰": "gàn,hàn",
    "酐": "gān",
    "矸": "gān",
    "柑": "gān",
    "疳": "gān",
    "苷": "gān",
    "泔": "gān",
    "擀": "gǎn",
    "绀": "gàn",
    "澉": "gǎn",
    "坩": "gān",
    "淦": "gàn",
    "尴": "gān",
    "个": "gè,gě",
    "乹": "qián",
    "亁": "qián",
    "橄": "gǎn",
    "乾": "qián,gān",
    "仠": "gǎn,hàn",
    "佄": "hān,gàn",
    "倝": "gàn",
    "凎": "gàn",
    "凲": "gān",
    "咁": "xián,gān",
    "尶": "gān",
    "尲": "gān",
    "奸": "jiān",
    "尷": "gān",
    "幹": "gàn",
    "扞": "hàn",
    "捍": "hàn",
    "忓": "gān,hàn",
    "攼": "gān,hàn",
    "檊": "gàn",
    "浛": "hán",
    "汗": "hàn,hán",
    "漧": "gān",
    "灨": "gàn",
    "皯": "gǎn",
    "桿": "gǎn",
    "榦": "gàn",
    "玕": "gān",
    "盰": "gàn",
    "笴": "gě",
    "筸": "gān",
    "稈": "gǎn",
    "粓": "gān",
    "簳": "gǎn,gàn",
    "篢": "gōng,gǎn,lǒng",
    "紺": "gàn",
    "虷": "hán",
    "衦": "gǎn",
    "詌": "gàn",
    "諴": "xián",
    "芉": "gǎn",
    "豃": "hǎn",
    "贑": "gàn",
    "迀": "gān",
    "釬": "hàn",
    "趕": "gǎn",
    "錎": "xiàn",
    "飦": "zhān",
    "骭": "gàn",
    "魐": "gān",
    "贛": "gàn",
    "鰔": "jiān",
    "鱤": "gǎn",
    "鳡": "gǎn",
    "鳱": "gān,hàn,yàn",
    "钢": "gāng,gàng",
    "刚": "gāng",
    "港": "gǎng,jiǎng",
    "纲": "gāng",
    "缸": "gāng",
    "岗": "gǎng",
    "肛": "gāng",
    "扛": "káng,gāng",
    "筻": "gàng",
    "罡": "gāng",
    "戆": "gàng,zhuàng",
    "冈": "gāng",
    "杠": "gàng,gāng",
    "亢": "kàng",
    "伉": "kàng",
    "堽": "gāng",
    "剛": "gāng",
    "冮": "gāng",
    "戅": "gàng,zhuàng",
    "岡": "gāng",
    "堈": "gāng",
    "戇": "gàng,zhuàng",
    "掆": "gāng",
    "抗": "kàng",
    "槓": "gàng",
    "溝": "gōu",
    "焵": "gàng",
    "棡": "gāng",
    "牨": "gāng",
    "犅": "gāng",
    "犺": "kàng,gǎng",
    "疘": "gāng",
    "碙": "náo,gāng",
    "罁": "gāng",
    "矼": "gāng,qiāng,kòng",
    "罓": "wǎng",
    "綱": "gāng",
    "釭": "gāng",
    "鋼": "gāng,gàng",
    "阬": "kēng",
    "頏": "háng",
    "鎠": "gāng",
    "颃": "háng",
    "高": "gāo",
    "搞": "gǎo",
    "告": "gào",
    "稿": "gǎo",
    "篙": "gāo",
    "膏": "gāo,gào",
    "羔": "gāo",
    "镐": "gǎo",
    "糕": "gāo",
    "皋": "gāo,háo",
    "郜": "gào",
    "杲": "gǎo",
    "诰": "gào",
    "睾": "gāo",
    "槔": "gāo",
    "锆": "gào",
    "槁": "gǎo",
    "勂": "gào",
    "藁": "gǎo",
    "吿": "gào",
    "缟": "gǎo",
    "夰": "gǎo",
    "咎": "jiù",
    "峼": "gào",
    "暠": "hào",
    "槀": "gǎo",
    "槹": "gāo",
    "櫜": "gāo",
    "滜": "zé,hào",
    "浩": "hào",
    "橰": "gāo",
    "檺": "gǎo",
    "澔": "hào",
    "獋": "háo,gāo",
    "獔": "háo",
    "皐": "gāo,yáo",
    "祮": "gào",
    "祰": "gào",
    "禞": "gào",
    "稾": "gǎo",
    "筶": "gào",
    "羙": "měi,gāo",
    "稁": "gǎo",
    "臯": "gāo",
    "縞": "gǎo",
    "菒": "gǎo",
    "藳": "gǎo",
    "蒿": "hāo",
    "誥": "gào",
    "鋯": "gào",
    "韟": "gāo",
    "餻": "gāo",
    "鎬": "gǎo,hào",
    "髙": "gāo",
    "鷎": "gāo",
    "鷱": "gāo",
    "鼛": "gāo",
    "各": "gè,gě",
    "歌": "gē",
    "割": "gē",
    "哥": "gē",
    "搁": "gē,gé",
    "格": "gé",
    "阁": "gé",
    "隔": "gé",
    "咯": "kǎ,luò,gē",
    "葛": "gé,gě",
    "蛤": "gé,há",
    "戈": "gē",
    "鸽": "gē",
    "疙": "gē,yì",
    "屹": "yì",
    "合": "hé,gě",
    "硌": "luò,gè",
    "铬": "gè",
    "骼": "gé",
    "颌": "hé,gé",
    "革": "gé",
    "袼": "gē",
    "塥": "gé",
    "圪": "gē",
    "虼": "gè",
    "镉": "gé",
    "舸": "gě",
    "嗝": "gé",
    "膈": "gé",
    "搿": "gé",
    "仡": "yì,gē",
    "纥": "hé,gē",
    "佫": "gé",
    "哿": "gě,jiā",
    "介": "jiè",
    "匌": "gé",
    "個": "gè,gě",
    "呄": "gé",
    "吤": "jiè,gè",
    "可": "kě,kè",
    "嘅": "kǎi,gě",
    "嘢": "yě",
    "彁": "gē",
    "戓": "gē",
    "戨": "gē",
    "扢": "gǔ,xì,gē,jié",
    "挌": "gé",
    "擱": "gē,gé",
    "敋": "gé,guó,è",
    "愅": "gé",
    "櫊": "gé",
    "滆": "gé",
    "牫": "gē,qiú",
    "槅": "gé",
    "犵": "gē",
    "猲": "xiē,hè,gé,hài",
    "牱": "kē",
    "獦": "gé,liè,xiē",
    "箇": "gè",
    "秴": "huō",
    "滒": "gē",
    "肐": "gē",
    "紇": "hé,gē",
    "臵": "gé",
    "茖": "gè",
    "蛒": "gé,luò",
    "菏": "hé",
    "裓": "gé,jiē",
    "觡": "gé",
    "詥": "hé",
    "臈": "là,gé",
    "謌": "gē",
    "轕": "gé",
    "鎑": "yè,tà,gé",
    "鉀": "jiǎ",
    "鎶": "gē",
    "鉻": "gè",
    "鉿": "hā",
    "鎘": "gé,lì",
    "钾": "jiǎ",
    "諽": "gé",
    "铪": "hā,kē",
    "閤": "hé,gé",
    "閘": "zhá",
    "閣": "gé",
    "鞷": "gé",
    "鞈": "gé,tà,sǎ",
    "韐": "gé",
    "闸": "zhá",
    "騔": "gé",
    "韚": "gé",
    "魺": "hé",
    "頜": "hé",
    "鮥": "luò,gé",
    "髂": "qià",
    "鮯": "gé",
    "鲄": "hé,gě",
    "鴐": "jiā",
    "鴚": "gē",
    "鵅": "luò",
    "给": "gěi,jǐ",
    "跟": "gēn",
    "根": "gēn",
    "哏": "gén,hěn",
    "亘": "gèn",
    "茛": "gèn",
    "艮": "gèn",
    "搄": "gèn",
    "鴿": "gē",
    "更": "gēng,gèng",
    "耕": "gēng",
    "揯": "gèn",
    "颈": "jǐng,gěng",
    "梗": "gěng",
    "耿": "gěng",
    "庚": "gēng",
    "赓": "gēng",
    "鲠": "gěng",
    "亙": "gèn",
    "哽": "gěng",
    "刯": "gēng",
    "峺": "gěng",
    "堩": "gèng",
    "挭": "gěng",
    "椩": "gēng",
    "暅": "xuǎn",
    "埂": "gěng",
    "羹": "gēng",
    "焿": "gēng",
    "浭": "gēng",
    "畊": "gēng",
    "恆": "héng",
    "絚": "gēng",
    "絙": "huán,gēng",
    "硬": "yìng",
    "掶": "jié",
    "緪": "gēng,gèng",
    "羮": "gēng",
    "縆": "gēng,gèng",
    "莄": "gěng",
    "菮": "gēng",
    "郉": "xíng",
    "郠": "gěng",
    "邢": "xíng",
    "骾": "gěng",
    "鯁": "gěng",
    "鶊": "gēng",
    "頸": "jǐng",
    "鹒": "gēng",
    "喼": "jiē",
    "嗰": "gě",
    "賡": "gēng",
    "工": "gōng",
    "功": "gōng",
    "公": "gōng",
    "共": "gòng,gōng",
    "弓": "gōng",
    "攻": "gōng",
    "宫": "gōng",
    "供": "gōng,gòng",
    "恭": "gōng",
    "拱": "gǒng",
    "贡": "gòng",
    "躬": "gōng",
    "巩": "gǒng",
    "汞": "gǒng",
    "肱": "gōng",
    "龚": "gōng",
    "红": "hóng,gōng",
    "觥": "gōng",
    "珙": "gǒng",
    "匑": "gōng",
    "蚣": "gōng,zhōng",
    "匔": "gōng",
    "咣": "guāng",
    "唝": "gòng,hǒng,gǒng",
    "嗊": "gòng,hǒng,gǒng",
    "厷": "gōng,hóng",
    "塨": "gōng",
    "幊": "gōng",
    "愩": "gōng,gòng,hǒng",
    "慐": "gōng,gòng,hǒng",
    "廾": "gǒng",
    "拲": "gǒng",
    "杛": "gōng",
    "栱": "gǒng",
    "渱": "hóng",
    "熕": "gòng",
    "碽": "gōng",
    "糼": "gōng",
    "宮": "gōng",
    "羾": "hóng,gòng",
    "紅": "hóng,gōng",
    "蛩": "qióng",
    "觵": "gōng",
    "虹": "hóng",
    "躳": "gōng",
    "輁": "gǒng",
    "貢": "gòng",
    "銾": "hòng,gǒng",
    "髸": "gōng",
    "魟": "hóng",
    "鞏": "gǒng",
    "龏": "gōng,wò",
    "龔": "gōng",
    "够": "gòu",
    "沟": "gōu",
    "狗": "gǒu",
    "钩": "gōu",
    "勾": "gōu,gòu",
    "购": "gòu",
    "构": "gòu",
    "苟": "gǒu",
    "句": "jù,gōu",
    "垢": "gòu",
    "岣": "gǒu",
    "彀": "gòu",
    "枸": "jǔ,gǒu",
    "鞲": "gōu",
    "觏": "gòu",
    "缑": "gōu",
    "诟": "gòu",
    "笱": "gǒu",
    "遘": "gòu",
    "媾": "gòu",
    "篝": "gōu",
    "佝": "gōu,kòu",
    "傋": "jiǎng,gòu",
    "冓": "gòu",
    "呴": "xǔ,hǒu,gòu",
    "区": "qū,ōu",
    "區": "qū,ōu",
    "坸": "gòu",
    "抅": "jū",
    "姤": "gòu,dù",
    "搆": "gòu",
    "拘": "jū,gōu",
    "撀": "gòu",
    "泃": "jū",
    "煹": "gòu",
    "構": "gòu",
    "玽": "gǒu",
    "簼": "gōu",
    "緱": "gōu",
    "耈": "gǒu",
    "夠": "gòu",
    "耉": "gǒu",
    "蚼": "gǒu,qú,xù",
    "茩": "hòu",
    "耇": "gǒu",
    "褠": "gōu",
    "袧": "gōu",
    "訽": "gòu",
    "覯": "gòu",
    "詬": "gòu",
    "豿": "gǒu",
    "軥": "qú",
    "購": "gòu",
    "鉤": "gōu",
    "雊": "gòu",
    "鮈": "jū",
    "韝": "gōu",
    "鈎": "gōu",
    "鴝": "qú",
    "鸜": "qú",
    "鸲": "qú",
    "古": "gǔ",
    "股": "gǔ",
    "鼓": "gǔ",
    "谷": "gǔ",
    "故": "gù",
    "孤": "gū",
    "箍": "gū",
    "姑": "gū",
    "顾": "gù",
    "固": "gù",
    "估": "gū,gù",
    "雇": "gù",
    "咕": "gū",
    "蛊": "gǔ",
    "骨": "gǔ,gū",
    "沽": "gū",
    "菇": "gū",
    "辜": "gū",
    "贾": "gǔ,jiǎ",
    "鸪": "gū",
    "梏": "gù",
    "崮": "gù",
    "轱": "gū",
    "鹄": "hú",
    "菰": "gū",
    "汩": "gǔ,yù",
    "鹘": "gǔ",
    "臌": "gǔ",
    "钴": "gǔ",
    "酤": "gū",
    "呱": "guā,gū,guǎ",
    "鲴": "gù",
    "牯": "gǔ",
    "诂": "gǔ",
    "瞽": "gǔ",
    "毂": "gǔ",
    "锢": "gù",
    "牿": "gù",
    "痼": "gù",
    "蛄": "gū",
    "觚": "gū",
    "嘏": "gǔ",
    "傦": "gǔ",
    "罟": "gǔ",
    "僱": "gù",
    "凅": "gù",
    "劷": "yáng",
    "唂": "gū",
    "唃": "gū",
    "哌": "pài",
    "啒": "gǔ",
    "嗀": "hù",
    "嗗": "wā,gǔ",
    "堌": "gù",
    "夃": "gǔ,yíng",
    "峠": "qiǎ",
    "尳": "gǔ",
    "崓": "gù",
    "怘": "hù,gù",
    "愲": "gǔ",
    "抇": "hú,gǔ",
    "嫴": "gū",
    "枯": "kū",
    "榖": "gǔ",
    "棝": "gù",
    "榾": "gù",
    "橭": "gū",
    "櫎": "huǎng,guǒ,gǔ",
    "柧": "gū",
    "泒": "gū",
    "淈": "gǔ",
    "濲": "gǔ",
    "瀔": "gǔ",
    "滑": "huá",
    "焸": "xiǒng,yīng",
    "皷": "gǔ",
    "瓠": "hù",
    "盬": "gǔ",
    "硲": "yù",
    "磆": "huá,kě,gū",
    "祻": "gù",
    "稒": "gū",
    "笟": "gū",
    "箛": "gū",
    "篐": "gū",
    "穀": "gǔ",
    "糓": "gǔ,gòu",
    "罛": "gū",
    "羖": "gǔ",
    "脵": "gǔ",
    "胍": "guā",
    "苽": "gū",
    "縎": "gǔ,hú",
    "苦": "kǔ",
    "薣": "gǔ",
    "蓇": "gū",
    "蛌": "tún",
    "蠱": "gǔ",
    "角": "jiǎo,jué",
    "詁": "gǔ",
    "軱": "gū",
    "賈": "jiǎ,gǔ,jià",
    "轂": "gǔ",
    "軲": "gū",
    "逧": "gǔ",
    "鈲": "gū",
    "頋": "ě",
    "鈷": "gǔ",
    "錮": "gù",
    "顧": "gù",
    "餶": "gǔ",
    "馉": "gǔ",
    "骰": "tóu",
    "鯝": "gù",
    "鴣": "gū",
    "鵠": "hú",
    "鶻": "gǔ,hú",
    "鼔": "gǔ",
    "鮕": "gū",
    "挂": "guà",
    "刮": "guā",
    "瓜": "guā",
    "寡": "guǎ",
    "剐": "guǎ",
    "褂": "guà",
    "卦": "guà",
    "鸹": "guā",
    "冎": "guǎ",
    "栝": "guā,tiǎn",
    "诖": "guà",
    "劀": "guā",
    "剮": "guǎ",
    "叧": "guǎ",
    "咶": "huài,shì",
    "坬": "guà",
    "歄": "guā",
    "掛": "guà",
    "煱": "guā",
    "絓": "guà,kuā",
    "啩": "guà",
    "緺": "guā,wō",
    "咼": "wā,guǎ,guō",
    "罫": "guǎi,guà",
    "罣": "guà",
    "諣": "huà,guā",
    "舌": "shé",
    "詿": "guà",
    "趏": "guā,huó",
    "踻": "guā",
    "銽": "xiān,kuò,tiǎn,guā",
    "銛": "xiān,kuò,tiǎn,guā",
    "颪": "guā",
    "铦": "xiān,kuò,tiǎn,guā",
    "騧": "guā",
    "鴰": "guā",
    "颳": "guā",
    "括": "kuò,guā",
    "怪": "guài",
    "乖": "guāi",
    "拐": "guǎi",
    "哙": "kuài",
    "恠": "guài",
    "噲": "kuài",
    "叏": "guái",
    "夬": "guài",
    "枴": "guǎi",
    "柺": "guǎi",
    "掴": "guó",
    "管": "guǎn",
    "关": "guān",
    "官": "guān",
    "惯": "guàn",
    "观": "guān,guàn",
    "馆": "guǎn",
    "罐": "guàn",
    "灌": "guàn",
    "贯": "guàn",
    "冠": "guān,guàn",
    "棺": "guān",
    "纶": "lún,guān",
    "矜": "jīn,qín,guān",
    "莞": "guān,guǎn,wǎn",
    "掼": "guàn",
    "盥": "guàn",
    "涫": "guān",
    "鳏": "guān",
    "倌": "guān",
    "鹳": "guàn",
    "卝": "guàn,kuàng",
    "丱": "guàn,kuàng",
    "婠": "wān,wà",
    "悹": "guàn",
    "慣": "guàn",
    "懽": "huān",
    "摜": "guàn",
    "斡": "wò,guǎn",
    "悺": "guàn",
    "樌": "guàn",
    "果": "guǒ",
    "桄": "guāng,guàng",
    "權": "quán",
    "毌": "guàn,wān",
    "泴": "guàn",
    "淉": "guǒ,guàn",
    "沦": "lún",
    "潅": "guàn",
    "爟": "guàn",
    "琯": "guǎn",
    "淪": "lún",
    "痯": "guǎn",
    "瓘": "guàn",
    "瘝": "guān",
    "癏": "guān",
    "矔": "guàn,quán",
    "礶": "guàn",
    "祼": "guàn",
    "綸": "lún,guān",
    "罆": "guàn",
    "舘": "guǎn",
    "萖": "wǎn",
    "窤": "guān",
    "蒄": "guān",
    "菅": "jiān",
    "観": "guān,guàn",
    "覌": "guān,guàn",
    "筦": "guǎn",
    "觀": "guān,guàn",
    "躀": "guàn",
    "貫": "guàn",
    "輨": "guǎn",
    "錧": "guǎn",
    "鏆": "guàn",
    "遦": "guàn",
    "鑵": "guàn",
    "関": "guān",
    "闗": "guān",
    "雚": "guàn,huán",
    "關": "guān",
    "鱞": "guān",
    "鰥": "guān",
    "館": "guǎn",
    "鱹": "guàn",
    "鳤": "guǎn",
    "鵍": "huān",
    "光": "guāng",
    "逛": "guàng",
    "鸛": "guàn",
    "侊": "gōng",
    "犷": "guǎng",
    "俇": "guàng",
    "胱": "guāng",
    "僙": "guāng",
    "垙": "guāng",
    "姯": "guāng",
    "広": "guǎng",
    "恍": "huǎng",
    "廣": "guǎng",
    "扩": "kuò",
    "挄": "kuò,guāng",
    "撗": "héng,guàng",
    "擴": "kuò",
    "欟": "guàn",
    "横": "héng,hèng",
    "洸": "guāng",
    "灮": "guāng",
    "炗": "guāng",
    "炚": "guāng",
    "潢": "huáng,guāng",
    "烡": "guāng",
    "炛": "guāng",
    "珖": "guāng",
    "獷": "guǎng",
    "硄": "kuāng,guāng",
    "臦": "guàng,jiǒng",
    "臩": "guǎng,jiǒng",
    "茪": "guāng",
    "輄": "guāng",
    "趪": "huáng",
    "迋": "wàng,kuāng",
    "銧": "guāng",
    "黆": "guāng",
    "归": "guī",
    "贵": "guì",
    "鬼": "guǐ",
    "跪": "guì",
    "轨": "guǐ",
    "规": "guī",
    "桂": "guì",
    "龟": "guī,jūn,qiū",
    "硅": "guī",
    "柜": "guì,jǔ",
    "诡": "guǐ",
    "闺": "guī",
    "瑰": "guī",
    "圭": "guī",
    "傀": "kuǐ,guī",
    "癸": "guǐ",
    "刽": "guì",
    "炔": "quē",
    "庋": "guǐ",
    "宄": "guǐ",
    "桧": "guì,huì",
    "刿": "guì",
    "鳜": "guì,jué",
    "鲑": "guī,xié",
    "皈": "guī",
    "妫": "guī",
    "晷": "guǐ",
    "亀": "guī",
    "炅": "jiǒng,guì",
    "匦": "guǐ",
    "佹": "guǐ",
    "簋": "guǐ",
    "劊": "guì",
    "劌": "guì",
    "匭": "guǐ",
    "厬": "guǐ",
    "匱": "kuì,guì",
    "垝": "guǐ",
    "姽": "guǐ",
    "哇": "wā,wa",
    "嫢": "guī",
    "娃": "wá",
    "媯": "guī",
    "匮": "kuì,guì",
    "嶲": "guī,xī,juàn",
    "嬀": "guī",
    "嶡": "jué,guì",
    "巂": "guī,xī,juàn",
    "帰": "guī",
    "庪": "guǐ",
    "廆": "guī,wěi,huì",
    "恑": "guǐ",
    "摫": "guī",
    "撌": "guì",
    "攰": "guì",
    "昋": "guì",
    "朹": "qiú,guǐ",
    "椝": "guī",
    "椢": "guì",
    "桅": "wéi",
    "槣": "jī,guī",
    "攱": "guǐ,guì",
    "槶": "guì",
    "槼": "guī",
    "槻": "guī",
    "檜": "guì,huì",
    "櫰": "huái,guī",
    "櫷": "guī",
    "櫃": "guì",
    "氿": "guǐ,jiǔ",
    "歸": "guī",
    "沩": "wéi",
    "湀": "guǐ",
    "洼": "wā",
    "潙": "wéi",
    "溎": "yàn,guì",
    "珪": "guī",
    "璝": "guī",
    "瓌": "guī",
    "癐": "guì,wēi",
    "瞆": "guì,wèi,kuì",
    "瞡": "guī",
    "瞶": "guì,kuì",
    "硊": "wěi,guì",
    "祪": "guǐ",
    "祈": "qí",
    "禬": "guì",
    "筀": "guì",
    "窐": "wā,guī",
    "簂": "guó,guì",
    "絵": "huì",
    "繪": "huì",
    "绘": "huì",
    "茥": "guī",
    "蓕": "guì",
    "胿": "guī,kuì",
    "蘬": "guī",
    "蛫": "guǐ",
    "螝": "guì,huǐ",
    "蟡": "guǐ",
    "襘": "guì",
    "袿": "guī,guà",
    "規": "guī",
    "觤": "guǐ",
    "觖": "jué",
    "赽": "jué",
    "詭": "guǐ",
    "貴": "guì",
    "趹": "jué,guì",
    "邽": "guī",
    "蹶": "jué,juě",
    "郌": "guī",
    "軌": "guǐ",
    "陒": "guǐ",
    "閨": "guī",
    "雟": "guī,xī",
    "隗": "wěi,kuí",
    "騩": "guī",
    "鞼": "guì",
    "鬶": "guī",
    "鬹": "guī",
    "鮭": "guī,xié,wā,kuí",
    "鱥": "guì",
    "鴃": "jué",
    "鴂": "jué",
    "鱖": "guì",
    "龜": "guī,jūn,qiū",
    "鲧": "gǔn",
    "滚": "gǔn",
    "辊": "gǔn",
    "衮": "gǔn",
    "丨": "gǔn",
    "绲": "gǔn",
    "棞": "jùn",
    "磙": "gǔn",
    "浑": "hún",
    "惃": "gǔn",
    "混": "hùn,hún",
    "渾": "hún",
    "璭": "guǎn",
    "滾": "gǔn",
    "睔": "gùn",
    "睴": "hùn",
    "緷": "gǔn,yùn",
    "緄": "gǔn",
    "蓘": "gǔn",
    "裷": "yuān,gǔn",
    "謴": "gùn",
    "袞": "gǔn",
    "輥": "gǔn",
    "錕": "kūn",
    "蔉": "gǔn",
    "鮌": "gǔn",
    "锟": "kūn",
    "过": "guò,guo,guō",
    "鯀": "gǔn",
    "国": "guó",
    "裹": "guǒ",
    "锅": "guō",
    "郭": "guō",
    "涡": "wō,guō",
    "埚": "guō",
    "椁": "guǒ",
    "聒": "guō",
    "猓": "guō",
    "崞": "guō",
    "帼": "guó",
    "馘": "guó",
    "虢": "guó",
    "蜾": "guǒ",
    "呙": "wā,guǎ,guō",
    "蝈": "guō",
    "划": "huá,huà",
    "唬": "hǔ,xià",
    "啯": "guō",
    "嘓": "guō",
    "囯": "guó",
    "囶": "guó",
    "囗": "wéi,guó",
    "囻": "guó",
    "圀": "guó",
    "墎": "guō",
    "國": "guó",
    "堝": "guō",
    "彍": "guō",
    "彉": "guō",
    "幗": "guó",
    "惈": "guǒ",
    "慖": "guó",
    "摑": "guó",
    "楇": "guō,kuǎ",
    "槨": "guǒ",
    "渦": "wō,guō",
    "活": "huó",
    "漍": "guó",
    "濄": "guō,wō",
    "瘑": "guō",
    "矌": "kuàng,guō",
    "粿": "guǒ",
    "綶": "guǒ",
    "腂": "guò",
    "腘": "guó",
    "蔮": "guó",
    "聝": "guó",
    "蝸": "wō",
    "膕": "guó",
    "蜮": "yù",
    "菓": "guǒ",
    "蟈": "guō",
    "褁": "guǒ",
    "輠": "guǒ",
    "蠃": "luǒ",
    "鈛": "guō",
    "過": "guò",
    "鐹": "guò",
    "錁": "kè",
    "鍋": "guō",
    "餜": "guǒ",
    "锞": "kè",
    "馃": "guǒ",
    "哈": "hā,hǎ,hà",
    "虾": "xiā",
    "丷": "bā",
    "奤": "pò,hǎ,tǎi",
    "妎": "hài,jiè",
    "吓": "xià,hè",
    "為": "wéi,wèi",
    "蝦": "xiā",
    "海": "hǎi",
    "害": "hài",
    "氦": "hài",
    "獬": "xiè",
    "孩": "hái",
    "骇": "hài",
    "亥": "hài",
    "嗨": "hāi,hēi",
    "咍": "hāi",
    "醢": "hǎi",
    "嗐": "hài",
    "嚡": "xié,hái",
    "咴": "huī",
    "塰": "hǎi",
    "烸": "hǎi",
    "酼": "hǎi",
    "還": "huán,hái",
    "頦": "kē",
    "餀": "hài",
    "饚": "hài",
    "颏": "kē",
    "駴": "hài",
    "駭": "hài",
    "嘿": "hēi,mò",
    "乤": "xià",
    "含": "hán",
    "喊": "hǎn",
    "寒": "hán",
    "汉": "hàn",
    "旱": "hàn",
    "韩": "hán",
    "酣": "hān",
    "焊": "hàn",
    "涵": "hán",
    "函": "hán",
    "憨": "hān",
    "翰": "hàn",
    "罕": "hǎn",
    "撼": "hàn",
    "邗": "hán",
    "撖": "hàn",
    "悍": "hàn",
    "菡": "hàn",
    "瀚": "hàn",
    "阚": "kàn",
    "邯": "hán",
    "蚶": "hān",
    "焓": "hán",
    "傼": "hàn",
    "兯": "han",
    "凾": "hán",
    "颔": "hàn",
    "鼾": "hān",
    "哻": "hān",
    "唅": "hán,hàn",
    "嚂": "làn",
    "娢": "hán",
    "圅": "hán",
    "嫨": "hān,nǎn",
    "晗": "hán",
    "崡": "hán",
    "晥": "wǎn",
    "嵌": "qiàn,kàn",
    "暵": "hàn",
    "梒": "hán",
    "椷": "jiān,hán",
    "晘": "hàn",
    "欦": "qiān,xiān",
    "歛": "liǎn,hān",
    "浫": "hǎn",
    "涆": "hàn",
    "淊": "yān",
    "嵅": "hán",
    "滩": "tān",
    "漢": "hàn",
    "澏": "hán",
    "澣": "huàn",
    "熯": "hàn,rǎn",
    "猂": "hàn",
    "灘": "tān",
    "爳": "han",
    "甝": "hán",
    "皔": "hàn",
    "睅": "hàn",
    "筨": "hán",
    "琀": "hán",
    "糮": "xiàn",
    "肣": "qín,hán,hàn",
    "莟": "hàn",
    "蔊": "hàn",
    "蘫": "lán",
    "蛿": "hàn",
    "蜬": "hán",
    "蜭": "hàn",
    "螒": "hàn",
    "譀": "hàn",
    "谽": "hān",
    "軒": "xuān",
    "銲": "hàn",
    "轩": "xuān",
    "鈐": "qián",
    "鋎": "hàn",
    "鋡": "hán",
    "雗": "hàn",
    "靬": "jiān",
    "钤": "qián",
    "闞": "kàn,hǎn",
    "顄": "hàn",
    "頷": "hàn",
    "顩": "yǎn",
    "馠": "hān",
    "韓": "hán",
    "馯": "hàn,hán",
    "鬫": "kàn",
    "駻": "hàn",
    "鶾": "hàn",
    "行": "háng,xíng",
    "魽": "hān",
    "巷": "xiàng,hàng",
    "航": "háng",
    "吭": "háng,kēng",
    "杭": "háng",
    "绗": "háng",
    "沆": "hàng",
    "垳": "háng",
    "珩": "héng",
    "妔": "kēng,háng",
    "忼": "kāng,hàng",
    "斻": "háng",
    "桁": "héng,háng",
    "炕": "kàng",
    "笐": "háng,hàng",
    "狼": "láng",
    "筕": "háng",
    "絎": "háng",
    "蚢": "háng",
    "貥": "háng",
    "邟": "kàng,háng",
    "迒": "háng",
    "苀": "háng",
    "魧": "háng",
    "好": "hǎo,hào",
    "号": "hào,háo",
    "嚎": "háo",
    "郝": "hǎo",
    "豪": "háo",
    "毫": "háo",
    "耗": "hào",
    "壕": "háo",
    "貉": "hé,háo,mò",
    "昊": "hào",
    "颢": "hào",
    "嚆": "hāo",
    "灏": "hào",
    "嗥": "háo",
    "皓": "hào",
    "濠": "háo",
    "呺": "xiāo,háo",
    "傐": "hào",
    "儫": "háo",
    "嘷": "háo",
    "哠": "hào",
    "噑": "háo",
    "妞": "niū",
    "薅": "hāo",
    "恏": "hào",
    "昦": "hào",
    "悎": "hào,jiào",
    "暤": "hào",
    "晧": "hào",
    "暭": "hào",
    "曍": "hào",
    "椃": "háo",
    "淏": "hào",
    "滈": "hào,xuè",
    "獆": "háo",
    "灝": "hào",
    "皜": "hào",
    "皞": "hào",
    "皡": "hào",
    "皥": "hào",
    "秏": "hào,mào",
    "竓": "háo",
    "籇": "háo",
    "翯": "hè",
    "聕": "hào",
    "茠": "hāo",
    "薃": "hào",
    "薧": "hāo,kǎo",
    "藃": "xiāo,hào",
    "虠": "jiāo",
    "蠔": "háo",
    "諕": "xià,háo",
    "號": "hào",
    "膠": "jiāo",
    "鄗": "hào",
    "譹": "háo",
    "鎒": "nòu",
    "鐞": "nòu",
    "鰝": "hào",
    "顥": "hào",
    "和": "hé,hè,huó,huò,hú",
    "喝": "hē,hè,yè",
    "河": "hé",
    "荷": "hé",
    "贺": "hè",
    "何": "hé,hē,hè",
    "赫": "hè",
    "禾": "hé",
    "褐": "hè",
    "鹤": "hè",
    "涸": "hé",
    "嗬": "hē",
    "劾": "hé",
    "盍": "hé",
    "翮": "hé",
    "阖": "hé",
    "壑": "hè",
    "咊": "hé,hè",
    "哬": "hè",
    "诃": "hē",
    "呼": "hū",
    "啝": "hé",
    "嗃": "hè,xiāo,xiào,hù",
    "嗑": "kē,kè",
    "垎": "hè",
    "嚇": "hè,xià",
    "姀": "hé",
    "喛": "huàn,yuán,xuǎn,hé",
    "峆": "hé",
    "寉": "hè",
    "惒": "hé,hè",
    "愒": "qì,kài",
    "抲": "hē,hè,qiā",
    "敆": "hé",
    "柇": "hé",
    "揭": "jiē,qì",
    "楁": "hé",
    "欱": "hē",
    "渇": "kě",
    "洽": "qià",
    "渮": "hé",
    "湼": "niè",
    "澕": "hé",
    "焃": "hè",
    "渴": "kě",
    "煂": "hè",
    "熆": "hé",
    "熇": "hè,xiāo",
    "燺": "hè",
    "爀": "hè",
    "狢": "hé,mò",
    "癋": "hè",
    "皬": "hé",
    "盇": "hé",
    "盉": "hé",
    "碋": "hè",
    "篕": "hé",
    "籺": "hé",
    "粭": "hé",
    "繳": "jiǎo,zhuó",
    "缴": "jiǎo,zhuó",
    "苛": "kē,hē",
    "萂": "hé",
    "藿": "huò",
    "螛": "hé,xiá",
    "蚵": "kē",
    "蝎": "xiē",
    "蠚": "hē",
    "袔": "hè,kè",
    "覈": "hé",
    "訸": "hé",
    "訶": "hē",
    "謞": "hè",
    "貈": "hé,mò",
    "賀": "hè",
    "輅": "lù",
    "轄": "xiá",
    "辂": "lù",
    "郃": "hé",
    "辖": "xiá",
    "鉌": "hé",
    "闔": "hé",
    "阋": "xì",
    "隺": "hú,hè",
    "靍": "hè",
    "霍": "huò",
    "靎": "hè",
    "靏": "hè",
    "鞨": "hé",
    "鑉": "hé",
    "餄": "hé",
    "饸": "hé",
    "鶡": "hé,jiè",
    "鬩": "xì",
    "鸖": "hè",
    "鶴": "hè",
    "鹖": "hé",
    "麧": "hé",
    "鶮": "hè,hú",
    "齕": "hé",
    "龁": "hé",
    "龢": "hé",
    "嬒": "huì",
    "黒": "hēi",
    "潶": "hēi",
    "黑": "hēi",
    "狠": "hěn",
    "很": "hěn",
    "痕": "hén",
    "恨": "hèn",
    "佷": "hěn",
    "拫": "hén",
    "詪": "hěn",
    "噷": "xīn,hěn,hèn",
    "掀": "xiān",
    "鞎": "hén",
    "恒": "héng",
    "哼": "hēng",
    "衡": "héng",
    "亨": "hēng,pēng",
    "蘅": "héng",
    "堼": "fēng",
    "姮": "héng",
    "涥": "hēng",
    "烆": "héng",
    "狟": "huán,huān",
    "橫": "héng,hèng",
    "胻": "héng",
    "悙": "hēng,hèng",
    "脝": "hēng",
    "鑅": "héng",
    "訇": "hōng",
    "鵆": "héng",
    "鸻": "héng",
    "乊": "yī",
    "乥": "hù",  # Unknow.
    "鴴": "héng",
    "轰": "hōng",
    "哄": "hōng,hǒng,hòng",
    "洪": "hóng",
    "宏": "hóng",
    "烘": "hōng",
    "鸿": "hóng",
    "弘": "hóng",
    "闳": "hóng",
    "蕻": "hòng",
    "荭": "hóng",
    "薨": "hōng",
    "黉": "hóng",
    "仜": "hóng",
    "泓": "hóng",
    "叿": "hōng,hóng",
    "吰": "hóng",
    "吽": "hǒu,hōng,ōu",
    "嚝": "hōng",
    "讧": "hòng",
    "垬": "hóng",
    "娂": "hóng",
    "妅": "hóng",
    "宖": "hóng",
    "屸": "hóng,lóng",
    "彋": "hóng",
    "揈": "hōng",
    "撔": "hòng",
    "晎": "hǒng",
    "哅": "xiōng",
    "巆": "yíng,hōng",
    "汯": "hóng",
    "浤": "hóng",
    "汪": "wāng",
    "渹": "hōng,qìng",
    "潂": "hóng",
    "澋": "jǐng",
    "澒": "hòng,gǒng",
    "灴": "hōng",
    "焢": "hōng",
    "玒": "hóng",
    "玜": "hóng",
    "瓨": "xiáng,hóng",
    "硔": "hóng",
    "硡": "hōng",
    "竑": "hóng",
    "竤": "hóng",
    "篊": "hóng",
    "粠": "hóng",
    "紭": "hóng",
    "綋": "hóng",
    "紘": "hóng",
    "翃": "hóng",
    "翝": "hóng",
    "耾": "hóng",
    "纮": "hóng",
    "舼": "qióng",
    "苰": "hóng",
    "葒": "hóng",
    "葓": "hóng",
    "謍": "yíng",
    "谹": "hóng",
    "谾": "hōng",
    "軣": "hōng",
    "訌": "hòng",
    "鈜": "hóng",
    "輷": "hōng",
    "轟": "hōng",
    "鋐": "hóng",
    "鉷": "hóng",
    "谼": "hóng",
    "鍧": "hōng",
    "閧": "hòng,xiàng",
    "閎": "hóng",
    "闀": "hòng",
    "闂": "hòng,juǎn,xiàng",
    "霐": "hóng",
    "霟": "hóng",
    "鞃": "hóng",
    "鬨": "hòng",
    "鴻": "hóng",
    "黌": "hóng",
    "厚": "hòu",
    "后": "hòu",
    "吼": "hǒu",
    "喉": "hóu",
    "侯": "hóu,hòu",
    "候": "hòu",
    "猴": "hóu",
    "鲎": "hòu",
    "篌": "hóu",
    "後": "hòu",
    "逅": "hòu",
    "糇": "hóu",
    "垕": "hòu",
    "骺": "hóu",
    "瘊": "hóu",
    "帿": "hóu",
    "洉": "hòu",
    "犼": "hǒu",
    "矦": "hóu,hòu",
    "睺": "hóu",
    "翭": "hóu",
    "堠": "hòu",
    "翵": "hóu,qú",
    "葔": "hóu",
    "豞": "hòu",
    "郈": "hòu",
    "鄇": "hóu",
    "銗": "hóu,xiàng",
    "鍭": "hóu",
    "鮜": "hòu",
    "鯸": "hóu",
    "餱": "hóu",
    "鱟": "hòu",
    "齁": "hōu",
    "湖": "hú",
    "户": "hù",
    "虎": "hǔ",
    "鲘": "hòu",
    "互": "hù",
    "壶": "hú",
    "护": "hù",
    "胡": "hú",
    "糊": "hū,hú,hù",
    "弧": "hú",
    "忽": "hū",
    "狐": "hú",
    "葫": "hú",
    "蝴": "hú",
    "沪": "hù",
    "乎": "hū",
    "戏": "xì,hū",
    "瑚": "hú",
    "鹕": "hú",
    "冱": "hù",
    "怙": "hù",
    "鹱": "hù",
    "笏": "hù",
    "戽": "hù",
    "浒": "hǔ,xǔ",
    "扈": "hù",
    "祜": "hù",
    "醐": "hú",
    "琥": "hǔ",
    "囫": "hú",
    "烀": "hū",
    "轷": "hū",
    "斛": "hú",
    "猢": "hú",
    "惚": "hū",
    "滹": "hū",
    "岵": "hù",
    "煳": "hú",
    "唿": "hū",
    "觳": "hú",
    "槲": "hú",
    "乕": "hǔ",
    "冴": "yà",
    "匢": "hū",
    "喖": "hú",
    "匫": "hū",
    "嘑": "hū",
    "嘝": "hú",
    "嚛": "hù",
    "垀": "hū",
    "壷": "hú",
    "姱": "kuā,hù",
    "婟": "hù",
    "壺": "hú",
    "媩": "hú",
    "嫮": "hù",
    "嫭": "hù",
    "寣": "hū",
    "帍": "hù",
    "弖": "hù",
    "幠": "hū",
    "恗": "hū,kuā",
    "戯": "xì,hū",
    "戸": "hù",
    "戲": "xì,hū",
    "戶": "hù",
    "戱": "xì,hū",
    "搰": "hú",
    "昈": "hù",
    "昒": "hū",
    "曶": "hū,hù",
    "擭": "huò",
    "楛": "kǔ,hù",
    "枑": "hù,dǐ",
    "槴": "hù",
    "楜": "hú",
    "歑": "hū",
    "沍": "hù",
    "殻": "ké,qiào",
    "泘": "hū",
    "洿": "wū",
    "淴": "hū",
    "滬": "hù",
    "滸": "hǔ,xǔ",
    "濩": "huò,hù",
    "瀫": "hú",
    "焀": "hú",
    "熩": "hù",
    "瓡": "zhí,hú",
    "汻": "hǔ,huǎng",
    "瓳": "hú",
    "礐": "què,hú",
    "簄": "hù",
    "穫": "huò",
    "絗": "hú",
    "粐": "hù",
    "縏": "pán",
    "箶": "hú",
    "膴": "hū,wǔ",
    "舗": "pù",
    "芐": "hù,xià",
    "羽": "yǔ",
    "芔": "huì,hū",
    "苸": "hū",
    "芴": "wù,hū",
    "芦": "lú",
    "綔": "hù",
    "縠": "hú",
    "萀": "hǔ",
    "蔛": "hú",
    "蔰": "hù",
    "虝": "hǔ",
    "虍": "hū",
    "螜": "hú",
    "觷": "xué,hù",
    "謼": "hū",
    "衚": "hú",
    "許": "xū",
    "護": "hù",
    "许": "xǔ,hǔ",
    "虖": "hū",
    "錿": "hǔ",
    "軤": "hū",
    "鍙": "hù",
    "鍸": "hú",
    "雐": "hū",
    "鋘": "huá,wú,wū",
    "雽": "hū,hù",
    "鄠": "hù",
    "韄": "huò",
    "頶": "hú",
    "頀": "hù",
    "餬": "hú",
    "魱": "hú",
    "鯱": "hǔ",
    "鰗": "hú",
    "鬍": "hú",
    "鱯": "hù",
    "鳠": "hù",
    "鳸": "hù",
    "鴩": "dié",
    "鶦": "hú",
    "鸌": "hù",
    "鶘": "hú",
    "话": "huà",
    "花": "huā",
    "画": "huà",
    "化": "huà,huā",
    "哗": "huá,huā",
    "华": "huá,huà,huā",
    "猾": "huá",
    "豁": "huō,huò,huá",
    "铧": "huá",
    "桦": "huà",
    "骅": "huá",
    "砉": "xū,huā",
    "劃": "huá,huà",
    "婲": "huā",
    "埖": "huā",
    "嘩": "huá,huā",
    "姡": "huá,huó",
    "婳": "huà",
    "嫿": "huà",
    "劐": "huō",
    "嬅": "huà",
    "學": "xué",
    "学": "xué",
    "崋": "huà",
    "搳": "huá",
    "摦": "huà",
    "撶": "huá",
    "杹": "huà",
    "椛": "huā",
    "槬": "huà",
    "檴": "huò",
    "樺": "huà",
    "找": "zhǎo",
    "澅": "huà",
    "浍": "kuài,huì",
    "璍": "yè",
    "澮": "kuài,huì",
    "畫": "huà",
    "畵": "huà",
    "獪": "kuài",
    "硴": "huā",
    "稞": "kē",
    "糀": "huā",
    "繣": "huà",
    "舙": "huà",
    "芲": "lún,huā",
    "華": "huá,huà,huā",
    "蕐": "huá",
    "蘤": "huā",
    "蘳": "huī",
    "螖": "huá",
    "觟": "huà,xiè",
    "誮": "huā",
    "諙": "huà",
    "話": "huà",
    "譮": "huà",
    "釪": "huá,yú",
    "釫": "huá,wū",
    "錵": "huā",
    "譁": "huá",
    "鷨": "huá",
    "鏵": "huá",
    "驊": "huá",
    "黊": "huà",
    "淮": "huái",
    "坏": "huài,pēi,pī,péi",
    "佪": "huí,huái",
    "踝": "huái",
    "徊": "huái",
    "嘳": "kuì",
    "喟": "kuì",
    "懐": "huái",
    "坯": "pī",
    "壞": "huài",
    "槐": "huái",
    "壊": "huài",
    "瀤": "huái,wāi",
    "懷": "huái",
    "耲": "huái",
    "蘾": "huài",
    "蘹": "huái",
    "褱": "huái",
    "褢": "huái",
    "换": "huàn",
    "唤": "huàn",
    "环": "huán",
    "患": "huàn",
    "缓": "huǎn",
    "欢": "huān",
    "幻": "huàn",
    "宦": "huàn",
    "涣": "huàn",
    "焕": "huàn",
    "豢": "huàn",
    "桓": "huán",
    "痪": "huàn",
    "逭": "huàn",
    "漶": "huàn",
    "獾": "huān",
    "鲩": "huàn",
    "郇": "xún,huán",
    "鬟": "huán",
    "寰": "huán",
    "奂": "huàn",
    "擐": "huàn",
    "锾": "huán",
    "圜": "huán,yuán",
    "萑": "huán",
    "浣": "huàn",
    "喚": "huàn",
    "洹": "huán",
    "嚾": "huàn,huān",
    "缳": "huán",
    "圂": "hùn",
    "孉": "huān,quán",
    "奐": "huàn",
    "垸": "yuàn,huán",
    "堚": "huán",
    "寏": "huán",
    "嵈": "huàn",
    "巜": "kuài",
    "愌": "huàn",
    "懁": "xuān,huān",
    "攌": "huàn",
    "換": "huàn",
    "援": "yuán",
    "峘": "huán",
    "槵": "huàn",
    "欥": "yù,yì",
    "歓": "huān",
    "梙": "huàn",
    "歡": "huān",
    "汍": "wán",
    "烉": "huàn",
    "渙": "huàn",
    "煥": "huàn",
    "澴": "huán",
    "瑍": "huàn",
    "瓛": "huán,yè,yà",
    "瑗": "yuàn",
    "環": "huán",
    "皖": "wǎn",
    "瘓": "huàn",
    "眩": "xuàn",
    "睆": "huǎn",
    "瞏": "qióng,huán",
    "瞣": "wàn",
    "糫": "huán",
    "綄": "huán,huàn,wàn",
    "緩": "huǎn",
    "羦": "huán",
    "繯": "huán",
    "肒": "huàn",
    "萈": "huán",
    "藧": "huàn",
    "脘": "wǎn",
    "荁": "huán",
    "讙": "huān",
    "蒝": "yuán,huán",
    "豲": "huán",
    "蠸": "quán",
    "貆": "huán,huān",
    "貛": "huān",
    "轘": "huàn",
    "酄": "huān",
    "鉮": "shén",
    "鍰": "huán",
    "輐": "wàn",
    "鐶": "huán",
    "镮": "huán",
    "阛": "huán",
    "闤": "huán",
    "雈": "huán",
    "驩": "huān",
    "鯶": "huàn",
    "鰀": "huàn",
    "鴅": "huān",
    "鹮": "huán",
    "黄": "huáng",
    "鯇": "huàn",
    "慌": "huāng",
    "晃": "huǎng,huàng",
    "荒": "huāng",
    "簧": "huáng",
    "凰": "huáng",
    "惶": "huáng",
    "皇": "huáng",
    "谎": "huǎng",
    "蝗": "huáng",
    "磺": "huáng",
    "煌": "huáng",
    "幌": "huǎng",
    "隍": "huáng",
    "肓": "huāng",
    "鳇": "huáng",
    "篁": "huáng",
    "徨": "huáng",
    "遑": "huáng",
    "癀": "huáng",
    "湟": "huáng",
    "璜": "huáng",
    "偟": "huáng",
    "蟥": "huáng",
    "喤": "huáng",
    "堭": "huáng",
    "塃": "huāng",
    "奛": "huǎng",
    "媓": "huáng",
    "崲": "huáng",
    "巟": "huāng",
    "墴": "huáng",
    "怳": "huǎng",
    "愰": "huàng",
    "揘": "huáng,yóng",
    "兤": "huǎng",
    "宺": "huāng,huǎng",
    "晄": "huǎng",
    "朚": "huāng,máng,wáng",
    "楻": "huáng",
    "曂": "huàng",
    "炾": "huǎng",
    "滉": "huàng",
    "熀": "huǎng",
    "熿": "huáng,huǎng",
    "榥": "huàng",
    "獚": "huáng",
    "爌": "kuàng,huǎng",
    "瑝": "huáng",
    "皝": "huàng",
    "皩": "huàng",
    "穔": "huáng",
    "縨": "huǎng",
    "艎": "huáng",
    "葟": "huáng",
    "茫": "máng",
    "芒": "máng",
    "衁": "huāng",
    "詤": "huǎng",
    "諻": "huáng",
    "鍠": "huáng",
    "鎤": "huàng",
    "鐄": "huáng",
    "謊": "huǎng",
    "锽": "huáng",
    "餭": "huáng",
    "韹": "huáng",
    "騜": "huáng",
    "鱑": "huáng",
    "鰉": "huáng",
    "鷬": "huáng",
    "黃": "huáng",
    "灰": "huī",
    "会": "huì,kuài",
    "回": "huí",
    "挥": "huī",
    "汇": "huì",
    "惠": "huì",
    "辉": "huī",
    "晦": "huì",
    "恢": "huī",
    "毁": "huǐ",
    "慧": "huì",
    "秽": "huì",
    "徽": "huī",
    "贿": "huì",
    "蛔": "huí",
    "讳": "huì",
    "卉": "huì",
    "悔": "huǐ",
    "诲": "huì",
    "烩": "huì",
    "彗": "huì",
    "珲": "hún,huī",
    "蕙": "huì",
    "喙": "huì",
    "恚": "huì",
    "隳": "huī,duò",
    "麾": "huī",
    "晖": "huī",
    "哕": "yuě,huì",
    "诙": "huī",
    "蟪": "huì",
    "茴": "huí",
    "洄": "huí",
    "虺": "huǐ",
    "荟": "huì",
    "僡": "huì",
    "缋": "huì,huí",
    "儶": "huì,xié",
    "叀": "zhuān",
    "嘒": "huì",
    "匯": "huì",
    "噅": "huī",
    "噕": "huī",
    "囘": "huí",
    "嚖": "huì",
    "噦": "yuě,huì",
    "圚": "huì",
    "媈": "huī",
    "囬": "huí",
    "孈": "xié,huī",
    "寭": "huì",
    "屷": "huì",
    "幑": "huī",
    "婎": "huī",
    "廽": "huí",
    "廻": "huí",
    "彚": "huì",
    "彙": "huì",
    "恵": "huì",
    "恛": "huí",
    "憓": "huì",
    "懳": "huì",
    "拻": "huī",
    "徻": "huì",
    "撝": "huī,wéi",
    "揮": "huī",
    "暳": "huì",
    "椲": "wěi,huī",
    "楎": "huī",
    "暉": "huī",
    "槥": "huì",
    "橞": "huì",
    "會": "huì,kuài",
    "檅": "huì",
    "檓": "huǐ",
    "櫘": "huì",
    "毇": "huǐ",
    "沬": "mèi",
    "洃": "huī",
    "毀": "huǐ",
    "泋": "huì",
    "湏": "huì,mǐn,xū",
    "滙": "huì",
    "潓": "huì",
    "濊": "huì,huò",
    "瀈": "huī",
    "灳": "huī",
    "烜": "xuǎn",
    "烣": "huī",
    "煇": "huī,yùn,xūn",
    "燬": "huǐ",
    "獩": "huì",
    "煒": "wěi",
    "燴": "huì",
    "璤": "huì",
    "璯": "huì,kuài",
    "痐": "huí",
    "琿": "hún,huī",
    "瘣": "huì,lěi",
    "眭": "guì,suī",
    "睳": "huī",
    "瞺": "huì",
    "睢": "huī,suī",
    "禈": "huī",
    "篲": "huì",
    "穢": "huì",
    "翙": "huì",
    "繢": "huì,huí",
    "翬": "huī",
    "翽": "huì",
    "翚": "huī",
    "蔧": "huì",
    "蒐": "sōu",
    "薉": "huì",
    "薈": "huì",
    "藱": "huì,huí",
    "蚘": "huí",
    "蜖": "huí",
    "蛕": "huí",
    "褘": "huī",
    "袆": "huī",
    "詯": "huì",
    "誨": "huì",
    "詼": "huī",
    "諱": "huì",
    "譓": "huì",
    "譭": "huǐ",
    "譿": "huì",
    "豗": "huī",
    "賄": "huì",
    "輝": "huī",
    "逥": "huí",
    "违": "wéi",
    "迴": "huí",
    "銊": "xù,huì",
    "鏸": "huì,suì,ruì",
    "鐬": "huì",
    "闠": "huì",
    "阓": "huì",
    "靧": "huì",
    "違": "wéi",
    "韢": "suì",
    "韋": "wéi",
    "頮": "huì",
    "韦": "wéi",
    "顪": "huì",
    "鮰": "huí",
    "鰴": "huī",
    "鼿": "wù",
    "齀": "wù",
    "溃": "kuì,huì",
    "昏": "hūn",
    "荤": "hūn",
    "婚": "hūn",
    "餯": "huì",
    "魂": "hún",
    "阍": "hūn",
    "倱": "hùn",
    "溷": "hùn",
    "俒": "hùn",
    "婫": "hùn,kūn",
    "忶": "hún",
    "惛": "hūn,mèn",
    "惽": "mǐn",
    "慁": "hùn",
    "馄": "hún",
    "掍": "hùn",
    "诨": "hùn",
    "捆": "kǔn",
    "昬": "hūn",
    "梡": "kuǎn",
    "梱": "kǔn",
    "棔": "hūn",
    "昆": "kūn",
    "殙": "hūn,mèi",
    "湣": "mǐn,hūn",
    "湷": "zhuāng,hún",
    "焝": "hùn",
    "眃": "yún,hùn",
    "睧": "hūn",
    "焄": "xūn,hūn",
    "緍": "mín",
    "睯": "hūn",
    "涽": "hūn",
    "緡": "mín",
    "繉": "shéng",
    "缗": "mín",
    "蔒": "hūn",
    "葷": "hūn",
    "諢": "hùn",
    "轋": "hūn",
    "觨": "hùn",
    "顐": "wèn",
    "閽": "hūn",
    "餫": "yùn",
    "餛": "hún",
    "鼲": "hún",
    "或": "huò",
    "火": "huǒ",
    "伙": "huǒ",
    "货": "huò",
    "祸": "huò",
    "惑": "huò",
    "获": "huò",
    "嚯": "huò",
    "镬": "huò",
    "攉": "huō",
    "锪": "huò",
    "耠": "huō",
    "蠖": "huò",
    "夥": "huǒ",
    "钬": "huǒ",
    "佸": "huó",
    "俰": "huò",
    "剨": "huò",
    "咟": "huò",
    "嚿": "huò",
    "奯": "huò",
    "掝": "huò,xù",
    "搉": "què",
    "旤": "huò",
    "曤": "huò",
    "嚄": "huò,ǒ",
    "沎": "huò",
    "湱": "huò",
    "漷": "huǒ,huò,kuò",
    "瀖": "huò",
    "吙": "huō",
    "癨": "huò",
    "獲": "huò",
    "眓": "huò",
    "矆": "huò,yuè",
    "矐": "huò",
    "礊": "kè,huò",
    "秮": "huó,kuò",
    "秳": "huó,kuò",
    "篧": "zhuó,huò",
    "禍": "huò",
    "耯": "huò",
    "臛": "huò",
    "萿": "kuò",
    "艧": "huò",
    "蒦": "huò",
    "謋": "huò",
    "邩": "huǒ",
    "越": "yuè",
    "貨": "huò",
    "鈥": "huǒ",
    "閄": "huò,shǎn",
    "鍃": "huò",
    "鑊": "huò",
    "雘": "huò",
    "隻": "zhī",
    "靃": "huò",
    "騞": "huō",
    "魊": "yù",
    "夻": "huà",
    "乁": "yí,jí",
    "几": "jī,jǐ",
    "及": "jí",
    "急": "jí",
    "既": "jì",
    "即": "jí",
    "机": "jī",
    "鸡": "jī",
    "记": "jì",
    "极": "jí",
    "积": "jī",
    "计": "jì",
    "挤": "jǐ",
    "己": "jǐ",
    "级": "jí",
    "季": "jì",
    "寄": "jì",
    "系": "xì,jì",
    "激": "jī",
    "纪": "jì,jǐ",
    "基": "jī",
    "吉": "jí",
    "脊": "jǐ",
    "际": "jì",
    "汲": "jí",
    "肌": "jī",
    "嫉": "jí",
    "姬": "jī",
    "绩": "jì",
    "缉": "jī,qī",
    "饥": "jī",
    "迹": "jì",
    "棘": "jí",
    "蓟": "jì",
    "技": "jì",
    "冀": "jì",
    "辑": "jí",
    "伎": "jì,qí",
    "祭": "jì,zhài",
    "剂": "jì",
    "悸": "jì",
    "籍": "jí",
    "寂": "jì",
    "期": "qī,jī",
    "其": "qí,jī",
    "忌": "jì",
    "济": "jì,jǐ",
    "齐": "qí,jì,zī,zhāi",
    "妓": "jì",
    "集": "jí",
    "击": "jī",
    "圾": "jī",
    "箕": "jī",
    "稽": "jī,qǐ",
    "继": "jì",
    "讥": "jī",
    "畸": "jī",
    "疾": "jí",
    "洎": "jì",
    "墼": "jī",
    "鲚": "jì",
    "齑": "jī",
    "屐": "jī",
    "戟": "jǐ",
    "鲫": "jì",
    "嵇": "jī",
    "矶": "jī",
    "稷": "jì",
    "虮": "jǐ",
    "戢": "jí",
    "诘": "jié,jí",
    "笈": "jí",
    "暨": "jì",
    "笄": "jī",
    "剞": "jī",
    "叽": "jī",
    "蒺": "jí",
    "跻": "jī",
    "嵴": "jǐ",
    "掎": "jǐ",
    "跽": "jì",
    "霁": "jì",
    "唧": "jī",
    "畿": "jī",
    "玑": "jī",
    "瘠": "jí",
    "丌": "qí,jī",
    "羁": "jī",
    "偈": "jì,jié",
    "佶": "jí",
    "赍": "jī",
    "楫": "jí",
    "芨": "jī",
    "髻": "jì",
    "咭": "jī,xī,qià",
    "蕺": "jí",
    "麂": "jǐ",
    "骥": "jì",
    "觊": "jì",
    "殛": "jí",
    "岌": "jí",
    "亟": "jí,qì",
    "犄": "jī",
    "乩": "jī",
    "芰": "jì",
    "哜": "jì,jiē,zhāi",
    "丮": "jǐ",
    "亼": "jí",
    "倚": "yǐ",
    "兾": "jì",
    "刉": "jī",
    "刏": "jī",
    "剤": "jì",
    "勣": "jì",
    "偮": "jí",
    "卽": "jí",
    "劑": "jì",
    "叝": "jí",
    "吇": "zǐ",
    "僟": "jī",
    "喞": "jī",
    "坖": "jì",
    "嘰": "jī",
    "垍": "jì",
    "嚌": "jì,jiē,zhāi",
    "塉": "jí",
    "嗘": "jī",
    "妀": "jǐ",
    "姞": "jí",
    "墍": "xì",
    "姼": "shí",
    "峜": "fǎ",
    "居": "jū",
    "屰": "nì,jǐ",
    "尐": "jié,jí",
    "嶯": "jí",
    "嵆": "jī",
    "帺": "qí,jì",
    "廭": "jì",
    "彑": "jì",
    "彐": "jì,xuě",
    "徛": "jì",
    "彶": "jí",
    "忣": "jí",
    "惎": "jì",
    "愱": "jí",
    "憿": "jiǎo,jǐ",
    "懠": "qí,jī,jì",
    "懻": "jì",
    "幾": "jī,jǐ",
    "揖": "yī",
    "揤": "jí",
    "撃": "jī",
    "撽": "qiào,yāo,jī",
    "撠": "jǐ",
    "擊": "jī",
    "敧": "qī,yǐ,jī",
    "旣": "jì",
    "擠": "jǐ",
    "暩": "jì",
    "旡": "jì",
    "曁": "jì",
    "梞": "jì",
    "攲": "qī,yǐ,jī",
    "枅": "jī",
    "棋": "qí",
    "楖": "jí,zhì",
    "槉": "jí",
    "極": "jí",
    "檝": "jí",
    "機": "jī",
    "檵": "jì",
    "櫅": "jī,jì",
    "毄": "jī",
    "檕": "jì",
    "橶": "jǐ",
    "樭": "jī",
    "泲": "jǐ",
    "汥": "zhī,jì",
    "淁": "qiè,jí",
    "櫭": "jué,jì",
    "済": "jì,jǐ",
    "湒": "jí",
    "洁": "jié",
    "漃": "jì",
    "漈": "jì",
    "潗": "jí",
    "濈": "jí,shà",
    "犱": "jǐ",
    "焏": "jí,qì",
    "濟": "jì,jǐ",
    "狤": "jié",
    "瀱": "jì",
    "璂": "qí",
    "猗": "yī,yǐ",
    "璣": "jī",
    "璾": "jì,zī",
    "痵": "jì",
    "癪": "jī",
    "癠": "jì",
    "瘵": "zhài",
    "皍": "jí",
    "睽": "kuí",
    "瞿": "qú,jù",
    "禝": "jì",
    "磯": "jī",
    "瞉": "kòu,jì",
    "禨": "jī,jì",
    "稘": "jī,qí",
    "秸": "jiē",
    "穄": "jì",
    "穊": "jì",
    "稩": "jì",
    "穖": "jǐ,jì",
    "積": "jī",
    "筓": "jī",
    "穧": "jì",
    "箿": "jí",
    "簊": "jī",
    "糭": "zòng",
    "紒": "jì,jié,jiè",
    "紀": "jì",
    "級": "jí",
    "結": "jié,jiē",
    "継": "jì",
    "給": "gěi,jǐ",
    "縘": "xì",
    "緝": "jī,qī",
    "繫": "xì,jì",
    "繋": "jì",
    "繼": "jì",
    "结": "jié,jiē",
    "績": "jì",
    "羇": "jī",
    "罽": "jì",
    "羈": "jī",
    "耭": "jī",
    "耤": "jí,jiè",
    "膌": "jí",
    "臮": "jì",
    "脔": "luán",
    "艥": "jí",
    "艻": "lè",
    "芶": "gōu,gǒu",
    "苙": "lì,jī",
    "茍": "jì",
    "莋": "zuó",
    "葪": "jì",
    "蒩": "zū,jù",
    "萁": "qí",
    "蔇": "jì",
    "蕀": "jí",
    "蕲": "qí",
    "薊": "jì",
    "蘮": "jì",
    "蘎": "jì",
    "藉": "jiè,jí",
    "蘄": "qí",
    "蘻": "jì",
    "虀": "jī",
    "蝍": "jí",
    "螏": "jí",
    "蜡": "là",
    "蟿": "qì",
    "蟣": "jǐ",
    "裚": "jì",
    "襀": "jì",
    "襋": "jí",
    "覉": "jī",
    "蟻": "yǐ",
    "覊": "jī",
    "觙": "jí",
    "覬": "jì",
    "褀": "qí",
    "觭": "jī,qí",
    "誋": "jì",
    "計": "jì",
    "訐": "jié",
    "記": "jì",
    "諅": "jì,jī",
    "譤": "jī",
    "譏": "jī",
    "谻": "jí",
    "谿": "xī",
    "賫": "jī",
    "讦": "jié",
    "賷": "jī",
    "趌": "jí,jié",
    "趞": "què,qì,jí",
    "跂": "qí,qǐ",
    "跡": "jì",
    "踦": "qī",
    "蹐": "jí",
    "蹟": "jì",
    "躤": "jí",
    "躸": "jī",
    "踖": "jí",
    "轚": "jí",
    "踑": "jī",
    "輯": "jí",
    "郆": "jí",
    "鄿": "qí",
    "郅": "zhì",
    "銈": "jī",
    "躋": "jī",
    "銡": "jí",
    "錤": "jī",
    "鍓": "jí",
    "鏶": "jí",
    "鑇": "jī",
    "鑙": "jī",
    "鐖": "jī",
    "隮": "jī",
    "雦": "chóu",
    "雧": "jí",
    "際": "jì",
    "霵": "jí",
    "雞": "jī",
    "鞊": "jié,jí",
    "霽": "jì",
    "鞿": "jī",
    "韲": "jī",
    "飢": "jī",
    "饑": "jī",
    "騎": "qí",
    "鬾": "jì",
    "骑": "qí",
    "魝": "jì",
    "驥": "jì",
    "魢": "jǐ",
    "鯚": "jì",
    "鰶": "jì",
    "鰿": "jì",
    "鯯": "zhì",
    "鱀": "jì",
    "鱾": "jǐ",
    "鯽": "jì",
    "鳮": "jī",
    "鱭": "jì",
    "鵋": "jì",
    "鶏": "jī",
    "鷑": "jì",
    "鸄": "jī",
    "鷄": "jī",
    "鹡": "jī",
    "齊": "qí,zhāi",
    "齌": "jì",
    "齍": "zī",
    "鶺": "jī",
    "齏": "jī",
    "齎": "jí",
    "家": "jiā,jia,jie",
    "加": "jiā",
    "假": "jiǎ,jià",
    "价": "jià,jiè,jie",
    "佳": "jiā",
    "甲": "jiǎ",
    "架": "jià",
    "嘉": "jiā",
    "驾": "jià",
    "荚": "jiá",
    "嫁": "jià",
    "稼": "jià",
    "颊": "jiá",
    "铗": "jiá",
    "茄": "qié",
    "葭": "jiā",
    "迦": "jiā",
    "戛": "jiá",
    "浃": "jiā",
    "镓": "jiā",
    "恝": "jiá",
    "岬": "jiǎ",
    "跏": "jiā",
    "胛": "jiǎ",
    "笳": "jiā",
    "痂": "jiā",
    "枷": "jiā",
    "珈": "jiā",
    "瘕": "jiǎ,xiá,xiā",
    "袈": "jiā",
    "傢": "jiā",
    "郏": "jiá",
    "蛱": "jiá",
    "價": "jià,jie",
    "唊": "jiá,qiǎn",
    "圿": "jiá",
    "叚": "jiǎ",
    "埉": "xiá,jiā",
    "夓": "xià",
    "婽": "jiǎ",
    "夏": "xià",
    "宊": "tū,jiā",
    "徦": "jiǎ,xiá",
    "夾": "jiā,jiá,gā,xiá",
    "忦": "jiá",
    "戞": "jiá",
    "幏": "jià",
    "扴": "jiá",
    "抸": "jiā",
    "拁": "jiā,yá",
    "押": "yā",
    "拮": "jié,jiá",
    "挈": "qiè",
    "挟": "xié,jiā",
    "挾": "xié,jiā",
    "揩": "kāi",
    "揳": "xiē",
    "擖": "qiā,jiā,yè",
    "斚": "jiǎ",
    "斝": "jiǎ",
    "梜": "jiā",
    "暇": "xiá",
    "椵": "jiǎ,jiā",
    "榎": "jiǎ",
    "榢": "jià",
    "槚": "jiǎ",
    "檟": "jiǎ",
    "毠": "jiā",
    "泇": "jiā",
    "犌": "jiā",
    "猳": "jiā",
    "玾": "jiǎ",
    "耞": "jiā",
    "糘": "jiā",
    "脥": "jiá",
    "腵": "jiā",
    "浹": "jiā",
    "莢": "jiá",
    "裌": "jiá",
    "豭": "jiā",
    "貑": "jiā",
    "袷": "jiá,jié,qiā",
    "蛺": "jiá",
    "跲": "jié",
    "郟": "jiá",
    "鉫": "jiā",
    "鋏": "jiá",
    "頬": "jiá",
    "鎵": "jiā",
    "頡": "jié",
    "頰": "jiá",
    "颉": "jié,xié,jiá",
    "駕": "jià",
    "駱": "luò",
    "骆": "luò",
    "骱": "jiè",
    "鴶": "jiá",
    "鵊": "jiá",
    "麚": "jiā",
    "见": "jiàn,xiàn",
    "件": "jiàn",
    "减": "jiǎn",
    "间": "jiān,jiàn",
    "尖": "jiān",
    "键": "jiàn",
    "贱": "jiàn",
    "检": "jiǎn",
    "兼": "jiān",
    "肩": "jiān",
    "箭": "jiàn",
    "煎": "jiān",
    "建": "jiàn",
    "剪": "jiǎn",
    "歼": "jiān",
    "监": "jiān,jiàn",
    "坚": "jiān",
    "简": "jiǎn",
    "健": "jiàn",
    "艰": "jiān",
    "荐": "jiàn",
    "剑": "jiàn",
    "溅": "jiàn,jiān",
    "涧": "jiàn",
    "浅": "qiǎn,jiān",
    "鉴": "jiàn",
    "捡": "jiǎn",
    "践": "jiàn",
    "俭": "jiǎn",
    "硷": "jiǎn",
    "柬": "jiǎn",
    "笺": "jiān",
    "拣": "jiǎn",
    "碱": "jiǎn",
    "舰": "jiàn",
    "槛": "jiàn,kǎn",
    "缄": "jiān",
    "饯": "jiàn",
    "翦": "jiǎn",
    "鞯": "jiān",
    "戋": "jiān",
    "牮": "jiàn",
    "谏": "jiàn",
    "枧": "jiǎn",
    "趼": "jiǎn",
    "腱": "jiàn",
    "搛": "jiān",
    "缣": "jiān",
    "戬": "jiǎn",
    "鲣": "jiān",
    "毽": "jiàn",
    "谫": "jiǎn",
    "楗": "jiàn",
    "笕": "jiǎn",
    "囝": "jiǎn,nān",
    "蹇": "jiǎn",
    "謇": "jiǎn",
    "裥": "jiǎn",
    "蒹": "jiān",
    "踺": "jiàn",
    "睑": "jiǎn",
    "鹣": "jiān",
    "俴": "jiàn",
    "僭": "jiàn",
    "锏": "jiǎn",
    "偂": "qián",
    "湔": "jiān",
    "倹": "jiǎn",
    "傔": "qiàn,jiān",
    "僣": "tiě,jiàn",
    "冿": "jiān",
    "儉": "jiǎn",
    "剣": "jiàn",
    "剱": "jiàn",
    "前": "qián",
    "劎": "jiàn",
    "劒": "jiàn",
    "劔": "jiàn",
    "劍": "jiàn",
    "囏": "jiān",
    "堿": "jiǎn",
    "堅": "jiān",
    "堑": "qiàn,zàn,jiàn",
    "墹": "jiàn",
    "塹": "qiàn,zàn,jiàn",
    "姧": "jiān",
    "姦": "jiān",
    "寋": "jiàn",
    "帴": "jiǎn,jiān,sàn",
    "幵": "jiān",
    "彅": "jiǎn",
    "徤": "jiàn",
    "惤": "jiān",
    "弿": "jiǎn",
    "戩": "jiǎn",
    "挸": "jiǎn",
    "揵": "qián,jiàn,jiǎn",
    "揀": "jiǎn",
    "擶": "jiàn",
    "撿": "jiǎn",
    "攕": "xiān,jiān",
    "旔": "jiàn",
    "揃": "jiǎn,jiān",
    "暕": "jiǎn,lán",
    "栫": "jiàn,zùn",
    "柙": "xiá",
    "梘": "jiǎn",
    "椾": "jiān",
    "榗": "jiàn,jìn",
    "樫": "jiān",
    "橌": "xiàn",
    "橏": "zhǎn,jiǎn",
    "橺": "xiàn",
    "検": "jiǎn",
    "檢": "jiǎn",
    "櫼": "jiān",
    "檻": "jiàn,kǎn",
    "殱": "jiān",
    "殲": "jiān",
    "減": "jiǎn",
    "湕": "jiǎn",
    "涀": "xiàn",
    "滥": "làn",
    "澗": "jiàn",
    "瀳": "jiàn,zùn",
    "瀐": "jiān",
    "濫": "làn",
    "瀸": "jiān",
    "瀽": "jiǎn",
    "濺": "jiàn,jiān",
    "熞": "jiān",
    "熸": "jiān",
    "牋": "jiān",
    "玪": "jiān,qián",
    "猏": "jiān,yàn",
    "犍": "jiān,qián",
    "睷": "jiān",
    "瑊": "jiān",
    "珔": "jiàn",
    "瞯": "xián,jiàn",
    "瞷": "jiàn",
    "瑐": "jiǎn",
    "瞼": "jiǎn",
    "碊": "jiān,zhàn",
    "礀": "jiàn",
    "監": "jiān,jiàn",
    "磵": "jiàn",
    "礛": "jiān",
    "稴": "xián,jiān,liàn",
    "礆": "jiǎn",
    "箴": "zhēn",
    "筧": "jiǎn",
    "篯": "jiǎn,jiān",
    "箋": "jiān",
    "籈": "zhēn,jiān",
    "籛": "jiǎn,jiān",
    "簡": "jiǎn",
    "絸": "jiǎn",
    "繝": "jiàn",
    "縑": "jiān",
    "糋": "jiàn",
    "纎": "xiān",
    "繭": "jiǎn",
    "纖": "xiān",
    "緘": "jiān",
    "聻": "nǐ,jiàn",
    "纤": "xiān,qiàn",
    "臶": "jiàn",
    "菺": "jiān",
    "艦": "jiàn",
    "葌": "jiān",
    "艱": "jiān",
    "葏": "jīng",
    "葥": "qián",
    "蔪": "jiān",
    "蕑": "jiān",
    "蕳": "jiān",
    "虃": "jiān",
    "藆": "jiǎn",
    "薦": "jiàn",
    "袸": "jiàn,zùn",
    "蠒": "jiǎn",
    "襉": "jiǎn",
    "襺": "jiǎn",
    "襇": "jiǎn",
    "覸": "jiàn",
    "見": "jiàn,xiàn",
    "諓": "jiàn",
    "詃": "jiǎn",
    "諫": "jiàn",
    "譼": "jiān",
    "譖": "zèn",
    "譾": "jiǎn",
    "谮": "zèn",
    "豣": "jiān,yàn",
    "豜": "jiān",
    "賎": "jiàn",
    "趝": "jiàn",
    "謭": "jiǎn",
    "轞": "jiàn",
    "賤": "jiàn",
    "醎": "xián",
    "踐": "jiàn",
    "醶": "yàn,liǎn,xiān",
    "釰": "rì,rèn,jiàn",
    "釼": "rì,rèn,jiàn",
    "銒": "xíng",
    "銭": "qián",
    "鋄": "wàn,jiǎn",
    "鋻": "jiān,jiàn",
    "錬": "liàn",
    "鈃": "xíng",
    "錢": "qián",
    "錽": "wàn",
    "鍳": "jiàn",
    "鎫": "wàn,jiǎn",
    "鏩": "jiàn,zàn",
    "鍵": "jiàn",
    "鐗": "jiǎn",
    "鐧": "jiǎn",
    "鐱": "jiàn",
    "鍊": "liàn",
    "鑑": "jiàn",
    "鑬": "jiàn",
    "鑒": "jiàn",
    "鑯": "jiān",
    "鑳": "jiàn",
    "钘": "xíng",
    "钱": "qián",
    "閒": "xián,jiān,jiàn",
    "間": "jiān,jiàn",
    "鞬": "jiàn,jiān",
    "险": "xiǎn",
    "韀": "jiān",
    "險": "xiǎn",
    "韉": "jiān",
    "餞": "jiàn",
    "餰": "jiān",
    "馢": "jiān",
    "鬋": "jiǎn",
    "騫": "qiān",
    "骞": "qiān",
    "鰜": "jiān",
    "鰎": "jiǎn",
    "鳒": "jiān",
    "鰹": "jiān",
    "鳽": "jiān,qiān,zhān",
    "鵳": "jiān",
    "鶼": "jiān",
    "鹸": "jiǎn",
    "鹻": "jiǎn",
    "鹹": "xián",
    "麉": "jiān",
    "黚": "qián",
    "黬": "yǎn",
    "鹼": "jiǎn",
    "廴": "yǐn,yìn",
    "将": "jiāng,jiàng",
    "讲": "jiǎng",
    "江": "jiāng",
    "降": "jiàng,xiáng",
    "浆": "jiāng,jiàng",
    "僵": "jiāng",
    "奖": "jiǎng",
    "姜": "jiāng",
    "酱": "jiàng",
    "匠": "jiàng",
    "蒋": "jiǎng",
    "疆": "jiāng,qiáng",
    "桨": "jiǎng",
    "强": "qiáng,qiǎng,jiàng",
    "礓": "jiāng",
    "豇": "jiāng",
    "缰": "jiāng",
    "犟": "jiàng",
    "耩": "jiǎng",
    "绛": "jiàng",
    "糨": "jiàng",
    "茳": "jiāng",
    "洚": "jiàng",
    "勥": "jiàng",
    "匞": "jiàng",
    "塂": "jiǎng",
    "壃": "jiāng",
    "夅": "jiàng,xiáng",
    "奨": "jiǎng",
    "奬": "jiǎng",
    "嵹": "jiàng",
    "弜": "jiàng",
    "將": "jiāng,jiàng",
    "弶": "jiàng",
    "強": "qiáng,qiǎng,jiàng",
    "摪": "jiāng,qiàng",
    "彊": "qiáng,qiǎng,jiàng",
    "摾": "jiàng",
    "杢": "jié",
    "櫤": "jiàng",
    "橿": "jiāng",
    "槳": "jiǎng",
    "殭": "jiāng",
    "滰": "jiàng",
    "漿": "jiāng,jiàng",
    "獎": "jiǎng",
    "畺": "jiāng,jiàng",
    "疅": "jiāng",
    "糡": "jiàng",
    "絳": "jiàng",
    "繮": "jiāng",
    "畕": "jiāng",
    "翞": "jiāng",
    "膙": "jiǎng",
    "葁": "jiāng",
    "蔃": "qiáng",
    "蔣": "jiǎng",
    "螀": "jiāng",
    "螿": "jiāng",
    "薑": "jiāng",
    "袶": "péng",
    "謽": "jiàng",
    "講": "jiǎng",
    "醤": "jiàng",
    "醬": "jiàng",
    "韁": "jiāng",
    "顜": "jiǎng",
    "鱂": "jiāng",
    "鳉": "jiāng",
    "交": "jiāo",
    "脚": "jiǎo",
    "较": "jiào",
    "教": "jiào,jiāo",
    "觉": "jué,jiào",
    "叫": "jiào",
    "焦": "jiāo",
    "胶": "jiāo",
    "绞": "jiǎo",
    "娇": "jiāo",
    "搅": "jiǎo",
    "狡": "jiǎo",
    "骄": "jiāo",
    "校": "xiào,jiào",
    "嚼": "jiáo,jué,jiào",
    "郊": "jiāo",
    "矫": "jiǎo,jiáo",
    "轿": "jiào",
    "蕉": "jiāo",
    "礁": "jiāo",
    "饺": "jiǎo",
    "铰": "jiǎo",
    "窖": "jiào",
    "椒": "jiāo",
    "酵": "jiào",
    "徼": "jiǎo,jiào",
    "侥": "jiǎo,yáo",
    "僬": "jiāo",
    "艽": "jiāo,qiú",
    "蛟": "jiāo",
    "敫": "jiǎo",
    "峤": "jiào,qiáo",
    "姣": "jiāo,xiáo",
    "跤": "jiāo",
    "皎": "jiǎo",
    "茭": "jiāo",
    "鹪": "jiāo",
    "噍": "jiào",
    "醮": "jiào",
    "佼": "jiǎo",
    "湫": "qiū,jiǎo",
    "挢": "jiǎo",
    "鲛": "jiāo",
    "乔": "qiáo",
    "侨": "qiáo",
    "僑": "qiáo",
    "勪": "qiāo",
    "儌": "jiǎo",
    "却": "què",
    "呌": "jiào",
    "卻": "què",
    "僥": "jiǎo,yáo",
    "嘦": "jiào",
    "嘂": "jiào",
    "妖": "yāo",
    "喬": "qiáo,jiāo",
    "咬": "yǎo",
    "嫶": "qiáo",
    "孂": "jiǎo",
    "峧": "jiāo",
    "嵺": "liáo",
    "嶕": "jiāo",
    "嬓": "jiào",
    "嶣": "jiāo",
    "嬌": "jiāo",
    "恔": "xiào,jiǎo",
    "嶠": "jiào,qiáo",
    "憍": "jiāo",
    "憢": "xiāo,jiāo",
    "捁": "jiǎo,kù",
    "撹": "jiǎo",
    "挍": "jiào,jiāo",
    "撟": "jiǎo",
    "敎": "jiào,jiāo",
    "攪": "jiǎo",
    "敥": "yàn",
    "敽": "jiǎo",
    "敿": "jiǎo",
    "晈": "jiǎo",
    "暞": "jiǎo",
    "曒": "jiǎo",
    "櫵": "qiáo",
    "湬": "qiū,jiǎo",
    "斠": "jiào",
    "橋": "qiáo",
    "滘": "jiào",
    "漖": "jiào",
    "潐": "jiào,qiáo",
    "灂": "zhuó,jiào,zé",
    "灚": "jiǎo",
    "烄": "jiǎo,yào",
    "焳": "jué",
    "煍": "jiǎo,qiāo",
    "燋": "jiāo,qiáo,jué,zhuó",
    "獥": "jiào",
    "璬": "jiǎo",
    "珓": "jiào",
    "皦": "jiǎo",
    "皭": "jiào",
    "穚": "jiāo",
    "窌": "jiào,liáo,liù",
    "笅": "jiǎo,jiào",
    "矯": "jiǎo,jiáo",
    "筊": "jiǎo,jiào",
    "簥": "jiāo",
    "纐": "jiǎo",
    "糾": "jiū",
    "纠": "jiū",
    "腳": "jiǎo",
    "膲": "jiāo",
    "臫": "jiǎo",
    "芁": "qiú",
    "絞": "jiǎo",
    "茮": "jiāo",
    "萩": "qiū",
    "菽": "shū",
    "藠": "jiào",
    "蟜": "jiǎo",
    "蕎": "qiáo",
    "覐": "jué,jiào",
    "蟭": "jiāo",
    "覚": "jué,jiào",
    "訆": "jiào",
    "譑": "jiǎo",
    "覺": "jué,jiào",
    "譥": "jiào",
    "賋": "jiǎo",
    "趭": "jiào",
    "踋": "jiǎo",
    "蹻": "qiāo",
    "轇": "jiāo",
    "較": "jiào",
    "釂": "jiào",
    "釥": "qiǎo,jiǎo",
    "轎": "jiào",
    "鉸": "jiǎo",
    "驕": "jiāo",
    "骹": "qiāo,xiāo",
    "餃": "jiǎo",
    "鱎": "jiǎo",
    "鐎": "jiāo",
    "鮫": "jiāo",
    "鵁": "jiāo",
    "鵤": "zān",
    "鷮": "jiāo",
    "鷦": "jiāo",
    "纟": "sī",
    "节": "jié,jiē",
    "街": "jiē",
    "借": "jiè",
    "皆": "jiē",
    "截": "jié",
    "界": "jiè",
    "解": "jiě,jiè,xiè",
    "届": "jiè",
    "姐": "jiě",
    "戒": "jiè",
    "劫": "jié",
    "阶": "jiē",
    "竭": "jié",
    "楷": "kǎi,jiē",
    "桔": "jié,jú",
    "诫": "jiè",
    "杰": "jié",
    "睫": "jié",
    "疥": "jiè",
    "桀": "jié",
    "喈": "jiē",
    "蚧": "jiè",
    "羯": "jié",
    "嗟": "jiē",
    "鲒": "jié",
    "婕": "jié",
    "碣": "jié,yà",
    "孑": "jié",
    "疖": "jiē",
    "丯": "jiè",
    "倢": "jié",
    "偼": "jié",
    "刦": "jié",
    "傑": "jié",
    "刼": "jié",
    "劼": "jié",
    "唶": "jiè,zé,jí",
    "刧": "jié",
    "堦": "jiē",
    "堺": "jiè",
    "卪": "jié",
    "媘": "jiē",
    "契": "qì,qiè,xiè",
    "媎": "jiě",
    "岊": "jié",
    "屆": "jiè",
    "媫": "jié",
    "岕": "jiè",
    "嵑": "kě,jié",
    "崨": "jié",
    "嫅": "jiē,suǒ",
    "嵥": "jié",
    "嶰": "xiè,jiè",
    "巀": "jié",
    "嶻": "jié",
    "幯": "jié",
    "庎": "jiè",
    "徣": "jiè",
    "悈": "jiè,kè",
    "掲": "jiē",
    "搩": "jié,zhé",
    "擑": "jiē",
    "擮": "jié",
    "拾": "shí,shè",
    "擳": "zhì,jié",
    "昅": "jié",
    "桝": "jié",
    "椄": "jiē,qiè",
    "楐": "jiè",
    "楬": "jiē",
    "楶": "jié",
    "榤": "jié",
    "毑": "jiě",
    "洯": "qiè,jié",
    "湝": "jiē",
    "滐": "jié",
    "煯": "jiē",
    "檞": "jiě",
    "潔": "jié",
    "玠": "jiè",
    "琾": "jiè",
    "畍": "jiè",
    "疌": "jié,qiè",
    "痎": "jiē",
    "砎": "jiè",
    "礍": "jié",
    "癤": "jiē",
    "犗": "jiè",
    "祖": "zǔ",
    "稭": "jiē",
    "節": "jié",
    "絜": "xié,jié",
    "繲": "xiè",
    "脻": "jiē",
    "菨": "jiē,shà",
    "蓵": "jié",
    "蛣": "jié",
    "蛶": "jiè",
    "蝔": "jiē",
    "蜐": "jié",
    "蠘": "jié",
    "莭": "jié",
    "艐": "kè",
    "蠞": "jié",
    "蠽": "jié",
    "衱": "jié",
    "衸": "jiè",
    "袓": "jù,jiē",
    "褯": "jiè",
    "袺": "jié",
    "觧": "jiě,jiè,xiè",
    "誱": "jié",
    "詰": "jié",
    "誡": "jiè",
    "謯": "jiē",
    "踕": "jié",
    "鉣": "jié",
    "迼": "jié",
    "鍻": "jié",
    "鍇": "kǎi",
    "階": "jiē",
    "锴": "kǎi",
    "雃": "jiān",
    "鞂": "jiē",
    "飷": "jiě",
    "髫": "tiáo",
    "魪": "jiè",
    "鶛": "jiē",
    "鮚": "jié",
    "紧": "jǐn",
    "近": "jìn",
    "今": "jīn",
    "进": "jìn",
    "斤": "jīn",
    "尽": "jìn,jǐn",
    "金": "jīn",
    "禁": "jīn,jìn",
    "劲": "jìn,jìng",
    "浸": "jìn",
    "锦": "jǐn",
    "晋": "jìn",
    "筋": "jīn",
    "津": "jīn",
    "谨": "jǐn",
    "巾": "jīn",
    "襟": "jīn",
    "烬": "jìn",
    "靳": "jìn",
    "廑": "jǐn,qín",
    "瑾": "jǐn",
    "馑": "jǐn",
    "槿": "jǐn",
    "衿": "jīn",
    "堇": "jīn",
    "荩": "jìn",
    "噤": "jìn",
    "缙": "jìn",
    "卺": "jǐn",
    "妗": "jìn",
    "赆": "jìn",
    "觐": "jìn",
    "伒": "jìn,yín",
    "僅": "jǐn,jìn",
    "僸": "jìn",
    "兓": "qīn",
    "儘": "jǐn",
    "侭": "jǐn",
    "凚": "jìn",
    "劤": "jìn,jìng",
    "厪": "jǐn",
    "唫": "jìn,yín",
    "勁": "jìn,jìng",
    "嚍": "jìn",
    "埐": "qín,jīn",
    "吟": "yín",
    "堻": "jīn",
    "墐": "jìn",
    "壗": "jìn",
    "婜": "qiān,jǐn",
    "嫤": "jǐn,jìn",
    "嬧": "jìn",
    "嬐": "xiān,yǎn,jìn",
    "寖": "jìn,qǐn",
    "惍": "jīn",
    "嶜": "qín",
    "搢": "jìn",
    "斳": "qín",
    "巹": "jǐn",
    "枃": "jìn",
    "慬": "qín,jìn,jǐn",
    "晉": "jìn",
    "歏": "jìn,qūn",
    "殣": "jìn",
    "浕": "jìn",
    "溍": "jìn",
    "漌": "jǐn",
    "濅": "jìn",
    "濜": "jìn",
    "煡": "jìn",
    "燼": "jìn",
    "琻": "jīn",
    "璡": "jīn",
    "瑨": "jìn",
    "璶": "jìn",
    "琎": "jīn",
    "珒": "jīn",
    "砛": "jīn",
    "盡": "jìn",
    "祲": "jìn",
    "紟": "jīn,jìn",
    "紾": "zhěn,tiǎn",
    "緊": "jǐn",
    "肋": "lèi,lē",
    "荕": "jīn",
    "臸": "zhī,jìn",
    "縉": "jìn",
    "菫": "jǐn",
    "菳": "qín,qīn,jīn",
    "竻": "lè,jīn",
    "蓳": "jǐn",
    "觔": "jīn",
    "訡": "yín",
    "藎": "jìn",
    "覲": "jìn",
    "賮": "jìn",
    "謹": "jǐn",
    "贐": "jìn",
    "進": "jìn",
    "釒": "jīn",
    "釿": "jīn",
    "鋟": "qǐn",
    "錦": "jǐn",
    "钅": "jīn",
    "锓": "qǐn",
    "馸": "xìn,jìn",
    "饉": "jǐn",
    "鹶": "jīn",
    "黅": "jīn",
    "齽": "jìn",
    "竟": "jìng",
    "井": "jǐng",
    "静": "jìng",
    "经": "jīng",
    "京": "jīng",
    "敬": "jìng",
    "惊": "jīng",
    "景": "jǐng,yǐng",
    "镜": "jìng",
    "警": "jǐng",
    "竞": "jìng",
    "精": "jīng",
    "径": "jìng",
    "荆": "jīng",
    "晶": "jīng",
    "境": "jìng",
    "粳": "jīng",
    "茎": "jīng",
    "鲸": "jīng",
    "睛": "jīng",
    "痉": "jìng",
    "兢": "jīng",
    "靖": "jìng",
    "肼": "jǐng",
    "獍": "jìng",
    "阱": "jǐng",
    "腈": "jīng",
    "弪": "jìng",
    "刭": "jǐng",
    "憬": "jǐng",
    "婧": "jìng",
    "胫": "jìng",
    "菁": "jīng",
    "儆": "jǐng",
    "迳": "jìng",
    "旌": "jīng",
    "靓": "jìng,liàng",
    "泾": "jīng",
    "亰": "jīng",
    "俓": "jìng",
    "仱": "qián",
    "倞": "liàng,jìng",
    "傹": "jìng",
    "儬": "qìng",
    "坓": "jǐng",
    "凈": "jìng,chēng",
    "坕": "jīng",
    "剄": "jǐng",
    "坙": "jīng",
    "妌": "jìng",
    "婙": "jìng",
    "宑": "jǐng",
    "婛": "jīng",
    "巠": "jīng,xíng",
    "幜": "jǐng",
    "弳": "jìng",
    "憼": "jǐng,jìng",
    "徑": "jìng",
    "擏": "qíng,jǐng",
    "旍": "jīng",
    "暻": "jǐng",
    "梷": "jìng",
    "桱": "jìng",
    "橸": "jīng",
    "殑": "qíng,jìng",
    "汬": "jǐng",
    "曔": "jìng",
    "汫": "jǐng",
    "氏": "shì,zhī",
    "檠": "qíng",
    "浄": "jìng",
    "濪": "qìng",
    "燝": "zhǔ",
    "涇": "jīng",
    "烃": "tīng",
    "猄": "jīng",
    "烴": "tīng",
    "璄": "jǐng",
    "璟": "jǐng",
    "璥": "jǐng",
    "秔": "jīng",
    "稉": "jīng",
    "痙": "jìng",
    "穽": "jǐng",
    "竧": "jìng,zhěn",
    "竸": "jìng",
    "競": "jìng",
    "粇": "kāng,jīng",
    "箐": "qìng,jīng",
    "竫": "jìng",
    "経": "jīng",
    "聙": "jīng",
    "經": "jīng",
    "荊": "jīng",
    "葝": "qíng",
    "莖": "jìng",
    "蟼": "jǐng",
    "蜻": "qīng",
    "誩": "jìng",
    "踁": "jìng",
    "脛": "jìng",
    "鋞": "xíng,xìng,jīng",
    "逕": "jìng",
    "陘": "xíng",
    "靑": "qīng",
    "陉": "xíng",
    "靘": "qìng",
    "青": "qīng",
    "鏡": "jìng",
    "靚": "jìng",
    "靜": "jìng",
    "頚": "jǐng",
    "頴": "yǐng",
    "颕": "yǐng",
    "鵛": "jìng",
    "鶁": "jīng",
    "鯨": "jīng",
    "驚": "jīng",
    "麖": "jīng",
    "鶄": "jīng",
    "麠": "jīng",
    "鼱": "jīng",
    "窘": "jiǒng",
    "炯": "jiǒng",
    "扃": "jiōng",
    "侰": "jiǒng",
    "僒": "jiǒng",
    "迥": "jiǒng",
    "冋": "jiōng",
    "冏": "jiǒng",
    "囧": "jiǒng",
    "坰": "jiōng",
    "埛": "jiōng",
    "宭": "qún",
    "垧": "shǎng",
    "泂": "jiǒng",
    "冂": "jiōng",
    "浻": "jiǒng,jiōng",
    "澃": "jiǒng",
    "扄": "shǎng,jiōng",
    "烱": "jiǒng",
    "煚": "jiǒng",
    "瀅": "yíng",
    "煛": "jiǒng",
    "熲": "jiǒng",
    "燛": "jiǒng",
    "綗": "jiǒng",
    "絅": "jiōng,jiǒng",
    "蘏": "jiōng",
    "蘔": "jiōng",
    "褧": "jiǒng",
    "逈": "jiǒng",
    "熒": "yíng",
    "銄": "xiǎng,jiōng",
    "顈": "jiǒng",
    "鎣": "yíng",
    "颎": "jiǒng",
    "駉": "jiōng",
    "駫": "jiōng",
    "就": "jiù",
    "九": "jiǔ",
    "酒": "jiǔ",
    "旧": "jiù",
    "久": "jiǔ",
    "揪": "jiū",
    "救": "jiù",
    "究": "jiū",
    "舅": "jiù",
    "厩": "jiù",
    "韭": "jiǔ",
    "臼": "jiù",
    "玖": "jiǔ",
    "灸": "jiǔ",
    "疚": "jiù",
    "赳": "jiū",
    "僦": "jiù",
    "柩": "jiù",
    "桕": "jiù",
    "鬏": "jiū",
    "丩": "jiū",
    "阄": "jiū",
    "乆": "jiǔ",
    "啾": "jiū",
    "倃": "jiù",
    "鹫": "jiù",
    "乣": "jiǔ",
    "剹": "lù,jiū",
    "勼": "jiū",
    "匓": "jiù",
    "鸠": "jiū",
    "匛": "jiù",
    "匶": "jiù",
    "廏": "jiù",
    "廐": "jiù",
    "廄": "jiù",
    "慦": "jiù",
    "捄": "jiù",
    "奺": "jiǔ",
    "揂": "jiū,yóu",
    "揫": "jiū",
    "摎": "jiū,liú,liáo,jiǎo,náo",
    "朻": "jiū",
    "杦": "jiǔ",
    "柾": "jiù",
    "樛": "jiū,liáo",
    "橚": "sù,qiū",
    "殧": "jiù",
    "汣": "jiǔ",
    "牞": "jiū,lè",
    "畂": "mǔ",
    "稵": "zī,jiū",
    "穋": "lù",
    "糺": "jiū,jiǔ",
    "紤": "jiǔ",
    "缪": "móu,miù,miào,mù,liǎo",
    "舏": "jiǔ",
    "舊": "jiù",
    "萛": "jiū",
    "镹": "jiǔ",
    "繆": "móu,miù,miào,mù,liǎo",
    "蝤": "qiú",
    "韮": "jiǔ",
    "鬮": "jiū",
    "鳩": "jiū",
    "麔": "jiù",
    "鷲": "jiù",
    "欍": "jiù",
    "齨": "jiù",
    "举": "jǔ",
    "巨": "jù",
    "局": "jú",
    "具": "jù",
    "距": "jù",
    "锯": "jù",
    "剧": "jù",
    "菊": "jú",
    "矩": "jǔ",
    "沮": "jǔ,jù",
    "拒": "jù",
    "惧": "jù",
    "鞠": "jū",
    "聚": "jù",
    "驹": "jū",
    "狙": "jū",
    "俱": "jù",
    "疽": "jū",
    "踞": "jù",
    "据": "jù,jū",
    "咀": "jǔ,zuǐ",
    "炬": "jù",
    "倨": "jù",
    "醵": "jù",
    "屦": "jù",
    "裾": "jū",
    "犋": "jù",
    "窭": "jù",
    "飓": "jù",
    "锔": "jū",
    "椐": "jū",
    "苣": "jù,qǔ",
    "琚": "jū",
    "掬": "jū",
    "龃": "jǔ",
    "榘": "jǔ",
    "趄": "qiè,jū",
    "遽": "jù",
    "橘": "jú",
    "踽": "jǔ",
    "莒": "jǔ",
    "雎": "jū",
    "榉": "jǔ",
    "鞫": "jū",
    "侷": "jú",
    "倶": "jù",
    "讵": "jù",
    "僪": "yù,jú",
    "冣": "zuì",
    "钜": "jù",
    "劇": "jù",
    "凥": "jū",
    "匊": "jū",
    "勮": "jù",
    "圧": "yā",
    "埧": "jù",
    "坥": "qū",
    "姖": "jù",
    "娵": "jū",
    "婅": "jú",
    "壉": "jù",
    "娶": "qǔ",
    "寠": "jù,lóu",
    "埾": "jù",
    "婮": "jū",
    "岠": "jù",
    "屨": "jù",
    "岨": "jū,jǔ",
    "崌": "jū",
    "弆": "jǔ",
    "巈": "jú",
    "忂": "qú,jù",
    "怐": "kòu,jù",
    "愳": "jù",
    "懅": "jù",
    "拠": "jù",
    "懼": "jù",
    "挙": "jǔ",
    "怇": "jù",
    "挶": "jú",
    "揟": "xū,jū",
    "擧": "jǔ",
    "據": "jù,jū",
    "梮": "jū",
    "昛": "jù",
    "椇": "jǔ",
    "檋": "jū",
    "椈": "jú",
    "櫸": "jǔ",
    "欅": "jǔ",
    "歫": "jù",
    "毩": "jū",
    "毱": "jū",
    "洰": "jù",
    "泦": "jú",
    "涺": "jū",
    "淗": "jú",
    "澽": "jù",
    "渠": "qú,jù",
    "湨": "jú",
    "焗": "jú",
    "狊": "jú",
    "爠": "qú",
    "珇": "zǔ,jù",
    "痀": "gōu",
    "眗": "jū,xū,kōu",
    "砠": "jū",
    "犑": "jú",
    "秬": "jù",
    "租": "zū",
    "窶": "jù",
    "筥": "jǔ",
    "簴": "jù",
    "篓": "lǒu",
    "簍": "lǒu",
    "籧": "qú",
    "粷": "jú",
    "粔": "jù",
    "耟": "jù",
    "聥": "jǔ",
    "腒": "jū",
    "臄": "jué",
    "罝": "jū",
    "艍": "jū",
    "舉": "jǔ",
    "葅": "zū",
    "萭": "yǔ",
    "菹": "zū",
    "蒟": "jǔ",
    "蓻": "zí,jú",
    "蒌": "lóu",
    "蘜": "jú",
    "蔞": "lóu",
    "蘧": "qú",
    "虡": "jù",
    "蜛": "jū",
    "螶": "qú,jù",
    "蛆": "qū",
    "襷": "jǔ",
    "豦": "jù",
    "諊": "jū",
    "詎": "jù",
    "貗": "jù,lóu",
    "趉": "jué",
    "蚷": "jù",
    "趜": "jú",
    "跔": "jū",
    "跙": "jū,jù,qiè",
    "足": "zú",
    "踘": "jū",
    "跼": "jú",
    "躆": "jù",
    "躹": "jū",
    "輂": "jú",
    "邭": "jù",
    "郹": "jú",
    "鄒": "zōu",
    "蹫": "jú",
    "鄹": "zōu",
    "郥": "bèi",
    "郰": "zōu",
    "邹": "zōu",
    "鉅": "jù",
    "鋦": "jū,jú",
    "鐻": "jù",
    "鋸": "jù,jū",
    "閰": "jú",
    "陱": "jū",
    "駏": "jù",
    "颶": "jù",
    "駒": "jū",
    "駶": "jú",
    "驧": "jú",
    "鮔": "jù",
    "鬻": "yù",
    "鲏": "pí",
    "鴡": "jū",
    "鵙": "jú",
    "鮍": "pí",
    "鵴": "jú",
    "鼳": "jú",
    "鶋": "jū",
    "鶪": "jú",
    "齟": "jǔ",
    "鼰": "jú",
    "卷": "juàn,juǎn",
    "圈": "quān,juàn,juān",
    "倦": "juàn",
    "鹃": "juān",
    "捐": "juān",
    "娟": "juān",
    "眷": "juàn",
    "绢": "juàn",
    "鄄": "juàn",
    "锩": "juǎn",
    "镌": "juān",
    "蠲": "juān",
    "涓": "juān",
    "隽": "jùn,juàn",
    "劵": "juàn",
    "勌": "juàn,juān",
    "勬": "juān",
    "桊": "juàn",
    "呟": "juǎn",
    "狷": "juàn",
    "圏": "quān,juàn,juān",
    "埍": "juǎn",
    "埢": "quán",
    "奆": "juàn",
    "姢": "juān",
    "帣": "juàn,juǎn",
    "弮": "juàn,quān",
    "悁": "yuān,juàn",
    "慻": "juàn",
    "捲": "juǎn,quán",
    "朘": "juān,zuī",
    "梋": "xuān,juān,xié",
    "惓": "juàn,quán",
    "淃": "juàn",
    "焆": "juān,yè",
    "棬": "quān,juàn",
    "獧": "juàn",
    "泫": "xuàn",
    "瓹": "juàn,juān",
    "睊": "juàn",
    "甄": "zhēn",
    "睃": "suō",
    "絭": "juàn",
    "睠": "juàn",
    "縳": "zhuàn,juàn",
    "羂": "juàn",
    "絹": "juàn",
    "脧": "juān",
    "腃": "juàn",
    "罥": "juàn",
    "臇": "juǎn",
    "萒": "yǎn",
    "菤": "juǎn",
    "蔨": "juàn",
    "蕋": "ruǐ",
    "裐": "juān",
    "蕊": "ruǐ",
    "襈": "zhuàn",
    "讂": "juàn,xuān",
    "踡": "quán",
    "身": "shēn",
    "鋗": "xuān,juān,juàn",
    "蜷": "quán",
    "錈": "juǎn",
    "鎸": "juān",
    "鞙": "xuān,juān",
    "鐫": "juān",
    "雋": "jùn,juàn",
    "韏": "quàn",
    "飬": "yǎng,juàn",
    "餋": "juàn",
    "决": "jué",
    "绝": "jué",
    "爵": "jué",
    "掘": "jué",
    "鵑": "jiān",
    "诀": "jué",
    "倔": "jué,juè",
    "抉": "jué",
    "攫": "jué",
    "噱": "jué,xué",
    "撅": "juē,jué",
    "劂": "jué",
    "桷": "jué",
    "矍": "jué",
    "爝": "jué",
    "镢": "jué",
    "橛": "jué",
    "獗": "jué",
    "珏": "jué",
    "崛": "jué",
    "蕨": "jué",
    "噘": "juē",
    "谲": "jué",
    "孓": "jué",
    "亅": "jué",
    "傕": "què,jué",
    "厥": "jué",
    "乙": "yǐ",
    "刔": "jué",
    "匷": "jué",
    "啳": "quán",
    "埆": "què,jué",
    "妜": "yuè,jué",
    "孒": "jué",
    "屩": "juē",
    "屫": "juē",
    "崫": "jué",
    "屈": "qū",
    "嶥": "jué",
    "弡": "jué,zhāng",
    "彏": "jué",
    "憰": "jué",
    "憠": "jué",
    "戄": "jué",
    "挗": "jué",
    "捔": "jué,zhuó",
    "撧": "juē",
    "斍": "jué,jiào",
    "欔": "qú",
    "欮": "jué",
    "殌": "jǐng",
    "氒": "jué",
    "泬": "jué,xuè",
    "橜": "jué",
    "潏": "yù",
    "灍": "jué",
    "決": "jué",
    "熦": "jué",
    "爴": "jué",
    "爑": "jué",
    "玃": "jué",
    "玦": "jué",
    "狂": "kuáng",
    "玨": "jué",
    "璚": "qióng,jué",
    "疦": "jué,xuè",
    "瘚": "jué",
    "矞": "yù,xù,jué",
    "瑴": "jué",
    "矡": "jué",
    "穱": "zhuō,jué",
    "穴": "xué",
    "絕": "jué",
    "砄": "jué",
    "繑": "qiāo",
    "絶": "jué",
    "繘": "jú,jué",
    "芵": "jué",
    "蕝": "jué",
    "蚗": "jué,quē",
    "蕞": "zuì",
    "虳": "jué",
    "蟨": "jué",
    "蟩": "jué",
    "蛙": "wā",
    "蠼": "qú",
    "袦": "nà,jué",
    "觼": "jué",
    "誳": "qū,juè",
    "譎": "jué",
    "貜": "jué",
    "蹷": "jué",
    "訣": "jué",
    "躩": "jué",
    "逫": "zhú",
    "鈌": "jué",
    "鐍": "jué",
    "镼": "jié",
    "钁": "jué",
    "鐝": "jué",
    "闋": "què",
    "闕": "què,quē",
    "阙": "quē,què",
    "阕": "què",
    "鞒": "qiáo",
    "駃": "jué,kuài",
    "騤": "kuí",
    "鞽": "qiáo",
    "鶌": "qū",
    "鷢": "jué",
    "龣": "jiǎo",
    "骙": "kuí",
    "君": "jūn",
    "军": "jūn",
    "均": "jūn",
    "菌": "jūn,jùn",
    "峻": "jùn",
    "竣": "jùn",
    "骏": "jùn",
    "钧": "jūn",
    "郡": "jùn",
    "儁": "jùn",
    "麇": "jūn,qún",
    "捃": "jùn",
    "皲": "jūn",
    "勻": "yún",
    "呁": "jùn",
    "匀": "yún",
    "筠": "yún,jūn",
    "埈": "jùn",
    "姰": "jūn,xún",
    "寯": "jùn",
    "懏": "jùn",
    "晙": "jùn",
    "攈": "jùn,pèi",
    "旬": "xún",
    "桾": "jūn",
    "汮": "jūn",
    "濬": "jùn,xùn",
    "燇": "jùn",
    "珺": "jùn",
    "狻": "suān",
    "畯": "jùn",
    "焞": "tūn",
    "皹": "jūn",
    "焌": "qū,jùn",
    "碅": "jūn",
    "箘": "jùn,qūn",
    "箟": "jùn",
    "皸": "jūn",
    "莙": "jūn",
    "葰": "jùn",
    "蜠": "jùn",
    "蚐": "jūn",
    "袀": "jūn",
    "覠": "jūn",
    "軍": "jūn",
    "鈞": "jūn",
    "銁": "jūn",
    "銞": "jūn",
    "餕": "jùn",
    "鍕": "jūn",
    "馂": "jùn",
    "鮶": "jūn",
    "陖": "jùn",
    "鋆": "yún",
    "駿": "jùn",
    "鲪": "jūn",
    "鵔": "jùn",
    "鵕": "jùn",
    "鵘": "jùn",
    "麏": "jūn",
    "麕": "jūn",
    "卡": "qiǎ,kǎ",
    "喀": "kā",
    "胩": "kǎ",
    "佧": "kǎ",
    "呿": "qū",
    "咔": "kǎ",
    "垰": "kǎ",
    "裃": "kǎ",
    "衉": "kè",
    "鉲": "kǎ",
    "开": "kāi",
    "凯": "kǎi",
    "慨": "kǎi",
    "垲": "kǎi",
    "锎": "kāi",
    "铠": "kǎi",
    "忾": "kài,xì",
    "恺": "kǎi",
    "勓": "kài",
    "蒈": "kǎi",
    "凱": "kǎi",
    "塏": "kǎi",
    "奒": "kāi",
    "幆": "yì",
    "愷": "kǎi",
    "愾": "kài,xì",
    "欯": "xì,kài",
    "溘": "kè",
    "暟": "kǎi",
    "炏": "yán",
    "烗": "kài",
    "炌": "kài",
    "輆": "kǎi",
    "豈": "qǐ",
    "鎎": "kài",
    "鎧": "kǎi",
    "鐦": "kāi",
    "開": "kāi",
    "闓": "kǎi",
    "闿": "kǎi",
    "颽": "kǎi",
    "雉": "zhì",
    "乫": "jiā",
    "砍": "kǎn",
    "看": "kàn,kān",
    "坎": "kǎn",
    "刊": "kān",
    "龛": "kān",
    "勘": "kān",
    "瞰": "kàn",
    "戡": "kān",
    "偘": "kǎn",
    "莰": "kǎn",
    "埳": "xiàn,kǎn",
    "凵": "kǎn,qiǎn",
    "塪": "xiàn",
    "墈": "kàn",
    "侃": "kǎn",
    "崁": "kàn",
    "嵁": "kān,zhàn",
    "惂": "kǎn",
    "冚": "kǎn",
    "扻": "zhì,sǔn,kǎn",
    "栞": "kān",
    "歁": "kǎn,kè",
    "矙": "kàn",
    "磡": "kàn",
    "竷": "kǎn,kàn",
    "莶": "xiān,liǎn",
    "輡": "kǎn",
    "衎": "kàn",
    "輱": "xián",
    "轁": "tāo",
    "轗": "kǎn",
    "顑": "kǎn",
    "薟": "xiān,liǎn",
    "餡": "xiàn",
    "馅": "xiàn",
    "龕": "kān",
    "慷": "kāng",
    "康": "kāng",
    "糠": "kāng",
    "钪": "kàng",
    "闶": "kàng,kāng",
    "囥": "kàng",
    "嫝": "kāng",
    "匟": "kàng",
    "嵻": "kāng",
    "槺": "kāng",
    "坑": "kēng",
    "漮": "kāng",
    "砊": "kāng",
    "穅": "kāng",
    "摃": "gāng",
    "躿": "kāng",
    "鱇": "kāng",
    "鈧": "kàng",
    "靠": "kào",
    "鏮": "kāng",
    "考": "kǎo",
    "烤": "kǎo",
    "閌": "kāng,kàng",
    "拷": "kǎo",
    "犒": "kào",
    "尻": "kāo",
    "铐": "kào",
    "丂": "kǎo,qiǎo,yú",
    "栲": "kǎo",
    "攷": "kǎo",
    "洘": "kǎo,kào",
    "焅": "kù",
    "嵪": "kāo,qiāo",
    "髛": "kāo",
    "鮳": "kào",
    "銬": "kào",
    "鯌": "kào",
    "鲓": "kào",
    "訄": "qiú",
    "克": "kè",
    "棵": "kē",
    "科": "kē",
    "颗": "kē",
    "刻": "kè",
    "课": "kè",
    "客": "kè",
    "壳": "ké,qiào",
    "柯": "kē",
    "磕": "kē",
    "恪": "kè",
    "坷": "kē,kě",
    "岢": "kě",
    "蝌": "kē",
    "轲": "kē",
    "窠": "kē",
    "缂": "kè",
    "钶": "kē",
    "珂": "kē",
    "氪": "kè",
    "瞌": "kē",
    "髁": "kē",
    "疴": "kē",
    "骒": "kè",
    "勀": "kè",
    "剋": "kēi,kè",
    "尅": "kēi,kè",
    "嵙": "kē",
    "愘": "kè,qià",
    "勊": "kè",
    "愙": "kè",
    "嶱": "kě,jié",
    "堁": "kè",
    "揢": "ké,qiā",
    "樖": "kē",
    "炣": "kě",
    "娔": "kè",
    "牁": "kē",
    "敤": "kě",
    "榼": "kē",
    "痾": "kē,ē",
    "砢": "kē,luǒ",
    "硞": "què,kè,kù",
    "碦": "kè",
    "窼": "chāo,kē",
    "犐": "kē",
    "簻": "zhuā",
    "緙": "kè",
    "翗": "ké",
    "礚": "kē",
    "胢": "qià",
    "萪": "kē",
    "薖": "kē",
    "趷": "kē",
    "軻": "kē,kě",
    "鈳": "kē",
    "顆": "kē",
    "課": "kè",
    "醘": "kē",
    "騍": "kè",
    "肯": "kěn",
    "啃": "kěn",
    "恳": "kěn",
    "垦": "kěn",
    "裉": "kèn",
    "墾": "kěn",
    "垠": "yín",
    "掯": "kèn",
    "懇": "kěn",
    "珢": "yín,kèn",
    "硍": "kèn,xiàn,gǔn,yǐn",
    "褃": "kèn",
    "豤": "kěn",
    "肎": "kěn",
    "貇": "kěn,kūn",
    "肻": "kěn",
    "錹": "kěn",
    "頎": "qí",
    "齦": "yín",
    "颀": "qí",
    "龈": "yín,kěn",
    "劥": "kēng",
    "坈": "rǒng,kēng",
    "铿": "kēng",
    "忐": "tǎn",
    "揁": "zhēng,kēng",
    "摼": "kēng,qiān",
    "殸": "qìng,kēng,shēng",
    "牼": "kēng",
    "硁": "kēng",
    "硜": "kēng",
    "硎": "xíng",
    "硻": "kēng,kěng",
    "誙": "kēng",
    "銵": "kēng",
    "怾": "zhǐ",  # Unknow.
    "空": "kōng,kòng,kǒng",
    "鍞": "kēng",
    "孔": "kǒng",
    "挳": "kēng,qiān",
    "控": "kòng",
    "鏗": "kēng",
    "恐": "kǒng",
    "倥": "kōng,kǒng",
    "崆": "kōng",
    "埪": "kōng",
    "宆": "qióng",
    "悾": "kōng,kǒng",
    "箜": "kōng",
    "涳": "kōng,náng",
    "椌": "qiāng,kōng",
    "硿": "kōng",
    "羫": "qiāng,kòng",
    "穹": "qióng",
    "躻": "kōng",
    "錓": "kōng",
    "腔": "qiāng",
    "鞚": "kòng",
    "鵼": "kōng",
    "廤": "kù",
    "扣": "kòu",
    "口": "kǒu",
    "抠": "kōu",
    "蔻": "kòu",
    "寇": "kòu",
    "芤": "kōu",
    "眍": "kōu",
    "冦": "kòu",
    "筘": "kòu",
    "叩": "kòu",
    "劶": "kǒu",
    "妪": "yù",
    "嫗": "yù",
    "宼": "kòu",
    "剾": "kōu",
    "彄": "kōu",
    "挎": "kuà,kū",
    "敂": "kòu",
    "摳": "kōu",
    "毆": "ōu",
    "瞘": "kōu",
    "窛": "kòu",
    "竘": "qǔ,kǒu",
    "簆": "kòu",
    "蔲": "kòu",
    "釦": "kòu",
    "鷇": "kòu",
    "鏂": "ōu",
    "滱": "kòu",
    "哭": "kū",
    "裤": "kù",
    "库": "kù",
    "酷": "kù",
    "窟": "kū",
    "刳": "kū",
    "喾": "kù",
    "骷": "kū",
    "堀": "kū",
    "绔": "kù",
    "俈": "kù",
    "圐": "kū",
    "嚳": "kù",
    "圣": "shèng",
    "庫": "kù",
    "扝": "yū,wū,kū",
    "桍": "kū",
    "泏": "chù,shè",
    "狜": "kǔ",
    "瘔": "kù",
    "矻": "kū",
    "秙": "kù,kū",
    "窋": "zhú,kū",
    "絝": "kù",
    "袴": "kù",
    "跍": "kū",
    "趶": "kuà,wù",
    "褲": "kù",
    "跨": "kuà",
    "鮬": "kū",
    "郀": "kū",
    "垮": "kuǎ",
    "夸": "kuā,kuà",
    "咵": "kuā",
    "胯": "kuà",
    "晇": "xù,kuā",
    "舿": "kuā",
    "銙": "kuǎ",
    "顝": "kuī",
    "骻": "kuà",
    "誇": "kuā,kuà",
    "块": "kuài",
    "快": "kuài",
    "筷": "kuài",
    "侩": "kuài",
    "蒯": "kuǎi",
    "郐": "kuài",
    "狯": "kuài",
    "脍": "kuài",
    "儈": "kuài",
    "凷": "kuài",
    "圦": "kuài",
    "塊": "kuài",
    "廥": "kuài",
    "擓": "kuǎi",
    "旝": "kuài",
    "糩": "kuài",
    "墤": "kuài,tuí",
    "鬠": "kuò",
    "蒉": "kuì,kuài",
    "膾": "kuài",
    "鄶": "kuài",
    "蕢": "kuì",
    "鱠": "kuài",
    "鲙": "kuài",
    "款": "kuǎn",
    "魁": "kuí",
    "髋": "kuān",
    "寛": "kuān",
    "完": "wán",
    "寬": "kuān",
    "宽": "kuān",
    "欵": "kuǎn",
    "歀": "kuǎn",
    "窽": "kuǎn,cuàn",
    "髖": "kuān",
    "矿": "kuàng",
    "鑧": "kuān",
    "框": "kuàng",
    "筐": "kuāng",
    "况": "kuàng",
    "旷": "kuàng",
    "匡": "kuāng",
    "眶": "kuàng",
    "诳": "kuáng",
    "邝": "kuàng",
    "纩": "kuàng",
    "夼": "kuǎng",
    "诓": "kuāng",
    "贶": "kuàng",
    "圹": "kuàng",
    "哐": "kuāng",
    "儣": "kuǎng",
    "劻": "kuāng",
    "匩": "kuāng",
    "兄": "xiōng",
    "岲": "kuàng",
    "忹": "kuáng,wǎng",
    "恇": "kuāng",
    "壙": "kuàng",
    "懭": "kuǎng",
    "懬": "kuàng",
    "抂": "kuáng,wǎng,zài",
    "昿": "kuàng",
    "曠": "kuàng",
    "枉": "wǎng",
    "況": "kuàng",
    "洭": "kuāng",
    "狅": "kuáng",
    "眖": "kuàng",
    "砿": "kuàng",
    "穬": "kuàng",
    "絋": "kuàng",
    "礦": "kuàng",
    "絖": "kuàng",
    "纊": "kuàng",
    "誆": "kuāng",
    "筺": "kuāng",
    "誑": "kuáng",
    "軖": "kuáng",
    "貺": "kuàng",
    "軠": "kuáng",
    "軦": "kuàng",
    "邼": "kuāng",
    "鉱": "kuàng",
    "鋛": "kuàng",
    "鑛": "kuàng",
    "鵟": "kuáng",
    "黋": "kuàng",
    "軭": "kuāng",
    "亏": "kuī",
    "鄺": "kuàng",
    "愧": "kuì",
    "窥": "kuī",
    "葵": "kuí",
    "馈": "kuì",
    "盔": "kuī",
    "岿": "kuī",
    "愦": "kuì",
    "奎": "kuí",
    "跬": "kuǐ",
    "聩": "kuì",
    "篑": "kuì",
    "喹": "kuí",
    "逵": "kuí",
    "暌": "kuí",
    "揆": "kuí",
    "悝": "kuī,lǐ",
    "馗": "kuí",
    "蝰": "kuí",
    "刲": "kuī",
    "卼": "wù",
    "夔": "kuí",
    "嬇": "kuì",
    "尯": "kuì,kuǐ",
    "巙": "kuí",
    "戣": "kuí",
    "巋": "kuī",
    "晆": "kuí",
    "憒": "kuì",
    "楑": "kuí",
    "楏": "kuí",
    "樻": "guì",
    "櫆": "kuí",
    "殨": "kuì,huì",
    "欳": "kuài",
    "煃": "kuǐ",
    "磈": "kuǐ,wěi",
    "潰": "kuì,huì",
    "籄": "kuì",
    "窺": "kuī",
    "簣": "kuì",
    "聧": "kuī",
    "缺": "quē",
    "聵": "kuì",
    "臾": "yú",
    "藈": "kuí",
    "蘷": "kuí",
    "虁": "kuí",
    "聭": "kuì",
    "蹞": "kuǐ",
    "虧": "kuī",
    "躨": "kuí",
    "鍨": "kuí",
    "鄈": "kuí",
    "鍷": "kuí",
    "鐀": "guì",
    "鑎": "guì",
    "闚": "kuī",
    "頄": "qiú",
    "頃": "qǐng",
    "頯": "kuí",
    "餽": "kuì",
    "顷": "qǐng",
    "饋": "kuì",
    "頍": "kuǐ",
    "困": "kùn",
    "坤": "kūn",
    "髡": "kūn",
    "琨": "kūn",
    "醌": "kūn",
    "鲲": "kūn",
    "阃": "kǔn",
    "悃": "kǔn",
    "堃": "kūn",
    "堒": "kūn",
    "卵": "luǎn",
    "壸": "kǔn",
    "壼": "kǔn",
    "尡": "hùn",
    "崑": "kūn",
    "晜": "kūn",
    "涃": "kùn",
    "潉": "kūn",
    "焜": "kūn",
    "熴": "kūn",
    "猑": "kūn",
    "瑻": "kūn",
    "崐": "kūn",
    "硱": "kǔn",
    "祵": "kǔn",
    "稇": "kǔn",
    "稛": "kǔn",
    "綑": "kǔn",
    "臗": "kuān",
    "罤": "tí",
    "菎": "kūn",
    "蜫": "kūn",
    "裈": "kūn",
    "睏": "kùn",
    "裍": "kǔn",
    "裩": "kūn",
    "褌": "kūn",
    "閸": "kǔn",
    "閫": "kǔn",
    "頑": "wán",
    "騉": "kūn",
    "髠": "kūn",
    "顽": "wán",
    "髨": "kūn",
    "鯤": "kūn",
    "鵾": "kūn",
    "鶤": "kūn",
    "廓": "kuò",
    "适": "shì",
    "噋": "tūn,kuò",
    "蛞": "kuò",
    "鹍": "kūn",
    "拡": "kuò",
    "濶": "kuò",
    "桰": "guā",
    "阔": "kuò",
    "懖": "guō",
    "爥": "zhú",
    "筈": "kuò",
    "葀": "kuò",
    "霩": "kuò",
    "闊": "kuò",
    "燭": "zhú",
    "鞹": "kuò",
    "韕": "kuò",
    "頢": "kuò",
    "髺": "kuò,yuè",
    "穒": "hè",  # Unknow.
    "鞟": "kuò",
    "拉": "lā,lá",
    "啦": "lā,la",
    "腊": "là,xī",
    "辣": "là",
    "喇": "lǎ",
    "垃": "lā",
    "落": "là,luò,lào",
    "蓝": "lán",
    "瘌": "là",
    "邋": "lā",
    "砬": "lì,lā,lá",
    "剌": "là,lá",
    "儠": "liè",
    "嚹": "lá",
    "旯": "lá",
    "揧": "là",
    "搚": "lā,xié,xiàn",
    "擸": "liè,là",
    "攋": "là,lài",
    "摺": "zhé",
    "柆": "lā",
    "楋": "là",
    "櫴": "là,lài",
    "溂": "là",
    "瓎": "là",
    "爉": "là,liè",
    "磖": "lá,lā",
    "揦": "là,lá",
    "翋": "là",
    "癩": "lài",
    "菈": "lā",
    "藞": "lǎ",
    "臘": "là",
    "蝋": "là",
    "蝲": "là",
    "辢": "là",
    "鑞": "là",
    "鞡": "la",
    "蠟": "là",
    "镴": "là",
    "鬎": "là",
    "鱲": "liè",
    "癞": "lài",
    "鯻": "là",
    "来": "lái",
    "赖": "lài",
    "莱": "lái",
    "濑": "lài",
    "崃": "lái",
    "涞": "lái",
    "铼": "lái",
    "籁": "lài",
    "俫": "lái",
    "徕": "lài,lái",
    "倈": "lái",
    "赉": "lài",
    "唻": "lài",
    "厲": "lì",
    "來": "lái",
    "婡": "lái,lài",
    "崍": "lái",
    "睐": "lài",
    "庲": "lái",
    "梾": "lái",
    "徠": "lái,lài",
    "棶": "lái",
    "懶": "lǎn",
    "瀬": "lài",
    "瀨": "lài",
    "猍": "lái",
    "筙": "lái",
    "琜": "lái",
    "箂": "lái",
    "籟": "lài",
    "睞": "lài",
    "藾": "lài",
    "襰": "lǎi",
    "淶": "lái",
    "萊": "lái",
    "賚": "lài",
    "逨": "lái",
    "賴": "lài",
    "郲": "lái",
    "騋": "lái",
    "釐": "lí,xǐ,xī",
    "錸": "lái",
    "顂": "lài",
    "頼": "lài",
    "鶆": "lái",
    "鯠": "lái",
    "麳": "lái",
    "兰": "lán",
    "烂": "làn",
    "拦": "lán",
    "黧": "lí",
    "篮": "lán",
    "栏": "lán",
    "揽": "lǎn",
    "懒": "lǎn",
    "缆": "lǎn",
    "谰": "lán",
    "婪": "lán",
    "澜": "lán",
    "览": "lǎn",
    "榄": "lǎn",
    "岚": "lán",
    "褴": "lán",
    "斓": "lán",
    "镧": "lán",
    "罱": "lǎn",
    "漤": "lǎn",
    "儖": "lán",
    "厱": "qiān,lán",
    "僋": "tǎn,tàn",
    "囒": "lán",
    "阑": "lán",
    "壏": "xiàn,làn",
    "壈": "lǎn",
    "啉": "lán,lín",
    "嬾": "lǎn",
    "孄": "lǎn",
    "孏": "lǎn",
    "幱": "lán",
    "嵐": "lán",
    "惏": "lán,lín",
    "廩": "lǐn",
    "廪": "lǐn",
    "懢": "lán,xiàn",
    "擥": "lǎn",
    "懔": "lǐn",
    "攬": "lǎn",
    "攔": "lán",
    "斕": "lán",
    "欗": "lán",
    "欄": "lán",
    "浨": "lǎn",
    "欖": "lǎn",
    "湅": "liàn",
    "涟": "lián",
    "灆": "lán",
    "漣": "lián",
    "瀾": "lán",
    "灡": "lán",
    "灠": "lǎn",
    "煉": "liàn",
    "燗": "làn",
    "燣": "lán",
    "爁": "làn",
    "爤": "làn",
    "爦": "lǎn,làn",
    "璼": "lán",
    "瓓": "làn",
    "礷": "jiān",
    "爛": "làn",
    "籣": "lán",
    "糷": "làn",
    "籃": "lán",
    "炼": "liàn",
    "繿": "lán",
    "葻": "lán",
    "襕": "lán",
    "藍": "lán",
    "蘭": "lán",
    "襽": "lán",
    "襴": "lán",
    "襤": "lán",
    "覧": "lǎn",
    "覽": "lǎn",
    "纜": "lǎn",
    "讕": "lán",
    "譋": "lán",
    "躝": "lán",
    "醂": "lǎn",
    "钄": "làn",
    "鑭": "lán",
    "闌": "lán",
    "韊": "lán",
    "顲": "lǎn",
    "浪": "làng",
    "廊": "láng",
    "郎": "láng,làng",
    "朗": "lǎng",
    "稂": "láng",
    "琅": "láng",
    "螂": "láng",
    "榔": "láng",
    "莨": "làng,liáng",
    "蒗": "làng",
    "啷": "lāng",
    "锒": "láng",
    "勆": "láng",
    "阆": "làng",
    "哴": "liàng,láng",
    "唥": "léng",
    "埌": "làng",
    "塱": "lǎng",
    "俍": "liáng",
    "嫏": "láng",
    "崀": "lǎng",
    "悢": "liàng",
    "朖": "lǎng",
    "朤": "lǎng",
    "桹": "láng",
    "樃": "láng",
    "欴": "láng",
    "烺": "lǎng",
    "瑯": "láng",
    "硠": "láng",
    "筤": "láng,làng",
    "脼": "liǎng",
    "艆": "láng",
    "蓈": "láng",
    "蓢": "lǎng",
    "蜋": "láng",
    "誏": "lǎng,làng",
    "躴": "láng",
    "踉": "liáng,liàng",
    "郒": "láng",
    "樠": "mán",
    "郞": "láng",
    "鎯": "láng",
    "鋃": "láng",
    "駺": "liáng,láng",
    "閬": "làng",
    "老": "lǎo",
    "捞": "lāo",
    "牢": "láo",
    "劳": "láo",
    "烙": "lào,luò",
    "涝": "lào",
    "酪": "lào",
    "络": "luò,lào",
    "佬": "lǎo",
    "姥": "mǔ,lǎo",
    "潦": "lǎo,lào,liáo",
    "耢": "lào",
    "铹": "láo",
    "醪": "láo",
    "铑": "lǎo",
    "栳": "lǎo",
    "僗": "láo",
    "崂": "láo",
    "痨": "láo",
    "労": "láo",
    "僚": "liáo",
    "哰": "láo",
    "勞": "láo",
    "嗠": "lào",
    "恅": "lǎo",
    "憥": "láo",
    "嶗": "láo",
    "咾": "lǎo",
    "憦": "lào,láo",
    "撈": "lāo",
    "朥": "láo",
    "撩": "liāo,liáo",
    "橑": "liáo",
    "橯": "lào",
    "嫪": "lào",
    "浶": "láo",
    "珯": "lǎo",
    "硓": "lǎo",
    "獠": "liáo",
    "癆": "láo",
    "澇": "lào",
    "磱": "láo,luò",
    "窂": "láo",
    "粩": "lāo",
    "絡": "luò,lào",
    "耮": "lào",
    "蛯": "lǎo",
    "蓼": "liǎo,lù",
    "簩": "láo",
    "蟧": "láo,liáo",
    "轑": "lǎo",
    "顟": "láo",
    "銠": "lǎo",
    "鐒": "láo",
    "鮱": "lǎo",
    "軂": "lào",
    "髝": "láo",
    "了": "liǎo,le",
    "乐": "lè,yuè",
    "勒": "lè,lēi",
    "鳓": "lè",
    "仂": "lè",
    "泐": "lè",
    "叻": "lè",
    "嘞": "lei,lē",
    "忇": "lè",
    "楽": "lè,yuè",
    "氻": "lè",
    "玏": "lè",
    "砳": "lè",
    "簕": "lè",
    "阞": "lè",
    "韷": "lè",
    "餎": "lè",
    "饹": "gē,le",
    "樂": "lè,yuè,yào,lào",
    "类": "lèi",
    "鰳": "lè",
    "累": "léi,lěi,lèi",
    "泪": "lèi",
    "雷": "léi",
    "垒": "lěi",
    "擂": "léi,lèi",
    "蕾": "lěi",
    "镭": "léi",
    "儡": "lěi",
    "磊": "lěi",
    "缧": "léi",
    "诔": "lěi",
    "耒": "lěi",
    "酹": "lèi",
    "羸": "léi",
    "嫘": "léi",
    "傫": "lěi",
    "儽": "léi",
    "檑": "léi",
    "咧": "liě,liē,lié,lie",
    "塁": "lěi",
    "厽": "lěi",
    "卢": "lú",
    "壨": "lěi",
    "攂": "léi,lèi",
    "壘": "lěi",
    "樏": "léi,lěi",
    "櫐": "lěi",
    "欙": "léi",
    "洡": "lěi,lèi",
    "涙": "lèi",
    "淚": "lèi",
    "灅": "lěi",
    "漯": "luò,tà",
    "瓃": "léi",
    "櫑": "léi,lěi",
    "癗": "lěi",
    "畾": "léi",
    "盧": "lú",
    "磥": "lěi,léi",
    "礌": "léi,lěi",
    "礧": "léi,lěi,lèi",
    "礨": "lěi",
    "祱": "shuì,lèi",
    "禷": "lèi",
    "絫": "lěi,lèi,léi",
    "纇": "lèi",
    "縲": "léi",
    "矋": "lěi",
    "纝": "léi",
    "罍": "léi",
    "脷": "lì",
    "纍": "léi",
    "蔂": "léi",
    "蕌": "lěi",
    "藟": "lěi",
    "蘱": "lèi",
    "蘲": "léi",
    "蘽": "lěi",
    "蠝": "lěi",
    "虆": "léi",
    "讄": "lěi",
    "誄": "lěi",
    "轠": "léi",
    "銇": "lèi",
    "鐳": "léi",
    "錑": "lèi",
    "鑘": "léi",
    "鑸": "lěi",
    "靁": "léi",
    "頛": "lèi",
    "頪": "lèi",
    "颣": "lèi",
    "鱩": "léi",
    "鸓": "lěi",
    "類": "lèi",
    "鼺": "léi",
    "里": "lǐ",
    "力": "lì",
    "立": "lì",
    "李": "lǐ",
    "例": "lì",
    "哩": "li,lǐ,lī",
    "理": "lǐ",
    "利": "lì",
    "梨": "lí",
    "礼": "lǐ",
    "历": "lì",
    "丽": "lì,lí",
    "砾": "lì",
    "漓": "lí",
    "傈": "lì",
    "荔": "lì",
    "俐": "lì",
    "痢": "lì",
    "狸": "lí",
    "粒": "lì",
    "吏": "lì",
    "沥": "lì",
    "栗": "lì",
    "励": "lì",
    "厉": "lì",
    "璃": "lí",
    "鲤": "lǐ",
    "篱": "lí",
    "黎": "lí",
    "郦": "lì,zhí",
    "鹂": "lí",
    "笠": "lì",
    "犁": "lí",
    "坜": "lì",
    "鳢": "lǐ",
    "苈": "lì",
    "缡": "lí",
    "跞": "lì,luò",
    "蜊": "lì",
    "锂": "lǐ",
    "蓠": "lí",
    "澧": "lǐ",
    "粝": "lì",
    "呖": "lì",
    "枥": "lì",
    "蠡": "lǐ",
    "嫠": "lí",
    "砺": "lì",
    "篥": "lì",
    "猁": "lì",
    "藜": "lí",
    "疬": "lì",
    "溧": "lì",
    "鲡": "lí",
    "戾": "lì",
    "栎": "lì,yuè",
    "唳": "lì",
    "疠": "lì,lài",
    "醴": "lǐ",
    "轹": "lì",
    "詈": "lì",
    "罹": "lí",
    "逦": "lǐ",
    "俪": "lì",
    "喱": "lí",
    "雳": "lì",
    "莅": "lì",
    "俚": "lǐ",
    "蛎": "lì",
    "娌": "lǐ",
    "儮": "lì",
    "位": "wèi",
    "凓": "lì",
    "刕": "lí",
    "儷": "lì",
    "剓": "lí",
    "剺": "lí",
    "列": "liè",
    "劙": "lí",
    "厤": "lì",
    "勵": "lì",
    "叓": "lì",
    "叕": "zhuó,yǐ,lì,jué",
    "唎": "lì",
    "嚟": "lí",
    "囄": "lí",
    "囇": "lì",
    "塛": "lì",
    "嚦": "lì",
    "厯": "lì",
    "娳": "lì",
    "壢": "lì",
    "婯": "lì",
    "孋": "lí,lì",
    "孷": "lí",
    "岦": "lì",
    "峛": "lǐ",
    "峲": "lǐ",
    "巁": "lì,liè",
    "廲": "lí",
    "屴": "lì",
    "悡": "lí",
    "悧": "lì",
    "悷": "lì",
    "搮": "lì",
    "擽": "lì,luò,yuè",
    "捩": "liè",
    "攊": "lì,luò",
    "攭": "lì,luǒ",
    "攦": "lì,shài",
    "慄": "lì",
    "暦": "lì",
    "斄": "lí,tái",
    "曞": "lì",
    "朸": "lì",
    "栃": "lì",
    "栛": "lì",
    "曆": "lì",
    "栵": "liè",
    "梸": "lí",
    "棃": "lí",
    "棙": "lì,liè",
    "檪": "lì",
    "櫔": "lì",
    "櫟": "lì,yuè",
    "欐": "lì",
    "櫪": "lì",
    "欚": "lǐ",
    "歴": "lì",
    "沴": "lì",
    "歷": "lì",
    "沵": "mǐ,lì",
    "氂": "máo",
    "浬": "lǐ",
    "涖": "lì",
    "泣": "qì",
    "濿": "lì",
    "濼": "luò,pō",
    "瀝": "lì",
    "爄": "lì,liè",
    "灑": "sǎ",
    "灕": "lí",
    "犂": "lí",
    "犛": "máo,lí",
    "犡": "lì",
    "珕": "lì",
    "珞": "luò",
    "爏": "lì",
    "琍": "lí",
    "瑮": "lì",
    "瓈": "lí",
    "瓑": "lì",
    "瓥": "lì",
    "癘": "lì,lài",
    "癧": "lì",
    "盠": "lí",
    "盭": "lì",
    "瓅": "lì",
    "矖": "xǐ",
    "砅": "lì",
    "睝": "lí",
    "磿": "lì",
    "礫": "lì",
    "礰": "lì",
    "禮": "lǐ",
    "秝": "lì",
    "禲": "lì",
    "穲": "lí",
    "礪": "lì",
    "竰": "lí",
    "筣": "lí",
    "粴": "lǐ",
    "籬": "lí",
    "糲": "lì",
    "綟": "lì,liè",
    "縭": "lí",
    "糎": "lí",
    "纅": "yào,lì",
    "纚": "lí,xǐ,lǐ,sǎ",
    "艃": "lí",
    "茘": "lì",
    "荲": "lí",
    "菞": "lí",
    "蒚": "lì",
    "蔾": "lí",
    "蒞": "lì",
    "藶": "lì",
    "蛠": "lì",
    "蚸": "lì",
    "蜧": "lì",
    "蘺": "lí",
    "蟍": "lí",
    "蝷": "lì",
    "蝕": "shí",
    "蠇": "lì",
    "蠫": "lí",
    "蠣": "lì",
    "裏": "lǐ",
    "褵": "lí",
    "裡": "lǐ",
    "觻": "lì,lù",
    "謧": "lí",
    "蟸": "lí",
    "赲": "lì",
    "貍": "lí",
    "讈": "lì",
    "躒": "lì,luò",
    "轣": "lì",
    "轢": "lì",
    "邐": "lǐ",
    "酈": "lì",
    "醨": "lí",
    "鉝": "lì",
    "鋫": "lí",
    "釃": "shī",
    "錅": "lí",
    "鏫": "lí",
    "鋰": "lǐ",
    "鑗": "lí",
    "鑠": "shuò",
    "铄": "shuò",
    "隷": "lì,dài",
    "隸": "lì,dài",
    "靋": "lì",
    "霾": "mái",
    "靂": "lì",
    "鬁": "lì",
    "颯": "sà",
    "飒": "sà",
    "鯉": "lǐ",
    "鯏": "lí",
    "鯬": "lí",
    "鱱": "lǐ",
    "鱳": "lè",
    "鱧": "lǐ",
    "鴗": "lì",
    "鳨": "lì",
    "鵹": "lí",
    "鱺": "lí",
    "鷅": "lì",
    "鸝": "lí",
    "麗": "lí,lì",
    "俩": "liǎ",
    "倆": "liǎ",
    "麜": "lì",
    "练": "liàn",
    "莲": "lián",
    "联": "lián",
    "恋": "liàn",
    "脸": "liǎn",
    "连": "lián",
    "链": "liàn",
    "敛": "liǎn",
    "怜": "lián",
    "廉": "lián",
    "蠊": "lián",
    "琏": "liǎn",
    "蔹": "liǎn",
    "殓": "liàn",
    "镰": "lián",
    "鲢": "lián",
    "奁": "lián",
    "臁": "lián",
    "潋": "liàn",
    "濂": "lián",
    "裢": "lián",
    "亷": "lián",
    "令": "líng,lǐng,lìng",
    "僆": "liàn",
    "劆": "lián",
    "楝": "liàn",
    "匲": "lián",
    "嗹": "lián",
    "噒": "lián",
    "堜": "liàn",
    "奩": "lián",
    "娈": "luán",
    "匳": "lián",
    "媡": "liàn",
    "嬚": "liǎn",
    "慩": "lián,liǎn",
    "嫾": "lián",
    "孌": "luán",
    "憐": "lián",
    "戀": "liàn",
    "挛": "luán",
    "梿": "lián,liǎn",
    "斂": "liǎn",
    "摙": "liǎn,liàn",
    "攣": "luán",
    "槏": "qiǎn,lián,xiàn",
    "槤": "lián,liǎn",
    "櫣": "lián,liǎn",
    "浰": "lì",
    "殮": "liàn",
    "溓": "lián,liǎn,nián,xián,xiàn",
    "澰": "liàn",
    "濓": "lián",
    "熑": "lián",
    "燫": "lián",
    "瀲": "liàn",
    "瑓": "liàn",
    "磏": "lián,qiān",
    "瞵": "lín",
    "籢": "lián",
    "簾": "lián",
    "練": "liàn",
    "籨": "lián",
    "纞": "liàn",
    "縺": "lián",
    "羷": "liǎn",
    "璉": "liǎn",
    "聨": "lián",
    "翴": "lián",
    "聫": "lián",
    "聮": "lián",
    "聯": "lián",
    "膦": "lìn",
    "萰": "liàn",
    "苓": "líng",
    "蓮": "lián",
    "臉": "liǎn",
    "螊": "lián",
    "蘞": "liǎn",
    "蘝": "liǎn",
    "覝": "lián",
    "褳": "lián",
    "薕": "lián",
    "謰": "lián",
    "譧": "zhàn",
    "蹥": "lián",
    "鄻": "liǎn",
    "鎌": "lián",
    "連": "lián",
    "鏈": "liàn",
    "零": "líng",
    "鐮": "lián",
    "鬑": "lián",
    "鰊": "liàn",
    "鱄": "zhuān",
    "鰱": "lián",
    "两": "liǎng",
    "亮": "liàng",
    "辆": "liàng",
    "凉": "liáng,liàng",
    "量": "liáng,liàng",
    "粮": "liáng",
    "晾": "liàng",
    "良": "liáng",
    "梁": "liáng",
    "墚": "liáng",
    "椋": "liáng",
    "魉": "liǎng",
    "谅": "liàng",
    "両": "liǎng",
    "粱": "liáng",
    "兩": "liǎng",
    "唡": "liǎng",
    "啢": "liǎng",
    "喨": "liàng",
    "掚": "liǎng",
    "樑": "liáng",
    "湸": "liàng",
    "簗": "zhù",
    "涼": "liáng,liàng",
    "煷": "huǒ",
    "綡": "jīng",
    "緉": "liǎng",
    "糧": "liáng",
    "蜽": "liǎng",
    "裲": "liǎng",
    "諒": "liàng",
    "蹒": "pán",
    "蹣": "pán",
    "輌": "liàng",
    "輬": "liáng",
    "輛": "liàng",
    "辌": "liáng",
    "鍄": "liàng",
    "魎": "liǎng",
    "料": "liào",
    "聊": "liáo",
    "撂": "liào",
    "疗": "liáo",
    "廖": "liào",
    "燎": "liáo,liǎo",
    "辽": "liáo",
    "寥": "liáo",
    "尥": "liào",
    "镣": "liào",
    "钌": "liǎo,liào",
    "鹩": "liáo",
    "僇": "lù",
    "寮": "liáo",
    "缭": "liáo",
    "嫽": "liáo",
    "嘹": "liáo",
    "尞": "liáo",
    "尦": "liào",
    "屪": "liáo",
    "嶚": "liáo",
    "嶛": "liáo",
    "廫": "liáo",
    "憭": "liǎo,liáo",
    "憀": "liáo",
    "敹": "liáo",
    "漻": "liáo,liú",
    "暸": "liáo",
    "炓": "liào",
    "爎": "liáo,liǎo",
    "爒": "liáo,liǎo",
    "璙": "liáo",
    "瞭": "liǎo,liào",
    "療": "liáo",
    "窷": "liào",
    "竂": "liáo",
    "簝": "liáo",
    "膋": "liáo",
    "繚": "liáo",
    "膫": "liáo",
    "蟉": "liú",
    "蟟": "liáo",
    "豂": "liáo",
    "賿": "liáo",
    "蹘": "liáo",
    "鄝": "liǎo",
    "遼": "liáo",
    "蹽": "liāo",
    "鏐": "liú",
    "釕": "liǎo,liào",
    "镠": "liú",
    "鐐": "liào",
    "镽": "liǎo",
    "飂": "liù,liáo",
    "飉": "liáo",
    "鷯": "liáo",
    "裂": "liè,liě",
    "髎": "liáo",
    "猎": "liè",
    "劣": "liè",
    "烈": "liè",
    "埒": "liè",
    "鬣": "liè",
    "趔": "liè",
    "躐": "liè",
    "冽": "liè",
    "劦": "xié,liè",
    "劽": "liè",
    "哷": "liè,lǜ",
    "洌": "liè",
    "埓": "liè",
    "姴": "liè",
    "峢": "lǐ",
    "巤": "liè",
    "忚": "xī,liě",
    "挒": "liè",
    "浖": "liè",
    "毟": "liě",
    "烮": "liè",
    "奊": "xié",
    "煭": "liè",
    "燤": "tài,liè",
    "犣": "liè",
    "猟": "liè",
    "挘": "liě",
    "聗": "liè",
    "睙": "lì",
    "獵": "liè",
    "脟": "liè",
    "蛚": "liè",
    "迾": "liè",
    "颲": "liè",
    "鮤": "liè",
    "鬛": "liè",
    "鴷": "liè",
    "茢": "liè",
    "林": "lín",
    "淋": "lín,lìn",
    "临": "lín",
    "邻": "lín",
    "磷": "lín",
    "赁": "lìn",
    "鳞": "lín",
    "拎": "līn",
    "琳": "lín",
    "霖": "lín",
    "凛": "lǐn",
    "遴": "lín",
    "嶙": "lín",
    "蔺": "lìn",
    "粼": "lín",
    "吝": "lìn",
    "麟": "lín",
    "躏": "lìn",
    "任": "rèn,rén",
    "亃": "lǐn,lìn",
    "辚": "lín",
    "檩": "lǐn",
    "伈": "xǐn",
    "僯": "lǐn",
    "厸": "lín,miǎo",
    "壣": "lín",
    "凜": "lǐn",
    "崊": "lín",
    "悋": "lìn",
    "恡": "lìn",
    "撛": "lǐn",
    "斴": "lín",
    "懍": "lǐn",
    "晽": "lín",
    "暽": "lín",
    "涁": "shèn",
    "檁": "lǐn",
    "渗": "shèn",
    "澟": "lǐn",
    "滲": "shèn",
    "潾": "lín",
    "瀶": "lín",
    "璘": "lín",
    "橉": "lìn",
    "燐": "lín",
    "獜": "lín,lìn",
    "痳": "má,lìn",
    "甐": "lìn",
    "疄": "lín,lìn",
    "碄": "lín",
    "粦": "lín",
    "箖": "lín,lǐn",
    "焛": "lìn",
    "繗": "lín",
    "翷": "lín",
    "臨": "lín",
    "藺": "lìn",
    "蹸": "lìn",
    "躙": "lìn",
    "賃": "lìn",
    "躪": "lìn",
    "轥": "lìn",
    "菻": "lǐn,má",
    "轔": "lín",
    "鏻": "lín",
    "閵": "lìn",
    "鄰": "lín",
    "隣": "lín",
    "驎": "lín",
    "阴": "yīn",
    "魿": "líng",
    "麐": "lín",
    "鱗": "lín",
    "另": "lìng",
    "铃": "líng",
    "领": "lǐng",
    "玲": "líng",
    "岭": "lǐng,líng",
    "灵": "líng",
    "龄": "líng",
    "凌": "líng",
    "陵": "líng",
    "羚": "líng",
    "菱": "líng",
    "伶": "líng",
    "棱": "léng,lēng,líng",
    "翎": "líng",
    "绫": "líng",
    "酃": "líng",
    "瓴": "líng",
    "蛉": "líng",
    "泠": "líng",
    "呤": "líng",
    "棂": "líng",
    "鲮": "líng",
    "聆": "líng",
    "囹": "líng",
    "倰": "lèng",
    "柃": "líng",
    "刢": "líng",
    "坽": "líng",
    "冷": "lěng",
    "姈": "líng",
    "婈": "líng",
    "孁": "líng",
    "夌": "líng",
    "岺": "lǐng,líng",
    "崚": "líng,léng",
    "彾": "líng",
    "掕": "líng",
    "昤": "líng",
    "嶺": "lǐng",
    "朎": "líng",
    "櫺": "líng",
    "淩": "líng",
    "澪": "líng",
    "欞": "líng",
    "瀮": "lián",
    "炩": "lìng",
    "燯": "líng",
    "爧": "líng",
    "狑": "líng",
    "琌": "líng",
    "砱": "líng",
    "祾": "líng",
    "秢": "líng",
    "竛": "líng",
    "紷": "líng",
    "皊": "líng",
    "舲": "líng",
    "綾": "líng",
    "笭": "líng",
    "蓤": "líng",
    "蕶": "líng",
    "蘦": "lìng",
    "衑": "líng",
    "袊": "lǐng,líng",
    "蔆": "líng",
    "裬": "líng",
    "詅": "líng",
    "跉": "líng",
    "軨": "líng",
    "輘": "líng",
    "醽": "líng",
    "錂": "líng",
    "閝": "líng",
    "鈴": "líng",
    "阾": "lín",
    "霊": "líng",
    "霝": "líng",
    "霛": "líng",
    "靇": "lóng",
    "靈": "lìng",
    "領": "lǐng",
    "駖": "líng",
    "鸰": "líng",
    "鯪": "líng",
    "鹷": "líng",
    "霗": "líng",
    "麢": "líng",
    "齢": "líng",
    "齡": "líng",
    "鴒": "líng",
    "六": "liù,lù",
    "龗": "líng",
    "流": "liú",
    "留": "liú",
    "刘": "liú",
    "柳": "liǔ",
    "溜": "liū,liù",
    "瘤": "liú",
    "榴": "liú",
    "琉": "liú",
    "馏": "liù,liú",
    "陆": "lù",
    "碌": "lù,liù",
    "绺": "liǔ",
    "锍": "liǔ",
    "鎏": "liú",
    "镏": "liú",
    "浏": "liú",
    "旒": "liú",
    "骝": "liú",
    "熘": "liū",
    "遛": "liù",
    "僂": "lǚ,lóu",
    "偻": "lǚ,lóu",
    "鹨": "liù",
    "嚠": "liú",
    "塯": "liù",
    "劉": "liú",
    "媹": "liú",
    "嵧": "liú",
    "嬼": "liǔ",
    "廇": "liù",
    "懰": "liú,liǔ",
    "斿": "liú,yóu",
    "栁": "liǔ",
    "旈": "liú",
    "抡": "lūn,lún",
    "桞": "liǔ",
    "橊": "liú",
    "橮": "liǔ",
    "沠": "pài",
    "桺": "liǔ",
    "澑": "liū,liù",
    "泖": "mǎo",
    "游": "yóu",
    "熮": "liǔ",
    "瑠": "liú",
    "璢": "liú",
    "畱": "liú",
    "珋": "liǔ",
    "畄": "liú",
    "瀏": "liú",
    "瑬": "liú",
    "疁": "liú",
    "磂": "liú,liù",
    "癅": "liú",
    "磟": "liù",
    "罶": "liǔ",
    "羀": "liǔ",
    "綹": "liǔ",
    "翏": "liù",
    "膢": "lǘ",
    "蒥": "liú",
    "蓅": "liú",
    "藰": "liú,liǔ",
    "裗": "liú",
    "蹓": "liū",
    "鉚": "mǎo",
    "鋶": "liǔ",
    "鐂": "liú",
    "鎦": "liú,liù",
    "雡": "liù",
    "铆": "mǎo",
    "陸": "lù",
    "霤": "liù",
    "飀": "liú",
    "飗": "liú",
    "駠": "liú",
    "餾": "liù",
    "駵": "liú",
    "飅": "liú",
    "驑": "liú",
    "鬸": "liù",
    "騮": "liú",
    "鶹": "liú",
    "鰡": "liú",
    "鹠": "liú",
    "鷚": "liù",
    "麍": "liú",
    "囖": "luó,luō,luo",
    "龙": "lóng",
    "拢": "lǒng",
    "笼": "lóng,lǒng",
    "隆": "lóng",
    "聋": "lóng",
    "垄": "lǒng",
    "咙": "lóng",
    "窿": "lóng",
    "陇": "lǒng",
    "弄": "nòng,lòng",
    "胧": "lóng",
    "垅": "lǒng",
    "珑": "lóng",
    "泷": "lóng,shuāng",
    "栊": "lóng",
    "砻": "lóng",
    "癃": "lóng",
    "茏": "lóng",
    "儱": "lǒng,lóng,lòng",
    "哢": "lòng",
    "厐": "páng",
    "嚨": "lóng",
    "巃": "lóng",
    "壠": "lǒng",
    "壟": "lǒng",
    "嶐": "lóng",
    "巄": "lóng",
    "徿": "lòng,lǒng",
    "庞": "páng",
    "昽": "lóng",
    "攏": "lǒng",
    "曨": "lóng",
    "梇": "lòng",
    "槞": "lóng",
    "朧": "lóng",
    "湰": "lóng",
    "总": "zǒng",
    "櫳": "lóng",
    "滝": "lóng",
    "漋": "lóng",
    "爖": "lóng",
    "瀧": "lóng,shuāng",
    "矓": "lóng",
    "瓏": "lóng",
    "硦": "luò,lòng",
    "礲": "lóng",
    "礱": "lóng",
    "竉": "lǒng",
    "竜": "lóng",
    "篭": "lóng,lǒng",
    "眬": "lóng",
    "籠": "lóng,lǒng",
    "蕯": "sà",
    "聾": "lóng",
    "蠬": "lóng",
    "蘢": "lóng",
    "衖": "xiàng",
    "襱": "lóng",
    "豅": "lóng",
    "蠪": "lóng",
    "躘": "lóng,lǒng",
    "鏧": "lóng",
    "鑨": "lóng",
    "霳": "lóng",
    "驡": "lóng",
    "隴": "lǒng",
    "贚": "lòng",
    "鸗": "lóng",
    "龒": "lóng",
    "龐": "páng",
    "龓": "lóng,lǒng",
    "龍": "lóng,lǒng",
    "楼": "lóu",
    "搂": "lǒu,lōu",
    "漏": "lòu",
    "陋": "lòu",
    "露": "lòu,lù",
    "娄": "lóu",
    "蝼": "lóu",
    "镂": "lòu",
    "喽": "lóu,lou",
    "髅": "lóu",
    "嘍": "lóu,lou",
    "嵝": "lǒu",
    "塿": "lǒu",
    "婁": "lóu",
    "瘘": "lòu",
    "耧": "lóu",
    "屚": "lòu",
    "廔": "lóu",
    "慺": "lóu,lǚ",
    "嶁": "lǒu",
    "溇": "lóu",
    "摟": "lǒu,lōu",
    "樓": "lóu",
    "漊": "lóu",
    "熡": "lóu",
    "甊": "lǒu",
    "瘻": "lòu",
    "瘺": "lòu",
    "瞜": "lóu,lǘ,lou",
    "艛": "lóu",
    "耬": "lóu",
    "謱": "lóu",
    "螻": "lóu",
    "遱": "lóu",
    "鞻": "lóu",
    "軁": "lóu",
    "录": "lù",
    "髏": "lóu",
    "鏤": "lòu",
    "路": "lù",
    "鹿": "lù",
    "炉": "lú",
    "鲁": "lǔ",
    "卤": "lǔ",
    "颅": "lú",
    "庐": "lú",
    "绿": "lǜ,lù",
    "虏": "lǔ",
    "戮": "lù",
    "赂": "lù",
    "掳": "lǔ",
    "潞": "lù",
    "禄": "lù",
    "麓": "lù",
    "栌": "lú",
    "渌": "lù",
    "泸": "lú",
    "轳": "lú",
    "鲈": "lú",
    "氇": "lǔ",
    "簏": "lù",
    "橹": "lǔ",
    "垆": "lú",
    "胪": "lú",
    "镥": "lǔ",
    "辘": "lù",
    "漉": "lù",
    "撸": "lū",
    "噜": "lū",
    "璐": "lù",
    "鸬": "lú",
    "鹭": "lù",
    "舻": "lú",
    "侓": "lù",
    "勎": "lù",
    "勠": "lù",
    "嚧": "lú",
    "嚕": "lū",
    "塶": "lù",
    "坴": "lù",
    "塷": "lǔ",
    "圥": "lù",
    "峍": "lù",
    "廘": "lù",
    "娽": "lù",
    "彔": "lù",
    "挔": "lǚ",
    "壚": "lú",
    "捋": "luō,lǚ",
    "捛": "lǚ",
    "摝": "lù",
    "廬": "lú",
    "摅": "shū",
    "擄": "lǔ",
    "擼": "lū",
    "攎": "lú,luó",
    "枦": "lú",
    "攄": "shū",
    "椂": "lù",
    "樐": "lǔ",
    "淕": "lù",
    "櫨": "lú",
    "氌": "lǔ",
    "滤": "lǜ",
    "淥": "lù",
    "櫓": "lǔ",
    "澛": "lǔ",
    "滷": "lǔ",
    "瀂": "lǔ",
    "瀘": "lú",
    "獹": "lú",
    "爐": "lú",
    "玈": "lú",
    "琭": "lù",
    "瓐": "lú",
    "甪": "lù",
    "濾": "lǜ",
    "盝": "lù",
    "睩": "lù",
    "矑": "lú",
    "硉": "lù",
    "硵": "lǔ",
    "磠": "lǔ",
    "稑": "lù",
    "祿": "lù",
    "簶": "lù",
    "箓": "lù",
    "籚": "lú",
    "簬": "lù",
    "籙": "lù",
    "簵": "lù",
    "粶": "lù",
    "罏": "lú",
    "纑": "lú",
    "膟": "lǜ",
    "緑": "lǜ,lù",
    "舮": "lú",
    "艣": "lǔ",
    "艪": "lǔ",
    "菉": "lù",
    "蓾": "lǔ",
    "艫": "lú",
    "蕗": "lù",
    "蘆": "lú",
    "臚": "lú",
    "螰": "lù",
    "虜": "lǔ",
    "虂": "lù",
    "蠦": "lú",
    "觮": "jué",
    "踛": "lù",
    "賂": "lù",
    "蹗": "lù",
    "轆": "lù",
    "醁": "lù",
    "轤": "lú",
    "趢": "lù",
    "鈩": "lú",
    "錄": "lù",
    "録": "lù",
    "錴": "lù",
    "鏀": "lǔ",
    "鏴": "lù",
    "鐪": "lǔ",
    "騄": "lù",
    "顱": "lú",
    "鑥": "lǔ",
    "騼": "lù",
    "髗": "lú",
    "魲": "lú",
    "魯": "lǔ",
    "鯥": "lù",
    "鑪": "lú",
    "鴼": "lù",
    "鵦": "lù",
    "鱸": "lú",
    "鵱": "lù",
    "鷺": "lù",
    "鹵": "lǔ",
    "鸕": "lú",
    "乱": "luàn",
    "滦": "luán",
    "峦": "luán",
    "孪": "luán",
    "栾": "luán",
    "黸": "lú",
    "乿": "zhì,luàn",
    "銮": "luán",
    "鸾": "luán",
    "圝": "luán",
    "圞": "luán",
    "亂": "luàn",
    "孿": "luán",
    "奱": "luán",
    "曫": "luán",
    "灓": "luán,luàn",
    "巒": "luán",
    "癵": "luán",
    "癴": "luán",
    "欒": "luán",
    "羉": "luán",
    "灤": "luán",
    "臡": "ní,luán",
    "臠": "luán",
    "薍": "wàn,luàn",
    "虊": "luán",
    "覶": "luó,luǎn",
    "鵉": "luán",
    "鑾": "luán",
    "鸞": "luán",
    "釠": "luàn",
    "略": "lüè",
    "掠": "lüè",
    "锊": "lüè",
    "剠": "qíng",
    "畧": "lüè",
    "圙": "lüè",
    "率": "shuài,lǜ",
    "稤": "lüè",
    "寽": "lüè,luó",
    "药": "yào",
    "鋢": "lüè",
    "藥": "yào",
    "鋝": "lüè",
    "论": "lùn,lún",
    "轮": "lún",
    "伦": "lún",
    "仑": "lún",
    "囵": "lún",
    "圇": "lún",
    "侖": "lún",
    "埨": "lǔn",
    "婨": "lún",
    "倫": "lún",
    "崘": "lún",
    "崙": "lún",
    "惀": "lǔn,lùn",
    "棆": "lún",
    "溣": "lùn",
    "磮": "lún",
    "掄": "lūn,lún",
    "碖": "lún,lǔn,lùn",
    "稐": "lǔn",
    "耣": "lún,lǔn",
    "腀": "lún",
    "菕": "lún",
    "蜦": "lún",
    "踚": "lún",
    "論": "lùn,lún",
    "陯": "lún",
    "鯩": "lún",
    "輪": "lún",
    "罗": "luó",
    "锣": "luó",
    "裸": "luǒ",
    "骡": "luó",
    "箩": "luó",
    "螺": "luó",
    "萝": "luó",
    "洛": "luò",
    "逻": "luó",
    "荦": "luò",
    "倮": "luǒ",
    "雒": "luò",
    "椤": "luó",
    "脶": "luó",
    "瘰": "luǒ",
    "摞": "luò",
    "镙": "luó",
    "泺": "luò,pō",
    "儸": "luó",
    "剆": "luǒ",
    "啰": "luō,luó,luo",
    "囉": "luō,luó,luo",
    "猡": "luó",
    "挼": "ruó",
    "峈": "luò",
    "攞": "luó",
    "捰": "wǒ,luò,luǒ",
    "曪": "luǒ",
    "欏": "luó",
    "烁": "shuò",
    "癳": "luǒ",
    "爍": "shuò",
    "犖": "luò",
    "笿": "luò",
    "籮": "luó",
    "羅": "luó",
    "臝": "luǒ",
    "腡": "luó",
    "纙": "luò",
    "蓏": "luǒ",
    "覼": "luó",
    "蘿": "luó",
    "躶": "luǒ",
    "邏": "luó",
    "頱": "luō",
    "饠": "luó",
    "鑼": "luó",
    "鸁": "luó",
    "鏍": "luó",
    "騾": "luó",
    "驘": "luó",
    "铝": "lǚ",
    "驴": "lǘ",
    "屡": "lǚ",
    "吕": "lǚ",
    "律": "lǜ",
    "缕": "lǚ",
    "氯": "lǜ",
    "侣": "lǚ",
    "履": "lǚ",
    "旅": "lǚ",
    "膂": "lǚ",
    "榈": "lǘ",
    "闾": "lǘ",
    "褛": "lǚ",
    "稆": "lǚ",
    "儢": "lǚ",
    "勴": "lǜ",
    "侶": "lǚ",
    "卛": "shuài,lǜ",
    "垏": "lǜ",
    "嵂": "lǜ",
    "屢": "lǚ",
    "呂": "lǚ",
    "曥": "lú",
    "慮": "lǜ",
    "焒": "lǚ",
    "梠": "lǚ",
    "爈": "lǜ",
    "櫚": "lǘ",
    "穞": "lǔ",
    "祣": "lǚ",
    "穭": "lǚ",
    "箻": "lǜ",
    "絽": "lǚ",
    "繂": "lǜ",
    "縷": "lǚ",
    "綠": "lǜ",
    "葎": "lǜ",
    "藘": "lǘ",
    "郘": "lǚ",
    "鑢": "lǜ",
    "鋁": "lǚ",
    "膐": "lǚ",
    "閭": "lǘ",
    "馿": "lú",
    "褸": "lǚ",
    "鷜": "lóu,lǚ",
    "呣": "m",
    "驢": "lǘ",
    "吗": "má,mǎ,ma",
    "妈": "mā",
    "马": "mǎ",
    "嘛": "má,ma",
    "麻": "má",
    "码": "mǎ",
    "骂": "mà",
    "抹": "mǒ,mò,mā",
    "玛": "mǎ",
    "蟆": "má,mò",
    "唛": "mà",
    "犸": "mǎ",
    "嬷": "mó",
    "蚂": "mǎ,mā,mà",
    "么": "yāo,mó,ma,me",
    "摩": "mó,mā",
    "亇": "gè,mā",
    "傌": "mà",
    "杩": "mà,mǎ",
    "呐": "nà,nè",
    "嗎": "má,mǎ,ma",
    "嘜": "mà",
    "媽": "mā",
    "嫲": "mā,má",
    "孖": "zī,mā",
    "尛": "mó",
    "嬤": "mó",
    "榪": "mà,mā",
    "犘": "má",
    "獁": "mǎ",
    "溤": "mǎ",
    "痲": "má",
    "瑪": "mǎ",
    "睰": "mà",
    "碼": "mǎ",
    "祃": "mà",
    "禡": "mà",
    "礣": "miè",
    "罵": "mà",
    "蔴": "má",
    "蓦": "mò",
    "螞": "mǎ,mā,mà",
    "遤": "mǎ",
    "貊": "mò",
    "鎷": "mǎ",
    "蟇": "má",
    "閁": "mà",
    "靡": "mí",
    "驀": "mò",
    "馬": "mǎ",
    "鬕": "mà",
    "鰢": "mǎ",
    "駡": "mà",
    "鷌": "mǎ",
    "麼": "mó,me",
    "买": "mǎi",
    "麽": "mó,me",
    "卖": "mài",
    "迈": "mài",
    "埋": "mái,mán",
    "麦": "mài",
    "劢": "mài",
    "脉": "mài,mò",
    "荬": "mǎi",
    "佅": "mài",
    "咪": "mī",
    "勱": "mài",
    "嘪": "mǎi",
    "売": "mài",
    "脈": "mài",
    "衇": "mài",
    "薶": "mái,wō",
    "蕒": "mǎi",
    "買": "mǎi",
    "邁": "mài",
    "霡": "mài",
    "鷶": "mǎi",
    "霢": "mài",
    "麥": "mài",
    "满": "mǎn",
    "賣": "mài",
    "慢": "màn",
    "瞒": "mán,mén",
    "漫": "màn",
    "蛮": "mán",
    "蔓": "màn,wàn",
    "曼": "màn",
    "馒": "mán",
    "谩": "mán",
    "幔": "màn",
    "螨": "mǎn",
    "墁": "màn",
    "颟": "mān",
    "鳗": "mán",
    "熳": "màn",
    "缦": "màn",
    "镘": "màn",
    "僈": "màn",
    "嫚": "màn",
    "姏": "mán",
    "鞔": "mán,mèn",
    "屘": "mǎn",
    "慲": "mán",
    "悗": "mán,mèn",
    "摱": "mán,màn",
    "槾": "màn,wàn",
    "澫": "wàn,màn",
    "幕": "mù",
    "澷": "màn",
    "獌": "màn",
    "満": "mǎn",
    "睌": "miǎn",
    "滿": "mǎn",
    "矕": "mǎn,mán",
    "絻": "miǎn,wèn,mán,wàn",
    "蔄": "màn",
    "瞞": "mán,mén",
    "蘰": "màn",
    "蟃": "wàn",
    "縵": "màn",
    "襔": "mǎn",
    "蠻": "mán",
    "蟎": "mǎn",
    "鄤": "màn",
    "謾": "mán",
    "鏋": "mǎn",
    "鏝": "màn",
    "鬗": "mán",
    "顢": "mān",
    "饅": "mán",
    "鰻": "mán",
    "忙": "máng",
    "鬘": "mán",
    "莽": "mǎng",
    "盲": "máng",
    "氓": "méng,máng",
    "硭": "máng",
    "邙": "máng",
    "蟒": "mǎng,měng",
    "漭": "mǎng",
    "吂": "máng",
    "娏": "máng",
    "厖": "máng",
    "尨": "lóng,máng,méng,páng",
    "哤": "máng",
    "恾": "máng",
    "庬": "máng,méng,páng",
    "朦": "méng",
    "杗": "máng",
    "杧": "máng",
    "壾": "mǎng",
    "牤": "māng",
    "浝": "máng",
    "汒": "máng",
    "牻": "máng",
    "狵": "máng,dòu",
    "甿": "méng",
    "盳": "máng,wàng",
    "笀": "máng",
    "瞢": "méng,měng",
    "痝": "máng",
    "茻": "mǎng",
    "蘉": "máng",
    "蠎": "mǎng",
    "釯": "máng",
    "鋩": "máng",
    "铓": "máng",
    "莾": "mǎng",
    "駹": "máng",
    "鸏": "méng",
    "鹲": "méng",
    "毛": "máo",
    "冒": "mào,mò",
    "帽": "mào",
    "矛": "máo",
    "猫": "māo,máo",
    "卯": "mǎo",
    "貌": "mào",
    "茂": "mào",
    "贸": "mào",
    "锚": "máo",
    "茅": "máo",
    "耄": "mào",
    "茆": "máo",
    "蝥": "máo",
    "懋": "mào",
    "髦": "máo",
    "昴": "mǎo",
    "瞀": "mào",
    "袤": "mào",
    "牦": "máo",
    "瑁": "mào",
    "蟊": "máo",
    "冃": "mào",
    "旄": "máo,mào",
    "侔": "móu",
    "冐": "mào",
    "冇": "mǎo",
    "勖": "xù",
    "務": "wù",
    "夘": "mǎo,wǎn",
    "堥": "máo,móu,wǔ",
    "媢": "mào",
    "嵍": "wù,máo",
    "峁": "mǎo",
    "愗": "mào",
    "戼": "mǎo",
    "暓": "mào",
    "枆": "máo",
    "描": "miáo",
    "毣": "mù",
    "渵": "máo",
    "毷": "mào",
    "楙": "máo",
    "皃": "mào",
    "獏": "mò",
    "眊": "mào",
    "牟": "móu,mù",
    "笷": "mǎo",
    "緢": "miáo,máo",
    "罞": "máo",
    "芼": "máo,mào",
    "萺": "mào",
    "蓩": "mǎo",
    "覒": "mào",
    "蝐": "mào",
    "蛑": "móu",
    "軞": "máo",
    "貿": "mào",
    "貓": "māo,máo",
    "鄚": "mào",
    "鄮": "mào",
    "鉾": "máo",
    "酕": "máo",
    "霿": "méng",
    "髳": "máo,méng",
    "鶜": "máo",
    "錨": "máo",
    "嚜": "mèi,me,mò",
    "嚒": "mē",
    "嚰": "mè",
    "庅": "mó,mā,me",
    "濹": "mè",
    "癦": "mèng",
    "没": "méi,mò",
    "孭": "miē",
    "每": "měi",
    "镁": "měi",
    "美": "měi",
    "酶": "méi",
    "妹": "mèi",
    "枚": "méi",
    "霉": "méi",
    "煤": "méi",
    "玫": "méi",
    "梅": "méi",
    "寐": "mèi",
    "眉": "méi",
    "糜": "mí,méi",
    "媒": "méi",
    "昧": "mèi",
    "谜": "mí",
    "媚": "mèi",
    "嵋": "méi",
    "猸": "méi",
    "沫": "mò",
    "湄": "méi",
    "浼": "měi",
    "鹛": "méi",
    "莓": "méi",
    "袂": "mèi",
    "镅": "méi",
    "魅": "mèi",
    "凂": "měi",
    "呅": "wěn",
    "楣": "méi",
    "味": "wèi",
    "堳": "méi",
    "塺": "méi",
    "坶": "mù,mǔ",
    "媄": "měi",
    "媺": "měi",
    "墨": "mò",
    "嬍": "měi",
    "嵄": "měi",
    "抺": "mèi",
    "挴": "měi",
    "攟": "jùn",
    "攗": "méi",
    "某": "mǒu",
    "栂": "méi",
    "楳": "méi",
    "槑": "méi",
    "櫗": "miè,mèi",
    "毎": "měi",
    "徾": "méi",
    "氼": "nì",
    "湈": "méi",
    "渼": "měi",
    "煝": "mèi",
    "溦": "wēi",
    "沒": "méi,mò",
    "燘": "měi",
    "珻": "méi",
    "瑂": "méi",
    "眛": "mèi",
    "痗": "mèi",
    "睂": "méi",
    "睸": "mèi",
    "矀": "wéi",
    "祙": "mèi",
    "篃": "mèi",
    "脄": "méi",
    "禖": "méi",
    "腜": "méi",
    "脢": "méi",
    "蘪": "mí",
    "葿": "méi",
    "跊": "mèi",
    "蝞": "mèi",
    "躾": "měi",
    "苺": "méi",
    "郿": "méi",
    "鎂": "měi",
    "韎": "mèi,wà",
    "鬽": "mèi",
    "鎇": "méi",
    "黣": "měi",
    "鶥": "méi",
    "黴": "méi",
    "鋂": "méi,méng",
    "门": "mén",
    "们": "mén",
    "闷": "mèn,mēn",
    "亹": "wěi,mén",
    "焖": "mèn",
    "扪": "mén",
    "钔": "mén",
    "們": "mén",
    "怋": "mín,mén",
    "懑": "mèn",
    "懣": "mèn",
    "悶": "mèn,mēn",
    "暪": "mèn",
    "捫": "mén",
    "汶": "wèn,mén",
    "玣": "biàn",
    "燜": "mèn",
    "玧": "mén,yǔn",
    "穈": "mén,méi",
    "璊": "mén",
    "菛": "mén",
    "虋": "mén",
    "椚": "mēn",
    "玟": "mín,wén",
    "鍆": "mén",
    "閅": "mén",
    "門": "mén",
    "梦": "mèng",
    "蒙": "mēng,méng,měng",
    "猛": "měng",
    "锰": "měng",
    "孟": "mèng",
    "盟": "méng",
    "萌": "méng",
    "檬": "méng",
    "礞": "méng",
    "勐": "měng",
    "蜢": "měng",
    "懵": "měng",
    "甍": "méng",
    "蠓": "měng",
    "儚": "méng",
    "虻": "méng",
    "艋": "měng",
    "冡": "měng",
    "艨": "méng",
    "夣": "mèng",
    "幪": "méng",
    "懜": "mèng,méng,měng",
    "嫇": "míng,mǐng",
    "夢": "mèng",
    "掹": "mēng",
    "擝": "mēng",
    "曚": "méng",
    "明": "míng",
    "橗": "méng",
    "氋": "méng",
    "懞": "méng,měng",
    "溕": "méng",
    "獴": "méng",
    "瓾": "wā",
    "濛": "méng",
    "矒": "méng,měng",
    "瞑": "míng",
    "莔": "méng",
    "矇": "mēng",
    "萠": "pān",
    "蕄": "méng",
    "蝱": "méng",
    "鄳": "méng",
    "錳": "měng",
    "雺": "wù,méng",
    "霚": "wù",
    "霥": "mèng",
    "鄸": "méng",
    "靀": "méng",
    "顭": "méng",
    "霧": "wù",
    "饛": "méng",
    "鯍": "méng",
    "鯭": "měng",
    "鱦": "yìng",
    "黽": "mǐn,miǎn,měng",
    "黾": "mǐn,miǎn,měng",
    "鼆": "měng",
    "踎": "móu",
    "米": "mǐ",
    "密": "mì",
    "眯": "mī,mí",
    "迷": "mí",
    "蜜": "mì",
    "觅": "mì",
    "幂": "mì",
    "弥": "mí,mǐ",
    "醚": "mí",
    "蘼": "mí",
    "縻": "mí",
    "汨": "mì",
    "麋": "mí",
    "祢": "mí",
    "猕": "mí",
    "弭": "mǐ",
    "芈": "mǐ",
    "谧": "mì",
    "脒": "mǐ",
    "敉": "mǐ",
    "嘧": "mì",
    "糸": "mì,sī",
    "侎": "mǐ",
    "冖": "mì",
    "冞": "mí",
    "劘": "mó",
    "冪": "mì",
    "孊": "mǐ",
    "宻": "mì",
    "塓": "mì",
    "峚": "mì",
    "幎": "mì",
    "幦": "mì",
    "戂": "mí,mó",
    "幺": "yāo",
    "彌": "mí,mǐ",
    "擟": "mí",
    "摵": "sè,mí,sù",
    "擵": "mó",
    "攠": "mí,mǐ,mó",
    "榓": "mì",
    "樒": "mì",
    "檷": "nǐ,mí",
    "櫁": "mì",
    "淧": "mì",
    "洣": "mǐ",
    "渳": "mǐ",
    "滵": "mì",
    "漞": "mì",
    "溟": "míng",
    "濔": "mǐ,nǐ",
    "濗": "mì",
    "瀰": "mí",
    "灖": "mǐ",
    "熐": "mì",
    "爢": "mí",
    "獯": "xūn",
    "眫": "pàng,pán",
    "眽": "mò",
    "瓕": "mí,xǐ",
    "瞇": "mī,mí",
    "祕": "mì,bì",
    "瞴": "wǔ,mí",
    "禰": "mí",
    "簚": "mì,miè",
    "獼": "mí",
    "籋": "niè",
    "粎": "mǐ",
    "羋": "mǐ",
    "蒾": "mí",
    "罙": "shēn",
    "蓂": "míng",
    "葞": "mǐ",
    "蔝": "mǐ",
    "羃": "mì",
    "藌": "mí",
    "蝆": "yǎng",
    "蔤": "mì",
    "袮": "mí",
    "覔": "mì",
    "覛": "mì",
    "詸": "mí",
    "覓": "mì",
    "醾": "mí",
    "謎": "mí",
    "謐": "mì",
    "醿": "mí",
    "釄": "mí",
    "銤": "mǐ",
    "鑖": "miè",
    "鸍": "mí",
    "镾": "mí",
    "麊": "mí",
    "鼏": "mì",
    "面": "miàn",
    "免": "miǎn",
    "麛": "mí",
    "绵": "mián",
    "棉": "mián",
    "眠": "mián",
    "缅": "miǎn",
    "冕": "miǎn",
    "勉": "miǎn",
    "娩": "miǎn",
    "腼": "miǎn",
    "湎": "miǎn",
    "眄": "miǎn",
    "偭": "miǎn",
    "丏": "miǎn",
    "沔": "miǎn",
    "渑": "miǎn,shéng",
    "勔": "miǎn",
    "喕": "miǎn",
    "冥": "míng",
    "婂": "mián",
    "媔": "mián,miǎn",
    "嬵": "mián",
    "愐": "miǎn",
    "檰": "mián",
    "櫋": "mián",
    "汅": "miǎn",
    "泯": "mǐn",
    "矈": "mián",
    "矊": "mián",
    "糆": "miàn",
    "澠": "miǎn,shéng",
    "緜": "mián",
    "綿": "mián",
    "芇": "mián",
    "莬": "wèn,wǎn,miǎn",
    "矏": "mián",
    "緬": "miǎn",
    "葂": "miǎn",
    "蝒": "mián",
    "蠠": "mǐn",
    "靣": "miàn",
    "鮸": "miǎn",
    "麫": "miàn",
    "靦": "miǎn",
    "麪": "miàn",
    "麺": "miàn",
    "麵": "miàn",
    "秒": "miǎo",
    "苗": "miáo",
    "庙": "miào",
    "藐": "miǎo",
    "妙": "miào",
    "瞄": "miáo",
    "眇": "miǎo",
    "渺": "miǎo",
    "缈": "miǎo",
    "淼": "miǎo",
    "喵": "miāo",
    "杪": "miǎo",
    "媌": "miáo",
    "嫹": "miáo",
    "鹋": "miáo",
    "邈": "miǎo",
    "庿": "miào",
    "玅": "miào",
    "廟": "miào",
    "竗": "miào",
    "彯": "piāo,piào",
    "篎": "miǎo",
    "紗": "shā",
    "纱": "shā",
    "蜱": "pí",
    "鱙": "yáo",
    "鶓": "miáo",
    "緲": "miǎo",
    "灭": "miè",
    "咩": "miē",
    "篾": "miè",
    "蠛": "miè",
    "乜": "miē,niè",
    "吀": "miē",
    "哶": "miē",
    "幭": "miè",
    "懱": "miè",
    "搣": "miè",
    "蔑": "miè",
    "滅": "miè",
    "瀎": "miè,mò",
    "眜": "mò,miè",
    "薎": "miè",
    "衊": "miè",
    "覕": "piē,miè",
    "谂": "shěn",
    "民": "mín",
    "抿": "mǐn",
    "鱴": "miè",
    "敏": "mǐn",
    "闽": "mǐn",
    "皿": "mǐn",
    "珉": "mín",
    "悯": "mǐn",
    "闵": "mǐn",
    "苠": "mín",
    "鳘": "mǐn",
    "僶": "mǐn",
    "冧": "lín",
    "冺": "mǐn",
    "刡": "mǐn",
    "岷": "mín",
    "勄": "mǐn",
    "呡": "wěn,mǐn",
    "垊": "mín",
    "姄": "mín",
    "崏": "mín",
    "忞": "mǐn,wěn,mín",
    "慜": "mín",
    "捪": "mín",
    "敯": "mǐn",
    "旻": "mín",
    "憫": "mǐn",
    "旼": "mín",
    "暋": "mǐn,mín",
    "渂": "wèn,mín",
    "琘": "mín",
    "潣": "mǐn",
    "琝": "mín",
    "瑉": "mín",
    "盷": "xián,tián",
    "盿": "mín",
    "砇": "mín",
    "碈": "mín",
    "笢": "mǐn",
    "笽": "mǐn",
    "簢": "mǐn",
    "痻": "mín",
    "罠": "mín",
    "繩": "shéng",
    "绳": "shéng",
    "賯": "xiōng,mín",
    "鈱": "mín",
    "錉": "mín",
    "鍲": "mín",
    "閔": "mǐn",
    "閩": "mǐn",
    "鴖": "mín",
    "鰵": "mǐn",
    "名": "míng",
    "命": "mìng",
    "铭": "míng",
    "螟": "míng",
    "暝": "míng",
    "佲": "mǐng",
    "茗": "míng",
    "凕": "mǐng",
    "姳": "mǐng",
    "慏": "mǐng",
    "掵": "mìng",
    "鸣": "míng",
    "酩": "mǐng",
    "朙": "míng",
    "榠": "míng",
    "洺": "míng",
    "猽": "míng",
    "眀": "míng",
    "眳": "míng",
    "覭": "míng",
    "銘": "míng",
    "鳴": "míng",
    "詺": "míng",
    "鄍": "míng",
    "谬": "miù",
    "摸": "mō",
    "謬": "miù",
    "磨": "mó,mò",
    "末": "mò",
    "膜": "mó",
    "莫": "mò,mù",
    "默": "mò",
    "模": "mó,mú",
    "魔": "mó",
    "摹": "mó",
    "陌": "mò",
    "漠": "mò",
    "蘑": "mó",
    "万": "wàn,mò",
    "无": "wú",
    "寞": "mò",
    "秣": "mò",
    "殁": "mò",
    "镆": "mò",
    "瘼": "mò",
    "嫫": "mó",
    "馍": "mó",
    "谟": "mó",
    "貘": "mò",
    "劰": "miǎo",
    "茉": "mò",
    "耱": "mò",
    "嗼": "mò",
    "嚤": "mō",
    "勿": "wù",
    "嚩": "pó",
    "圽": "mò",
    "塻": "mò",
    "妺": "mò",
    "帓": "mò,wà",
    "嫼": "mò",
    "帞": "mò",
    "帕": "pà",
    "怽": "mì",
    "昩": "mò",
    "枺": "mò",
    "橅": "mó",
    "歾": "mò,wěn",
    "暯": "mù",
    "懡": "mǒ",
    "歿": "mò",
    "爅": "mò",
    "皌": "mò",
    "眿": "mò",
    "無": "wú",
    "瞐": "mò",
    "瞙": "mò",
    "砞": "mò",
    "礳": "mò",
    "粖": "yù",
    "糢": "mó",
    "縸": "mù,mò",
    "纆": "mò",
    "莈": "mò",
    "艒": "mù",
    "藦": "mò",
    "蛨": "mò",
    "蟔": "mò",
    "絈": "mò",
    "謩": "mó",
    "譕": "wú",
    "袜": "wà",
    "貃": "mò",
    "謨": "mó",
    "銆": "mò",
    "靺": "mò",
    "饝": "mó",
    "鏌": "mò",
    "饃": "mó",
    "髍": "mó",
    "魩": "mò",
    "魹": "mó",
    "麿": "mí",
    "黙": "mò",
    "谋": "móu",
    "鍪": "móu",
    "劺": "móu",
    "哞": "mōu",
    "婺": "wù",
    "厶": "sī,mǒu",
    "眸": "móu",
    "敄": "wù,móu",
    "桙": "yú,móu",
    "洠": "sì",
    "毋": "wú",
    "恈": "móu",
    "謀": "móu",
    "鞪": "mù,móu",
    "鴾": "móu",
    "蟱": "wú",
    "麰": "móu",
    "木": "mù",
    "母": "mǔ",
    "亩": "mǔ",
    "目": "mù",
    "牧": "mù",
    "墓": "mù",
    "穆": "mù",
    "暮": "mù",
    "慕": "mù",
    "牡": "mǔ",
    "拇": "mǔ",
    "睦": "mù",
    "钼": "mù",
    "毪": "mú",
    "沐": "mù",
    "凩": "mù",
    "仫": "mù",
    "姆": "mǔ",
    "苜": "mù",
    "墲": "wú",
    "娒": "wǔ,mǔ",
    "幙": "mù",
    "峔": "mǔ",
    "楘": "mù",
    "樢": "niǎo,mù",
    "慔": "mù",
    "氁": "mú",
    "炑": "mù",
    "牳": "mǔ",
    "畆": "mǔ",
    "畒": "mǔ",
    "畮": "mǔ",
    "畞": "mǔ",
    "畝": "mǔ",
    "砪": "mǔ",
    "胟": "mǔ",
    "蚞": "mù",
    "踇": "mǔ",
    "鉧": "mǔ",
    "狇": "mù",
    "雮": "mù",
    "旀": "mèi",
    "莯": "mù",
    "丆": "hǎn",
    "鉬": "mù",
    "椧": "mìng",  # Unknow.
    "那": "nà,nǎ,nèi,nā",
    "拿": "ná",
    "纳": "nà",
    "哪": "nǎ,něi,na,né",
    "霂": "mù",
    "钠": "nà",
    "南": "nán,nā",
    "衲": "nà",
    "捺": "nà",
    "娜": "nà,nuó",
    "镎": "ná",
    "肭": "nà",
    "內": "nèi",
    "内": "nèi,nà",
    "乸": "nǎ",
    "吶": "nà,nè",
    "嗱": "ná",
    "妠": "nà,nàn",
    "呶": "náo",
    "拏": "ná",
    "抐": "nè,nì,ruì,nà",
    "挐": "rú,ná",
    "淰": "niǎn,shěn",
    "笝": "nà",
    "篛": "ruò",
    "箬": "ruò",
    "納": "nà",
    "蒘": "rú,ná",
    "訤": "xiáo",
    "誽": "nì,ná",
    "蒳": "nà",
    "豽": "nà",
    "軜": "nà",
    "詉": "náo",
    "蹃": "nuò",
    "雫": "nǎ",
    "鈉": "nà",
    "靹": "nà",
    "鎿": "ná",
    "魶": "nà",
    "奶": "nǎi",
    "耐": "nài",
    "氖": "nǎi",
    "萘": "nài",
    "奈": "nài",
    "艿": "nǎi",
    "柰": "nài",
    "倷": "nǎi",
    "妳": "nǐ,nǎi",
    "孻": "nái",
    "鼐": "nài",
    "掜": "nǐ,niè,yì",
    "廼": "nǎi",
    "搱": "zhì,nái",
    "摨": "zhì,nái",
    "渿": "nài",
    "熋": "xióng",
    "疓": "nǎi",
    "腉": "nái",
    "螚": "nài,něng",
    "褦": "nài",
    "能": "néng,nài",
    "迺": "nǎi",
    "釢": "nǎi",
    "男": "nán",
    "难": "nán,nàn,nuó",
    "赧": "nǎn",
    "囡": "nān",
    "錼": "nài",
    "蝻": "nǎn",
    "楠": "nán",
    "侽": "nán",
    "喃": "nán",
    "腩": "nǎn",
    "婻": "nàn",
    "弇": "yǎn",
    "娚": "nán",
    "戁": "nǎn",
    "抩": "nán",
    "揇": "nǎn",
    "暔": "nán",
    "枏": "nán",
    "枬": "zhān",
    "摊": "tān",
    "攤": "tān",
    "柟": "nán",
    "湳": "nǎn",
    "煵": "nǎn",
    "畘": "nán",
    "莮": "nán",
    "萳": "nǎn",
    "諵": "nán,nàn",
    "遖": "nán",
    "難": "nán,nàn,nuó",
    "囊": "náng,nāng",
    "馕": "náng,nǎng",
    "曩": "nǎng",
    "乪": "náng",
    "囔": "nāng",
    "儾": "nàng,nāng",
    "哝": "nóng",
    "攮": "nǎng",
    "嚢": "náng",
    "噥": "nóng",
    "搑": "róng,náng,nǎng",
    "擃": "nǎng",
    "欜": "náng",
    "瀼": "ráng,nǎng",
    "灢": "nǎng",
    "蠰": "náng",
    "憹": "náo,nǎo,náng",
    "譨": "nóng",
    "鬞": "nóng",
    "齉": "nàng",
    "饢": "náng",
    "闹": "nào",
    "蘘": "ráng",
    "脑": "nǎo",
    "恼": "nǎo",
    "孬": "nāo",
    "铙": "náo",
    "挠": "náo",
    "垴": "nǎo",
    "猱": "náo",
    "蛲": "náo",
    "硇": "náo",
    "匘": "nǎo",
    "瑙": "nǎo",
    "夒": "náo",
    "堖": "nǎo",
    "嫐": "nǎo",
    "峱": "náo",
    "嶩": "náo",
    "巎": "náo",
    "怓": "náo,niú",
    "悩": "nǎo",
    "惱": "nǎo",
    "檂": "nóng",
    "撓": "náo",
    "獶": "náo,nǎo,yōu",
    "碯": "nǎo",
    "橈": "ráo,náo",
    "脳": "nǎo",
    "獿": "náo,yōu",
    "腝": "ruǎn",
    "腦": "nǎo",
    "譊": "náo",
    "蟯": "náo",
    "閙": "nào",
    "鐃": "náo",
    "蝚": "róu",
    "鬧": "nào",
    "讷": "nè",
    "眲": "nè",
    "呢": "ní,ne",
    "娞": "něi,suī",
    "婑": "wǒ",
    "馁": "něi",
    "氝": "nèi",
    "訥": "nè",
    "脮": "něi",
    "浽": "suī,něi",
    "腇": "něi",
    "錗": "nèi",
    "鮾": "něi",
    "餒": "něi",
    "鯘": "něi",
    "焾": "niǎn",
    "嫩": "nèn",
    "媆": "ruǎn,nèn",
    "餧": "wèi",
    "枘": "ruì",
    "莻": "gòng",  # Unknow.
    "銰": "āi",
    "嫰": "nèn",
    "鈪": "è",
    "啱": "yán",
    "恁": "nèn,nín",
    "你": "nǐ",
    "泥": "ní,nì",
    "拟": "nǐ",
    "腻": "nì",
    "逆": "nì",
    "溺": "nì,niào",
    "倪": "ní",
    "匿": "nì",
    "妮": "nī",
    "霓": "ní",
    "铌": "ní",
    "尼": "ní",
    "猊": "ní",
    "伲": "nǐ,nì",
    "昵": "nì",
    "坭": "ní",
    "睨": "nì",
    "怩": "ní",
    "鲵": "ní",
    "伱": "nǐ",
    "儞": "nǐ",
    "堄": "nì",
    "旎": "nǐ",
    "婗": "ní,nǐ",
    "嫟": "nì",
    "孨": "zhuǎn",
    "孴": "nǐ",
    "屔": "ní",
    "嬺": "nì",
    "愵": "nì",
    "嶷": "yí",
    "抳": "nǐ,ní",
    "晲": "nǐ",
    "惄": "nì",
    "擬": "nǐ",
    "棿": "ní,nǐ",
    "淣": "ní",
    "暱": "nì",
    "滠": "shè",
    "慝": "tè",
    "狔": "nǐ",
    "灄": "shè",
    "濘": "nìng",
    "痆": "niè",
    "眤": "nì",
    "秜": "ní,nì",
    "胒": "nì",
    "縌": "nì",
    "苨": "nǐ",
    "薿": "nǐ",
    "膩": "nì",
    "籾": "ní",
    "蚭": "ní",
    "蛪": "qiè,ní",
    "觬": "ní",
    "蜺": "ní",
    "貎": "ní",
    "跜": "ní",
    "輗": "ní",
    "郳": "ní",
    "鑈": "niè",
    "鉨": "xǐ",
    "鈮": "ní",
    "隬": "nǐ",
    "馜": "ní",
    "齯": "ní",
    "鯢": "ní",
    "年": "nián",
    "麑": "ní",
    "念": "niàn",
    "捻": "niǎn,niē",
    "撵": "niǎn",
    "碾": "niǎn",
    "蔫": "niān",
    "粘": "zhān",
    "黏": "nián",
    "廿": "niàn",
    "鲶": "nián",
    "辇": "niǎn",
    "鲇": "nián",
    "卄": "niàn",
    "哖": "nián",
    "姩": "nián,niàn",
    "撚": "niǎn",
    "涊": "niǎn",
    "攆": "niǎn",
    "秊": "nián",
    "秥": "nián",
    "簐": "niǎn",
    "艌": "niàn",
    "蹨": "niǎn",
    "躎": "niǎn",
    "輦": "niǎn",
    "輾": "zhǎn",
    "鮎": "nián",
    "辗": "zhǎn,niǎn",
    "鯰": "nián",
    "鵇": "nián",
    "尿": "niào,suī",
    "茑": "niǎo",
    "脲": "niào",
    "嬲": "niǎo",
    "嫋": "niǎo",
    "嬝": "niǎo",
    "蔦": "niǎo",
    "袅": "niǎo",
    "裊": "niǎo",
    "褭": "niǎo",
    "捏": "niē",
    "镍": "niè",
    "聂": "niè",
    "孽": "niè",
    "涅": "niè",
    "镊": "niè",
    "啮": "niè",
    "陧": "niè",
    "嗫": "niè",
    "蹑": "niè",
    "臬": "niè",
    "喦": "yán",
    "颞": "niè",
    "噛": "niè",
    "嚙": "niè",
    "囁": "niè",
    "囓": "niè",
    "圼": "niè",
    "孼": "niè",
    "嵒": "yán",
    "嵲": "niè",
    "嶭": "niè",
    "巕": "niè",
    "帇": "niè",
    "幸": "xìng",
    "揑": "niē",
    "摂": "shè",
    "敜": "niè",
    "摄": "shè,niè",
    "惗": "niàn",
    "攝": "shè,niè",
    "枿": "niè",
    "槷": "niè",
    "篞": "niè",
    "櫱": "niè",
    "糱": "niè",
    "糵": "niè",
    "肀": "yù",
    "聶": "niè",
    "苶": "nié",
    "臲": "niè",
    "菍": "niè,rěn",
    "蠥": "niè",
    "褹": "yì",
    "讘": "niè",
    "踂": "niè",
    "諗": "shěn",
    "踙": "niè",
    "銸": "zhé,niè",
    "鉩": "xǐ",
    "踗": "niè",
    "躡": "niè",
    "鋷": "zuì,niè",
    "錜": "niè",
    "鎳": "niè",
    "钀": "niè",
    "鑷": "niè",
    "闑": "niè",
    "隉": "niè",
    "齧": "niè",
    "囜": "nín",
    "您": "nín",
    "拰": "nǐn",
    "脌": "nín",
    "顳": "niè",
    "凝": "níng",
    "宁": "níng,nìng,zhù",
    "狞": "níng",
    "泞": "nìng",
    "拧": "níng,nǐng,nìng",
    "佞": "nìng",
    "侫": "nìng",
    "咛": "níng",
    "儜": "níng",
    "聍": "níng",
    "嬣": "níng",
    "嚀": "níng",
    "寍": "níng,nìng",
    "寕": "níng,nìng",
    "寗": "níng,nìng",
    "甯": "níng,nìng",
    "寜": "níng,nìng",
    "寧": "níng,nìng",
    "橣": "níng",
    "攘": "rǎng",
    "澝": "nìng",
    "檸": "níng",
    "擰": "níng,nǐng,nìng",
    "獰": "níng",
    "疑": "yí,nǐ",
    "苧": "zhù,níng",
    "聹": "níng",
    "鑏": "níng",
    "薴": "níng",
    "鬡": "níng",
    "鬤": "ráng",
    "鸋": "níng",
    "纽": "niǔ",
    "狃": "niǔ",
    "汼": "niú,yóu",
    "忸": "niǔ",
    "沑": "nǜ,niǔ",
    "炄": "niǔ",
    "牜": "niú",
    "莥": "niǔ",
    "牛": "niú",
    "蚴": "yòu",
    "靵": "niǔ",
    "紐": "niǔ",
    "农": "nóng",
    "浓": "nóng",
    "脓": "nóng",
    "侬": "nóng",
    "挊": "nòng",
    "儂": "nóng",
    "挵": "nòng",
    "欁": "nóng",
    "禯": "nóng",
    "癑": "nòng,nóng",
    "濃": "nóng",
    "秾": "nóng",
    "繷": "nǒng",
    "蕽": "nóng",
    "膿": "nóng",
    "襛": "nóng",
    "辳": "nóng",
    "穠": "nóng",
    "農": "nóng",
    "啂": "gòu",
    "耨": "nòu",
    "嬬": "rú",
    "醲": "nóng",
    "齈": "nòng",
    "搙": "nù,nuò,nòu",
    "槈": "nòu",
    "擩": "rǔ",
    "檽": "nòu,ruǎn,rú",
    "獳": "nòu,rú",
    "羺": "nóu",
    "譳": "ròu",
    "努": "nǔ",
    "奴": "nú",
    "胬": "nǔ",
    "怒": "nù",
    "驽": "nú",
    "弩": "nǔ",
    "伮": "nú,nǔ",
    "伖": "tǎng",
    "孥": "nú",
    "傉": "nù",
    "砮": "nǔ",
    "笯": "nú",
    "褥": "rù",
    "奻": "nuán",
    "暖": "nuǎn",
    "渜": "nuǎn,nuán",
    "湪": "tuàn,nuǎn",
    "煖": "nuǎn",
    "帑": "tǎng,nú",
    "煗": "nuǎn",
    "餪": "nuǎn",
    "駑": "nú",
    "硸": "nüè",
    "谑": "xuè",
    "疟": "nüè,yào",
    "虐": "nüè",
    "黁": "nún",
    "燶": "nóng",
    "懦": "nuò",
    "糯": "nuò",
    "挪": "nuó",
    "诺": "nuò",
    "喏": "nuò,rě",
    "傩": "nuó",
    "锘": "nuò",
    "搦": "nuò",
    "儺": "nuó",
    "愞": "nuò",
    "懧": "nuò",
    "堧": "ruán",
    "搻": "ná,nuò",
    "掿": "nuò",
    "梛": "nuó",
    "橠": "nuó",
    "榒": "nuò",
    "稬": "nuò",
    "穤": "nuò",
    "糑": "nuò",
    "糥": "nuò",
    "耎": "ruǎn,nuò",
    "逽": "nuò",
    "諾": "nuò",
    "鍩": "nuò",
    "需": "xū",
    "女": "nǚ,rǔ",
    "衄": "nǜ",
    "钕": "nǚ",
    "恧": "nǜ",
    "籹": "nǚ",
    "衂": "nǜ",
    "朒": "nǜ,gǎ",
    "釹": "nǚ",
    "筽": "o",
    "夞": "wài",  # Unknow.
    "乯": "hū",
    "昷": "wēn",
    "鞰": "wēn,yùn",
    "瘧": "nüè,yào",
    "偶": "ǒu",
    "喔": "ō,wō",
    "呕": "ǒu,ōu,òu",
    "欧": "ōu",
    "藕": "ǒu",
    "鸥": "ōu",
    "沤": "òu,ōu",
    "怄": "òu",
    "殴": "ōu",
    "瓯": "ōu",
    "讴": "ōu",
    "耦": "ǒu",
    "吘": "ǒu",
    "塸": "ōu,qiū",
    "嘔": "ǒu",
    "敺": "qū",
    "櫙": "ōu",
    "慪": "òu",
    "歐": "ōu",
    "渥": "wò",
    "握": "wò",
    "熰": "ōu,ǒu",
    "漚": "òu,ōu",
    "甌": "ōu",
    "紆": "yū",
    "腢": "ǒu",
    "蕅": "ǒu",
    "纡": "yū",
    "膒": "ōu",
    "藲": "ōu",
    "醧": "yù",
    "遇": "yù",
    "謳": "ōu",
    "鴎": "ōu",
    "齵": "yú",
    "鷗": "ōu",
    "爬": "pá",
    "趴": "pā",
    "啪": "pā",
    "琶": "pá",
    "妑": "pā",
    "筢": "pá",
    "葩": "pā",
    "掱": "pá",
    "牌": "pái",
    "潖": "pá",
    "袙": "pà",
    "迫": "pò,pǎi",
    "徘": "pái",
    "帊": "pà",
    "舥": "pā",
    "俳": "pái",
    "犤": "pái",
    "猅": "pái",
    "蒎": "pài",
    "輫": "pái",
    "簰": "pái",
    "鎃": "pài",
    "磗": "zhuān",
    "盘": "pán",
    "判": "pàn",
    "畔": "pàn",
    "叛": "pàn",
    "磐": "pán",
    "胖": "pàn",
    "攀": "pān",
    "襻": "pàn",
    "爿": "pán",
    "泮": "pàn",
    "乑": "yín",
    "冸": "pàn",
    "姍": "shān,shàn",
    "媻": "pán",
    "姗": "shān,shàn",
    "宷": "shěn",
    "审": "shěn",
    "幋": "pán",
    "審": "shěn",
    "沜": "pàn",
    "彦": "yàn",
    "槃": "pán",
    "洀": "pán",
    "溿": "pàn",
    "瀊": "pán",
    "炍": "pàn",
    "牉": "pàn",
    "片": "piàn,piān",
    "盻": "xì,pǎn",
    "皤": "pó",
    "眅": "pān",
    "盤": "pán",
    "蒰": "pán",
    "詊": "pàn",
    "踫": "pèng",
    "鋬": "pàn",
    "鎜": "pán",
    "鑻": "pàn",
    "鄱": "pó",
    "鞶": "pán",
    "頖": "pàn",
    "鵥": "pàn",
    "耪": "pǎng",
    "沗": "hóng,pāng",
    "乓": "pāng",
    "滂": "pāng",
    "胮": "pāng",
    "篣": "péng,páng",
    "膖": "pāng",
    "蠭": "fēng",
    "覫": "pǎng",
    "霶": "pāng",
    "龎": "páng",
    "抛": "pāo",
    "咆": "páo",
    "泡": "pào,pāo",
    "狍": "páo",
    "庖": "páo",
    "匏": "páo",
    "疱": "pào",
    "垉": "páo",
    "脬": "pāo",
    "奅": "pào",
    "爮": "páo",
    "犥": "piāo",
    "拋": "pāo",
    "礟": "pào",
    "萢": "pāo",
    "皰": "pào",
    "褜": "páo",
    "謈": "bó",
    "軳": "páo",
    "鞄": "páo",
    "麅": "páo",
    "麭": "pào",
    "礮": "pào",
    "陪": "péi",
    "配": "pèi",
    "赔": "péi",
    "呸": "pēi",
    "胚": "pēi",
    "佩": "pèi",
    "培": "péi",
    "沛": "pèi",
    "帔": "pèi",
    "旆": "pèi",
    "醅": "pēi",
    "霈": "pèi",
    "辔": "pèi",
    "姵": "pèi",
    "俖": "pěi",
    "伂": "pèi",
    "嶏": "pǐ,pèi",
    "媐": "yí,pèi",
    "怌": "pēi",
    "抷": "pī,pēi",
    "斾": "pèi",
    "昢": "pò",
    "毰": "péi",
    "珮": "pèi",
    "肧": "pēi",
    "蓜": "pèi",
    "浿": "pèi",
    "淠": "pì,pèi",
    "阫": "péi",
    "馷": "pèi",
    "轡": "pèi",
    "賠": "péi",
    "駍": "pēng",
    "盆": "pén",
    "湓": "pén",
    "呠": "pěn",
    "瓫": "pén",
    "翸": "pěn",
    "碰": "pèng",
    "棚": "péng",
    "砰": "pēng",
    "蓬": "péng",
    "朋": "péng",
    "烹": "pēng",
    "硼": "péng",
    "澎": "péng",
    "篷": "péng",
    "蟛": "péng",
    "膨": "péng",
    "剻": "pēng",
    "嘭": "pēng",
    "倗": "péng",
    "匉": "pēng",
    "塜": "péng",
    "怦": "pēng",
    "塳": "péng",
    "恲": "pēng",
    "憉": "péng",
    "掽": "pèng",
    "梈": "pēng",
    "弸": "péng",
    "庄": "zhuāng",
    "椖": "péng",
    "椪": "pèng",
    "淎": "pěng",
    "泙": "pēng,píng",
    "淜": "píng,péng",
    "漰": "bēn,pēng",
    "皏": "pěng",
    "槰": "pèng",
    "樥": "péng",
    "稝": "péng",
    "磞": "pēng,pèng",
    "纄": "péng",
    "胓": "píng,pēng",
    "竼": "péng",
    "芃": "péng",
    "荓": "píng",
    "苹": "píng,pēng",
    "蟚": "péng",
    "硑": "pēng,píng",
    "軯": "pēng",
    "輣": "péng",
    "輧": "píng",
    "軿": "píng",
    "閛": "pēng,pèng",
    "韸": "péng",
    "韼": "péng",
    "髼": "péng",
    "鬅": "péng",
    "鑝": "péng",
    "鬔": "péng",
    "巼": "bā",  # Unknow.
    "浌": "fá",
    "喸": "bǔ",  # Unknow.
    "乶": "fǔ",
    "闏": "fēng",  # Unknow.
    "批": "pī",
    "皮": "pí",
    "劈": "pī,pǐ",
    "披": "pī",
    "匹": "pǐ",
    "屁": "pì",
    "僻": "pì",
    "痞": "pǐ",
    "霹": "pī",
    "琵": "pí",
    "毗": "pí",
    "啤": "pí",
    "砒": "pī",
    "疲": "pí",
    "譬": "pì",
    "丕": "pī",
    "貔": "pí",
    "癖": "pǐ",
    "圮": "pǐ",
    "郫": "pí",
    "甓": "pì",
    "睥": "bì,pì",
    "鼙": "pí",
    "铍": "pí,pī",
    "邳": "pī",
    "罴": "pí",
    "噼": "pī",
    "蚍": "pí",
    "伾": "pī",
    "噽": "pǐ",
    "伓": "pī",
    "嚊": "xiù,pì",
    "嚭": "pǐ",
    "嫓": "pì",
    "憵": "pī",
    "岯": "pī",
    "壀": "pí",
    "朇": "bì,pí",
    "扑": "pū",
    "榌": "bī,pi",
    "毘": "pí",
    "毞": "bǐ",
    "渒": "pài",
    "澼": "pì",
    "炋": "pī",
    "焷": "pí",
    "狉": "pī",
    "狓": "pī",
    "疈": "pì",
    "睤": "bì",
    "潎": "pì,piē",
    "磇": "pī",
    "痦": "wù",
    "疋": "pǐ,yǎ,shū",
    "礕": "pī",
    "秛": "pī",
    "秠": "pī",
    "篺": "pí",
    "礔": "pī",
    "簲": "pái",
    "耚": "pī",
    "脴": "pǐ",
    "膍": "pí",
    "苉": "pǐ",
    "蚽": "pí",
    "苤": "piě",
    "螷": "pí",
    "羆": "pí",
    "蠯": "pí",
    "豼": "pí",
    "豾": "pī",
    "釽": "pī,zhāo",
    "鉟": "pī",
    "銢": "pǐ",
    "鈹": "pí",
    "闢": "pì",
    "錃": "pī",
    "阰": "pí",
    "隦": "pí",
    "銔": "pī",
    "顖": "xìn",
    "頗": "pō",
    "駓": "pī",
    "髬": "pī",
    "颇": "pō",
    "魾": "pī",
    "鴄": "pǐ",
    "鵧": "pí",
    "鷿": "pì",
    "篇": "piān",
    "骗": "piàn",
    "偏": "piān",
    "翩": "piān",
    "骈": "pián",
    "蹁": "pián",
    "胼": "pián",
    "囨": "piān",
    "谝": "piǎn",
    "犏": "piān",
    "媥": "piān",
    "楩": "pián",
    "腁": "pián",
    "覑": "piǎn",
    "諚": "biàn",
    "貵": "piǎn",
    "楄": "piān",
    "諞": "piǎn",
    "賆": "pián",
    "騈": "pián",
    "騗": "piàn",
    "駢": "pián",
    "骿": "pián",
    "魸": "piàn",
    "騙": "piàn",
    "票": "piào,piāo",
    "飘": "piāo",
    "瓢": "piáo",
    "朴": "pǔ,pò,pō,piáo",
    "螵": "piāo",
    "瞟": "piǎo",
    "勡": "piāo",
    "缥": "piǎo,piāo",
    "嘌": "piāo",
    "慓": "piāo",
    "旚": "piāo",
    "皫": "piǎo",
    "磦": "biāo",
    "翲": "piāo",
    "薸": "piáo",
    "縹": "piǎo,piāo",
    "醥": "piǎo",
    "闝": "piáo",
    "顠": "piǎo",
    "飃": "piāo",
    "魒": "piāo",
    "丿": "piě",
    "飄": "piāo",
    "氕": "piē",
    "嫳": "piè",
    "暼": "piē",
    "鐅": "piě",
    "品": "pǐn",
    "贫": "pín",
    "聘": "pìn",
    "拼": "pīn",
    "嫔": "pín",
    "榀": "pǐn",
    "姘": "pīn",
    "颦": "pín",
    "牝": "pìn",
    "嚬": "pín",
    "娉": "pīng",
    "玭": "pín",
    "朩": "pìn,děng",  # Unknow: Google Translage 提供的拼音：děng，但读音为pìn。
    "嬪": "pín",
    "矉": "pín",
    "礗": "pīn",
    "薲": "pín",
    "穦": "pīn",
    "蘋": "pín,píng",
    "貧": "pín",
    "顰": "pín",
    "驞": "pīn",
    "馪": "pīn",
    "瓶": "píng",
    "评": "píng",
    "乒": "pīng",
    "萍": "píng",
    "坪": "píng",
    "凭": "píng",
    "呯": "píng",
    "凴": "píng",
    "枰": "píng",
    "鲆": "píng",
    "俜": "pīng",
    "塀": "píng",
    "娦": "pín",
    "屛": "pǐng,bǐng",
    "岼": "píng",
    "帡": "píng",
    "帲": "píng",
    "幈": "píng",
    "慿": "píng",
    "洴": "píng",
    "涄": "pīng",
    "憑": "píng",
    "焩": "píng",
    "甹": "pīng",
    "甁": "píng",
    "玶": "píng",
    "砯": "pīng",
    "竮": "píng",
    "箳": "píng",
    "簈": "píng",
    "缾": "píng",
    "聠": "pīng",
    "艵": "pīng",
    "蚲": "píng",
    "蛢": "píng",
    "蓱": "píng",
    "郱": "píng",
    "評": "píng",
    "頩": "pīng",
    "鮃": "píng",
    "破": "pò",
    "坡": "pō",
    "粕": "pò",
    "婆": "pó",
    "笸": "pǒ",
    "攴": "pū",
    "钋": "pō",
    "叵": "pǒ",
    "岥": "pō",
    "珀": "pò",
    "钷": "pǒ",
    "岶": "pò",
    "廹": "pò,pǎi",
    "敀": "pò",
    "椺": "xí",
    "櫇": "pó",
    "洦": "pò",
    "嘙": "pó",
    "烞": "pò",
    "尀": "pǒ",
    "溌": "pō",
    "皛": "xiǎo",
    "砶": "pò",
    "蒪": "pò",
    "酦": "pō",
    "鏺": "pō",
    "釙": "pō",
    "駊": "pǒ",
    "鉕": "pǒ",
    "咅": "pǒu",
    "哣": "pǒu",
    "堷": "yìn",
    "剖": "pōu",
    "犃": "pǒu",
    "抔": "póu",
    "颒": "huì",
    "哛": "fēn",  # Unknow.
    "兺": "fēn",  # Unknow.
    "铺": "pū,pù",
    "谱": "pǔ",
    "仆": "pū,pú",
    "圃": "pǔ",
    "浦": "pǔ",
    "镨": "pǔ",
    "噗": "pū",
    "普": "pǔ",
    "匍": "pú",
    "氆": "pǔ",
    "濮": "pú",
    "蹼": "pǔ",
    "镤": "pú",
    "璞": "pú",
    "圤": "pú",
    "圑": "pǔ",
    "巬": "gū",
    "巭": "gū",
    "暜": "pǔ",
    "墣": "pú",
    "檏": "pǔ",
    "潽": "pū",
    "炇": "pū",
    "樸": "pǔ",
    "烳": "pǔ",
    "痡": "pū,pù",
    "瞨": "pú",
    "穙": "pú",
    "菐": "pú",
    "蒱": "pú",
    "舖": "pù",
    "諩": "pǔ",
    "贌": "pú",
    "酺": "pú",
    "譜": "pǔ",
    "鋪": "pū,pù",
    "鏷": "pú",
    "駇": "wén",
    "鐠": "pǔ",
    "曝": "pù,bào",
    "起": "qǐ",
    "七": "qī",
    "气": "qì",
    "器": "qì",
    "启": "qǐ",
    "漆": "qī",
    "妻": "qī,qì",
    "柒": "qī",
    "岂": "qǐ,kǎi",
    "欺": "qī",
    "砌": "qì,qiè",
    "祁": "qí",
    "凄": "qī",
    "乞": "qǐ",
    "企": "qǐ",
    "歧": "qí",
    "栖": "qī,xī",
    "畦": "qí",
    "弃": "qì",
    "脐": "qí",
    "崎": "qí",
    "迄": "qì",
    "沏": "qī",
    "旗": "qí",
    "讫": "qì",
    "祺": "qí",
    "骐": "qí",
    "屺": "qǐ",
    "岐": "qí",
    "蹊": "xī",
    "桤": "qī",
    "憩": "qì",
    "萋": "qī",
    "芑": "qǐ",
    "汔": "qì",
    "鳍": "qí",
    "俟": "sì,qí",
    "槭": "qì,sè",
    "嘁": "qī",
    "蛴": "qí",
    "綦": "qí",
    "亓": "qí",
    "欹": "qī",
    "琪": "qí",
    "麒": "qí",
    "圻": "qí,yín",
    "蜞": "qí",
    "琦": "qí",
    "杞": "qǐ",
    "碛": "qì",
    "祗": "zhī",
    "葺": "qì",
    "耆": "qí,shì",
    "淇": "qí",
    "倛": "qī",
    "绮": "qǐ",
    "亝": "qí,zhāi",
    "傶": "qī,còu",
    "僛": "qī",
    "剘": "qí",
    "切": "qiē,qiè",
    "咠": "qì",
    "勤": "qín",
    "呇": "qǐ",
    "唭": "qì",
    "唘": "qǐ",
    "吱": "zhī,zī",
    "啔": "qǐ",
    "噐": "qì",
    "埼": "qí",
    "啓": "qǐ",
    "夡": "qì",
    "娸": "qī",
    "婍": "qǐ",
    "岓": "qí",
    "忔": "yì,qì",
    "宿": "sù,xiǔ,xiù",
    "嵜": "qí",
    "忯": "qí,shì",
    "啟": "qǐ",
    "忮": "zhì",
    "恓": "xī,qī,xù",
    "愭": "qí",
    "悽": "qī",
    "慼": "qī",
    "慽": "qī",
    "憇": "qì",
    "扺": "zhǐ",
    "捿": "qī",
    "掑": "qí",
    "斉": "qí",
    "斊": "qí",
    "支": "zhī",
    "朞": "jī",
    "暣": "qì",
    "旂": "qí",
    "枝": "zhī,qí",
    "梩": "sì,qǐ",
    "栔": "qì,qiè",
    "棄": "qì",
    "棨": "qǐ",
    "棊": "qí",
    "桼": "qī",
    "棲": "qī",
    "檱": "qí",
    "榿": "qī",
    "欫": "qì",
    "櫀": "qí",
    "気": "qì",
    "洓": "sè,qì,zì",
    "氣": "qì",
    "淒": "qī",
    "渏": "yī",
    "湇": "qì",
    "湆": "qì",
    "渍": "zì",
    "濝": "qí",
    "漬": "zì",
    "炁": "qì",
    "猉": "qí",
    "玘": "qǐ",
    "玂": "qí",
    "甈": "qì",
    "疧": "qí",
    "盀": "qǐ",
    "盵": "qì",
    "滊": "qì,xì,xiē",
    "碕": "qí",
    "碁": "qí",
    "碶": "qì",
    "磎": "xī",
    "磩": "qì,zhú",
    "磜": "qì",
    "磧": "qì",
    "禥": "qí",
    "簱": "qí",
    "簯": "qí",
    "籏": "qí",
    "示": "shì",
    "粸": "qí",
    "竒": "qí",
    "綥": "qí",
    "紪": "qī",
    "綨": "jī,qí",
    "綮": "qìng,qǐ",
    "緀": "qī",
    "綺": "qǐ",
    "緕": "zī",
    "纃": "zī",
    "缼": "quē",
    "罊": "qì",
    "肵": "qí",
    "艩": "qí",
    "芞": "qì",
    "藄": "qí",
    "臍": "qí",
    "蚑": "qí",
    "蜝": "qí",
    "蚚": "qí",
    "螇": "xī,qī",
    "螧": "qí",
    "衹": "zhǐ",
    "蠐": "qí",
    "蚔": "qí,zhǐ",
    "裿": "yǐ",
    "褄": "qī",
    "諆": "qī",
    "諬": "qǐ",
    "訖": "qì",
    "諿": "xǔ",
    "軝": "qí",
    "迉": "qī",
    "邔": "qǐ",
    "趿": "tā",
    "郪": "qī",
    "錡": "qí",
    "鏚": "qī",
    "锜": "qí",
    "闙": "qǐ",
    "釮": "qí",
    "霋": "qī",
    "騹": "qí",
    "騏": "qí",
    "鬿": "qí",
    "魕": "jī",
    "鬐": "qí",
    "魌": "qī",
    "鯕": "qí",
    "鮨": "yì",
    "鲯": "qí",
    "鰭": "qí",
    "鶈": "qī",
    "鵸": "qí",
    "麡": "qí",
    "齮": "yǐ",
    "恰": "qià",
    "掐": "qiā",
    "葜": "qiā",
    "鶀": "qí",
    "佉": "qū",
    "冾": "qià",
    "圶": "qià",
    "拤": "qiǎ",
    "帢": "qià",
    "殎": "qià",
    "磍": "xiá,qià,yà",
    "硈": "qià",
    "跒": "qiǎ",
    "酠": "qiǎ",
    "鞐": "qiǎ",
    "千": "qiān",
    "牵": "qiān",
    "签": "qiān",
    "铅": "qiān,yán",
    "欠": "qiàn",
    "钎": "qiān",
    "谴": "qiǎn",
    "潜": "qián",
    "谦": "qiān",
    "歉": "qiàn",
    "扦": "qiān",
    "遣": "qiǎn",
    "迁": "qiān",
    "仟": "qiān",
    "黔": "qián",
    "岍": "qiān",
    "褰": "qiān",
    "箝": "qián",
    "倩": "qiàn",
    "掮": "qián",
    "搴": "qiān",
    "愆": "qiān",
    "慊": "qiàn,qiè",
    "悭": "qiān",
    "虔": "qián",
    "芡": "qiàn",
    "荨": "qián,xún",
    "缱": "qiǎn",
    "芊": "qiān",
    "佥": "qiān",
    "阡": "qiān",
    "茜": "qiàn",
    "肷": "qiǎn",
    "俔": "qiàn",
    "椠": "qiàn",
    "僉": "qiān",
    "儙": "qiàn",
    "嗛": "xián,qiàn,qiè",
    "伣": "qiàn",
    "圱": "qiān,sú",
    "墘": "qián",
    "刋": "qiàn",
    "壍": "qiàn",
    "奷": "qiān",
    "媊": "qián",
    "孅": "xiān,qiān",
    "孯": "qiān",
    "圲": "qiān",
    "岒": "qián",
    "嵰": "qīn,qiǎn",
    "廞": "xīn",
    "寨": "zhài",
    "忴": "qián,qín",
    "悓": "qiàn",
    "扲": "qián,qín",
    "拑": "qián",
    "慳": "qiān",
    "拪": "qiān",
    "掔": "qiān,wàn",
    "撁": "qiān",
    "攐": "qiān",
    "攑": "qiān",
    "攓": "qiān",
    "撍": "zǎn,zān,zēn,qián",
    "杄": "qiān",
    "棈": "qiàn",
    "杴": "xiān",
    "槧": "qiàn",
    "檶": "qiān,lián",
    "櫏": "qiān",
    "歬": "qián",
    "榩": "qián",
    "汘": "qiān",
    "汧": "qiān",
    "橬": "qián",
    "濳": "qián",
    "灊": "qián",
    "炶": "shǎn,qián,shān",
    "潛": "qián",
    "煔": "shǎn,qián,shān",
    "燂": "tán",
    "皘": "qiàn",
    "竏": "qiān",
    "牽": "qiān",
    "篏": "qiàn",
    "篟": "qiàn",
    "籖": "qiān",
    "籤": "qiān",
    "簽": "qiān",
    "箞": "quān",
    "綪": "qiàn,qīng,zhēng",
    "粁": "qiān",
    "繾": "qiǎn",
    "羬": "qián,xián,yán",
    "縴": "qiàn",
    "羥": "qiǎng",
    "羟": "qiǎng",
    "膁": "qiǎn",
    "臤": "qiān,xián",
    "苂": "chán,yín",
    "茾": "qiān",
    "葴": "zhēn",
    "蔳": "qiàn",
    "蒨": "qiàn",
    "蚈": "qiān",
    "藖": "xián",
    "蕁": "qián,xún",
    "蚙": "qín,qián",
    "蜸": "qiǎn",
    "諐": "qiān",
    "谸": "qiān",
    "謙": "qiān",
    "譴": "qiǎn",
    "軡": "qián",
    "輤": "qiàn",
    "鈆": "qiān",
    "遷": "qiān",
    "鍼": "zhēn",
    "釺": "qiān",
    "鎆": "qián",
    "鑓": "qiǎn",
    "鉛": "qiān",
    "韆": "qiān",
    "顅": "qiān",
    "騚": "qián",
    "騝": "qián",
    "鬜": "qiān",
    "鬝": "qiān",
    "鰬": "qián",
    "鏲": "qiān",
    "鵮": "qiān",
    "鹐": "qiān",
    "枪": "qiāng",
    "墙": "qiáng",
    "羌": "qiāng",
    "蜣": "qiāng",
    "蔷": "qiáng",
    "跄": "qiāng,qiàng",
    "戗": "qiāng,qiàng",
    "襁": "qiǎng",
    "戕": "qiāng",
    "炝": "qiàng",
    "镪": "qiǎng",
    "锖": "qiāng",
    "樯": "qiáng",
    "锵": "qiāng",
    "嫱": "qiáng",
    "唴": "qiàng",
    "啌": "qiāng",
    "墏": "qiǎng",
    "墻": "qiáng",
    "嬙": "qiáng",
    "嗴": "qiāng",
    "嶈": "qiāng",
    "廧": "qiáng,sè",
    "庆": "qìng",
    "慶": "qìng",
    "斨": "qiāng",
    "溬": "qiāng",
    "漒": "qiáng",
    "檣": "qiáng",
    "熗": "qiàng",
    "猐": "qiāng",
    "牆": "qiáng",
    "牄": "qiāng",
    "獇": "qiāng",
    "玱": "qiāng,cāng",
    "繈": "qiǎng",
    "繦": "qiǎng",
    "羻": "qiàng",
    "艢": "qiáng",
    "薔": "qiáng,sè",
    "蘠": "qiáng",
    "羗": "qiāng",
    "謒": "qiāng",
    "琷": "què",
    "親": "qīn,qìng",
    "蹡": "qiāng",
    "跫": "qióng",
    "蹌": "qiāng",
    "錆": "qīng",
    "桥": "qiáo",
    "鏹": "qiǎng,qiāng",
    "鏘": "qiāng",
    "敲": "qiāo",
    "瞧": "qiáo",
    "巧": "qiǎo",
    "翘": "qiáo,qiào",
    "锹": "qiāo",
    "撬": "qiào",
    "悄": "qiǎo,qiāo",
    "窍": "qiào",
    "鞘": "qiào,shāo",
    "雀": "què,qiāo,qiǎo",
    "俏": "qiào,xiào",
    "峭": "qiào",
    "荞": "qiáo",
    "樵": "qiáo",
    "跷": "qiāo",
    "硗": "qiāo",
    "谯": "qiáo",
    "憔": "qiáo",
    "愀": "qiǎo",
    "缲": "qiāo,sāo",
    "诮": "qiào",
    "劁": "qiāo",
    "僺": "qiào",
    "喿": "zào,qiāo",
    "削": "xiāo,xuē",
    "嘺": "qiáo,qiào",
    "塙": "què",
    "墝": "qiāo",
    "帩": "qiāo",
    "幓": "shān,qiāo,shēn",
    "墧": "qiáo,què",
    "橇": "qiāo",
    "幧": "qiāo",
    "槗": "qiáo",
    "捎": "shāo,shào",
    "橾": "shū,qiāo",
    "招": "zhāo",
    "毃": "qiāo",
    "殼": "ké,qiào",
    "燆": "qiāo",
    "犞": "qiáo",
    "癄": "qiáo,jiào",
    "睄": "qiáo,shào,xiāo",
    "硚": "qiáo",
    "硝": "xiāo",
    "碻": "què,qiāo",
    "礄": "qiáo",
    "窯": "yáo",
    "箾": "shuò,xiāo,qiào",
    "竅": "qiào",
    "荍": "qiáo",
    "藮": "qiáo",
    "翹": "qiáo,qiào",
    "誚": "qiào",
    "菬": "qiáo,zhǎo",
    "譙": "qiáo",
    "趬": "qiāo",
    "繰": "qiāo,sāo",
    "踃": "xiāo",
    "踍": "qiāo",
    "躈": "qiào",
    "蹺": "qiāo",
    "郻": "qiāo",
    "鄡": "qiāo",
    "鄥": "qiāo",
    "陗": "qiào",
    "銚": "diào,tiáo,yáo",
    "鐈": "qiáo",
    "鞩": "qiào",
    "韒": "qiào",
    "頝": "qiāo",
    "鍫": "qiāo",
    "顤": "yáo",
    "顦": "qiáo",
    "鍬": "qiāo",
    "髚": "qiào",
    "髜": "qiǎo",
    "窃": "qiè",
    "怯": "qiè",
    "郄": "qiè,xì",
    "惬": "qiè",
    "锲": "qiè",
    "妾": "qiè",
    "倿": "nìng",
    "匧": "qiè",
    "厒": "qiè",
    "箧": "qiè",
    "唼": "shà",
    "帹": "shà,qiè",
    "悏": "qiè",
    "朅": "qiè,hé",
    "癿": "qié",
    "穕": "qiè",
    "稧": "xì,qiè",
    "笡": "qiè",
    "竊": "qiè",
    "籡": "qiè",
    "篋": "qiè",
    "緁": "jī",
    "聺": "qié",
    "愜": "qiè",
    "苆": "qiē",
    "藒": "qì",
    "踥": "qiè",
    "鐑": "qì",
    "鍥": "qiè",
    "鯜": "qiè",
    "亲": "qīn,qìng",
    "擒": "qín",
    "侵": "qīn",
    "寝": "qǐn",
    "琴": "qín",
    "芹": "qín",
    "沁": "qìn",
    "秦": "qín",
    "钦": "qīn",
    "禽": "qín",
    "吣": "qìn",
    "覃": "tán,qín",
    "衾": "qīn",
    "芩": "qín",
    "嗪": "qín",
    "螓": "qín",
    "吢": "qìn",
    "溱": "zhēn,qín",
    "檎": "qín",
    "坅": "qǐn",
    "媇": "qīn",
    "埁": "cén",
    "唚": "qìn",
    "寑": "qǐn",
    "噙": "qín",
    "嫀": "qín,shēn",
    "揿": "qìn",
    "寢": "qǐn",
    "嵚": "qīn",
    "寴": "qīn,qìn",
    "嶔": "qīn",
    "懃": "qín",
    "懄": "qín",
    "庈": "qín",
    "抋": "qìn",
    "捦": "qín",
    "搇": "qìn",
    "昑": "qǐn",
    "梫": "qǐn",
    "撳": "qìn",
    "瀙": "qìn",
    "珡": "qín",
    "欽": "qīn",
    "琹": "qín",
    "瘽": "qín",
    "矝": "jīn,qín,guān",
    "澿": "qín",
    "笉": "qǐn",
    "綅": "qīn,xiān",
    "耹": "qín",
    "菣": "qìn",
    "菦": "qín",
    "藽": "qìn",
    "螼": "qǐn",
    "蓁": "zhēn",
    "誛": "qīn",
    "赺": "yǐn",
    "赾": "qǐn",
    "鈊": "xīn",
    "鈙": "qín",
    "蠄": "qín",
    "靲": "qín",
    "雂": "qín",
    "駸": "qīn",
    "顉": "qīn",
    "鮼": "qīn",
    "骎": "qīn",
    "鬵": "zèng",
    "鳹": "qín",
    "请": "qǐng",
    "轻": "qīng",
    "清": "qīng",
    "情": "qíng",
    "晴": "qíng",
    "氢": "qīng",
    "倾": "qīng",
    "卿": "qīng",
    "擎": "qíng",
    "氰": "qíng",
    "謦": "qǐng",
    "圊": "qīng",
    "苘": "qǐng",
    "黥": "qíng",
    "磬": "qìng",
    "傾": "qīng",
    "凊": "qìng",
    "勍": "qíng",
    "罄": "qìng",
    "啨": "qíng,yīng",
    "埥": "qīng,zhēng",
    "鲭": "qīng",
    "夝": "qíng",
    "寈": "qīng",
    "庼": "qǐng",
    "廎": "qǐng",
    "声": "shēng",
    "掅": "qìng,qiàn",
    "暒": "qíng",
    "棾": "qíng",
    "樈": "qíng",
    "檾": "qǐng",
    "櫦": "qìng",
    "淸": "qīng",
    "氫": "qīng",
    "漀": "qǐng",
    "甠": "qíng",
    "硘": "qíng",
    "碃": "qìng",
    "軽": "qīng",
    "胜": "shèng",
    "請": "qǐng",
    "郬": "qīng",
    "輕": "qīng",
    "鯖": "qīng",
    "穷": "qióng",
    "鑋": "qīng",
    "琼": "qióng",
    "邛": "qióng",
    "茕": "qióng",
    "筇": "qióng",
    "儝": "qióng",
    "嬛": "huán,xuān,qióng",
    "銎": "qióng",
    "卭": "qióng",
    "惸": "qióng",
    "桏": "qióng",
    "焪": "qióng",
    "焭": "qióng",
    "橩": "qióng",
    "憌": "qióng",
    "熍": "qióng",
    "琁": "xuán,qióng",
    "煢": "qióng",
    "睘": "qióng",
    "瓗": "qióng,wěi,wèi",
    "瓊": "qióng",
    "竆": "qióng",
    "笻": "qióng",
    "藭": "qióng",
    "藑": "qióng",
    "窮": "qióng",
    "蛬": "qióng",
    "赹": "qióng",
    "求": "qiú",
    "球": "qiú",
    "秋": "qiū",
    "泅": "qiú",
    "丘": "qiū",
    "邱": "qiū",
    "囚": "qiú",
    "酋": "qiú",
    "楸": "qiū",
    "蚯": "qiū",
    "裘": "qiú",
    "巯": "qiú",
    "糗": "qiǔ",
    "逑": "qiú",
    "俅": "qiú",
    "虬": "qiú",
    "赇": "qiú",
    "犰": "qiú",
    "鳅": "qiū",
    "丠": "qiū",
    "鼽": "qiú",
    "遒": "qiú",
    "厹": "róu,qiú",
    "叴": "qiú",
    "唒": "qiú",
    "坵": "qiū",
    "团": "tuán",
    "崷": "qiú",
    "媝": "qiū",
    "巰": "qiú",
    "恘": "qiū",
    "扏": "qiú",
    "搝": "qiǔ",
    "梂": "qiú",
    "殏": "qiú",
    "櫹": "xiāo",
    "毬": "qiú",
    "汓": "qiú",
    "浗": "qiú",
    "氽": "tǔn",
    "渞": "qiú,wù",
    "煪": "qiú",
    "玌": "qiú",
    "璆": "qiú",
    "皳": "qiú",
    "盚": "qiú",
    "秌": "qiū",
    "穐": "qiū",
    "篍": "qiū",
    "紌": "qiú",
    "絿": "qiú",
    "緧": "qiū",
    "湭": "qiú",
    "莍": "qiú",
    "蘒": "qiū",
    "虯": "qiú",
    "蛷": "qiú",
    "蝵": "qiū",
    "蟗": "qiū",
    "蠤": "qiū",
    "觓": "qiú",
    "肍": "qiú",
    "觩": "qiú",
    "訅": "qiú",
    "逎": "qiú",
    "賕": "qiú",
    "邺": "yè",
    "釚": "qiú",
    "釻": "qiú",
    "銶": "qiú",
    "鞦": "qiū",
    "鞧": "qiū",
    "鮂": "qiú",
    "鯄": "qiú",
    "鰌": "qiū",
    "鰽": "qiú",
    "鱃": "xiū",
    "鰍": "qiū",
    "鶖": "qiū",
    "鵭": "qín",
    "鹙": "qiū",
    "龝": "qiū",
    "去": "qù",
    "取": "qǔ",
    "驱": "qū",
    "曲": "qū,qǔ",
    "躯": "qū",
    "龋": "qǔ",
    "戌": "xū",
    "祛": "qū",
    "蕖": "qú",
    "磲": "qú",
    "劬": "qú",
    "阒": "qù",
    "麴": "qū",
    "癯": "qú",
    "衢": "qú",
    "黢": "qū",
    "璩": "qú",
    "氍": "qú",
    "蛐": "qū",
    "觑": "qù,qū",
    "伹": "qū",
    "岖": "qū",
    "佢": "qú",
    "刞": "qù",
    "匤": "qū",
    "厺": "qù",
    "戵": "qú",
    "抾": "qū",
    "斪": "qú",
    "欋": "qú",
    "岴": "qū",
    "憈": "qū",
    "嶇": "qū",
    "浀": "qū",
    "淭": "qú",
    "璖": "qú",
    "竬": "qǔ",
    "灈": "qú",
    "筁": "qū",
    "粬": "qū",
    "紶": "qū,qǔ",
    "絇": "qú",
    "翑": "qú,yù",
    "胠": "qū",
    "组": "zǔ",
    "菃": "qú",
    "臞": "qú",
    "葋": "qú",
    "蝺": "qǔ",
    "蟝": "qú",
    "組": "zǔ",
    "蠷": "qú",
    "衐": "qú",
    "袪": "qū",
    "覰": "qū,qù",
    "覻": "qù,qū",
    "詓": "qǔ",
    "覷": "qù,qū",
    "迲": "qù",  # Unknow: Google Translage 提供的拼音是轻音，但读音 4 声。
    "鑺": "qú",
    "閴": "qù",
    "阹": "qū",
    "駆": "qū",
    "闃": "qù",
    "躣": "qú",
    "駈": "qū",
    "軀": "qū",
    "騶": "zōu",
    "髷": "qū",
    "驅": "qū",
    "驺": "zōu",
    "魼": "qū",
    "鰸": "qū",
    "鱋": "qū",
    "麮": "qù",
    "麹": "qū",
    "麯": "qū",
    "鼁": "qù",
    "鼩": "qú",
    "齲": "qǔ",
    "权": "quán",
    "劝": "quàn",
    "拳": "quán",
    "犬": "quǎn",
    "全": "quán",
    "颧": "quán",
    "券": "quàn,xuàn",
    "泉": "quán",
    "痊": "quán",
    "筌": "quán",
    "绻": "quǎn",
    "诠": "quán",
    "畎": "quǎn",
    "鬈": "quán",
    "悛": "quān",
    "勧": "quàn",
    "勸": "quàn",
    "姾": "quán",
    "铨": "quán",
    "峑": "quán",
    "婘": "quán,juàn",
    "巏": "quán",
    "巻": "juàn,juǎn",
    "恮": "quán,zhuān",
    "搼": "quán",
    "佺": "quán",
    "栒": "xún",
    "拴": "shuān",
    "椦": "quān,juàn,quán",
    "槫": "tuán,shuàn,quán",
    "権": "quán",
    "洤": "quán",
    "湶": "quán",
    "灥": "xún,quán,quàn",
    "楾": "quán",
    "烇": "quǎn",
    "牶": "quàn",
    "牷": "quán",
    "犈": "quán",
    "甽": "zhèn",
    "硂": "quán",
    "絟": "quán,shuān",
    "縓": "quán",
    "綣": "quǎn",
    "葲": "quán",
    "虇": "quǎn",
    "觠": "quán",
    "瑔": "quán",
    "謜": "yuán",
    "譔": "zhuàn",
    "跧": "quán",
    "闎": "quán",
    "銓": "quán",
    "詮": "quán",
    "駩": "quán",
    "顴": "quán",
    "鐉": "quān",
    "鰁": "quán",
    "騡": "quán",
    "鳈": "quán",
    "齤": "quán",
    "确": "què",
    "瘸": "qué",
    "鹊": "què",
    "崅": "què",
    "榷": "què",
    "悫": "què",
    "愨": "què",
    "汋": "zhuó,què",
    "燩": "què",
    "慤": "què",
    "獡": "shuò,xī",
    "碏": "què,xī",
    "皵": "què",
    "礭": "què",
    "舃": "xì",
    "確": "què",
    "蒛": "quē",
    "舄": "xì",
    "鵲": "què",
    "囷": "qūn",
    "群": "qún",
    "夋": "qūn",
    "帬": "qún",
    "峮": "qún",
    "逡": "qūn",
    "羣": "qún",
    "裠": "qún",
    "輑": "yǐn",
    "亽": "jí",
    "罖": "wǎng",
    "囕": "lǎn",  # Unknow.
    "裙": "qún",
    "然": "rán",
    "染": "rǎn",
    "燃": "rán",
    "髯": "rán",
    "苒": "rǎn",
    "呥": "rán",
    "嘫": "rán",
    "蚺": "rán",
    "媣": "rǎn",
    "姌": "rǎn",
    "珃": "rǎn",
    "繎": "rán",
    "肰": "rán",
    "橪": "rǎn,yān",
    "舑": "tān",
    "蒅": "rǎn",
    "衻": "rán",
    "袇": "rán",
    "髥": "rán",
    "袡": "rán",
    "蚦": "rán",
    "让": "ràng",
    "嚷": "rǎng,rāng",
    "瓤": "ráng",
    "壤": "rǎng",
    "勷": "ráng,xiāng",
    "穰": "ráng",
    "禳": "ráng",
    "壌": "rǎng",
    "孃": "niáng",
    "忀": "xiāng",
    "儴": "ráng,xiāng",
    "懹": "ràng",
    "欀": "xiāng",
    "爙": "rǎng",
    "穣": "ráng",
    "獽": "ráng",
    "纕": "xiāng,rǎng",
    "躟": "ráng",
    "譲": "ràng",
    "讓": "ràng",
    "鑲": "xiāng",
    "镶": "xiāng",
    "饶": "ráo",
    "绕": "rào",
    "桡": "ráo,náo",
    "荛": "ráo",
    "嬈": "ráo,rǎo",
    "娆": "ráo,rǎo",
    "犪": "kuí",
    "穘": "xiāo,rào",
    "扰": "rǎo",
    "襓": "ráo",
    "繞": "rào",
    "遶": "rào",
    "蕘": "ráo",
    "隢": "rǎo",
    "擾": "rǎo",
    "饒": "ráo",
    "热": "rè",
    "若": "ruò,rě",
    "捼": "ruó,wěi,ré",
    "惹": "rě",
    "渃": "ruò,rè,luò",
    "偌": "ruò",
    "熱": "rè",
    "人": "rén",
    "忍": "rěn",
    "认": "rèn",
    "刃": "rèn",
    "仁": "rén",
    "韧": "rèn",
    "妊": "rèn",
    "纫": "rèn",
    "壬": "rén",
    "饪": "rèn",
    "轫": "rèn",
    "荏": "rěn",
    "葚": "shèn",
    "仭": "rèn",
    "衽": "rèn",
    "稔": "rěn",
    "刄": "rèn",
    "姙": "rèn",
    "屻": "rèn",
    "忈": "rén",
    "忎": "rén",
    "仞": "rèn",
    "扨": "rèn",
    "朲": "rén",
    "栠": "rěn",
    "梕": "rèn,ér",
    "栣": "rěn",
    "棯": "rěn,shěn",
    "秹": "rěn",
    "秂": "rén",
    "牣": "rèn",
    "紝": "rèn",
    "絍": "rèn",
    "綛": "rěn",
    "纴": "rèn",
    "紉": "rèn",
    "肕": "rèn",
    "芢": "rén",
    "荵": "rěn",
    "訒": "rèn",
    "袵": "rèn",
    "讱": "rèn",
    "認": "rèn",
    "躵": "rěn",
    "鈓": "rèn",
    "銋": "rén,rěn",
    "軔": "rèn",
    "靱": "rèn",
    "餁": "rèn",
    "靭": "rèn",
    "魜": "rén",
    "鵀": "rén",
    "飪": "rèn",
    "氜": "yáng,rì",
    "日": "rì",
    "韌": "rèn",
    "馹": "rì",
    "驲": "rì",
    "囸": "rì",
    "容": "róng",
    "融": "róng",
    "鈤": "rì",
    "绒": "róng",
    "溶": "róng",
    "熔": "róng",
    "荣": "róng",
    "戎": "róng",
    "冗": "rǒng",
    "蓉": "róng",
    "茸": "róng",
    "榕": "róng",
    "狨": "róng",
    "嵘": "róng",
    "傇": "rǒng",
    "傛": "róng",
    "蝾": "róng",
    "媶": "róng",
    "嫆": "róng",
    "嬫": "róng",
    "宂": "rǒng",
    "峵": "róng",
    "嵤": "róng,yíng",
    "搈": "róng",
    "曧": "róng",
    "嶸": "róng",
    "栄": "róng",
    "摉": "sōu",
    "榵": "róng",
    "毧": "róng",
    "氄": "rǒng",
    "榮": "róng",
    "瀜": "róng",
    "爃": "róng,yíng",
    "瑢": "róng",
    "穁": "róng",
    "穃": "ròng",
    "縙": "róng,rǒng,ròng",
    "烿": "róng",
    "絨": "róng",
    "縟": "rù",
    "缛": "rù",
    "羢": "róng",
    "茙": "róng",
    "螎": "róng",
    "鎔": "róng",
    "褣": "róng",
    "镕": "róng",
    "蠑": "róng",
    "駥": "róng",
    "頌": "sòng",
    "颂": "sòng",
    "柔": "róu",
    "肉": "ròu",
    "糅": "róu",
    "揉": "róu",
    "蹂": "róu",
    "媃": "róu",
    "鞣": "róu",
    "楺": "róu,ròu",
    "渘": "róu",
    "宍": "ròu",
    "瑈": "róu",
    "粈": "róu",
    "腬": "róu",
    "瓇": "róu",
    "煣": "róu",
    "葇": "róu",
    "輮": "róu",
    "鍒": "róu",
    "鑐": "xū",
    "騥": "róu",
    "禸": "róu",
    "鰇": "róu",
    "鶔": "róu",
    "如": "rú",
    "韖": "rǒu",
    "入": "rù",
    "汝": "rǔ",
    "儒": "rú",
    "茹": "rú",
    "乳": "rǔ",
    "辱": "rǔ",
    "蠕": "rú",
    "孺": "rú",
    "蓐": "rù",
    "襦": "rú",
    "铷": "rú",
    "嚅": "rú",
    "颥": "rú",
    "溽": "rù",
    "洳": "rù",
    "侞": "rú",
    "偄": "ruǎn",
    "咮": "zhòu",
    "嗕": "rù",
    "媷": "rù",
    "嶿": "rū",
    "帤": "rú",
    "扖": "rù",
    "曘": "rú",
    "薷": "rú",
    "月": "yuè",
    "杁": "rù",
    "桇": "rú",
    "燸": "xū",
    "筎": "rú",
    "繻": "rú",
    "肗": "rǔ",
    "蕠": "rú",
    "袽": "rú",
    "鄏": "rǔ",
    "込": "yū",
    "醹": "rú",
    "銣": "rú",
    "鱬": "rú",
    "顬": "rú",
    "鳰": "rù",
    "鴑": "rú",
    "鴽": "rú",
    "软": "ruǎn",
    "阮": "ruǎn",
    "撋": "ruán",
    "壖": "ruán",
    "朊": "ruǎn",
    "瓀": "ruǎn",
    "瑌": "ruǎn",
    "緛": "ruǎn,ruàn",
    "礝": "ruǎn",
    "蝡": "rú",
    "軟": "ruǎn",
    "瑞": "ruì",
    "碝": "ruǎn",
    "睿": "ruì",
    "壡": "ruǐ",
    "蕤": "ruí",
    "惢": "suǒ,ruǐ",
    "芮": "ruì",
    "桵": "ruí",
    "棁": "zhuō",
    "叡": "ruì",
    "橤": "ruǐ",
    "汭": "ruì",
    "甤": "ruí",
    "笍": "zhuì,ruì",
    "蚋": "ruì",
    "緌": "ruí",
    "綏": "suí",
    "繠": "ruǐ",
    "苼": "shēng,ruí",
    "绥": "suí",
    "蘃": "ruǐ",
    "蘂": "ruǐ",
    "蜹": "ruì",
    "踒": "wō",
    "橍": "rùn",
    "润": "rùn",
    "闰": "rùn",
    "潤": "rùn",
    "閠": "rùn",
    "閏": "rùn",
    "叒": "ruò",
    "弱": "ruò",
    "楉": "ruò",
    "爇": "ruò",
    "焫": "ruò",
    "蒻": "ruò",
    "鄀": "ruò",
    "鰙": "ruò",
    "嵶": "ruò",
    "鶸": "ruò",
    "鰯": "ruò",
    "洒": "sǎ,xǐ",
    "撒": "sā,sǎ",
    "萨": "sà",
    "挲": "suō,shā",
    "仨": "sā",
    "脎": "sà",
    "卅": "sà",
    "桬": "shā",
    "摋": "sà,shā,shǎi",
    "櫒": "sà",
    "泧": "yuè,sà",
    "殺": "shā",
    "訯": "sǎ",
    "薩": "sà",
    "躠": "sǎ,xiè",
    "鈒": "sà",
    "鏾": "sǎn,xiàn,sà",
    "潵": "sàn,sǎ",
    "钑": "sà,xì",
    "隡": "sà",
    "霅": "zhá",
    "靸": "sǎ",
    "栍": "shēng",  # Unknow.
    "馺": "sà",
    "塞": "sāi,sài,sè",
    "腮": "sāi",
    "鳃": "sāi,xǐ",
    "思": "sī,sāi",
    "赛": "sài",
    "噻": "sāi",
    "僿": "sài",
    "嗮": "sǎi",
    "嘥": "sāi",
    "愢": "sāi,sī,sǐ",
    "毢": "sāi",
    "毸": "sāi,suī",
    "簑": "suō",
    "顋": "sāi",
    "賽": "sài",
    "乷": "shā",
    "簺": "sài",
    "虄": "sà",  # Unknow.
    "鰓": "sāi",
    "三": "sān",
    "散": "sàn,sǎn",
    "伞": "sǎn",
    "叁": "sān",
    "馓": "sǎn",
    "糁": "sǎn,shēn",
    "毵": "sān",
    "霰": "xiàn",
    "厁": "sān",
    "壭": "san",
    "弎": "sān",
    "傘": "sǎn",
    "俕": "sàn",
    "橵": "zān",
    "毶": "sān",
    "犙": "sān",
    "糂": "shēn",
    "糣": "sǎn,shēn",
    "繖": "sǎn",
    "糤": "sǎn",
    "糝": "sǎn,shēn",
    "閐": "sàn",
    "蔘": "shēn",
    "毿": "sān",
    "鬖": "sān",
    "饊": "sǎn",
    "彡": "shān,xiǎn",
    "氵": "shuǐ",
    "颡": "sǎng",
    "嗓": "sǎng",
    "桑": "sāng",
    "丧": "sāng,sàng",
    "磉": "sǎng",
    "搡": "sǎng",
    "喪": "sāng,sàng",
    "槡": "sāng",
    "鎟": "sǎng",
    "褬": "sǎng",
    "桒": "sāng",
    "顙": "sǎng",
    "扫": "sǎo,sào",
    "骚": "sāo,sǎo",
    "搔": "sāo",
    "嫂": "sǎo",
    "埽": "sào,sǎo",
    "鳋": "sāo",
    "梢": "shāo,sào",
    "臊": "sāo,sào",
    "缫": "sāo",
    "哨": "shào",
    "掻": "sāo",
    "瘙": "sào",
    "掃": "sǎo,sào",
    "氉": "sào",
    "溞": "sāo",
    "煰": "zào",
    "矂": "sào",
    "燥": "zào",
    "颾": "sāo,sōu",
    "騒": "sāo",
    "繅": "sāo",
    "騷": "sāo",
    "髞": "sào",
    "縿": "shān",
    "鱢": "sāo",
    "鰠": "sāo",
    "色": "sè",
    "涩": "sè",
    "瑟": "sè",
    "啬": "sè",
    "铯": "sè",
    "嗇": "sè",
    "穑": "sè",
    "懎": "sè",
    "擌": "sè",
    "歮": "sè",
    "愬": "sù,shuò",
    "歰": "sè,shà",
    "渋": "sè",
    "澁": "sè",
    "濏": "sè",
    "濇": "sè",
    "澀": "sè",
    "瀒": "sè",
    "瘷": "sè",
    "璱": "sè",
    "穯": "sè",
    "繬": "sè",
    "溹": "suò",
    "虩": "xì",
    "穡": "sè",
    "譅": "sè",
    "鎍": "suǒ,sè",
    "轖": "sè",
    "鎩": "shā",
    "鏼": "sè",
    "銫": "sè",
    "铩": "shā",
    "闟": "xì,sè,tà",
    "雭": "sè,xí",
    "飋": "sè",
    "裇": "xū",
    "聓": "xù",
    "槮": "sēn",
    "森": "sēn",
    "襂": "sēn",
    "鬙": "sēng",
    "閪": "sē,xī",
    "縇": "xuān",  # Unknow.
    "沙": "shā,shà",
    "杀": "shā",
    "啥": "shá",
    "傻": "shǎ",
    "砂": "shā",
    "莎": "suō,shā",
    "煞": "shā,shà",
    "杉": "shā",
    "厦": "shà,xià",
    "鲨": "shā",
    "霎": "shà",
    "痧": "shā",
    "倽": "shà",
    "裟": "shā",
    "歃": "shà",
    "儍": "shǎ",
    "唦": "shā",
    "挱": "suō,shā",
    "榝": "shā,xiè",
    "噎": "yē",
    "樧": "shā,xiè",
    "廈": "shà,xià",
    "硰": "shā",
    "猀": "shā",
    "箑": "shà",
    "繺": "shā",
    "繌": "zōng,zòng",
    "翜": "shà",
    "翣": "shà",
    "萐": "shà",
    "蔱": "shā",
    "賖": "shē",
    "賒": "shē",
    "閯": "shà",
    "閷": "shā",
    "赊": "shē",
    "魦": "shā",
    "鯋": "shā",
    "鯊": "shā",
    "晒": "shài",
    "筛": "shāi",
    "酾": "shī",
    "曬": "shài",
    "篩": "shāi",
    "簁": "shāi",
    "簛": "shāi,sī",
    "籭": "shāi",
    "術": "shù",
    "山": "shān",
    "闪": "shǎn",
    "衫": "shān",
    "善": "shàn",
    "扇": "shàn,shān",
    "删": "shān",
    "膳": "shàn",
    "陕": "shǎn",
    "煽": "shān",
    "珊": "shān",
    "汕": "shàn",
    "缮": "shàn",
    "蟮": "shàn",
    "芟": "shān",
    "鄯": "shàn",
    "潸": "shān",
    "跚": "shān",
    "擅": "shàn",
    "鳝": "shàn",
    "剡": "yǎn,shàn",
    "骟": "shàn",
    "讪": "shàn",
    "疝": "shàn",
    "钐": "shān,shàn",
    "傓": "shān",
    "埏": "yán,shān",
    "舢": "shān",
    "僐": "shàn",
    "剼": "shān",
    "刪": "shān",
    "墡": "shàn",
    "挻": "shān",
    "嶦": "zhān,shàn",
    "掞": "shàn,yàn,yǎn",
    "搧": "shān",
    "敾": "shàn",
    "圸": "shān",
    "晱": "shǎn",
    "曑": "shēn",
    "杣": "mián",
    "曏": "xiàng",
    "樿": "shàn",
    "椫": "shàn",
    "潬": "tān,shàn",
    "澘": "shān",
    "檀": "tán",
    "灗": "shàn",
    "烻": "yàn",
    "熌": "shǎn",
    "痁": "shān,diàn",
    "狦": "shān",
    "檆": "shān",
    "睒": "shǎn",
    "磰": "shàn",
    "笘": "shān",
    "羴": "shān",
    "葠": "shēn",
    "繕": "shàn",
    "羶": "shān",
    "襳": "xiān",
    "覢": "shǎn",
    "謆": "shàn",
    "譱": "shàn",
    "訕": "shàn",
    "軕": "shān",
    "邖": "shān",
    "赸": "shàn",
    "銏": "shàn,shuò",
    "鐥": "shàn",
    "閊": "shān",
    "釤": "shān,shàn",
    "顃": "tán",
    "閃": "shǎn",
    "陝": "shǎn",
    "鯅": "shān",
    "饍": "shàn",
    "鱓": "shàn",
    "騸": "shàn",
    "鱣": "zhān",
    "上": "shàng,shǎng",
    "鳣": "zhān,shàn",
    "伤": "shāng",
    "鱔": "shàn",
    "商": "shāng",
    "赏": "shǎng",
    "墒": "shāng",
    "熵": "shāng",
    "晌": "shǎng",
    "觞": "shāng",
    "绱": "shàng",
    "汤": "tāng,shāng",
    "殇": "shāng",
    "仩": "cháng",
    "恦": "shàng",
    "丄": "shàng",
    "慯": "shāng",
    "傷": "shāng",
    "滳": "shāng",
    "殤": "shāng",
    "漡": "shāng",
    "湯": "tāng,shāng",
    "禓": "shāng,yáng",
    "蔏": "shāng",
    "螪": "shāng",
    "謪": "shāng",
    "緔": "shàng",
    "觴": "shāng",
    "鑜": "shǎng",
    "賞": "shǎng",
    "踼": "táng",
    "鞝": "shàng,zhǎng",
    "鬺": "shāng",
    "少": "shǎo,shào",
    "稍": "shāo,shào",
    "韶": "sháo",
    "邵": "shào",
    "烧": "shāo",
    "召": "zhào,shào",
    "劭": "shào",
    "苕": "tiáo,sháo",
    "艄": "shāo",
    "潲": "shào",
    "蛸": "xiāo",
    "娋": "shào,shāo",
    "筲": "shāo",
    "卲": "shào",
    "弰": "shāo",
    "搜": "sōu",
    "旓": "shāo",
    "柖": "sháo,shào",
    "佋": "zhāo,shào",
    "溲": "sōu",
    "燿": "yào",
    "燒": "shāo",
    "玿": "sháo",
    "焼": "shāo",
    "笤": "tiáo",
    "綃": "xiāo",
    "莦": "shāo,xiāo",
    "萔": "tiáo",
    "绡": "xiāo",
    "萷": "shāo",
    "蕱": "shāo",
    "袑": "shào",
    "輎": "shāo",
    "颵": "xiāo",
    "髾": "shāo",
    "鮹": "shāo",
    "社": "shè",
    "射": "shè,yè,yì",
    "舍": "shè",
    "设": "shè",
    "折": "zhē,zhé,shé",
    "慑": "shè",
    "奢": "shē",
    "厍": "shè",
    "猞": "shē",
    "畲": "shē",
    "歙": "xī,shè",
    "麝": "shè",
    "佘": "shé",
    "弽": "shè",
    "慴": "shè",
    "厙": "shè",
    "抴": "yè",
    "捨": "shě",
    "檨": "shē",
    "懾": "shè",
    "欇": "shè",
    "涻": "shè",
    "畬": "shē,yú",
    "磼": "jí,shé",
    "舎": "shè",
    "蔎": "shè",
    "葉": "yè",
    "蛥": "shé",
    "蠂": "shè",
    "虵": "shé",
    "輋": "shē",
    "韘": "shè,xiè",
    "騇": "shè",
    "設": "shè",
    "伸": "shēn",
    "深": "shēn",
    "神": "shén",
    "婶": "shěn",
    "甚": "shèn,shén",
    "肾": "shèn",
    "申": "shēn",
    "绅": "shēn",
    "砷": "shēn",
    "呻": "shēn",
    "什": "shí,shén",
    "娠": "shēn",
    "慎": "shèn",
    "莘": "shēn,xīn",
    "诜": "shēn",
    "椹": "zhēn,shèn",
    "矧": "shěn",
    "渖": "shěn",
    "侁": "shēn",
    "哂": "shěn",
    "侺": "shèn",
    "蜃": "shèn",
    "兟": "shēn",
    "信": "xìn,shēn",
    "堔": "shēn",
    "妽": "shēn",
    "吲": "yǐn,shěn",
    "姺": "shēn,xiān",
    "孞": "xìn",
    "屾": "shēn",
    "嬸": "shěn",
    "峷": "shēn",
    "弞": "shěn",
    "愼": "shèn",
    "扟": "shēn",
    "搷": "tián,shēn",
    "昚": "shèn",
    "曋": "shěn",
    "柛": "shēn",
    "椮": "sēn",
    "燊": "shēn",
    "榊": "shén",
    "氠": "shēn",
    "珅": "shēn",
    "甡": "shēn",
    "甧": "shēn",
    "瘆": "shèn",
    "瘮": "shèn",
    "眒": "shēn",
    "矤": "shěn",
    "祳": "shèn",
    "穼": "shēn",
    "瞫": "shěn",
    "籶": "shēn",
    "眘": "shèn",
    "籸": "shēn",
    "罧": "shēn",
    "脤": "shèn",
    "腎": "shèn",
    "蓡": "shēn",
    "紳": "shēn",
    "薓": "shēn",
    "蜄": "shèn",
    "覾": "shěn",
    "裑": "shēn",
    "訠": "shěn",
    "訷": "shēn",
    "讅": "shěn",
    "谉": "shěn",
    "邥": "shěn",
    "詵": "shēn",
    "鋠": "shèn",
    "頣": "shěn",
    "駪": "shēn",
    "魫": "shěn",
    "震": "zhèn",
    "鯓": "shēn",
    "鰰": "shén",
    "鵢": "shēn",
    "省": "shěng,xǐng",
    "生": "shēng",
    "升": "shēng",
    "剩": "shèng",
    "甥": "shēng",
    "牲": "shēng",
    "偗": "shěng",
    "笙": "shēng",
    "眚": "shěng",
    "剰": "shèng",
    "呏": "shēng",
    "墭": "shèng",
    "勝": "shèng",
    "冼": "xiǎn",
    "憴": "shéng",
    "姓": "xìng",
    "斘": "shēng",
    "媵": "yìng",
    "晠": "shèng",
    "昇": "shēng",
    "曻": "shēng",
    "榺": "shèng",
    "橳": "shèng",
    "殅": "shēng",
    "泩": "shēng",
    "渻": "shěng",
    "枡": "shēng",
    "湦": "shēng",
    "狌": "shēng,xīng",
    "焺": "shēng",
    "珄": "shēng",
    "琞": "shèng",
    "竔": "shēng",
    "縄": "shéng",
    "箵": "xīng",
    "蕂": "shèng",
    "聖": "shèng",
    "聲": "shēng",
    "譝": "shéng",
    "貹": "shèng",
    "賸": "shèng",
    "鉎": "shēng",
    "鍟": "shēng",
    "阩": "shēng",
    "陞": "shēng",
    "鵿": "shēng",
    "陹": "shēng",
    "鼪": "shēng",
    "是": "shì",
    "使": "shǐ",
    "十": "shí",
    "时": "shí",
    "事": "shì",
    "室": "shì",
    "师": "shī",
    "试": "shì",
    "史": "shǐ",
    "式": "shì",
    "识": "shí,zhì",
    "虱": "shī",
    "矢": "shǐ",
    "驶": "shǐ",
    "始": "shǐ",
    "似": "sì,shì",
    "嘘": "xū,shī",
    "士": "shì",
    "屎": "shǐ",
    "拭": "shì",
    "誓": "shì",
    "柿": "shì",
    "逝": "shì",
    "势": "shì",
    "殖": "zhí,shi",
    "世": "shì",
    "峙": "zhì,shì",
    "嗜": "shì",
    "噬": "shì",
    "失": "shī",
    "仕": "shì",
    "释": "shì",
    "侍": "shì",
    "狮": "shī",
    "食": "shí,sì,yì",
    "恃": "shì",
    "蚀": "shí",
    "视": "shì",
    "实": "shí",
    "施": "shī",
    "湿": "shī",
    "诗": "shī",
    "尸": "shī",
    "莳": "shì,shí",
    "豕": "shǐ",
    "埘": "shí",
    "铈": "shì",
    "舐": "shì",
    "鲥": "shí",
    "轼": "shì",
    "鲺": "shī",
    "贳": "shì",
    "蓍": "shī",
    "筮": "shì",
    "炻": "shí",
    "弑": "shì",
    "乨": "shǐ",
    "螫": "shì,zhē",
    "亊": "shì",
    "佀": "sì",
    "丗": "shì",
    "佦": "yòu",
    "兘": "shǐ",
    "谥": "shì",
    "冟": "shì",
    "卋": "shì",
    "呞": "shī",
    "勢": "shì",
    "呩": "shì",
    "厔": "zhì,shī",
    "埶": "yì,shì",
    "唑": "zuò",
    "噓": "xū,shī",
    "奭": "shì",
    "媞": "tí",
    "塒": "shí",
    "実": "shí",
    "嬕": "shì",
    "宩": "shǐ",
    "寔": "shí",
    "寺": "sì",
    "實": "shí",
    "嵵": "shí",
    "峕": "shí",
    "屍": "shī",
    "師": "shī",
    "弒": "shì",
    "徥": "shì,tǐ",
    "忕": "shì,tài",
    "恀": "shì",
    "惿": "tí,shì",
    "戺": "shì",
    "揓": "shì",
    "旹": "shí",
    "昰": "shì",
    "斯": "sī",
    "時": "shí",
    "枾": "shì",
    "栻": "shì",
    "榁": "shǐ",
    "榯": "shí",
    "檡": "zhái,shì,tú",
    "洂": "yè",
    "汁": "zhī",
    "浉": "shī",
    "湜": "shí",
    "湤": "shī",
    "溡": "shí",
    "溮": "shī",
    "液": "yè",
    "溼": "shī",
    "烒": "shì",
    "煶": "shì",
    "狶": "xī,shǐ",
    "狧": "tà,shì",
    "濕": "shī",
    "瑡": "shī",
    "痑": "tān,shǐ",
    "眎": "shì",
    "獅": "shī",
    "眡": "shì",
    "眂": "shì",
    "祏": "shí",
    "禵": "tí",
    "礻": "shì",
    "睗": "shì",
    "秲": "shì,zhì",
    "竍": "shí",
    "笶": "shǐ",
    "笹": "tì",
    "箷": "shī,yí",
    "篒": "yì",
    "簭": "shì",
    "籂": "shi",
    "绎": "yì",
    "胑": "zhī",
    "繹": "yì",
    "舓": "shì",
    "葹": "shī",
    "肢": "zhī",
    "蒒": "shī",
    "絁": "shī",
    "蝨": "shī",
    "褆": "tí",
    "褷": "shī",
    "襫": "shì",
    "襹": "shī",
    "觢": "shì",
    "視": "shì",
    "蒔": "shì,shí",
    "詩": "shī",
    "試": "shì",
    "諡": "shì",
    "謚": "shì",
    "跩": "zhuǎi",
    "辻": "shi",
    "識": "shí",
    "貰": "shì",
    "軾": "shì",
    "遈": "shí",
    "遾": "shì",
    "邿": "shī",
    "醳": "yì,shì",
    "釈": "shì",
    "鉂": "shǐ",
    "釶": "shī,yí",
    "鈰": "shì",
    "鉃": "shì",
    "釋": "shì",
    "鉇": "shī",
    "鉐": "shí",
    "鉽": "shì",
    "銴": "shì,zhì",
    "鍦": "shī",
    "鉈": "tā",
    "餙": "shì",
    "铊": "tā,tuó",
    "馶": "zhī,shì",
    "飠": "shí",
    "魳": "zā",
    "鮖": "shí",
    "饣": "shí",
    "駛": "shǐ",
    "鰘": "shì",
    "鯴": "shī",
    "鰤": "shī",
    "鰣": "shí",
    "鳲": "shī",
    "鳾": "shī",
    "鸤": "shī",
    "鼭": "shí",
    "鶳": "shī",
    "鼫": "shí",
    "齛": "xiè",
    "齥": "xiè",
    "收": "shōu",
    "首": "shǒu",
    "手": "shǒu",
    "守": "shǒu",
    "瘦": "shòu",
    "授": "shòu",
    "兽": "shòu",
    "售": "shòu",
    "寿": "shòu",
    "熟": "shú",
    "狩": "shòu",
    "収": "shōu",
    "艏": "shǒu",
    "垨": "shǒu",
    "夀": "shòu",
    "绶": "shòu",
    "壽": "shòu",
    "獣": "shòu",
    "涭": "shòu,tāo",
    "扌": "shǒu",
    "痩": "shòu",
    "獸": "shòu",
    "膄": "shòu",
    "綬": "shòu",
    "鏉": "shòu,sōu",
    "书": "shū",
    "树": "shù",
    "数": "shù,shǔ,shuò",
    "输": "shū",
    "叔": "shū",
    "梳": "shū",
    "束": "shù",
    "蜀": "shǔ",
    "属": "shǔ,zhǔ",
    "述": "shù",
    "术": "shù,shú,zhú",
    "赎": "shú",
    "鼠": "shǔ",
    "黍": "shǔ",
    "疏": "shū",
    "孰": "shú",
    "蔬": "shū",
    "戍": "shù",
    "墅": "shù",
    "竖": "shù",
    "薯": "shǔ",
    "庶": "shù",
    "恕": "shù",
    "漱": "shù",
    "枢": "shū",
    "暑": "shǔ",
    "抒": "shū",
    "殊": "shū",
    "曙": "shǔ",
    "署": "shǔ",
    "纾": "shū",
    "秫": "shú",
    "舒": "shū",
    "姝": "shū",
    "毹": "shū",
    "沭": "shù",
    "腧": "shù",
    "塾": "shú",
    "殳": "shū",
    "俆": "xú",
    "澍": "shù,zhù",
    "倏": "shū",
    "儵": "shū",
    "倐": "shū",
    "俞": "yú,yù,shù",
    "兪": "yú,shù",
    "咰": "shù,xún",
    "婌": "shū",
    "尗": "shú",
    "尌": "shù,zhù",
    "庻": "shù",
    "嗽": "sòu",
    "忬": "yù,shū",
    "屬": "shǔ,zhǔ",
    "怷": "shù",
    "捒": "shù,sǒng,sōu",
    "悆": "yù,shū",
    "掓": "shū",
    "朮": "shù,shú,zhú",
    "數": "shù,shǔ,shuò",
    "書": "shū",
    "柕": "mào",
    "朱": "zhū,shú",
    "毺": "shū",
    "杼": "zhù",
    "樹": "shù",
    "潄": "shù",
    "潻": "shǔ",
    "涑": "sù",
    "濖": "shù",
    "瀭": "shū",
    "焂": "shū",
    "瑹": "tú,shū",
    "璹": "shú",
    "稌": "tú,shǔ",
    "癙": "shǔ",
    "籔": "sǒu,shǔ",
    "疎": "shū",
    "糬": "shǔ",
    "紵": "zhù",
    "竪": "shù",
    "絉": "shù",
    "綀": "shū",
    "荗": "shù",
    "蒁": "shù",
    "紓": "shū",
    "蒣": "xú,shú",
    "薥": "shǔ",
    "藷": "shǔ",
    "虪": "shù",
    "蠴": "shǔ",
    "翛": "xiāo",
    "蠾": "zhú",
    "裋": "shù",
    "謶": "zhuó",
    "豎": "shù",
    "豫": "yù",
    "軗": "shū",
    "踈": "shū",
    "贖": "shú",
    "輸": "shū",
    "鄃": "shū",
    "透": "tòu",
    "鉥": "shù",
    "錰": "shù",
    "野": "yě",
    "鏣": "shù",
    "陎": "shū",
    "镯": "zhuó",
    "隃": "yú,yáo,shù",
    "鐲": "zhuó",
    "鱪": "shǔ",
    "鮛": "shū",
    "鵨": "shū",
    "鱰": "shǔ",
    "鶐": "shù",
    "鼡": "shǔ",
    "鷸": "yù",
    "鹬": "yù",
    "忄": "xīn",
    "唰": "shuā",
    "刷": "shuā,shuà",
    "耍": "shuǎ",
    "誜": "shuà",
    "涮": "shuàn",
    "唆": "suō",
    "选": "xuǎn",
    "選": "xuǎn",
    "摔": "shuāi",
    "甩": "shuǎi",
    "蟀": "shuài",
    "帅": "shuài",
    "栓": "shuān",
    "闩": "shuān",
    "腨": "shuàn",
    "帥": "shuài",
    "閂": "shuān",
    "双": "shuāng",
    "霜": "shuāng",
    "專": "zhuān",
    "傱": "sǒng",
    "爽": "shuǎng",
    "孇": "shuāng",
    "塽": "shuǎng",
    "孀": "shuāng",
    "慡": "shuǎng",
    "樉": "shǎng",
    "欆": "shuāng",
    "灀": "shuàng",
    "縔": "shuǎng",
    "礵": "shuāng",
    "艭": "shuāng",
    "鏯": "shuǎng",
    "驦": "shuāng",
    "騻": "shuāng",
    "骦": "shuāng",
    "鷞": "shuāng",
    "鸘": "shuāng",
    "雙": "shuāng",
    "鹴": "shuāng",
    "水": "shuǐ",
    "谁": "shuí",
    "睡": "shuì",
    "娷": "zhuì,shuì",
    "税": "shuì",
    "说": "shuō,shuì,yuè",
    "帨": "shuì",
    "挩": "tuō,shuì",
    "捝": "tuō,shuì",
    "氺": "shuǐ",
    "涗": "shuì",
    "涚": "shuì",
    "脽": "shuí",
    "裞": "shuì",
    "稅": "shuì",
    "説": "shuō,shuì,yuè",
    "說": "shuō,shuì,yuè",
    "誰": "shuí,shéi",
    "閖": "shuǐ",
    "顺": "shùn",
    "吮": "shǔn",
    "瞬": "shùn",
    "廵": "xún",
    "舜": "shùn",
    "橓": "shùn",
    "巡": "xún",
    "瞚": "shùn",
    "恂": "xún",
    "眴": "xuàn,shùn,xún",
    "瞤": "rún,shùn",
    "蕣": "shùn",
    "鬊": "shùn",
    "順": "shùn",
    "朔": "shuò",
    "硕": "shuò,shí",
    "搠": "shuò",
    "妁": "shuò",
    "槊": "shuò",
    "哾": "chuò,yuè",
    "蒴": "shuò",
    "欶": "shuò,sòu",
    "嗍": "suō",
    "洬": "sù,shuò",
    "矟": "shuò",
    "碩": "shuò,shí",
    "鎙": "shuò",
    "濯": "zhuó,zhào",
    "溯": "sù",
    "四": "sì",
    "死": "sǐ",
    "撕": "sī",
    "丝": "sī",
    "私": "sī",
    "肆": "sì",
    "饲": "sì",
    "嗣": "sì",
    "嘶": "sī",
    "巳": "sì",
    "耜": "sì",
    "驷": "sì",
    "兕": "sì",
    "蛳": "sī",
    "锶": "sī",
    "汜": "sì",
    "泗": "sì",
    "鸶": "sī",
    "姒": "sì",
    "笥": "sì",
    "咝": "sī",
    "厮": "sī",
    "缌": "sī",
    "祀": "sì",
    "亖": "sì",
    "価": "sì",
    "俬": "sī",
    "澌": "sī",
    "傂": "zhì,sī",
    "以": "yǐ",
    "儩": "sì",
    "凘": "sī",
    "台": "tái,tāi",
    "娰": "sì",
    "噝": "sī",
    "媤": "sī",
    "孠": "sì",
    "恖": "sī",
    "廝": "sī",
    "杫": "sì,zhǐ,xǐ",
    "柶": "sì",
    "徙": "xǐ",
    "楒": "sī",
    "榹": "sì",
    "析": "xī",
    "泀": "sī",
    "涘": "sì",
    "燍": "sī",
    "瀃": "sì",
    "牭": "sì",
    "磃": "sī,tí",
    "禠": "sī",
    "禗": "sī",
    "禩": "sì",
    "泤": "sì",
    "竢": "sì",
    "洍": "sì",
    "罒": "wǎng",
    "絲": "sī",
    "糹": "sī",
    "罳": "sī",
    "肂": "sì",
    "緦": "sī",
    "蕬": "sī",
    "蕼": "sì",
    "肄": "yì",
    "菥": "xī",
    "虒": "sī",
    "蜤": "sī",
    "螔": "yí",
    "蟴": "sī",
    "螄": "sī",
    "覗": "sì",
    "謕": "tí",
    "逘": "yǐ",
    "貄": "sì",
    "蟖": "sī",
    "鈻": "sì",
    "釲": "sì",
    "鉰": "sī",
    "銉": "yù,sì",
    "銯": "sī",
    "鋖": "sī,tuó",
    "鐁": "sī",
    "颸": "sī",
    "鍶": "sī",
    "飤": "sì",
    "飔": "sī",
    "飴": "yí,sì",
    "飼": "sì",
    "饴": "yí",
    "騦": "sī",
    "鷉": "tī",
    "駟": "sì",
    "鼶": "sī",
    "螦": "sāo",
    "乺": "suǒ",
    "鷥": "sī",
    "送": "sòng",
    "宋": "sòng",
    "松": "sōng",
    "耸": "sǒng",
    "怂": "sǒng",
    "讼": "sòng",
    "竦": "sǒng",
    "菘": "sōng",
    "淞": "sōng",
    "嵩": "sōng",
    "悚": "sǒng",
    "倯": "sōng",
    "诵": "sòng",
    "凇": "sōng",
    "崧": "sōng",
    "吅": "xuān,sòng",
    "忪": "sōng,zhōng",
    "庺": "sōng",
    "嵷": "sǒng",
    "娀": "sōng",
    "愯": "sǒng",
    "捴": "zǒng",
    "憽": "sōng",
    "摗": "sōu,sǒng",
    "慫": "sǒng",
    "枀": "sōng",
    "柗": "sōng",
    "揔": "zǒng,sōng",
    "枩": "sōng",
    "檧": "sōng",
    "硹": "sōng",
    "梥": "sōng",
    "濍": "sōng",
    "蜙": "zhōng",
    "鎹": "sòng",
    "訟": "sòng",
    "誦": "sòng",
    "餸": "sòng",
    "駷": "sǒng",
    "鬆": "sōng",
    "聳": "sǒng",
    "艘": "sōu",
    "擞": "sòu,sǒu",
    "嗖": "sōu",
    "飕": "sōu",
    "叟": "sǒu",
    "瞍": "sǒu",
    "锼": "sōu",
    "傁": "sǒu",
    "凁": "sōu",
    "螋": "sǒu",
    "叜": "sǒu",
    "嗾": "sǒu",
    "廀": "sōu",
    "廋": "sōu",
    "捜": "sōu",
    "棷": "zōu,sǒu",
    "馊": "sōu",
    "撨": "xiāo,sōu",
    "櫢": "sǒu",
    "潚": "sù",
    "擻": "sòu,sǒu",
    "獀": "sōu",
    "瘶": "sòu",
    "謏": "xiǎo",
    "蓃": "sōu,sǒu",
    "鄋": "sōu",
    "醙": "sōu",
    "颼": "sōu",
    "鎪": "sōu",
    "騪": "sōu",
    "餿": "sōu",
    "诉": "sù",
    "素": "sù",
    "速": "sù",
    "塑": "sù",
    "俗": "sú",
    "苏": "sū,sù",
    "肃": "sù",
    "粟": "sù",
    "缩": "suō,sù",
    "酥": "sū",
    "愫": "sù",
    "僳": "sù",
    "簌": "sù",
    "稣": "sū",
    "觫": "sù",
    "谡": "sù",
    "夙": "sù",
    "嗉": "sù",
    "傃": "sù",
    "僁": "xiè",
    "卹": "xù",
    "囌": "sū",
    "蔌": "sù",
    "埣": "suì,sù",
    "塐": "sù",
    "嫊": "sù",
    "憟": "sù",
    "梀": "sù,yìn",
    "榡": "sù",
    "樎": "sù",
    "樕": "sù",
    "櫯": "sū",
    "殐": "sù",
    "泝": "sù",
    "溸": "sù",
    "潥": "sù",
    "玊": "sù",
    "珟": "sù",
    "甦": "sū",
    "璛": "sù",
    "碿": "sù,xiè",
    "稡": "zuì,zú,sū",
    "窣": "sū",
    "粛": "sù",
    "穌": "sū",
    "縤": "sù",
    "縮": "suō,sù",
    "膆": "sù",
    "肅": "sù",
    "莤": "sù,yóu",
    "藗": "sù",
    "蘓": "sū",
    "蘇": "sū",
    "訴": "sù",
    "趚": "sù",
    "謖": "sù",
    "蹜": "sù",
    "遬": "sù",
    "遡": "sù",
    "鋉": "sù",
    "驌": "sù",
    "餗": "sù",
    "骕": "sù",
    "鱐": "sù",
    "鯂": "sū",
    "鷫": "sù",
    "鹔": "sù",
    "算": "suàn",
    "酸": "suān",
    "匴": "suǎn",
    "蒜": "suàn",
    "痠": "suān",
    "撰": "zhuàn",
    "筭": "suàn",
    "笇": "suàn",
    "祘": "suàn",
    "岁": "suì",
    "碎": "suì",
    "随": "suí",
    "虽": "suī",
    "穗": "suì",
    "遂": "suì",
    "髓": "suǐ",
    "隧": "suì",
    "祟": "suì",
    "谇": "suì",
    "濉": "suī",
    "邃": "suì",
    "荽": "suī",
    "亗": "suì",
    "倠": "suī",
    "嗺": "zuī,suī",
    "哸": "suī",
    "夊": "suī",
    "嵗": "suì",
    "嬘": "suì",
    "檖": "suì",
    "旞": "suì",
    "燧": "suì",
    "滖": "suī",
    "歳": "suì",
    "歲": "suì",
    "瀡": "suǐ",
    "澻": "suì",
    "煫": "suì",
    "璲": "suì",
    "瓍": "suí",
    "睟": "suì,zuì",
    "砕": "suì",
    "穂": "suì",
    "禭": "suì",
    "穟": "suì",
    "繐": "suì",
    "繸": "suì",
    "膸": "suǐ",
    "芕": "suī",
    "荾": "suī",
    "襚": "suì",
    "譢": "suì",
    "蓑": "suō",
    "誶": "suì",
    "賥": "suì",
    "遀": "suí",
    "遗": "yí",
    "鐆": "suì",
    "鐩": "suì",
    "遺": "yí",
    "隨": "suí",
    "鞖": "suī",
    "雖": "suī",
    "髄": "suí",
    "孙": "sūn,xùn",
    "损": "sǔn",
    "笋": "sǔn",
    "飧": "sūn",
    "榫": "sǔn",
    "荪": "sūn",
    "狲": "sūn",
    "隼": "sǔn",
    "巺": "xùn",
    "搎": "sūn",
    "孫": "sūn,xùn",
    "槂": "sūn",
    "潠": "xùn",
    "損": "sǔn",
    "畃": "xún",
    "箰": "sǔn",
    "猻": "sūn",
    "簨": "sǔn,zhuàn",
    "筍": "sǔn",
    "蕵": "sūn",
    "薞": "sūn",
    "蓀": "sūn",
    "鎨": "sǔn",
    "鶽": "sǔn,xùn",
    "跣": "xiǎn",
    "所": "suǒ",
    "锁": "suǒ",
    "琐": "suǒ",
    "索": "suǒ",
    "唢": "suǒ",
    "梭": "suō",
    "桫": "suō",
    "娑": "suō",
    "嗦": "suō",
    "羧": "suō",
    "傞": "suō",
    "些": "xiē,suò",
    "摍": "suō",
    "溑": "suǒ",
    "暛": "suǒ",
    "嗩": "suǒ",
    "犧": "xī",
    "琑": "suǒ",
    "牺": "xī",
    "獻": "xiàn",
    "瑣": "suǒ",
    "璅": "zǎo,suǒ",
    "莏": "suō",
    "簔": "suō",
    "蜶": "suò",
    "趖": "suō",
    "鎻": "suǒ",
    "鏁": "suǒ",
    "鎖": "suǒ",
    "逤": "suò",
    "髿": "shā",
    "鮻": "suō",
    "他": "tā",
    "它": "tā",
    "踏": "tà",
    "拓": "tuò,tà,zhí",
    "獭": "tǎ",
    "挞": "tà",
    "蹋": "tà",
    "溻": "tā",
    "榻": "tà",
    "遢": "tà",
    "傝": "tà,tàn",
    "侤": "ta",
    "闼": "tà",
    "咜": "tuō",
    "嚃": "tà",
    "嚺": "tà",
    "崉": "tà",
    "墖": "tǎ",
    "太": "tài",
    "榙": "tā",
    "毾": "tà",
    "涾": "tà",
    "撻": "tà",
    "澾": "tà",
    "濌": "tà",
    "牠": "tā",
    "祂": "tā",
    "禢": "tà",
    "褟": "tā",
    "誻": "tà",
    "譶": "tà",
    "獺": "tǎ",
    "躢": "tà",
    "蹹": "tà",
    "錔": "tà",
    "闒": "tà",
    "阘": "tà",
    "遝": "tà",
    "鞳": "tà",
    "鞜": "tà",
    "襨": "dùi",  # Unknow.
    "闥": "tà",
    "苔": "tái,tāi",
    "泰": "tài",
    "态": "tài",
    "胎": "tāi",
    "酞": "tài",
    "汰": "tài",
    "肽": "tài",
    "炱": "tái",
    "跆": "tái",
    "鲐": "tái",
    "儓": "tái",
    "冭": "tài",
    "囼": "tāi",
    "坮": "tái",
    "邰": "tái",
    "夳": "tài",
    "嬯": "tái",
    "孡": "tāi",
    "钛": "tài",
    "忲": "tài",
    "薹": "tái",
    "擡": "tái",
    "旲": "tái,yīng",
    "態": "tài",
    "溙": "tài",
    "炲": "tái",
    "珆": "yí,tāi",
    "檯": "tái",
    "籉": "tái",
    "舦": "tài",
    "粏": "tà",
    "臺": "tái",
    "鈦": "tài",
    "颱": "tái",
    "鮐": "tái",
    "谈": "tán",
    "碳": "tàn",
    "叹": "tàn",
    "探": "tàn",
    "贪": "tān",
    "痰": "tán",
    "毯": "tǎn",
    "炭": "tàn",
    "坦": "tǎn",
    "瘫": "tān",
    "谭": "tán",
    "坍": "tān",
    "袒": "tǎn",
    "锬": "tán",
    "钽": "tǎn",
    "郯": "tán",
    "嗿": "tǎn",
    "昙": "tán",
    "墵": "tán",
    "壜": "tán",
    "嘆": "tàn",
    "婒": "tán",
    "怹": "tān",
    "墰": "tán",
    "憛": "tán",
    "埮": "tán,tàn",
    "憳": "tǎn",
    "擹": "tān",
    "憻": "tǎn",
    "暺": "tǎn",
    "榃": "tán",
    "歎": "tàn",
    "湠": "tàn",
    "曇": "tán",
    "璮": "tǎn",
    "炎": "yán",
    "罈": "tán",
    "罎": "tán",
    "癱": "tān",
    "舕": "tàn",
    "菼": "tǎn",
    "藫": "tán",
    "襢": "tǎn",
    "蕈": "xùn",
    "談": "tán",
    "譚": "tán",
    "貚": "tán",
    "舔": "tiǎn",
    "醓": "tǎn",
    "賧": "dǎn",
    "貪": "tān",
    "醰": "tán",
    "錟": "tán",
    "鉭": "tǎn",
    "鷤": "tí",
    "譠": "tán",
    "躺": "tǎng",
    "堂": "táng",
    "糖": "táng",
    "塘": "táng",
    "搪": "táng",
    "唐": "táng",
    "棠": "táng",
    "螳": "táng",
    "膛": "táng",
    "羰": "tāng",
    "瑭": "táng",
    "醣": "táng",
    "镗": "tāng",
    "傥": "tǎng",
    "耥": "tǎng",
    "溏": "táng",
    "傏": "táng",
    "劏": "tāng",
    "饧": "xíng",
    "螗": "táng",
    "嘡": "tāng",
    "啺": "táng",
    "铴": "tàng,tāng",
    "坣": "táng",
    "戃": "tǎng",
    "摥": "tàng",
    "曭": "tǎng",
    "榶": "táng",
    "漟": "táng",
    "煻": "táng",
    "爣": "tǎng",
    "矘": "tǎng",
    "磄": "táng",
    "篖": "táng",
    "糃": "táng",
    "糛": "táng",
    "膅": "táng",
    "蓎": "táng",
    "薚": "tāng",
    "赯": "táng",
    "蝪": "tāng",
    "蹚": "tāng",
    "禟": "táng",
    "鄌": "táng",
    "鎕": "táng",
    "鎲": "tǎng",
    "鏜": "tāng,táng",
    "钂": "tǎng",
    "鐋": "tàng",
    "镋": "tǎng",
    "隚": "táng",
    "鞺": "tāng",
    "餹": "táng",
    "饄": "táng",
    "鶶": "táng",
    "鼞": "tāng",
    "餳": "xíng",
    "套": "tào",
    "掏": "tāo",
    "逃": "táo",
    "桃": "táo",
    "讨": "tǎo",
    "淘": "táo",
    "绦": "tāo",
    "萄": "táo",
    "鼗": "táo",
    "啕": "táo",
    "饕": "tāo",
    "仐": "jīn,sǎn",
    "匋": "táo,yáo",
    "韬": "tāo",
    "咷": "táo",
    "滔": "tāo",
    "夵": "yǎn,tāo",
    "嫍": "tāo",
    "幍": "tāo",
    "姚": "yáo",
    "慆": "tāo",
    "抭": "yǎo,tāo",
    "梼": "chóu,táo,dào",
    "搯": "tāo",
    "弢": "tāo",
    "槄": "tāo",
    "瑫": "tāo",
    "祹": "táo",
    "綯": "táo",
    "縚": "tāo",
    "絛": "tāo",
    "蜪": "táo",
    "裪": "táo",
    "縧": "tāo",
    "詜": "tāo",
    "绹": "táo",
    "謟": "tāo",
    "迯": "táo",
    "討": "tǎo",
    "醄": "táo",
    "鋾": "táo",
    "鞱": "tāo",
    "鞉": "táo",
    "韜": "tāo",
    "鞀": "táo",
    "饀": "táo",
    "飸": "tāo",
    "騊": "táo",
    "駣": "táo",
    "疼": "téng",
    "藤": "téng",
    "儯": "téng",
    "幐": "téng",
    "誊": "téng",
    "滕": "téng",
    "漛": "téng",
    "籐": "téng",
    "籘": "téng",
    "縢": "téng",
    "腾": "téng",
    "膯": "tēng",
    "虅": "téng",
    "螣": "téng",
    "邆": "téng",
    "駦": "téng",
    "霯": "tèng",
    "謄": "téng",
    "驣": "téng",
    "鰧": "téng",
    "騰": "téng",
    "鼟": "tēng",
    "剃": "tì",
    "剔": "tī",
    "替": "tì",
    "梯": "tī",
    "啼": "tí",
    "涕": "tì",
    "嚏": "tì",
    "惕": "tì",
    "锑": "tī",
    "屉": "tì",
    "醍": "tí,tǐ",
    "鹈": "tí",
    "绨": "tí,tì",
    "裼": "xī,tì",
    "缇": "tí",
    "逖": "tì",
    "偍": "tí",
    "厗": "tí",
    "悌": "tì",
    "荑": "yí,tí",
    "嗁": "tí",
    "嚔": "tì",
    "崹": "tí",
    "悐": "tì",
    "惖": "tì",
    "戻": "tì",
    "掦": "tì",
    "挮": "tǐ,tì",
    "桋": "yí,tí",
    "擿": "tī,zhì,zhāi",
    "歒": "tì",
    "殢": "tì",
    "屜": "tì",
    "洟": "yí",
    "漽": "tí",
    "瑅": "tí",
    "稊": "tí",
    "瓋": "tì",
    "穉": "zhì",
    "籊": "tì",
    "蕛": "tí",
    "綈": "tí,tì",
    "緹": "tí",
    "薙": "tì",
    "褅": "tì",
    "趧": "tí",
    "趯": "tì,yuè",
    "躰": "tǐ",
    "跃": "yuè",
    "躍": "yuè",
    "軆": "tǐ",
    "逷": "tì",
    "遆": "dì,tí",
    "鍗": "tí",
    "鐟": "zān",
    "銻": "tī",
    "錫": "xī",
    "騠": "tí",
    "骵": "tǐ",
    "髰": "tì",
    "鬀": "tì",
    "鮧": "yí",
    "鮷": "tí",
    "鯷": "tí",
    "鳀": "tí",
    "鴺": "yí",
    "锡": "xī",
    "鷈": "tī",
    "體": "tǐ,tī",
    "鵜": "tí",
    "天": "tiān",
    "田": "tián",
    "添": "tiān",
    "甜": "tián",
    "腆": "tiǎn",
    "恬": "tián",
    "阗": "tián",
    "掭": "tiàn",
    "忝": "tiǎn",
    "畋": "tián",
    "殄": "tiǎn",
    "倎": "tiǎn",
    "兲": "tiān",
    "呑": "tūn,tiān",
    "唺": "tiǎn",
    "娗": "tǐng",
    "吞": "tūn",
    "婖": "tiān",
    "屇": "tián",
    "悿": "tiǎn",
    "晪": "tiǎn",
    "沺": "tián",
    "淟": "tiǎn",
    "寘": "zhì",
    "湉": "tián",
    "琠": "tiǎn,tiàn",
    "瑱": "tiàn,tián,zhèn",
    "璳": "tián",
    "甛": "tián",
    "畇": "yún",
    "畑": "tián",
    "睼": "tí",
    "畠": "zāi,zī",
    "睓": "tiǎn",
    "碵": "tián",
    "磌": "tián",
    "窴": "tián,diān,yǎn",
    "胋": "tián",
    "舚": "tiàn",
    "菾": "tián,tiàn",
    "觍": "tiǎn",
    "覥": "tiǎn",
    "賟": "tiǎn",
    "錪": "tiǎn",
    "酟": "tiān",
    "鎭": "zhèn",
    "镇": "zhèn",
    "鎮": "zhèn",
    "闐": "tián",
    "靔": "tiān",
    "靝": "tiān",
    "餂": "tiǎn",
    "鴫": "tián",
    "鷆": "tián",
    "鷏": "tián",
    "黇": "tiān",
    "条": "tiáo,tiāo",
    "眺": "tiào",
    "龆": "tiáo",
    "祧": "tiāo",
    "窕": "tiǎo,yáo",
    "宨": "tiǎo",
    "鲦": "tiáo",
    "迢": "tiáo",
    "岧": "tiáo",
    "岹": "tiáo",
    "庣": "tiāo",
    "恌": "tiāo,yáo",
    "斢": "tǒu,tiǎo",
    "旫": "tiāo",
    "晀": "tiǎo",
    "朓": "tiǎo",
    "樤": "tiáo",
    "祒": "tiáo",
    "條": "tiáo,tiāo",
    "窱": "tiǎo",
    "聎": "tiāo",
    "脁": "tiǎo",
    "脩": "xiū",
    "艞": "yào",
    "芀": "tiáo",
    "蓚": "tiáo",
    "蓨": "tiáo",
    "螩": "dāo",
    "覜": "tiào",
    "趒": "tiào",
    "鋚": "tiáo",
    "鎥": "tiáo",
    "鞗": "tiáo",
    "铁": "tiě",
    "贴": "tiē",
    "齠": "tiáo",
    "鰷": "tiáo",
    "帖": "tiè,tiě,tiē",
    "萜": "tiē",
    "怗": "tiē,zhān",
    "餮": "tiè",
    "聑": "tiē,zhé",
    "占": "zhān,zhàn",
    "蛈": "tiě",
    "鉄": "tiě",
    "飻": "tiè",
    "銕": "tiě",
    "貼": "tiē",
    "驖": "tiě",
    "听": "tīng",
    "停": "tíng",
    "挺": "tǐng",
    "亭": "tíng",
    "艇": "tǐng",
    "庭": "tíng",
    "廷": "tíng",
    "莛": "tíng",
    "霆": "tíng",
    "婷": "tíng",
    "梃": "tǐng,tìng",
    "侹": "tǐng",
    "厅": "tīng",
    "厛": "tīng",
    "嵉": "tíng",
    "圢": "tǐng",
    "庁": "tīng",
    "廰": "tīng",
    "桯": "tīng,yíng",
    "榳": "tíng",
    "楟": "tíng",
    "廳": "tīng",
    "涏": "tǐng",
    "烶": "tǐng",
    "渟": "tíng,tīng",
    "珽": "tǐng",
    "筳": "tíng",
    "綎": "tīng",
    "耓": "tīng",
    "聤": "tíng",
    "聴": "tīng",
    "聼": "tīng",
    "脡": "tǐng",
    "蝏": "tíng",
    "誔": "tǐng",
    "諪": "tíng",
    "邒": "tíng",
    "閮": "tíng,tǐng",
    "聽": "tīng",
    "鞓": "tīng",
    "鼮": "tíng",
    "頲": "tǐng",
    "颋": "tǐng",
    "乭": "shí",
    "同": "tóng,tòng",
    "通": "tōng",
    "痛": "tòng",
    "铜": "tóng",
    "捅": "tǒng",
    "桶": "tǒng",
    "统": "tǒng",
    "童": "tóng",
    "彤": "tóng",
    "瞳": "tóng",
    "茼": "tóng",
    "砼": "tóng",
    "仝": "tóng",
    "恸": "tòng",
    "哃": "tóng",
    "嗵": "tōng",
    "囲": "wéi,tōng",
    "峂": "tóng",
    "佟": "tóng",
    "庝": "tóng",
    "憅": "tòng",
    "恿": "yǒng",
    "慟": "tòng",
    "晍": "tóng",
    "樋": "tōng",
    "曈": "tóng",
    "氃": "tóng",
    "浵": "tóng",
    "炵": "tōng",
    "狪": "tóng,dòng",
    "熥": "tēng",
    "獞": "tóng",
    "犝": "tóng",
    "眮": "tóng",
    "硧": "yǒng,tóng",
    "秱": "tóng",
    "粡": "tóng",
    "穜": "tóng,zhǒng",
    "痌": "tōng,tóng",
    "綂": "tǒng",
    "蓪": "tōng",
    "蚒": "tóng",
    "統": "tǒng",
    "赨": "tóng",
    "鉖": "tóng",
    "蜼": "wèi",
    "鉵": "tóng",
    "餇": "tóng",
    "鮦": "tóng",
    "鲖": "tóng",
    "銅": "tóng",
    "头": "tóu,tou",
    "偸": "tōu",
    "妵": "tǒu",
    "偷": "tōu",
    "婾": "tōu,yú",
    "亠": "tóu",
    "媮": "tōu,yú",
    "敨": "tǒu",
    "愉": "yú,tōu",
    "紏": "tǒu",
    "綉": "xiù",
    "绣": "xiù",
    "蘣": "tǒu",
    "褕": "yú",
    "緰": "tōu,xū,shū",
    "諭": "yù",
    "谕": "yù",
    "鍮": "tōu",
    "飳": "zhù,tǒu",
    "黈": "tǒu",
    "頭": "tóu",
    "吐": "tǔ,tù",
    "图": "tú",
    "突": "tū",
    "秃": "tū",
    "途": "tú",
    "徒": "tú",
    "屠": "tú",
    "钍": "tǔ",
    "凸": "tū",
    "菟": "tù,tú",
    "余": "yú",
    "凃": "tú",
    "堍": "tù",
    "酴": "tú",
    "図": "tú",
    "唋": "tǔ,tù",
    "圖": "tú",
    "圡": "tǔ",
    "圗": "tú",
    "堗": "tū",
    "墿": "yì,tú",
    "峹": "tú",
    "嵞": "tú",
    "嶀": "tū",
    "廜": "tú",
    "悇": "tú",
    "捸": "tū",
    "揬": "tú",
    "汢": "tu",
    "涋": "tū",
    "庩": "tú",
    "潳": "tú,zhā",
    "湥": "tū",
    "痜": "tū",
    "瘏": "tú",
    "筡": "tú",
    "莵": "tù,tú",
    "葖": "tū",
    "迌": "tù",
    "禿": "tū",
    "蒤": "tú",
    "鈯": "tú",
    "鋵": "tū",
    "鍎": "tú",
    "馟": "tú",
    "釷": "tǔ",
    "駼": "tú",
    "鵌": "tú",
    "鵵": "tù",
    "鵚": "tū",
    "鶟": "tú",
    "鷋": "tú",
    "鷵": "tú",
    "鼵": "tū",
    "湍": "tuān",
    "疃": "tuǎn",
    "抟": "tuán",
    "団": "tuán",
    "圕": "tuān",
    "塼": "zhuān,tuán",
    "嫥": "zhuān",
    "慱": "tuán",
    "剸": "tuán,zhuān",
    "檲": "tuán",
    "漙": "tuán,zhuān",
    "猯": "tuān,tuàn",
    "煓": "tuān",
    "畽": "tuǎn",
    "摶": "tuán",
    "篿": "tuán,zhuān",
    "糰": "tuán",
    "貒": "tuān,tuàn",
    "磚": "zhuān",
    "褖": "tuàn",
    "鷒": "tuán",
    "鏄": "tuán",
    "鷻": "tuán",
    "腿": "tuǐ",
    "褪": "tuì,tùn",
    "退": "tuì",
    "推": "tuī",
    "蜕": "tuì",
    "颓": "tuí",
    "侻": "tuó,tuì",
    "俀": "tuǐ",
    "煺": "tuì",
    "忒": "tè,tuī",
    "僓": "tuǐ,tuí",
    "啍": "zhūn,tūn,xiāng,duǐ",
    "娧": "tuì",
    "尵": "tuí",
    "聉": "wà,tuǐ,zhuó",
    "穨": "tuí",
    "蓷": "tuī",
    "藬": "tuī",
    "脫": "tuō",
    "蘈": "tuí",
    "脱": "tuō",
    "讉": "yí,tuī",
    "蹆": "tuǐ",
    "蹪": "tuí",
    "蛻": "tuì",
    "隤": "tuí",
    "駾": "tuì",
    "骽": "tuǐ",
    "頽": "tuí",
    "頹": "tuí",
    "頺": "tuí",
    "屯": "tún,zhūn",
    "饨": "tún",
    "暾": "tūn",
    "坉": "tún,dùn",
    "吴": "wú",
    "旽": "tūn,zhùn",
    "朜": "tūn",
    "臀": "tún",
    "涒": "tūn,yūn",
    "豘": "tún",
    "軘": "tún",
    "窀": "zhūn",
    "霕": "tún",
    "魨": "tún",
    "臋": "tún",
    "鲀": "tún",
    "黗": "tún",
    "飩": "tún",
    "妥": "tuǒ",
    "托": "tuō",
    "驼": "tuó",
    "椭": "tuǒ",
    "唾": "tuò",
    "乇": "tuō,zhé",
    "柝": "tuò",
    "跎": "tuó",
    "坨": "tuó",
    "佗": "tuó",
    "鸵": "tuó",
    "庹": "tuǒ",
    "箨": "tuò",
    "鼍": "tuó",
    "侂": "tuō",
    "堶": "tuó",
    "咃": "tuō",
    "岮": "tuó",
    "彵": "tuǒ,yí",
    "砣": "tuó",
    "撱": "wěi,tuǒ",
    "杔": "tuō,zhé",
    "杝": "yí,lì,lí,duò,tuò",
    "楕": "tuǒ",
    "槖": "tuó",
    "毤": "tuò",
    "汑": "tuō",
    "涶": "tuō,tuò",
    "狏": "tuó,yí",
    "砤": "tuó",
    "毻": "tuò",
    "碢": "tuó",
    "紽": "tuó",
    "莌": "tuō",
    "籜": "tuò",
    "萚": "tuò",
    "蘀": "tuò",
    "袘": "yí,yì",
    "袥": "tuō",
    "袉": "tuó,tuō",
    "託": "tuō",
    "讬": "tuō",
    "迆": "yǐ,yí",
    "迱": "yǐ,yí",
    "迤": "yǐ,yí",
    "飥": "tuō",
    "阤": "tuó",
    "陁": "tuó",
    "饦": "tuō",
    "馲": "tuō,zhé",
    "駞": "tuó",
    "騨": "tuó",
    "驒": "tuó",
    "驝": "tuó",
    "魠": "tuō",
    "駝": "tuó",
    "鮀": "tuó",
    "鰖": "tuǒ",
    "鵎": "tuǒ",
    "鴕": "tuó",
    "鼉": "tuó",
    "屗": "wěi",  # Unknow.
    "鼧": "tuó",
    "徚": "dōng",
    "斏": "láng",
    "曢": "liǎo",  # Unknow.
    "朑": "tì",
    "桛": "",  # Unknow.
    "歚": "shàn",
    "毜": "háo",
    "毝": "cǎi",
    "毮": "shā",
    "洜": "luò",
    "烪": "",  # Unknow.
    "焑": "yān",
    "焽": "xiǒng,yīng",
    "燞": "jiǎo",
    "癷": "bō,bǒ",
    "稥": "xiāng",
    "祍": "rèn",
    "皼": "gǔ",
    "聁": "pàn",  # Unknow.
    "耂": "lǎo",
    "聣": "ní",
    "蒊": "huā",
    "茒": "yuán",
    "艈": "yù",  # Unknow: 同『毓』
    "蓞": "dàn",
    "藔": "liáo",
    "虲": "xiā",  # Unknow: 同『虾』
    "蝊": "dìng",  # Unknow.
    "袰": "bō",
    "贘": "shǎng",
    "辪": "xuē",
    "躼": "lào",
    "鍂": "piān",
    "鎼": "xià",
    "鐢": "fán",
    "闧": "tā",  # Unknow.
    "霻": "fēng",
    "鶑": "yīng",
    "瓦": "wǎ,wà",
    "佤": "wǎ",
    "挖": "wā",
    "娲": "wā",
    "劸": "wā",
    "咓": "wǎ",
    "啘": "yuē,wā",
    "腽": "wà",
    "嗢": "wà",
    "屲": "wā",
    "徍": "wàng,jiā,wā",
    "搲": "wā,wǎ,wà",
    "媧": "wā",
    "汚": "wū",
    "攨": "wā",
    "汙": "wū",
    "溛": "wā",
    "漥": "wā",
    "瓲": "wa",  # Unknow.
    "畖": "wā",
    "污": "wū",
    "穵": "wā",
    "砙": "wǎ",
    "窊": "wā",
    "膃": "wà",
    "邷": "wǎ",
    "韈": "wā",
    "窪": "wā",
    "襪": "wà",
    "韤": "wà",
    "黳": "yī",
    "鞋": "xié",
    "鼃": "wā",
    "喎": "wāi",
    "歪": "wāi",
    "外": "wài",
    "竵": "wāi",
    "崴": "wǎi,wēi",
    "顡": "wài",
    "夭": "yāo",
    "晚": "wǎn",
    "玩": "wán",
    "碗": "wǎn",
    "挽": "wǎn",
    "弯": "wān",
    "湾": "wān",
    "丸": "wán",
    "腕": "wàn",
    "宛": "wǎn,yuān",
    "婉": "wǎn",
    "烷": "wán",
    "豌": "wān",
    "惋": "wǎn",
    "蜿": "wān",
    "绾": "wǎn",
    "芄": "wán",
    "琬": "wǎn",
    "畹": "wǎn",
    "纨": "wán",
    "剜": "wān",
    "乛": "yǐ",
    "倇": "wǎn",
    "菀": "wǎn,yùn",
    "卍": "wàn",
    "卐": "wàn",
    "唍": "wǎn",
    "刓": "wán",
    "塆": "wān",
    "埦": "wǎn,wān",
    "园": "yuán",
    "壪": "wān",
    "妧": "wàn,yuán",
    "岏": "wán",
    "帵": "wān",
    "忨": "wán",
    "夗": "yuàn,wǎn,wān,yuān",
    "抏": "wán",
    "惌": "yuān,wǎn",
    "捖": "wán",
    "彎": "wān",
    "晩": "wǎn",
    "捥": "wàn,wǎn,wān,yù",
    "晼": "wǎn",
    "杤": "wàn",
    "梚": "wǎn",
    "椀": "wǎn",
    "涴": "wǎn,wò,yuān",
    "潫": "wān",
    "琓": "wán",
    "盌": "wǎn",
    "笂": "wán",
    "睕": "wān",
    "灣": "wān",
    "箢": "wǎn,yuān",
    "綩": "wǎn",
    "紈": "wán",
    "翫": "wán",
    "脕": "wàn",
    "綰": "wǎn",
    "莧": "xiàn",
    "苋": "xiàn",
    "萬": "wàn",
    "蚖": "yuán,wán",
    "貦": "wán",
    "贃": "wàn,zhuàn",
    "贎": "wàn",
    "踠": "wǎn",
    "邜": "xī",
    "鋔": "wǎn",
    "鋺": "yuǎn,yuān,wǎn,wān",
    "鍐": "zōng",
    "輓": "wǎn",
    "骩": "wěi",
    "骪": "wěi",
    "骫": "wěi",
    "魭": "yuán",
    "望": "wàng",
    "忘": "wàng",
    "王": "wáng,wàng",
    "往": "wǎng",
    "网": "wǎng",
    "亡": "wáng,wú",
    "旺": "wàng",
    "妄": "wàng",
    "辋": "wǎng",
    "魍": "wǎng",
    "亾": "wáng",
    "惘": "wǎng",
    "仼": "wáng",
    "兦": "wáng",
    "罔": "wǎng",
    "尣": "wāng",
    "尩": "wāng",
    "尪": "wāng",
    "尢": "yóu",
    "彺": "wǎng",
    "尫": "wāng",
    "徃": "wǎng",
    "暀": "wǎng,wàng",
    "朢": "wàng",
    "棢": "wǎng",
    "瀇": "wǎng,wāng",
    "焹": "gàng",
    "菵": "wǎng",
    "莣": "wáng",
    "蚟": "wáng",
    "網": "wǎng",
    "蛧": "wǎng",
    "蝄": "wǎng",
    "誷": "wǎng",
    "迬": "zhù,wǎng",
    "輞": "wǎng",
    "为": "wéi,wèi",
    "未": "wèi",
    "围": "wéi",
    "喂": "wèi",
    "胃": "wèi",
    "微": "wēi",
    "尾": "wěi,yǐ",
    "威": "wēi",
    "伟": "wěi",
    "卫": "wèi",
    "危": "wēi",
    "委": "wěi,wēi",
    "魏": "wèi",
    "唯": "wéi",
    "维": "wéi",
    "畏": "wèi",
    "惟": "wéi",
    "巍": "wēi",
    "谓": "wèi",
    "尉": "wèi,yù",
    "蔚": "wèi",
    "潍": "wéi",
    "纬": "wěi",
    "萎": "wěi",
    "慰": "wèi",
    "苇": "wěi",
    "渭": "wèi",
    "葳": "wēi",
    "帏": "wéi",
    "艉": "wěi",
    "鲔": "wěi",
    "逶": "wēi",
    "娓": "wěi",
    "闱": "wéi",
    "隈": "wēi",
    "玮": "wěi",
    "涠": "wéi",
    "帷": "wéi",
    "诿": "wěi",
    "洧": "wěi",
    "偎": "wēi",
    "猬": "wèi",
    "猥": "wěi",
    "嵬": "wéi",
    "軎": "wèi",
    "韪": "wěi",
    "圩": "wéi,xū",
    "痿": "wěi",
    "倭": "wō,wēi",
    "炜": "wěi",
    "煨": "wēi",
    "薇": "wēi",
    "儰": "wěi",
    "厃": "wēi,yán",
    "唩": "wō,wěi",
    "叞": "wèi,yù",
    "喡": "wéi,wèi",
    "喴": "wēi",
    "偉": "wěi",
    "墛": "wèi",
    "壝": "wéi",
    "媁": "wéi,wěi",
    "媙": "wēi",
    "媦": "wèi",
    "圍": "wéi",
    "峗": "wéi",
    "寪": "wěi",
    "峞": "wéi",
    "崣": "wěi",
    "嵔": "wēi,wěi",
    "嶶": "wēi",
    "徫": "wěi",
    "幃": "wéi",
    "愄": "wēi",
    "愇": "wěi",
    "懀": "wèi",
    "揋": "wēi",
    "捤": "wěi",
    "揻": "wēi",
    "斖": "wěi,mén",
    "暐": "wěi",
    "梶": "wěi",
    "椳": "wēi",
    "楲": "wēi",
    "欈": "wéi,zuì",
    "有": "yǒu,yòu",
    "沇": "yǎn",
    "洈": "wéi",
    "浘": "wěi",
    "渨": "wěi",
    "湋": "wéi",
    "濰": "wéi",
    "烓": "wēi",
    "煀": "qū",
    "煟": "wèi",
    "潿": "wéi",
    "溈": "wéi",
    "熭": "wèi",
    "燰": "wēi",
    "爲": "wéi,wèi",
    "犚": "wèi",
    "熨": "yù",
    "犩": "wéi",
    "猚": "yá,wèi",
    "琟": "wéi,yù",
    "璏": "zhì",
    "痏": "wěi,yòu,yù",
    "癓": "wēi",
    "硙": "wéi,wèi,ái",
    "瑋": "wěi",
    "碨": "wěi,wèi",
    "緭": "wèi",
    "罻": "wèi",
    "縅": "wēi",
    "維": "wéi",
    "腲": "wěi",
    "芛": "wěi",
    "緯": "wěi",
    "苿": "wèi",
    "茟": "yù",
    "荱": "wěi",
    "菋": "wèi",
    "葨": "wēi",
    "蓶": "wéi",
    "蔿": "wěi",
    "薳": "yuǎn,wěi",
    "葦": "wěi",
    "藯": "wèi",
    "蘶": "wèi",
    "蜲": "wēi",
    "蝛": "wēi",
    "螱": "wèi",
    "衞": "wèi",
    "蝟": "wèi",
    "覣": "wēi",
    "褽": "wèi",
    "衛": "wèi",
    "覹": "wéi",
    "觹": "xī",
    "觽": "xī",
    "觿": "xī",
    "詴": "wēi",
    "讏": "wèi",
    "諉": "wěi",
    "謂": "wèi",
    "讆": "wèi",
    "躗": "wèi",
    "鄬": "wéi",
    "躛": "wèi",
    "轊": "wèi",
    "醀": "wéi",
    "鍏": "wéi",
    "鍡": "wěi",
    "鏏": "wèi",
    "隇": "wēi",
    "霨": "wèi",
    "闈": "wéi",
    "霺": "wēi",
    "阢": "wù",
    "韑": "wěi",
    "頠": "wěi",
    "韡": "wěi",
    "餵": "wèi",
    "韙": "wěi",
    "颹": "wěi",
    "饖": "wèi",
    "鮇": "wèi",
    "鮠": "wéi",
    "鰃": "wēi",
    "鰄": "wēi",
    "鳂": "wēi",
    "鮪": "wěi",
    "鳚": "wèi",
    "问": "wèn",
    "文": "wén",
    "闻": "wén",
    "稳": "wěn",
    "温": "wēn",
    "吻": "wěn",
    "蚊": "wén",
    "瘟": "wēn",
    "纹": "wén,wèn",
    "刎": "wěn",
    "雯": "wén",
    "璺": "wèn",
    "紊": "wěn",
    "阌": "wén",
    "呚": "huá,qì",
    "塭": "wēn",
    "妏": "wèn",
    "彣": "wén",
    "問": "wèn",
    "忟": "mǐn,wěn,mín",
    "愠": "yùn",
    "慍": "yùn",
    "抆": "wěn",
    "揾": "wèn",
    "搵": "wèn",
    "桽": "wěn",
    "榅": "wēn,yùn",
    "榲": "wēn",
    "殟": "wēn",
    "炆": "wén",
    "珳": "wén",
    "煴": "yūn,yǔn",
    "瑥": "wēn",
    "瘒": "wén",
    "溫": "wēn",
    "穏": "wěn",
    "眼": "yǎn",
    "緼": "yùn,yūn,wēn",
    "縕": "yùn,yūn,wēn",
    "缊": "yùn,yūn,wēn",
    "肳": "wěn",
    "穩": "wěn",
    "紋": "wén,wèn",
    "脗": "wěn",
    "聞": "wén",
    "芠": "wén",
    "蕰": "yùn",
    "薀": "yùn",
    "蕴": "yùn",
    "藴": "yùn",
    "螡": "wén",
    "蚉": "wén",
    "蟁": "wén",
    "褞": "yùn",
    "蘊": "yùn",
    "豱": "wēn",
    "轀": "wēn",
    "輼": "wēn",
    "辒": "wēn",
    "鈫": "qín",
    "閺": "wén",
    "鎾": "wēn",
    "闅": "wén",
    "闦": "wén",
    "閿": "wén",
    "限": "xiàn",
    "韞": "yùn",
    "饂": "wēn",
    "馼": "wén",
    "韫": "yùn,wēn",
    "魰": "wén",
    "鰛": "wēn",
    "鰮": "wēn",
    "鳁": "wēn",
    "鳼": "wén",
    "鴍": "wén",
    "鼤": "wén",
    "翁": "wēng",
    "嗡": "wēng",
    "蕹": "wèng",
    "瓮": "wèng",
    "勜": "wěng,yǎng",
    "蓊": "wěng",
    "塕": "wěng",
    "嵡": "wěng",
    "奣": "wěng",
    "滃": "wěng,wēng",
    "暡": "wěng",
    "壅": "yōng",
    "瞈": "wěng",
    "罋": "wèng",
    "聬": "wēng",
    "甕": "wèng",
    "鎓": "wēng",
    "螉": "wēng",
    "鶲": "wēng",
    "鹟": "wēng",
    "齆": "wèng",
    "我": "wǒ",
    "卧": "wò",
    "窝": "wō",
    "挝": "zhuā,wō",
    "沃": "wò",
    "蜗": "wō",
    "幄": "wò",
    "仴": "wò",
    "龌": "wò",
    "莴": "wō",
    "偓": "wò",
    "肟": "wò",
    "媉": "wò",
    "婐": "wǒ",
    "捾": "wò,xiá",
    "枂": "wò,yuè",
    "楃": "wò",
    "撾": "zhuā,wō",
    "杌": "wù",
    "涹": "wō",
    "濣": "wò",
    "猧": "wō",
    "瓁": "wò",
    "瞃": "wò",
    "腛": "wò",
    "臒": "wò,yuè",
    "臥": "wò",
    "窩": "wō",
    "馧": "yūn,wò",
    "齷": "wò",
    "萵": "wō",
    "五": "wǔ",
    "物": "wù",
    "舞": "wǔ",
    "屋": "wū",
    "雾": "wù",
    "误": "wù",
    "捂": "wǔ",
    "悟": "wù",
    "钨": "wū",
    "武": "wǔ",
    "务": "wù",
    "呜": "wū",
    "戊": "wù",
    "侮": "wǔ",
    "吾": "wú,yù",
    "伍": "wǔ",
    "午": "wǔ",
    "乌": "wū",
    "诬": "wū",
    "巫": "wū",
    "芜": "wú",
    "晤": "wù",
    "坞": "wù",
    "梧": "wú",
    "蜈": "wú",
    "牾": "wǔ",
    "妩": "wǔ",
    "寤": "wù",
    "兀": "wù",
    "邬": "wū",
    "怃": "wǔ",
    "骛": "wù",
    "忤": "wǔ",
    "鋈": "wù",
    "於": "yú,wū",
    "仵": "wǔ",
    "鹜": "wù",
    "焐": "wù",
    "迕": "wǔ",
    "庑": "wǔ",
    "鹉": "wǔ",
    "鼯": "wú",
    "乄": "wǔ",
    "浯": "wú",
    "俉": "wù",
    "圬": "wū",
    "伆": "wěn",
    "倵": "wǔ",
    "儛": "wǔ",
    "剭": "wū",
    "呉": "wú",
    "啎": "wǔ",
    "吳": "wú",
    "奦": "wù",
    "嗚": "wū",
    "娪": "wú,wù,yú",
    "塢": "wù",
    "娬": "wǔ",
    "屼": "wù",
    "岉": "wù",
    "嵨": "wù",
    "嫵": "wǔ",
    "峿": "wú",
    "弙": "wū",
    "忢": "wù",
    "悞": "wù",
    "御": "yù",
    "悮": "wù",
    "廡": "wǔ",
    "扤": "wù",
    "扜": "yū,wū",
    "摀": "wǔ",
    "旿": "wù,wǔ",
    "杅": "yú,wū",
    "憮": "wǔ",
    "杇": "wū",
    "橆": "wú",
    "歍": "wū",
    "洖": "wú",
    "溩": "wù",
    "潕": "wǔ",
    "熃": "wù",
    "熓": "wǔ",
    "玝": "wǔ",
    "珸": "wú",
    "珷": "wǔ",
    "瑦": "wǔ",
    "烏": "wū",
    "璑": "wú",
    "甒": "wǔ",
    "矹": "wù",
    "碔": "wǔ",
    "祦": "wú",
    "禑": "xú",
    "窏": "wū",
    "窹": "wù",
    "箼": "wū",
    "粅": "wù",
    "莁": "wú",
    "茣": "wú",
    "誈": "wū",
    "螐": "wū",
    "蕪": "wú",
    "逜": "wǔ",
    "誣": "wū",
    "躌": "wǔ",
    "郚": "wú",
    "誤": "wù",
    "鋙": "wú",
    "錻": "bū",
    "鄔": "wū",
    "隖": "wù",
    "铻": "wú",
    "鎢": "wū",
    "靰": "wù",
    "鯃": "wú",
    "鴮": "wū",
    "鰞": "wū",
    "騖": "wù",
    "鵐": "wú",
    "鵡": "wǔ",
    "鷡": "wú",
    "鶩": "wù",
    "鹀": "wú",
    "齬": "yǔ",
    "龉": "yǔ",
    "西": "xī",
    "洗": "xǐ,xiǎn",
    "细": "xì",
    "吸": "xī",
    "席": "xí",
    "稀": "xī",
    "溪": "xī",
    "熄": "xī",
    "膝": "xī",
    "息": "xī",
    "袭": "xí",
    "惜": "xī",
    "习": "xí",
    "嘻": "xī",
    "夕": "xī",
    "矽": "xī",
    "熙": "xī",
    "悉": "xī",
    "檄": "xí",
    "希": "xī",
    "晰": "xī",
    "媳": "xí",
    "硒": "xī",
    "铣": "xiǎn,xǐ",
    "烯": "xī",
    "隙": "xì",
    "汐": "xī",
    "犀": "xī",
    "蜥": "xī",
    "奚": "xī",
    "浠": "xī",
    "葸": "xǐ",
    "饩": "xì",
    "屣": "xǐ",
    "玺": "xǐ",
    "禊": "xì",
    "嬉": "xī",
    "兮": "xī",
    "穸": "xī",
    "翕": "xī",
    "禧": "xǐ",
    "僖": "xī",
    "蓰": "xǐ",
    "淅": "xī",
    "舾": "xī",
    "醯": "xī",
    "欷": "xī",
    "皙": "xī",
    "蟋": "xī",
    "隰": "xí",
    "羲": "xī",
    "唏": "xī",
    "曦": "xī",
    "樨": "xī",
    "粞": "xī",
    "觋": "xí",
    "鼷": "xī",
    "熹": "xī",
    "俙": "xī",
    "义": "yì",
    "係": "xì",
    "傒": "xī,xì",
    "匸": "xì",
    "卌": "xì",
    "凞": "xī",
    "卥": "xī",
    "吚": "yī",
    "唽": "xī",
    "厀": "xī",
    "嚱": "xī",
    "噏": "xī",
    "塈": "jì",
    "咦": "yí",
    "壐": "xǐ",
    "嬆": "xī",
    "屃": "xì",
    "屖": "xī",
    "屭": "xì",
    "嵠": "xī",
    "嶍": "xí",
    "巇": "xī",
    "徆": "xī",
    "徯": "xī",
    "忥": "xì",
    "怬": "xì",
    "怸": "xī,shù",
    "恄": "xì",
    "悕": "xī",
    "惁": "xī",
    "慀": "xì,xié",
    "扸": "xī,zhé",
    "憘": "xǐ,xī",
    "晞": "xī",
    "暿": "xī,xǐ",
    "晳": "xī",
    "憙": "xǐ",
    "枲": "xǐ",
    "桸": "xī",
    "椞": "xì",
    "榽": "xī",
    "橀": "xī",
    "橲": "xǐ",
    "歖": "xǐ",
    "氥": "xī",
    "渓": "xī",
    "漇": "xǐ",
    "漝": "xí",
    "潝": "xī,yà",
    "潟": "xì",
    "澙": "xì",
    "焁": "xī",
    "焈": "xī",
    "焟": "xī",
    "焬": "xī,yì",
    "煕": "xī,yí",
    "熂": "xì",
    "熈": "xī",
    "熺": "xī",
    "燨": "xī",
    "熻": "xī",
    "爔": "xī",
    "犔": "xì",
    "犠": "xī",
    "琋": "xī",
    "瘜": "xī",
    "睎": "xī",
    "瞦": "xī",
    "璽": "xǐ",
    "磶": "xì",
    "礂": "xī",
    "窸": "xī",
    "綌": "xì",
    "緆": "xī",
    "繥": "xī",
    "縰": "xǐ",
    "绤": "xì",
    "細": "xì",
    "羛": "yì,xī",
    "翖": "xī",
    "義": "yì",
    "習": "xí",
    "肹": "xī",
    "脇": "xié",
    "脋": "xié",
    "胁": "xié",
    "莃": "xī",
    "脅": "xié",
    "葈": "xǐ",
    "蒵": "xí,xì",
    "蒠": "xī",
    "蓆": "xí",
    "蕮": "xì",
    "薂": "xí,xiào",
    "蟢": "xǐ",
    "衋": "xì",
    "蠵": "xī",
    "蜴": "yì",
    "覀": "yà",
    "覤": "xì",
    "襲": "xí",
    "訢": "xīn",
    "謑": "xǐ",
    "覡": "xī",
    "誒": "ēi,éi,ěi,èi,xī",
    "譆": "xī",
    "豨": "xī",
    "诶": "ēi,éi,ěi,èi,xī",
    "豀": "xī",
    "豯": "xī",
    "貕": "xī",
    "赥": "xī",
    "赩": "xì",
    "趇": "xì",
    "蹝": "xǐ",
    "趘": "xí",
    "躧": "xǐ",
    "鄎": "xī",
    "郤": "xì",
    "郋": "xí",
    "釳": "xì",
    "酅": "xī",
    "釸": "xī",
    "鈢": "xǐ",
    "鎴": "xí",
    "鑴": "xī",
    "銑": "xiǎn,xǐ",
    "隟": "xì",
    "鏭": "xī",
    "隵": "xī",
    "霫": "xí",
    "霼": "xì",
    "飁": "xí",
    "餏": "xī",
    "饻": "xī",
    "騱": "xí",
    "騽": "xí",
    "餼": "xì",
    "驨": "xí",
    "鯑": "xī",
    "鰼": "xí",
    "鱚": "xǐ",
    "鳛": "xí",
    "鸂": "xī",
    "鵗": "xī",
    "黖": "xì",
    "下": "xià",
    "峡": "xiá",
    "瞎": "xiā",
    "霞": "xiá",
    "狭": "xiá",
    "匣": "xiá",
    "侠": "xiá",
    "狎": "xiá",
    "黠": "xiá",
    "罅": "xià",
    "硖": "xiá",
    "丅": "xià",
    "遐": "xiá",
    "傄": "xiā",
    "瑕": "xiá",
    "圷": "xià",
    "俠": "xiá",
    "呀": "yā,ya",
    "岈": "yá",
    "懗": "xià",
    "敮": "xiá",
    "梺": "xià",
    "溊": "bō",
    "炠": "xiá",
    "峽": "xiá",
    "烚": "xiá",
    "珨": "xiá",
    "煆": "xiā",
    "疜": "xià",
    "疨": "yǎ,xiā",
    "睱": "xià",
    "狹": "xiá",
    "祫": "xiá",
    "碬": "xiá",
    "筪": "xiá",
    "縀": "xié",
    "舝": "xiá",
    "縖": "xiá",
    "硤": "xiá",
    "翈": "xiá",
    "舺": "xiá",
    "蕸": "xiá",
    "赮": "xiá",
    "谺": "xiā",
    "鍜": "xiá",
    "鎋": "xiá",
    "閕": "xiā,xiǎ",
    "鏬": "xià",
    "陜": "xiá",
    "騢": "xiá",
    "陿": "xiá",
    "颬": "xiā",
    "魻": "xiá",
    "鰕": "xiā",
    "鶷": "xiá",
    "线": "xiàn",
    "现": "xiàn",
    "先": "xiān",
    "县": "xiàn,xuán",
    "显": "xiǎn",
    "闲": "xián",
    "献": "xiàn",
    "嫌": "xián",
    "弦": "xián",
    "陷": "xiàn",
    "鲜": "xiān,xiǎn",
    "衔": "xián",
    "锨": "xiān",
    "仙": "xiān",
    "咸": "xián",
    "贤": "xián",
    "腺": "xiàn",
    "宪": "xiàn",
    "舷": "xián",
    "羡": "xiàn",
    "藓": "xiǎn",
    "岘": "xiàn",
    "痫": "xián",
    "籼": "xiān",
    "蚬": "xiǎn",
    "祆": "xiān",
    "猃": "xiǎn",
    "跹": "xiān",
    "娴": "xián",
    "酰": "xiān",
    "暹": "xiān",
    "氙": "xiān",
    "鹇": "xián",
    "仚": "xiān",
    "伭": "xián,xuán",
    "佡": "xiān",
    "筅": "xiǎn",
    "僊": "xiān",
    "僩": "xiàn",
    "僲": "xiān",
    "僴": "xiàn",
    "哯": "xiàn",
    "咞": "xiàn,xián",
    "嘕": "xiān",
    "垷": "xiàn",
    "奾": "xiān",
    "妶": "xián,xuán,xù",
    "姭": "xiàn",
    "啣": "xián",
    "娹": "xián",
    "娨": "mǎn",
    "婱": "xián",
    "嫺": "xián",
    "尠": "xiǎn",
    "屳": "xiān",
    "嫻": "xián",
    "尟": "xiǎn",
    "崄": "xiǎn",
    "嶮": "xiǎn",
    "幰": "xiǎn",
    "峴": "xiàn",
    "廯": "xiān",
    "忺": "xiān",
    "憪": "xián,xiàn",
    "憸": "xiān",
    "挦": "xián",
    "揱": "xiāo",
    "搟": "xiǎn,xiān",
    "撊": "xiàn",
    "憲": "xiàn",
    "撏": "xián",
    "攇": "xiǎn",
    "晛": "xiàn",
    "枮": "xiān,zhēn",
    "毨": "xiǎn",
    "櫶": "xiǎn",
    "澖": "xián",
    "瀗": "xiàn",
    "灦": "xiǎn",
    "烍": "xiǎn",
    "獫": "xiǎn",
    "狝": "xiǎn",
    "獮": "xiǎn",
    "玁": "xiǎn",
    "玹": "xuán,xián",
    "珗": "xiān",
    "甉": "xián",
    "現": "xiàn",
    "癇": "xián",
    "癎": "xián",
    "県": "xiàn",
    "睍": "xiàn",
    "礥": "xián,xín",
    "禒": "xiǎn",
    "矣": "yǐ",
    "箲": "xiǎn",
    "粯": "xiàn",
    "秈": "xiān",
    "絃": "xián",
    "絤": "xiàn",
    "綖": "yán,xiàn",
    "綫": "xiàn",
    "線": "xiàn",
    "繊": "xiān",
    "縣": "xiàn,xuán",
    "缐": "xiàn",
    "臔": "xiàn",
    "胘": "xián",
    "羨": "xiàn",
    "苮": "xiān",
    "蛝": "xián",
    "臽": "xiàn",
    "蚿": "xián",
    "蘚": "xiǎn",
    "衘": "xián",
    "褼": "xiān",
    "誢": "xiàn",
    "誸": "xián",
    "蜆": "xiǎn",
    "譣": "xiǎn",
    "豏": "xiàn",
    "贒": "xián",
    "赻": "xiǎn",
    "軐": "xìn,xiàn",
    "賢": "xián",
    "蹮": "xiān",
    "鋧": "xiàn",
    "躚": "xiān",
    "鍌": "xiǎn",
    "鑦": "xián",
    "銜": "xián",
    "陥": "xiàn",
    "鍁": "xiān",
    "韅": "xiǎn",
    "閑": "xián",
    "険": "xiǎn",
    "韯": "xiān",
    "韱": "xiān",
    "顕": "xiǎn",
    "馦": "xiān",
    "鱻": "xiān",
    "顯": "xiǎn",
    "鮮": "xiān,xiǎn",
    "鶱": "xiān",
    "鷴": "xián",
    "鷼": "xián",
    "麙": "xián",
    "鷳": "xián",
    "麲": "xiàn",
    "鼸": "xiàn",
    "黹": "zhǐ",
    "想": "xiǎng",
    "向": "xiàng",
    "象": "xiàng",
    "响": "xiǎng",
    "项": "xiàng",
    "香": "xiāng",
    "乡": "xiāng",
    "相": "xiāng,xiàng",
    "像": "xiàng",
    "箱": "xiāng",
    "享": "xiǎng",
    "厢": "xiāng",
    "祥": "xiáng",
    "橡": "xiàng",
    "详": "xiáng,yáng",
    "襄": "xiāng",
    "湘": "xiāng",
    "飨": "xiǎng",
    "翔": "xiáng",
    "骧": "xiāng",
    "鲞": "xiǎng",
    "蟓": "xiàng",
    "庠": "xiáng",
    "芗": "xiāng",
    "饷": "xiǎng",
    "亯": "xiǎng",
    "缃": "xiāng",
    "佭": "xiáng",
    "勨": "xiàng",
    "葙": "xiāng",
    "姠": "xiàng",
    "嚮": "xiàng",
    "嶑": "xiàng",
    "晑": "xiǎng",
    "栙": "xiáng",
    "楿": "xiāng",
    "廂": "xiāng",
    "洋": "yáng",
    "珦": "xiàng",
    "絴": "xiáng",
    "瓖": "xiāng",
    "羏": "yáng,xiáng",
    "缿": "xiàng",
    "膷": "xiāng",
    "萫": "xiāng",
    "緗": "xiāng",
    "蠁": "xiǎng",
    "襐": "xiàng",
    "蚃": "xiǎng",
    "薌": "xiāng",
    "郷": "xiāng",
    "跭": "xiáng",
    "鄊": "xiāng",
    "詳": "xiáng",
    "鄕": "xiāng",
    "鄉": "xiāng",
    "鐌": "xiàng",
    "響": "xiǎng",
    "餉": "xiǎng",
    "項": "xiàng",
    "饗": "xiǎng",
    "饟": "xiǎng,náng",
    "驤": "xiāng",
    "鮝": "xiǎng",
    "鯗": "xiǎng",
    "鱌": "xiàng",
    "鱜": "xiāng",
    "鱶": "xiǎng",
    "鴹": "yáng",
    "麘": "xiāng",
    "小": "xiǎo",
    "笑": "xiào",
    "萧": "xiāo",
    "销": "xiāo",
    "消": "xiāo",
    "效": "xiào",
    "肖": "xiāo,xiào",
    "宵": "xiāo",
    "晓": "xiǎo",
    "霄": "xiāo",
    "哮": "xiào",
    "孝": "xiào",
    "淆": "xiáo",
    "魈": "xiāo",
    "骁": "xiāo",
    "枵": "xiāo",
    "崤": "xiáo",
    "哓": "xiāo",
    "筱": "xiǎo",
    "逍": "xiāo",
    "潇": "xiāo",
    "侾": "xiāo",
    "枭": "xiāo",
    "俲": "xiào",
    "箫": "xiāo",
    "効": "xiào",
    "傚": "xiào",
    "嘋": "xiào",
    "咲": "xiào",
    "咻": "xiū",
    "婋": "xiāo",
    "宯": "xiāo",
    "嘵": "xiāo",
    "彇": "xiāo",
    "庨": "xiāo",
    "恷": "qiū",
    "敩": "xiào,xué",
    "斅": "xiào",
    "斆": "xiào",
    "暁": "xiǎo",
    "歊": "xiāo",
    "殽": "xiáo,yáo,xiào",
    "毊": "xiāo",
    "曉": "xiǎo",
    "梟": "xiāo",
    "洨": "xiáo",
    "滧": "yáo",
    "涍": "xiào",
    "灱": "xiāo",
    "灲": "xiāo",
    "烋": "xiāo",
    "焇": "xiāo",
    "澩": "xué",
    "瀟": "xiāo",
    "熽": "xiào",
    "猇": "xiāo",
    "獟": "yào,xiāo",
    "獢": "xiāo",
    "爻": "yáo",
    "痚": "xiāo",
    "痟": "xiāo",
    "皢": "xiǎo",
    "硣": "xiāo",
    "窙": "xiāo",
    "筿": "xiǎo",
    "篠": "xiǎo",
    "簘": "xiāo",
    "膮": "xiāo",
    "虈": "xiāo",
    "簫": "xiāo",
    "虓": "xiāo",
    "蕭": "xiāo",
    "蟂": "xiāo",
    "蟏": "xiāo",
    "蟰": "xiāo",
    "蠨": "xiāo",
    "詨": "xiào",
    "誟": "xiào",
    "誵": "xiáo",
    "髐": "xiāo",
    "髇": "xiāo",
    "驍": "xiāo",
    "鴞": "xiāo",
    "銷": "xiāo",
    "鴵": "xiāo",
    "鷍": "xiāo",
    "鷕": "yǎo",
    "鸮": "xiāo",
    "血": "xiě,xuè",
    "写": "xiě",
    "歇": "xiē",
    "谢": "xiè",
    "屑": "xiè",
    "卸": "xiè",
    "蟹": "xiè",
    "泻": "xiè",
    "懈": "xiè",
    "邪": "xié,yá,yé,yú,xú",
    "楔": "xiē",
    "泄": "xiè,yì",
    "协": "xié",
    "械": "xiè",
    "谐": "xié",
    "携": "xié",
    "叶": "yè,xié",
    "绁": "xiè",
    "缬": "xié",
    "廨": "xiè",
    "榭": "xiè",
    "撷": "xié",
    "偕": "xié",
    "瀣": "xiè",
    "亵": "xiè",
    "榍": "xiè",
    "邂": "xiè",
    "薤": "xiè",
    "燮": "xiè",
    "伳": "xiè",
    "躞": "xiè",
    "勰": "xié",
    "偞": "xiè",
    "冩": "xiě",
    "偰": "xiè",
    "卨": "xiè",
    "嗋": "xié",
    "噧": "xiè",
    "垥": "xié",
    "協": "xié",
    "塮": "xiè",
    "娎": "xiē",
    "媟": "xiè",
    "夑": "xiè",
    "屓": "xì",
    "屧": "xiè",
    "峫": "xié,yé",
    "徢": "xiè",
    "寫": "xiě,xiè",
    "恊": "xié",
    "愶": "xié",
    "拹": "xié",
    "擕": "xié",
    "暬": "xiè",
    "旪": "xié",
    "擷": "xié",
    "攜": "xié",
    "枻": "yì,xiè",
    "洩": "xiè",
    "澥": "xiè",
    "灺": "xiè",
    "炨": "xiè",
    "炧": "xiè",
    "瀉": "xiè",
    "熁": "xié",
    "燲": "xié",
    "爕": "xiè",
    "瑎": "xié,jiē",
    "祄": "xiè",
    "禼": "xiè",
    "糏": "xiè",
    "絏": "xiè",
    "綊": "xié",
    "絬": "xiè",
    "緤": "xiè,yè",
    "紲": "xiè",
    "緳": "xié",
    "缷": "xiè",
    "翓": "xié",
    "薢": "xiè",
    "纈": "xiè",
    "膎": "xié",
    "耶": "yé,yē",
    "藛": "xiě",
    "蝢": "xié",
    "蝑": "xū",
    "蠏": "xiè",
    "蠍": "xiē",
    "衺": "xié",
    "褉": "xiè",
    "襭": "xié",
    "鍱": "yè",
    "讗": "xié",
    "謝": "xiè",
    "褻": "xiè",
    "諧": "xié",
    "韰": "xiè",
    "鞵": "xié",
    "鐷": "yè",
    "齂": "xiè",
    "页": "yè",
    "頁": "yè",
    "齘": "xiè",
    "龤": "xié",
    "新": "xīn",
    "心": "xīn",
    "欣": "xīn",
    "芯": "xīn,xìn",
    "薪": "xīn",
    "锌": "xīn",
    "辛": "xīn",
    "寻": "xún",
    "衅": "xìn",
    "忻": "xīn",
    "歆": "xīn",
    "囟": "xìn",
    "馨": "xīn",
    "鑫": "xīn",
    "伩": "xìn",
    "俽": "xīn",
    "噺": "xīn",
    "妡": "xīn",
    "兴": "xīng,xìng",
    "嬜": "xīn",
    "惞": "xīn",
    "憖": "yìn",
    "杺": "xīn",
    "尋": "xún",
    "枔": "xín",
    "潃": "xiǔ",
    "炘": "xìn",
    "焮": "xìn",
    "盺": "xīn",
    "舋": "xìn",
    "襑": "xín",
    "訫": "xìn",
    "邤": "xīn",
    "興": "xīng",
    "釁": "xìn",
    "阠": "xìn",
    "鐔": "xín",
    "鋅": "xīn",
    "馫": "xīn",
    "性": "xìng",
    "型": "xíng",
    "形": "xíng",
    "星": "xīng",
    "刑": "xíng",
    "腥": "xīng",
    "杏": "xìng",
    "悻": "xìng",
    "惺": "xīng",
    "猩": "xīng",
    "荥": "xíng,yīng",
    "侀": "xíng",
    "擤": "xǐng",
    "倖": "xìng",
    "哘": "xíng",
    "荇": "xìng",
    "垶": "xīng",
    "娙": "xíng",
    "婞": "xìng",
    "嫈": "yīng",
    "嬹": "xìng",
    "曐": "xīng",
    "洐": "xíng",
    "涬": "xìng",
    "煋": "xīng",
    "瑆": "xīng",
    "皨": "xīng",
    "滎": "xíng,yíng",
    "睲": "xǐng,xìng",
    "硏": "yán,yàn",
    "篂": "xīng",
    "緈": "xìng",
    "研": "yán,yàn",
    "臖": "xìng",
    "莕": "xìng",
    "蛵": "xíng",
    "裄": "háng",
    "觪": "xīng",
    "觲": "xīng",
    "謃": "xīng",
    "鉶": "xíng",
    "騂": "xīng",
    "铏": "xíng",
    "鮏": "xīng",
    "骍": "xīng",
    "鯹": "xīng",
    "胸": "xiōng",
    "熊": "xióng",
    "雄": "xióng",
    "凶": "xiōng",
    "汹": "xiōng",
    "兇": "xiōng",
    "夐": "xiòng,xuàn",
    "忷": "xiōng",
    "恟": "xiōng",
    "匈": "xiōng",
    "芎": "xiōng",
    "敻": "xiòng,xuàn",
    "昫": "xù",
    "胷": "xiōng",
    "訩": "xiōng",
    "詗": "xiòng",
    "讻": "xiōng",
    "詾": "xiōng",
    "洶": "xiōng",
    "诇": "xiòng",
    "修": "xiū",
    "休": "xiū,xǔ",
    "羞": "xiū",
    "锈": "xiù",
    "嗅": "xiù",
    "朽": "xiǔ",
    "馐": "xiū",
    "袖": "xiù",
    "秀": "xiù",
    "貅": "xiū",
    "髹": "xiū",
    "鸺": "xiū",
    "俢": "xiū",
    "樇": "xiū",
    "庥": "xiū",
    "滫": "xiǔ",
    "岫": "xiù",
    "烌": "xiū",
    "珛": "xiù",
    "琇": "xiù",
    "璓": "xiù",
    "煦": "xù",
    "糔": "xiǔ",
    "綇": "xū",
    "繍": "xiù",
    "脙": "xiū",
    "苬": "xiú",
    "臹": "xiū",
    "繡": "xiù",
    "螑": "xiù",
    "褏": "xiù",
    "褎": "xiù",
    "銝": "xiū",
    "莠": "yǒu",
    "鎀": "xiū",
    "鏅": "xiū,xiù",
    "鏥": "xiù",
    "銹": "xiù",
    "飍": "xiū",
    "髤": "xiū",
    "鏽": "xiù",
    "饈": "xiū",
    "鮴": "xiū",
    "齅": "xiù",
    "鵂": "xiū",
    "虚": "xū",
    "须": "xū",
    "蓄": "xù",
    "续": "xù",
    "叙": "xù",
    "婿": "xù",
    "徐": "xú",
    "旭": "xù",
    "吁": "xū,yù",
    "绪": "xù",
    "序": "xù",
    "酗": "xù",
    "糈": "xǔ",
    "恤": "xù",
    "墟": "xū",
    "栩": "xǔ",
    "蓿": "xù",
    "洫": "xù",
    "顼": "xū",
    "胥": "xū",
    "醑": "xǔ",
    "诩": "xǔ",
    "溆": "xù",
    "亐": "yú",
    "盱": "xū",
    "于": "yú",
    "伃": "yú",
    "伵": "xù",
    "侐": "xù",
    "偦": "xū",
    "冔": "xú",
    "勗": "xù",
    "喣": "xǔ",
    "垿": "xù",
    "壻": "xù",
    "姁": "xǔ,xū",
    "媭": "xū",
    "嬃": "xū",
    "幁": "zhèng",
    "怴": "xù,xuè",
    "惐": "yù,xù",
    "敍": "xù",
    "暊": "xǔ",
    "旴": "xù,xū",
    "朂": "xù",
    "敘": "xù",
    "楈": "xū",
    "欨": "xū",
    "欰": "xù",
    "歔": "xū",
    "殈": "xù",
    "汿": "xù",
    "沀": "xù",
    "淢": "yù,xù",
    "潊": "xù",
    "湑": "xǔ,xū",
    "烅": "xù",
    "漵": "xù",
    "烼": "xù",
    "獝": "xù",
    "珝": "xǔ",
    "珬": "xù",
    "疞": "xū",
    "盢": "xù",
    "盨": "xǔ",
    "瞁": "xù",
    "瞲": "xuè",
    "稰": "xǔ,xū",
    "稸": "xù",
    "窢": "huò",
    "籲": "yù",
    "続": "xù",
    "緖": "xù",
    "縃": "xū",
    "聟": "xù",
    "續": "xù",
    "芌": "yù",
    "緒": "xù",
    "芧": "xù,zhù",
    "芋": "yù",
    "蕦": "xū",
    "藇": "xù,yù,xū",
    "藚": "xù",
    "虗": "xū",
    "蛡": "yì,xǔ",
    "訏": "xū",
    "虛": "xū",
    "訹": "xù",
    "諝": "xū",
    "謣": "yú",
    "譃": "xū",
    "谞": "xū",
    "詡": "xǔ",
    "賉": "xù",
    "鄦": "xǔ",
    "雩": "yú",
    "頊": "xù",
    "驉": "xū",
    "須": "xū",
    "鬚": "xū",
    "魆": "xū",
    "魖": "xū",
    "魣": "yú",
    "鱮": "xù",
    "悬": "xuán",
    "旋": "xuán,xuàn",
    "宣": "xuān",
    "喧": "xuān",
    "绚": "xuàn",
    "玄": "xuán",
    "癣": "xuǎn",
    "暄": "xuān",
    "楦": "xuàn",
    "渲": "xuàn",
    "儇": "xuān",
    "漩": "xuán",
    "铉": "xuàn",
    "璇": "xuán",
    "碹": "xuàn",
    "煊": "xuān",
    "镟": "xuàn",
    "炫": "xuàn",
    "萱": "xuān",
    "揎": "xuān",
    "痃": "xuán",
    "塇": "xuān",
    "咺": "xuǎn,xuān",
    "媗": "xuān",
    "嫙": "xuán",
    "谖": "xuān",
    "弲": "xuān,yuān",
    "怰": "xuàn",
    "愃": "xuān",
    "愋": "xuān",
    "昍": "xuān",
    "晅": "xuān",
    "昡": "xuàn",
    "暶": "xuán",
    "懸": "xuán",
    "楥": "xuàn,yuán",
    "檈": "xuán",
    "玆": "zī",
    "琄": "xuàn",
    "璿": "xuán",
    "洵": "xún",
    "瑄": "xuān",
    "睻": "xuān",
    "矎": "xuān",
    "癬": "xuǎn",
    "箮": "xuān",
    "禤": "xuān",
    "縼": "xuàn",
    "繏": "xuàn",
    "翾": "xuān",
    "翧": "xuān",
    "絢": "xuàn",
    "蓒": "xuān",
    "萲": "xuān",
    "蔙": "xuàn",
    "蕿": "xuān",
    "藼": "xuān",
    "蘐": "xuān",
    "蜁": "xuán",
    "蜎": "yuān",
    "蝖": "xuān",
    "蠉": "xuān",
    "諠": "xuān",
    "衒": "xuàn",
    "袨": "xuàn",
    "譞": "xuān",
    "贙": "xuàn",
    "諼": "xuān",
    "鍹": "xuān",
    "颴": "xuàn",
    "鉉": "xuàn",
    "駨": "xún,xuān",
    "鏇": "xuàn",
    "駽": "xuān",
    "馔": "zhuàn",
    "鰚": "xuān",
    "饌": "zhuàn",
    "靴": "xuē",
    "雪": "xuě",
    "薛": "xuē",
    "鳕": "xuě",
    "泶": "xué",
    "乴": "xué",
    "坹": "xuè",
    "岤": "xuè",
    "峃": "xué",
    "嶨": "xué",
    "斈": "xué",
    "桖": "xuè",
    "樰": "xuě",
    "烕": "miè",
    "燢": "xué",
    "瀥": "xuè",
    "狘": "xuè",
    "疶": "xuē",
    "膤": "xuě",
    "艝": "xuě",
    "茓": "xué",
    "蒆": "xuē",
    "袕": "xué",
    "轌": "xuě",
    "雤": "yù",
    "辥": "xuē",
    "鞾": "xuē",
    "謔": "xuè",
    "鷽": "xué",
    "鸴": "xué",
    "鱈": "xuě",
    "讯": "xùn",
    "熏": "xūn,xùn",
    "训": "xùn",
    "循": "xún",
    "殉": "xùn",
    "迅": "xùn",
    "驯": "xùn",
    "汛": "xùn",
    "逊": "xùn",
    "询": "xún",
    "勋": "xūn",
    "巽": "xùn",
    "鲟": "xún",
    "浔": "xún",
    "埙": "xūn",
    "峋": "xún",
    "醺": "xūn",
    "薰": "xūn",
    "伨": "xùn",
    "曛": "xūn",
    "荀": "xún",
    "窨": "yìn,xūn",
    "徇": "xùn",
    "侚": "xùn",
    "偱": "xún",
    "勲": "xūn",
    "勛": "xūn",
    "勳": "xūn",
    "卂": "xùn",
    "噀": "xùn",
    "噚": "xún",
    "嚑": "xūn",
    "坃": "xūn",
    "壎": "xūn",
    "奞": "xùn,zhuì",
    "壦": "xūn",
    "愻": "xùn",
    "塤": "xūn",
    "揗": "xún",
    "攳": "xún",
    "杊": "xún",
    "桪": "xún",
    "樳": "xún",
    "殾": "xùn",
    "毥": "xún,xùn",
    "燅": "xún",
    "燖": "xún",
    "燻": "xūn",
    "爋": "xūn,xùn",
    "潯": "xún",
    "爓": "yàn,xún",
    "狥": "xùn",
    "璕": "xún",
    "稄": "xùn,zè",
    "矄": "xūn",
    "珣": "xún",
    "筼": "yún",
    "篔": "yún",
    "紃": "xún",
    "纁": "xūn",
    "臐": "xūn",
    "薫": "xūn",
    "蘍": "xūn",
    "蟫": "yín,xún",
    "蟳": "xún",
    "賐": "jùn",
    "訊": "xùn",
    "訓": "xùn",
    "訙": "xùn",
    "迿": "xùn",
    "鄩": "xún",
    "鑂": "xùn",
    "詢": "xún",
    "遜": "xùn",
    "顨": "xùn",
    "鱏": "xún",
    "馴": "xùn",
    "压": "yā,yà",
    "鱘": "xún",
    "牙": "yá",
    "鸭": "yā",
    "芽": "yá",
    "丫": "yā",
    "涯": "yá",
    "雅": "yǎ",
    "衙": "yá",
    "鸦": "yā",
    "讶": "yà",
    "蚜": "yá",
    "砑": "yà",
    "琊": "yá",
    "桠": "yā",
    "睚": "yá",
    "娅": "yà",
    "痖": "yǎ",
    "氩": "yà",
    "迓": "yà",
    "伢": "yá",
    "俹": "yà",
    "倻": "yē",
    "厊": "yǎ",
    "揠": "yà",
    "劜": "yà",
    "厓": "yá",
    "圔": "yà",
    "堐": "yá",
    "圠": "yà",
    "厌": "yàn",
    "厭": "yàn",
    "孲": "yā",
    "崕": "yá",
    "壓": "yā,yà",
    "庌": "yǎ",
    "庘": "yā",
    "婭": "yà",
    "挜": "yà,yǎ",
    "枒": "yā",
    "掗": "yà,yǎ",
    "椻": "yà",
    "浥": "yì",
    "札": "zhá",
    "漄": "yá",
    "犽": "yà",
    "氬": "yà",
    "玡": "yá",
    "瑘": "yé",
    "稏": "yà",
    "窫": "yà,yē",
    "聐": "yà",
    "瘂": "yǎ",
    "笌": "yá",
    "襾": "yà",
    "蕥": "yǎ",
    "釾": "yé,yá",
    "錏": "yā",
    "鐚": "yā",
    "铔": "yā,yà",
    "訝": "yà",
    "顔": "yán",
    "颜": "yán",
    "鴨": "yā",
    "鴉": "yā",
    "鵶": "yā",
    "鼼": "yào",
    "齖": "yá",
    "烟": "yān",
    "沿": "yán",
    "盐": "yán",
    "言": "yán",
    "演": "yǎn",
    "严": "yán",
    "咽": "yān,yàn,yè",
    "淹": "yān",
    "掩": "yǎn",
    "宴": "yàn",
    "岩": "yán",
    "延": "yán",
    "堰": "yàn",
    "验": "yàn",
    "殷": "yīn,yān,yǐn",
    "艳": "yàn",
    "阉": "yān",
    "雁": "yàn",
    "砚": "yàn",
    "唁": "yàn",
    "焰": "yàn",
    "谚": "yàn",
    "衍": "yǎn",
    "燕": "yàn,yān",
    "阎": "yán",
    "焉": "yān",
    "奄": "yǎn,yān",
    "芫": "yuán,yán",
    "厣": "yǎn",
    "菸": "yān",
    "琰": "yǎn",
    "滟": "yàn",
    "魇": "yǎn",
    "焱": "yàn",
    "赝": "yàn",
    "筵": "yán",
    "兖": "yǎn",
    "餍": "yàn",
    "恹": "yān",
    "罨": "yǎn",
    "湮": "yān,yīn",
    "偃": "yǎn",
    "谳": "yàn",
    "闫": "yán",
    "胭": "yān",
    "晏": "yàn",
    "酽": "yàn",
    "俨": "yǎn",
    "郾": "yǎn",
    "鄢": "yān",
    "妍": "yán",
    "崦": "yān",
    "鼹": "yǎn",
    "嫣": "yān",
    "乵": "yǎn",
    "偣": "ān",
    "偐": "yàn",
    "傿": "yān,yàn",
    "儼": "yǎn",
    "兗": "yǎn",
    "円": "yuán",
    "剦": "yān",
    "匽": "yǎn,yàn",
    "厳": "yán",
    "喭": "yàn",
    "噞": "yǎn",
    "嚥": "yàn",
    "厴": "yǎn",
    "塩": "yán",
    "墕": "yàn",
    "壛": "yán",
    "嚴": "yán",
    "壧": "yán",
    "妟": "yàn",
    "姲": "yàn",
    "娫": "yán",
    "姸": "yán",
    "娮": "yán",
    "嬊": "yàn",
    "嬮": "yān,yàn",
    "嬿": "yàn",
    "孍": "yǎn",
    "嵃": "yǎn",
    "嵓": "yán",
    "嶖": "yān",
    "巌": "yán",
    "巖": "yán",
    "巗": "yán",
    "巚": "yǎn",
    "愝": "yǎn",
    "巘": "yǎn",
    "懕": "yān",
    "彥": "yàn",
    "戭": "yǎn",
    "扊": "yǎn",
    "抁": "yǎn",
    "揅": "yán",
    "昖": "yán",
    "暥": "yàn",
    "曕": "yàn",
    "曮": "yǎn",
    "棪": "yǎn,yàn",
    "揜": "yǎn",
    "椼": "yǎn",
    "楌": "yán",
    "樮": "yān",
    "檿": "yǎn",
    "櫩": "yán",
    "殗": "yè,yān,yàn",
    "氤": "yīn",
    "渰": "yān,yǎn",
    "洇": "yīn",
    "淫": "yín",
    "灎": "yàn",
    "漹": "yān",
    "灔": "yàn",
    "渷": "yǎn",
    "灩": "yàn",
    "焔": "yàn",
    "灧": "yàn",
    "熖": "yàn",
    "燄": "yàn",
    "狿": "yán",
    "牪": "yàn",
    "猒": "yàn",
    "煙": "yān",
    "琂": "yán",
    "珚": "yān",
    "甗": "yǎn",
    "硽": "yān,yǎn",
    "碞": "yán",
    "篶": "yān",
    "礹": "yán,yǎn",
    "硯": "yàn",
    "縯": "yǎn,yǐn",
    "艶": "yàn",
    "簷": "yán",
    "莚": "yán",
    "臙": "yān",
    "葕": "xìng",
    "艷": "yàn",
    "蔅": "yán",
    "虤": "yán",
    "蝘": "yǎn",
    "褗": "yǎn",
    "覎": "yàn",
    "觾": "yàn",
    "觃": "yàn",
    "訁": "yán",
    "訮": "yán",
    "詽": "yán",
    "讌": "yàn",
    "讠": "yán",
    "讞": "yàn",
    "諺": "yàn",
    "豔": "yàn",
    "豓": "yàn",
    "躽": "yǎn",
    "贋": "yàn",
    "贗": "yàn",
    "軅": "yàn",
    "郔": "yán",
    "這": "zhè",
    "酀": "yàn",
    "这": "zhè,zhèi",
    "酓": "yǎn",
    "醼": "yàn",
    "閆": "yán",
    "閹": "yān",
    "阭": "yǔn",
    "隁": "yàn,yǎn",
    "釅": "yàn",
    "隒": "yǎn",
    "閻": "yán",
    "靨": "yè",
    "靥": "yè",
    "騐": "yàn",
    "饜": "yàn",
    "顏": "yán",
    "験": "yàn",
    "騴": "yàn",
    "驠": "yàn",
    "鬳": "yàn",
    "鰋": "yǎn",
    "驗": "yàn",
    "鳫": "yàn",
    "鴈": "yàn",
    "魘": "yǎn",
    "鶠": "yǎn",
    "鷃": "yàn",
    "鷰": "yàn",
    "麣": "yán",
    "黡": "yǎn",
    "黤": "yǎn",
    "黫": "yān",
    "黭": "yǎn",
    "黰": "zhěn,yān",
    "鹽": "yán",
    "黶": "yǎn",
    "齗": "yīn",
    "齞": "yàn",
    "齴": "yǎn",
    "龂": "yín,kěn",
    "鼴": "yǎn",
    "龑": "yǎn",
    "样": "yàng",
    "养": "yǎng",
    "羊": "yáng,xiáng",
    "秧": "yāng",
    "扬": "yáng",
    "氧": "yǎng",
    "痒": "yǎng",
    "杨": "yáng",
    "漾": "yàng",
    "阳": "yáng",
    "殃": "yāng",
    "鸯": "yāng",
    "佯": "yáng",
    "央": "yāng",
    "疡": "yáng",
    "恙": "yàng",
    "炀": "yáng",
    "徉": "yáng",
    "鞅": "yāng,yàng",
    "蛘": "yáng",
    "泱": "yāng",
    "烊": "yáng,yàng",
    "佒": "yǎng",
    "怏": "yàng",
    "傟": "yǎng",
    "咉": "yǎng",
    "坱": "yǎng",
    "垟": "yáng",
    "奍": "quān,juàn",
    "姎": "yāng",
    "岟": "yǎng",
    "崸": "yáng",
    "慃": "yǎng",
    "懩": "yǎng",
    "抰": "yāng",
    "攁": "yǎng",
    "敭": "yáng",
    "旸": "yáng",
    "昜": "yáng",
    "揚": "yáng",
    "暘": "yáng",
    "柍": "yǎng,yàng,yāng,yīng",
    "映": "yìng",
    "楧": "yǎng,yàng,yīng",
    "楊": "yáng",
    "様": "yàng",
    "氱": "yǎng",
    "炴": "yǎng",
    "瀁": "yǎng,yàng",
    "樣": "yàng",
    "珜": "yáng",
    "煬": "yáng,yàng",
    "眏": "yāng,yǎng,yìng",
    "眻": "yáng",
    "癢": "yǎng",
    "礢": "yǎng",
    "紻": "yǎng",
    "羕": "yàng",
    "羘": "zāng",
    "羪": "yōu",
    "胦": "yāng",
    "詇": "yàng",
    "諹": "yáng",
    "英": "yīng",
    "軮": "yǎng",
    "輰": "yáng",
    "鉠": "yāng",
    "鍈": "yāng",
    "鍚": "yáng",
    "鐊": "xī",
    "钖": "yáng",
    "阦": "yáng",
    "雵": "yāng",
    "霙": "yīng",
    "陽": "yáng",
    "霷": "yáng",
    "駚": "yǎng",
    "養": "yǎng",
    "鰑": "yáng",
    "颺": "yáng",
    "飏": "yáng",
    "鸉": "yáng",
    "鴦": "yāng",
    "要": "yào,yāo",
    "摇": "yáo",
    "腰": "yāo",
    "窑": "yáo",
    "舀": "yǎo",
    "邀": "yāo",
    "谣": "yáo",
    "遥": "yáo",
    "瑶": "yáo",
    "耀": "yào",
    "尧": "yáo",
    "钥": "yuè,yào",
    "鳐": "yáo",
    "珧": "yáo",
    "鹞": "yào",
    "吆": "yāo",
    "崾": "yǎo",
    "肴": "yáo",
    "曜": "yào",
    "徭": "yáo",
    "杳": "yǎo",
    "倄": "yáo",
    "偠": "yǎo",
    "傜": "yáo",
    "窈": "yǎo",
    "喓": "yāo",
    "嗂": "yáo",
    "垚": "yáo",
    "婹": "yǎo",
    "媱": "yáo",
    "宎": "yǎo",
    "堯": "yáo",
    "尭": "yáo",
    "岆": "yǎo",
    "峣": "yáo",
    "嶢": "yáo",
    "嶤": "yáo",
    "徺": "jiǎo,yáo",
    "怮": "yōu,yào",
    "愮": "yáo,yào",
    "揺": "yáo",
    "幼": "yòu",
    "摿": "yáo",
    "暚": "yáo",
    "曣": "yàn",
    "枖": "yǎo,yāo",
    "搖": "yáo",
    "柼": "yǎo",
    "楆": "yāo",
    "榚": "yǎo",
    "榣": "yáo",
    "殀": "yāo",
    "溔": "yǎo",
    "滛": "yín",
    "熎": "yào",
    "烑": "yáo",
    "狕": "yǎo",
    "瀹": "yuè",
    "猺": "yáo",
    "猶": "yóu",
    "矅": "yào",
    "瑤": "yáo",
    "祅": "yāo",
    "磘": "yáo",
    "窅": "yǎo",
    "由": "yóu",
    "穾": "yào",
    "窔": "yào",
    "窰": "yáo",
    "筄": "yào",
    "苭": "yǎo",
    "葽": "yāo",
    "繇": "yáo,yóu,zhòu",
    "葯": "yào",
    "蓔": "yǎo,zhuó",
    "薬": "yào",
    "蘨": "yáo",
    "袎": "yào",
    "覞": "yào",
    "訞": "yāo",
    "詏": "yào",
    "讑": "yào",
    "謡": "yáo",
    "謠": "yáo",
    "鎐": "yáo,zú",
    "遙": "yáo",
    "靿": "yào",
    "闄": "yǎo",
    "鑰": "yuè",
    "颻": "yáo",
    "餆": "yáo",
    "飖": "yáo",
    "騕": "yǎo",
    "餚": "yáo",
    "鰩": "yáo",
    "齩": "yǎo",
    "鷂": "yào",
    "也": "yě",
    "夜": "yè",
    "业": "yè",
    "爷": "yé",
    "掖": "yè,yē",
    "腋": "yè",
    "冶": "yě",
    "曳": "yè",
    "椰": "yē",
    "谒": "yè",
    "晔": "yè",
    "烨": "yè",
    "揶": "yé",
    "亪": "ye",
    "亱": "yè",
    "僷": "yè",
    "铘": "yé",
    "吔": "yē",
    "嚈": "yàn",
    "埜": "yě",
    "墷": "yè",
    "壄": "yě",
    "嶫": "yè",
    "捓": "yé,yú",
    "嶪": "yè",
    "捙": "yè",
    "擛": "yè",
    "拽": "zhuài,zhuāi,yè",
    "擨": "yē",
    "擪": "yè",
    "擫": "yè",
    "暍": "yē",
    "曅": "yè",
    "枽": "yè",
    "曗": "yè",
    "枼": "yè",
    "曄": "yè",
    "漜": "yě",
    "歋": "yē",
    "潱": "yē",
    "澲": "yè",
    "業": "yè",
    "爗": "yè",
    "煠": "yè,zhá",
    "燁": "yè",
    "皣": "yè",
    "瞱": "yè",
    "瞸": "yè",
    "爺": "yé",
    "礏": "yè",
    "蠮": "yē",
    "鄓": "yì",
    "謁": "yè",
    "鎁": "yé",
    "鄴": "yè",
    "鋣": "yé",
    "餣": "yè",
    "餘": "yú",
    "饁": "yè",
    "馌": "yè",
    "驜": "yè",
    "鵺": "yè",
    "鸈": "yè",
    "馀": "yú",
    "黦": "yuè",
    "一": "yī",
    "已": "yǐ",
    "亿": "yì",
    "衣": "yī",
    "依": "yī",
    "易": "yì",
    "医": "yī",
    "仪": "yí",
    "亦": "yì",
    "椅": "yǐ,yī",
    "益": "yì",
    "姨": "yí",
    "翼": "yì",
    "伊": "yī",
    "胰": "yí",
    "译": "yì",
    "沂": "yí",
    "宜": "yí",
    "异": "yì",
    "彝": "yí",
    "蚁": "yǐ",
    "壹": "yī",
    "谊": "yì",
    "铱": "yī",
    "翌": "yì",
    "抑": "yì",
    "艺": "yì",
    "役": "yì",
    "逸": "yì",
    "疫": "yì",
    "臆": "yì",
    "颐": "yí",
    "裔": "yì",
    "毅": "yì",
    "忆": "yì",
    "意": "yì",
    "夷": "yí",
    "议": "yì",
    "诣": "yì",
    "溢": "yì",
    "怿": "yì",
    "癔": "yì",
    "镒": "yì",
    "痍": "yí",
    "旖": "yǐ",
    "熠": "yì",
    "驿": "yì",
    "怡": "yí",
    "翊": "yì",
    "酏": "yǐ",
    "圯": "yí",
    "峄": "yì",
    "懿": "yì",
    "劓": "yì",
    "殪": "yì",
    "漪": "yī",
    "咿": "yī",
    "瘗": "yì",
    "羿": "yì",
    "苡": "yǐ",
    "弈": "yì",
    "贻": "yí",
    "佾": "yì",
    "钇": "yǐ",
    "刈": "yì",
    "缢": "yì",
    "悒": "yì",
    "黟": "yī",
    "弋": "yì",
    "翳": "yì",
    "埸": "yì",
    "奕": "yì",
    "挹": "yì",
    "薏": "yì",
    "亄": "yì",
    "呓": "yì",
    "伇": "yì",
    "镱": "yì",
    "伿": "yì",
    "舣": "yǐ",
    "侇": "yí",
    "俋": "yì",
    "偯": "yǐ",
    "兿": "yì",
    "冝": "yí",
    "儀": "yí",
    "劮": "yì",
    "億": "yì",
    "勚": "yì",
    "勩": "yì",
    "匜": "yí",
    "匇": "yì",
    "呭": "yì",
    "唈": "yì",
    "圛": "yì",
    "印": "yìn",
    "坄": "yì",
    "囈": "yì",
    "垼": "yì",
    "壱": "yī",
    "夁": "yī",
    "妷": "zhí,yì",
    "嫛": "yī",
    "嬄": "yī",
    "嬑": "yì",
    "嫕": "yì",
    "嬟": "yǐ",
    "宧": "yí",
    "宐": "yí",
    "寱": "yì",
    "寲": "yí",
    "峓": "yí",
    "崺": "yǐ",
    "嶬": "yí",
    "帟": "yì",
    "巸": "yí",
    "帠": "yì",
    "庡": "yǐ",
    "嶧": "yì",
    "廙": "yì",
    "弌": "yī",
    "弬": "yi",
    "彜": "yí",
    "彛": "yí",
    "彞": "yí",
    "恞": "yí",
    "怈": "yì",
    "悘": "yī,yì",
    "悥": "yì,niàn",
    "扅": "yí",
    "扆": "yǐ",
    "择": "zé,zhái",
    "撎": "yī",
    "憶": "yì",
    "懌": "yì",
    "擇": "zé,zhái",
    "攺": "yǐ",
    "敡": "yì",
    "敼": "yǐ",
    "旑": "yǐ",
    "晹": "yì",
    "曀": "yì",
    "暆": "yí",
    "曎": "yì",
    "曵": "yè",
    "杙": "yì",
    "枍": "yì",
    "栘": "yí",
    "栧": "yì,xiè",
    "栺": "zhī,yì",
    "棭": "yì",
    "椬": "yí",
    "椸": "yí",
    "槸": "yì",
    "榏": "yì",
    "樴": "zhí",
    "檍": "yì",
    "檥": "yǐ",
    "檹": "yī",
    "櫂": "zhào",
    "欭": "yì,yīn",
    "歝": "yì",
    "殔": "yì",
    "殹": "yì",
    "毉": "yī",
    "洢": "yī",
    "浂": "yì",
    "湙": "yì",
    "浳": "yì",
    "潩": "yì",
    "澺": "yì",
    "炈": "yì",
    "瀷": "yì",
    "焲": "yì",
    "熤": "yì",
    "熪": "yí",
    "燚": "yì",
    "熼": "yì",
    "燡": "yì",
    "燱": "yì",
    "獈": "yì",
    "玴": "yì",
    "瑿": "yī",
    "瓵": "yí",
    "畩": "yī",
    "痬": "yì",
    "異": "yì",
    "瘱": "yì",
    "瘞": "yì",
    "瞖": "yì",
    "礒": "yǐ",
    "秇": "yì,zhí",
    "稦": "yī",
    "祎": "yī",
    "禕": "yī",
    "穓": "yì",
    "竩": "yì",
    "笖": "yǐ",
    "簃": "yí",
    "籎": "yí",
    "繄": "yī",
    "繶": "yì",
    "羠": "yí",
    "耴": "yì",
    "縊": "yì",
    "肊": "yì",
    "膉": "yì",
    "艗": "yì",
    "芅": "yì",
    "苢": "yǐ",
    "苅": "yì",
    "艤": "yǐ",
    "萓": "yí",
    "萟": "yì",
    "蓺": "yì",
    "藙": "yì",
    "蛜": "yī",
    "蘙": "yì",
    "虉": "yì",
    "藝": "yì",
    "蛦": "yí",
    "螘": "yǐ",
    "螠": "yì",
    "衪": "yì",
    "衵": "rì",
    "袣": "yì",
    "衤": "yī",
    "裛": "yì",
    "襗": "zé",
    "襼": "yì",
    "觺": "yí",
    "訲": "yì",
    "訳": "yì",
    "詍": "yì",
    "譩": "yī",
    "詣": "yì",
    "誼": "yì",
    "讛": "yì",
    "譯": "yì",
    "豙": "yì",
    "議": "yì",
    "豛": "yì",
    "豷": "yì",
    "貖": "yì",
    "貤": "yì,yí",
    "贀": "yì",
    "跇": "yì",
    "貽": "yí",
    "跠": "yí",
    "輢": "yǐ",
    "轙": "yǐ",
    "辷": "yī",
    "迻": "yí",
    "郼": "yī",
    "釴": "yì",
    "鈘": "yǐ",
    "釔": "yǐ",
    "醫": "yī",
    "鈠": "yì",
    "鉯": "yǐ",
    "鏔": "yí",
    "銥": "yī",
    "陭": "qí",
    "鐿": "yì",
    "隿": "yì",
    "霬": "yì",
    "鎰": "yì",
    "靾": "xiè",
    "頉": "yí",
    "頥": "yí",
    "顊": "yí",
    "駅": "yì",
    "頤": "yí",
    "顗": "yǐ",
    "骮": "yì",
    "鳦": "yǐ",
    "鯣": "yì,sī",
    "驛": "yì",
    "鶂": "yì",
    "鶍": "yì",
    "鶃": "yì",
    "鷊": "yì",
    "鷁": "yì",
    "鷧": "yì",
    "鷖": "yī",
    "鷾": "yì",
    "鸃": "yì",
    "鹝": "yì",
    "黓": "yì",
    "鹢": "yì",
    "鹥": "yī",
    "齸": "yì",
    "黝": "yǒu",
    "引": "yǐn",
    "因": "yīn",
    "银": "yín",
    "音": "yīn",
    "饮": "yǐn",
    "隐": "yǐn,yìn",
    "荫": "yīn,yìn",
    "尹": "yǐn",
    "寅": "yín",
    "茵": "yīn",
    "堙": "yīn",
    "姻": "yīn",
    "鄞": "yín",
    "喑": "yīn",
    "夤": "yín",
    "胤": "yìn",
    "狺": "yín",
    "霪": "yín",
    "蚓": "yǐn",
    "铟": "yīn",
    "瘾": "yǐn",
    "乚": "háo,yǐ",
    "茚": "yìn",
    "侌": "yīn",
    "冘": "yín,yóu",
    "众": "zhòng",
    "凐": "yīn",
    "噖": "yín",
    "噾": "yīn",
    "嚚": "yín",
    "囙": "yīn",
    "圁": "yín",
    "垔": "yīn",
    "垽": "yìn",
    "婬": "yín",
    "婣": "yīn",
    "峾": "yín",
    "崯": "yín",
    "嶾": "yǐn",
    "廕": "yìn",
    "崟": "yín",
    "愔": "yīn",
    "慭": "yìn",
    "慇": "yīn",
    "憗": "yìn",
    "懚": "yìn",
    "斦": "yín,zhì",
    "朄": "yǐn",
    "檃": "yǐn",
    "栶": "yīn",
    "檭": "yín",
    "檼": "yǐn",
    "櫽": "yǐn",
    "歅": "yān,yīn",
    "殥": "yín",
    "泿": "yín",
    "洕": "yìn",
    "淾": "yǐn",
    "溵": "yīn",
    "湚": "yìn",
    "濥": "yǐn",
    "濦": "yīn",
    "烎": "yín",
    "犾": "yín",
    "猌": "yìn",
    "璌": "yín",
    "瘖": "yīn",
    "癊": "yìn",
    "碒": "yín",
    "癮": "yǐn",
    "磤": "yīn,yǐn",
    "禋": "yīn",
    "秵": "yīn",
    "粌": "yǐn",
    "筃": "yīn",
    "絪": "yīn",
    "緸": "yīn",
    "荶": "yín",
    "蒑": "yīn",
    "蔩": "yín",
    "蘟": "yǐn",
    "螾": "yǐn",
    "裀": "yīn",
    "訔": "yín",
    "蔭": "yīn",
    "訚": "yín",
    "誾": "yín",
    "諲": "yīn",
    "讔": "yǐn",
    "趛": "yǐn",
    "鈏": "yǐn",
    "酳": "yìn",
    "鈝": "yín",
    "銀": "yín",
    "陻": "yīn",
    "銦": "yīn",
    "闉": "yīn",
    "阥": "yīn",
    "隠": "yǐn,yìn",
    "霒": "yīn",
    "霠": "yīn",
    "隱": "yǐn,yìn",
    "靷": "yǐn",
    "鞇": "yīn",
    "韾": "yīn",
    "飮": "yǐn,yìn",
    "飲": "yǐn,yìn",
    "駰": "yīn",
    "鮣": "yìn",
    "骃": "yīn",
    "鷣": "yín",
    "营": "yíng",
    "影": "yǐng",
    "应": "yīng,yìng",
    "迎": "yíng",
    "蝇": "yíng",
    "赢": "yíng",
    "盈": "yíng",
    "颖": "yǐng",
    "鹰": "yīng",
    "莹": "yíng",
    "樱": "yīng",
    "缨": "yīng",
    "婴": "yīng",
    "荧": "yíng",
    "萤": "yíng",
    "楹": "yíng",
    "萦": "yíng",
    "蓥": "yíng",
    "瘿": "yǐng",
    "茔": "yíng",
    "鹦": "yīng",
    "莺": "yīng",
    "璎": "yīng",
    "嘤": "yīng",
    "撄": "yīng",
    "瑛": "yīng",
    "滢": "yíng",
    "潆": "yíng",
    "嬴": "yíng",
    "罂": "yīng",
    "颍": "yǐng",
    "瀛": "yíng",
    "膺": "yīng",
    "僌": "yíng",
    "偀": "yīng",
    "営": "yíng",
    "噟": "yīng",
    "媖": "yīng",
    "嚶": "yīng",
    "塋": "yíng",
    "孆": "yīng",
    "嬰": "yīng",
    "孾": "yīng",
    "巊": "yǐng",
    "廮": "yǐng",
    "愥": "yīng",
    "応": "yīng,yìng",
    "摬": "yǐng",
    "攍": "yíng",
    "暎": "yìng",
    "攚": "wěng",
    "應": "yīng,yìng",
    "攖": "yīng",
    "朠": "yīng",
    "桜": "yīng",
    "梬": "yǐng",
    "渶": "yīng",
    "櫿": "yíng",
    "櫻": "yīng",
    "溁": "yíng",
    "溋": "yíng",
    "濙": "yíng",
    "濚": "yíng",
    "潁": "yǐng",
    "濴": "yíng",
    "瀯": "yíng",
    "瀴": "yīng,yǐng,yìng",
    "灐": "yíng",
    "灜": "yíng",
    "瀠": "yíng",
    "煐": "yīng",
    "珱": "yīng",
    "甇": "yīng",
    "瓔": "yīng",
    "瑩": "yíng,yǐng",
    "矨": "yǐng",
    "甖": "yīng",
    "盁": "yíng",
    "碤": "yīng",
    "礯": "yīng",
    "癭": "yǐng",
    "籝": "yíng",
    "穎": "yǐng",
    "籯": "yíng",
    "緓": "yīng",
    "绬": "yīng",
    "縈": "yíng",
    "纓": "yīng",
    "罃": "yīng",
    "耺": "yún,yíng",
    "膡": "yìng",
    "萾": "yíng",
    "罌": "yīng",
    "藀": "yíng",
    "蘡": "yīng",
    "蛍": "yíng",
    "蝧": "yīng",
    "蝿": "yíng",
    "蠳": "yīng",
    "褮": "yīng",
    "螢": "yíng",
    "蠅": "yíng",
    "覮": "yíng,yǐng",
    "譻": "yīng",
    "譍": "yīng",
    "賏": "yīng",
    "軈": "yīng",
    "鐛": "yǐng",
    "鑍": "yīng",
    "锳": "yīng",
    "贏": "yíng",
    "鴬": "yīng",
    "鶧": "yīng",
    "鷪": "yīng",
    "韺": "yīng",
    "鶯": "yīng",
    "鷹": "yīng",
    "鸎": "yīng",
    "鸚": "yīng",
    "哟": "yō,yo",
    "育": "yù",
    "唷": "yō",
    "喲": "yō,yo",
    "用": "yòng",
    "永": "yǒng",
    "拥": "yōng",
    "蛹": "yǒng",
    "勇": "yǒng",
    "雍": "yōng",
    "咏": "yǒng",
    "泳": "yǒng",
    "佣": "yōng,yòng",
    "踊": "yǒng",
    "痈": "yōng",
    "臃": "yōng",
    "庸": "yōng",
    "慵": "yōng",
    "俑": "yǒng",
    "墉": "yōng",
    "鳙": "yōng",
    "邕": "yōng",
    "喁": "yóng",
    "勈": "yǒng",
    "饔": "yōng",
    "嗈": "yōng",
    "噰": "yōng,yǒng",
    "镛": "yōng",
    "埇": "yǒng",
    "塎": "yǒng",
    "嫞": "yōng",
    "嵱": "yǒng",
    "廱": "yōng",
    "彮": "yǒng",
    "怺": "yǒng",
    "惥": "yǒng",
    "愑": "yǒng",
    "愹": "yǒng",
    "悀": "yǒng",
    "柡": "yǒng",
    "栐": "yǒng",
    "擁": "yōng",
    "湧": "yǒng",
    "槦": "róng,yōng",
    "滽": "yōng",
    "澭": "yōng,yǒng",
    "慂": "yǒng",
    "灉": "yōng",
    "牅": "yōng",
    "癕": "yōng",
    "砽": "yòng",
    "禜": "yíng",
    "苚": "yòng",
    "癰": "yōng",
    "蒏": "yòng",
    "郺": "yōng",
    "詠": "yǒng",
    "踴": "yǒng",
    "鄘": "yōng",
    "醟": "yòng",
    "銿": "zhōng,yōng",
    "雝": "yōng",
    "鯒": "yǒng",
    "鰫": "yóng",
    "鏞": "yōng",
    "顒": "yóng",
    "鲬": "yǒng",
    "颙": "yóng",
    "鷛": "yōng",
    "鱅": "yōng",
    "又": "yòu",
    "右": "yòu",
    "油": "yóu",
    "铀": "yóu",
    "优": "yōu",
    "友": "yǒu",
    "忧": "yōu",
    "尤": "yóu",
    "犹": "yóu",
    "诱": "yòu",
    "悠": "yōu",
    "邮": "yóu",
    "酉": "yǒu",
    "佑": "yòu",
    "釉": "yòu",
    "幽": "yōu",
    "疣": "yóu",
    "攸": "yōu",
    "蚰": "yóu",
    "鱿": "yóu",
    "猷": "yóu",
    "卣": "yǒu",
    "莸": "yóu",
    "宥": "yòu",
    "牖": "yǒu",
    "蝣": "yóu",
    "柚": "yòu,yóu",
    "囿": "yòu",
    "鼬": "yòu",
    "呦": "yōu",
    "铕": "yǒu",
    "丣": "yǒu",
    "亴": "yòu",
    "侑": "yòu",
    "偤": "yóu",
    "哊": "yòu",
    "唀": "yòu",
    "嚘": "yōu",
    "優": "yōu",
    "峟": "yòu",
    "孧": "yòu,niū",
    "姷": "yòu",
    "峳": "yōu",
    "庮": "yóu",
    "怣": "yóu",
    "懮": "yōu,yǒu",
    "栯": "yǒu,yù",
    "梄": "yǒu",
    "楢": "yóu,yǒu",
    "櫌": "yōu",
    "憂": "yōu",
    "櫾": "yòu,yóu",
    "沋": "yóu",
    "泈": "zhōng",
    "瀀": "yōu",
    "湵": "yǒu",
    "滺": "yōu",
    "牗": "yǒu,yōng",
    "狖": "yòu",
    "禉": "yǒu",
    "秞": "yóu",
    "糿": "gōng",
    "祐": "yòu",
    "羐": "líng",
    "纋": "yōu",
    "羑": "yǒu",
    "耰": "yōu",
    "聈": "yǒu",
    "脜": "róu",
    "苃": "yǒu",
    "肬": "yóu",
    "訧": "yóu",
    "蕕": "yóu",
    "貁": "yòu",
    "誘": "yòu",
    "輏": "yóu",
    "迶": "yòu",
    "逌": "yōu",
    "輶": "yóu",
    "蜏": "yǒu",
    "逰": "yóu",
    "遊": "yóu",
    "邎": "yáo",
    "鄾": "yōu",
    "酭": "yòu",
    "鈾": "yóu",
    "駀": "yóu",
    "鮋": "yóu",
    "鲉": "yóu",
    "銪": "yǒu",
    "麀": "yōu",
    "魷": "yóu",
    "与": "yǔ,yù,yú",
    "欲": "yù",
    "鱼": "yú",
    "雨": "yǔ,yù",
    "语": "yǔ,yù",
    "愈": "yù",
    "狱": "yù",
    "玉": "yù",
    "渔": "yú",
    "予": "yú,yǔ",
    "誉": "yù",
    "愚": "yú",
    "虞": "yú",
    "娱": "yú",
    "淤": "yū",
    "舆": "yú",
    "屿": "yǔ",
    "禹": "yǔ",
    "宇": "yǔ",
    "迂": "yū",
    "域": "yù",
    "盂": "yú",
    "郁": "yù",
    "喻": "yù",
    "峪": "yù",
    "粥": "zhōu,yù",
    "渝": "yú",
    "榆": "yú",
    "隅": "yú",
    "寓": "yù",
    "浴": "yù",
    "裕": "yù",
    "驭": "yù",
    "预": "yù",
    "嵛": "yú",
    "鹆": "yù",
    "阈": "yù",
    "妤": "yú",
    "窳": "yǔ",
    "觎": "yú",
    "舁": "yú",
    "蓣": "yù",
    "煜": "yù",
    "钰": "yù",
    "谀": "yú",
    "瑜": "yú",
    "禺": "yú,yù,ǒu",
    "竽": "yú",
    "聿": "yù",
    "欤": "yú",
    "俣": "yǔ",
    "伛": "yǔ",
    "庾": "yǔ",
    "圄": "yǔ",
    "萸": "yú",
    "昱": "yù",
    "瘐": "yǔ",
    "圉": "yǔ",
    "瘀": "yū",
    "燠": "yù",
    "饫": "yù",
    "毓": "yù",
    "腴": "yú",
    "狳": "yú",
    "蝓": "yú",
    "俁": "yǔ",
    "俼": "yù",
    "偊": "yú",
    "匬": "yǔ",
    "喅": "yù",
    "唹": "yū",
    "喐": "huò,guó,xù",
    "傴": "yǔ",
    "喩": "yù",
    "噊": "jué",
    "噳": "yǔ",
    "圫": "yù,zhūn",
    "堉": "yù",
    "堣": "yú",
    "堬": "yú",
    "娯": "yú",
    "媀": "yù,yú",
    "嬩": "yú",
    "寙": "yǔ",
    "娛": "yú",
    "崳": "yú",
    "嶎": "yù",
    "庽": "yù",
    "嵎": "yú",
    "彧": "yù",
    "慾": "yù",
    "嶼": "yǔ",
    "懙": "yǔ,yú",
    "戫": "yù",
    "扵": "yú",
    "挧": "yǔ",
    "敔": "yǔ",
    "斞": "yǔ",
    "斔": "yǔ,zhōng",
    "旟": "yú",
    "棛": "yù",
    "棜": "yù",
    "棫": "yù",
    "楡": "yú",
    "楀": "yǔ",
    "楰": "yú",
    "櫲": "yù",
    "欎": "yù",
    "歈": "yú",
    "歶": "yú",
    "欝": "yù",
    "歟": "yú",
    "淯": "yù",
    "湡": "yú",
    "滪": "yù",
    "澞": "yú",
    "澦": "yù",
    "灪": "yù",
    "灹": "zhà,yù",
    "焴": "yù",
    "漁": "yú",
    "燏": "yù",
    "爩": "yù",
    "牏": "yú",
    "玙": "yú",
    "玗": "yú",
    "獄": "yù",
    "琙": "yù",
    "璵": "yú",
    "瑀": "yǔ",
    "畭": "shē",
    "癒": "yù",
    "盓": "yū",
    "瘉": "yù",
    "睮": "yú",
    "砡": "yù",
    "硢": "yù",
    "礇": "yù",
    "礖": "yù",
    "礜": "yù",
    "祤": "yǔ",
    "秗": "yù",
    "稢": "yù",
    "稶": "yù",
    "穥": "yǔ",
    "禦": "yù",
    "穻": "yū,yǔ",
    "箊": "yū",
    "篽": "yù",
    "籅": "yú",
    "緎": "yù",
    "籞": "yù",
    "罭": "yù",
    "羭": "yú",
    "艅": "yú",
    "荢": "zì",
    "與": "yǔ",
    "茰": "yú",
    "萮": "yú",
    "蒮": "yù",
    "苑": "yuàn",
    "蓹": "yù",
    "蕍": "yú",
    "薁": "yù",
    "蘌": "yù",
    "蘛": "yú",
    "蕷": "yù",
    "蜟": "yù",
    "虶": "yú",
    "螸": "yú",
    "衧": "yú",
    "袬": "yù",
    "諛": "yú",
    "譽": "yù",
    "貐": "yǔ",
    "軉": "yù",
    "覦": "yú",
    "語": "yǔ,yù",
    "輍": "yù",
    "轝": "yú",
    "迃": "yū",
    "逳": "yù",
    "遹": "yù",
    "輿": "yú",
    "邘": "yú",
    "鄅": "yǔ",
    "酑": "yú",
    "鋊": "yù",
    "錥": "yù",
    "鍝": "yú",
    "鈺": "yù",
    "鐭": "yù",
    "陓": "yū",
    "隩": "ào,yù",
    "雓": "yú",
    "霱": "yù",
    "閾": "yù",
    "預": "yù",
    "饇": "yù",
    "騟": "yú",
    "飫": "yù",
    "驈": "yù",
    "骬": "yú",
    "馭": "yù",
    "髃": "yú",
    "鬰": "yù",
    "鮽": "yú",
    "鬱": "yù",
    "鯲": "yú",
    "鰅": "yú",
    "魚": "yú",
    "鱊": "yù",
    "鳿": "yù",
    "鴥": "yù",
    "鴧": "yù",
    "鴪": "yù",
    "鷠": "yú",
    "鸆": "yú",
    "鵒": "yù",
    "鸒": "yù",
    "麌": "yǔ",
    "员": "yuán,yún,yùn",
    "远": "yuǎn,yuàn",
    "元": "yuán",
    "圆": "yuán",
    "原": "yuán",
    "院": "yuàn",
    "愿": "yuàn",
    "猿": "yuán",
    "怨": "yuàn",
    "冤": "yuān",
    "源": "yuán",
    "缘": "yuán",
    "袁": "yuán",
    "渊": "yuān",
    "垣": "yuán",
    "辕": "yuán",
    "鸳": "yuān",
    "鼋": "yuán",
    "橼": "yuán",
    "媛": "yuàn,yuán",
    "爰": "yuán",
    "眢": "yuān",
    "鸢": "yuān",
    "沅": "yuán",
    "螈": "yuán",
    "傆": "yuàn,yuán",
    "塬": "yuán",
    "剈": "yuān",
    "厡": "yuán",
    "允": "yǔn",
    "厵": "yuán",
    "噮": "yuàn",
    "員": "yuán,yún,yùn",
    "圎": "yuán",
    "囦": "yuān",
    "園": "yuán",
    "妴": "yuàn",
    "媴": "yuán",
    "嫄": "yuán",
    "寃": "yuān",
    "圓": "yuán",
    "嬽": "yuān",
    "杬": "yuán,wán",
    "棩": "yuān",
    "榞": "yuán",
    "榬": "yuán",
    "渁": "yuān",
    "櫞": "yuán",
    "渆": "yuān",
    "淵": "yuān",
    "渕": "yuān",
    "灁": "yuān",
    "溒": "yuán",
    "盶": "yuǎn",
    "獂": "huán",
    "湲": "yuán",
    "禐": "yuàn",
    "猨": "yuán",
    "笎": "yuán",
    "縁": "yuán",
    "羱": "yuán",
    "緣": "yuán",
    "肙": "yuān",
    "葾": "yuān",
    "蒬": "yuān",
    "薗": "yuán",
    "蜵": "yuān",
    "蝝": "yuán",
    "蝯": "yuán",
    "衏": "yuàn",
    "裫": "yuàn",
    "褑": "yuàn",
    "褤": "yuán",
    "貟": "yuán,yún,yùn",
    "贠": "yuán,yùn",
    "逺": "yuǎn",
    "邧": "yuán",
    "轅": "yuán",
    "邍": "yuán",
    "酛": "yuán",
    "鈨": "yuán",
    "遠": "yuǎn",
    "鎱": "yuán",
    "陨": "yǔn",
    "隕": "yǔn",
    "願": "yuàn",
    "駌": "yuān",
    "騵": "yuán",
    "鶢": "yuán",
    "鴛": "yuān",
    "鶰": "yuán",
    "鳶": "yuān",
    "鵷": "yuān",
    "鼘": "yuān",
    "鹓": "yuān",
    "鼝": "yuān",
    "黿": "yuán",
    "阅": "yuè",
    "岳": "yuè",
    "悦": "yuè",
    "粤": "yuè",
    "钺": "yuè",
    "曰": "yuē",
    "嬳": "yuè",
    "刖": "yuè",
    "樾": "yuè",
    "岄": "yuè",
    "彟": "huò",
    "龠": "yuè",
    "恱": "yuè",
    "彠": "huò",
    "嶽": "yuè",
    "戉": "yuè",
    "抈": "yuè",
    "捳": "yuè",
    "悅": "yuè",
    "曱": "yuē",
    "爚": "yuè",
    "玥": "yuè",
    "矱": "yuē",
    "礿": "yuè",
    "禴": "yuè",
    "篗": "yuè",
    "籆": "yuè",
    "籰": "yuè",
    "蚎": "yuè",
    "籥": "yuè",
    "粵": "yuè",
    "蚏": "yuè",
    "蘥": "yuè",
    "跀": "yuè",
    "軏": "yuè",
    "鈅": "yuè",
    "鉞": "yuè",
    "閱": "yuè",
    "閲": "yuè",
    "鸑": "yuè",
    "鸙": "yuè",
    "龥": "yù",  # Unknow.
    "云": "yún",
    "晕": "yùn,yūn",
    "运": "yùn",
    "韵": "yùn",
    "孕": "yùn",
    "耘": "yún",
    "酝": "yùn",
    "郧": "yún",
    "氲": "yūn",
    "恽": "yùn",
    "郓": "yùn",
    "芸": "yún",
    "昀": "yún",
    "狁": "yǔn",
    "纭": "yún",
    "伝": "yún",
    "殒": "yǔn",
    "傊": "yùn",
    "呍": "hōng",
    "喗": "yǔn",
    "囩": "yún",
    "夽": "yǔn",
    "奫": "yūn",
    "妘": "yún",
    "愪": "yún",
    "抎": "yǔn",
    "惲": "yùn",
    "抣": "yún",
    "橒": "yún",
    "枟": "yùn",
    "暈": "yùn,yūn",
    "殞": "yǔn",
    "沄": "yún",
    "涢": "yún",
    "氳": "yūn",
    "溳": "yún",
    "澐": "yún",
    "熅": "yūn,yǔn",
    "熉": "yún",
    "磒": "yǔn",
    "秐": "yún",
    "縜": "yún",
    "腪": "yùn",
    "繧": "wén",
    "蒀": "yūn",
    "紜": "yún",
    "荺": "yǔn",
    "蒕": "yūn",
    "蒷": "yún",
    "賱": "yǔn",
    "鄆": "yùn",
    "鄖": "yún",
    "蕓": "yún",
    "運": "yùn",
    "醖": "yùn",
    "醞": "yùn",
    "韗": "yùn",
    "雲": "yún",
    "頵": "jūn",
    "霣": "yǔn",
    "馻": "yǔn",
    "韻": "yùn",
    "齫": "yǔn",
    "齳": "yǔn",
    "咋": "zǎ,zé,zhā",
    "扎": "zā,zhā,zhá",
    "砸": "zá",
    "匝": "zā",
    "咱": "zá,zǎ",
    "喒": "zá,zǎ",
    "帀": "zā",
    "桚": "zā,zǎn",
    "沯": "zá",
    "紥": "zhā,zā",
    "沞": "zā",
    "拶": "zā,zǎn",
    "咂": "zā",
    "臜": "zā",
    "紮": "zhā,zā",
    "臢": "zā",
    "襍": "zá",
    "鉔": "zā",
    "雑": "zá",
    "雥": "zá",
    "韴": "zá",
    "雜": "zá",
    "在": "zài",
    "灾": "zāi",
    "再": "zài",
    "载": "zǎi,zài",
    "栽": "zāi",
    "宰": "zǎi",
    "甾": "zāi,zī",
    "哉": "zāi",
    "崽": "zǎi",
    "儎": "zài",
    "仔": "zī,zǐ,zǎi",
    "扗": "zài",
    "傤": "zài",
    "洅": "zài",
    "渽": "zāi",
    "溨": "zāi",
    "烖": "zāi",
    "睵": "zāi",
    "縡": "zài,zēng",
    "災": "zāi",
    "菑": "zī,zì,zāi",
    "賳": "zāi",
    "酨": "zài",
    "載": "zài",
    "暂": "zàn",
    "赞": "zàn",
    "簪": "zān",
    "趱": "zǎn",
    "糌": "zān",
    "瓒": "zàn",
    "偺": "zá,zǎ",
    "昝": "zǎn",
    "儧": "zǎn",
    "儹": "zǎn",
    "錾": "zàn",
    "兂": "zān",
    "寁": "zǎn",
    "揝": "zǎn,zuàn",
    "瓉": "zàn",
    "禶": "zàn",
    "簮": "zān",
    "讃": "zàn",
    "讚": "zàn",
    "賛": "zàn",
    "暫": "zàn",
    "瓚": "zàn",
    "鄼": "zàn",
    "鐕": "zān",
    "饡": "zàn",
    "贊": "zàn",
    "趲": "zǎn",
    "鏨": "zàn",
    "脏": "zàng",
    "塟": "zàng",
    "奘": "zàng,zhuǎng",
    "驵": "zǎng",
    "牂": "zāng",
    "葬": "zàng",
    "赃": "zāng",
    "弉": "zàng",
    "臓": "zàng",
    "賍": "zāng",
    "賘": "zāng",
    "銺": "zàng",
    "臟": "zàng",
    "贓": "zāng",
    "贜": "zāng",
    "駔": "zǎng",
    "遭": "zāo",
    "早": "zǎo",
    "糟": "zāo",
    "髒": "zāng",
    "灶": "zào",
    "凿": "záo",
    "枣": "zǎo",
    "藻": "zǎo",
    "躁": "zào",
    "皂": "zào",
    "唣": "zào",
    "唕": "zào",
    "蚤": "zǎo",
    "噪": "zào",
    "慥": "zào",
    "梍": "zào",
    "栆": "zǎo",
    "璪": "zǎo",
    "竃": "zào",
    "皁": "zào",
    "簉": "zào",
    "艁": "zào",
    "薻": "zǎo",
    "棗": "zǎo",
    "譟": "zào",
    "趮": "zào",
    "竈": "zào",
    "蹧": "zāo",
    "醩": "zāo",
    "鑿": "záo",
    "则": "zé",
    "责": "zé",
    "泽": "zé,shì",
    "箦": "zé",
    "舴": "zé",
    "迮": "zé",
    "啧": "zé",
    "仄": "zè",
    "伬": "chǐ",
    "昃": "zè",
    "啫": "zé,shì",
    "笮": "zuó,zé",
    "赜": "zé",
    "則": "zé",
    "嘖": "zé",
    "夨": "cè",
    "崱": "zè",
    "庂": "zè",
    "択": "zé",
    "昗": "zè",
    "捑": "zè",
    "歵": "zé",
    "樍": "zé",
    "沢": "zé",
    "汄": "zè",
    "泎": "zé",
    "皟": "zé",
    "溭": "zé",
    "瞔": "zé",
    "矠": "zé",
    "耫": "zhá,zé",
    "礋": "zé",
    "柞": "zuò,zhà",
    "蔶": "zé",
    "葃": "zuò",
    "蠌": "zé",
    "簀": "zé",
    "讁": "zhé",
    "謮": "zé",
    "飵": "zuò,zé,zhā",
    "謫": "zhé",
    "谪": "zhé",
    "鸅": "zé",
    "齚": "zé",
    "賾": "zé",
    "責": "zé,zhài",
    "蠈": "zéi",
    "鰂": "zéi",
    "鱡": "zéi",
    "鲗": "zéi",
    "囎": "zèng",
    "贼": "zéi",
    "譛": "jiàn",
    "怎": "zěn",
    "賊": "zéi",
    "赠": "zèng",
    "憎": "zēng",
    "罾": "zēng",
    "综": "zōng,zèng",
    "増": "zēng",
    "曽": "zēng,céng",
    "甑": "zèng",
    "熷": "zèng",
    "璔": "zēng",
    "矰": "zēng",
    "锃": "zèng",
    "磳": "zēng",
    "譄": "zēng",
    "鄫": "zēng",
    "鬷": "zōng",
    "鱛": "zēng",
    "綜": "zōng,zèng",
    "贈": "zèng",
    "鋥": "zèng",
    "渣": "zhā",
    "炸": "zhà,zhá",
    "眨": "zhǎ",
    "榨": "zhà",
    "铡": "zhá",
    "砟": "zhǎ",
    "诈": "zhà",
    "痄": "zhà",
    "乍": "zhà",
    "吒": "zhà,zhā",
    "咤": "zhà",
    "哳": "zhā",
    "蚱": "zhà",
    "偧": "zhā",
    "揸": "zhā",
    "劄": "zhā,zhá",
    "厏": "zhǎ,zhǎi",
    "宱": "zhà",
    "抯": "zhā",
    "拃": "zhǎ",
    "齄": "zhā",
    "挓": "zhā",
    "摣": "zhā",
    "柤": "zhā,zǔ,zū",
    "怍": "zuò,zhà",
    "搾": "zhà",
    "樝": "zhā",
    "溠": "zhà",
    "牐": "zhá",
    "皶": "zhā",
    "箚": "zhá",
    "苲": "zuó,zhǎ",
    "蚻": "zhá",
    "譗": "zhá",
    "譇": "zhā",
    "踷": "zhě",
    "醡": "zhà",
    "迊": "zā",
    "詐": "zhà",
    "鮓": "zhǎ,zhà",
    "鮺": "zhǎ",
    "鲊": "zhǎ,zhà",
    "鲝": "zhǎ",
    "齇": "zhā",
    "鍘": "zhá",
    "窄": "zhǎi",
    "债": "zhài",
    "砦": "zhài",
    "摘": "zhāi",
    "厇": "zhé,zhái",
    "斋": "zhāi",
    "夈": "zhāi",
    "抧": "zhǐ,zhǎi",
    "捚": "zhāi",
    "斎": "zhāi",
    "榸": "zhāi",
    "債": "zhài",
    "粂": "zhāi",
    "鉙": "zhǎi",
    "齋": "zhāi",
    "盏": "zhǎn",
    "站": "zhàn",
    "毡": "zhān",
    "战": "zhàn",
    "展": "zhǎn",
    "栈": "zhàn",
    "蘸": "zhàn",
    "绽": "zhàn",
    "斩": "zhǎn",
    "谵": "zhān",
    "旃": "zhān",
    "瞻": "zhān",
    "嫸": "zhǎn",
    "搌": "zhǎn",
    "偡": "zhàn",
    "嶘": "zhàn",
    "戦": "zhàn",
    "惉": "zhān",
    "旜": "zhān",
    "栴": "zhān",
    "桟": "zhàn",
    "戰": "zhàn",
    "氊": "zhān",
    "琖": "zhǎn",
    "斬": "zhǎn",
    "菚": "zhàn",
    "氈": "zhān",
    "虥": "zhàn",
    "薝": "zhān",
    "蛅": "zhān",
    "盞": "zhǎn",
    "虦": "zhàn",
    "覱": "zhàn,zhān",
    "讝": "zhán",
    "綻": "zhàn",
    "趈": "zhān",
    "輚": "hàn",
    "譫": "zhān",
    "醆": "zhǎn",
    "轏": "zhàn",
    "閚": "zhān",
    "邅": "zhān",
    "霑": "zhān",
    "颭": "zhǎn",
    "飐": "zhǎn",
    "饘": "zhān",
    "驏": "zhàn",
    "驙": "zhān",
    "魙": "zhān",
    "鸇": "zhān",
    "鹯": "zhān",
    "章": "zhāng",
    "帐": "zhàng",
    "张": "zhāng",
    "涨": "zhǎng,zhàng",
    "仗": "zhàng",
    "丈": "zhàng",
    "账": "zhàng",
    "樟": "zhāng",
    "彰": "zhāng",
    "掌": "zhǎng",
    "杖": "zhàng",
    "漳": "zhāng",
    "瘴": "zhàng",
    "障": "zhàng",
    "仉": "zhǎng",
    "嫜": "zhāng",
    "幛": "zhàng",
    "璋": "zhāng",
    "嶂": "zhàng",
    "傽": "zhāng",
    "鄣": "zhāng",
    "幥": "zhǎng",
    "蟑": "zhāng",
    "墇": "zhàng",
    "扙": "zhàng",
    "獐": "zhāng",
    "慞": "zhāng",
    "張": "zhāng",
    "暲": "zhāng",
    "涱": "zhàng",
    "帳": "zhàng",
    "痮": "zhàng",
    "瞕": "zhàng",
    "粀": "zhàng",
    "瘬": "zhàng",
    "粻": "zhāng",
    "礃": "zhǎng",
    "蔁": "zhāng",
    "遧": "zhāng",
    "鏱": "zhāng",
    "鐣": "chēng",
    "漲": "zhǎng,zhàng",
    "餦": "zhāng",
    "騿": "zhāng",
    "鱆": "zhāng",
    "麞": "zhāng",
    "賬": "zhàng",
    "着": "zhuó,zháo,zhāo,zhe",
    "罩": "zhào",
    "爪": "zhǎo,zhuǎ",
    "照": "zhào",
    "兆": "zhào",
    "昭": "zhāo",
    "棹": "zhào,zhuō",
    "钊": "zhāo",
    "沼": "zhǎo",
    "肇": "zhào",
    "啅": "zhuó,zhào",
    "诏": "zhào",
    "垗": "zhào",
    "妱": "zhāo",
    "巶": "zhāo",
    "笊": "zhào",
    "旐": "zhào",
    "曌": "zhào",
    "枛": "zhào",
    "炤": "zhào,zhāo",
    "燳": "zhào",
    "爫": "zhǎo,zhuǎ",
    "瑵": "zhǎo",
    "狣": "zhào",
    "罀": "zhào",
    "盄": "diào",
    "瞾": "zhào",
    "羄": "zhào",
    "肁": "zhào",
    "肈": "zhào",
    "鉊": "zhāo",
    "鍣": "zhāo",
    "駋": "zhāo",
    "鮡": "zhào",
    "者": "zhě",
    "遮": "zhē",
    "詔": "zhào",
    "釗": "zhāo",
    "蛰": "zhé",
    "浙": "zhè",
    "辙": "zhé",
    "柘": "zhè",
    "蔗": "zhè",
    "哲": "zhé",
    "辄": "zhé",
    "赭": "zhě",
    "啠": "zhé",
    "鹧": "zhè",
    "磔": "zhé",
    "嚞": "zhé",
    "嗻": "zhē,zhè,zhù,zhe",
    "蜇": "zhé",
    "埑": "zhé",
    "慹": "zhí,zhé",
    "嫬": "zhē",
    "悊": "zhé",
    "喆": "zhé",
    "晢": "zhé",
    "歽": "zhé",
    "晣": "zhé",
    "樜": "zhè",
    "淛": "zhè",
    "潪": "zhí,zhì",
    "砓": "zhé",
    "籷": "zhé",
    "虴": "zhé",
    "粍": "zhé",
    "襵": "zhě",
    "蟅": "zhè",
    "讋": "zhé",
    "詟": "zhé",
    "謺": "zhé",
    "輙": "zhé",
    "蟄": "zhé",
    "鮿": "zhé",
    "輒": "zhé",
    "轍": "zhé",
    "鷓": "zhè",
    "陬": "zōu",
    "鷙": "zhì",
    "鸷": "zhì",
    "真": "zhēn",
    "阵": "zhèn",
    "针": "zhēn",
    "振": "zhèn",
    "诊": "zhěn",
    "臻": "zhēn",
    "砧": "zhēn",
    "斟": "zhēn",
    "珍": "zhēn",
    "侦": "zhēn",
    "轸": "zhěn",
    "祯": "zhēn",
    "贞": "zhēn",
    "榛": "zhēn",
    "朕": "zhèn",
    "赈": "zhèn",
    "鸩": "zhèn",
    "胗": "zhēn",
    "塦": "zhèn",
    "桢": "zhēn",
    "畛": "zhěn",
    "姫": "zhěn",
    "偵": "zhēn",
    "寊": "zhēn",
    "嫃": "zhēn,zhěn",
    "屒": "zhěn",
    "帪": "zhēn",
    "弫": "zhěn",
    "抮": "zhěn",
    "挋": "zhèn",
    "揕": "zhèn,zhēn",
    "搸": "zhēn",
    "敒": "shēn",
    "敶": "chén",
    "昣": "zhěn",
    "栕": "chén",
    "栚": "zhèn",
    "樼": "zhēn",
    "殝": "zhēn",
    "潧": "zhēn",
    "澵": "zhēn",
    "獉": "zhēn",
    "珎": "zhēn",
    "瑧": "zhēn",
    "楨": "zhēn",
    "眕": "zhěn",
    "湞": "zhēn",
    "眞": "zhēn",
    "眹": "zhèn",
    "禛": "zhēn",
    "紖": "zhèn",
    "絼": "zhèn",
    "縥": "zhěn",
    "纼": "zhèn",
    "聄": "zhěn",
    "蒖": "zhēn",
    "薽": "zhēn",
    "萙": "zhěn",
    "禎": "zhēn",
    "袗": "zhěn",
    "裖": "zhěn",
    "覙": "zhěn",
    "誫": "zhèn",
    "轃": "zhēn",
    "診": "zhěn",
    "貞": "zhēn",
    "賑": "zhèn",
    "軫": "zhěn",
    "辴": "zhěn",
    "酙": "zhēn",
    "遉": "zhēn",
    "錱": "zhēn",
    "鋴": "zhèn",
    "鉁": "zhēn",
    "駗": "zhěn",
    "針": "zhēn",
    "鬒": "zhěn",
    "陣": "zhèn",
    "靕": "zhèng",
    "鱵": "zhēn",
    "鼑": "dǐng",
    "鴆": "zhèn",
    "帧": "zhēn",
    "正": "zhèng,zhēng",
    "整": "zhěng",
    "睁": "zhēng",
    "争": "zhēng",
    "征": "zhēng",
    "挣": "zhèng,zhēng",
    "证": "zhèng",
    "怔": "zhēng",
    "症": "zhèng,zhēng",
    "郑": "zhèng",
    "狰": "zhēng",
    "拯": "zhěng",
    "蒸": "zhēng",
    "政": "zhèng",
    "峥": "zhēng",
    "凧": "zhēng",
    "塣": "zhèng",
    "钲": "zhēng,zhèng",
    "铮": "zhēng",
    "筝": "zhēng",
    "诤": "zhèng",
    "佂": "zhēng",
    "崝": "zhēng",
    "姃": "zhēng",
    "媜": "zhēng",
    "愸": "zhěng",
    "徰": "zhēng",
    "抍": "zhěng",
    "崢": "zhēng",
    "晸": "zhěng",
    "炡": "zhēng",
    "幀": "zhēn",
    "掙": "zhēng,zhèng",
    "止": "zhǐ",
    "爭": "zhēng",
    "眐": "zhēng",
    "烝": "zhēng",
    "猙": "zhēng",
    "糽": "zhēng,zhěng",
    "篜": "zhēng",
    "癥": "zhēng",
    "睜": "zhēng",
    "証": "zhèng",
    "聇": "zhēng",
    "踭": "zhēng",
    "箏": "zhēng",
    "諍": "zhèng",
    "證": "zhèng",
    "鄭": "zhèng",
    "鬇": "zhēng",
    "鴊": "zhèng",
    "錚": "zhēng",
    "鉦": "zhēng",
    "只": "zhī,zhǐ",
    "之": "zhī",
    "制": "zhì",
    "知": "zhī,zhì",
    "直": "zhí",
    "指": "zhǐ",
    "稚": "zhì",
    "芝": "zhī",
    "纸": "zhǐ",
    "蜘": "zhī",
    "脂": "zhī",
    "织": "zhī,zhì",
    "质": "zhì",
    "炙": "zhì",
    "职": "zhí",
    "痔": "zhì",
    "植": "zhí",
    "侄": "zhí",
    "执": "zhí",
    "值": "zhí",
    "趾": "zhǐ",
    "址": "zhǐ",
    "旨": "zhǐ",
    "志": "zhì",
    "挚": "zhì",
    "掷": "zhì",
    "致": "zhì",
    "置": "zhì",
    "帜": "zhì",
    "秩": "zhì",
    "智": "zhì",
    "帙": "zhì",
    "摭": "zhí",
    "枳": "zhǐ",
    "轵": "zhǐ",
    "桎": "zhì",
    "蛭": "zhì",
    "祉": "zhǐ",
    "觯": "zhì",
    "膣": "zhì",
    "芷": "zhǐ",
    "栀": "zhī",
    "彘": "zhì",
    "咫": "zhǐ",
    "絷": "zhí",
    "踬": "zhì",
    "轾": "zhì",
    "痣": "zhì",
    "骘": "zhì",
    "踯": "zhí",
    "卮": "zhī",
    "酯": "zhǐ",
    "埴": "zhí",
    "俧": "zhì",
    "贽": "zhì",
    "倁": "zhī",
    "跖": "zhí",
    "豸": "zhì",
    "偫": "zhì",
    "値": "zhí",
    "栉": "zhì",
    "儨": "zhì",
    "凪": "zhǐ",
    "劕": "zhì",
    "劧": "zhǐ",
    "坁": "zhǐ,zhì",
    "坧": "zhǐ",
    "垁": "zhì",
    "墌": "zhǐ,zhuó",
    "娡": "zhì",
    "嬂": "zhí",
    "執": "zhí",
    "巵": "zhī",
    "帋": "zhǐ",
    "姪": "zhí",
    "崻": "zhì,shì",
    "庢": "zhì",
    "庤": "zhì",
    "廌": "zhì",
    "徔": "cóng",
    "徏": "zhì",
    "徝": "zhì",
    "恉": "zhǐ",
    "幟": "zhì",
    "憄": "zhī,zhì",
    "懥": "zhì",
    "懫": "zhì",
    "戠": "zhí",
    "搘": "zhī",
    "旘": "zhì",
    "晊": "zhì",
    "摯": "zhì",
    "梽": "zhì",
    "椥": "zhī",
    "擲": "zhì",
    "梔": "zhī",
    "槜": "zuì",
    "榰": "zhī",
    "櫍": "zhì",
    "汦": "zhǐ",
    "洔": "zhǐ",
    "洷": "zhì",
    "淽": "zhǐ",
    "櫛": "zhì",
    "滍": "zhì",
    "漐": "zhí",
    "潌": "zhì",
    "瀄": "zhì",
    "沚": "zhǐ",
    "狾": "zhì",
    "熫": "zhì",
    "犆": "zhí,tè",
    "特": "tè",
    "猘": "zhì",
    "瓆": "zhì",
    "疻": "zhǐ",
    "疷": "zhī",
    "砋": "zhǐ",
    "礩": "zhì",
    "祑": "zhì",
    "祬": "zhī",
    "禃": "zhí",
    "秓": "zhī",
    "秖": "zhǐ",
    "秪": "dī",
    "秷": "zhì",
    "稺": "zhì",
    "筫": "zhì,zhǐ",
    "禔": "tí,zhǐ",
    "稙": "zhī",
    "綕": "zhī",
    "紩": "zhì",
    "紙": "zhǐ",
    "緻": "zhì",
    "翐": "zhì",
    "織": "zhī,zhì",
    "縶": "zhí",
    "聀": "zhí",
    "膱": "zhí",
    "芖": "zhì",
    "藢": "zhǐ",
    "茋": "zhǐ",
    "蘵": "zhī",
    "衼": "zhī",
    "蟙": "zhí",
    "袠": "zhì",
    "袟": "zhì",
    "職": "zhí",
    "襧": "zhǐ",
    "覟": "zhì",
    "觗": "zhì",
    "訨": "zhǐ",
    "製": "zhì",
    "謢": "lū",
    "豑": "zhì",
    "觶": "zhì",
    "貭": "zhì",
    "豒": "zhì",
    "誌": "zhì",
    "跱": "zhì",
    "蹠": "zhí",
    "質": "zhì",
    "軄": "zhí",
    "贄": "zhì",
    "釞": "zhí",
    "躑": "zhí",
    "輊": "zhì",
    "銍": "zhì",
    "鋕": "zhì",
    "躓": "zhì",
    "軹": "zhǐ",
    "铚": "zhì",
    "鑕": "zhì",
    "锧": "zhì",
    "隲": "zhì",
    "駤": "zhì",
    "馽": "zhí",
    "阯": "zhǐ",
    "驇": "zhì",
    "鴲": "zhī",
    "鼅": "zhī",
    "鴙": "zhì",
    "騭": "zhì",
    "钟": "zhōng",
    "肿": "zhǒng",
    "忠": "zhōng",
    "中": "zhōng,zhòng",
    "终": "zhōng",
    "仲": "zhòng",
    "踵": "zhǒng",
    "衷": "zhōng",
    "伀": "zhōng",
    "舯": "zhōng",
    "刣": "zhōng",
    "冢": "zhǒng",
    "堹": "zhòng",
    "塚": "zhǒng",
    "妐": "zhōng",
    "妕": "zhòng",
    "螽": "zhōng",
    "锺": "zhōng",
    "媑": "zhòng",
    "尰": "zhǒng",
    "幒": "zhōng",
    "彸": "zhōng",
    "歱": "zhǒng",
    "柊": "zhōng",
    "汷": "zhōng",
    "煄": "zhǒng",
    "炂": "zhōng",
    "瘇": "zhǒng",
    "狆": "zhòng",
    "筗": "zhòng",
    "籦": "zhōng",
    "茽": "zhòng",
    "蔠": "zhōng",
    "眾": "zhòng",
    "終": "zhōng",
    "螤": "zhōng",
    "蚛": "zhòng",
    "腫": "zhǒng",
    "衳": "zhōng",
    "衶": "zhòng",
    "諥": "zhòng",
    "迚": "dá",
    "衆": "zhòng",
    "鈡": "zhōng",
    "鴤": "zhōng",
    "鼨": "zhōng",
    "鐘": "zhōng",
    "洲": "zhōu",
    "鍾": "zhōng",
    "皱": "zhòu",
    "周": "zhōu",
    "州": "zhōu",
    "轴": "zhóu,zhòu",
    "昼": "zhòu",
    "舟": "zhōu",
    "宙": "zhòu",
    "肘": "zhǒu",
    "骤": "zhòu",
    "咒": "zhòu",
    "胄": "zhòu",
    "帚": "zhǒu",
    "纣": "zhòu",
    "荮": "zhòu",
    "碡": "zhóu",
    "伷": "zhòu",
    "籀": "zhòu",
    "酎": "zhòu",
    "僽": "zhòu",
    "呪": "zhòu",
    "冑": "zhòu",
    "侜": "zhōu",
    "侏": "zhū",
    "喌": "zhōu",
    "徟": "zhōu",
    "晭": "zhǒu",
    "炿": "zhōu",
    "烐": "zhōu",
    "啄": "zhuó",
    "珘": "zhōu",
    "晝": "zhòu",
    "甃": "zhòu",
    "注": "zhù",
    "疛": "zhǒu",
    "睭": "zhǒu",
    "矪": "zhōu",
    "箒": "zhǒu",
    "籒": "zhòu",
    "籕": "zhòu",
    "粙": "zhòu",
    "皺": "zhòu",
    "菷": "zhǒu",
    "舳": "zhú",
    "紂": "zhòu",
    "葤": "zhòu",
    "詋": "zhòu",
    "賙": "zhōu",
    "諏": "zōu",
    "輈": "zhōu",
    "赒": "zhōu",
    "诹": "zōu",
    "辀": "zhōu",
    "輖": "zhōu",
    "軸": "zhóu,zhòu",
    "週": "zhōu",
    "郮": "zhōu",
    "銂": "zhōu",
    "霌": "zhōu",
    "駎": "zhòu",
    "駲": "zhōu",
    "鯞": "zhǒu",
    "驟": "zhòu",
    "猪": "zhū",
    "住": "zhù",
    "竹": "zhú",
    "主": "zhǔ",
    "株": "zhū",
    "煮": "zhǔ",
    "筑": "zhù,zhú",
    "贮": "zhù",
    "铸": "zhù",
    "嘱": "zhǔ",
    "珠": "zhū",
    "驻": "zhù",
    "拄": "zhǔ",
    "瞩": "zhǔ",
    "蛛": "zhū",
    "柱": "zhù",
    "诛": "zhū",
    "潴": "zhū",
    "洙": "zhū",
    "伫": "zhù",
    "蛀": "zhù",
    "瘃": "zhú",
    "茱": "zhū",
    "翥": "zhù",
    "橥": "zhū",
    "苎": "zhù",
    "箸": "zhù",
    "铢": "zhū",
    "炷": "zhù",
    "躅": "zhú",
    "渚": "zhǔ",
    "麈": "zhǔ",
    "邾": "zhū",
    "劅": "zhuó",
    "疰": "zhù",
    "槠": "zhū",
    "劚": "zhú",
    "劯": "zhǔ",
    "壴": "zhù",
    "佇": "zhù",
    "墸": "zhù",
    "坾": "zhù",
    "宔": "zhǔ",
    "嵀": "zhù",
    "曯": "zhú",
    "囑": "zhǔ",
    "斀": "zhuó,zhú",
    "樦": "zhù",
    "柷": "zhù",
    "櫡": "zhuó,zhù",
    "欘": "zhú",
    "殶": "zhù",
    "斸": "zhú",
    "濐": "zhǔ",
    "櫫": "zhū",
    "灟": "zhú",
    "櫧": "zhū",
    "炢": "zhú",
    "煑": "zhǔ",
    "眝": "zhù",
    "瀦": "zhū",
    "砫": "zhù,zhǔ",
    "硃": "zhū",
    "竚": "zhù",
    "祩": "zhù",
    "秼": "zhū",
    "笜": "zhú",
    "筯": "zhù",
    "矚": "zhǔ",
    "篫": "zhù",
    "紸": "zhù",
    "絑": "zhū",
    "纻": "zhù",
    "罜": "zhǔ",
    "羜": "zhù",
    "築": "zhù,zhú",
    "莇": "zhù",
    "茿": "zhú",
    "蝫": "zhū",
    "蠋": "zhú",
    "袾": "zhū",
    "詝": "zhǔ",
    "茁": "zhuó",
    "註": "zhù",
    "跓": "zhù",
    "誅": "zhū",
    "鉒": "zhù",
    "貯": "zhù",
    "軴": "zhù",
    "豬": "zhū",
    "鋳": "zhù",
    "钃": "zhú",
    "銖": "zhū",
    "鑄": "zhù",
    "阻": "zǔ",
    "霔": "shù",
    "馵": "zhù",
    "駯": "zhū",
    "鮢": "zhū",
    "鯺": "zhū",
    "鱁": "zhú",
    "鴸": "zhū",
    "鼄": "zhū",
    "檛": "zhuā",
    "駐": "zhù",
    "髽": "zhuā",
    "膼": "zhuā",
    "抓": "zhuā",
    "转": "zhuǎn,zhuàn,zhuǎi",
    "专": "zhuān",
    "砖": "zhuān",
    "赚": "zhuàn",
    "僎": "zhuàn",
    "篆": "zhuàn",
    "専": "zhuān",
    "堟": "zhuàn",
    "颛": "zhuān",
    "灷": "zhuàn",
    "瑑": "zhuàn",
    "瑼": "zhuān",
    "啭": "zhuàn",
    "囀": "zhuàn",
    "籑": "zhuàn",
    "蒃": "zhuàn",
    "竱": "zhuǎn",
    "蟤": "zhuān",
    "諯": "zhuān",
    "転": "zhuàn,zhuǎn",
    "鄟": "zhuān",
    "賺": "zhuàn,zuàn",
    "装": "zhuāng",
    "撞": "zhuàng",
    "轉": "zhuǎn",
    "顓": "zhuān",
    "桩": "zhuāng",
    "壮": "zhuàng",
    "状": "zhuàng",
    "妆": "zhuāng",
    "壯": "zhuàng",
    "壵": "zhuàng",
    "娤": "zhuāng",
    "庒": "zhuāng",
    "梉": "zhuāng",
    "妝": "zhuāng",
    "丬": "pán",
    "焋": "zhuàng",
    "糚": "zhuāng",
    "粧": "zhuāng",
    "荘": "zhuāng",
    "狀": "zhuàng",
    "坠": "zhuì",
    "锥": "zhuī",
    "赘": "zhuì",
    "莊": "zhuāng",
    "裝": "zhuāng",
    "缒": "zhuì",
    "甀": "zhuì",
    "沝": "zhuǐ,zǐ",
    "骓": "zhuī",
    "礈": "zhuì",
    "畷": "zhuì",
    "諈": "zhuì",
    "膇": "zhuì",
    "墜": "zhuì",
    "縋": "zhuì",
    "轛": "duì",
    "醊": "zhuì",
    "贅": "zhuì",
    "餟": "chuò",
    "鑆": "zhuì",
    "鵻": "zhuī",
    "錐": "zhuī",
    "凖": "zhǔn",
    "宒": "zhūn",
    "谆": "zhūn",
    "稕": "zhùn,zhǔn",
    "騅": "zhuī",
    "衠": "zhūn",
    "綧": "zhǔn,zhùn",
    "準": "zhǔn",
    "訰": "zhùn",
    "准": "zhǔn",
    "迍": "zhūn",
    "諄": "zhūn",
    "灼": "zhuó",
    "拙": "zhuō",
    "捉": "zhuō",
    "桌": "zhuō",
    "浊": "zhuó",
    "卓": "zhuó",
    "琢": "zhuó,zuó",
    "酌": "zhuó",
    "诼": "zhuó",
    "擢": "zhuó",
    "涿": "zhuō",
    "倬": "zhuō",
    "丵": "zhuó",
    "浞": "zhuó",
    "圴": "zhuó",
    "妰": "zhuó",
    "撯": "zhuó",
    "娺": "zhuó",
    "禚": "zhuó",
    "斮": "zhuó",
    "擆": "zhuó",
    "斵": "zhuó",
    "斱": "zhuó",
    "晫": "zhuó",
    "梲": "zhuō",
    "棳": "zhuō",
    "椓": "zhuó",
    "槕": "zhuō",
    "烵": "zhuó",
    "犳": "zhuó,bào",
    "斲": "zhuó",
    "琸": "zhuó",
    "濁": "zhuó",
    "硺": "zhuó",
    "籗": "zhuó",
    "窧": "zhuō",
    "窡": "zhuó",
    "籱": "zhuó",
    "罬": "zhuó",
    "蠗": "zhuó",
    "蠿": "zhuó",
    "諁": "zhuó",
    "鐯": "zhuō",
    "鵫": "zhuó",
    "鷟": "zhuó",
    "諑": "zhuó",
    "字": "zì",
    "紫": "zǐ",
    "籽": "zǐ",
    "子": "zǐ",
    "自": "zì",
    "资": "zī",
    "姿": "zī",
    "咨": "zī",
    "淄": "zī",
    "孜": "zī",
    "滓": "zǐ",
    "笫": "zǐ",
    "秭": "zǐ",
    "恣": "zì",
    "梓": "zǐ",
    "缁": "zī",
    "谘": "zī",
    "鲻": "zī",
    "锱": "zī",
    "觜": "zī,zuǐ",
    "孳": "zī",
    "耔": "zǐ",
    "赀": "zī",
    "髭": "zī",
    "訾": "zī",
    "嵫": "zī",
    "倳": "zì",
    "嗞": "zī",
    "剚": "zì",
    "眦": "zì",
    "姉": "zǐ",
    "辎": "zī",
    "崰": "zī",
    "孶": "zī",
    "杍": "zǐ",
    "栥": "zī",
    "姊": "zǐ",
    "椔": "zī",
    "湽": "zī",
    "榟": "zǐ",
    "牸": "zì",
    "矷": "zǐ",
    "禌": "zī",
    "秶": "zī",
    "秄": "zǐ,zì",
    "紎": "zī",
    "胾": "zì",
    "眥": "zì",
    "芓": "zì,zǐ",
    "茊": "zī",
    "茡": "zì",
    "虸": "zǐ",
    "葘": "zī",
    "訿": "zǐ",
    "緇": "zī",
    "趦": "zī",
    "諮": "zī",
    "貲": "zī",
    "資": "zī",
    "輺": "zī",
    "釨": "zǐ",
    "鄑": "zī",
    "鈭": "zī",
    "輜": "zī",
    "鍿": "zī",
    "鎡": "zī",
    "镃": "zī",
    "頾": "zī",
    "頿": "zī",
    "錙": "zī",
    "鰦": "zī",
    "鶅": "zī",
    "鼒": "zī",
    "唨": "zǔ",
    "咗": "zuo",
    "鯔": "zī",
    "宗": "zōng",
    "棕": "zōng",
    "鬃": "zōng",
    "踪": "zōng",
    "倊": "zǒng",
    "腙": "zōng",
    "倧": "zōng",
    "堫": "zōng",
    "粽": "zòng",
    "傯": "zǒng",
    "嵕": "zōng",
    "嵸": "zǒng",
    "嵏": "zōng",
    "惣": "zǒng",
    "惾": "zōng",
    "愡": "còng,sōng",
    "搃": "zǒng",
    "朡": "zōng",
    "昮": "zòng",
    "椶": "zōng",
    "熧": "zōng",
    "猔": "zòng",
    "猣": "zōng",
    "瘲": "zòng",
    "疭": "zòng",
    "摠": "zǒng",
    "磫": "zōng",
    "稯": "zōng,zǒng",
    "緃": "zōng",
    "糉": "zòng",
    "緵": "zōng,zòng",
    "縂": "zǒng",
    "翪": "zōng",
    "葼": "zōng",
    "蓗": "zǒng",
    "蝬": "zōng",
    "豵": "zōng",
    "踨": "zōng",
    "錝": "cóng",
    "鍯": "cōng",
    "鑁": "zōng",
    "鏓": "cōng",
    "騌": "zōng",
    "騣": "zōng",
    "骔": "zōng",
    "鬉": "zōng",
    "蹤": "zōng",
    "鯮": "zōng",
    "鯼": "zōng",
    "棸": "zōu",
    "緅": "zōu",
    "赱": "zǒu",
    "鯐": "zǒu",
    "走": "zǒu",
    "齺": "zōu",
    "鲰": "zōu",
    "黀": "zōu",
    "哫": "zú",
    "爼": "zǔ",
    "鯫": "zōu",
    "箤": "zú",
    "踿": "cù",
    "诅": "zǔ",
    "俎": "zǔ",
    "錊": "zuì",
    "鎺": "zǔ",
    "靻": "zǔ",
    "詛": "zǔ",
    "钻": "zuān,zuàn",
    "劗": "zuān",
    "纂": "zuǎn",
    "纉": "zuǎn",
    "繤": "zuǎn",
    "缵": "zuǎn",
    "籫": "zuǎn",
    "攥": "zuàn",
    "鑚": "zuān",
    "纘": "zuǎn",
    "鑽": "zuān",
    "嘴": "zuǐ",
    "厜": "zuī",
    "醉": "zuì",
    "罪": "zuì",
    "噿": "zuǐ",
    "嶊": "zuǐ",
    "嶵": "zuì",
    "晬": "zuì",
    "枠": "huà",
    "栬": "zuì",
    "樶": "zuī",
    "檇": "zuì",
    "檌": "zuì",
    "璻": "zuǐ",
    "祽": "zuì",
    "穝": "zuō",
    "絊": "zuì",
    "纗": "zuī",
    "蟕": "zuī",
    "辠": "zuì",
    "酔": "zuì",
    "尊": "zūn",
    "鳟": "zūn",
    "撙": "zǔn",
    "遵": "zūn",
    "捘": "zùn",
    "噂": "zūn",
    "嶟": "zūn",
    "繜": "zūn,zǔn",
    "樽": "zūn",
    "銌": "zùn",
    "譐": "zǔn",
    "鐏": "zūn",
    "鶎": "zūn",
    "鷷": "zūn",
    "罇": "zūn",
    "鱒": "zūn",
    "做": "zuò",
    "作": "zuò",
    "坐": "zuò",
    "左": "zuǒ",
    "座": "zuò",
    "昨": "zuó",
    "祚": "zuò",
    "佐": "zuǒ",
    "胙": "zuò",
    "侳": "zuò",
    "岝": "zuò",
    "岞": "zuò",
    "秨": "zuó",
    "稓": "zuó",
    "筰": "zuó",
    "糳": "zuò",
    "阼": "zuò",
    "繓": "zuǒ",
    "葄": "zuò",
    "袏": "zuò",
    "蓙": "zuò",
    "鈼": "zuó"
}
