/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.core.properties;

import java.util.Properties;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.NoIvGenerator;
import org.jasypt.properties.EncryptableProperties;
import org.jasypt.salt.RandomSaltGenerator;
import org.jasypt.salt.SaltGenerator;
import org.ow2.proactive.core.properties.PASharedProperties;

public class PropertyDecrypter {
    private static StandardPBEStringEncryptor encryptor = null;

    public static synchronized StringEncryptor getDefaultEncryptor() {
        if (encryptor == null) {
            encryptor = new StandardPBEStringEncryptor();
            encryptor.setPassword(PASharedProperties.PROPERTIES_CRYPT_KEY.getValueAsString());
            System.setProperty("jasypt.encryptor.password", PASharedProperties.PROPERTIES_CRYPT_KEY.getValueAsString());
            encryptor.setAlgorithm("PBEWithMD5AndDES");
            encryptor.setProviderName("SunJCE");
            encryptor.setStringOutputType("base64");
            encryptor.setSaltGenerator((SaltGenerator)new RandomSaltGenerator());
            encryptor.setIvGenerator((IvGenerator)new NoIvGenerator());
            encryptor.setKeyObtentionIterations(1000);
        }
        return encryptor;
    }

    public static Properties getDecryptableProperties() {
        StringEncryptor encryptor = PropertyDecrypter.getDefaultEncryptor();
        return new EncryptableProperties(encryptor);
    }
}

