function [idx,C,sumD,D] = mykmeans(X, k, varargin)

[start,distance,replicates,maxiter,ff_start,emptyaction,display] = ...
    myparse(varargin,'Start','furthestfirst',...
            'Distance','sqEuclidean',...
            'Replicates',1,'Maxiter',100,...
            'furthestfirst_start','sample',...
            'EmptyAction','singleton','Display','off');
[N,P] = size(X);

if strcmp(start,'furthestfirst'),

  start = zeros([k,P,replicates]);
  if strcmpi(ff_start,'sample')
    for rep = 1:replicates,
      start(:,:,rep) = furthestfirst(X, k, 'Distance', distance,...
                                     'Start','sample');
    end;
  else,
    replicates = 1;
    start = furthestfirst(X,k,'Distance',distance,...
                          'Start','mean');
  end;

  [idx,C,sumD,D] = matlabkmeans(X,k,'Start',start,'Distance',distance,...
                                'Replicates',replicates,'Maxiter',maxiter,...
                                'EmptyAction',emptyaction,'Display',display);

else,

  [idx,C,sumD,D] = matlabkmeans(X,k,'Start',start,'Distance',distance,...
                                'Replicates',replicates,'Maxiter',maxiter,...
                                'EmptyAction',emptyaction,'Display',display);

end;