/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.smartproxy;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.objectweb.proactive.extensions.dataspaces.vfs.selector.FileSelector;
import org.ow2.proactive.authentication.ConnectionInfo;
import org.ow2.proactive.authentication.UserData;
import org.ow2.proactive.scheduler.common.Page;
import org.ow2.proactive.scheduler.common.SchedulerEvent;
import org.ow2.proactive.scheduler.common.SchedulerEventListener;
import org.ow2.proactive.scheduler.common.SortSpecifierContainer;
import org.ow2.proactive.scheduler.common.TaskDescriptor;
import org.ow2.proactive.scheduler.common.exception.ImageValidationException;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.exception.JobValidationException;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.exception.SchedulerException;
import org.ow2.proactive.scheduler.common.exception.SubmissionClosedException;
import org.ow2.proactive.scheduler.common.exception.UnknownJobException;
import org.ow2.proactive.scheduler.common.exception.UnknownTaskException;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobIdDataAndError;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.job.JobResult;
import org.ow2.proactive.scheduler.common.job.JobState;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.common.task.TaskState;
import org.ow2.proactive.scheduler.common.task.TaskStatesPage;
import org.ow2.proactive.scheduler.common.task.TaskStatus;
import org.ow2.proactive.scheduler.common.task.dataspaces.InputSelector;
import org.ow2.proactive.scheduler.common.task.dataspaces.OutputSelector;
import org.ow2.proactive.scheduler.rest.DisconnectionAwareSchedulerEventListener;
import org.ow2.proactive.scheduler.rest.ISchedulerClient;
import org.ow2.proactive.scheduler.rest.SchedulerClient;
import org.ow2.proactive.scheduler.rest.ds.DataSpaceClient;
import org.ow2.proactive.scheduler.rest.ds.IDataSpaceClient;
import org.ow2.proactive.scheduler.rest.ds.LocalDestination;
import org.ow2.proactive.scheduler.rest.ds.LocalDirSource;
import org.ow2.proactive.scheduler.rest.ds.RemoteDestination;
import org.ow2.proactive.scheduler.rest.ds.RemoteSource;
import org.ow2.proactive.scheduler.signal.SignalApiException;
import org.ow2.proactive.scheduler.smartproxy.common.AbstractSmartProxy;
import org.ow2.proactive.scheduler.smartproxy.common.AwaitedJob;
import org.ow2.proactive.scheduler.smartproxy.common.AwaitedTask;
import org.ow2.proactive.scheduler.smartproxy.common.JobTracker;
import org.ow2.proactive.scheduler.smartproxy.common.SchedulerEventListenerExtended;
import org.ow2.proactive.utils.Tools;
import org.ow2.proactive_grid_cloud_portal.common.FileType;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.WorkflowUrlData;
import org.ow2.proactive_grid_cloud_portal.smartproxy.RestJobTrackerImpl;

public class RestSmartProxyImpl
extends AbstractSmartProxy<RestJobTrackerImpl>
implements ISchedulerClient,
SchedulerEventListener,
DisconnectionAwareSchedulerEventListener {
    private static final Logger logger = Logger.getLogger(RestSmartProxyImpl.class);
    private ISchedulerClient restSchedulerClient;
    private IDataSpaceClient restDataSpaceClient;

    public RestSmartProxyImpl() {
        super((JobTracker)new RestJobTrackerImpl());
    }

    public void init(ConnectionInfo connectionInfo) {
        try {
            this.connectionInfo = connectionInfo;
            this.restSchedulerClient = SchedulerClient.createInstance();
            this.restSchedulerClient.init(new ConnectionInfo(connectionInfo.getUrl(), connectionInfo.getLogin(), connectionInfo.getDomain(), connectionInfo.getPassword(), connectionInfo.getCredentialFile(), connectionInfo.isInsecure()));
            DataSpaceClient restDsClient = new DataSpaceClient();
            restDsClient.init(connectionInfo.getUrl(), this.restSchedulerClient);
            this.restDataSpaceClient = restDsClient;
            ((RestJobTrackerImpl)this.jobTracker).setRestDataSpaceClient(this.restDataSpaceClient);
            ((RestJobTrackerImpl)this.jobTracker).loadJobs();
            this.setInitialized(true);
            this.registerAsListener();
            this.syncAwaitedJobs();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void disconnect() throws PermissionException {
        try {
            this._getScheduler().disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInitialized(false);
    }

    public String getCurrentPolicy() throws NotConnectedException, PermissionException {
        return this._getScheduler().getCurrentPolicy();
    }

    public Map getJobsToSchedule() throws NotConnectedException, PermissionException {
        return this._getScheduler().getJobsToSchedule();
    }

    public List<TaskDescriptor> getTasksToSchedule() throws NotConnectedException, PermissionException {
        return this._getScheduler().getTasksToSchedule();
    }

    protected ISchedulerClient _getScheduler() {
        this.checkInitialized();
        return this.restSchedulerClient;
    }

    protected void createFolder(String fUri) throws NotConnectedException, PermissionException {
        RemoteSource remoteSource = new RemoteSource(IDataSpaceClient.Dataspace.USER, fUri);
        remoteSource.setType(FileType.FOLDER);
        this.restDataSpaceClient.create((IDataSpaceClient.IRemoteSource)remoteSource);
    }

    protected void removeJobIO(Job job, String pushURL, String pullURL, String newFolderName) {
        pushURL = pushURL + "/" + newFolderName;
        RemoteSource remoteSource = new RemoteSource(IDataSpaceClient.Dataspace.USER, pushURL);
        try {
            this.restDataSpaceClient.delete((IDataSpaceClient.IRemoteSource)remoteSource);
        }
        catch (NotConnectedException | PermissionException e) {
            logger.debug((Object)("Error in removeJobIO push for job " + job.getName()));
        }
        pullURL = pullURL + "/" + newFolderName;
        remoteSource.setPath(pullURL);
        try {
            this.restDataSpaceClient.delete((IDataSpaceClient.IRemoteSource)remoteSource);
        }
        catch (NotConnectedException | PermissionException e) {
            logger.debug((Object)("Error in removeJobIO pull for job " + job.getName()));
        }
    }

    public JobId reSubmit(JobId currentJobId, Map<String, String> jobVariables, Map<String, String> jobGenericInfos, String sessionId) throws NotConnectedException, UnknownJobException, PermissionException, JobCreationException, SubmissionClosedException {
        return this._getScheduler().reSubmit(currentJobId, jobVariables, jobGenericInfos, sessionId);
    }

    public JobId submit(Job job) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submit(job);
    }

    public List<JobIdDataAndError> submit(List<Job> jobs) throws NotConnectedException {
        return this._getScheduler().submit(jobs);
    }

    public JobId submit(File job) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submit(job);
    }

    public JobId submit(File job, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submit(job, variables);
    }

    public JobId submit(File job, Map<String, String> variables, Map<String, String> genericInfos) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submit(job, variables, genericInfos);
    }

    public JobId submit(URL job) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submit(job);
    }

    public JobId submit(URL job, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submit(job, variables);
    }

    public JobId submit(URL job, Map<String, String> variables, Map<String, String> headerParams) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submit(job, variables, headerParams);
    }

    public JobId submit(URL job, Map<String, String> variables, Map<String, String> genericInfos, Map<String, String> headerParams) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submit(job, variables, genericInfos, headerParams);
    }

    public JobId submit(Map<String, String> genericInfos, URL job, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submit(genericInfos, job, variables);
    }

    public JobId submitFromCatalog(String catalogRestURL, String bucketName, String workflowName) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submitFromCatalog(catalogRestURL, bucketName, workflowName);
    }

    public JobId submitFromCatalog(String catalogRestURL, String bucketName, String workflowName, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submitFromCatalog(catalogRestURL, bucketName, workflowName, variables);
    }

    public JobId submitFromCatalog(String catalogRestURL, String bucketName, String workflowName, Map<String, String> variables, Map<String, String> genericInfo) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submitFromCatalog(catalogRestURL, bucketName, workflowName, variables, genericInfo);
    }

    public JobId submitFromCatalog(String catalogRestURL, String calledWorkflow) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submitFromCatalog(catalogRestURL, calledWorkflow);
    }

    public JobId submitFromCatalog(String catalogRestURL, String calledWorkflow, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submitFromCatalog(catalogRestURL, calledWorkflow, variables);
    }

    public JobId submitFromCatalog(String catalogRestURL, String calledWorkflow, Map<String, String> variables, Map<String, String> genericInfo) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this._getScheduler().submitFromCatalog(catalogRestURL, calledWorkflow, variables, genericInfo);
    }

    public List<JobIdDataAndError> multipleSubmitFromUrls(List<WorkflowUrlData> workflowUrlDataList) throws NotConnectedException, PermissionException {
        return this._getScheduler().multipleSubmitFromUrls(workflowUrlDataList);
    }

    public JobState getJobState(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this._getScheduler().getJobState(jobId);
    }

    public TaskResult getTaskResult(String jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this._getScheduler().getTaskResult(jobId, taskName);
    }

    public boolean finishInErrorTask(String jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this._getScheduler().finishInErrorTask(jobId, taskName);
    }

    public boolean restartInErrorTask(String jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this._getScheduler().restartInErrorTask(jobId, taskName);
    }

    public boolean restartAllInErrorTasks(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this._getScheduler().restartAllInErrorTasks(jobId);
    }

    public List<String> getGlobalSpaceURIs() throws NotConnectedException, PermissionException {
        return this._getScheduler().getGlobalSpaceURIs();
    }

    public List<String> getUserSpaceURIs() throws NotConnectedException, PermissionException {
        return this._getScheduler().getUserSpaceURIs();
    }

    public void addEventListener(SchedulerEventListenerExtended listener, boolean myEventsOnly, SchedulerEvent ... events) throws NotConnectedException, PermissionException {
        this._getScheduler().addEventListener((SchedulerEventListener)listener, myEventsOnly, events);
    }

    public boolean uploadInputfiles(TaskFlowJob job, String localInputFolderPath) throws NotConnectedException, PermissionException {
        try {
            List<String> userSpaces = this.getUserSpaceURIs();
            List<String> inputSpaces = Arrays.asList(Tools.dataSpaceConfigPropertyToUrls((String)job.getInputSpace()));
            String remotePath = this.extractRelativePath(userSpaces, inputSpaces);
            if (remotePath == null) {
                throw new IllegalArgumentException("Could not extract remote path using inputSpace=" + inputSpaces + " and userSpace=" + userSpaces);
            }
            String jname = job.getName();
            logger.debug((Object)("Pushing files for job " + jname + " from " + localInputFolderPath + " to " + remotePath));
            TaskFlowJob tfj = job;
            for (Task task : tfj.getTasks()) {
                if (task.getInputFilesList() == null) continue;
                this.uploadInputFilesForTask(localInputFolderPath, remotePath, task);
            }
            logger.debug((Object)("Finished push operation from " + localInputFolderPath + " to " + remotePath));
        }
        catch (Exception error) {
            throw Throwables.propagate((Throwable)error);
        }
        return true;
    }

    private void uploadInputFilesForTask(String localInputFolderPath, String remotePath, Task task) throws NotConnectedException, PermissionException {
        logger.debug((Object)("Pushing files for task " + task.getName()));
        ArrayList includes = Lists.newArrayList();
        ArrayList excludes = Lists.newArrayList();
        List inputFilesList = task.getInputFilesList();
        if (inputFilesList != null) {
            for (InputSelector is : inputFilesList) {
                this.addfileSelection(is.getInputFiles(), includes, excludes);
            }
        }
        LocalDirSource source = new LocalDirSource(localInputFolderPath);
        source.setIncludes((List)includes);
        source.setExcludes((List)excludes);
        RemoteDestination dest = new RemoteDestination(IDataSpaceClient.Dataspace.USER, remotePath);
        this.restDataSpaceClient.upload((IDataSpaceClient.ILocalSource)source, (IDataSpaceClient.IRemoteDestination)dest);
    }

    private String extractRelativePath(List<String> userSpaces, List<String> urls) {
        String remotePath = null;
        for (int i = 0; i < urls.size() && i < userSpaces.size(); ++i) {
            String userSpace;
            String url = urls.get(i);
            if (!url.startsWith(userSpace = userSpaces.get(i))) continue;
            remotePath = url.substring(userSpace.length() + (userSpace.endsWith("/") ? 0 : 1));
            break;
        }
        return remotePath;
    }

    protected void downloadTaskOutputFiles(AwaitedJob awaitedjob, String jobId, String taskName, String localFolder) throws NotConnectedException, PermissionException {
        String sourceFile;
        AwaitedTask atask;
        block15: {
            atask = awaitedjob.getAwaitedTask(taskName);
            if (atask == null) {
                throw new IllegalArgumentException("The task " + taskName + " does not belong to job " + jobId + " or has already been removed");
            }
            if (atask.isTransferring()) {
                logger.warn((Object)("The task " + taskName + " of job " + jobId + " is already transferring its output"));
                return;
            }
            try {
                List<String> userSpaces = this.getUserSpaceURIs();
                List<String> outputSpaces = Arrays.asList(Tools.dataSpaceConfigPropertyToUrls((String)awaitedjob.getOutputSpaceURL()));
                sourceFile = this.extractRelativePath(userSpaces, outputSpaces);
                if (sourceFile != null) break block15;
                if (awaitedjob.isAutomaticTransfer()) {
                    logger.error((Object)("Could not extract remote path using inputSpace=" + outputSpaces + " and userSpace=" + userSpaces));
                    break block15;
                }
                throw new IllegalArgumentException("Could not extract remote path using outputSpace=" + outputSpaces + " and userSpace=" + userSpaces);
            }
            catch (Throwable error) {
                throw Throwables.propagate((Throwable)error);
            }
        }
        if (awaitedjob.isIsolateTaskOutputs()) {
            sourceFile = sourceFile.replace("TASKID", "TASKID/" + atask.getTaskId());
        }
        List outputFileSelectors = atask.getOutputSelectors();
        ArrayList includes = Lists.newArrayList();
        ArrayList excludes = Lists.newArrayList();
        if (outputFileSelectors != null) {
            for (OutputSelector os : outputFileSelectors) {
                this.addfileSelection(os.getOutputFiles(), includes, excludes);
            }
        }
        ((RestJobTrackerImpl)this.jobTracker).setTaskTransferring(jobId, taskName, true);
        if (awaitedjob.isAutomaticTransfer()) {
            this.threadPool.submit(new DownloadHandler(jobId, taskName, sourceFile, includes, excludes, localFolder));
        } else {
            try {
                RemoteSource source = new RemoteSource(IDataSpaceClient.Dataspace.USER, sourceFile);
                source.setIncludes((List)includes);
                source.setExcludes((List)excludes);
                File localDir = new File(localFolder);
                LocalDestination dest = new LocalDestination(localDir);
                this.restDataSpaceClient.download((IDataSpaceClient.IRemoteSource)source, (IDataSpaceClient.ILocalDestination)dest);
            }
            catch (NotConnectedException | PermissionException e) {
                logger.error((Object)String.format("Cannot download files, jobId=%s, taskId=%s, source=%s, destination=%s", jobId, taskName, sourceFile, localFolder), e);
                throw e;
            }
            finally {
                ((RestJobTrackerImpl)this.jobTracker).setTaskTransferring(jobId, taskName, false);
            }
            ((RestJobTrackerImpl)this.jobTracker).removeAwaitedTask(jobId, taskName);
        }
    }

    private void addfileSelection(FileSelector fs, List<String> includes, List<String> excludes) {
        includes.addAll(fs.getIncludes());
        excludes.addAll(fs.getExcludes());
    }

    public void registerAsListener() throws NotConnectedException, PermissionException {
        this._getScheduler().addEventListener((SchedulerEventListener)this, true, this.configuredEvents);
    }

    public void setSession(String sid) {
        this._getScheduler().setSession(sid);
    }

    public String getSession() {
        return this._getScheduler().getSession();
    }

    public boolean isJobFinished(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this._getScheduler().isJobFinished(jobId);
    }

    public boolean isJobFinished(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this._getScheduler().isJobFinished(jobId);
    }

    public JobResult waitForJob(JobId jobId, long timeout) throws NotConnectedException, UnknownJobException, PermissionException, TimeoutException {
        return this._getScheduler().waitForJob(jobId, timeout);
    }

    public JobResult waitForJob(String jobId, long timeout) throws NotConnectedException, UnknownJobException, PermissionException, TimeoutException {
        return this._getScheduler().waitForJob(jobId, timeout);
    }

    public boolean isTaskFinished(String jobId, String taskName) throws UnknownJobException, NotConnectedException, PermissionException, UnknownTaskException {
        return this._getScheduler().isTaskFinished(jobId, taskName);
    }

    public TaskResult waitForTask(String jobId, String taskName, long timeout) throws UnknownJobException, NotConnectedException, PermissionException, UnknownTaskException, TimeoutException {
        return this._getScheduler().waitForTask(jobId, taskName, timeout);
    }

    public List<JobResult> waitForAllJobs(List<String> jobIds, long timeout) throws NotConnectedException, UnknownJobException, PermissionException, TimeoutException {
        return this._getScheduler().waitForAllJobs(jobIds, timeout);
    }

    public Map.Entry<String, JobResult> waitForAnyJob(List<String> jobIds, long timeout) throws NotConnectedException, UnknownJobException, PermissionException, TimeoutException {
        return this._getScheduler().waitForAnyJob(jobIds, timeout);
    }

    public Map.Entry<String, TaskResult> waitForAnyTask(String jobId, List<String> taskNames, long timeout) throws UnknownJobException, NotConnectedException, PermissionException, UnknownTaskException, TimeoutException {
        return this._getScheduler().waitForAnyTask(jobId, taskNames, timeout);
    }

    public List<Map.Entry<String, TaskResult>> waitForAllTasks(String jobId, List<String> taskNames, long timeout) throws UnknownJobException, NotConnectedException, PermissionException, UnknownTaskException, TimeoutException {
        return this._getScheduler().waitForAllTasks(jobId, taskNames, timeout);
    }

    public boolean pushFile(String spacename, String pathname, String filename, String file) throws NotConnectedException, PermissionException {
        return this._getScheduler().pushFile(spacename, pathname, filename, file);
    }

    public void pullFile(String space, String pathname, String outputFile) throws NotConnectedException, PermissionException {
        this._getScheduler().pullFile(space, pathname, outputFile);
    }

    public boolean deleteFile(String space, String pathname) throws NotConnectedException, PermissionException {
        return this._getScheduler().deleteFile(space, pathname);
    }

    public Page<TaskId> getTaskIds(String taskTag, long from, long to, boolean mytasks, Set<TaskStatus> taskStatuses, int offset, int limit) throws SchedulerException {
        return this._getScheduler().getTaskIds(taskTag, from, to, mytasks, taskStatuses, offset, limit);
    }

    public Page<TaskState> getTaskStates(String taskTag, long from, long to, boolean mytasks, Set<TaskStatus> statusFilter, int offset, int limit, SortSpecifierContainer sortParams) throws SchedulerException {
        return this._getScheduler().getTaskStates(taskTag, from, to, mytasks, statusFilter, offset, limit, sortParams);
    }

    public JobInfo getJobInfo(String jobId) throws SchedulerException {
        return this._getScheduler().getJobInfo(jobId);
    }

    public boolean changeStartAt(JobId jobId, String startAt) throws NotConnectedException, UnknownJobException, PermissionException {
        return this._getScheduler().changeStartAt(jobId, startAt);
    }

    public boolean changeStartAt(List<JobId> jobIdList, String startAt) throws NotConnectedException, UnknownJobException, PermissionException {
        return this._getScheduler().changeStartAt(jobIdList, startAt);
    }

    public String getJobContent(JobId jobId) throws SchedulerException {
        return this._getScheduler().getJobContent(jobId);
    }

    public Map<Object, Object> getPortalConfiguration() throws SchedulerException {
        return this._getScheduler().getPortalConfiguration();
    }

    public String getCurrentUser() throws NotConnectedException {
        return this._getScheduler().getCurrentUser();
    }

    public UserData getCurrentUserData() throws NotConnectedException {
        return this._getScheduler().getCurrentUserData();
    }

    public Subject getSubject() throws NotConnectedException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getSchedulerProperties() throws SchedulerException {
        return this._getScheduler().getSchedulerProperties();
    }

    public TaskStatesPage getTaskPaginated(String jobId, int offset, int limit) throws NotConnectedException, UnknownJobException, PermissionException {
        return this._getScheduler().getTaskPaginated(jobId, offset, limit);
    }

    public TaskStatesPage getTaskPaginated(String jobId, String statusFilter, int offset, int limit) throws NotConnectedException, UnknownJobException, PermissionException {
        return this._getScheduler().getTaskPaginated(jobId, statusFilter, offset, limit);
    }

    public List<TaskResult> getPreciousTaskResults(String jobId) throws NotConnectedException, PermissionException, UnknownJobException {
        return this._getScheduler().getPreciousTaskResults(jobId);
    }

    public Map<Long, Map<String, Serializable>> getJobResultMaps(List<String> jobsId) throws UnknownJobException, NotConnectedException, PermissionException {
        return this._getScheduler().getJobResultMaps(jobsId);
    }

    public Map<Long, List<String>> getPreciousTaskNames(List<String> jobsId) throws SchedulerException {
        return this._getScheduler().getPreciousTaskNames(jobsId);
    }

    public void enableRemoteVisualization(String jobId, String taskName, String connectionString) throws NotConnectedException, PermissionException, UnknownJobException, UnknownTaskException {
        this._getScheduler().enableRemoteVisualization(jobId, taskName, connectionString);
    }

    public void registerService(String jobId, int serviceInstanceid, boolean enableActions) throws NotConnectedException, PermissionException, UnknownJobException {
        this._getScheduler().registerService(jobId, serviceInstanceid, enableActions);
    }

    public void detachService(String jobId, int serviceInstanceid) throws NotConnectedException, PermissionException, UnknownJobException {
        this._getScheduler().detachService(jobId, serviceInstanceid);
    }

    public void notifyDisconnection() {
        if (!this.terminating) {
            logger.warn((Object)"Websocket disconnection notification received.");
            for (SchedulerEventListenerExtended listener : this.eventListeners) {
                if (!(listener instanceof DisconnectionAwareSchedulerEventListener)) continue;
                ((DisconnectionAwareSchedulerEventListener)listener).notifyDisconnection();
            }
            try {
                this.registerAsListener();
                this.syncAwaitedJobs();
            }
            catch (Exception e) {
                logger.error((Object)"Error while reconnecting", (Throwable)e);
            }
        }
    }

    public boolean checkPermission(String method) throws SecurityException {
        return this._getScheduler().checkPermission(method);
    }

    public boolean checkJobPermissionMethod(String jobId, String method) throws SchedulerException {
        return this._getScheduler().checkJobPermissionMethod(jobId, method);
    }

    public List<String> checkJobsPermissionMethod(List<String> jobIds, String method) throws SchedulerException {
        return this._getScheduler().checkJobsPermissionMethod(jobIds, method);
    }

    public Set<String> addJobSignal(String jobId, String signal, Map<String, String> updatedVariables) throws UnknownJobException, NotConnectedException, PermissionException, SignalApiException, JobValidationException {
        return this._getScheduler().addJobSignal(jobId, signal, updatedVariables);
    }

    public List<JobVariable> validateJobSignal(String jobId, String signal, Map<String, String> updatedVariables) throws UnknownJobException, NotConnectedException, PermissionException, SignalApiException, JobValidationException {
        return this._getScheduler().validateJobSignal(jobId, signal, updatedVariables);
    }

    public void addExternalEndpointUrl(String jobId, String endpointName, String externalEndpointUrl, String endpointIconUri) throws NotConnectedException, PermissionException, UnknownJobException {
        this._getScheduler().addExternalEndpointUrl(jobId, endpointName, externalEndpointUrl, endpointIconUri);
    }

    public void removeExternalEndpointUrl(String jobId, String endpointName) throws NotConnectedException, PermissionException, UnknownJobException {
        this._getScheduler().removeExternalEndpointUrl(jobId, endpointName);
    }

    public void updateLogo(byte[] image) throws NotConnectedException, PermissionException, ImageValidationException {
        this._getScheduler().updateLogo(image);
    }

    private class DownloadHandler
    implements Runnable {
        private String jobId;
        private String taskName;
        private String sourceFile;
        private List<String> includes;
        private List<String> excludes;
        private String localFolder;

        public DownloadHandler(String jobId, String taskName, String sourceFile, List<String> includes, List<String> excludes, String localFolder) {
            this.jobId = jobId;
            this.taskName = taskName;
            this.sourceFile = sourceFile;
            this.includes = includes;
            this.excludes = excludes;
            this.localFolder = localFolder;
        }

        @Override
        public void run() {
            try {
                RemoteSource source = new RemoteSource(IDataSpaceClient.Dataspace.USER, this.sourceFile);
                source.setIncludes(this.includes);
                source.setExcludes(this.excludes);
                File localDir = new File(this.localFolder);
                LocalDestination dest = new LocalDestination(localDir);
                RestSmartProxyImpl.this.restDataSpaceClient.download((IDataSpaceClient.IRemoteSource)source, (IDataSpaceClient.ILocalDestination)dest);
            }
            catch (Throwable error) {
                logger.error((Object)String.format("Cannot download output files: job_id=%s, task_name=%s, source=%s, destination=%s", this.jobId, this.taskName, this.sourceFile, this.localFolder), error);
                logger.warn((Object)String.format("[job_id=%s, task_name=%s] will be removed from the known task list. The system will not attempt again to retrieve data for this task. You could try to manually copy the data from %s in userspace.", this.jobId, this.taskName, this.sourceFile));
                Iterator it = RestSmartProxyImpl.this.eventListeners.iterator();
                while (it.hasNext()) {
                    SchedulerEventListenerExtended l = (SchedulerEventListenerExtended)it.next();
                    try {
                        l.pullDataFailed(this.jobId, this.taskName, this.sourceFile, error);
                    }
                    catch (Exception e1) {
                        it.remove();
                    }
                }
                RestSmartProxyImpl.this.removeAwaitedTask(this.jobId, this.taskName);
                return;
            }
            Iterator it = RestSmartProxyImpl.this.eventListeners.iterator();
            while (it.hasNext()) {
                SchedulerEventListenerExtended l = (SchedulerEventListenerExtended)it.next();
                try {
                    l.pullDataFinished(this.jobId, this.taskName, this.localFolder);
                }
                catch (Exception e1) {
                    it.remove();
                }
            }
            RestSmartProxyImpl.this.removeAwaitedTask(this.jobId, this.taskName);
        }
    }
}

