/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.task.NativeTask;
import org.ow2.proactive.scripting.InvalidScriptException;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.SelectionScript;
import org.ow2.proactive.scripting.SimpleScript;
import org.ow2.proactive.utils.Tools;

@PublicAPI
public class FlatJobFactory {
    public static Logger logger = Logger.getLogger(FlatJobFactory.class);
    public static final String CMD_FILE_COMMENT_CHAR = "#";
    public static final String JOB_DEFAULT_NAME_PREFIX = "Job_";
    private static FlatJobFactory factory = null;

    public static FlatJobFactory getFactory() {
        if (factory == null) {
            factory = new FlatJobFactory();
        }
        return factory;
    }

    public Job createNativeJobFromCommandsFile(String commandFilePath, String jobName, String selectionScriptPath, String userName) throws JobCreationException {
        if (jobName == null) {
            jobName = JOB_DEFAULT_NAME_PREFIX + userName;
        }
        TaskFlowJob nativeJob = new TaskFlowJob();
        nativeJob.setName(jobName);
        logger.debug((Object)("Job : " + nativeJob.getName()));
        try {
            File commandFile = new File(commandFilePath);
            if (!commandFile.isFile()) {
                throw new JobCreationException("Error occured during Job creation, check that file " + commandFilePath + " exists and is a readable file");
            }
            int task_number = 0;
            ArrayList<String> commandList = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader(commandFile));){
                String commandLine;
                while ((commandLine = reader.readLine()) != null) {
                    if ((commandLine = commandLine.trim()).startsWith(CMD_FILE_COMMENT_CHAR, 0) || "".equals(commandLine)) continue;
                    commandList.add(commandLine);
                }
            }
            if (commandList.size() == 0) {
                throw new JobCreationException("Error occured during Job creation, No any valid command line has been built from" + commandFilePath + "");
            }
            int numberOfDigit = Integer.toString(commandList.size()).length();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumIntegerDigits(numberOfDigit);
            nf.setMinimumIntegerDigits(numberOfDigit);
            for (String command : commandList) {
                NativeTask t = this.createNativeTaskFromCommandString(command, "task_" + nf.format(++task_number), selectionScriptPath);
                t.setPreciousResult(true);
                nativeJob.addTask(t);
                logger.debug((Object)("-> Task Name = " + t.getName()));
                logger.debug((Object)("-> command = " + t.getCommandLine() + "\n"));
            }
        }
        catch (Exception e) {
            throw new JobCreationException(e);
        }
        return nativeJob;
    }

    public Job createNativeJobFromCommand(String command, String jobName, String selectionScriptPath, String userName) throws JobCreationException {
        if (command == null || "".equalsIgnoreCase(command)) {
            throw new JobCreationException("Error, command cannot be null");
        }
        if (jobName == null) {
            jobName = JOB_DEFAULT_NAME_PREFIX + userName;
        }
        TaskFlowJob nativeJob = new TaskFlowJob();
        nativeJob.setName(jobName);
        logger.debug((Object)("Job : " + nativeJob.getName()));
        try {
            NativeTask t = this.createNativeTaskFromCommandString(command, "task1", selectionScriptPath);
            t.setPreciousResult(true);
            nativeJob.addTask(t);
            logger.debug((Object)("-> Task Name = " + t.getName()));
            logger.debug((Object)("-> command = " + t.getCommandLine() + "\n"));
        }
        catch (Exception e) {
            throw new JobCreationException(e);
        }
        return nativeJob;
    }

    private NativeTask createNativeTaskFromCommandString(String command, String taskName, String selectionScriptPath) throws InvalidScriptException {
        NativeTask desc = new NativeTask();
        desc.setCommandLine(Tools.parseCommandLine((String)command));
        desc.setName(taskName);
        if (selectionScriptPath != null) {
            SelectionScript script = new SelectionScript((Script)new SimpleScript(new File(selectionScriptPath), null), true);
            desc.addSelectionScript(script);
        }
        return desc;
    }
}

