# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.0
#
# <auto-generated>
#
# Generated from file `Metrics.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Ice_BuiltinSequences_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module IceMX
_M_IceMX = Ice.openModule('IceMX')
__name__ = 'IceMX'
_M_IceMX.__doc__ = '''The Ice Management eXtension facility. It provides the 
IceMX#MetricsAdmin interface for management clients to retrieve
metrics from Ice applications.'''

if '_t_StringIntDict' not in _M_IceMX.__dict__:
    _M_IceMX._t_StringIntDict = IcePy.defineDictionary('::IceMX::StringIntDict', (), IcePy._t_string, IcePy._t_int)

if 'Metrics' not in _M_IceMX.__dict__:
    _M_IceMX.Metrics = Ice.createTempClass()
    class Metrics(Ice.Object):
        '''The base class for metrics. A metrics object represents a
collection of measurements associated to a given a system.'''
        def __init__(self, id='', total=0, current=0, totalLifetime=0, failures=0):
            self.id = id
            self.total = total
            self.current = current
            self.totalLifetime = totalLifetime
            self.failures = failures

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceMX::Metrics')

        def ice_id(self, current=None):
            return '::IceMX::Metrics'

        def ice_staticId():
            return '::IceMX::Metrics'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_Metrics)

        __repr__ = __str__

    _M_IceMX.MetricsPrx = Ice.createTempClass()
    class MetricsPrx(Ice.ObjectPrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceMX.MetricsPrx.ice_checkedCast(proxy, '::IceMX::Metrics', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceMX.MetricsPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceMX::Metrics'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceMX._t_MetricsPrx = IcePy.defineProxy('::IceMX::Metrics', MetricsPrx)

    _M_IceMX._t_Metrics = IcePy.defineClass('::IceMX::Metrics', Metrics, -1, (), False, False, None, (), (
        ('id', (), IcePy._t_string, False, 0),
        ('total', (), IcePy._t_long, False, 0),
        ('current', (), IcePy._t_int, False, 0),
        ('totalLifetime', (), IcePy._t_long, False, 0),
        ('failures', (), IcePy._t_int, False, 0)
    ))
    Metrics._ice_type = _M_IceMX._t_Metrics

    _M_IceMX.Metrics = Metrics
    del Metrics

    _M_IceMX.MetricsPrx = MetricsPrx
    del MetricsPrx

if 'MetricsFailures' not in _M_IceMX.__dict__:
    _M_IceMX.MetricsFailures = Ice.createTempClass()
    class MetricsFailures(object):
        '''A structure to keep track of failures associated with a given
metrics.'''
        def __init__(self, id='', failures=None):
            self.id = id
            self.failures = failures

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceMX.MetricsFailures):
                return NotImplemented
            else:
                if self.id != other.id:
                    return False
                if self.failures != other.failures:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_MetricsFailures)

        __repr__ = __str__

    _M_IceMX._t_MetricsFailures = IcePy.defineStruct('::IceMX::MetricsFailures', MetricsFailures, (), (
        ('id', (), IcePy._t_string),
        ('failures', (), _M_IceMX._t_StringIntDict)
    ))

    _M_IceMX.MetricsFailures = MetricsFailures
    del MetricsFailures

if '_t_MetricsFailuresSeq' not in _M_IceMX.__dict__:
    _M_IceMX._t_MetricsFailuresSeq = IcePy.defineSequence('::IceMX::MetricsFailuresSeq', (), _M_IceMX._t_MetricsFailures)

if '_t_MetricsMap' not in _M_IceMX.__dict__:
    _M_IceMX._t_MetricsMap = IcePy.defineSequence('::IceMX::MetricsMap', (), _M_IceMX._t_Metrics)

if '_t_MetricsView' not in _M_IceMX.__dict__:
    _M_IceMX._t_MetricsView = IcePy.defineDictionary('::IceMX::MetricsView', (), IcePy._t_string, _M_IceMX._t_MetricsMap)

if 'UnknownMetricsView' not in _M_IceMX.__dict__:
    _M_IceMX.UnknownMetricsView = Ice.createTempClass()
    class UnknownMetricsView(Ice.UserException):
        '''Raised if a metrics view cannot be found.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IceMX::UnknownMetricsView'

    _M_IceMX._t_UnknownMetricsView = IcePy.defineException('::IceMX::UnknownMetricsView', UnknownMetricsView, (), False, None, ())
    UnknownMetricsView._ice_type = _M_IceMX._t_UnknownMetricsView

    _M_IceMX.UnknownMetricsView = UnknownMetricsView
    del UnknownMetricsView

if 'MetricsAdmin' not in _M_IceMX.__dict__:
    _M_IceMX.MetricsAdmin = Ice.createTempClass()
    class MetricsAdmin(Ice.Object):
        '''The metrics administrative facet interface. This interface allows
remote administrative clients to access metrics of an application
that enabled the Ice administrative facility and configured some
metrics views.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceMX.MetricsAdmin:
                raise RuntimeError('IceMX.MetricsAdmin is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceMX::MetricsAdmin')

        def ice_id(self, current=None):
            return '::IceMX::MetricsAdmin'

        def ice_staticId():
            return '::IceMX::MetricsAdmin'
        ice_staticId = staticmethod(ice_staticId)

        def getMetricsViewNames(self, current=None):
            '''Get the names of enabled and disabled metrics.

Arguments:
    disabledViews The names of the disabled views.

Returns:
    The name of the enabled views.'''
            pass

        def enableMetricsView(self, name, current=None):
            '''Enables a metrics view.

Arguments:
    name The metrics view name.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
            pass

        def disableMetricsView(self, name, current=None):
            '''Disable a metrics view.

Arguments:
    name The metrics view name.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
            pass

        def getMetricsView(self, view, current=None):
            '''Get the metrics objects for the given metrics view. This
returns a dictionnary of metric maps for each metrics class
configured with the view. The timestamp allows the client to
compute averages which are not dependent of the invocation
latency for this operation.

Arguments:
    view The name of the metrics view.

    timestamp The local time of the process when the metrics
object were retrieved.

Returns:
    The metrics view data.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
            pass

        def getMapMetricsFailures(self, view, map, current=None):
            '''Get the metrics failures associated with the given view and map.

Arguments:
    view The name of the metrics view.

    map The name of the metrics map.

Returns:
    The metrics failures associated with the map.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
            pass

        def getMetricsFailures(self, view, map, id, current=None):
            '''Get the metrics failure associated for the given metrics.

Arguments:
    view The name of the metrics view.

    map The name of the metrics map.

    id The ID of the metrics.

Returns:
    The metrics failures associated with the metrics.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_MetricsAdmin)

        __repr__ = __str__

    _M_IceMX.MetricsAdminPrx = Ice.createTempClass()
    class MetricsAdminPrx(Ice.ObjectPrx):

        '''Get the names of enabled and disabled metrics.

Arguments:
    disabledViews The names of the disabled views.

Returns:
    The name of the enabled views.'''
        def getMetricsViewNames(self, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_getMetricsViewNames.invoke(self, ((), _ctx))

        '''Get the names of enabled and disabled metrics.

Arguments:
    disabledViews The names of the disabled views.

Returns:
    The name of the enabled views.'''
        def begin_getMetricsViewNames(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_getMetricsViewNames.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get the names of enabled and disabled metrics.

Arguments:
    disabledViews The names of the disabled views.

Returns:
    The name of the enabled views.'''
        def end_getMetricsViewNames(self, _r):
            return _M_IceMX.MetricsAdmin._op_getMetricsViewNames.end(self, _r)

        '''Enables a metrics view.

Arguments:
    name The metrics view name.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def enableMetricsView(self, name, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_enableMetricsView.invoke(self, ((name, ), _ctx))

        '''Enables a metrics view.

Arguments:
    name The metrics view name.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def begin_enableMetricsView(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_enableMetricsView.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Enables a metrics view.

Arguments:
    name The metrics view name.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def end_enableMetricsView(self, _r):
            return _M_IceMX.MetricsAdmin._op_enableMetricsView.end(self, _r)

        '''Disable a metrics view.

Arguments:
    name The metrics view name.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def disableMetricsView(self, name, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_disableMetricsView.invoke(self, ((name, ), _ctx))

        '''Disable a metrics view.

Arguments:
    name The metrics view name.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def begin_disableMetricsView(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_disableMetricsView.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Disable a metrics view.

Arguments:
    name The metrics view name.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def end_disableMetricsView(self, _r):
            return _M_IceMX.MetricsAdmin._op_disableMetricsView.end(self, _r)

        '''Get the metrics objects for the given metrics view. This
returns a dictionnary of metric maps for each metrics class
configured with the view. The timestamp allows the client to
compute averages which are not dependent of the invocation
latency for this operation.

Arguments:
    view The name of the metrics view.

    timestamp The local time of the process when the metrics
object were retrieved.

Returns:
    The metrics view data.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def getMetricsView(self, view, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_getMetricsView.invoke(self, ((view, ), _ctx))

        '''Get the metrics objects for the given metrics view. This
returns a dictionnary of metric maps for each metrics class
configured with the view. The timestamp allows the client to
compute averages which are not dependent of the invocation
latency for this operation.

Arguments:
    view The name of the metrics view.

    timestamp The local time of the process when the metrics
object were retrieved.

Returns:
    The metrics view data.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def begin_getMetricsView(self, view, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_getMetricsView.begin(self, ((view, ), _response, _ex, _sent, _ctx))

        '''Get the metrics objects for the given metrics view. This
returns a dictionnary of metric maps for each metrics class
configured with the view. The timestamp allows the client to
compute averages which are not dependent of the invocation
latency for this operation.

Arguments:
    view The name of the metrics view.

    timestamp The local time of the process when the metrics
object were retrieved.

Returns:
    The metrics view data.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def end_getMetricsView(self, _r):
            return _M_IceMX.MetricsAdmin._op_getMetricsView.end(self, _r)

        '''Get the metrics failures associated with the given view and map.

Arguments:
    view The name of the metrics view.

    map The name of the metrics map.

Returns:
    The metrics failures associated with the map.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def getMapMetricsFailures(self, view, map, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_getMapMetricsFailures.invoke(self, ((view, map), _ctx))

        '''Get the metrics failures associated with the given view and map.

Arguments:
    view The name of the metrics view.

    map The name of the metrics map.

Returns:
    The metrics failures associated with the map.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def begin_getMapMetricsFailures(self, view, map, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_getMapMetricsFailures.begin(self, ((view, map), _response, _ex, _sent, _ctx))

        '''Get the metrics failures associated with the given view and map.

Arguments:
    view The name of the metrics view.

    map The name of the metrics map.

Returns:
    The metrics failures associated with the map.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def end_getMapMetricsFailures(self, _r):
            return _M_IceMX.MetricsAdmin._op_getMapMetricsFailures.end(self, _r)

        '''Get the metrics failure associated for the given metrics.

Arguments:
    view The name of the metrics view.

    map The name of the metrics map.

    id The ID of the metrics.

Returns:
    The metrics failures associated with the metrics.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def getMetricsFailures(self, view, map, id, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_getMetricsFailures.invoke(self, ((view, map, id), _ctx))

        '''Get the metrics failure associated for the given metrics.

Arguments:
    view The name of the metrics view.

    map The name of the metrics map.

    id The ID of the metrics.

Returns:
    The metrics failures associated with the metrics.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def begin_getMetricsFailures(self, view, map, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceMX.MetricsAdmin._op_getMetricsFailures.begin(self, ((view, map, id), _response, _ex, _sent, _ctx))

        '''Get the metrics failure associated for the given metrics.

Arguments:
    view The name of the metrics view.

    map The name of the metrics map.

    id The ID of the metrics.

Returns:
    The metrics failures associated with the metrics.

Exceptions:
    UnknownMetricsView Raised if the metrics view cannot be
found.'''
        def end_getMetricsFailures(self, _r):
            return _M_IceMX.MetricsAdmin._op_getMetricsFailures.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceMX.MetricsAdminPrx.ice_checkedCast(proxy, '::IceMX::MetricsAdmin', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceMX.MetricsAdminPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceMX::MetricsAdmin'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceMX._t_MetricsAdminPrx = IcePy.defineProxy('::IceMX::MetricsAdmin', MetricsAdminPrx)

    _M_IceMX._t_MetricsAdmin = IcePy.defineClass('::IceMX::MetricsAdmin', MetricsAdmin, -1, (), True, False, None, (), ())
    MetricsAdmin._ice_type = _M_IceMX._t_MetricsAdmin

    MetricsAdmin._op_getMetricsViewNames = IcePy.Operation('getMetricsViewNames', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, Ice.FormatType.SlicedFormat, (), (), (((), _M_Ice._t_StringSeq, False, 0),), ((), _M_Ice._t_StringSeq, False, 0), ())
    MetricsAdmin._op_enableMetricsView = IcePy.Operation('enableMetricsView', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, Ice.FormatType.SlicedFormat, (), (((), IcePy._t_string, False, 0),), (), None, (_M_IceMX._t_UnknownMetricsView,))
    MetricsAdmin._op_disableMetricsView = IcePy.Operation('disableMetricsView', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, Ice.FormatType.SlicedFormat, (), (((), IcePy._t_string, False, 0),), (), None, (_M_IceMX._t_UnknownMetricsView,))
    MetricsAdmin._op_getMetricsView = IcePy.Operation('getMetricsView', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, Ice.FormatType.SlicedFormat, (), (((), IcePy._t_string, False, 0),), (((), IcePy._t_long, False, 0),), ((), _M_IceMX._t_MetricsView, False, 0), (_M_IceMX._t_UnknownMetricsView,))
    MetricsAdmin._op_getMapMetricsFailures = IcePy.Operation('getMapMetricsFailures', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, Ice.FormatType.SlicedFormat, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_string, False, 0)), (), ((), _M_IceMX._t_MetricsFailuresSeq, False, 0), (_M_IceMX._t_UnknownMetricsView,))
    MetricsAdmin._op_getMetricsFailures = IcePy.Operation('getMetricsFailures', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, Ice.FormatType.SlicedFormat, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_string, False, 0), ((), IcePy._t_string, False, 0)), (), ((), _M_IceMX._t_MetricsFailures, False, 0), (_M_IceMX._t_UnknownMetricsView,))

    _M_IceMX.MetricsAdmin = MetricsAdmin
    del MetricsAdmin

    _M_IceMX.MetricsAdminPrx = MetricsAdminPrx
    del MetricsAdminPrx

if 'ThreadMetrics' not in _M_IceMX.__dict__:
    _M_IceMX.ThreadMetrics = Ice.createTempClass()
    class ThreadMetrics(_M_IceMX.Metrics):
        '''Provides information on the number of threads currently in use and
their activity.'''
        def __init__(self, id='', total=0, current=0, totalLifetime=0, failures=0, inUseForIO=0, inUseForUser=0, inUseForOther=0):
            _M_IceMX.Metrics.__init__(self, id, total, current, totalLifetime, failures)
            self.inUseForIO = inUseForIO
            self.inUseForUser = inUseForUser
            self.inUseForOther = inUseForOther

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceMX::Metrics', '::IceMX::ThreadMetrics')

        def ice_id(self, current=None):
            return '::IceMX::ThreadMetrics'

        def ice_staticId():
            return '::IceMX::ThreadMetrics'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_ThreadMetrics)

        __repr__ = __str__

    _M_IceMX.ThreadMetricsPrx = Ice.createTempClass()
    class ThreadMetricsPrx(_M_IceMX.MetricsPrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceMX.ThreadMetricsPrx.ice_checkedCast(proxy, '::IceMX::ThreadMetrics', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceMX.ThreadMetricsPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceMX::ThreadMetrics'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceMX._t_ThreadMetricsPrx = IcePy.defineProxy('::IceMX::ThreadMetrics', ThreadMetricsPrx)

    _M_IceMX._t_ThreadMetrics = IcePy.defineClass('::IceMX::ThreadMetrics', ThreadMetrics, -1, (), False, False, _M_IceMX._t_Metrics, (), (
        ('inUseForIO', (), IcePy._t_int, False, 0),
        ('inUseForUser', (), IcePy._t_int, False, 0),
        ('inUseForOther', (), IcePy._t_int, False, 0)
    ))
    ThreadMetrics._ice_type = _M_IceMX._t_ThreadMetrics

    _M_IceMX.ThreadMetrics = ThreadMetrics
    del ThreadMetrics

    _M_IceMX.ThreadMetricsPrx = ThreadMetricsPrx
    del ThreadMetricsPrx

if 'DispatchMetrics' not in _M_IceMX.__dict__:
    _M_IceMX.DispatchMetrics = Ice.createTempClass()
    class DispatchMetrics(_M_IceMX.Metrics):
        '''Provides information on servant dispatch.'''
        def __init__(self, id='', total=0, current=0, totalLifetime=0, failures=0, userException=0, size=0, replySize=0):
            _M_IceMX.Metrics.__init__(self, id, total, current, totalLifetime, failures)
            self.userException = userException
            self.size = size
            self.replySize = replySize

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceMX::DispatchMetrics', '::IceMX::Metrics')

        def ice_id(self, current=None):
            return '::IceMX::DispatchMetrics'

        def ice_staticId():
            return '::IceMX::DispatchMetrics'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_DispatchMetrics)

        __repr__ = __str__

    _M_IceMX.DispatchMetricsPrx = Ice.createTempClass()
    class DispatchMetricsPrx(_M_IceMX.MetricsPrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceMX.DispatchMetricsPrx.ice_checkedCast(proxy, '::IceMX::DispatchMetrics', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceMX.DispatchMetricsPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceMX::DispatchMetrics'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceMX._t_DispatchMetricsPrx = IcePy.defineProxy('::IceMX::DispatchMetrics', DispatchMetricsPrx)

    _M_IceMX._t_DispatchMetrics = IcePy.defineClass('::IceMX::DispatchMetrics', DispatchMetrics, -1, (), False, False, _M_IceMX._t_Metrics, (), (
        ('userException', (), IcePy._t_int, False, 0),
        ('size', (), IcePy._t_long, False, 0),
        ('replySize', (), IcePy._t_long, False, 0)
    ))
    DispatchMetrics._ice_type = _M_IceMX._t_DispatchMetrics

    _M_IceMX.DispatchMetrics = DispatchMetrics
    del DispatchMetrics

    _M_IceMX.DispatchMetricsPrx = DispatchMetricsPrx
    del DispatchMetricsPrx

if 'ChildInvocationMetrics' not in _M_IceMX.__dict__:
    _M_IceMX.ChildInvocationMetrics = Ice.createTempClass()
    class ChildInvocationMetrics(_M_IceMX.Metrics):
        '''Provides information on child invocations. A child invocation is
either remote (sent over an Ice connection) or collocated. An
invocation can have multiple child invocation if it is
retried. Child invocation metrics are embedded within 
InvocationMetrics.'''
        def __init__(self, id='', total=0, current=0, totalLifetime=0, failures=0, size=0, replySize=0):
            _M_IceMX.Metrics.__init__(self, id, total, current, totalLifetime, failures)
            self.size = size
            self.replySize = replySize

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceMX::ChildInvocationMetrics', '::IceMX::Metrics')

        def ice_id(self, current=None):
            return '::IceMX::ChildInvocationMetrics'

        def ice_staticId():
            return '::IceMX::ChildInvocationMetrics'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_ChildInvocationMetrics)

        __repr__ = __str__

    _M_IceMX.ChildInvocationMetricsPrx = Ice.createTempClass()
    class ChildInvocationMetricsPrx(_M_IceMX.MetricsPrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceMX.ChildInvocationMetricsPrx.ice_checkedCast(proxy, '::IceMX::ChildInvocationMetrics', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceMX.ChildInvocationMetricsPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceMX::ChildInvocationMetrics'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceMX._t_ChildInvocationMetricsPrx = IcePy.defineProxy('::IceMX::ChildInvocationMetrics', ChildInvocationMetricsPrx)

    _M_IceMX._t_ChildInvocationMetrics = IcePy.defineClass('::IceMX::ChildInvocationMetrics', ChildInvocationMetrics, -1, (), False, False, _M_IceMX._t_Metrics, (), (
        ('size', (), IcePy._t_long, False, 0),
        ('replySize', (), IcePy._t_long, False, 0)
    ))
    ChildInvocationMetrics._ice_type = _M_IceMX._t_ChildInvocationMetrics

    _M_IceMX.ChildInvocationMetrics = ChildInvocationMetrics
    del ChildInvocationMetrics

    _M_IceMX.ChildInvocationMetricsPrx = ChildInvocationMetricsPrx
    del ChildInvocationMetricsPrx

if 'CollocatedMetrics' not in _M_IceMX.__dict__:
    _M_IceMX.CollocatedMetrics = Ice.createTempClass()
    class CollocatedMetrics(_M_IceMX.ChildInvocationMetrics):
        '''Provides information on invocations that are collocated. Collocated
metrics are embedded within InvocationMetrics.'''
        def __init__(self, id='', total=0, current=0, totalLifetime=0, failures=0, size=0, replySize=0):
            _M_IceMX.ChildInvocationMetrics.__init__(self, id, total, current, totalLifetime, failures, size, replySize)

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceMX::ChildInvocationMetrics', '::IceMX::CollocatedMetrics', '::IceMX::Metrics')

        def ice_id(self, current=None):
            return '::IceMX::CollocatedMetrics'

        def ice_staticId():
            return '::IceMX::CollocatedMetrics'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_CollocatedMetrics)

        __repr__ = __str__

    _M_IceMX.CollocatedMetricsPrx = Ice.createTempClass()
    class CollocatedMetricsPrx(_M_IceMX.ChildInvocationMetricsPrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceMX.CollocatedMetricsPrx.ice_checkedCast(proxy, '::IceMX::CollocatedMetrics', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceMX.CollocatedMetricsPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceMX::CollocatedMetrics'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceMX._t_CollocatedMetricsPrx = IcePy.defineProxy('::IceMX::CollocatedMetrics', CollocatedMetricsPrx)

    _M_IceMX._t_CollocatedMetrics = IcePy.defineClass('::IceMX::CollocatedMetrics', CollocatedMetrics, -1, (), False, False, _M_IceMX._t_ChildInvocationMetrics, (), ())
    CollocatedMetrics._ice_type = _M_IceMX._t_CollocatedMetrics

    _M_IceMX.CollocatedMetrics = CollocatedMetrics
    del CollocatedMetrics

    _M_IceMX.CollocatedMetricsPrx = CollocatedMetricsPrx
    del CollocatedMetricsPrx

if 'RemoteMetrics' not in _M_IceMX.__dict__:
    _M_IceMX.RemoteMetrics = Ice.createTempClass()
    class RemoteMetrics(_M_IceMX.ChildInvocationMetrics):
        '''Provides information on invocations that are specifically sent over
Ice connections. Remote metrics are embedded within 
InvocationMetrics.'''
        def __init__(self, id='', total=0, current=0, totalLifetime=0, failures=0, size=0, replySize=0):
            _M_IceMX.ChildInvocationMetrics.__init__(self, id, total, current, totalLifetime, failures, size, replySize)

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceMX::ChildInvocationMetrics', '::IceMX::Metrics', '::IceMX::RemoteMetrics')

        def ice_id(self, current=None):
            return '::IceMX::RemoteMetrics'

        def ice_staticId():
            return '::IceMX::RemoteMetrics'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_RemoteMetrics)

        __repr__ = __str__

    _M_IceMX.RemoteMetricsPrx = Ice.createTempClass()
    class RemoteMetricsPrx(_M_IceMX.ChildInvocationMetricsPrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceMX.RemoteMetricsPrx.ice_checkedCast(proxy, '::IceMX::RemoteMetrics', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceMX.RemoteMetricsPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceMX::RemoteMetrics'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceMX._t_RemoteMetricsPrx = IcePy.defineProxy('::IceMX::RemoteMetrics', RemoteMetricsPrx)

    _M_IceMX._t_RemoteMetrics = IcePy.defineClass('::IceMX::RemoteMetrics', RemoteMetrics, -1, (), False, False, _M_IceMX._t_ChildInvocationMetrics, (), ())
    RemoteMetrics._ice_type = _M_IceMX._t_RemoteMetrics

    _M_IceMX.RemoteMetrics = RemoteMetrics
    del RemoteMetrics

    _M_IceMX.RemoteMetricsPrx = RemoteMetricsPrx
    del RemoteMetricsPrx

if 'InvocationMetrics' not in _M_IceMX.__dict__:
    _M_IceMX.InvocationMetrics = Ice.createTempClass()
    class InvocationMetrics(_M_IceMX.Metrics):
        '''Provide measurements for proxy invocations. Proxy invocations can
either be sent over the wire or be collocated.'''
        def __init__(self, id='', total=0, current=0, totalLifetime=0, failures=0, retry=0, userException=0, remotes=None, collocated=None):
            _M_IceMX.Metrics.__init__(self, id, total, current, totalLifetime, failures)
            self.retry = retry
            self.userException = userException
            self.remotes = remotes
            self.collocated = collocated

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceMX::InvocationMetrics', '::IceMX::Metrics')

        def ice_id(self, current=None):
            return '::IceMX::InvocationMetrics'

        def ice_staticId():
            return '::IceMX::InvocationMetrics'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_InvocationMetrics)

        __repr__ = __str__

    _M_IceMX.InvocationMetricsPrx = Ice.createTempClass()
    class InvocationMetricsPrx(_M_IceMX.MetricsPrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceMX.InvocationMetricsPrx.ice_checkedCast(proxy, '::IceMX::InvocationMetrics', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceMX.InvocationMetricsPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceMX::InvocationMetrics'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceMX._t_InvocationMetricsPrx = IcePy.defineProxy('::IceMX::InvocationMetrics', InvocationMetricsPrx)

    _M_IceMX._t_InvocationMetrics = IcePy.declareClass('::IceMX::InvocationMetrics')

    _M_IceMX._t_InvocationMetrics = IcePy.defineClass('::IceMX::InvocationMetrics', InvocationMetrics, -1, (), False, False, _M_IceMX._t_Metrics, (), (
        ('retry', (), IcePy._t_int, False, 0),
        ('userException', (), IcePy._t_int, False, 0),
        ('remotes', (), _M_IceMX._t_MetricsMap, False, 0),
        ('collocated', (), _M_IceMX._t_MetricsMap, False, 0)
    ))
    InvocationMetrics._ice_type = _M_IceMX._t_InvocationMetrics

    _M_IceMX.InvocationMetrics = InvocationMetrics
    del InvocationMetrics

    _M_IceMX.InvocationMetricsPrx = InvocationMetricsPrx
    del InvocationMetricsPrx

if 'ConnectionMetrics' not in _M_IceMX.__dict__:
    _M_IceMX.ConnectionMetrics = Ice.createTempClass()
    class ConnectionMetrics(_M_IceMX.Metrics):
        '''Provides information on the data sent and received over Ice
connections.'''
        def __init__(self, id='', total=0, current=0, totalLifetime=0, failures=0, receivedBytes=0, sentBytes=0):
            _M_IceMX.Metrics.__init__(self, id, total, current, totalLifetime, failures)
            self.receivedBytes = receivedBytes
            self.sentBytes = sentBytes

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceMX::ConnectionMetrics', '::IceMX::Metrics')

        def ice_id(self, current=None):
            return '::IceMX::ConnectionMetrics'

        def ice_staticId():
            return '::IceMX::ConnectionMetrics'
        ice_staticId = staticmethod(ice_staticId)

        def __str__(self):
            return IcePy.stringify(self, _M_IceMX._t_ConnectionMetrics)

        __repr__ = __str__

    _M_IceMX.ConnectionMetricsPrx = Ice.createTempClass()
    class ConnectionMetricsPrx(_M_IceMX.MetricsPrx):

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceMX.ConnectionMetricsPrx.ice_checkedCast(proxy, '::IceMX::ConnectionMetrics', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceMX.ConnectionMetricsPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceMX::ConnectionMetrics'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceMX._t_ConnectionMetricsPrx = IcePy.defineProxy('::IceMX::ConnectionMetrics', ConnectionMetricsPrx)

    _M_IceMX._t_ConnectionMetrics = IcePy.defineClass('::IceMX::ConnectionMetrics', ConnectionMetrics, -1, (), False, False, _M_IceMX._t_Metrics, (), (
        ('receivedBytes', (), IcePy._t_long, False, 0),
        ('sentBytes', (), IcePy._t_long, False, 0)
    ))
    ConnectionMetrics._ice_type = _M_IceMX._t_ConnectionMetrics

    _M_IceMX.ConnectionMetrics = ConnectionMetrics
    del ConnectionMetrics

    _M_IceMX.ConnectionMetricsPrx = ConnectionMetricsPrx
    del ConnectionMetricsPrx

# End of module IceMX

Ice.sliceChecksums["::IceMX::ChildInvocationMetrics"] = "e8d7639c4944abd2b46e1676712e3914"
Ice.sliceChecksums["::IceMX::CollocatedMetrics"] = "3249804089f8e0882d12276c8e6d4165"
Ice.sliceChecksums["::IceMX::ConnectionMetrics"] = "ff705e359a88ff9bc35ab28283c8e29"
Ice.sliceChecksums["::IceMX::DispatchMetrics"] = "e583ad5ced38253d9ff59929af294ba"
Ice.sliceChecksums["::IceMX::InvocationMetrics"] = "64216b477afc9431249a60ae5913f8"
Ice.sliceChecksums["::IceMX::Metrics"] = "94c8036c48f8749deb5f33a364ecee"
Ice.sliceChecksums["::IceMX::MetricsAdmin"] = "88697f8371c057b7177760281b33a5"
Ice.sliceChecksums["::IceMX::MetricsFailures"] = "19ecb6e915befa597421fa4c92a1ac"
Ice.sliceChecksums["::IceMX::MetricsFailuresSeq"] = "a62163545a1a5a54ade5d7d826aac8bd"
Ice.sliceChecksums["::IceMX::MetricsMap"] = "22667dd9415a83de99a17cf19f63975"
Ice.sliceChecksums["::IceMX::MetricsView"] = "c8c150b17e594dea2e3c7c2d4738b6"
Ice.sliceChecksums["::IceMX::RemoteMetrics"] = "1dda65bb856a2c2fcaf32ea2b40682f"
Ice.sliceChecksums["::IceMX::StringIntDict"] = "e6c7aa764386f6528aa38c89cbff5dd4"
Ice.sliceChecksums["::IceMX::ThreadMetrics"] = "54ca6eb235a9769ade47e8ae200ff18"
Ice.sliceChecksums["::IceMX::UnknownMetricsView"] = "18de0c2a8812deb6facfd521d84ba6"
