# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SubscriptionDefinition(Model):
    """The subscription definition used to create the subscription.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar subscription_id: The ID of the subscription.
    :vartype subscription_id: str
    :param subscription_display_name: The display name of the subscription.
    :type subscription_display_name: str
    :param offer_type: The offer type of the subscription. For example,
     MS-AZR-0017P (EnterpriseAgreement) and MS-AZR-0148P (EnterpriseAgreement
     devTest) are available.
    :type offer_type: str
    :param etag: The etag the subscription definition.
    :type etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'subscription_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'subscription_display_name': {'key': 'properties.subscriptionDisplayName', 'type': 'str'},
        'offer_type': {'key': 'properties.offerType', 'type': 'str'},
        'etag': {'key': 'properties.etag', 'type': 'str'},
    }

    def __init__(self, subscription_display_name=None, offer_type=None, etag=None):
        self.id = None
        self.name = None
        self.type = None
        self.subscription_id = None
        self.subscription_display_name = subscription_display_name
        self.offer_type = offer_type
        self.etag = etag
