
_packages = {
    "wxPython": {
        "latest_version": "3.0.1.1",
        "versions": {
            "3.0.1.1": {
                "urls": [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "innosetup",
                        "filename" : "wxPython3.0-win32-3.0.1.1-py27.exe",
                        "md5_digest" : "2488a3b3065530da67e7cebba8b32aac",
                        "url" : "http://downloads.sourceforge.net/wxpython/wxPython3.0-win32-3.0.1.1-py27.exe"
                    }
                ]
            }
        }
    },
    "greenlet": {
        "latest_version": "0.3.2",
        "versions": {
            "0.3.2": {
                "urls": [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "greenlet-0.3.2.win32-py2.7.exe",
                        "md5_digest" : "7e5cc074f6eede39a2b833ed772f1b41",
                        "url" : "https://pypi.python.org/packages/2.7/g/greenlet/greenlet-0.3.2.win32-py2.7.exe"
                    }
                ]
            }
        }
    },
    "cx-Oracle": {
        "latest_version": "5.1.3",
        "versions": {
            "5.1.3" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "cx_Oracle-5.1.3-11g.win32-py2.7.exe",
                        "md5_digest" : "c4618c499254ff9adf6db581b699e862",
                        "url" : "https://pypi.python.org/packages/2.7/c/cx_Oracle/cx_Oracle-5.1.3-11g.win32-py2.7.exe",
                        "uninstall_name" : "cx_Oracle",
                    }
                ]
            },
            "5.1.1" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "msi",
                        "filename" : "cx_Oracle-5.1.1-10g.win32-py2.7.msi",
                        "md5_digest" : "a7fd6ec9c66ca59f8c90af8e85a340a2",
                        "url" : "http://downloads.sourceforge.net/cx-oracle/cx_Oracle-5.1.1-10g.win32-py2.7.msi"
                    }
                ]
            }
        }
    },
    "lxml" : {
        "latest_version": "3.3.5",
        "versions": {
            "3.3.5" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "lxml-3.3.5.win32-py2.7.exe",
                        "md5_digest" : "2c10ce9cab81e0155a019fb6c0c3e2e9",
                        "url" : "https://pypi.python.org/packages/2.7/l/lxml/lxml-3.3.5.win32-py2.7.exe"
                    }
                ]
            },
            "2.3" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "lxml-2.3.win32-py2.7.exe",
                        "md5_digest" : "9c02aae672870701377750121f5a6f84",
                        "url" : "https://pypi.python.org/packages/2.7/l/lxml/lxml-2.3.win32-py2.7.exe"
                    }
                ]
            }
        }
    },
    "matplotlib": {
        "latest_version": "1.1.0",
        "versions": {
            "1.1.0": {
                "urls": [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "matplotlib-1.1.0.win32-py2.7.exe",
                        "md5_digest" : "38d7caaa4be612b5b9b3cccca5c89aaf",
                        "url" : "http://sourceforge.net/projects/matplotlib/files/matplotlib/matplotlib-1.1.0/matplotlib-1.1.0.win32-py2.7.exe/download"
                    }
                ]
            }
        }
    },
    "numpy": {
        "latest_version" : "1.6.1",
        "versions" : {
            "1.6.1" : {
                "urls": [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "numpy-1.6.1-win32-superpack-python2.7.exe",
                        "md5_digest" : "9642412608979d50f72413308f0e2444",
                        "url" : "http://sourceforge.net/projects/numpy/files/NumPy/1.6.1/numpy-1.6.1-win32-superpack-python2.7.exe/download"
                    }
                ]
            }
        }

    },
    "pycrypto": {
        "latest_version": "2.3",
        "versions": {
            "2.3" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "msi",
                        "filename" : "pycrypto-2.3.win32-py2.7.msi",
                        "md5_digest" : "c3a73b85fb69608966d6d64e00e85cfd",
                        "url" : "http://za-download.sjsoft.com/deps/pycrypto-2.3.win32-py2.7.msi"
                    }
                ]
            }
        }
    },
    "pyodbc" : {
        "latest_version": "2.1.12",
        "versions": {
            "2.1.12" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "pyodbc-2.1.12.win32-py2.7.exe",
                        "md5_digest" : "0f426440b165922b1012bb5777952d09",
                        "url" : "http://pyodbc.googlecode.com/files/pyodbc-2.1.12.win32-py2.7.exe"
                    }
                ]
            }
        }
    },
    "pytidylib": {
        "latest_version": "0.2.1",
        "versions": {
            "0.2.1" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "pytidylib-0.2.1.win32.exe",
                        "md5_digest" : "ce99b6a4b4ec24cf721a46a7aa84f890",
                        "url" : "http://download.sjsoft.com/opensource/pytidylib-0.2.1.win32.exe"
                    }
                ],
                "dlls" : [
                    {
                        "files": ["bin/tidy.dll"],
                        "destination": "../..",
                        "name": "HTMLTidy",
                        "version" : "060405",
                        "md5_digest" : "3d716c67a4e35c43042b464abbcbea47",
                        "url": "http://prdownloads.sourceforge.net/int64/tidy-060405-dll-fast.zip?download"
                    },
                ]
            }
        }
    },
    "python-ldap" : {
        "latest_version" : "2.4.9",
        "versions": {
            "2.4.9" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "python-ldap-2.4.9.win32-py2.7.exe",
                        "md5_digest" : "e8ba435ef2be486d70c16f56c226c60f",
                        "url" : "http://download.sjsoft.com/opensource/python-ldap-2.4.9.win32-py2.7.exe"
                    }
                ]
            }
        }
    },
    "pywin32" : {
        "latest_version" : "218",
        "versions": {
            "218" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "pywin32-218.win32-py2.7.exe",
                        "md5_digest" : "16e178ac18b49fa0d27ba0be90f460af",
                        "url" : "http://downloads.sourceforge.net/project/pywin32/pywin32/Build%20218/pywin32-218.win32-py2.7.exe?r=http%3A%2F%2Fsourceforge.net%2Fprojects%2Fpywin32%2Ffiles%2Fpywin32%2FBuild%2520218%2F&ts=1369749647&use_mirror=tenet"
                    }
                ]
            },
            "217" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "pywin32-217.win32-py2.7.exe",
                        "md5_digest" : "42202e223b9d21079f397b9116093ac6",
                        "url" : "http://downloads.sourceforge.net/project/pywin32/pywin32/Build%20217/pywin32-217.win32-py2.7.exe?r=http%3A%2F%2Fsourceforge.net%2Fprojects%2Fpywin32%2Ffiles%2Fpywin32%2FBuild%2520217%2F&ts=1404913990&use_mirror=tenet"
                    }
                ]
            }
        }
    },
    "pycairo" : {
        "latest_version" : "1.8.10",
        "versions": {
            "1.8.10" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "pycairo-1.8.10.win32-py2.7.exe",
                        "md5_digest" : "21b17e99f5a606a1e2008067fa5d82ab",
                        "url" : "http://ftp.acc.umu.se/pub/gnome/binaries/win32/pycairo/1.8/pycairo-1.8.10.win32-py2.7.exe"
                    }
                ],
                "dlls" : [
                    {
                        "files": ["bin/zlib1.dll"],
                        "destination": "cairo",
                        "name": "zlib",
                        "version" : "1.2.5",
                        "md5_digest" : "453d63205afcd648f5d6f9ed59f1cc82",
                        "url": "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/zlib_1.2.5-2_win32.zip"
                    },
                    {
                        "files": ["bin/libcairo-2.dll", "bin/libcairo-gobject-2.dll", "bin/libcairo-script-interpreter-2.dll"],
                        "destination": "cairo",
                        "name": "cairo",
                        "version" : "1.10.2",
                        "md5_digest" : "97c03ea128f9e3d4e32044a7520b74a9",
                        "url": "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/cairo_1.10.2-2_win32.zip"
                    },
                    {
                        "files": ["bin/libpng14-14.dll"],
                        "destination": "cairo",
                        "name": "libpng",
                        "version" : "1.4.3",
                        "md5_digest" : "44ee062641a204f65f0e96720fe57282",
                        "url": "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/libpng_1.4.3-1_win32.zip"
                    },
                    {
                        "files": ["bin/freetype6.dll"],
                        "destination": "cairo",
                        "name": "Freetype",
                        "version" : "2.4.2",
                        "md5_digest" : "3087ab1ad08716621fdb43e94f2b3bc1",
                        "url": "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/freetype_2.4.2-1_win32.zip"
                    },
                    {
                        "files": ["bin/libfontconfig-1.dll"],
                        "destination": "cairo",
                        "name": "Fontconfig",
                        "version" : "2.8.0",
                        "md5_digest" : "1ec9bc0123bc8b2d9e273272bfeb9795",
                        "url": "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/fontconfig_2.8.0-2_win32.zip"
                    },
                    {
                        "files": ["bin/libexpat-1.dll"],
                        "destination": "cairo",
                        "name": "expat",
                        "version" : "2.0.1",
                        "md5_digest" : "99da6bef2cfb051ecda4d70ff24ed149",
                        "url": "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/expat_2.0.1-1_win32.zip"
                    }
                ]
            }
        }
    },
    "psutil" : {
        "latest_version" : "0.7.0",
        "versions": {
            "0.7.0" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "psutil-0.7.0.win32-py2.7.exe",
                        "md5_digest" : "5696fbc8b2da9603b393f119166a28a1",
                        "url" : "https://psutil.googlecode.com/files/psutil-0.7.0.win32-py2.7.exe"
                    }
                ]
            },
            "0.6.1" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "psutil-0.6.1.win32-py2.7.exe",
                        "md5_digest" : "8d73121603c0aaf87e0056bd615755f5",
                        "url" : "http://psutil.googlecode.com/files/psutil-0.6.1.win32-py2.7.exe"
                    }
                ]
            },
            "0.4.1" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "psutil-0.4.1.win32-py2.7.exe",
                        "md5_digest" : "aae9ad6b466d3085bab177d3f3859cab",
                        "url" : "https://pypi.python.org/packages/2.7/p/psutil/psutil-0.4.1.win32-py2.7.exe"
                    }
                ]
            }
        }
    },
    "py2exe" : {
        "latest_version" : "0.6.9",
        "versions": {
            "0.6.9" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "py2exe-0.6.9.win32-py2.7.exe",
                        "md5_digest" : "b7899302e70596defe3b7e8c95cd15c1",
                        "url" : "http://downloads.sourceforge.net/project/py2exe/py2exe/0.6.9/py2exe-0.6.9.win32-py2.7.exe?r=http%3A%2F%2Fsourceforge.net%2Fprojects%2Fpy2exe%2Ffiles%2Fpy2exe%2F0.6.9%2F&ts=1373628132&use_mirror=tenet"
                    }
                ]
            }
        }
    },
    "SendKeys" : {
        "latest_version" : "0.3",
        "versions": {
            "0.3" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "SendKeys-0.3.win32-py2.7.exe",
                        "md5_digest" : "11336eb2347b20490ea233edecd448ed",
                        "url" : "http://web.dyfis.net/SendKeys-0.3.win32-py2.7.exe"
                    }
                ]
            }
        }
    },
    "Twisted" : {
        # For some reason the Twisted bdist_wininst installer for 11.1.0 isn't on PyPI
        "versions": {
            "11.1.0" : {
                "urls" : [
                    {
                        "python_version" : "2.7",
                        "packagetype" : "bdist_wininst",
                        "filename" : "Twisted-11.1.0.win32-py2.7.exe",
                        "md5_digest" : "3815ebb4b60eda48f0b3a240bdceac64",
                        "url" : "http://twistedmatrix.com/Releases/Twisted/11.1/Twisted-11.1.0.win32-py2.7.exe"
                    }
                ]
            }
        }
    },
}



def has_package_version(package_name, version):
    return package_name in _packages and version in _packages[package_name]["versions"]

def find_package_urls(package_name, version=None):
    if package_name in _packages:
        version = version or _packages[package_name]['latest_version']
        return _packages[package_name]["versions"][version]['urls'], _packages[package_name]["versions"][version].get('dlls', [])
    return None, None