/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerProvider;
import jdbm.helper.RecordManagerImpl;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;

public final class Provider
implements RecordManagerProvider {
    public RecordManager createRecordManager(String name, Properties options) throws IOException {
        boolean compress;
        RecordManagerImpl recman = new BaseRecordManager(name);
        String value = options.getProperty("jdbm.disableTransactions", "false");
        if (value.equalsIgnoreCase("TRUE")) {
            recman.disableTransactions();
        }
        if (compress = (value = options.getProperty("jdbm.compress", "false")).equalsIgnoreCase("TRUE")) {
            recman.setCompress(true);
        }
        String cacheType = options.getProperty("jdbm.cache.type", "auto");
        value = options.getProperty("jdbm.cache.size", "1000");
        int cacheSize = Integer.parseInt(value);
        if ("auto".equals(cacheType)) {
            try {
                cacheType = Runtime.getRuntime().maxMemory() <= 50000000L ? "mru" : "soft";
            }
            catch (Exception e) {
                cacheType = "mru";
            }
        }
        if ("mru".equals(cacheType)) {
            if (cacheSize > 0) {
                recman = new CacheRecordManager(recman, cacheSize, false);
            }
        } else if ("soft".equals(cacheType)) {
            recman = new CacheRecordManager(recman, cacheSize, true);
        } else if (!"none".equals(cacheType)) {
            throw new IllegalArgumentException("Unknown cache type: " + cacheType);
        }
        return recman;
    }
}

