/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.common;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.ow2.proactive.authentication.UserData;
import org.ow2.proactive.scheduler.common.SortSpecifierContainer;
import org.ow2.proactive.scheduler.common.job.JobIdDataAndError;
import org.ow2.proactive_grid_cloud_portal.common.dto.LoginForm;
import org.ow2.proactive_grid_cloud_portal.common.dto.PermissionForm;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.CompletedJobsCountData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.CompletedTasksCountData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.FilteredStatisticsData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.FilteredTopWorkflowData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.FilteredTopWorkflowsCumulatedCoreTimeData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.FilteredTopWorkflowsNumberOfNodesData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobLabelInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobUsageData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobValidationData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.RestMapPage;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.RestPage;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerStatusData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerUserData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskStateSummaryData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.UserJobData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.WorkflowDescription;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.WorkflowDurationData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.WorkflowUrlData;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.JobCreationRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.LogForwardingRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.NotConnectedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.PermissionRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.RestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SchedulerRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SubmissionClosedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.UnknownJobRestException;

@Path(value="/scheduler/")
public interface SchedulerRestInterface {
    public static final String defaultStatusFilter = "running;pending;finished";

    @GET
    @Path(value="url")
    @Produces(value={"text/plain"})
    public String getUrl();

    @GET
    @Path(value="domains")
    @Produces(value={"application/json"})
    public List<String> getDomains();

    @GET
    @Path(value="jobs")
    @Produces(value={"application/json"})
    public RestPage<String> jobs(@HeaderParam(value="sessionid") String var1, @QueryParam(value="index") @DefaultValue(value="-1") int var2, @QueryParam(value="limit") @DefaultValue(value="-1") int var3) throws RestException;

    @GET
    @Path(value="jobsinfo")
    @Produces(value={"application/json", "application/xml"})
    public RestPage<UserJobData> jobsInfo(@HeaderParam(value="sessionid") String var1, @QueryParam(value="index") @DefaultValue(value="-1") int var2, @QueryParam(value="limit") @DefaultValue(value="-1") int var3) throws RestException;

    @GET
    @Path(value="jobsinfolist")
    @Produces(value={"application/json", "application/xml"})
    public List<UserJobData> jobsInfoList(@HeaderParam(value="sessionid") String var1, @QueryParam(value="jobsid") List<String> var2) throws RestException;

    @POST
    @Path(value="jobsinfolist")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/xml"})
    public List<UserJobData> jobsInfoListPost(@HeaderParam(value="sessionid") String var1, List<String> var2) throws RestException;

    @GET
    @GZIP
    @Path(value="revisionjobsinfo")
    @Produces(value={"application/json", "application/xml"})
    public RestMapPage<Long, ArrayList<UserJobData>> revisionAndJobsInfo(@HeaderParam(value="sessionid") String var1, @QueryParam(value="index") @DefaultValue(value="-1") int var2, @QueryParam(value="limit") @DefaultValue(value="-1") int var3, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var4, @QueryParam(value="pending") @DefaultValue(value="true") boolean var5, @QueryParam(value="running") @DefaultValue(value="true") boolean var6, @QueryParam(value="finished") @DefaultValue(value="true") boolean var7, @QueryParam(value="withIssuesOnly") @DefaultValue(value="false") boolean var8, @QueryParam(value="childJobs") @DefaultValue(value="true") boolean var9, @QueryParam(value="jobName") @DefaultValue(value="") String var10, @QueryParam(value="projectName") @DefaultValue(value="") String var11, @QueryParam(value="bucketName") @DefaultValue(value="") String var12, @QueryParam(value="submissionMode") @DefaultValue(value="") String var13, @QueryParam(value="label") @DefaultValue(value="") String var14, @QueryParam(value="userName") @DefaultValue(value="") String var15, @QueryParam(value="tenant") String var16, @QueryParam(value="parentId") @DefaultValue(value="-1") Long var17, @QueryParam(value="sortParams") String var18, @QueryParam(value="status") @DefaultValue(value="") String var19, @QueryParam(value="submittedTimeGreater") @DefaultValue(value="0") long var20, @QueryParam(value="submittedTimeLessThan") @DefaultValue(value="0") long var22, @QueryParam(value="startAtTimeGreater") @DefaultValue(value="0") long var24, @QueryParam(value="startAtTimeLessThan") @DefaultValue(value="0") long var26) throws RestException;

    @GET
    @Path(value="state/revision")
    @Produces(value={"application/json", "application/xml"})
    public long schedulerStateRevision(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException;

    @GET
    @Path(value="jobs/{jobid}")
    @Produces(value={"application/json", "application/xml"})
    public JobStateData listJobs(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/result")
    @Produces(value={"application/json"})
    public JobResultData jobResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/resultmap")
    @Produces(value={"application/json"})
    public Map<String, String> jobResultMap(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/resultmap")
    @Produces(value={"application/json"})
    public Map<Long, Map<String, String>> jobResultMaps(@HeaderParam(value="sessionid") String var1, @QueryParam(value="jobsid") List<String> var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/info")
    @Produces(value={"application/json"})
    public JobInfoData jobInfo(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/result/value")
    @Produces(value={"application/json"})
    public Map<String, String> jobResultValue(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @DELETE
    @Path(value="jobs/{jobid}")
    @Produces(value={"application/json"})
    public boolean removeJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @DELETE
    @Path(value="jobs")
    @Produces(value={"application/json"})
    public boolean removeJobs(@HeaderParam(value="sessionid") String var1, @QueryParam(value="jobsid") List<String> var2, @QueryParam(value="olderThan") long var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/log/server")
    @Produces(value={"text/plain", "application/json"})
    public String jobServerLog(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/kill")
    @Produces(value={"application/json"})
    public boolean killJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @PUT
    @Path(value="jobs/kill")
    @Produces(value={"application/json"})
    public boolean killJobs(@HeaderParam(value="sessionid") String var1, @QueryParam(value="jobsid") List<String> var2) throws RestException;

    @GET
    @Path(value="jobs/{jobid}/tasks")
    @Produces(value={"application/json"})
    public RestPage<String> getTasksNames(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/paginated")
    @Produces(value={"application/json"})
    public RestPage<String> getTasksNamesPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="offset") @DefaultValue(value="0") int var3, @QueryParam(value="limit") @DefaultValue(value="-1") int var4) throws RestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}")
    @Produces(value={"application/json"})
    public RestPage<String> getJobTasksIdsByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/paginated")
    @Produces(value={"application/json"})
    public RestPage<String> getJobTasksIdsByTagPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3, @QueryParam(value="offset") @DefaultValue(value="0") int var4, @QueryParam(value="limit") @DefaultValue(value="-1") int var5) throws RestException;

    @GET
    @GZIP
    @Path(value="tasks")
    @Produces(value={"application/json"})
    public RestPage<String> getTaskIds(@HeaderParam(value="sessionid") String var1, @QueryParam(value="from") @DefaultValue(value="0") long var2, @QueryParam(value="to") @DefaultValue(value="0") long var4, @QueryParam(value="mytasks") @DefaultValue(value="false") boolean var6, @QueryParam(value="statusFilter") @DefaultValue(value="running;pending;finished") String var7, @QueryParam(value="offset") @DefaultValue(value="0") int var8, @QueryParam(value="limit") @DefaultValue(value="-1") int var9) throws RestException;

    @GET
    @GZIP
    @Path(value="tasks/tag/{tasktag}")
    @Produces(value={"application/json"})
    public RestPage<String> getTaskIdsByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="tasktag") String var2, @QueryParam(value="from") @DefaultValue(value="0") long var3, @QueryParam(value="to") @DefaultValue(value="0") long var5, @QueryParam(value="mytasks") @DefaultValue(value="false") boolean var7, @QueryParam(value="statusFilter") @DefaultValue(value="running;pending;finished") String var8, @QueryParam(value="offset") @DefaultValue(value="0") int var9, @QueryParam(value="limit") @DefaultValue(value="-1") int var10) throws RestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/tags")
    @Produces(value={"application/json"})
    public List<String> getJobTaskTags(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/tags/startsWith/{prefix}")
    @Produces(value={"application/json"})
    public List<String> getJobTaskTagsPrefix(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="prefix") String var3) throws RestException;

    @GET
    @Path(value="jobs/{jobid}/html")
    @Produces(value={"application/json;charset=utf-8"})
    public String getJobHtml(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws IOException, NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @Path(value="jobs/{jobid}/xml")
    @Produces(value={"application/xml", "application/json"})
    public String getJobContent(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStates(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/aggregated")
    @Produces(value={"application/json"})
    public RestPage<TaskStateSummaryData> getJobTaskStatesAggregated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @Path(value="jobs/{jobid}/taskstates/visualization")
    @Produces(value={"application/json"})
    public List<TaskStateData> getJobTaskStatesWithVisualization(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/paginated")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="offset") @DefaultValue(value="0") int var3, @QueryParam(value="limit") @DefaultValue(value="50") int var4) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/filtered/paginated")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesFilteredPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="offset") @DefaultValue(value="0") int var3, @QueryParam(value="limit") @DefaultValue(value="50") int var4, @QueryParam(value="statusFilter") @DefaultValue(value="") String var5) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/{tasktag}")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/{tasktag}/paginated")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesByTagPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3, @QueryParam(value="offset") @DefaultValue(value="0") int var4, @QueryParam(value="limit") @DefaultValue(value="50") int var5) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/{tasktag}/{statusFilter}/paginated")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesByTagByStatusPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="offset") @DefaultValue(value="0") int var3, @QueryParam(value="limit") @DefaultValue(value="50") int var4, @PathParam(value="tasktag") String var5, @PathParam(value="statusFilter") PathSegment var6) throws RestException;

    @GET
    @GZIP
    @Path(value="taskstates")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getTaskStates(@HeaderParam(value="sessionid") String var1, @QueryParam(value="from") @DefaultValue(value="0") long var2, @QueryParam(value="to") @DefaultValue(value="0") long var4, @QueryParam(value="mytasks") @DefaultValue(value="false") boolean var6, @QueryParam(value="statusFilter") @DefaultValue(value="running;pending;finished") String var7, @QueryParam(value="offset") @DefaultValue(value="0") int var8, @QueryParam(value="limit") @DefaultValue(value="-1") int var9, @QueryParam(value="sortparameters") SortSpecifierContainer var10) throws RestException;

    @GET
    @GZIP
    @Path(value="taskstates/tag/{tasktag}")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getTaskStatesByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="tasktag") String var2, @QueryParam(value="from") @DefaultValue(value="0") long var3, @QueryParam(value="to") @DefaultValue(value="0") long var5, @QueryParam(value="mytasks") @DefaultValue(value="false") boolean var7, @QueryParam(value="statusFilter") @DefaultValue(value="running;pending;finished") String var8, @QueryParam(value="offset") @DefaultValue(value="0") int var9, @QueryParam(value="limit") @DefaultValue(value="-1") int var10, @QueryParam(value="sortparameters") SortSpecifierContainer var11) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/log/full")
    @Produces(value={"text/plain", "application/json"})
    public Response jobFullLogs(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="sessionid") String var3, @QueryParam(value="destination") String var4) throws RestException, IOException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/result/log/all")
    @Produces(value={"text/plain", "application/json"})
    public String jobLogs(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/{taskname}")
    @Produces(value={"application/json"})
    public TaskStateData jobTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/value")
    @Produces(value={"text/plain", "application/json"})
    public String valueOfTaskResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/value")
    @Produces(value={"application/json"})
    public Map<String, String> valueOfTaskResultByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/metadata")
    @Produces(value={"application/json"})
    public Map<String, String> metadataOfTaskResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/metadata")
    @Produces(value={"application/json"})
    public Map<String, Map<String, String>> metadataOfTaskResultByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/results/precious/metadata")
    @Produces(value={"application/json"})
    public List<String> getPreciousTaskName(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/result/precious/metadata")
    @Produces(value={"application/json"})
    public Map<Long, List<String>> getPreciousTaskNames(@HeaderParam(value="sessionid") String var1, @QueryParam(value="jobsid") List<String> var2) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/serializedvalue")
    @Produces(value={"*/*"})
    public byte[] serializedValueOfTaskResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/download")
    @Produces(value={"*/*"})
    public Response downloadTaskResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3, @QueryParam(value="destination") String var4, @QueryParam(value="sessionToken") String var5) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/serializedvalue")
    @Produces(value={"application/json"})
    public Map<String, byte[]> serializedValueOfTaskResultByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result")
    @Produces(value={"application/json"})
    public TaskResultData taskResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result")
    @Produces(value={"application/json"})
    public List<TaskResultData> taskResultByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/log/all")
    @Produces(value={"text/plain", "application/json"})
    public String taskLog(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/log/all")
    @Produces(value={"text/plain", "application/json"})
    public String taskLogByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/log/err")
    @Produces(value={"text/plain", "application/json"})
    public String taskLogErr(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/log/err")
    @Produces(value={"text/plain", "application/json"})
    public String taskLogErrByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/log/out")
    @Produces(value={"text/plain", "application/json"})
    public String taskLogout(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/log/out")
    @Produces(value={"text/plain", "application/json"})
    public String taskLogoutByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/log/full")
    @Produces(value={"text/plain", "application/json"})
    public InputStream taskFullLogs(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3, @QueryParam(value="sessionid") String var4) throws RestException, IOException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/log/server")
    @Produces(value={"text/plain", "application/json"})
    public String taskServerLog(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/log/server")
    @Produces(value={"text/plain", "application/json"})
    public String taskServerLogByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/pause")
    @Produces(value={"application/json"})
    public boolean pauseJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/restartAllInErrorTasks")
    @Produces(value={"application/json"})
    public boolean restartAllInErrorTasks(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/resume")
    @Produces(value={"application/json"})
    public boolean resumeJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws RestException;

    @POST
    @Path(value="submitflat")
    @Produces(value={"application/json"})
    public JobIdData submitFlat(@HeaderParam(value="sessionid") String var1, @FormParam(value="commandFileContent") String var2, @FormParam(value="jobName") String var3, @FormParam(value="selectionScriptContent") String var4, @FormParam(value="selectionScriptExtension") String var5) throws IOException, RestException;

    @POST
    @Path(value="{path:submit}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public JobIdData submit(@HeaderParam(value="sessionid") String var1, @PathParam(value="path") PathSegment var2, MultipartFormDataInput var3, @Context UriInfo var4) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @GET
    @Path(value="jobs/{jobid}/{path:resubmit}")
    @Produces(value={"application/json"})
    public JobIdData reSubmit(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="path") PathSegment var3, @Context UriInfo var4) throws IOException, RestException;

    @POST
    @Path(value="jobs/{jobid}/{path:resubmit/body}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JobIdData reSubmit(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="path") PathSegment var3, Map<String, String> var4, @Context UriInfo var5) throws IOException, RestException;

    @POST
    @Path(value="jobs/{jobid}/{path:validate/body}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JobValidationData validate(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="path") PathSegment var3, Map<String, String> var4, @Context UriInfo var5) throws IOException, RestException;

    @POST
    @Path(value="jobs/{jobid}/{path:validate}")
    @Produces(value={"application/json"})
    public JobValidationData validate(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="path") PathSegment var3, @Context UriInfo var4) throws IOException, RestException;

    @GET
    @Path(value="jobs/{jobid}/description")
    @Produces(value={"application/json"})
    public WorkflowDescription getDescription(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws IOException, RestException;

    @POST
    @Path(value="jobs/resubmit")
    @Produces(value={"application/json"})
    public List<JobIdData> reSubmitAll(@HeaderParam(value="sessionid") String var1, @QueryParam(value="jobsid") List<String> var2) throws RestException;

    @Consumes(value={"application/json"})
    @POST
    @Path(value="{path:plannings}")
    @Produces(value={"application/json"})
    public String submitPlannings(@HeaderParam(value="sessionid") String var1, @PathParam(value="path") PathSegment var2, Map<String, String> var3) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @POST
    @Path(value="{path:jobs}")
    @Produces(value={"application/json"})
    public JobIdData submitFromUrl(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="link") String var2, @PathParam(value="path") PathSegment var3, @Context UriInfo var4) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @POST
    @Path(value="{path:jobs}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public JobIdData submitFromUrl(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="link") String var2, @PathParam(value="path") PathSegment var3, MultipartFormDataInput var4, @Context UriInfo var5) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @POST
    @Path(value="{path:jobs}/body")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JobIdData submitFromUrl(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="link") String var2, @PathParam(value="path") PathSegment var3, Map<String, String> var4, @Context UriInfo var5) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @POST
    @Path(value="{path:jobs}/body/sync")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JobResultData submitFromUrlSync(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="link") String var2, @HeaderParam(value="timeout") Long var3, @PathParam(value="path") PathSegment var4, Map<String, String> var5, @Context UriInfo var6) throws RestException, IOException;

    @POST
    @Path(value="{path:jobs}/body/multi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<JobIdDataAndError> multipleSubmitFromUrls(@HeaderParam(value="sessionid") String var1, List<WorkflowUrlData> var2) throws NotConnectedRestException;

    @POST
    @Path(value="dataspace/{spaceName:[a-zA-Z][a-zA-Z_0-9]*}{filePath:.*}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public boolean pushFile(@HeaderParam(value="sessionid") String var1, @PathParam(value="spaceName") String var2, @PathParam(value="filePath") String var3, MultipartFormDataInput var4) throws IOException, NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="dataspace/{spaceName:[a-zA-Z][a-zA-Z_0-9]*}{filePath:.*}")
    @Produces(value={"application/octet-stream", "application/json"})
    public InputStream pullFile(@HeaderParam(value="sessionid") String var1, @PathParam(value="spaceName") String var2, @PathParam(value="filePath") String var3) throws IOException, NotConnectedRestException, PermissionRestException;

    @DELETE
    @Path(value="dataspace/{spaceName:[a-zA-Z][a-zA-Z_0-9]*}{filePath:.*}")
    @Produces(value={"application/json"})
    public boolean deleteFile(@HeaderParam(value="sessionid") String var1, @PathParam(value="spaceName") String var2, @PathParam(value="filePath") String var3) throws IOException, NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="disconnect")
    @Produces(value={"application/json"})
    public void disconnect(@HeaderParam(value="sessionid") String var1) throws RestException;

    @PUT
    @Path(value="pause")
    @Produces(value={"application/json"})
    public boolean pauseScheduler(@HeaderParam(value="sessionid") String var1) throws RestException;

    @PUT
    @Path(value="stop")
    @Produces(value={"application/json"})
    public boolean stopScheduler(@HeaderParam(value="sessionid") String var1) throws RestException;

    @PUT
    @Path(value="resume")
    @Produces(value={"application/json"})
    public boolean resumeScheduler(@HeaderParam(value="sessionid") String var1) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/priority/byname/{name}")
    @Produces(value={"application/json"})
    public void schedulerChangeJobPriorityByName(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="name") String var3) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/priority/byvalue/{value}")
    @Produces(value={"application/json"})
    public void schedulerChangeJobPriorityByValue(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="value") String var3) throws RestException;

    @PUT
    @Path(value="freeze")
    @Produces(value={"application/json"})
    public boolean freezeScheduler(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="status")
    @Produces(value={"application/json"})
    public SchedulerStatusData getSchedulerStatus(@HeaderParam(value="sessionid") String var1) throws RestException;

    @PUT
    @Path(value="start")
    @Produces(value={"application/json"})
    public boolean startScheduler(@HeaderParam(value="sessionid") String var1) throws RestException;

    @PUT
    @Path(value="kill")
    @Produces(value={"application/json"})
    public boolean killScheduler(@HeaderParam(value="sessionid") String var1) throws RestException;

    @PUT
    @Path(value="shutdown")
    @Produces(value={"application/json"})
    public boolean shutdownScheduler(@HeaderParam(value="sessionid") String var1) throws RestException;

    @POST
    @Path(value="linkrm")
    @Produces(value={"application/json"})
    public boolean linkRm(@HeaderParam(value="sessionid") String var1, @FormParam(value="rmurl") String var2) throws RestException;

    @GET
    @Path(value="isconnected")
    @Produces(value={"application/json"})
    public boolean isConnected(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="login")
    @Produces(value={"text/plain", "application/json"})
    public String login(@FormParam(value="username") String var1, @FormParam(value="password") String var2) throws LoginException, SchedulerRestException;

    @PUT
    @Path(value="session")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain", "application/json"})
    public String loginOrRenewSession(@HeaderParam(value="sessionid") String var1, @FormParam(value="username") String var2, @FormParam(value="password") String var3) throws SchedulerRestException, LoginException, NotConnectedRestException;

    @PUT
    @Path(value="session")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain", "application/json"})
    public String loginOrRenewSession(@HeaderParam(value="sessionid") String var1, @MultipartForm LoginForm var2) throws KeyException, SchedulerRestException, LoginException, NotConnectedRestException;

    @GET
    @Path(value="logins/sessionid/{sessionId}")
    @Produces(value={"text/plain", "application/json"})
    public String getLoginFromSessionId(@PathParam(value="sessionId") String var1);

    @GET
    @Path(value="logins/sessionid/{sessionId}/userdata")
    @Produces(value={"application/json"})
    public UserData getUserDataFromSessionId(@PathParam(value="sessionId") String var1);

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="login")
    @Produces(value={"text/plain", "application/json"})
    public String loginWithCredential(@MultipartForm LoginForm var1) throws KeyException, LoginException, SchedulerRestException;

    @GET
    @GZIP
    @Path(value="users")
    @Produces(value={"application/json"})
    public List<SchedulerUserData> getUsers(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="userspace")
    @Produces(value={"application/json"})
    public List<String> userspaceURIs(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="globalspace")
    @Produces(value={"application/json"})
    public List<String> globalspaceURIs(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @GZIP
    @Path(value="userswithjobs")
    @Produces(value={"application/json"})
    public List<SchedulerUserData> getUsersWithJobs(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="stats")
    @Produces(value={"application/json"})
    public Map<String, String> getStatistics(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="stathistory")
    @Produces(value={"application/json"})
    public String getStatHistory(@HeaderParam(value="sessionid") String var1, @QueryParam(value="function") String var2) throws NotConnectedRestException;

    @GET
    @Path(value="stats/myaccount")
    @Produces(value={"application/json"})
    public Map<String, String> getStatisticsOnMyAccount(@HeaderParam(value="sessionid") String var1) throws RestException;

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="createcredential")
    @Produces(value={"*/*"})
    public byte[] getCreateCredential(@MultipartForm LoginForm var1) throws LoginException, SchedulerRestException;

    @GET
    @Path(value="usage/myaccount")
    @Produces(value={"application/json"})
    public List<JobUsageData> getUsageOnMyAccount(@HeaderParam(value="sessionid") String var1, @QueryParam(value="startdate") Date var2, @QueryParam(value="enddate") Date var3) throws RestException;

    @GET
    @Path(value="stats/filters")
    @Produces(value={"application/json"})
    public FilteredStatisticsData getFilteredStatistics(@HeaderParam(value="sessionid") String var1, @QueryParam(value="startdate") @DefaultValue(value="0") long var2, @QueryParam(value="enddate") @DefaultValue(value="0") long var4, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var6, @QueryParam(value="workflowName") @DefaultValue(value="null") String var7, @QueryParam(value="bucketName") @DefaultValue(value="null") String var8) throws RestException;

    @GET
    @Path(value="stats/topWorkflowsWithIssues")
    @Produces(value={"application/json"})
    public List<FilteredTopWorkflowData> getTopWorkflowsWithIssues(@HeaderParam(value="sessionid") String var1, @QueryParam(value="numberOfWorkflows") int var2, @QueryParam(value="startdate") @DefaultValue(value="0") long var3, @QueryParam(value="enddate") @DefaultValue(value="0") long var5, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var7, @QueryParam(value="workflowName") @DefaultValue(value="null") String var8, @QueryParam(value="bucketName") @DefaultValue(value="null") String var9) throws RestException;

    @GET
    @Path(value="stats/topWorkflowsCumulatedCoreTime")
    @Produces(value={"application/json"})
    public List<FilteredTopWorkflowsCumulatedCoreTimeData> getTopWorkflowsCumulatedCoreTime(@HeaderParam(value="sessionid") String var1, @QueryParam(value="numberOfWorkflows") int var2, @QueryParam(value="startdate") @DefaultValue(value="0") long var3, @QueryParam(value="enddate") @DefaultValue(value="0") long var5, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var7, @QueryParam(value="workflowName") @DefaultValue(value="null") String var8, @QueryParam(value="bucketName") @DefaultValue(value="null") String var9) throws RestException;

    @GET
    @Path(value="stats/topWorkflowsNumberOfNodes")
    @Produces(value={"application/json"})
    public List<FilteredTopWorkflowsNumberOfNodesData> getTopWorkflowsNumberOfNodes(@HeaderParam(value="sessionid") String var1, @QueryParam(value="numberOfWorkflows") int var2, @QueryParam(value="startdate") @DefaultValue(value="0") long var3, @QueryParam(value="enddate") @DefaultValue(value="0") long var5, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var7, @QueryParam(value="workflowName") @DefaultValue(value="null") String var8, @QueryParam(value="bucketName") @DefaultValue(value="null") String var9, @QueryParam(value="inParallel") @DefaultValue(value="false") boolean var10) throws RestException;

    @GET
    @Path(value="stats/topExecutionTimeWorkflows")
    @Produces(value={"application/json"})
    public List<WorkflowDurationData> getTopExecutionTimeWorkflows(@HeaderParam(value="sessionid") String var1, @QueryParam(value="numberOfWorkflows") int var2, @QueryParam(value="startdate") @DefaultValue(value="0") long var3, @QueryParam(value="enddate") @DefaultValue(value="0") long var5, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var7, @QueryParam(value="workflowName") @DefaultValue(value="null") String var8, @QueryParam(value="bucketName") @DefaultValue(value="null") String var9) throws RestException;

    @GET
    @Path(value="stats/topPendingTimeWorkflows")
    @Produces(value={"application/json"})
    public List<WorkflowDurationData> getTopPendingTimeWorkflows(@HeaderParam(value="sessionid") String var1, @QueryParam(value="numberOfWorkflows") int var2, @QueryParam(value="startdate") @DefaultValue(value="0") long var3, @QueryParam(value="enddate") @DefaultValue(value="0") long var5, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var7, @QueryParam(value="workflowName") @DefaultValue(value="null") String var8, @QueryParam(value="bucketName") @DefaultValue(value="null") String var9) throws RestException;

    @GET
    @Path(value="stats/submittedFromCount")
    @Produces(value={"application/json"})
    public Map<String, Integer> getSubmissionModeCount(@HeaderParam(value="sessionid") String var1, @QueryParam(value="startdate") @DefaultValue(value="0") long var2, @QueryParam(value="enddate") @DefaultValue(value="0") long var4, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var6, @QueryParam(value="workflowName") @DefaultValue(value="null") String var7, @QueryParam(value="bucketName") @DefaultValue(value="null") String var8) throws RestException;

    @GET
    @Path(value="stats/completedJobs")
    @Produces(value={"application/json"})
    public CompletedJobsCountData getCompletedJobs(@HeaderParam(value="sessionid") String var1, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var2, @QueryParam(value="workflowName") @DefaultValue(value="null") String var3, @QueryParam(value="bucketName") @DefaultValue(value="null") String var4, @QueryParam(value="startdate") @DefaultValue(value="0") long var5, @QueryParam(value="enddate") @DefaultValue(value="-1") long var7, @QueryParam(value="numberOfIntervals") @DefaultValue(value="1") int var9) throws RestException;

    @GET
    @Path(value="stats/completedTasks")
    @Produces(value={"application/json"})
    public CompletedTasksCountData getCompletedTasks(@HeaderParam(value="sessionid") String var1, @QueryParam(value="myTasks") @DefaultValue(value="false") boolean var2, @QueryParam(value="taskName") @DefaultValue(value="null") String var3, @QueryParam(value="startdate") @DefaultValue(value="0") long var4, @QueryParam(value="enddate") @DefaultValue(value="-1") long var6, @QueryParam(value="numberOfIntervals") @DefaultValue(value="1") int var8) throws RestException;

    @GET
    @Path(value="submissionModeValues")
    @Produces(value={"application/json"})
    public Set<String> getSubmissionModeValues(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="usage/account")
    @Produces(value={"application/json"})
    public List<JobUsageData> getUsageOnAccount(@HeaderParam(value="sessionid") String var1, @QueryParam(value="user") String var2, @QueryParam(value="startdate") Date var3, @QueryParam(value="enddate") Date var4) throws RestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/livelog")
    @Produces(value={"text/plain", "application/json"})
    public String getLiveLogJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="allLogs") @DefaultValue(value="false") boolean var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException, LogForwardingRestException, IOException;

    @GET
    @Path(value="jobs/{jobid}/livelog/available")
    @Produces(value={"application/json"})
    public int getLiveLogJobAvailable(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException;

    @DELETE
    @Path(value="jobs/{jobid}/livelog")
    @Produces(value={"application/json"})
    public boolean deleteLiveLogJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/visu")
    @Produces(value={"application/json"})
    public void enableRemoteVisualization(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3, @QueryParam(value="connectionString") String var4) throws RestException;

    @POST
    @Path(value="jobs/{jobid}/services")
    @Produces(value={"application/json"})
    public void registerService(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="serviceInstanceid") int var3, @QueryParam(value="enableActions") boolean var4) throws RestException;

    @DELETE
    @Path(value="jobs/{jobid}/services")
    @Produces(value={"application/json"})
    public void detachService(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="serviceid") int var3) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/restart")
    @Produces(value={"application/json"})
    public boolean restartTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/finishInErrorTask")
    @Produces(value={"application/json"})
    public boolean finishInErrorTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/restartInErrorTask")
    @Produces(value={"application/json"})
    public boolean restartInErrorTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/preempt")
    @Produces(value={"application/json"})
    public boolean preemptTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/kill")
    @Produces(value={"application/json"})
    public boolean killTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws RestException;

    @POST
    @Path(value="{path:validate}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public JobValidationData validate(@HeaderParam(value="sessionid") String var1, @PathParam(value="path") PathSegment var2, MultipartFormDataInput var3) throws NotConnectedRestException;

    @POST
    @Path(value="{path:validateurl}/body")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public JobValidationData validateFromUrl(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="link") String var2, Map<String, String> var3, @PathParam(value="path") PathSegment var4) throws NotConnectedRestException;

    @POST
    @Path(value="{path:validateurl}")
    @Produces(value={"application/json"})
    public JobValidationData validateFromUrl(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="link") String var2, @PathParam(value="path") PathSegment var3) throws NotConnectedRestException;

    @POST
    @Path(value="{path:validateurl}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public JobValidationData validateFromUrl(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="link") String var2, @PathParam(value="path") PathSegment var3, MultipartFormDataInput var4) throws NotConnectedRestException;

    @POST
    @Path(value="/credentials/")
    @Produces(value={"application/json"})
    public void putThirdPartyCredential(@HeaderParam(value="sessionid") String var1, @FormParam(value="key") String var2, @FormParam(value="value") String var3) throws RestException;

    @DELETE
    @Path(value="/credentials/")
    @Produces(value={"application/json"})
    public void removeThirdPartyCredential(@HeaderParam(value="sessionid") String var1, @QueryParam(value="key") String var2) throws RestException;

    @GET
    @Path(value="/credentials/")
    @Produces(value={"application/json"})
    public Set<String> thirdPartyCredentialsKeySet(@HeaderParam(value="sessionid") String var1) throws RestException;

    @PUT
    @Path(value="jobs/{jobid}/startat/{startAt}")
    @Produces(value={"application/json"})
    public boolean changeStartAt(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="startAt") String var3) throws RestException;

    @PUT
    @Path(value="jobs/startat/{startAt}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public boolean changeStartAtMultiple(@HeaderParam(value="sessionid") String var1, @PathParam(value="startAt") String var2, List<String> var3) throws RestException;

    @GET
    @Path(value="configuration/portal")
    @Produces(value={"application/json"})
    public Map<Object, Object> getPortalConfiguration(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="properties")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchedulerPropertiesFromSessionId(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="/permission/{method}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public boolean checkPermissionMethod(@HeaderParam(value="sessionid") String var1, @PathParam(value="method") String var2) throws RestException;

    @GET
    @Path(value="job/{jobid}/permission/{method}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public boolean checkJobPermissionMethod(@HeaderParam(value="sessionid") String var1, @PathParam(value="method") String var2, @PathParam(value="jobid") String var3) throws RestException;

    @POST
    @Path(value="jobs/permission/{method}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<String> checkJobsPermissionMethod(@HeaderParam(value="sessionid") String var1, @PathParam(value="method") String var2, List<String> var3) throws RestException;

    @POST
    @Path(value="job/{jobid}/signals")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Set<String> addJobSignal(@HeaderParam(value="sessionid") String var1, @QueryParam(value="signal") String var2, @PathParam(value="jobid") String var3) throws RestException;

    @POST
    @Path(value="job/{jobid}/signals")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Set<String> addJobSignalWithVariables(@HeaderParam(value="sessionid") String var1, @QueryParam(value="signal") String var2, @PathParam(value="jobid") String var3, Map<String, String> var4) throws RestException;

    @POST
    @Path(value="job/{jobid}/signals/validate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JobValidationData validateJobSignal(@HeaderParam(value="sessionid") String var1, @QueryParam(value="signal") String var2, @PathParam(value="jobid") String var3, Map<String, String> var4) throws RestException;

    @POST
    @Path(value="jobs/permission/methods")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, Map<String, Boolean>> checkJobsPermissionMethods(@HeaderParam(value="sessionid") String var1, PermissionForm var2) throws RestException;

    @POST
    @Path(value="jobs/{jobid}/externalendpointurl")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public void addExternalEndpointUrl(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @FormParam(value="endpointName") String var3, @FormParam(value="externalEndpointUrl") String var4, @FormParam(value="endpointIconUri") String var5) throws RestException;

    @DELETE
    @Path(value="jobs/{jobid}/externalendpointurl")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void removeExternalEndpointUrl(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, String var3) throws RestException;

    @PUT
    @Path(value="labels/jobs/setlabel")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void setLabelOnJobs(@HeaderParam(value="sessionid") String var1, @QueryParam(value="labelId") String var2, List<String> var3) throws RestException;

    @PUT
    @Path(value="labels/jobs/removelabel")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void removeJobLabels(@HeaderParam(value="sessionid") String var1, List<String> var2) throws RestException;

    @GET
    @Path(value="labels")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<JobLabelInfoData> getLabels(@HeaderParam(value="sessionid") String var1) throws RestException;

    @POST
    @Path(value="labels")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<JobLabelInfoData> createLabels(@HeaderParam(value="sessionid") String var1, List<String> var2) throws RestException;

    @POST
    @Path(value="labels/set")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<JobLabelInfoData> setLabels(@HeaderParam(value="sessionid") String var1, List<String> var2) throws RestException;

    @PUT
    @Path(value="labels/{labelId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JobLabelInfoData updateLabel(@HeaderParam(value="sessionid") String var1, @PathParam(value="labelId") String var2, @QueryParam(value="newLabel") String var3) throws RestException;

    @DELETE
    @Path(value="labels/{labelId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void deleteLabel(@HeaderParam(value="sessionid") String var1, @PathParam(value="labelId") String var2) throws RestException;
}

