# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CheckNameAvailabilityParameter(Model):
    """Parameter supplied to check Namespace name availability operation .

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name to check the namespace name availability
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityParameter, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CheckNameAvailabilityResult(Model):
    """The Result of the CheckNameAvailability operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name_available: Value indicating Namespace is availability, true if
     the Namespace is available; otherwise, false.
    :type name_available: bool
    :param reason: The reason for unavailability of a Namespace. Possible
     values include: 'None', 'InvalidName', 'SubscriptionIsDisabled',
     'NameInUse', 'NameInLockdown', 'TooManyNamespaceInCurrentSubscription'
    :type reason: str or
     ~azure.mgmt.eventhub.v2015_08_01.models.UnavailableReason
    :ivar message: The detailed info regarding the reason associated with the
     Namespace.
    :vartype message: str
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'UnavailableReason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ConsumerGroupCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Consumer Group operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Location of the resource.
    :type location: str
    :param type: ARM type of the Namespace.
    :type type: str
    :param name: Name of the consumer group.
    :type name: str
    :ivar created_at: Exact time the message was created.
    :vartype created_at: datetime
    :ivar event_hub_path: The path of the Event Hub.
    :vartype event_hub_path: str
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    :param user_metadata: The user metadata.
    :type user_metadata: str
    """

    _validation = {
        'location': {'required': True},
        'created_at': {'readonly': True},
        'event_hub_path': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'event_hub_path': {'key': 'properties.eventHubPath', 'type': 'str'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'user_metadata': {'key': 'properties.userMetadata', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ConsumerGroupCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)
        self.created_at = None
        self.event_hub_path = None
        self.updated_at = None
        self.user_metadata = kwargs.get('user_metadata', None)


class Resource(Model):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.location = kwargs.get('location', None)
        self.type = None


class ConsumerGroupResource(Resource):
    """Single item in List or Get Consumer group operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :ivar created_at: Exact time the message was created.
    :vartype created_at: datetime
    :ivar event_hub_path: The path of the Event Hub.
    :vartype event_hub_path: str
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    :param user_metadata: The user metadata.
    :type user_metadata: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'event_hub_path': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'event_hub_path': {'key': 'properties.eventHubPath', 'type': 'str'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'user_metadata': {'key': 'properties.userMetadata', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ConsumerGroupResource, self).__init__(**kwargs)
        self.created_at = None
        self.event_hub_path = None
        self.updated_at = None
        self.user_metadata = kwargs.get('user_metadata', None)


class EventHubCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Event Hub operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Location of the resource.
    :type location: str
    :param type: ARM type of the Namespace.
    :type type: str
    :param name: Name of the Event Hub.
    :type name: str
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: datetime
    :param message_retention_in_days: Number of days to retain the events for
     this Event Hub.
    :type message_retention_in_days: long
    :param partition_count: Number of partitions created for the Event Hub.
    :type partition_count: long
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :param status: Enumerates the possible values for the status of the Event
     Hub. Possible values include: 'Active', 'Disabled', 'Restoring',
     'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming',
     'Unknown'
    :type status: str or ~azure.mgmt.eventhub.v2015_08_01.models.EntityStatus
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    """

    _validation = {
        'location': {'required': True},
        'created_at': {'readonly': True},
        'partition_ids': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'properties.messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'properties.partitionCount', 'type': 'long'},
        'partition_ids': {'key': 'properties.partitionIds', 'type': '[str]'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(EventHubCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)
        self.created_at = None
        self.message_retention_in_days = kwargs.get('message_retention_in_days', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.partition_ids = None
        self.status = kwargs.get('status', None)
        self.updated_at = None


class EventHubResource(Resource):
    """Single item in List or Get Event Hub operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: datetime
    :param message_retention_in_days: Number of days to retain the events for
     this Event Hub.
    :type message_retention_in_days: long
    :param partition_count: Number of partitions created for the Event Hub.
    :type partition_count: long
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :param status: Enumerates the possible values for the status of the Event
     Hub. Possible values include: 'Active', 'Disabled', 'Restoring',
     'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming',
     'Unknown'
    :type status: str or ~azure.mgmt.eventhub.v2015_08_01.models.EntityStatus
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'partition_ids': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'properties.messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'properties.partitionCount', 'type': 'long'},
        'partition_ids': {'key': 'properties.partitionIds', 'type': '[str]'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(EventHubResource, self).__init__(**kwargs)
        self.created_at = None
        self.message_retention_in_days = kwargs.get('message_retention_in_days', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.partition_ids = None
        self.status = kwargs.get('status', None)
        self.updated_at = None


class NamespaceCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Namespace operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Namespace location.
    :type location: str
    :param sku:
    :type sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
    :param tags: Namespace tags.
    :type tags: dict[str, str]
    :param status: State of the Namespace. Possible values include: 'Unknown',
     'Creating', 'Created', 'Activating', 'Enabling', 'Active', 'Disabling',
     'Disabled', 'SoftDeleting', 'SoftDeleted', 'Removing', 'Removed', 'Failed'
    :type status: str or
     ~azure.mgmt.eventhub.v2015_08_01.models.NamespaceState
    :param provisioning_state: Provisioning state of the Namespace.
    :type provisioning_state: str
    :param created_at: The time the Namespace was created.
    :type created_at: datetime
    :param updated_at: The time the Namespace was updated.
    :type updated_at: datetime
    :param service_bus_endpoint: Endpoint you can use to perform Service Bus
     operations.
    :type service_bus_endpoint: str
    :ivar metric_id: Identifier for Azure Insights metrics
    :vartype metric_id: str
    :param enabled: Specifies whether this instance is enabled.
    :type enabled: bool
    """

    _validation = {
        'location': {'required': True},
        'metric_id': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'NamespaceState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(NamespaceCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.status = kwargs.get('status', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.created_at = kwargs.get('created_at', None)
        self.updated_at = kwargs.get('updated_at', None)
        self.service_bus_endpoint = kwargs.get('service_bus_endpoint', None)
        self.metric_id = None
        self.enabled = kwargs.get('enabled', None)


class TrackedResource(Resource):
    """Definition of Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class NamespaceResource(TrackedResource):
    """Single Namespace item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param sku:
    :type sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
    :param status: State of the Namespace. Possible values include: 'Unknown',
     'Creating', 'Created', 'Activating', 'Enabling', 'Active', 'Disabling',
     'Disabled', 'SoftDeleting', 'SoftDeleted', 'Removing', 'Removed', 'Failed'
    :type status: str or
     ~azure.mgmt.eventhub.v2015_08_01.models.NamespaceState
    :param provisioning_state: Provisioning state of the Namespace.
    :type provisioning_state: str
    :param created_at: The time the Namespace was created.
    :type created_at: datetime
    :param updated_at: The time the Namespace was updated.
    :type updated_at: datetime
    :param service_bus_endpoint: Endpoint you can use to perform Service Bus
     operations.
    :type service_bus_endpoint: str
    :ivar metric_id: Identifier for Azure Insights metrics
    :vartype metric_id: str
    :param enabled: Specifies whether this instance is enabled.
    :type enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'metric_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'status': {'key': 'properties.status', 'type': 'NamespaceState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(NamespaceResource, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.status = kwargs.get('status', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.created_at = kwargs.get('created_at', None)
        self.updated_at = kwargs.get('updated_at', None)
        self.service_bus_endpoint = kwargs.get('service_bus_endpoint', None)
        self.metric_id = None
        self.enabled = kwargs.get('enabled', None)


class NamespaceUpdateParameter(Model):
    """Parameters supplied to the Patch/update Namespace operation.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param sku: The sku of the created Namespace
    :type sku: ~azure.mgmt.eventhub.v2015_08_01.models.Sku
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(self, **kwargs):
        super(NamespaceUpdateParameter, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs.get('sku', None)


class Operation(Model):
    """A Event Hub REST API operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.eventhub.v2015_08_01.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: Service provider: Microsoft.EventHub
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Invoice,
     etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class RegenerateKeysParameters(Model):
    """Parameters supplied to the Regenerate Authorization Rule keys operation.

    :param policykey: Key that needs to be regenerated. Possible values
     include: 'PrimaryKey', 'SecondaryKey'
    :type policykey: str or ~azure.mgmt.eventhub.v2015_08_01.models.Policykey
    """

    _attribute_map = {
        'policykey': {'key': 'policykey', 'type': 'Policykey'},
    }

    def __init__(self, **kwargs):
        super(RegenerateKeysParameters, self).__init__(**kwargs)
        self.policykey = kwargs.get('policykey', None)


class ResourceListKeys(Model):
    """Namespace/EventHub Connection String.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar primary_connection_string: Primary connection string of the created
     Namespace AuthorizationRule.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: Secondary connection string of the
     created Namespace AuthorizationRule.
    :vartype secondary_connection_string: str
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and
     validating the SAS token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and
     validating the SAS token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the AuthorizationRule.
    :vartype key_name: str
    """

    _validation = {
        'primary_connection_string': {'readonly': True},
        'secondary_connection_string': {'readonly': True},
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
        'key_name': {'readonly': True},
    }

    _attribute_map = {
        'primary_connection_string': {'key': 'primaryConnectionString', 'type': 'str'},
        'secondary_connection_string': {'key': 'secondaryConnectionString', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceListKeys, self).__init__(**kwargs)
        self.primary_connection_string = None
        self.secondary_connection_string = None
        self.primary_key = None
        self.secondary_key = None
        self.key_name = None


class SharedAccessAuthorizationRuleCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Authorization Rules operation.

    All required parameters must be populated in order to send to Azure.

    :param location: Data center location.
    :type location: str
    :param name: Name of the AuthorizationRule.
    :type name: str
    :param rights: Required. The rights associated with the rule.
    :type rights: list[str or
     ~azure.mgmt.eventhub.v2015_08_01.models.AccessRights]
    """

    _validation = {
        'rights': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[AccessRights]'},
    }

    def __init__(self, **kwargs):
        super(SharedAccessAuthorizationRuleCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.name = kwargs.get('name', None)
        self.rights = kwargs.get('rights', None)


class SharedAccessAuthorizationRuleResource(Resource):
    """Single item in a List or Get AuthorizationRule operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :param location: Resource location
    :type location: str
    :ivar type: Resource type
    :vartype type: str
    :param rights: Required. The rights associated with the rule.
    :type rights: list[str or
     ~azure.mgmt.eventhub.v2015_08_01.models.AccessRights]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'rights': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[AccessRights]'},
    }

    def __init__(self, **kwargs):
        super(SharedAccessAuthorizationRuleResource, self).__init__(**kwargs)
        self.rights = kwargs.get('rights', None)


class Sku(Model):
    """SKU parameters supplied to the create Namespace operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of this SKU. Possible values include: 'Basic',
     'Standard'
    :type name: str or ~azure.mgmt.eventhub.v2015_08_01.models.SkuName
    :param tier: Required. The billing tier of this particular SKU. Possible
     values include: 'Basic', 'Standard', 'Premium'
    :type tier: str or ~azure.mgmt.eventhub.v2015_08_01.models.SkuTier
    :param capacity: The Event Hubs throughput units.
    :type capacity: int
    """

    _validation = {
        'tier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)
