/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.MasterReport;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.Severity;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.outWriter;

public class DefaultReportImpl
extends MasterReport {
    static boolean DEBUG = false;
    boolean quiet;
    boolean saveQuiet;
    public static String ePubVersion;

    public DefaultReportImpl(String ePubName) {
        this(ePubName, null, false);
    }

    public DefaultReportImpl(String ePubName, String info, boolean quiet) {
        this.quiet = quiet;
        String adjustedPath = PathUtil.removeWorkingDirectory(ePubName);
        this.setEpubFileName(adjustedPath);
        if (info != null) {
            // empty if block
        }
    }

    String fixMessage(String message) {
        if (message == null) {
            return "";
        }
        return message.replaceAll("[\\s]+", " ");
    }

    boolean pushQuiet() {
        this.saveQuiet = outWriter.isQuiet();
        outWriter.setQuiet(this.quiet);
        return this.saveQuiet;
    }

    void popQuiet() {
        outWriter.setQuiet(this.saveQuiet);
    }

    @Override
    public void message(Message message, EPUBLocation location, Object ... args) {
        Severity severity = message.getSeverity();
        String text = this.formatMessage(message, location, args);
        if (severity.equals((Object)Severity.USAGE)) {
            this.pushQuiet();
            outWriter.println(text);
            this.popQuiet();
        } else {
            System.err.println(text);
        }
    }

    String formatMessage(Message message, EPUBLocation location, Object ... args) {
        String fileName = location.getPath() == null ? "" : "/" + location.getPath();
        fileName = PathUtil.removeWorkingDirectory(fileName);
        return String.format("%1$s(%2$s): %3$s%4$s(%5$s,%6$s): %7$s", new Object[]{message.getSeverity(), message.getID(), PathUtil.removeWorkingDirectory(this.getEpubFileName()), fileName, location.getLine(), location.getColumn(), this.fixMessage(args != null && args.length > 0 ? message.getMessage(args) : message.getMessage())});
    }

    @Override
    public void info(String resource, FeatureEnum feature, String value) {
        if (2 >= this.getReportingLevel()) {
            switch (feature) {
                case FORMAT_VERSION: {
                    if (this.quiet) break;
                    outWriter.println(String.format(Messages.get("validating_version_message"), value));
                    break;
                }
                default: {
                    if (!DEBUG || this.quiet) break;
                    if (resource == null) {
                        outWriter.println("INFO: [" + (Object)((Object)feature) + "]=" + value);
                        break;
                    }
                    outWriter.println("INFO: [" + (Object)((Object)feature) + " (" + resource + ")]=" + value);
                }
            }
        }
    }

    @Override
    public int generate() {
        return 0;
    }

    @Override
    public void initialize() {
    }
}

